/**
 * @author sumit.meena
 */
Ext.define('Academia.view.transport.route.RouteSearch', {
	extend: 'Ext.form.Panel',
	alias: 'widget.routesearch',
	autoScroll: false,
	frame: false,
	border:false,
	plugins : "formlabelrequired",
	cls:'customSearchPanel',
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('ROUTE_NAME'),
			name: 'routeName',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			store: 'transport.route.RouteName',
			valueField: 'id',
			displayField: 'value',
			queryParam:'routeName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			forceSelection:true,
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('STOP_LOCATION'),
			name: 'stop',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			store: 'transport.route.RouteStops',
			valueField: 'id',
			displayField: 'value',
			queryParam:'routeStopsName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			forceSelection:true,
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('ROUND_TRIP'),
			name: 'roundTripId',
			store: 'examinationcenters.YesNo',
			itemId:'roundTripItemId',
			displayField: 'value',
			valueField: 'id',
			forceSelection:true
			//allowBlank:false
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('START_LOCATION'),
			name: 'startLocationId',
			store: 'transport.route.AllLocationName',
			itemId:'startLocationItemId',
			displayField: 'locationName',
			valueField: 'id',
			forceSelection:true
		},{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('END_LOCATION'),
			name: 'endLocationId',
			store: 'transport.route.AllLocationName',
			displayField: 'locationName',
			valueField: 'id',
			forceSelection:true
		},{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('RESPONSIBLE_PERSON'),
			name: 'responsiblePersonRoute',
			//itemId:'vehicleNo',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			store: 'transport.route.ResponsiblePerson',
			valueField: 'id',
			displayField: 'value',
			queryParam:'responsiblePersonName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			forceSelection:true,
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'numberfield',
			fieldLabel: getTransportTranslation('DISTANCE_FROM'),
			name: 'distanceFrom',
			itemId:'distanceFromId',
			minValue : 0,
			hideTrigger:true,
			allowDecimals:false,
			allowExponential :false,
			validator : function(val) {
				var maxValuefield = Ext.ComponentQuery.query('numberfield#distanceToId')[0];
				var maxValue = maxValuefield.getValue();
				if(!isNullOrEmpty(val)){
					if (!isNullOrEmpty(maxValue)) {
						 if(val>maxValue){
							 return false;
						 }
						 else if (val < maxValue) {
	       				  maxValuefield.clearInvalid();
	       				  return true;
	       			  } else {
	       				return getCommonTranslation('LESS_THAN_MAX_VALUE');
	       			  }
	       		  } else {
	       			return getCommonTranslation('LESS_THAN_MAX_VALUE');
	       		  }
				}else{
					maxValuefield.clearInvalid();
	       			  return true;
				}
			}
		},{
			xtype: 'numberfield',
			name:'distanceTo',
			itemId:'distanceToId',
			fieldLabel:getTransportTranslation('DISTANCE_TO'),
			minValue : 0,
			allowExponential :false,
			hideTrigger:true,
			validator : function(val) {
				var minValueField =Ext.ComponentQuery.query('numberfield#distanceFromId')[0];
				var minValue = minValueField.getValue();
				if(!isNullOrEmpty(val)){
				if (!isNullOrEmpty(minValue)) {
					if(val < minValue){
						return false;
					}
					else if (val > minValue) {
						minValueField.clearInvalid();
						minValueField.validate();
						return true;
					} else {
						return getCommonTranslation('MORE_THAN_MIN_VALUE');
					}
				 }else {
					 return getCommonTranslation('MORE_THAN_MIN_VALUE');
				}
				}else{
					minValueField.clearInvalid();
					return true;
				}
			}
		}]

	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getTransportTranslation('SEARCH'),
			formBind: true,
			itemId: 'SearchBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getTransportTranslation('RESET'),
			itemId: 'cancelBtn',	
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
			/*handler: function() {
				this.up('form').getForm().reset();
				this.up('form').isValid();
			}*/
		}]
	}]
});