/**
 * @author Deepak Sharma
 */

Ext.define('Academia.view.transport.serviceRoute.AssignDriverDetailWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.assigndriverdetailwindow',
	title: getTransportTranslation('TRANS_DRIVER_DETAIL'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	layout: {
		type: 'vbox'
	},
	items: [{
		xtype: 'form',
		itemId:'assigndriverdetailwindowId',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				fieldLabel: getTransportTranslation('TRANS_DRIVER_NAME'),
				name: 'driverId',
				itemId:'driverId',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				store: 'transport.route.ServiceRouteUserByUserType',
				valueField: 'id',
				displayField: 'value',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				allowBlank: false,
				forceSelection:true,
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				hidden:false,
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +'</div>';
					}
				}
			},{	
				xtype:'textfield',
				name:'licenseNumber',
				itemId:'licenseNumberId',
				fieldLabel: getTransportTranslation('TRANS_LICENCE_NO')
			}]
		},{
			xtype:'fieldcontainer',
			labelSeparator : ':',
			fieldLabel: getTransportTranslation('TRANS_DRIVER_CONTACT_NO'),
			itemId:'driverMobileCoutryCodeContainer',
			layout:'hbox',
			labelAlign:'top',
			items:[{
				xtype: 'customcombobox',
				valueField: 'isdCode',
				displayField: 'isdCode',
				store: Ext.create('Academia.store.common.CountryStore'),
				itemId:'driverMobileCountryCode',
				triggerAction: 'all',
				name: 'driverMobileCountryCode',
				width: 80,
				forceSelection:true,
				emptyText: 'Code', 
				minChars: 1
			},{
				xtype: 'numberfield',
				name:'driverMobileNumber',
				itemId:'driverMobileNumber',
				minLength: 6,
				maxLength: 11,
				spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
				enforceMaxLength : true,
				width:150
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				fieldLabel: getTransportTranslation('TRANS_CONDUCTOR_NAME'),
				name: 'conductorId',
				itemId:'conductorId',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				store: 'transport.route.ServiceRouteUserByUserType',
				valueField: 'id',
				displayField: 'value',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				hidden:false,
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +'</div>';
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			labelSeparator : ':',
			fieldLabel: getTransportTranslation('TRANS_CONDUCTOR_CONTACT_NO'),
			itemId:'conductorMobileCoutryCodeContainer',
			layout:'hbox',
			labelAlign:'top',
			items:[{
				xtype: 'customcombobox',
				valueField: 'isdCode',
				displayField: 'isdCode',
				store: Ext.create('Academia.store.common.CountryStore'),
				itemId:'conductorMobileCountryCode',
				triggerAction: 'all',
				name: 'conductorMobileCountryCode',
				width: 80,
				forceSelection:true,
				emptyText: 'Code', 
				minChars: 1
			},{
				xtype: 'numberfield',
				name:'conductorMobileNumber',
				itemId:'conductorMobileNumber',
				minLength: 6,
				maxLength: 11,
				spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
				enforceMaxLength : true,
				width:150
			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});