/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.transport.serviceRoute.DateExceptionGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.dateexceptiongrid',
	store : 'transport.serviceRoute.DateExceptionGrid',
	title: getTransportTranslation('DATE_EXCEPTION_LIST'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'transport.serviceRoute.DateExceptionGrid',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getTransportTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getTransportTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getTransportTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getTransportTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getTransportTranslation('DATE'),
		dataIndex : 'exceptionDate',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('ORIGINAL_STATUS'),
		dataIndex : 'originalStatus',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)) {
				if(value=='SCHEDULED'){
					return getCommonTranslation('SCHEDULED');
				}else{
					return getCommonTranslation('NOT_SCHEDULED');
				}
			}
		}
	},{
		header : getTransportTranslation('REVISED_STATUS'),
		dataIndex : 'revisedStatus',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)) {
				if(value=='SCHEDULED'){
					return getCommonTranslation('SCHEDULED');
				}else{
					return getCommonTranslation('NOT_SCHEDULED');
				}
			}
		}
	},{
		header : getTransportTranslation('REMARKS'),
		dataIndex : 'description',
		flex:1
	}]
});