/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.transport.serviceRoute.DateExceptionWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.dateexceptionwindow',
	title: getTransportTranslation('DATE_EXCEPTION'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	layout: {
		type: 'vbox'
	},
	items: [{
		xtype: 'form',
		itemId:'dateexceptionwindow',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype: 'datefield',
			name: 'exceptionDate',
			itemId:'exceptionDate',
			allowBlank:false,
			fieldLabel: getTransportTranslation('DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.DATE_FORMAT
		},{
			xtype: 'customcombobox',
			name: 'originalStatus',
			itemId:'originalStatus',
			allowBlank:false,
			fieldLabel: getTransportTranslation('ORIGINAL_STATUS'),
			store: 'transport.serviceRoute.VehicleStatus',
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'revisedStatus',
			itemId:'revisedStatus',
			allowBlank:false,
			queryMode:'local',
			fieldLabel: getTransportTranslation('REVISED_STATUS'),
			store: 'transport.serviceRoute.RevisedVehicleStatusStore',
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'textarea',
			name: 'description',
			itemId:'description',
			fieldLabel: getTransportTranslation('REMARKS')
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});
