/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.transport.serviceRoute.ServiceRouteMasterGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.serviceroutemastergrid',
	store : 'transport.serviceRoute.ServiceRouteMasterGrid',
	title: getTransportTranslation('SERVICE_ROUTE_LIST'),
	border: true,
	selType: 'checkboxmodel',
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'serviceroutestructure':1
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	/*selModel: {
        showHeaderCheckbox: true,
        checkOnly: true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
        allowDeselect: false
    },*/
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'transport.serviceRoute.ServiceRouteMasterGrid',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getTransportTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getTransportTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getTransportTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getTransportTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}, {
		xtype: 'splitbutton',
		itemId: 'btnRouteStoppageReportItemId',
		tooltip: getTransportTranslation('ROUTE_STOPPAGE_REPORT'),
		text: getTransportTranslation('ROUTE_STOPPAGE_REPORT'),
		menu: [{
			text: 'PDF',
			itemId: 'PDFRouteStoppageReportItemId'
		}, {
			text: 'EXCEL',
			itemId: 'ExcelRouteStoppageReportItemId'
		}],
		listeners: {
			click: function() {
				this.showMenu();
			}
		}
	}],
	columns: [{
		header : getTransportTranslation('SERVICE_ROUTE_NAME'),
		dataIndex : 'serviceName',
		flex:1
	},{
		header : getTransportTranslation('ROUTE_NAME'),
		dataIndex : 'routeName',
		flex:1
	},{
		header : getTransportTranslation('RESPONSIBLE_PERSON'),
		dataIndex : 'responsiblePersonName',
		flex:1,
		renderer: function(value, metaData, record, row, col, store, gridView) {
			if(!isNullOrEmpty(record.get("responsiblePerson"))) {
				return record.get("responsiblePerson").value;
			}else{
				return value;
			}
		}
	},{
		header : getTransportTranslation('START_LOCATION'),
		dataIndex : 'startLocation',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)) {
				return value.locationName;
			}
		}
	},{
		header : getTransportTranslation('START_TIME'),
		dataIndex : 'startTime',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)) {
				return timeRender(value);
			}
		}
	},{
		header : getTransportTranslation('END_LOCATION'),
		dataIndex : 'endLocation',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)) {
				return value.locationName;
			}
		}
	},{
		header : getTransportTranslation('END_TIME'),
		dataIndex : 'reachTime',
		flex:1,
		renderer: function(time) {
			if(!isNullOrEmpty(time)) {
				return timeRender(time);
			}
		}
	},{
		header : getTransportTranslation('DISTANCE'),
		dataIndex : 'distance',
		flex:1
	},{
		header : getTransportTranslation('NO_OF_VEHICLES'),
		dataIndex : 'noOfVehicles',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getTransportTranslation('VEHICLE_NUMBER'),
		dataIndex : 'vehicleNumber',
		flex:1
	},{
		header : getTransportTranslation('NO_OF_USERS_COVERED'),
		dataIndex : 'noOfUsersCovered',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getTransportTranslation('CAPACITY'),
		dataIndex : 'capacity',
		flex:1
	},
	{
		header : getTransportTranslation('VEHICLE_TYPE'),
		dataIndex : 'vehicleType',
		flex:1
	},
	{
		header : getTransportTranslation('TRANSPORT_PROVIDER_NAME'),
		dataIndex : 'transportProviderName',
		flex:1
	}]
});