/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.transport.serviceRoute.ServiceRouteSearch', {
	extend: 'Ext.form.Panel',
	alias: 'widget.serviceroutesearch',
	autoScroll: false,
	frame: false,
	border:false,
	plugins : "formlabelrequired",
	cls:'customSearchPanel',
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			xtype: 'textfield',
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'vehicleName',
			itemId:'vehicleName',
			fieldLabel: getTransportTranslation('VEHICLE_NO'),
			store: 'transport.vehicle.VehicleNo',
			valueField: 'id',
			displayField: 'value',
			queryParam:'vehicleNumber',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'serviceName',
			itemId:'serviceName',
			store: 'transport.serviceRoute.ServiceRouteName',
			fieldLabel: getTransportTranslation('SERVICE_ROUTE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'serviceName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			//allowBlank:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			
			xtype: 'customcombobox',
			name:'responsiblePersonName',
			itemId:'responsiblePersonName',
			store:'transport.serviceRoute.ServiceRouteResponsableName',
			fieldLabel: getTransportTranslation('RESPONSIBLE_PERSON'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'responsiblePersonName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			//allowBlank:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			
			xtype: 'customcombobox',
			name: 'routeName',
			itemId: 'routeName',
			fieldLabel: getTransportTranslation('ROUTE_NAME'),
			store: 'transport.route.RouteName',
			valueField: 'id',
			displayField: 'value',
			queryParam:'routeName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('START_LOCATION'),
			name: 'startLocationId',
			store: 'transport.route.LocationName',
			itemId:'startLocationItemId',
			displayField: 'locationName',
			valueField: 'id',
			forceSelection:true
		},{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('END_LOCATION'),
			name: 'endLocationId',
			store: 'transport.route.LocationName',
			displayField: 'locationName',
			valueField: 'id',
			forceSelection:true
		}]
	},
	{
	    xtype: 'fieldcontainer',
	    layout: 'hbox',
	    width: '100%',
	    defaults: {
	        labelAlign: 'top',
	        width:256
	    },
	    items: [{
	        xtype: 'customcombobox',
	        fieldLabel: getTransportTranslation('VEHICLE_TYPE'),
	        name: 'subType',
	        store: 'transport.vehicle.VehicleSubType',
	        itemId:'subType',
	        displayField: 'value',
	        valueField: 'id',
	        forceSelection:true
	       // columnWidth: 1
	    },{
	        xtype: 'customcombobox',
	        fieldLabel: getTransportTranslation('TRANSPORT_PROVIDER_NAME'),
	        name: 'transportProviderName',
	        itemId:'transportProviderName',
	        store: 'transport.route.TransportProviderStore',
	        displayField: 'value',
	        valueField: 'id',
	        forceSelection:true
	        //columnWidth: 1
	    }]
	},{
		xtype:'fieldset',
		title:getTransportTranslation('MORE_FILTERS'),
		//layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		width:'100%',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'numberfield',
				hideTrigger:true,
				mouseWheelEnabled:false,
				allowDecimals:true,
				allowExponential:false
			},
			items: [{
				fieldLabel: getTransportTranslation('DISTANCE_GREATER'),
				name: 'distanceGreater',
				itemId:'distanceGreater'
			},{
				fieldLabel: getTransportTranslation('DISTANCE_LESS'),
				name: 'distanceSmaller',
				itemId:'distanceSmaller'
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype : 'timefield',
				format:'g:i A'
			},
			items: [{
				fieldLabel: getTransportTranslation('START_TIME_GREATER'),
				name: 'startTimeGreater',
				itemId:'startTimeGreater'
			},{
				fieldLabel: getTransportTranslation('START_TIME_LESS'),
				name: 'startTimeSmaller',
				itemId:'startTimeSmaller'
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype : 'timefield',
				format:'g:i A'
			},
			items: [{
				fieldLabel: getTransportTranslation('REACH_TIME_GREATER'),
				name: 'reachTimeGreater',
				itemId:'reachTimeGreater'
			},{
				fieldLabel: getTransportTranslation('REACH_TIME_LESS'),
				name: 'reachTimeSmaller',
				itemId:'reachTimeSmaller'
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'numberfield',
				hideTrigger:true,
				mouseWheelEnabled:false,
				allowDecimals:false,
				allowExponential:false
			},
			items: [{
				fieldLabel: getTransportTranslation('CAPACITY_PLAN_FROM'),
				hidden:true,
				name: 'MinCapacity',
				itemId:'MinCapacity'
			},{
				fieldLabel: getTransportTranslation('CAPACITY_PLAN_TILL'),
				name: 'MaxCapacity',
				hidden:true,
				itemId:'MaxCapacity'
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'datefield',
				name: 'periodFrom',
				itemId:'periodFromItemId',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				vtype: 'daterange',
				endDateField: 'periodTill',
				editable:false,
				fieldLabel:getTransportTranslation('DATE_FROM')
			},{
				xtype: 'datefield',
				name: 'dateTill',
				itemId:'periodTill',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				vtype: 'daterange',
				startDateField: 'periodFromItemId',
				editable:false,
				fieldLabel:getTransportTranslation('DATE_TILL')
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getTransportTranslation('SEARCH'),
			formBind: true,
			itemId: 'SearchBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getTransportTranslation('RESET'),
			itemId: 'cancelBtn',	
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			handler: function() {
				this.up('form').getForm().reset();
			}
		}]
	}]
});
