/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.transport.serviceRoute.VehicleServiceRouteLinkGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.vehicleserviceroutelinkgrid',
	store : 'transport.serviceRoute.ServiceRouteForVehicle',
	title: getTransportTranslation('VEHICLE_LINKED_LIST'),
	border: true,
	reserveScrollbar:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'transport.serviceRoute.ServiceRouteForVehicle',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getTransportTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getTransportTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getTransportTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getTransportTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getTransportTranslation('ASSIGN_DRIVER'),
			itemId:'assignServiceRouteDriverDetail'
		}],
		listeners: { click: function() { this.showMenu(); }}
	}],
	columns: [{
		header : getTransportTranslation('VEHICLE_CODE'),
		dataIndex : 'vehicle',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)) {
				return value.resourceCode;
			}
		}
	},{
		header : getTransportTranslation('VEHICLE_NO'),
		dataIndex : 'vehicle',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)) {
				return value.vehicleNumber;
			}
		}
	},{
		header : getTransportTranslation('IS_ACTIVE'),
		dataIndex : 'whetherActive',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)) {
				if(value==true){
					return getTransportTranslation('YES');
				}else{
					return getTransportTranslation('NO');
				}
			}
		}
	},{
		header : getTransportTranslation('TRANS_DRIVER_NAME'),
		dataIndex : 'driverId',
		flex:1,
		renderer: function(value, metadata,record,rowIndex,colIndex,store,view) {
			var driverDetail = record.get('transServiceRouteDriverDetail');
			if(!isNullOrEmpty(driverDetail) && !isNullOrEmpty(driverDetail.driverId)) {
				return driverDetail.driverId.value;
			}
			else{
				return '';
			}
		}
	},{
		header : getTransportTranslation('TRANS_LICENCE_NO'),
		dataIndex : 'licenseNumber',
		flex:1,
		hidden: true,
		renderer: function(value, metadata,record,rowIndex,colIndex,store,view) {
			var driverDetail = record.get('transServiceRouteDriverDetail');
			if(!isNullOrEmpty(driverDetail) && !isNullOrEmpty(driverDetail.licenseNumber)) {
				return driverDetail.licenseNumber;
			}
			else{
				return '';
			}
		}
	},{
		header : getTransportTranslation('TRANS_DRIVER_CONTACT_NO'),
		dataIndex : 'driverMobileNumber',
		flex:1,
		renderer: function(value, metadata,record,rowIndex,colIndex,store,view) {
			var driverDetail = record.get('transServiceRouteDriverDetail');
			var mergeValue = '';
			if(!isNullOrEmpty(driverDetail)) {
				if (!isNullOrEmpty(driverDetail.driverMobileCountryCode)) {
					if (!isNullOrEmpty(driverDetail.driverMobileNumber)) {
						mergeValue = driverDetail.driverMobileCountryCode + "-" + driverDetail.driverMobileNumber;
					} else {
						mergeValue = driverDetail.driverMobileCountryCode;
					}
				} else if (!isNullOrEmpty(driverDetail.driverMobileNumber)) {
					mergeValue = driverDetail.driverMobileNumber;
				}
				return mergeValue;
			}
			else{
				return '';
			}
		}
	},{
		header : getTransportTranslation('TRANS_CONDUCTOR_NAME'),
		dataIndex : 'conductorId',
		flex:1,
		renderer: function(value, metadata,record,rowIndex,colIndex,store,view) {
			var driverDetail = record.get('transServiceRouteDriverDetail');
			if(!isNullOrEmpty(driverDetail) && !isNullOrEmpty(driverDetail.conductorId)) {
				return driverDetail.conductorId.value;
			}
			else{
				return '';
			}
		}
	},{
		header : getTransportTranslation('TRANS_CONDUCTOR_CONTACT_NO'),
		dataIndex : 'conductorMobileNumber',
		flex:1,
		renderer: function(value, metadata,record,rowIndex,colIndex,store,view) {
			var driverDetail = record.get('transServiceRouteDriverDetail');
			var mergeValue = '';
			if(!isNullOrEmpty(driverDetail)) {
				if (!isNullOrEmpty(driverDetail.conductorMobileCountryCode)) {
					if (!isNullOrEmpty(driverDetail.conductorMobileNumber)) {
						mergeValue = driverDetail.conductorMobileCountryCode + "-" + driverDetail.conductorMobileNumber;
					} else {
						mergeValue = driverDetail.conductorMobileCountryCode;
					}
				} else if (!isNullOrEmpty(driverDetail.conductorMobileNumber)) {
					mergeValue = driverDetail.conductorMobileNumber;
				}
				return mergeValue;
			}
			else{
				return '';
			}
		}
	}]
});