/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.transport.serviceRoute.VehicleServiceRouteLinkWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.vehicleserviceroutelinkwindow',
	title: getTransportTranslation('VEHICLE_LINKED'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	layout: {
		type: 'vbox'
	},
	items: [{
		xtype: 'form',
		itemId:'vehicleserviceroutelinkwindowId',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'hidden',
			itemId:'transServiceRouteDriverDetailId',
			name:'transServiceRouteDriverDetail'
		},{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('VEHICLE_NO'),
			name: 'vehicleNo',
			itemId:'vehicleNo',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			store: 'transport.vehicle.VehicleNo',
			valueField: 'id',
			displayField: 'value',
			queryParam:'vehicleNumber',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			forceSelection:true,
			minChars:3,
			allowBlank: false,
			typeAhead:false,
			hideTrigger:false,
			triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{vehicleNumber}' +'</div>';
				}
			}
		},{
			xtype: 'textfield',
			name: 'resourceCode',
			itemId:'resourceCode',
			readOnly:true,
			fieldLabel: getTransportTranslation('VEHICLE_CODE')
		},{
			xtype: 'customcombobox',
			name:'isActive',
			itemId:'isActive',
			store:'transport.vehicle.VehicleYesNoEnum',
			fieldLabel: getTransportTranslation('IS_ACTIVE'),
			displayField : 'value',
			valueField : 'id',
			allowBlank: false,
			editable: false
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});