/**
 *  @author Rajkumar.patidar
 */

Ext.define('Academia.view.transport.vehicle.EmissionHistoryList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.emissionhistorylist',
	store : 'transport.vehicle.EmissionHistoryGridData',
	title: getTransportTranslation('EMISSION_DETAILS'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'transport.vehicle.EmissionHistoryGridData',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getTransportTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getTransportTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getTransportTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getTransportTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getTransportTranslation('TRANSPORT_ADD_ADDRESS'),
			itemId:'addAddressEmissionPolicy'
		},{
			text:getCommonTranslation('UPLOAD_DOCUMENT'),
			itemId:'uploadEmissionPolicyDocumentLink'
		}/*,{
			text:getTransportTranslation('VIEW_EMISSION_POLICY_DOCUMENT'),
			itemId:'viewEmissionPolicyDocumentLink'
		}*/],
		listeners: { click: function() { this.showMenu(); }}
	}],
	columns: [{
		header: getTransportTranslation('EMISSION_VENDER'), // Pollution Control Center Name 
		dataIndex : 'emissionVendor',
		flex:1,
	},{
		header : getCommonTranslation('ADDRESS'),
		dataIndex : 'addressText',
		hidden : true,
		flex:1
	},{
		header: getTransportTranslation('EMISSION_DOCUMENT_WITH'),  // Pollution Control Authority 
		dataIndex : 'emissionPolicyWith',
		flex:1,
	},{
		header : getTransportTranslation('EMISSION_TO_BE_CHECKED_ON'),
		dataIndex : 'emissionToBeCheckOn',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('EMISSION_CHECKED_ON'),
		dataIndex : 'emissionCheckOn',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('EMISSION_CURRENCY'),
		dataIndex : 'currencyName',
		hidden : true,
		flex:1
	},{
		header : getTransportTranslation('EMISSION_CHECK_COST'),
		dataIndex : 'emissionCost',
		flex:1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header : getCommonTranslation('DOCUMENTS'),
		dataIndex : 'documentCount',
		flex:1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(value>0){
				return  '<a href="#"> ' + value + '</a>';
			}
			else{
				return '-';
			}
		}
	}/*,{
		header : getTransportTranslation('EMISSION_VENDER_ADDRESS'),
		dataIndex : 'addressId',
		flex:1,
		renderer:function(){
			return  '<a href="#">Address</a>';
		}
	}*/]
});