/**
 *  @author Ankur.Jaiswal
 */

Ext.define('Academia.view.transport.vehicle.FuelConsumptionGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.fuelconsumptiongrid',
	store : 'transport.vehicle.FuelConsumptionGridDataStore',
	title: getTransportTranslation('TRANS_FUEL_CONSUMPTION'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'transport.vehicle.FuelConsumptionGridDataStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getTransportTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getTransportTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getTransportTranslation('VIEW'),
		iconCls: 'view-icon'
			},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getTransportTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getTransportTranslation('REFILL_DATE'),
		dataIndex : 'refillDate',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('ODOMETER_READING'),
		dataIndex : 'odometerReading',
		flex:1
	},{
		header : getTransportTranslation('APPROXIMATE_AVAILABLE_FUEL'),
		dataIndex : 'approximateAvailableFuel',
		flex:1
	},{
		header : getTransportTranslation('CURRENT_REFILL'),
		dataIndex : 'currentRefill',
		flex:1
	},{
		header : getTransportTranslation('AMOUNT'),
		dataIndex : 'amount',
		flex:1
	},{
		header : getTransportTranslation('REFILL_BY'),
		dataIndex : 'refillBy',
		flex:1
	},{
		header : getTransportTranslation('REFILL_STATION'),
		dataIndex : 'refillStation',
		flex:1
	},{
		header : getTransportTranslation('FUEL_CONSUMPTION_AVG'),
		dataIndex : 'fuelConsumptionAverage',
		flex:1,
		renderer: function(val) {
			if(!isNullOrEmpty(val)) {
				var num = val.toFixed(2);
				return num;
			}
		}
	}]
});