/**
 *  @author Rajkumar.patidar
 */

Ext.define('Academia.view.transport.vehicle.InsuranceHistoryList', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.insurancehistorylist',
	store : 'transport.vehicle.InsuranceHistoryGridData',
	title: getTransportTranslation('INSURANCE_DETAIL'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'transport.vehicle.InsuranceHistoryGridData',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getTransportTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getTransportTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getTransportTranslation('VIEW'),
		iconCls: 'view-icon'
			},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getTransportTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getTransportTranslation('TRANSPORT_ADD_ADDRESS'),
			itemId:'addAddressInsurancePolicy'
		},{
			text:getCommonTranslation('UPLOAD_DOCUMENT'),
			itemId:'uploadInsurancePolicyDocumentLink'
		}/*,{
			text:getTransportTranslation('VIEW_INSURANCE_POLICY_DOCUMENT'),
			itemId:'viewInsurancePolicyDocumentLink'
		}*/],
		listeners: { click: function() { this.showMenu(); }}
	}],
	columns: [{
		header : getTransportTranslation('INSURED_BY'),
		dataIndex : 'insuranceVendor',
		flex:1
	},{
		header : getCommonTranslation('ADDRESS'),
		dataIndex : 'addressText',
		hidden : true,
		flex:1
	},{
		header : getTransportTranslation('POLICY_HOLDER_NAME'),
		dataIndex : 'policyHolderName',
		flex:1
	},{
		header : getTransportTranslation('POLICY_NUMBER'),
		dataIndex : 'policyNumber',
		flex:1
	},{
		header : getTransportTranslation('INCEPTION_DATE'),
		dataIndex : 'inceptionDate',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('INSURANCE_VALID_FROM'),
		dataIndex : 'validFrom',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('INSURANCE_VALID_TILL'),
		dataIndex : 'validTill',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('PREMIUM_PAYMENT_CYCLE'),
		dataIndex : 'premiumPaymentCycle',
		hidden:true,
		flex:1,
		renderer:function(value){
			if(!isNullOrEmpty(value)) {
				if(value == 'MONTHLY') {
					return 'Monthly';
				}else if(value == 'ANNUAL') {
					return 'Annual';
				}
			} else {
				return value;
			}
		}
	},{
		header : getTransportTranslation('INSURANCE_CURRENCY'),
		dataIndex : 'currencyName',
		hidden:true,
		flex:1
	},{
		header : getTransportTranslation('INSURANCE_COST'),
		dataIndex : 'insuranceCost',
		flex:1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header : getTransportTranslation('INSURANCE_PAID_ON'),
		dataIndex : 'insurancePaidOn',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header: getTransportTranslation('INSURANCE_POLICY_WITH'),
		dataIndex : 'insurancePolicyWith',
		flex:1
	},/*{
		header : getTransportTranslation('INSURANCE_ADDRESS_LINK'),
		dataIndex : 'addressId',
		flex:1,
		renderer:function(){
			return  '<a href="#">Address</a>';
		}
	},*/{
		header : getCommonTranslation('DOCUMENTS'),
		dataIndex : 'documentCount',
		flex:1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(value>0){
				return  '<a href="#"> ' + value + '</a>';
			}
			else{
				return '-';
			}
		}
	}]
});