/**
 *  @author Rajkumar.patidar
 */

Ext.define('Academia.view.transport.vehicle.JourneyAssignmentList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.journeyassignmentlist',
	store : 'transport.vehicle.JourneyAssignment',
	title: getTransportTranslation('JOURNEY_ASSIGNMENT_DETAILS'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'transport.vehicle.JourneyAssignment',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getTransportTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getTransportTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getTransportTranslation('VIEW'),
		iconCls: 'view-icon'
	}],
	columns: [{
		header : getTransportTranslation('DATE'),
		dataIndex : 'dateOfJourney',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('SERVICE_ROUTE_PLANNED'),
		dataIndex : 'transServiceRoute',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)) {
				return value.value;
			}
		}
	},{
		header : getTransportTranslation('ORIGINAL_STATUS'),
		dataIndex : 'assignStatus',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)) {
				if(value=='SCHEDULED'){
					return getCommonTranslation('SCHEDULED');
				}else{
					return getCommonTranslation('NOT_SCHEDULED');
				}
			}
		}
	},{
		header : getTransportTranslation('CURRENT_STATUS'),
		dataIndex : 'completionStatus',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)) {
				if(value=='RAN'){
					return getCommonTranslation('RAN');
				}else if(value=='NOT_RAN'){
					return getCommonTranslation('NOT_RAN');
				}else if(value=='PENDING'){
					return getCommonTranslation('PENDING');
				}
			}
		}
	},{
		header : getTransportTranslation('NO_OF_USERS_SERVICED'),
		dataIndex : 'noOfUsers',
		flex:1,
		renderer:function(value){
			if(value>0) {
			 return  '<a href="#">'+value+'</a>';
			}else{
				return 0;
			}
		}
	}]
});