/**
 * @author Rajkumar.Patidar 
 */
Ext.define('Academia.view.transport.vehicle.NumberOfUserCoveredGridWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.numberofusercoveredgridwindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	height: '50%',
	width: '70%',
	title:getTransportTranslation('NO_OF_USERS_SERVICED'),
	items: [{
		xtype: 'grid',
		store : 'transport.vehicle.JourneyAssignmentUserCount',
		frame: false,
		border:true,
		autoScroll: false,
		selType:'checkboxmodel',
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'transport.vehicle.JourneyAssignmentUserCount',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		tbar: [{
			xtype: 'button',
			itemId: 'btnAdd',
			text:getFeeAndPaymentCommonTranslation('SAVE'),
			tooltip: getFeeAndPaymentCommonTranslation('SAVE')
		}],
		columns: [{
			header : getTransportTranslation('USER'),
			dataIndex : 'serviceRouteUserValue',
			flex:1,
			sortable: true,
			renderer: function(value, metaData, record, row, col, store, gridView) {
				if(!isNullOrEmpty(value)) {
					return value;
				}
			}
		},{
			header : getTransportTranslation('ATTENDANCE'),
			dataIndex : 'attendance',
			flex:1,
			sortable: true,
			editor : {
				 xtype: 'customcombobox',
				 itemId:'attendance',
				 name:'attendance',
				 store:'transport.vehicle.PresentAbsentEnum',
				 valueField : 'id',
				 displayField : 'value',
				 typeAhead:false,
				 forceSelection:true
			 },
			 renderer:function(value){
				 if(!isNullOrEmpty(value)) {
					 if(value=='PRESENT'){
						 return getCommonTranslation('PRESENT');
					 }else{
						 return getCommonTranslation('ABSENT');  
					 }
				 }
			 }
		}],
		plugins: [{
			ptype : 'cellediting',
			clicksToEdit: 1
		}]
	}]
});
