/**
 *  @author Rajkumar.patidar
 */

Ext.define('Academia.view.transport.vehicle.RoadTaxHistoryList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.roadtaxhistorylist',
	store : 'transport.vehicle.RoadTaxHistoryGridData',
	title: getTransportTranslation('ROAD_TAX_DETAIL'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'transport.vehicle.RoadTaxHistoryGridData',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getTransportTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getTransportTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getTransportTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getTransportTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getTransportTranslation('TRANSPORT_ADD_ADDRESS'),
			itemId:'addAddressRoadTaxPolicy'
		},{
			text:getCommonTranslation('UPLOAD_DOCUMENT'),
			itemId:'uploadRoadTaxPolicyDocumentLink'
		}/*,{
			text:getTransportTranslation('VIEW_ROAD_TAX_POLICY_DOCUMENT'),
			itemId:'viewRoadTaxPolicyDocumentLink'
		}*/],
		listeners: { click: function() { this.showMenu(); }}
	}],
	columns: [{
		header : getTransportTranslation('ROAD_TAX_AUTHORITY'),
		dataIndex : 'roadTaxVendor',
		flex:1
	},{
		header : getCommonTranslation('ADDRESS'),
		dataIndex : 'addressText',
		hidden : true,
		flex:1
	},{
		header: getTransportTranslation('ROAD_TAX_DOCUMENT_WITH'), //Road Tax Agent 
		dataIndex : 'roadTaxWith',
		flex:1
	},{
		header : getTransportTranslation('ROAD_TAX_VALID_FROM'),
		dataIndex : 'validFrom',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('ROAD_TAX_VALID_TILL'),
		dataIndex : 'validTill',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('ROAD_TAX_CURRENCY'),
		dataIndex : 'currencyName',
		hidden : true,
		flex:1
	},{
		header : getTransportTranslation('ROAD_TAX_COST'),
		dataIndex : 'roadTaxCost',
		flex:1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header : getTransportTranslation('ROAD_TAX_PAID_ON'),
		dataIndex : 'roadTaxPaidOn',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getCommonTranslation('DOCUMENTS'),
		dataIndex : 'documentCount',
		flex:1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(value>0){
				return  '<a href="#"> ' + value + '</a>';
			}
			else{
				return '-';
			}
		}
	}/*,{
		header : getTransportTranslation('ROAD_TAX_AUTHORITY_ADDRESS'),
		dataIndex : 'addressId',
		flex:1,
		renderer:function(){
			return  '<a href="#">Address</a>';
		}
	}*/]
});