/**
 */

Ext.define('Academia.view.transport.vehicle.ServiceHistoryDetailWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.servicehistorydetailwin',
	title: getTransportTranslation('SERVICE_HISTORY_DETAILS'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'servicehistorydetailwinId',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name: 'serviceDate',
				itemId:'serviceDateId',
				fieldLabel: getTransportTranslation('DATE'),
				vtype: 'daterange',
				allowBlank: false,
				maxValue: new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
			},{
				xtype: 'textfield',
				name:'servicedBy',
				itemId:'servicedBy',
				fieldLabel: getTransportTranslation('SERVICED_BY'),
				//maxLength: 5,
				spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
				//allowBlank: false,
				enforceMaxLength : true,
				minValue:0
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'numberfield',
				name:'odometerReading',
				itemId:'odometerReading',
				fieldLabel: getTransportTranslation('ODOMETER_READING'),
				maxLength: 5,
				spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
				//allowBlank: false,
				enforceMaxLength : true,
				minValue:0
			},{
				xtype: 'numberfield',
				name:'amount',
				itemId:'amount',
				fieldLabel: getTransportTranslation('AMOUNT'),
				maxLength: 5,
				spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
				allowBlank: false,
				enforceMaxLength : true,
				minValue:0
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name: 'nextServiceDueDate',
				itemId:'nextServiceDueDate',
				fieldLabel: getTransportTranslation('NEXT_SERVICE_DUE_DATE'),
				vtype: 'daterange',
				//allowBlank: false,
				 minValue: new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},

			},{
		    	 xtype: 'customcombobox',
				 fieldLabel: getTransportTranslation('TRANSPORT_INCHARGE_NAME'),
				 name: 'person',
				 itemId: 'person',
				 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				 store: Ext.create('Academia.store.hostel.roomallocation.UserSmartSearchByUserType'),
				 valueField: 'id',
				 displayField: 'valueCode',
				 queryParam:'codeOrName',
				 triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				 enableKeyEvents  : 'true',
				 forceSelection:true,
				 minChars:3,
				 typeAhead:false,
				 hideTrigger:false,
				// allowBlank: false,
				 triggerAction: '',
				 listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +'</div>';
					}
				}
		     
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 536,
				labelAlign: 'top'
			},
			items:[{
    			xtype: 'textarea',
    			itemId:'remark',
    			name:'remark',
    			width: 536,
    			maxLength : 255,
    			fieldLabel: getCommonTranslation('REMARK')
    		}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtnServiceHistory',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtnServiceHistory',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});