/**
 * @author sohan.chouhan

 */
Ext.define('Academia.view.transport.vehicle.ServiceHistoryForVehicleStructure', {
	extend: 'Ext.form.Panel',
	alias: 'widget.servicehistoryforvehiclestructure',
	autoScroll: false,
	frame: false,
	border:false,
	
	items: [{
		xtype:'panel',
		width: 'auto',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'displayfield'
			},
			items:[{
				name: 'vehicleCode',
				itemId:'vehicleCode',
				fieldLabel: getTransportTranslation('VEHICLE_CODE')
			},{
				name: 'vehicleType',
				itemId:'vehicleType',
				fieldLabel: getTransportTranslation('VEHICLE_TYPE')
			},{
				name: 'vehicleNo',
				itemId:'vehicleNo',
				fieldLabel: getTransportTranslation('VEHICLE_NO')
			},{
				xtype:'hidden',
				name:'vehicleId',
				itemId:'vehicleId'
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'datefield',
				name:'dateFrom',
				itemId:'dateFrom',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype: 'daterange',
				endDateField: 'dateTill',
				editable:false,
				fieldLabel:getTransportTranslation('DATE_FROM')
			},{
				xtype: 'datefield',
				name:'dateTill',
				itemId:'dateTill',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype: 'daterange',
				startDateField: 'dateFrom',
				editable:false,
				maxValue:new Date(),
				fieldLabel:getTransportTranslation('DATE_TILL')
			}]
		},{
			xtype: 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items: [{
	            xtype: 'button',
	            text: getCommonTranslation('SEARCH'),
	            itemId: 'searchServiceHistoryItemId',
	            buttonAlign: 'left',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind: true
	        }, {
	            xtype: 'button',
	            itemId: 'resetServiceHistoryItemId',
	            text: getCommonTranslation('RESET'),
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        }]
		}]
	},{
		xtype:'panel',  
		items:[{
			xtype: 'servicehistorygrid',
			itemId: 'servicehistorygrid',
			margin:'0 0 0 0'
		}]
	}]
});