/**
 *  @author sohan.chouhan

 */

Ext.define('Academia.view.transport.vehicle.ServiceHistoryGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.servicehistorygrid',
	store : 'transport.vehicle.ServiceHistoryGridDataStore',
	title: getPersonModuleTranslation('SERVICE_HISTORY'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'transport.vehicle.ServiceHistoryGridDataStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getTransportTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getTransportTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getTransportTranslation('VIEW'),
		iconCls: 'view-icon'
			}/*,{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getTransportTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}*/],
	columns: [{
		header : getTransportTranslation('DATE'),
		dataIndex : 'serviceDate',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('SERVICED_BY'),
		dataIndex : 'servicedBy',
		flex:1
	},{
		header : getTransportTranslation('ODOMETER_READING'),
		dataIndex : 'odometerReading',
		flex:1
	},{
		header : getTransportTranslation('AMOUNT'),
		dataIndex : 'amount',
		flex:1
	},{
		header : getTransportTranslation('NEXT_SERVICE_DUE_DATE'),
		dataIndex : 'nextServiceDueDate',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getCommonTranslation('REMARK'),
		dataIndex : 'remark',
		flex:1
	}]
});