/**
 *  @author Priyanshi Sharma

 */

Ext.define('Academia.view.transport.vehicle.VehiclePermitGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.vehiclepermitgrid',
	store : 'transport.vehicle.VehiclePermitGridDataStore',
	title: getTransportTranslation('VEHICEL_PERMIT_DETAIL'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'transport.vehicle.VehiclePermitGridDataStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getTransportTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getTransportTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getTransportTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getTransportTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getTransportTranslation('PERMIT_NUMBER'),
		dataIndex : 'permitNumber',
		flex:1
	},{
		header : getTransportTranslation('ISSUE_DATE'),
		dataIndex : 'issueDate',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('EXPIRATION_DATE'),
		dataIndex : 'expirationDate',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('ISSUED_BY'),
		dataIndex : 'issuedBy',
		flex:1
	},{
		header : getTransportTranslation('VEHICLE_PERMIT_DOCUMENT'),
		dataIndex : 'permitDocumentId',
		flex:1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
					return '<a href="#">' + "1" + '</a>';
			}                        
		}
    
	}]
});