var helpMessageProvider = new Object();

helpMessageProvider.component = null;
helpMessageProvider.messages = new Array();
helpMessageProvider.displayMessage = null;
helpMessageProvider.messageKey = null;
helpMessageProvider.config = null;
helpMessageProvider.resourceBaseURL = "resources/helpContent/";
helpMessageProvider.language = 'en';

helpMessageProvider.width = null;
helpMessageProvider.calloutArrowLocation = null;
helpMessageProvider.relativePosition = null;

helpMessageProvider.setMessages = function(msgs){
	this.messages = msgs;
}
helpMessageProvider.reset = function(){
	
	helpMessageProvider.component = null;
	helpMessageProvider.displayMessage = null;
	helpMessageProvider.messageKey = null;

	helpMessageProvider.width = null;
	helpMessageProvider.calloutArrowLocation = null;
	helpMessageProvider.relativePosition = null;
}
helpMessageProvider.getMessage = function(cmp){
	if(this.messages && cmp){
			helpMessageProvider.reset();
			helpMessageProvider.component = cmp;
			helpMessageProvider.findMessage();
			return helpMessageProvider.buildMessageConfiguration();
	}
}
helpMessageProvider.findMessage = function(){
	var expr = undefined;
	if(this.component){
		if(this.component.componentCls == 'x-panel'){	
			expr = this.component.getActiveTab().xtype;
		}else{
			var id = this.component.id;
			if(id){
				var formElement = this.component.up('form');
				if(formElement){
					var formId = (formElement.id) ? formElement.id : undefined;  
					if(formId){
						expr = formId + '.' + id;
					}
				}
			}
		}
	}
	
	if(expr && helpMessageProvider.messages){
		var obj = jPath.filter(helpMessageProvider.messages, expr);
		if(obj && obj.length>0)
			helpMessageProvider.displayMessage = obj[0] || undefined;
		else
			helpMessageProvider.displayMessage = undefined;
	}
}
helpMessageProvider.populateMsgProperties = function(){
	if(helpMessageProvider.displayMessage){
		var msgObj = helpMessageProvider.displayMessage;
		
		msgObj.width = (msgObj.width) ? msgObj.width :200;
		msgObj.calloutArrowLocation = (msgObj.calloutArrowLocation) ? msgObj.calloutArrowLocation :helpMessageProvider.defaultCalloutArrowLocation();
		msgObj.relativePosition = (msgObj.relativePosition) ? msgObj.relativePosition :helpMessageProvider.defaultRelativePosition();
	}
}

helpMessageProvider.defaultCalloutArrowLocation = function(){
	if(this.component.componentCls == 'x-field')
		return 'left';
	else if(this.component.componentCls == 'x-fieldset')
		return 'bottom';
	else
		return 'left';
}

helpMessageProvider.defaultRelativePosition = function(){
	if(this.component.componentCls == 'x-field')
		return 'l-r';
	else if(this.component.componentCls == 'x-fieldset')
		return 'b-t';
	else
		return 'l-r';
}
	
helpMessageProvider.buildMessageConfiguration = function(){
	helpMessageProvider.populateMsgProperties();
	if(helpMessageProvider.displayMessage){
		var msgObj = helpMessageProvider.displayMessage;
		
		return {
			width:                 msgObj.width,
			html:                  msgObj.html,
			calloutArrowLocation:  msgObj.calloutArrowLocation,
			target:                helpMessageProvider.component,
			relativePosition:      msgObj.relativePosition,
			listeners: {
				hide: function () {
					this.destroy();
				}
			},
			resource:				msgObj.resource
		}
	}else{
		return null;
		
	}
}

helpMessageProvider.showHelp = function(obj, config) {
	helpMessageProvider.component = obj;
	var msgConfig;
	if (config)
		helpMessageProvider.component.config = config;
	if (obj && !obj.helpIcon) {
		if (obj.componentCls == 'x-panel') {
			html = '<div class="x-page-help-icon" style="width: 16px" data-qtip="Page Help"></div>';
			sourceElement = Ext.get(obj.el.dom.children[0].children[0]);
			msgConfig ={pageLevel:true};
		} else {
			msgConfig = helpMessageProvider.getMessage(obj);
			if (msgConfig) {
				var html = "";
				var sourceElement = undefined;
				if (obj.componentCls == 'x-field') {
					html = '<td valign="middle" width="16px" class ="x-form-help-item" data-qtip="Field Help" ><div class="x-form-help-icon" style="width: 16px"></div></td>';
					sourceElement = Ext.get(obj.el.dom.children[0].children[0]);
					msgConfig.relativeOffsets = [6, 15];
				} else if (obj.componentCls == 'x-fieldset') {
					html = '<div class="x-form-help-icon-fieldset" style="width: 16px" data-qtip="Field Help"></div>';
					sourceElement = Ext.get(obj.el.dom.children[0].children[0]);
					msgConfig.relativeOffsets = [0, -2];
				}
			}
		}
		if (sourceElement) {
			obj.helpIcon = sourceElement.createChild(html);
			msgConfig.target = obj.helpIcon;
			
			helpMessageProvider.bindEvent(msgConfig);
		}
	}
}

helpMessageProvider.bindEvent = function(msgConfig){
	var obj = helpMessageProvider.component;
	if(obj.helpIcon)
	{
		obj.helpIcon.on('click',function(){
			if(obj.config && obj.config.pageLevel){
				
				if(!isNullOrEmpty(obj.getActiveTab())){
					var xtype = obj.getActiveTab().xtype;
					if(xtype === 'panel' || xtype === 'container'){
						xtype = obj.getActiveTab().items.items[0].xtype;
					}
					helpMessageProvider.showPageHelp(xtype);
				}else{
					var xtype = obj.items.items[0].xtype;
					helpMessageProvider.showPageHelp(xtype);
				}
				
				
				
/*				if(msgConfig.resource){
					pageHelpWnd.show();
					Ext.getCmp('myIframe').getEl().dom.src = helpMessageProvider.resourceBaseURL +  helpMessageProvider.language + msgConfig.html;
				}else{
					Ext.MessageBox.show({
					   title: 'Help',
					   msg: msgConfig.html,
					   closable:true,
					   width: 800,
					   height:600
				   });
				}				   
*/			}else{
				Ext.widget( 'callout', msgConfig).show();
			}
		});
	}
}
helpMessageProvider.getPageHelp = function(xtype){
	if(helpMessageProvider.messages){
		var obj = jPath.filter(helpMessageProvider.messages, xtype);
		if(obj && obj.length>0)
			helpMessageProvider.displayMessage = obj[0] || undefined;
		else
			helpMessageProvider.displayMessage = undefined;
	}
}
helpMessageProvider.showPageHelp = function(xtype){
	helpMessageProvider.getPageHelp(xtype);
	if(helpMessageProvider.displayMessage){
		if(helpMessageProvider.displayMessage.resource){
			pageHelpWnd.show();
			Ext.getCmp('myIframe').getEl().dom.src = helpMessageProvider.resourceBaseURL  +  helpMessageProvider.language + '/' + helpMessageProvider.displayMessage.html;
		}else{
			Ext.MessageBox.show({
			   title: 'Help',
			   msg: '<p align="justify">'+helpMessageProvider.displayMessage.html+'</p>',
			   closable:true,
			   autoScroll:true,
			   width: 800,
			   height:600
		   });
		}
	}
}

var pageHelpWnd;
Ext.onReady(function() {
  pageHelpWnd = new Ext.Window({
    title : "Help",
    width : 800,
    height: 600,
    autoScroll:true,
	closeAction:'destroy',
    layout : 'fit',
    modal: true,
    border: 5,
    style: {
    	borderColor :"black",
    	borderStyle: 'solid'
    },
    constrain: true,
    items : [{
        xtype : "component",
		id:'myIframe',
        autoEl : {
            tag : "iframe",
            src : ""
        }
    }]
});	
});
