Ext.define('Ext.chart.axis.OverlapLabelOptions', {

	override: 'Ext.chart.axis.Axis'

	    ,alternateClassName: 'Ext.AxisOverlappingLabelOptions'

	    /**
	     * @cfg {Integer/String}
	     *
	     * Number of label rows. If this option is set to 'auto', then overlapping labels will
	     * be drawn on the next row where they don't overlap. Which can give a messy result.
	     */
	    ,labelRows: 1

	    /**
	     * @cfg {Boolean}
	     *
	     * Set to false to prevent automatic hiding of overlapping labels.
	     */
	    ,hideOverlappingLabels: true

	    ,drawHorizontalLabels: function() {
	        var me = this,
	            labelConf = me.label,
	            floor = Math.floor,
	            max = Math.max,
	            axes = me.chart.axes,
	            insetPadding = me.chart.insetPadding,
	            gutters = me.chart.maxGutters,
	            position = me.position,
	            inflections = me.inflections,
	            ln = inflections.length,
	            labels = me.labels,
	            maxHeight = 0,
	            ratio,
	            bbox, point, prevLabel, prevLabelId,
	            adjustEnd = me.adjustEnd,
	            hasLeft = axes.findIndex('position', 'left') != -1,
	            hasRight = axes.findIndex('position', 'right') != -1,
	            textLabel, text,
	            last, x, y, i, firstLabel;

	        var labelRows = Ext.num(this.labelRows, 1),
	            autoOffsetLabels = this.labelRows === 'auto',
	            hideLabels = this.hideOverlappingLabels;

	        var lastLabelOnRow = [],
	            row, j;

	        last = ln - 1;
	        //get a reference to the first text label dimensions
	        point = inflections[0];
	        firstLabel = me.getOrCreateLabel(0, me.label.renderer(labels[0]));
	        ratio = Math.floor(Math.abs(Math.sin(labelConf.rotate && (labelConf.rotate.degrees * Math.PI / 180) || 0)));

	        for (i = 0; i < ln; i++) {
	            row = 0; // rx: start at first row
	            point = inflections[i];
	            text = me.label.renderer(labels[i]);
	            textLabel = me.getOrCreateLabel(i, text);
	            bbox = textLabel._bbox;
	            //maxHeight = max(maxHeight, bbox.height + me.dashSize + me.label.padding);
	            x = floor(point[0] - (ratio ? bbox.height : bbox.width) / 2);
	            if (adjustEnd && gutters.left == 0 && gutters.right == 0) {
	                if (i == 0 && !hasLeft) {
	                    x = point[0];
	                }
	                else if (i == last && !hasRight) {
	                    x = Math.min(x, point[0] - bbox.width + insetPadding);
	                }
	            }
	            if (position == 'top') {
	                y = point[1] - (me.dashSize * 2) - me.label.padding - (bbox.height / 2);
	            }
	            else {
	                y = point[1] + (me.dashSize * 2) + me.label.padding + (bbox.height / 2);
	            }

	            // rx: vertical offset
	            y += (i % labelRows) * bbox.height;

	            textLabel.setAttributes({
	                hidden: false,
	                x: x,
	                y: y
	            }, true);

	            if (autoOffsetLabels) {
	                // rx: find the row on which we can draw the label without overlapping
	                for (j=0; j<lastLabelOnRow.length; j++) {
	                    if (me.intersect(textLabel, lastLabelOnRow[j])) {
	                        row++;
	                        textLabel.setAttributes({
	                            y: y + row * bbox.height
	                        }, true);
	                    }
	                }

	                // rx: calc maxHeight knowing the row
	                maxHeight = max(maxHeight, bbox.height + me.dashSize + me.label.padding + (bbox.height * row));

	                // rx: keep reference to know where we can place the next label
	                lastLabelOnRow[row] = textLabel;
	            } else {

	                if (hideLabels) {
	                    // Skip label if there isn't available minimum space
	                    if (i != 0 && (me.intersect(textLabel, prevLabel)
	                        || me.intersect(textLabel, firstLabel))) {
	                        if (i === last && prevLabelId !== 0) {
	                            prevLabel.hide(true);
	                        } else {
	                            textLabel.hide(true);
	                            continue;
	                        }
	                    }
	                }

	                maxHeight = max(maxHeight, bbox.height + me.dashSize + me.label.padding + bbox.height * (i % labelRows));
	            }

	            prevLabel = textLabel;
	            prevLabelId = i;
	        }

	        return maxHeight;
	    }
	});
