/**
 * @author
 * Manas
 * @description
 * Controller for Register For Assessment Group Filter & Grid
 */
Ext.define('Academia.controller.AssessmentGroupRegistration.AssessmentGroupRegistrationController', {
    extend: 'Academia.controller.base.BaseController',
	models: [
	    	'examinationcenters.marksheet.AssessmentGroupMarksheetModel'
	    ],

    views: [
        'examexecution.ExamRegisterGroupStructure',
        'examinationcenters.evaluationgrouplisting.ResgisterForGroupFilter',
        'examexecution.StudentRegisterForEvalGroupGrid',		
		'examexecution.RegGroupApplyWindow','examexecution.ApplyForAssessmentGroupStructure' ,
		'examexecution.RegAssessmentGroupCoreFilter',
		'examexecution.RegAssessmentGroupCoreGrid','examexecution.RegAssessmentGroupCoreStructure',
		'examinationcenters.evaluationgrouplisting.RegGroupApplyNowStructureSPPortal',
		'examinationcenters.evaluationgrouplisting.applicationdetail.RegGroupApplicationDetailForm',
		'examinationcenters.evaluationgrouplisting.documentsubmit.RegGroupDocumentGridStucture',
		'examinationcenters.evaluationgrouplisting.documentsubmit.EvalGroupListingDocumentGrid',
		'baselayout.contentarea.ContentPanel','examexecution.RegGroupApplyEventGrid' 
    ],

	stores: [
		'RegEGStores.RegEGProgramStore',
		'RegEGStores.RegEGBatchStore',
		'RegEGStores.RegEGPeriodStore',
		'RegEGStores.RegEGCourseStore',
		'RegEGStores.RegEGApplicationStore', 'RegEGStores.EvaluationGroupStore',
		'RegEGStores.EvaluationGroupProgramStore',
		'RegEGStores.EvaluationGroupBatchStore',
		'RegEGStores.EvaluationGroupApplicationStatusStore',
		'RegEGStores.EvaluationGroupStatusStore',
		'common.AcademicTermStore',
		'RegEGStores.RegAssessmentGroupCoreStore',
		'examinationcenters.evaluationgrouplisting.documentsubmit.EvalGroupListingDocumentStore',
		'RegEGStores.ApplyCoursesGridStore'

	],

    refs: [{
        ref: 'resgisterforgroupfilter',
        selector: 'resgisterforgroupfilter'
	},{
			ref: 'studentregisterforevalgroupgrid',
			selector: 'studentregisterforevalgroupgrid'
		}, {
			ref: 'regGroupApplyWindow',
			selector: 'regGroupApplyWindow'
		}, {
			ref: 'applyforassessmentgroupstructure',
			selector: 'applyforassessmentgroupstructure'
		},		{
				ref: 'documentsubmittedwindow',
				selector: 'documentsubmittedwindow'
			},			{
			   ref: 'applyassessmentgrid',
			   selector: 'applyassessmentgrid'
			}, {
				ref: 'documentsubmittedgrid',
				selector: 'documentsubmittedgrid'
			}, {
				ref: 'regassessmentgroupcorestructure',
				selector: 'regassessmentgroupcorestructure'
			},
			{
				ref: 'reggroupapplynowstructurespportal',
				selector: 'reggroupapplynowstructurespportal'
			}, {
				ref: 'regassessmentgroupcorefilter',
				selector: 'regassessmentgroupcorefilter'
			},   {
				ref: 'regassessmentgroupcoregrid',
				selector: 'regassessmentgroupcoregrid'
			},{
					ref : 'contentpanel',
					selector : 'contentpanel'
				}],
			
			config: {
			    	ASSESSMENTGROUP_CORE_REGISTRATION_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ASSESSMENTGROUP_CORE_REGISTRATION_PRIVILEGES')
			    },

    init: function () {
        this.control({
            'resgisterforgroupfilter': {
                afterrender: this.onFilterRender
            },				'regassessmentgroupcoregrid': {
				                afterrender: this.onCoreGridRender
				            },
			'regassessmentgroupcorestructure': {
			                afterrender: this.onRegStructRender
			            },
            'resgisterforgroupfilter #resetBtn': {
                click: this.onResetClick
            },
            'resgisterforgroupfilter #programItemId': {
                select: this.onProgramSelect
            },
            'resgisterforgroupfilter #batchIdItemId': {
                select: this.onBatchSelect
            },
            'resgisterforgroupfilter #periodId': {
                select: this.onPeriodSelect
            },
            'resgisterforgroupfilter #courseId': {
                select: this.onCourseSelect
            },
			
			'applyassessmentwindow': {
			    render: this.onApplyAssessmentActivate
			}
			,'documentsubmittedwindow': {
						    render: this.onDocWindow
						}
						,
			'resgisterforgroupfilter #searchBtn': {
				click: this.onSearchClick
			},

			'reggroupapplywindow button[itemId=submitBtn]': {
				click: this.onNextSaveClick
			},

			'studentregisterforevalgroupgrid button[itemId=btnApplyItemId]': {
				click: function() {
					var me = this;
					var grid = me.getStudentregisterforevalgroupgrid();
					me.applyNowForRegGroupForStudent(me, grid);
				}
			},
			
			
			'studentregisterforevalgroupgrid button[itemId=btnMakePayment]':{
					                			   click:function(obj){
					                				   var $this = this;
					                				   var grid =$this.getStudentregisterforevalgroupgrid();
													   var groupform=$this.getResgisterforgroupfilter();
					                				   var tempStore=grid.getStore();
					                				   //if(grid.getSelectionModel().getCount()>0){
					                				   if(tempStore.data.items.length>0){
					                					   var studentPortalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
					                					   var record =tempStore.data.items;//grid.getSelectionModel().getSelection();
					                					   var innerJsonArr=[], json;
					                					   var totalAmmount=0;
					                					   var models = grid.getStore().getRange();
					                					   var totalRevalApplied=0;
													for(var i in record) {
					                						   var feeAmount = record[i].data.feeAmount;
															    var newFeeAmount = 100;
					                						   if(!isNullOrEmpty(newFeeAmount)) {
																   newFeeAmount = parseFloat(newFeeAmount.replace(/[^\d.]/g, ''));
					                							   totalAmmount=totalAmmount+newFeeAmount;
					                							   innerJsonArr.push({
					                								   "admissionId": record[i].data.admissionId,
					                								   "studentId": studentPortalInfo.student.id,
					                								   "amount": newFeeAmount,
					                								   "feePlanId":  record[i].data.feePlanId,
					                								   "feeHeadName":  record[i].data.feeHeadName,
					                								   "courseName":record[i].data.courseName,
						                                               "evaluationGroupId":evalGroupValue,
			 														   "periodId":record[i].data.periodId,
																	    "evaluationGroupCode":record[i].data.evaluationGroupCode
					                						   });
			                                                         var lateFeeAmount=record[i].data.lateFeeAmount;
			  														  var totalAmounts=record[i].data.totalAmount;
																	if(!isNullOrEmpty(lateFeeAmount)){
																		 totalAmmount=totalAmmount+parseInt(lateFeeAmount);
																		 innerJsonArr.push({
					                								   "admissionId": record[i].data.admissionId,
					                								   "studentId": studentPortalInfo.student.id,
					                								   "amount": lateFeeAmount,
					                								   "feePlanId":  record[i].data.feePlanId,
					                								   "feeHeadName":  record[i].data.feeHeadName,
					                								   "courseName":record[i].data.courseName,
						                                               "evaluationGroupId":evalGroupValue,
			 														   "periodId":record[i].data.periodId,
																	   "evaluationGroupCode":"Late Fee Applicable"
					                						   });
																	}
					                							   json={
					                									   'firstName':studentPortalInfo.student.firstName,
					                									   'lastName':studentPortalInfo.student.lastName,
					                									   'phoneNo':studentPortalInfo.student.person.mobileCountryCode+" "+studentPortalInfo.student.person.mobileNumber,
					                									   'email':studentPortalInfo.student.person.emailId,
					                									   'studentCode':studentPortalInfo.student.code,
					                									   'studentName': studentPortalInfo.student.printName,
					                									   'program': studentPortalInfo.programBatchDetails.programName,
					                									   'batch':  studentPortalInfo.programBatchDetails.batchName,
					                									   "totalAmount":totalAmmount,
																		   "currencyCode":	record[i].data.currencyCode,
					                									   "examRevalPaymentDetail":innerJsonArr
					                							   };
					                						   } else {
					                							   showWarningMessage(getCommonTranslation('ALERT'),
					                									   'Fee is not applicable for this assessment group');
					                							   return false;
					                						   }
					                									   }
					                					   var buildInfo="";  
					                					   var revalPaymentUrl = ""; 
					                					   if(!isNullOrEmpty(json)) {
					                						   var XMLHttpRequestObject = false;  
					                						   if (window.XMLHttpRequest) {  
					                							   XMLHttpRequestObject = new XMLHttpRequest();  
					                							   XMLHttpRequestObject.overrideMimeType("text/xml");  
					                										   }
					                						   else if (window.ActiveXObject) {  
					                							   XMLHttpRequestObject = new  
					                							   ActiveXObject("Microsoft.XMLHTTP");  
					                								   }
					                						   XMLHttpRequestObject.withCredentials = false;
					                						   XMLHttpRequestObject.onreadystatechange = function() {
					                							   if (this.readyState == 4 && this.status == 200) {
					                								   var id = parseInt(XMLHttpRequestObject.responseText);
					                								   if(!isNaN(id)) {
					                									   var formWindow = $this.getExmevelgrouppaymentsummarywin();
					                									   if (!formWindow) {
					                										   Ext.widget('exmevelgrouppaymentsummarywin');
					                										   formWindow = $this.getExmevelgrouppaymentsummarywin();
					                									   }
					                									   formWindow.show();
					                									   var summaryGrid = formWindow.down('grid');
					                									   summaryGrid.getStore().loadRawData([]);
					                									   summaryGrid.getStore().loadRawData(innerJsonArr);
					                									   var summaryWindMsg = formWindow.down('#summaryWindMsg');
					                									   summaryWindMsg.setVisible(true);
					                									   summaryWindMsg.setValue('&nbsp;<b>Total Amount To Be Paid : '+totalAmmount+" /-</b>");
					                									   Ext.apply(formWindow,{
					                										   data:null,
					                										   setData : function(data){
					                											   formWindow.data = data;
					                										   },
					                										   getData:function(){
					                											   return formWindow.data;
					                										   }
					                									   });
					                									   formWindow.setData(id);
					                								   } else {
					                									   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Payment_PayU_Confirmation'));
					                								   }
					                										   }
					                							   else if(this.readyState == 4 && this.status != 200) {
				                									   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Payment_PayU_Confirmation'));
					                							   }
					                						   };
					                						   XMLHttpRequestObject.open("POST",  grid.getPaymentAGPostUrl(), true);
					                						   XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
					                						   XMLHttpRequestObject.send(""+Ext.encode(json));
															   grid.down('#btnMakePayment').disable();
					                					   }
					                				   }else{
					                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));							        	
					                				   }
					                			   }
					                		   },
											  
			
			
			'studentregisterforevalgroupgrid': {
				                			   selectionchange:function(view,records,eOpts){
				                					  var grid = this.getStudentregisterforevalgroupgrid();
					                				  var btnMakePayment =  grid.down('#btnMakePayment');
					                				  var btnApply=grid.down('#btnApplyItemId');
					                				  
					                				 if(records.length >0){ 
					                					 btnMakePayment.enable();
					                					 btnApply.enable();
					                				 }
					                				 else{
					                					 btnMakePayment.setDisabled(true);
					                					btnApply.setDisabled(true);
					                				 }
												  } 
				                			   },
											   'regassessmentgroupcorefilter': {
											       afterrender: function (form) {
											           var $this = this;
											           var currentAcademyArray = [];
											           var academyLocationIds = this.getCurrentAcademyLocation();

											           // --------------------------------------
											           // REGULAR PORTAL LOGIC (Portal ID = 1)
											           // --------------------------------------
											           var academicTermId = form.down("#academicTermId");
											           var evaluationGroupId = form.down("#assessmentGroupId");
											           var programItemId = form.down("#programItemId");
											           var batchIdItemId = form.down("#batchIdItemId");
											           var groupStatus = form.down("#evaluationGroupStatus");

											           // Disable dependent combos initially
											           groupStatus.setDisabled(true);
											           programItemId.setDisabled(true);
											           batchIdItemId.setDisabled(true);

											           // --------------------------------------
											           // Load Academic Term and Default Cascade
											           // --------------------------------------
											           academicTermId.getStore().getProxy().extraParams = { academyLocationIds: academyLocationIds };
											           academicTermId.getStore().load({
											               callback: function (records) {
											                   Ext.Array.each(records, function (val) {
											                       if (val.get('sequence') == 1) {
											                           currentAcademyArray.push(val);
											                       }
											                   });

											                   if (currentAcademyArray.length === 1) {
											                       academicTermId.setValue(currentAcademyArray[0].data.id);

											                       // Load Evaluation Group based on term
											                       evaluationGroupId.getStore().getProxy().extraParams = {
											                           academyLocationId: academyLocationIds,
											                           academicTermId: currentAcademyArray[0].data.id
											                       };

											                       evaluationGroupId.getStore().load({
											                           scope: $this,
											                           callback: function (rec) {
											                               if (rec.length === 1) {
											                                   evaluationGroupId.setValue(rec[0].data.id);
											                                   programItemId.reset().setDisabled(false);

											                                   var evaluationGroupIdValue = rec[0].data.id;
											                                   programItemId.getStore().getProxy().extraParams = {
											                                       academyLocationId: academyLocationIds,
											                                       evaluationGroupId: evaluationGroupIdValue,
											                                       academicTermId: currentAcademyArray[0].data.id
											                                   };

											                                   // Load Program Store
											                                   programItemId.getStore().load({
											                                       scope: $this,
											                                       callback: function (record) {
											                                           batchIdItemId.setDisabled(false);

											                                           if (record.length === 1) {
											                                               programItemId.setValue(record[0].data.id);
											                                               batchIdItemId.reset();

											                                               // Load Batch Store
											                                               batchIdItemId.getStore().getProxy().extraParams = {
											                                                   programId: record[0].data.id,
											                                                   academyLocationId: $this.getCurrentAcademyLocation(),
											                                                   evaluationGroupId: evaluationGroupIdValue
											                                               };

											                                               batchIdItemId.getStore().load({
											                                                   callback: function (record, operation, success) {
											                                                       if (success && record.length === 1) {
											                                                           batchIdItemId.setValue(record[0].data.id);
											                                                       }
											                                                   }
											                                               });
											                                           }
											                                       }
											                                   });
											                               }
											                           }
											                       });
											                   }
											               }
											           });

											           // --------------------------------------
											           // Load Group Status Default
											           // --------------------------------------
											           groupStatus.getStore().load({
											               callback: function () {
											                   groupStatus.setValue('NOT_APPLIED');
											               }
											           });
											       }
											   } ,
											   	    // SELECT event for academicTermId
													'regassessmentgroupcorefilter customcombobox[itemId=academicTermId]': {
													    select: function (obj, record) {
													        var $this = this;
													        var academyLocationIds = $this.getCurrentAcademyLocation();
													        var getFilterForm = this.getRegassessmentgroupcorefilter();
													        var formValues = getFilterForm.getValues();

													        var evaluationGroupId = getFilterForm.down("#assessmentGroupId");
													        var programItemId = getFilterForm.down("#programItemId");
													        var batchIdItemId = getFilterForm.down("#batchIdItemId");
															var groupStatus = getFilterForm.down("#evaluationGroupStatus");
															var appStatus = getFilterForm.down("#appStatus");

															evaluationGroupId.enable();
													        // --------------------------------------
													        // REGULAR PORTAL LOGIC (Portal ID = 1)
													        // --------------------------------------
													        programItemId.setDisabled(true);
													        programItemId.reset();
													        batchIdItemId.setDisabled(true);
													        batchIdItemId.reset();
															groupStatus.setDisabled(true).reset();
															appStatus.setDisabled(true).reset();
													     //   groupStatus.enable();

													        evaluationGroupId.reset();
													        evaluationGroupId.getStore().getProxy().extraParams = {
													            academyLocationId: $this.getCurrentAcademyLocation(),
													            academicTermId: record[0].data.id
													        };

													        evaluationGroupId.getStore().load({
													            scope: $this,
													            callback: function (rec) {
													                var getFilterForm = this.getRegassessmentgroupcorefilter();
													                var programItemId = getFilterForm.down("#programItemId");
													                var batchIdItemId = getFilterForm.down("#batchIdItemId");
																	var groupStatus = getFilterForm.down("#evaluationGroupStatus");
																	var appStatus = getFilterForm.down("#appStatus");

													                if (rec.length === 1) {
													                    evaluationGroupId.setValue(rec[0].data.id);

													                    programItemId.getStore().getProxy().extraParams = {
													                        academyLocationId: $this.getCurrentAcademyLocation(),
													                        evaluationGroupId: rec[0].data.id,
													                        academicTermId: record[0].data.id
													                    };
													                    programItemId.setDisabled(false).reset();
																		batchIdItemId.setDisabled(false).reset();
																		groupStatus.setDisabled(false).reset();
																		appStatus.setDisabled(false).reset();							
																		
													                    programItemId.getStore().load({
													                        scope: $this,
													                        callback: function (recProg) {
													                         //   batchIdItemId.setDisabled(false);
													                            if (recProg.length === 1) {
													                                programItemId.setValue(recProg[0].data.id);
													                                batchIdItemId.reset();

													                                batchIdItemId.getStore().getProxy().extraParams = {
													                                    programId: recProg[0].data.id,
													                                    academyLocationId: this.getCurrentAcademyLocation(),
													                                    evaluationGroupId: rec[0].data.id
													                                };

													                                batchIdItemId.getStore().load({
													                                    callback: function (recBatch, operation, success) {
													                                        if (success && recBatch.length === 1) {
													                                            batchIdItemId.setValue(recBatch[0].data.id);
													                                        }
													                                    }
													                                });
													                            }
													                        }
													                    });
													                } else {
													                    programItemId.setDisabled(true);
													                    batchIdItemId.setDisabled(true);
													                }
													            }
													        });
													    }
													},
											   	            
											   	            // SELECT event for evaluationGroupId
															'regassessmentgroupcorefilter customcombobox[itemId=assessmentGroupId]': {
															    select: function (obj, rec) {
															        var $this = this;
															        var filterForm = this.getRegassessmentgroupcorefilter();
															        var formValues = filterForm.getValues();
															        var evaluationGroupId = rec[0].data.id;
																	var groupStatus = filterForm.down("#evaluationGroupStatus");
																
																	var applicationStatus = filterForm.down("#appStatus");
																	applicationStatus.enable().reset();
																	groupStatus.enable().reset();
															        // --------------------------------------
															        // REGULAR PORTAL LOGIC (Simplified, Period removed)
															        // --------------------------------------
															        var programCombo = filterForm.down("#programItemId");
															        var batchCombo = filterForm.down("#batchIdItemId");
																	programCombo.enable();
																	batchCombo.setDisabled(true).reset();
																//	batchCombo.enable();
															        // Prepare and load Program store
															        var programStore = programCombo.getStore();
															        programCombo.setDisabled(false).reset();
															        programStore.getProxy().extraParams = {
															            academyLocationId: $this.getCurrentAcademyLocation(),
															            evaluationGroupId: evaluationGroupId,
															            academicTermId: formValues.academicTerm
															        };

															        programStore.load({
															            scope: $this,
															            callback: function (records) {
															            //    batchCombo.setDisabled(false).reset();

															                if (records.length === 1) {
															                    programCombo.setValue(records[0].data.id);
																				batchCombo.setDisabled(false).reset();
															                    // Prepare and load Batch store
															                    var batchStore = batchCombo.getStore();
															                    batchCombo.reset();
															                    batchStore.getProxy().extraParams = {
															                        programId: records[0].data.id,
															                        academyLocationId: $this.getCurrentAcademyLocation(),
															                        evaluationGroupId: evaluationGroupId
															                    };

															                    batchStore.load({
															                        callback: function (recBatch, operation, success) {
															                            if (success && recBatch.length === 1) {
															                                batchCombo.setValue(recBatch[0].data.id);
															                            }
															                        }
															                    });
															                }
															            }
															        });
															    }
															},
											   	            
											   	            // SELECT event for programItemId
															'regassessmentgroupcorefilter customcombobox[itemId=programItemId]': {
															    select: function (obj, rec) {
															        var programId = rec[0].data.id;
															        var form = obj.up('form').getForm();
															        var batch = form.findField('batchId');
															        var evaluationGroupId = form.findField('assessmentGroupId');
																	var filterForm = this.getRegassessmentgroupcorefilter();
																	var groupStatus = filterForm.down("#evaluationGroupStatus");
																	var applicationStatus = filterForm.down("#appStatus");
																	applicationStatus.enable().reset();
																	groupStatus.enable().reset();
															        // --------------------------------------
															        // REGULAR PORTAL LOGIC (Simplified, Period Removed)
															        // --------------------------------------
															        batch.enable().reset();
															        batch.getStore().getProxy().extraParams = {
															            programId: programId,
															            academyLocationId: this.getCurrentAcademyLocation(),
															            evaluationGroupId: evaluationGroupId.getValue()
															        };

															        batch.getStore().load({
															            callback: function (record, operation, success) {
															                if (success && record.length === 1) {
															                    batch.setValue(record[0].data.id);
															                }
															            }
															        });
															    }
															},
											   	            
											   	            // SELECT event for batchIdItemId
															'regassessmentgroupcorefilter customcombobox[itemId=batchIdItemId]': {
															    select: function (obj, rec) {
															        var $this = this;

															        if (this.getCurrentLoggedPortalId() != 3) {
															            // --------------------------------------
															            // REGULAR PORTAL LOGIC (Simplified, Period Removed)
															            // --------------------------------------
															            var form = $this.getRegassessmentgroupcorefilter();
															            var appStatus = form.down("#appStatus");
																		var groupStatus = form.down("#evaluationGroupStatus");
															            appStatus.enable().reset();
																		groupStatus.enable().reset();
															        }
															    }
															},
											   	            
			'regassessmentgroupcorefilter customcombobox[itemId=appStatus]': {
				select: function(obj, rec) {
					var $this = this;

					if (this.getCurrentLoggedPortalId() != 3) {
						// --------------------------------------
						// REGULAR PORTAL LOGIC (Simplified, Period Removed)
						// --------------------------------------
						var form = $this.getRegassessmentgroupcorefilter();
						var groupStatus = form.down("#evaluationGroupStatus");
						groupStatus.enable().reset();
					}
				}
			},
															
											   	            // SELECT event for periodId
														/*	'regassessmentgroupcorefilter customcombobox[itemId=periodId]': {
															    select: function (obj, rec) {
															        var $this = this;
															        var filterForm = this.getRegassessmentgroupcorefilter();

															        var academicTerm = filterForm.down('#academicTermId');
															        var evaluationGroupId = filterForm.down('#evaluationGroupId');
															        var studentProgramId = filterForm.down("#studentProgramId");
															        var studentBatchId = filterForm.down("#studentBatchId");
															        var appStatus = filterForm.down("#appStatus");
															        var periodId = rec[0].data.id;

															        // --------------------------------------
															        // STUDENT PORTAL LOGIC ONLY
															        // --------------------------------------
															        if (this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7) {
															            var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
															            appStatus.enable();

															            // Determine Student ID
															            var studentId = (this.getCurrentLoggedPortalId() == 7)
															                ? studentPortalInfo.student.id
															                : $this.getCurrentlyLoggedInUser().id;

															            // Load Evaluation Group store with relevant params
															            var evalGroupStore = evaluationGroupId.getStore();
															            evalGroupStore.getProxy().extraParams = {
															                academicTermId: academicTerm.getValue(),
															                studentId: studentId,
															                programId: studentProgramId.getValue(),
															                batchId: studentBatchId.getValue(),
															                periodId: periodId
															            };
															            evalGroupStore.load();
															        }
															    }
															},  */ 
											   	            
											   	            // SELECT event for studentProgramId 
											   	     /*       'regassessmentgroupcorefilter customcombobox[itemId=studentProgramId]':{
											   	                select : function(obj, record){
											   	                    var $this = this; 
											   	                    // Use the renamed getter
											   	                    var form=this.getRegassessmentgroupcorefilter();
											   	                    var programId = form.down("#studentProgramId");
											   	                    var batchId = form.down("#studentBatchId");
											   	                    var term = form.down("#academicTermId");
											   	                    var evaluationGroup = form.down("#evaluationGroupId");
											   	                    var appStatus = form.down("#appStatus");
											   	                    
											   	                    evaluationGroup.reset();
											   	                    term.reset();
											   	                    appStatus.reset();
											   	                    
											   	                    var batchStore = batchId.getStore();
											   	                    var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
											   	                    
											   	                    if(this.getCurrentLoggedPortalId()==7){ studentId = studentPortalInfo.student.id; }else{ studentId =this.getCurrentlyLoggedInUser().id; }
											   	                    
											   	                    batchId.setDisabled(false);
											   	                    batchId.setReadOnly(false);
											   	                    batchStore.getProxy().extraParams = { programId:programId.getValue(), studentId:studentId, }; 
											   	                    batchStore.load();
											   	                    
											   	                    var termStore = term.getStore();
											   	                    termStore.getProxy().extraParams = { programId:programId.getValue(), batchId:batchId.getValue(), }; 
											   	                    termStore.load();
											   	                    
											   	                    var evaluationGroupStore = evaluationGroup.getStore();
											   	                    evaluationGroupStore.getProxy().extraParams = { programId:programId.getValue(), batchId:batchId.getValue(), studentId:studentId, academicTermId:term.getValue() } 
											   	                    evaluationGroupStore.load();
											   	                }
											   	            },
											   	            
											   	            // SELECT event for studentBatchId
											   	            'regassessmentgroupcorefilter customcombobox[itemId=studentBatchId]':{
											   	                select:function(obj,rec){
											   	                    var batchId=rec[0].data.id; 
											   	                    var form=obj.up('form').getForm(); 
											   	                    var evaluationGroupField = form.findField('evaluationGroupId'); 
											   	                    var appStatusField = form.findField('appStatus'); 
											   	                    var programField = form.findField('program');
											   	                    
											   	                    evaluationGroupField.enable(); 
											   	                    evaluationGroupField.getStore().getProxy().extraParams = { programId: programField.getValue(), batchId:batchId }; 
											   	                    evaluationGroupField.getStore().load(); 
											   	                    appStatusField.enable();
											   	                }
											   	            }, */

											   	            // CLICK event for searchBtn
															'regassessmentgroupcorefilter button[itemId=searchBtn]': {
															    click: function (obj) {
															        var $this = this;
															        var filterForm = obj.up('form');
															        var form = filterForm.getForm();
															        var masterGrid = this.getRegassessmentgroupcoregrid();
															        var formValues = form.getValues();

															        // --------------------------------------
															        // Remove any periodId reference if exists
															        // --------------------------------------
															        if (formValues.periodId) {
															            delete formValues.periodId;
															        }

															        // --------------------------------------
															        // Set extra params for main grid store
															        // --------------------------------------
															        var store = masterGrid.getStore();
																	
																	
																	
															      //  store.getProxy().extraParams = formValues;
																	store.getProxy().extraParams = {
																		academyLocationId : this.getCurrentAcademyLocation(),
																		groupId: formValues.assessmentGroupId,
																		programId: formValues.program,
																		batchId: formValues.batchId,
																		applicationStatus: formValues.appStatus,
																		groupStatus: formValues.groupStatus,
																		academicTermId: formValues.academicTerm,
																	//	periodId: periodId,
																	//	isHallTicketGenerated: formValues.hallticketgenerated,
																	//	isHallTicketPublished: formValues.hallticketpublished,
																		sort: null
																	};
																
															        // --------------------------------------
															        // Load main grid store
															        // --------------------------------------
															        store.load({
															            callback: function (records, operation, success) {
															                masterGrid.config.searchFilterForm = filterForm;
															                $this.resetPageSetting(store, masterGrid);
															                store.load();
															                store.pageSize = 100;

															                if (records.length > 0) {
															                    // --------------------------------------
															                    // Enable buttons when records found
															                    // --------------------------------------
															                  //  masterGrid.down('#btnMakePayment').setDisabled(false);
															                  //  masterGrid.down('#btnDownloadForm').setDisabled(false);
															                 //   masterGrid.down('#btnExportToPDF').setDisabled(false);
															                  //  masterGrid.down('#btnExportToExcel').setDisabled(false);
															                    masterGrid.down('#spBtnMoreActions').setDisabled(false);

															                    // Regular Portal Privilege Handling (disabled for now)
															                    // $this.disableMoreActionPivileges(masterGrid, $this.getAPPLY_FOR_EVALUATION_GROUP_PERMISSION());

															                } else {
															                    // --------------------------------------
															                    // Disable buttons when no records
															                    // --------------------------------------
															                //    masterGrid.down('#btnMakePayment').setDisabled(true);
															                //    masterGrid.down('#btnDownloadForm').setDisabled(true);
															                //    masterGrid.down('#btnExportToPDF').setDisabled(true);
															                //    masterGrid.down('#btnExportToExcel').setDisabled(true);
															                    masterGrid.down('#spBtnMoreActions').setDisabled(true);
															                }
															            }
															        });
															    }
															},
											   	            
															// CLICK event for resetBtn
															'regassessmentgroupcorefilter button[itemId=resetBtn]': {
															    click: function (obj) {
															        var $this = this;
															        var filterForm = obj.up('form').getForm();
															        var getForm = this.getRegassessmentgroupcorefilter();

															        var evaluationGroup = filterForm.findField("assessmentGroupId");
															        var academicTermId = filterForm.findField("academicTerm");
															       var program = filterForm.findField("program");
																
																
															        // --------------------------------------
															        // RESET BASIC FORM FIELDS
															        // --------------------------------------
															        program.reset();
															        program.setDisabled(true);
															        evaluationGroup.reset();

															        // --------------------------------------
															        // CLEAR GRID AND DISABLE BUTTONS
															        // --------------------------------------
															     /*   var masterGrid = this.getEvalgrouplistingmastergrid();
															        masterGrid.getStore().removeAll();

															        var buttonsToolBar = masterGrid.query('toolbar')[0];
															        buttonsToolBar.query('#btnMakePayment')[0].setDisabled(true);
															        masterGrid.down('#btnDownloadForm').setDisabled(true);
															        masterGrid.down('#btnExportToPDF').setDisabled(true);
															        masterGrid.down('#btnExportToExcel').setDisabled(true);
															        masterGrid.down('#btnMoreActions').setDisabled(true);
*/
															        // --------------------------------------
															        // RESETTING LOGIC FOR REGULAR PORTAL (Portal ID = 1)
															        // --------------------------------------
															        var batchId = filterForm.findField("batchId");
															        var groupStatus = filterForm.findField("groupStatus");
																	var appStatus = filterForm.findField("appStatus");
															        filterForm.reset();
															        batchId.setDisabled(true);
																	appStatus.reset();
																	appStatus.setDisabled(true);
																	groupStatus.reset();
																	groupStatus.setDisabled(true);
															      

															        // --------------------------------------
															        // LOAD DEFAULT DATA AFTER RESET
															        // --------------------------------------
															        var currentAcademyArray = [];
															        var academyLocationIds = $this.getCurrentAcademyLocation();

															        academicTermId.getStore().getProxy().extraParams = { academyLocationIds: academyLocationIds };
															        academicTermId.getStore().load({
															            callback: function (records) {
															                Ext.Array.each(records, function (val) {
															                    if (val.get('sequence') == 1) {
															                        currentAcademyArray.push(val);
															                    }
															                });

															                if (currentAcademyArray.length === 1) {
															                    academicTermId.setValue(currentAcademyArray[0].data.id);

															                    evaluationGroup.getStore().getProxy().extraParams = {
															                        academyLocationId: academyLocationIds,
															                        academicTermId: currentAcademyArray[0].data.id
															                    };

															                    evaluationGroup.getStore().load({
															                        scope: $this,
															                        callback: function (rec) {
															                            if (rec.length === 1) {
															                                evaluationGroup.setValue(rec[0].data.id);
															                                program.reset().setDisabled(false);

															                                var evaluationGroupIdValue = rec[0].data.id;
															                                program.getStore().getProxy().extraParams = {
															                                    academyLocationId: academyLocationIds,
															                                    evaluationGroupId: evaluationGroupIdValue,
															                                    academicTermId: currentAcademyArray[0].data.id
															                                };

															                                program.getStore().load({
															                                    scope: $this,
															                                    callback: function (record) {
															                                        batchId.setDisabled(false);
															                                        if (record.length === 1) {
															                                            program.setValue(record[0].data.id);
															                                            batchId.reset();

															                                            batchId.getStore().getProxy().extraParams = {
															                                                programId: record[0].data.id,
															                                                academyLocationId: $this.getCurrentAcademyLocation(),
															                                                evaluationGroupId: evaluationGroupIdValue
															                                            };

															                                            batchId.getStore().load({
															                                                callback: function (record, operation, success) {
															                                                    if (success && record.length === 1) {
															                                                        batchId.setValue(record[0].data.id);
															                                                    }
															                                                }
															                                            });
															                                        }
															                                    }
															                                });
															                            }
															                        }
															                    });
															                }
															            }
															        });
															    }
															} ,

											   	            // CLICK event for exportToPdf
											   	            'regassessmentgroupcorefilter button[itemId=exportToPdf]':{
											   	                click:function(obj){
											   	                    var $this = this;
											   	                    var academyLocationIds = $this.getCurrentAcademyLocation();
											   	                    // Use the renamed getter
											   	                    var form = $this.getRegassessmentgroupcorefilter();
											   	                    var formValues = form.getValues();
											   	                    var reportParams =new Object(); 
											   	                    var reportTitle="Assessment Group Report"; 
											   	                    
											   	                    reportParams.ACADMEMY_LOCATION_IDS = academyLocationIds+""; 
											   	                    reportParams.headerName=reportTitle;
											   	                    
											   	                    if(!isNullOrEmpty(formValues.program)) { reportParams.PROGRAM_ID=formValues.program; } 
											   	                    if(!isNullOrEmpty(formValues.batchId)) { reportParams.BATCH_ID=formValues.batchId; } 
											   	                    if(!isNullOrEmpty(formValues.assessmentGroupId)) { reportParams.EVAL_GROUP=formValues.assessmentGroupId; } 
											   	                    if(!isNullOrEmpty(formValues.academicTerm)) { reportParams.ACADEMIC_TERM_ID=formValues.academicTerm; } 
											   	                    if(!isNullOrEmpty(formValues.groupStatus)) { reportParams.GROUP_STATUS=formValues.groupStatus; } 
											   	                    
											   	                    var exportUrl= "rest/applicationDetails/generateAssessmentGroupReports"; 
											   	                    var code = "ASSESSMENT_GROUP_REPORT"; 
											   	                    reportParams.code = code; 
											   	                    $this.exportJRXMLReport(code,reportParams,'','.pdf',exportUrl);
											   	                }
											   	            },
											   	            
											   	            // CLICK event for exportToExcel (Inferred from Pdf logic and general ExtJS structure)
											   	            'regassessmentgroupcorefilter button[itemId=exportToExcel]':{
											   	                click:function(obj){
											   	                    var $this = this;
											   	                    var academyLocationIds = $this.getCurrentAcademyLocation();
											   	                    // Use the renamed getter
											   	                    var form = $this.getRegassessmentgroupcorefilter();
											   	                    var formValues = form.getValues();
											   	                    var reportParams =new Object(); 
											   	                    var reportTitle="Assessment Group Report"; 
											   	                    
											   	                    reportParams.ACADMEMY_LOCATION_IDS = academyLocationIds+""; 
											   	                    reportParams.headerName=reportTitle;
											   	                    
											   	                    if(!isNullOrEmpty(formValues.program)) { reportParams.PROGRAM_ID=formValues.program; } 
											   	                    if(!isNullOrEmpty(formValues.batchId)) { reportParams.BATCH_ID=formValues.batchId; } 
											   	                    if(!isNullOrEmpty(formValues.assessmentGroupId)) { reportParams.EVAL_GROUP=formValues.assessmentGroupId; } 
											   	                    if(!isNullOrEmpty(formValues.academicTerm)) { reportParams.ACADEMIC_TERM_ID=formValues.academicTerm; } 
											   	                    if(!isNullOrEmpty(formValues.groupStatus)) { reportParams.GROUP_STATUS=formValues.groupStatus; } 
											   	                    
											   	                    var exportUrl= "rest/applicationDetails/generateAssessmentGroupReports"; 
											   	                    var code = "ASSESSMENT_GROUP_REPORT"; 
											   	                    reportParams.code = code; 
											   	                    $this.exportJRXMLReport(code,reportParams,'','.xlsx',exportUrl);
											   	                }
											   	            }
        });
    },
	

	
	onApplyNowBtnClick: function (grid) {
		
		
	},
	
	onRegStructRender: function (grid) {
			
			
		},
		
		onCoreGridRender: function (grid) {
					
					
				},
	
	applyNowForRegGroupForStudent: function(me, grid) {
											       // Ext.getBody().mask(getCommonTranslation('LOADING_APPLICATION'), 'x-mask-loading');
											
												   this.openNewCmpTab();
												   
												   var applicationDetails = this.getReggroupapplynowstructurespportal();
												                   						   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
												                   						   var studentName = studentPortalInfo.student.printName;
												                   						   var admissionId = studentPortalInfo.admissionDetails[0].id; 	   
												   

											       // Step 1️⃣: Validate selection
											       if (grid.getSelectionModel().getCount() === 0) {
											           showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
											           Ext.getBody().unmask();
											           return;
											       }

											       var record = grid.getSelectionModel().getSelection()[0];

											       // Step 2️⃣: Extract params for backend
											       //var admissionId = record.get('admissionId');
											       //var studentId = record.get('studentId');
											       var courseId = record.get('courseId');
											       var evaluationGroupId = record.data.evaluationGroupId;
												   
												   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();

												   var admissionId=studentPortalInfo.admissionDetails[0].id;

												   var studentId=studentPortalInfo.student.id;

											       if (isNullOrEmpty(admissionId) || isNullOrEmpty(studentId) || isNullOrEmpty(courseId) || isNullOrEmpty(evaluationGroupId)) {
											           showWarningMessage(getCommonTranslation('ALERT'), 'Missing required details to fetch application.');
											           Ext.getBody().unmask();
											           return;
											       }

											       // Step 3️⃣: Perform Ajax call
											       Ext.Ajax.request({
											           type: 'rest',
											           url: SERVERURL.APPY_NOW_FOR_REG_GROUP_FOR_STUDENT,
											           method: 'GET',
											           params: {
											               admissionId: admissionId,
											               studentId: studentId,
											               courseId: courseId,
											               evaluationGroupId: evaluationGroupId
											           },
											           success: function(response) {
											               Ext.getBody().unmask();

											               var result = Ext.decode(response.responseText);
														   record.set('applicationResult', result);

											               if (!isNullOrEmpty(result)) {
											                   // Step 4️⃣: Open window and fill form
											                  var form = applicationDetails.down('reggroupapplywindow form');
											                   if (form) {
											                       form.getForm().setValues({
											                           studentName: result.studentCode || '',
											                           name: result.studentName || '',
											                           assessmentGroupName: result.evaluationGroupCode || '',
											                           groupStatus: result.evaluationGroupStatus || '',
											                           centerStatus: result.centerStatus || '',
											                           program: result.programName || '',
											                           batch: result.batchName || '',
											                           applicationStatus: result.applicationStatus || '',
											                           roomAllocationStatus: result.roomAllocationStatus || ''
											                       });
											                   }
															   
															   if (result && result.groupCourseList && result.groupCourseList.length > 0) {
															          var grid = applicationDetails.down('#reggroupapplyeventgrid');
															          if (grid) {
															              var store = grid.getStore();
															              store.removeAll();
															              store.loadData(result.groupCourseList);
																		  
																		  store.each(function(rec) {
																		             rec.set('selected', true);
																		         });

																		         // Disable the check column UI
																		        var col = grid.down('checkcolumn[itemId=selectCol]');
																		         col.disable(); 
															          }
															      }
															   
															   

											                 //  showSuccessMessage(getCommonTranslation('SUCCESS'), 'Application data loaded successfully.');
											               } else {
											                   showInfoMessage(getCommonTranslation('INFO'), 'No data found for selected student.');
											               }
											           },
											           failure: function(response) {
											               Ext.getBody().unmask();
											               showErrorMessage(getCommonTranslation('ERROR'), 'Failed to fetch application: ' + response.statusText);
											           }
											       });
											   },
	
	onApplyAssessmentActivate: function (panel) {
		 
	}
	,	onDocWindow: function (panel) {
			 
		}, 
    // ============================
    // 🔹 ON FILTER RENDER
    // ============================
	onFilterRender: function (form) {
	    var me = this;
	    var studentInfo = me.getCurrentlyLoggedInUserInfoForPortal(); 
	    if (!studentInfo) return;

	    var studentId = studentInfo.student.id;
	    var alId = me.getCurrentAcademyLocation();

	    var programCombo = form.down('#programItemId'),
	        batchCombo = form.down('#batchIdItemId'),
	        periodCombo = form.down('#periodId'),
	        courseCombo = form.down('#courseId');

	    // ✅ SAFETY CHECK before accessing proxy
	    if (courseCombo && courseCombo.getStore && courseCombo.getStore()) {
	        var courseStore = courseCombo.getStore();
	        courseStore.getProxy().extraParams = {
	            studentId: studentId
	            // periodId intentionally removed
	        };
	        courseStore.load();
	    }

	    // Disable dependent combos initially
	    Ext.each([batchCombo, periodCombo], function (c) {
	        c.setDisabled(true);
	        c.clearValue();
	    });

	    // Enable and load Program combo
	    programCombo.setDisabled(false); 
	    programCombo.clearValue();

	    var programStore = programCombo.getStore();
	    programStore.removeAll();
	    programStore.getProxy().extraParams = {
	        alId: alId,
	        studentId: studentId
	    };

	    programStore.load({
	        callback: function (records, success) {
	            if (success && records && records.length === 1) {
	                var programId = records[0].data.programId;
	                programCombo.setValue(programId);
	                me.loadBatchStore(batchCombo, programId, studentId, form);
	            } else {
	                programCombo.setDisabled(false);

	                // ✅ Optional fallback course reload after 200ms
	                Ext.defer(function () {
	                    if (courseCombo && courseCombo.getStore && courseCombo.getStore()) {
	                        var store = courseCombo.getStore();
	                        store.getProxy().extraParams = {
	                            studentId: studentId
	                        };
	                        store.load(); 
	                    }
	                }, 200);
	            }
	        }
	    });
	},

    // ============================
    // 🔹 STEP 1 → PROGRAM SELECT
    // ============================
	onProgramSelect: function (combo, record, courseId) {
	    var form = combo.up('form');
	    var studentId = this.getStudentId(form);
	    var batchCombo = form.down('#batchIdItemId');
		var courseCombo = form.down('#courseId');
	    var programId;

	    if (record && record.length > 0 && record[0] && record[0].data) {
	        programId = record[0].data.programId;
	    } else {
	        programId = form.down('#programItemId').getValue();
	    }

	    if (!programId) {
	        return;
	    }

	    var params = {
	        programId: programId,
	        studentId: studentId
	    };

	    if (!isNullOrEmpty(courseId)) {
	        params.courseId = courseId;
	    }

	    this.loadBatchStore(batchCombo, programId, studentId, form, params);
	} ,

    loadBatchStore: function (batchCombo, programId, studentId, form) {
        var me = this,
            store = batchCombo.getStore();
			var courseCombo = form.down('#courseId');
        store.removeAll();
        store.getProxy().extraParams = {
            programId: programId,
            studentId: studentId
        };
        store.load({
            callback: function (records, success) {
                if (success &&  records.length === 1) {
                    var batchId = records[0].data.batchId;
                    batchCombo.setValue(batchId);
					batchCombo.enable();
					me.loadPeriodStore(form.down('#periodId'), batchId, studentId, form);
				} else {
					batchCombo.setDisabled(false);


					Ext.defer(function() {
						if (courseCombo && courseCombo.getStore()) {
							courseCombo.getProxy().extraParams = {
								studentId: studentId,
								periodId: null
							};
							courseCombo.getStore().load();
						}
					}, 200);  
				}
			}
		});
    },

    // ============================
    // 🔹 STEP 2 → BATCH SELECT
    // ============================
    onBatchSelect: function (combo, record) {
        var form = combo.up('form'),
            periodCombo = form.down('#periodId');

        periodCombo.setDisabled(false);
        periodCombo.clearValue();

        var batchId = record[0].data.batchId,
            studentId = this.getStudentId(form);

        this.loadPeriodStore(periodCombo, batchId, studentId, form);
    },

	loadPeriodStore: function (periodCombo, batchId, studentId, form) {
	    var me = this,
	        store = periodCombo.getStore();
			var courseCombo = form.down('#courseId');
	    store.removeAll();
	    store.getProxy().extraParams = {
	        batchId: batchId,
	        studentId: studentId
	    };

	    store.load({
	        callback: function (records, success) {
	            if (success && records.length === 1) {
	                var periodId = records[0].data.periodId;
	                periodCombo.setValue(periodId);
					periodCombo.enable();
	                // ✅ Fire select manually (ExtJS 4 doesn’t auto fire)
	                periodCombo.fireEvent('select', periodCombo, [records[0]]);
	            } else {
	                periodCombo.setDisabled(false);
					var courseCombo = form.down('#courseId');
					Ext.defer(function() {
											if (courseCombo && courseCombo.getStore()) {
												courseCombo.getProxy().extraParams = {
													studentId: studentId,
													periodId: null
												};
												courseCombo.getStore().load();
											}
										}, 500);
	            }
	        }
	    });
	},

    // ============================
    // 🔹 STEP 3 → PERIOD SELECT
    // ============================
    onPeriodSelect: function (combo, record) { 
        var form = combo.up('form'),
            courseCombo = form.down('#courseId');
			periodId = form.down('#periodId').getValue();

        courseCombo.setDisabled(false);
        courseCombo.clearValue();
		studentId = this.getStudentId(form);
		var isPeriod=true;

        this.loadCourseStore(courseCombo, periodId, studentId,isPeriod);
    },

	loadCourseStore: function (courseCombo, periodId, studentId,isPeriod) {
	    var form = courseCombo.up('form');
	    var programCombo = form.down('#programItemId');
	    var batchCombo = form.down('#batchIdItemId');
	    var periodCombo = form.down('#periodId');

		if(!isPeriod){
	    programCombo.clearValue();
	    batchCombo.clearValue();
	    periodCombo.clearValue();
		}
	    var store = courseCombo.getStore();
	    store.removeAll();
	    store.getProxy().extraParams = {
	        periodId: periodId,
	        studentId: studentId
	    };

	    store.load({
	        callback: function (records, success) {
	            if (success && records.length === 1) {
	                var courseId = records[0].data.courseId;
	                courseCombo.setValue(courseId);
	            } else {
	                courseCombo.setDisabled(false);
	            }
	        }
	    });
	} ,
	   /* On save Click of Event Apply Course Grid  */ 
	   onNextSaveClick: function(btn) {
	       var grid = Ext.ComponentQuery.query('studentregisterforevalgroupgrid')[0];
	       var record = grid.getSelectionModel().getSelection()[0];
	       var savedResult = record.get('applicationResult');

	       if (!savedResult) {
	           Ext.Msg.alert('Info', 'No cached data found. Please fetch first.');
	           return;
	       }

	       Ext.Ajax.request({
	           url: SERVERURL.SAVE_APPLY_GROUP_REG,
	           method: 'POST',
	           jsonData: savedResult,
	           success: function(response) {
	             //  var res = Ext.decode(response.responseText);
				  showSuccessMessage(getCommonTranslation('LOGIN_PAGE_CONTENT'),getCommonTranslation('CONFIG_SAVED_SUCCESSFULLY'));
	           },
	           failure: function() {
					showErrorMessage(getEnquiryTranslation('ALERT'), getCommonTranslation('FAILURE'));
	           }
	       });
	   },

    // ============================
    // 🔹 STEP 4 → COURSE SELECT
    // ============================
	onCourseSelect: function (combo, record) {
	    var me = this;
	    var form = combo.up('form');
	    var saveBtn = form.up('panel').down('#searchBtn');
	    saveBtn.setDisabled(!form.getForm().isValid());

	    if (me._isProgramSelectLocked) return;
	    me._isProgramSelectLocked = true;

	    var programCombo = form.down('#programItemId');
	    var courseId = record[0].data.courseId;
	    var programId = programCombo.getValue();

	  /*  if (programCombo && programId && courseId) {
	        programCombo.fireEvent(
	            'select',
	            programCombo,
	            [programCombo.getStore().getById(programId)],
	            courseId
	        );
	    }

	    Ext.defer(function () {
	        me._isProgramSelectLocked = false; 
	    }, 500); */ 
	},

    // ============================
    // 🔹 SEARCH CLICK
    // ============================
    onSearchClick: function (btn) {
        var form = btn.up('form');
        var grid = this.getStudentregisterforevalgroupgrid();
        var store = grid.getStore();
        var values = form.getValues();
		
        var studentId = this.getStudentId(form);
        var admissionId = this.getCurrentAcademyLocation();
		
		var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
		var admissionId = studentPortalInfo.admissionDetails[0].id;

        Ext.apply(store.getProxy().extraParams, {
            admissionId: admissionId,
            studentId: studentId,
            programId: values.programId,
            batchId: values.batchId,
            periodId: values.periodId,
            courseId: values.courseId
        });

        store.load();
    },

    // ============================
    // 🔹 RESET CLICK
    // ============================
    onResetClick: function (btn) {
        var me = this;
        var form = btn.up('form');

        form.getForm().reset();

        var grid = me.getStudentregisterforevalgroupgrid();
        if (grid && grid.getStore()) {
            grid.getStore().removeAll();
        }

        me.onFilterRender(form);
    },

    // ============================
    // 🔹 UTIL
    // ============================
    getStudentId: function (form) {
        var tab = form.up('tabpanel') ? form.up('tabpanel').getActiveTab() : null;
        if (tab && typeof tab.getUserId === 'function') {
            return tab.getUserId();
        }
        return null;
    },
	openNewCmpTab: function() {
	   	   var me = this;
	   	   var contentpanel = this.getContentpanel();
		   
		   //var evalgrouplistingtab = Ext.create('Academia.view.examinationcenters.evaluationgrouplisting.RegGroupApplyNowStructureSPPortal');
		  var tab = Ext.widget('reggroupapplynowstructurespportal');
		   var tabName = getExaminationTranslation('TEST_GROUP');
	   	   /**
	   	    * This is to remove tab from content panel and open same tab again 
	   	    */
	   	   var getcontroller=this.getController('menu.CoreERPNavigationController');
	   	   var getTab=getcontroller.getTab(tabName);
	   	   if(getTab!=null){
	   		   contentpanel.remove(getTab, true);
	   	   }
	   	   openTab(contentpanel, tabName, tab,CONSTANTS.MENU_COLOR_FOUR);
	      }
});