/*
 * @author prathamesh.sheth
 * 
 * This controller is used for application form sale details.
 *    
 */
Ext.define('Academia.controller.admission.applicationFormSale.ApplicationFormSaleController', {
    
	extend: 'Academia.controller.admission.admissionCommon.AdmissionFormCommonController',

    alias: "widget.applicationformsalecontroller",

    mixins: { 		
    	PersonInfoController:'Academia.controller.personinfo.common.PersonInfoController'
    },
    models: ['admission.applicationFormSale.PersonEnityModel',
             'admission.applicationFormSale.ApplicationFormEntityDataModel',
             'Academia.model.admission.applicationFormSale.ApplicantGridModel'],

    stores: ['admission.applicationFormSale.ApplicantTypeStore',
             'admission.applicationFormSale.ActiveProgramGroupComboStore',
             	 'admission.applicationFormSale.ProgramGroupComboStore',
             	 'admission.applicationFormSale.AddProgramGridStore',
             	 'admission.applicationFormSale.ApplicantGridStore',
             	 'admission.applicationFormSale.SearchResultGridStore',
             	 'admission.applicationFormSale.CollectedByComboStore',
             	 'admission.applicationFormSale.SaleRefTypeComboStore', 
             	 'admission.applicationFormSale.SaleRefComboStore',
             	 'admission.applicationFormSale.ProgramTabGridStore',
             	 'Academia.store.personinfo.common.personalinfo.ParentGuardianStore',
             	 'Academia.store.common.CountryStore','examinationcenters.IsTemplateMappedStore'
            ],

    views: ['admission.applicationFormSale.ApplicationFormSale',
            	 'admission.applicationFormSale.ApplicationFormSaleLayout', 
            	 'admission.applicationFormSale.ApplicantFormDetails',
            	 'admission.applicationFormSale.ApplicantGrid', 
            	 'admission.applicationFormSale.CollectionFormDetails', 
            	 'admission.applicationFormSale.ApplicantDetailsLayout', 
            	 'admission.applicationFormSale.ApplicantRelatives',
            	 'admission.applicationFormSale.AddProgramTabGrid',
            	 'admission.applicationFormSale.AddProgramWindowGrid', 
            	 'admission.applicationFormSale.AddProgramWindow',
            	 'admission.applicationFormSale.SearchApplicantWindow', 
            	 'admission.applicationFormSale.ApplicationFormButtonPanel',
            	 'personinfo.common.PersonCommonWindow',
            	 'personinfo.common.personalinfo.ParentGuardianGrid', 
            	 'personinfo.common.personalinfo.ParentGuardianForm',
                 'personinfo.common.personalinfo.SiblingDetailsGrid', 
                 'personinfo.common.personalinfo.SiblingForm',
                 'common.NestedJsonCombo',
                 'feeandpayment.receipts.MakePaymentWin'
                 ],

    refs: [{
        ref: 'applicationFormSale',
        selector: 'applicationformsale'
    }, {
        ref: 'searchWindow',
        selector: 'searchapplicantwindow[itemId=searchApplicationFormApplicantWindow]'
    }, {
        ref: 'applicantForm',
        selector: 'applicationformsale form[itemId=applicationFormSaleApplicantDetails]'
    }, {
        ref: 'addProgramTabGrid',
        selector: 'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives] grid[itemId=addprogramtabgrid]'
    }, {
        ref: 'applicantRelatives',
        selector: 'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives]'
    }, {
        ref: 'applicantGrid',
        selector: 'applicationformsale grid[itemId=applicantGrid]'
    }, {
        ref: 'addProgramWindow',
        selector: 'addprogramwindow[itemId=addProgramApplicationFormWindow]'
    }, {
        ref: 'addProgramWindowGrid',
        selector: 'addprogramwindow[itemId=addProgramApplicationFormWindow] grid[itemId=addProgramWindowGrid]'
    }, {
        ref: 'collectionFormDetails',
        selector: 'applicationformsale  form[itemId=collectionFormDetails]'
    }, {
        ref: 'applicationFormSaleLayout',
        selector: 'applicationformsalelayout'
    }, {
        ref: 'applicantDetailsLayout',
        selector: 'applicantdetailslayout'
    }, {
        ref: 'applicationFormButtonPanel',
        selector: 'applicationformbuttonpanel[itemId=applicationFormButtonPanel]'
    }, {
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'personParentGuardianForm',
        selector: 'parentguardianform[itemId=applicantFormSaleParentGuardianForm]'
    }, {
    	ref: 'applicantionParentGuardianGrid',
        selector: 'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives] parentguardiangrid[itemId=applicantionParentGuardianGrid]'
    }, {
        ref: 'personSiblingForm',
        selector: 'siblingform[itemId=applicantFormSaleSiblingForm]'
    }, {
    	ref: 'applicantionSiblingDetailsGrid',
        selector: 'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives] siblingdetailsgrid[itemId=applicantionSiblingDetailsGrid]'
    }, {
    	ref: 'makePaymentWindow',
    	selector: 'makepaymentwin'
    }],
    config: {
    	APPLICATION_PERSON_ID :null,
    	//APPLICATION_FORM_SALE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_FORM_SALE_PRIVILEGES'),
    	//APPLICATION_FORM_GENERATE_TOKEN_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_FORM_GENERATE_TOKEN_PRIVILEGES'),
    	//APPLICATION_FORM_SALE_PROGRAM_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_FORM_SALE_PROGRAM_PRIVILEGES'),
    	//APPLICATION_FORM_SALE_PARENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_FORM_SALE_PARENT_PRIVILEGES'),
    	//APPLICATION_FORM_SALE_SIBLING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_FORM_SALE_SIBLING_PRIVILEGES')
    },
    init: function(application) {
        this.control({
            'applicationformsale': {
                beforerender: function(applicationFormSalePanel) {
                	var me=this;
                    var emptyObject = new Object();
                    emptyObject.id = null;
                    var applicationFormSaleJsonData = Ext.encode(emptyObject);
                    if (!isNullOrEmpty(applicationFormSaleJsonData)) {
                        Ext.Ajax.request({
                            type: 'rest',
                            url: SERVERURL.APPLICATION_FORM_SALE_CREATE, //URL-:rest/applicationForm/create
                            jsonData: applicationFormSaleJsonData,
                            method: 'POST',
                            success: function(response, form) {                            	
                                applicationFormSalePanel.setApplicationFormSaleId(response.responseText);
                                var applicationFormSaleLayout = Ext.create('Academia.view.admission.applicationFormSale.ApplicationFormSaleLayout', {
                                    title: getAdmissionTranslation('APPLICATION_FORM_SALE'), //Application Form Sale															
                                    closable: false
                                });
                                var applicantDetailsLayout = Ext.create('Academia.view.admission.applicationFormSale.ApplicantDetailsLayout', {
                                    title: getAdmissionTranslation('APPLICANT_DETAILS'), //Applicant Details																									
                                    closable: false
                                });
                                if (applicationFormSaleLayout) {
                                    applicationFormSalePanel.add(applicationFormSaleLayout);
                                    applicationFormSalePanel.setActiveTab(applicationFormSaleLayout);
                                    me.getApplicationFormButtonPanel().setVisible(false);
                                	me.getCollectionFormDetails().setVisible(false);                                	
                                }
                                if (applicantDetailsLayout) {
                                    applicationFormSalePanel.add(applicantDetailsLayout);
//                                    me.getApplicantForm().down('#backToMainScreen').setVisible(true);
                                    if (!applicationFormSalePanel) {                                    	
                                        applicationFormSalePanel.setActiveTab(applicantDetailsLayout);
                                    }
                                }
                                applicationFormSalePanel.doLayout();
                            },
                            failure: function() {
                                return false;
                            }
                        });
                    }
                }
            },
             
            
            'applicationformbuttonpanel[itemId=applicationFormButtonPanel]': {
                render: function() {
                	var buttonPanel=this.getApplicationFormButtonPanel();
                    this.disableMoreActionPivilegesForGenerateToken(buttonPanel,this.getAPPLICATION_FORM_GENERATE_TOKEN_PERMISSIONS());
                }
            },
            'applicationformsale applicantformdetails[itemId=applicationFormSaleApplicantDetails]  button[itemId=searchButton]': {
                click: function() {
                    var searchWindow = this.getSearchWindow();
                    var applicantForm = this.getApplicantForm();
                    this.onSearchButtonClick(this, searchWindow, applicantForm, 'searchApplicationFormApplicantWindow');
                }
            },

            'applicantformdetails[itemId=applicationFormSaleApplicantDetails] combo[itemId=cmbApplicationType]': {
                select: function(combo, record) {
                    var me = this;
                    var applicantForm = me.getApplicantForm();
                    var selectedApplicationType = combo.getValue(); // record[0].get('name');
                    if (!isNullOrEmpty(selectedApplicationType)) {
                        me.showHideSearchCriteriaFields(selectedApplicationType, applicantForm);
                        me.displayTypeId(applicantForm,selectedApplicationType);
                    }
                }
            },
            
            'applicantformdetails[itemId=applicationFormSaleApplicantDetails] combo': {
                render: function(combo) {
                    combo.getStore().load();
                }
            },

            'applicantformdetails[itemId=applicationFormSaleApplicantDetails] button[itemId=saveApplicantFormDetails]': {
                click: function() {
                    var applicationFormSale = this.getApplicationFormSale();
                    var applicantForm = this.getApplicantForm();
                    var programTabGrid = this.getAddProgramTabGrid();
                    var applicantRelatives = this.getApplicantRelatives();
                    var grid = this.getApplicantGrid();
                    var buttonPanel=this.getApplicationFormButtonPanel();
                    var collectionForm=this.getCollectionFormDetails();
                    var applicationFormSaleId = applicationFormSale.getApplicationFormSaleId();                    
                    this.saveApplicationForm(this, applicantForm, programTabGrid, applicantRelatives, applicationFormSale, applicationFormSaleId, grid,buttonPanel,collectionForm);
                }
            },

            'applicantformdetails[itemId=applicationFormSaleApplicantDetails] button[itemId=cancelApplicationFormDetails]': {
                click: function() {
                    var applicantForm = this.getApplicantForm();
                    applicantForm.getForm().reset();
                    var applicantRelatives = this.getApplicantRelatives();
                    applicantRelatives.setActiveTab(0);
                    Ext.each(applicantRelatives.items.items, function(tab) {
                    	tab.setDisabled(true);                            
                    });
             		
                }
            },
/*
            'applicantformdetails[itemId=applicationFormSaleApplicantDetails] button[itemId=backToMainScreen]': {
                click: function() {
                    var applicationFormSaleLayout=this.getApplicationFormSaleLayout();
                    var applicationFormSalePanel = this.getApplicationFormSale();
                    if(applicationFormSalePanel && applicationFormSaleLayout){
                    	applicationFormSalePanel.setActiveTab(applicationFormSaleLayout);
                    }
                }
            },*/
            
            'searchapplicantwindow[itemId=searchApplicationFormApplicantWindow] button[itemId=cancelBtn]': {
                click: function() {
                    this.getSearchWindow().close();
                }
            },

            'searchapplicantwindow[itemId=searchApplicationFormApplicantWindow] button[itemId=importBtn]': {
                click: function() {
                    var searchWindow = this.getSearchWindow();
                    var applicantForm = this.getApplicantForm();
                    this.resetNameFields(applicantForm);
                    this.onSearchImportButtonClick(this, searchWindow, applicantForm);
                }
            },

            'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives] grid[itemId=addprogramtabgrid]': {
                render: function(grid) {
                    var applicantRelatives = this.getApplicantRelatives();
                    grid.getStore().load({
                        params: {
                            applicationID: applicantRelatives.getApplicationId()
                        }
                    });
                    
                    grid.getStore().on('beforeload', function(store, operation) {
                        var application = applicantRelatives.getApplicationId();
                        store.proxy.extraParams = {
                        		applicationID: application
                        };
                    });
                    this.doAccessControlValidation(grid, this.getAPPLICATION_FORM_SALE_PROGRAM_PERMISSIONS());
                    this.disableMoreActionPivileges(grid,this.getAPPLICATION_FORM_SALE_PROGRAM_PERMISSIONS());
                }
            },

            'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives] grid[itemId=addprogramtabgrid] button[itemId=btnAdd]': {
                click: function() {
                    var window = this.getAddProgramWindow();
                    if (!window) {
                        window = Ext.widget('addprogramwindow', {
                            itemId: 'addProgramApplicationFormWindow'
                        });
                    }
                    window.show();
                }
            },

            'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives] grid[itemId=addprogramtabgrid]  button[itemId=btnDelete]': {
                click: function() {
                    var me = this;
                    var grid = me.getAddProgramTabGrid();
                    var url = SERVERURL.APPLICATION_FORM_SALE_PROGRAM_DELETE; //URL-:rest/applicationProgram/delete
                    if (grid) {
                        me.checkGridRecordSelection(me, grid, 'id', getAdmissionTranslation('DELETE_PROGRAM'), url, getAdmissionTranslation('DELETE_PROGRAM_MSG'));
                    }
                }
            },

            'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives] grid[itemId=addprogramtabgrid] button[itemId=savePriority]': {
                click: function() {
                    var grid = this.getAddProgramTabGrid();
                    this.savePriority(this, grid);
                }
            },
            'addprogramwindow[itemId=addProgramApplicationFormWindow] combo[itemId=cmbPgmGroup]': {
            	afterrender:function(combo){
            		var store = combo.getStore();
            	 	  store.getProxy().api.read = this.getUrlOfStore(store) +'?activeFormSale=true&activeFormSubmission=false';
                      store.load(
          		    	{
                          scope:this,
                             callback: function(records,option,success){
                                 store.commitChanges();
                                 combo.bindStore(store);
                            
                                  if(store.getAt(0))
  	                    			combo.select(store.getAt(0));
                          }
                       });
              	},
                change: function(combo, selectedProgramGroup) {
                    var addProgramWindowGrid = this.getAddProgramWindowGrid();
//                    var selectedProgramGroup = record[0].get('id');
                    var isformSaleSelection=true, isformSubmissionSelection=false,whetherAdmissionOpen =true;
                    this.loadAddProgramGrid(addProgramWindowGrid, selectedProgramGroup,isformSaleSelection,isformSubmissionSelection,whetherAdmissionOpen);
                }
            },
            'addprogramwindow[itemId=addProgramApplicationFormWindow] button[itemId=addProgramBtn]': {
                click: function() {
                	var applicantGrid = this.getApplicantGrid();
                    var programTabGrid = this.getAddProgramTabGrid();
                    var programWindow = this.getAddProgramWindow();
                    var addProgramWindowGrid = this.getAddProgramWindowGrid();
                    var applicantionId = this.getApplicantRelatives().getApplicationId();
                    this.addProgramToApplication(this, programTabGrid, programWindow, addProgramWindowGrid, applicantionId,null,applicantGrid);
                }
            },
            'addprogramwindow[itemId=addProgramApplicationFormWindow] button[itemId=cancelProgramBtn]': {
                click: function() {
                    this.getAddProgramWindow().close();
                }
            },
/*
            'addprogramwindow[itemId=addProgramApplicationFormWindow] grid[itemId=addProgramWindowGrid]': {
                render: function(addProgramWindowGrid) {
                    var addProgramTabGrid = this.getAddProgramTabGrid();
                    var programGroup = addProgramWindowGrid.down('#cmbPgmGroup');
                    this.loadProgramGroupWithGridData(this, programGroup, addProgramWindowGrid, addProgramTabGrid);
                }
            },*/

            'applicationformbuttonpanel[itemId=applicationFormButtonPanel] button[itemId=cancelApplicationFormButton]': {
                click: function() {
                    var me = this;
                    var applicationFormSale = me.getApplicationFormSale();
                    if (applicationFormSale) {
                        var url = SERVERURL.APPLICATION_FORM_SALE_DELETE; //URL-:rest/applicationForm/delete					    	
                        var applicationFormId = applicationFormSale.getApplicationFormSaleId();
                        me.deleteFunction(me, applicationFormId, getAdmissionTranslation('DELETE_APPLICANT_FORM'), url, getAdmissionTranslation('DELETE_APPLICANT_FORM_MSG'), null, applicationFormSale);
                    }
                }
            },
            
            'applicationformbuttonpanel[itemId=applicationFormButtonPanel] button[itemId=makePaymentButton]': {
                click: function() {
                	var me = this;
                    var applicationFormSale = me.getApplicationFormSale();
                    if(applicationFormSale){
                   	 me.openApplicationFeeTab(applicationFormSale, 'applicationfee');
                    }                                                     	                    
                }
            },
                        

            'applicationformbuttonpanel[itemId=applicationFormButtonPanel] button[itemId=assignAppIdButton]': {
                click: function() {
                	 var me = this;
                     var applicationFormSale = me.getApplicationFormSale();
                     if(applicationFormSale){
                    	 me.openAssignApplicationTab(applicationFormSale,'Application form sale');
                     }                                                                                 	                   
                }
            },
            
            'applicationformbuttonpanel[itemId=applicationFormButtonPanel] button[itemId=submitApplicationFormDetails]': {
                click: function() {
                    var APPLICATION_FORM_SALE_STATUS = 'FORM_SALE_TOKEN_GENERATED';
                    var me = this;
                    var collectionForm = me.getCollectionFormDetails();
                    var applicantGrid = me.getApplicantGrid();
                    var applicationFormSale = me.getApplicationFormSale();
                    var applicantForm = this.getApplicantForm();                    
                    var applicantRelatives = this.getApplicantRelatives();
                    var applicationformbuttonpanel = me.getApplicationFormButtonPanel();
                    if (applicantGrid.getStore().data.length == 0) {
                    	showWarningMessage(getCommonTranslation('ALERT'), getAdmissionTranslation('PLEASE_ENTER_APPLICANT_DETAILS')); //Please add at least one applicant form details.
                    } else {
                        if (collectionForm.getForm().isValid()) {
                            var values = collectionForm.getForm().getValues();
                            if (!isEmpty(values)) {
                                var applicationFormSaleId = applicationFormSale.getApplicationFormSaleId();
                                me.submitApplicationForm(me, applicantGrid, applicationFormSale, applicationformbuttonpanel, collectionForm, applicationFormSaleId, values, APPLICATION_FORM_SALE_STATUS,applicantRelatives,applicantForm);
                            }
                        } else {
                        	showWarningMessage(getCommonTranslation('ALERT'), getAdmissionTranslation('ENTER_COLLECTION_DETAILS'));
                        }
                    }
                }
            },

            'applicationformsale grid[itemId=applicantGrid]': {
                render: function(grid) {
                    var applicationFormSalePanel = this.getApplicationFormSale();
                    var applicationFormIdValue = applicationFormSalePanel.getApplicationFormSaleId();
                    if (!isNullOrEmpty(applicationFormIdValue)) {
                        var paramObject = new Object();
                        paramObject.applicationFormId = applicationFormIdValue;                        
                        paramObject.feePlanType=grid.feePlanType;
                        paramObject.stageName=grid.stageName;
                        grid.getStore().load({
                            params: paramObject
                        });
                        
                        grid.getStore().on('beforeload', function(store, operation) {
                        	var applicationFormIdValue = applicationFormSalePanel.getApplicationFormSaleId();                        	                            
                            store.proxy.extraParams = {
                            	applicationFormId: applicationFormIdValue,
                            	feePlanType:grid.feePlanType,
                            	stageName:grid.stageName
                            };
                        });
                    }
                    this.doAccessControlValidation(grid, this.getAPPLICATION_FORM_SALE_PERMISSIONS());
                }
            },
            
            'applicationformsale textfield[name=firstName]': {
            	change: function(firstNameField){
            		this.setPrintNameValue(firstNameField);
            	}
            },
            'applicationformsale textfield[name=middleName]': {
            	change: function(firstNameField){
            		this.setPrintNameValue(firstNameField);
            	}
            },
            'applicationformsale textfield[name=lastName]': {
            	change: function(firstNameField){
            		this.setPrintNameValue(firstNameField);
            	}
            },
            'applicationformsale grid[itemId=applicantGrid] button[itemId=btnAdd]': {
                click: function() {
                	var me=this;
                    var applicantDetailsLayout = this.getApplicantDetailsLayout();
                    var applicationFormSale = this.getApplicationFormSale();
                    var programTabGrid = this.getAddProgramTabGrid();
                    if (applicationFormSale && applicantDetailsLayout) {
                        applicationFormSale.setActiveTab(applicantDetailsLayout);
                        var applicantForm = me.getApplicantForm();
                        if(applicantForm){                        	
                        	var cancelApplicationFormDetails = applicantForm.down('#cancelApplicationFormDetails');
                        	var cmbApplicationType = applicantForm.down('#cmbApplicationType');
                        	var searchComponent=applicantForm.down('#searchComponent');  
                        	var resetBtn=applicantForm.down('#gradeMasterResetButtonId');    
                        	searchComponent.setDisabled(false);                        	
                        	cmbApplicationType.setDisabled(false);
                        	resetBtn.setDisabled(false);
                        	toggleReadOnlyFormItems(applicantForm.getForm(),false);
                        	cancelApplicationFormDetails.fireEvent('click');
                        	cmbApplicationType.fireEvent('select',cmbApplicationType);
                        	if(programTabGrid){
                        		programTabGrid.getStore().load({
                                    params: {
                                        applicationID: ''
                                    }
                                });
                        	}                        	
                        }                            
                    }
                }
            },

            'applicationformsale grid[itemId=applicantGrid] button[itemId=btnDelete]': {
                click: function() {
                    var me = this;
                    var grid = me.getApplicantGrid();
                    var url = SERVERURL.APPLICATION_FORM_SALE_APPLICANT_DELETE; //URL-:rest/application/delete
                    if (grid) {
                        me.checkGridRecordSelection(me, grid, 'id', getAdmissionTranslation('DELETE_APPLICANT'), url, getAdmissionTranslation('DELETE_APPLICANT_MSG'));
                    }
                }
            },

            'applicationformsale grid[itemId=applicantGrid] gridview': {
                expandbody: function(rowNode, record, expandRow, eOpts) {
                	expandRow.style.height = '225px';
                    var applicantGrid = this.getApplicantGrid();
                    var expander = applicantGrid.getPlugin('applicantRowExpander');
                    var recordId = record.get('id');
                    var submitURL=SERVERURL.FEES_PAYMENTS_APPLICATION_FEE_GRID_API; //URL -:'rest/feePlan/findAllFeeAdmissionListingDetails'                    
                    if (!isNullOrEmpty(recordId)) {
                    	if(!isNullOrEmpty(submitURL)){
            				submitURL=submitURL.concat("?stageName="+applicantGrid.stageName+"&feePlanType="+applicantGrid.feePlanType+"&applicationId="+recordId);            			
                        }                        
                        Ext.Ajax.request({
                        	url: submitURL,
                            method: 'GET',
                            success: function(result, request) {
                                var jsonArrayData = eval("(" + result.responseText + ")");
                                var objectArray = new Array();
                                if (jsonArrayData.rows.length > 0) {
                                    for (var count = 0; count < jsonArrayData.rows.length; count++) {
                                        var recordData = jsonArrayData.rows[count];
                                        var object = new Object();
                                        if (!isEmpty(recordData)) {
                                            object.academy = recordData.academyName;
                                            object.location = recordData.locationName;
                                            object.program = recordData.programNameToBePrint;
                                            object.batch = recordData.batchName;
                                            object.seatType = recordData.seatName;
                                            object.feeAmount = recordData.feeAmount;
                                            objectArray.push(object);
                                        }
                                    }                                    
                                    expander.rowBodyTpl.overwrite(expandRow, objectArray);
                                } else {
                                    expander.rowBodyTpl.applyTemplate('<div>No Record To display</div>');
                                }
                            },
                            failure: function(result, request) {
                            	if(result.status!=401) {
                            		Ext.MessageBox.alert('Failed', result.responseText);
                            	}
                                return false;
                            }
                        });
                    }
                    return true;
                }
            },

            'applicationformsale  form[itemId=collectionFormDetails] combo[itemId=cmbRef]': {
                select: function(combo, record) {
                    var saleRefTypeValue = record[0].get('name'),applicationFormSale=combo.up('applicationformsale'),
                    	collectionFormDetails=applicationFormSale.down('#collectionFormDetails');
                    
                    var applicationFormIdValue = applicationFormSale.getApplicationFormSaleId();
                    	
                    var saleRefCombo = collectionFormDetails.down('#cmbSaleRef');
                    if (saleRefCombo) {
                        saleRefCombo.getStore().load({
                            params: {
                                saleRefType: saleRefTypeValue,
                                applicationFormId: applicationFormIdValue
                            }
                        });
                        saleRefCombo.clearValue();
                    }
                    var form = combo.up('form').getForm().getFields();
                    Ext.each(form.items,function(item){
                    	if(item.itemId !== 'hiddenId' && item.itemId !== 'versionId'&& item.itemId !== 'appFormSaleDate' && item.itemId !== 'cmbCollectedBy'
                    	&& item.itemId !== 'cmbRef' && item.itemId !== 'cmbSaleRef'){
                    		item.reset();
                    	}
                    });
                    
                    this.changeAddressType(saleRefTypeValue,collectionFormDetails);
                    
                }
            },
            'applicationformsale  form[itemId=collectionFormDetails] combo[itemId=cmbSaleRef]': {
                select: function(combo, record) {
                	var collectionFormDetails=combo.up('applicationformsale').down('#collectionFormDetails');
                    if (!isEmpty(record[0].data)) {
                        collectionFormDetails.getForm().setValues(record[0].data);
                        this.setAPPLICATION_PERSON_ID(record[0].get('personId'));
                    }
                    this.changeAddressType(collectionFormDetails.down('#cmbRef').value,collectionFormDetails);
                }
            },
            'applicationformsale  form[itemId=collectionFormDetails] button[itemId=manageAddress]': {
            	click:function(){
            		this.openApplicantAddressWindow();
            	}
            },
            /**
             * Parent Guardian Details
             * 
             */

            'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives] parentguardiangrid[itemId=applicantionParentGuardianGrid]': {
            	render: function() {
            		var grid = this.getApplicantionParentGuardianGrid();
            		var applicantRelatives = this.getApplicantRelatives();
                    this.loadGridStore(grid, applicantRelatives, SERVERURL.APPLICANT_PARENT_AND_GUARDIAN_DETAILS);
                    this.doAccessControlValidation(grid, this.getAPPLICATION_FORM_SALE_PARENT_PERMISSIONS()); 
                }
            },
            'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives] parentguardiangrid[itemId=applicantionParentGuardianGrid] button[itemId=btnAdd]': {
            	click: function() {
            		var formWindow = this.getPersonCommonWindow();
            		this.showPersonCommonWindow(formWindow, 'PARENT_GUARDIAN', 'applicantFormSaleParentGuardianForm');
                }
            },
            'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives] parentguardiangrid[itemId=applicantionParentGuardianGrid] button[itemId=btnEdit]': {
                click: this.editApplicantParentGuardianFormWindow
            },
            'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives] parentguardiangrid[itemId=applicantionParentGuardianGrid] button[itemId=btnView]': {
                click: this.viewApplicantParentGuardianFormWindow
            },
            'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives] parentguardiangrid[itemId=applicantionParentGuardianGrid] button[itemId=btnDelete]': {
                click: this.deleteApplicantParentGuardianRecord
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantFormSaleParentGuardianForm] button[itemId=submitButtonId]': {
                click: this.saveApplicantParentGuardian
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantFormSaleParentGuardianForm] button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantFormSaleParentGuardianForm] textfield[itemId=employeeIdField]': {
                change: function(){
                	var parentGuardianForm = this.getPersonParentGuardianForm();
                	this.onChangeDisabledInnerParentGuardianForm(parentGuardianForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantFormSaleParentGuardianForm] button[itemId=searchButtonId]': {
            	click: function(){
                	var parentGuardianForm = this.getPersonParentGuardianForm();
                	this.validateEmployeeOrgId(parentGuardianForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantFormSaleParentGuardianForm] checkboxfield[itemId=isEmployeeOrganisation]': {
                change: function(employeeOrg, checkValue, oldValue, eOpts) {
                	var parentGuardianForm = this.getPersonParentGuardianForm();
                    this.onChangeEmployeeOrgField(parentGuardianForm, checkValue);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantFormSaleParentGuardianForm]': {
            	render: function() {
            		var parentGuardianForm = this.getPersonParentGuardianForm();
                	this.onRenderHideInnerParentGuardianFormField(parentGuardianForm);
                	this.getPersonCommonWindow().doLayout();
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantFormSaleParentGuardianForm] combo[itemId=relationShipField]': {
                afterrender: function(combo, eOpts) {
                    this.onRenderParentGuardianRelationShipCombo(combo);
                },
                select : function(combo, record) {
                	var parentGuardianForm = this.getPersonParentGuardianForm();
                	if(combo.getValue() === 'LOCAL_GUARDIAN' || combo.getValue() === 'GUARDIAN' ){
                	    parentGuardianForm.down('#genderCombo').setReadOnly(false);
                	    parentGuardianForm.down('#maritalStatusCombo').setReadOnly(false);
                	}else{
                		parentGuardianForm.down('#genderCombo').setReadOnly(true);
                	    parentGuardianForm.down('#maritalStatusCombo').setReadOnly(true);
                	}
                	this.onSelectRelationshipComboValue(combo, '#applicantionParentGuardianGrid', parentGuardianForm);
                }
            },
            
            /**
             *  Sibling form details
             */
            
            'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives] siblingdetailsgrid[itemId=applicantionSiblingDetailsGrid]': {
            	render: function() {
            		var grid = this.getApplicantionSiblingDetailsGrid();
            		var applicantRelatives = this.getApplicantRelatives();
                    this.loadGridStore(grid, applicantRelatives, SERVERURL.APPLICANT_SIBLING_DETAILS);
                    this.doAccessControlValidation(grid, this.getAPPLICATION_FORM_SALE_SIBLING_PERMISSIONS()); 
                }
            },
            'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives] siblingdetailsgrid[itemId=applicantionSiblingDetailsGrid] button[itemId=btnAdd]': {
            	click: function() {
            		var formWindow = this.getPersonCommonWindow();
                    this.showPersonCommonWindow(formWindow, 'SIBLING', 'applicantFormSaleSiblingForm');
                }
            },
            'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives] siblingdetailsgrid[itemId=applicantionSiblingDetailsGrid] button[itemId=btnEdit]': {
                click: this.editApplicantSiblingFormWindow
            },
            'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives] siblingdetailsgrid[itemId=applicantionSiblingDetailsGrid] button[itemId=btnView]': {
                click: this.viewApplicantSiblingFormWindow
            },
            'applicationformsale tabpanel[itemId=applicationFormSaleApplicantRelatives] siblingdetailsgrid[itemId=applicantionSiblingDetailsGrid] button[itemId=btnDelete]': {
                click: this.deleteApplicantSiblingRecord
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantFormSaleSiblingForm]': {
                render: function(siblingForm) {
                	this.onRenderHideInnerSiblingFormField(siblingForm);
                	this.getPersonCommonWindow().doLayout();
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantFormSaleSiblingForm] combo[itemId=relationShipField]': {
                render: function(combo, eOpts) {
                    this.onRenderSiblingRelationShipCombo(combo);
                },
                select : function(combo, record) {
                	var siblingForm = this.getPersonSiblingForm();
                	this.onSelectSiblingRelationshipComboValue(combo, '#applicantFormSaleSiblingForm', siblingForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantFormSaleSiblingForm] textfield[itemId=siblingStudentId]': {
            	change: function(field, newValue, oldValue, eOpts){
                	var siblingForm = this.getPersonSiblingForm();
                	this.onChangeResetInnerSiblingForm(siblingForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantFormSaleSiblingForm] button[itemId=searchButtonId]': {
                click: function(){
                	var siblingForm = this.getPersonSiblingForm();
                	this.validateSiblingStudentId(siblingForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantFormSaleSiblingForm] button[itemId=submitButtonId]': {
            	click: this.saveApplicantSibling
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantFormSaleSiblingForm] button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            },
            'makepaymentwin[itemId=submissionFeeMakePayment] button[itemId=SubmitBtn]': {
            	click: function(button) {
            		var print = false;
            		this.createBill(button,print);
            	}
            },
            'makepaymentwin[itemId=submissionFeeMakePayment] button[itemId=SubmitAndPrintMakePaymentBtn]': {
            	click: function(button) {
            		var print = true;
            		this.createBill(button,print);
            	}
            },
            /* comment out this code bcz changed functionality of stage fee  
             * 'makepaymentwin[itemId=stageFeeMakePayment] button[itemId=SubmitBtn]': {
            	click: function(button) {
            		var print = false;
            		this.createBill(button,print);
            	}
            },
            'makepaymentwin[itemId=stageFeeMakePayment] button[itemId=SubmitAndPrintMakePaymentBtn]': {
            	click: function(button) {
            		var print = true;
            		this.createBill(button,print);
            	}
            },*/
            'makepaymentwin[itemId=applicationFeeMakePayment] button[itemId=SubmitBtn]': {
            	click: function(button) {
            		var print = false;
            		this.createBill(button,print);
            	}
            },
            'makepaymentwin[itemId=applicationFeeMakePayment] button[itemId=SubmitAndPrintMakePaymentBtn]': {
            	click: function(button) {
            		var print = true;
            		this.createBill(button,print);
            	}
            },
            'makepaymentwin[itemId=refundMakePayment] button[itemId=SubmitBtn]': {
            	click: function(button) {
            		var print = false;
            		this.createBill(button,print);
            	}
            },
            'makepaymentwin[itemId=refundMakePayment] button[itemId=SubmitAndPrintMakePaymentBtn]': {
            	click: function(button) {
            		var print = true;
            		this.createBill(button,print);
            	}
            },
            'makepaymentwin[itemId=assignApplicationMakePayment] button[itemId=SubmitBtn]': {
            	click: function(button) {
            		var print = false;
            		this.createBill(button,print);
            	}
            },
            'makepaymentwin[itemId=assignApplicationMakePayment] button[itemId=SubmitAndPrintMakePaymentBtn]': {
            	click: function(button) {
            		var print = true;
            		this.createBill(button,print);
            	}
            },
            'addressFormWindow#formSaleAddressWindow button#saveButtonId': {
                click: function(button){
                	this.saveApplicantAddress(button)
                }
            }
        });
    },
    
    changeAddressType :function(selRefType,collectionFormDetails){
    	if(selRefType === 'APPLICANT'){
    		collectionFormDetails.down('#manageAddress').setVisible(true);
    		collectionFormDetails.down('#address').setVisible(false);
    	}else{
    		collectionFormDetails.down('#manageAddress').setVisible(false);
    		collectionFormDetails.down('#address').setVisible(true);
    	}
    },
    
    saveApplicantAddress : function(button){
        var submitUrl, methodType, successMessage,window= button.up('window');
          var address = new Academia.model.organization.Address(),this$=this;
          var form = window.down('addressfieldsform').getForm(), values = form.getValues();
          var id = form.findField('id').getSubmitValue();
          form.updateRecord(address);
          address.set('country', this$.getNestedObject(values.country));
          address.set('parentCountryRegion', this$.getNestedObject(values.parentCountryRegion));
          address.set('countryRegion', this$.getNestedObject(values.countryRegion));
          address.set('city', this$.getNestedObject(values.city));
          
          var addressType=values.addressType;
          if(!addressType)
        	  addressType= CONSTANTS.PERSON_CURRENT;
          
          address.set('addressType', this$.getNestedObject(addressType));
          
          if (isNullOrEmpty(id)) {
          	methodType = 'POST';
              submitUrl = SERVERURL.APPLICANT_PERSON_ADDRESS_ADD;
              successMessage = getCommonTranslation('ADDRESS_ADD_SUCCESS');
          } else {
          	methodType = 'PUT';
              submitUrl = SERVERURL.APPLICANT_PERSON_ADDRESS_UPDATE;
              successMessage = getCommonTranslation('ADDRESS_UPDATE_SUCCESS');
          }
          var jsonObj = new Object();
          
          jsonObj.address = address.data;
          jsonObj.applicantPersonId =  this.getAPPLICATION_PERSON_ID();
          jsonObj.isDeleted = false;
          //jsonObj.addressType = this$.getAddressController().getIdValueJson(values.addressType);
          jsonObj.isPrimary = true;
          jsonObj.id = address.get('id');
          jsonObj.type = 'SELF_ADDRESS';

          var formData = Ext.encode(jsonObj);
          this$.applyWindowMask(); 
          Ext.Ajax.request({
              type: 'rest',
              url: submitUrl,
              jsonData: formData,
              method: methodType,
              success: function(form, action) {
              	this$.hideWindowMask();
                  showSuccessMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), successMessage);
                  window.close();
              }
          });
    	
    },

    openApplicantAddressWindow : function(){

        var applicantPersonId = this.getAPPLICATION_PERSON_ID(); url= SERVERURL.APPLICANT_GET_PERSON_ADDRESS_DETAILS;
        if(applicantPersonId){
            var addressFormWindow = Ext.widget('addressFormWindow',{
            	itemId:'formSaleAddressWindow'
            });
            addressFormWindow.show();
	    	var params = {
	    			personId : applicantPersonId	
	    	}; 
	    	
	    	var addressdetailsform=addressFormWindow.down('form[itemId=addressfieldsform]');
	        
	    	this.sendGetAjaxRequest(url, 'GET', params, function(option, success, response) {
	        	if(success){
	        		data = Ext.decode(response.responseText);
	        		if(data && data.length>0){
	            		data = data[0].address;
	            			var addressController= Academia.app.getController('organization.AddressController');
	            			addressController.setAddressFormData(data,addressdetailsform);
	        		}
	        	}
	            
	        });
        }else{  
        	showWarningMessage(getAdmissionTranslation('APPLICANT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    	
    },
    
    createBill: function(button,print) {
    	var form = button.up('form');
    	var window = button.up('window');
    	var formValues = form.getValues();
    	var applicantObject = new Object();
    	applicantObject.id = formValues.id;
    	formValues.raiseBillType =  'P_AND_C_FEE';
    	formValues.applicant = applicantObject;
    	
    	var recieptForObj = new Object();
    	recieptForObj.id = 2;
    	recieptForObj.value = "APPLICANT";
    	formValues.receiptFor = recieptForObj;
    	
    	var paymentMode = new Object();
    	paymentMode.id = formValues.paymentMode;
    	
    	var instrumentBank = new Object();
    	if(isNullOrEmpty(formValues.instrumentBank)) {
    	    instrumentBank.id= null;
    	} else {
    	    instrumentBank.id = formValues.instrumentBank;
    	}
    	
    	if(formValues.voucherMode === 'BANK') {
	      	var receiptPaymentInstrumentsArray = new Array();
	      	var receiptPaymentInstruments = new Object();
	    	receiptPaymentInstruments.paymentMode = paymentMode;
	    	receiptPaymentInstruments.instrumentBank = instrumentBank;
	    	receiptPaymentInstruments.instrumentNo = formValues.instrumentNo;
	        receiptPaymentInstruments.instrumentDate = formValues.instrumentDate;
	    	receiptPaymentInstruments.amount = formValues.amount;
	    	
	    	delete formValues.instrumentDate;
	    	delete formValues.amount;
	    	
	    	receiptPaymentInstrumentsArray.push(receiptPaymentInstruments);
	    	formValues.receiptPaymentInstruments = receiptPaymentInstrumentsArray;
    	}
    	
    	if(isNullOrEmpty(formValues.depositedBank)) {
    		formValues.depositedBank = null;
    	};
    	
    	if(isNullOrEmpty(formValues.depositedCash)) {
    		formValues.depositedCash = null;
    	};
    	
    	delete formValues.instrumentNo;
    	delete formValues.depositedLedger;
    	delete formValues.id;
    	delete formValues.paymentMode;
    	delete formValues.instrumentBank;
    	delete formValues.instrumentAmount;
    	if(formValues.customData!=undefined){
    		delete formValues.customData;
    	}
    	var submitData = Ext.encode(formValues); 
    	this$= this;
    	  //Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	this$.applyWindowMask();
    	window.down('#SubmitBtn').setDisabled(true);
    	window.down('#SubmitAndPrintMakePaymentBtn').setDisabled(true);
    	this.sendSaveAjaxRequest(SERVERURL.RECEIPT_HEADER_SAVEANDCREATEBILL, 'POST', submitData, function(opt,success,response){
		  	if(success){
		  		//Ext.getBody().unmask();
		  		this$.hideWindowMask();
		  		//Call for makePayment as per nita.
		  		var serverUrl = SERVERURL.ASSIGN_APPLICATION_ID_MAKE_PAYMENT;
		  		serverUrl = serverUrl.concat('?applicationId='+formValues.applicant.id);
		  		this$.sendSaveAjaxRequest(serverUrl, 'POST', null, function(opt,success,response){});
		  		window.close();
		  		showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_ADD_SUCCESS')); //No search result found
		  		if(print==true){
		  			this$.getPrintGenerateBill(response.responseText);
		  		}
		  	}
		  	
	  	});
    },
    
    /**
     * View applicant parent guardian history form window
     */

    viewApplicantParentGuardianFormWindow: function() {
    	var this$ = this;
    	var grid = this$.getApplicantionParentGuardianGrid();
        if (grid.getSelectionModel().getCount() > 0) {
        	var formWindow = this$.getPersonCommonWindow();
        	this$.mixins.PersonInfoController.showPersonCommonWindow(formWindow, 'PARENT_GUARDIAN', 'applicantFormSaleParentGuardianForm');
        	var parentGuardianForm = this.getPersonParentGuardianForm();
        	this$.mixins.PersonInfoController.viewParentGuardianFormWindow(grid, parentGuardianForm, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_FORM_DETAILS);
        } else {
            showWarningMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * edit applicant parent guardian history form window
     */
    editApplicantParentGuardianFormWindow: function() {

    	var this$ = this;
    	var grid = this$.getApplicantionParentGuardianGrid();
        if (grid.getSelectionModel().getCount() > 0) {
        	var formWindow = this$.getPersonCommonWindow();
        	this$.mixins.PersonInfoController.showPersonCommonWindow(formWindow, 'PARENT_GUARDIAN', 'applicantFormSaleParentGuardianForm');
        	var parentGuardianForm = this.getPersonParentGuardianForm();
        	this$.mixins.PersonInfoController.editParentGuardianFormWindow(grid, parentGuardianForm, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_FORM_DETAILS);
        } else {
            showWarningMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * delete applicant parent guardian history form window
     */
    deleteApplicantParentGuardianRecord: function() {
    	var this$ = this;
    	var grid = this$.getApplicantionParentGuardianGrid();
        this$.mixins.PersonInfoController.deleteParentGuardianRecord(grid, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_DELETE);
    },
    /**
     * save applicant parent guardian history form window
     */
    saveApplicantParentGuardian: function() {
    	
    	var this$ = this;
    	var applicantRelatives = this.getApplicantRelatives();
		var personId = applicantRelatives.getPersonId();
    	var grid = this$.getApplicantionParentGuardianGrid();
        var personObj = {
        		id : personId
        };//this$.getPersonObj();
        var parentGuardianForm = this.getPersonParentGuardianForm();
        var personCommonWindow = this$.getPersonCommonWindow();
        this$.mixins.PersonInfoController.saveParentGuardian('APPLICANT' ,grid, personCommonWindow, parentGuardianForm, personObj, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_ADD, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_UPDATE);

    },
    
    /**
     * View applicant sibling history form window
     */

    viewApplicantSiblingFormWindow: function() {
        var this$ = this;
        var grid = this$.getApplicantionSiblingDetailsGrid();
        if (grid.getSelectionModel().getCount() > 0) {
        	var formWindow = this$.getPersonCommonWindow();
        	this$.mixins.PersonInfoController.showPersonCommonWindow(formWindow, 'SIBLING', 'applicantFormSaleSiblingForm');
        	var form = this$.getPersonSiblingForm();
        	this$.mixins.PersonInfoController.viewSiblingFormWindow(grid, form, SERVERURL.APPLICANT_EDIT_SIBLING_DETAILS);
        } else {
            showWarningMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
        
    },
    /**
     * edit applicant sibling history form window
     */
    editApplicantSiblingFormWindow: function() {

    	var this$ = this;
    	var grid = this$.getApplicantionSiblingDetailsGrid();
        if (grid.getSelectionModel().getCount() > 0) {
        	var formWindow = this$.getPersonCommonWindow();
        	this$.mixins.PersonInfoController.showPersonCommonWindow(formWindow, 'SIBLING', 'applicantFormSaleSiblingForm');
        	var form = this$.getPersonSiblingForm();
        	this$.mixins.PersonInfoController.editSiblingFormWindow(grid, form, SERVERURL.APPLICANT_EDIT_SIBLING_DETAILS);
        } else {
            showWarningMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
       
    },
    /**
     * delete applicant sibling history form window
     */
    deleteApplicantSiblingRecord: function() {

    	var this$ = this;
    	var grid = this$.getApplicantionSiblingDetailsGrid();
        this$.mixins.PersonInfoController.deleteSiblingRecord(grid, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_DELETE);
    },
    /**
     * save applicant sibling history form window
     */
    saveApplicantSibling: function() {

    	var this$ = this;
    	var applicantRelatives = this.getApplicantRelatives();
		var personId = applicantRelatives.getPersonId();
    	var grid = this$.getApplicantionSiblingDetailsGrid();
        var personObj = {
        		id : personId
        };
        var siblingForm = this$.getPersonSiblingForm();
        var personCommonWindow = this$.getPersonCommonWindow();
        this$.mixins.PersonInfoController.saveSibling('APPLICANT', grid, personCommonWindow, siblingForm, personObj, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_ADD, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_UPDATE);
    },
    /**
     * @author Pravin.Surve
     * This function is to enable update priority button
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
   		var updateButton = gridReference.down("#savePriority");//itemId of update button
       	
   		updateButton.setVisible(false);
       	 
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'UPDATEPRIORITY') {
           		if(!isNullOrEmpty(updateButton)){
           			updateButton.setVisible(true);//enable more action button
           		}        		
           	}
       	});
     },
    //***************************************************************
     disableMoreActionPivilegesForGenerateToken: function(buttonPanel,permissionsMap) {
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        var submitApplicationFormDetails = buttonPanel.down('#submitApplicationFormDetails');
   		var makePaymentButton = buttonPanel.down("#makePaymentButton");//itemId of update button
   		var assignAppIdButton = buttonPanel.down("#assignAppIdButton");
   		var deleteButton = buttonPanel.down("#cancelApplicationFormButton");
   		
   		submitApplicationFormDetails.setVisible(false);
   		makePaymentButton.setVisible(false);
   		assignAppIdButton.setVisible(false);
   		deleteButton.setVisible(false);
   		
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'SUBMITANDGENERATETOKEN') {
           		if(!isNullOrEmpty(submitApplicationFormDetails)){
           			submitApplicationFormDetails.setVisible(true);//enable more action button
           		}        		
           	}
       		if (privilege === 'ASSIGNAPPLID') {
           		if(!isNullOrEmpty(makePaymentButton)){
           			assignAppIdButton.setVisible(true);//enable more action button
           		}        		
           	}
       		if (privilege === 'MAKEPAYMENT') {
           		if(!isNullOrEmpty(assignAppIdButton)){
           			makePaymentButton.setVisible(true);//enable more action button
           		}        		
           	}
       		if (privilege === 'DELETE') {
           		if(!isNullOrEmpty(deleteButton)){
           			deleteButton.setVisible(true);//enable more action button
           		}        		
           	}
       	});
     },
     //**************************************************************************************
     /**
 	 * SET the print name value when user entered first, middle and lastname.
 	 */
     setPrintNameValue:function(textfield){
     	var form = textfield.up('form');
     	var getForm=form.getForm();
     	var firstName = getForm.findField('firstName').getValue();
     	var middleName = getForm.findField('middleName').getValue();
     	var lastName = getForm.findField('lastName').getValue();
     	
     	var printName=null;
     	if(isNullOrEmpty(middleName)){
     		printName =firstName+" "+lastName;
     	}else{
     		printName =firstName+" "+middleName+" "+lastName ;
     	}
     	printName=printName.trim();
     	
     	var task = new Ext.util.DelayedTask(function(){
     	if(!isNullOrEmpty(printName)){
     		getForm.findField('printName').setValue(printName.replace(/ +/g, " "));
         	getForm.findField('shortName').setValue(printName.replace(/ +/g, " "));
     	}
 			});
     	task.delay(50);

     },
     /**
      * get print for make payment window
      */
     getPrintGenerateBill : function(id){
    	 var fileType = 'pdf';
    	 var $this = this;
     	var user=$this.getCurrentlyLoggedInUser();
     	var code ="MANAGE_RECEIPT_SETTLEMENT_CODE";
     	var reportParams =new Object();
     	reportParams.userId=user.code;
     	reportParams.ids=String(id); // convert int into string
     	var reportTitle=getFeeAndPaymentCommonTranslation('MANAGE_RECEIPT_JASPER_TITLE');
     	var exportUrl = SERVERURL.MANAGE_RECEIPT_SETTLEMENT_PDF;
     	
     	  var store=$this.getStore('examinationcenters.IsTemplateMappedStore');
     	    store.getProxy().extraParams={
     	    	code:code
     	    };
     	    store.load({
     	    	callback:function(rec,obj,success){
     	    		if(obj.response.responseText=="true"){
     	    			$this.exportJRXMLReport(code,reportParams,reportTitle,fileType,exportUrl); 
     	    		}else{
     	    			showWarningMessage(getCommonTranslation('ALERT'),getTranslation('TEMPLATE_MAPPING_ERROR'));
     	    		}
     			}
     	   });
     }
});
