/**
 * This controller is used for New Application Owner Setup
 * @author Amit Gupta
 * FIXME: [AKR] Extend the BASE CONTROLLER
 */
Ext.define('Academia.controller.admission.applicationOwnerSetup.ApplicationOwnerSetupController', {
	extend: 'Academia.controller.base.BaseController',

	models: [],
	stores: ['admission.applicationOwnerSetup.StoAdmApplicationOwnerMappingGridStore','feeandpayment.reports.InstrumentReportUserFindAllStore',
		'common.AcademyLocationByName','feeandpayment.AcademyLocationFeeMappingList','feeandpayment.ALProgramList','feeandpayment.ALProgramSearchCombo',
		'feeandpayment.ALProgramBatchList','feeandpayment.ALProgramBatchSearchCombo','feeandpayment.ALProgramBatchSeatTypeList','admission.applicationOwnerSetup.StoAdmAppOwnerUserFindAllStore'],

		views: ['admission.applicationOwnerSetup.StcAdmApplicationOwnerSetupMapping','admission.applicationOwnerSetup.StcAdmTabApplicationOwnerSetupMapping',
			'admission.applicationOwnerSetup.VWAdmApplicationOwnerSetupResultGrid','admission.applicationOwnerSetup.StcAdmAddAppOwnerMappingTab',
			'admission.applicationOwnerSetup.StcAdmAppOwnerWithProgramBatchSeatMap','admission.applicationOwnerSetup.VWAdmAppOwnerUserIdTabForm',
			'admission.applicationOwnerSetup.VWAdmAppOwnerFacultyCampusGrid','admission.applicationOwnerSetup.VWAdmAppOwnerSetupProgressTracker',
			'admission.applicationOwnerSetup.VWAdmAppOwnerProgramMapGrid','admission.applicationOwnerSetup.VWAdmAppOwnerProgramBatchMapGrid',
			'admission.applicationOwnerSetup.VWAdmAppOwnerProgramBatchSeatMapGrid','Academia.view.admission.applicationOwnerSetup.StcAdmEditWindow'],

			refs: [{
				ref: 'contentpanel',
				selector: 'contentpanel'
			},{
				ref: 'stcadmapplicationownersetupmapping',
				selector: 'stcadmapplicationownersetupmapping'
			},{
				ref: 'stcadmtabapplicationownersetupmapping',
				selector: 'stcadmtabapplicationownersetupmapping'
			},{
				ref: 'vwadmapplicationownersetupresultgrid',
				selector: 'vwadmapplicationownersetupresultgrid'
			},{
				ref: 'vwadmappowneruseridtabform',
				selector: 'vwadmappowneruseridtabform'
			},{
				ref: 'stcadmappownerwithprogrambatchseatmap',
				selector: 'stcadmappownerwithprogrambatchseatmap'
			},{
				ref: 'vwadmappownerfacultycampusgrid',
				selector: 'vwadmappownerfacultycampusgrid'
			},{
				ref:'vwadmappownersetupprogresstracker',
				selector:'vwadmappownersetupprogresstracker'
			},{
				ref:'stcadmaddappownermappingtab',
				selector:'stcadmaddappownermappingtab'
			},{
				ref:'vwadmappownerprogrammapgrid',
				selector:'vwadmappownerprogrammapgrid'
			},{
				ref:'vwadmappownerprogrambatchmapgrid',
				selector:'vwadmappownerprogrambatchmapgrid'
			},{
				ref:'vwadmappownerprogrambatchseatmapgrid',
				selector:'vwadmappownerprogrambatchseatmapgrid'
			},{
				ref:'stcadmeditwindow',
				selector:'stcadmeditwindow'
			}],
			config: {
				APPLICANT_OWNER_SETUP_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_OWNER_SETUP_PRIVILEGES')
			},
			init: function(application) {
				this.control({
					'vwadmapplicationownersetupresultgrid': {
						render: function(grid) {
							this.DisableApplicatonOwnerSetupPrivileges(grid, this.getAPPLICANT_OWNER_SETUP_PERMISSIONS());
							
							grid.getStore().load();
						},
						afterrender:function(grid){
		    				 var contentpanel = this.getContentpanel();
		    				 var structure = grid.up('stcadmtabapplicationownersetupmapping');
		    				 this.getGridHeaderFreeze(grid,structure);
		    			 }
					},
					'vwadmapplicationownersetupresultgrid button[itemId=admBtnAddAppOwnerItemId]':{
						click:this.openAdmAddAppOwnerMappingTab
					},
					'vwadmappowneruseridtabform button#admBtnNextForm':{
						click:function(btn){
							this.admUserFormNextEventAppOwner(btn);
						}
					},
					'vwadmappowneruseridtabform button#admBtnUserComboResetForm':{
						click:function(btn){
							btn.up('vwadmappowneruseridtabform').getForm().reset();
						}
					},
					'vwadmappownerfacultycampusgrid customcombobox#admFacultyCampusSearchComboItemId' : {
						select:function(obj, record){
							var $this = this;
							$this.getVwadmappownerfacultycampusgrid().getStore().clearFilter();
							$this.getVwadmappownerfacultycampusgrid().getStore().filter({property: 'id',
								value: record[0].get('id'),
								exactMatch: true,
								caseSensitive: true});
						}
					},
					'vwadmappownerfacultycampusgrid button#admNextBtnFacultyCampusItemId':{
						click:function(btn){
							this.admFaclutyCampusNextEventAppOwner(btn);
						}
					},
					'vwadmappownerprogrammapgrid customcombobox#admProgramSearchAppOwnerComboItemId' : {
						select:function(obj, record){
							this.getVwadmappownerprogrammapgrid().getStore().clearFilter();
							this.getVwadmappownerprogrammapgrid().getStore().filter({property: 'programId',
								value: record[0].get('id'),
								exactMatch: true,
								caseSensitive: true});
						}
					},
					'vwadmappownerprogrammapgrid button#admProgramNextButtonItemId':{
						click:function(btn){
							this.admAppOwnerProgramMapNextEvent(btn);
						}

					},
					'vwadmappownerprogrambatchmapgrid button#admProgramBatchNextButtonItemId':{
						click:function(btn){
							this.admAppOwnerProgramBatchMapNextEvent(btn);
						}
					},
					'vwadmappownerprogrambatchmapgrid customcombobox#admPBSAppOwnerComboItemId' :{
						select:function(obj, record){
							this.getVwadmappownerprogrambatchmapgrid().getStore().clearFilter();
							this.getVwadmappownerprogrambatchmapgrid().getStore().filter({property: 'batchId',
								value: record[0].get('id'),
								exactMatch: true,
								caseSensitive: true});
						}
					},
					'vwadmappownerfacultycampusgrid button#admSubmitBtnFacultyCampusItemId':{
						click:function(btn){
							this.admAppOwnerMappingSubmitAction(btn);
						}
					},
					'vwadmappownerprogrammapgrid button#admProgramSubmitAppOwnerItemId':{
						click:function(btn){
							this.admAppOwnerMappingSubmitAction(btn);
						}
					},
					'vwadmappownerprogrambatchmapgrid button#admProgramBatchSubmitAppOwnerItemId':{
						click:function(btn){
							this.admAppOwnerMappingSubmitAction(btn);
						}
					},
					'vwadmappownerprogrambatchseatmapgrid button#admPBSeatSubmitAppOwnerItemId':{
						click:function(btn){
							this.admAppOwnerMappingSubmitAction(btn);
						}
					},
					'stcadmappownerwithprogrambatchseatmap button#admResetBtnCommonItemId':{
			 			  click:function(btn){
			 				  var tabStructure = this.getStcadmappownerwithprogrambatchseatmap();
			 				  var activeGrid = tabStructure.getActiveTab().down('grid');
			 				  activeGrid.getSelectionModel().deselectAll();
			 				  activeGrid.getStore().clearFilter();
			 				  if(activeGrid.down('customcombobox'))
			 				  activeGrid.down('customcombobox').reset();
			 			  }
					},
					'vwadmapplicationownersetupresultgrid button[itemId=admBtnDeleteAppOwnerItemId]':{
						click:this.admDeleteAppOwnerMappingAction
					},
					'vwadmapplicationownersetupresultgrid button[itemId=admBtnEditAppOwnerItemId]':{
						click:function(obj){
							var grid = this.getVwadmapplicationownersetupresultgrid();
        	            	if (grid.getSelectionModel().getCount() > 0) {
        	            		this.admEditAppOwnerMappingAction(obj);
        	            	} else {
        	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	            	}
							
						}
					},
					'stcadmeditwindow button[itemId=appOwnerSubmitButtonId]':{
						click:function(obj){
							this.admSaveEditAppOwnerMappingAction(obj);
						}
					},
					'stcadmeditwindow button[itemId=appOwnerCancelButtonId]':{
						click:function(obj){
					        this.getStcadmeditwindow().close();
					   }
					},
					'vwadmappowneruseridtabform':{
						render:function(form){
		    				var $this = this
		    				form.body.on('click', function() {
		    					$this.hideInvalidIconFromField(form);
		    			       });
		    			}
					}
				});
			},
			openAdmAddAppOwnerMappingTab: function(){
				var contentpanel = this.getContentpanel();
				var coursetabstructure = Ext.widget('stcadmaddappownermappingtab');
				var tabName = getCommonTranslation('MANAGE_APPLICATION_OWNER');

				var getcontroller=this.getController('menu.CoreERPNavigationController');
				var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentpanel.remove(getTab, true);
				}
				openTab(contentpanel, tabName, coursetabstructure,CONSTANTS.MENU_COLOR_TWO);
				var userIdForm = this.getVwadmappowneruseridtabform();
				userIdForm.down('#admAppOwnerUserItemId').reset();
				this.getVwadmappownersetupprogresstracker().setVisible(true);
				this.admAppOwnerResetProgressTracker();
				var adjustmentprogresstracker = coursetabstructure.down("#vwadmappownersetupprogresstracker");
				var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
				progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
				progresstracker1.textEl.addCls("inProgressCss-progress-text");
				progresstracker1.updateText("Step 1 In Progress");
			},
			admUserFormNextEventAppOwner:function(btn){
				var $this = this;
				var userNameform = $this.getVwadmappowneruseridtabform();
				var userNameValue = userNameform.down('#admAppOwnerUserItemId').getValue();
				if(!isNullOrEmpty(userNameValue)){
					var appOwnerProgramBatchstructure = $this.getStcadmappownerwithprogrambatchseatmap();
					var facultyCapusContainer = appOwnerProgramBatchstructure.down('#admFacultyCampusContainerItemId');
					facultyCapusContainer.setDisabled(false);
					appOwnerProgramBatchstructure.setActiveTab(facultyCapusContainer);
					appOwnerProgramBatchstructure.down('#admUserItemId').setValue(userNameValue);
					var vwAdmAppOwnerFacultyCampusGrid = $this.getVwadmappownerfacultycampusgrid();
					var facultyAcmpusSearchCombo = vwAdmAppOwnerFacultyCampusGrid.down('#admFacultyCampusSearchComboItemId');
					facultyAcmpusSearchCombo.getStore().clearFilter();
					facultyAcmpusSearchCombo.getStore().load();
					vwAdmAppOwnerFacultyCampusGrid.getStore().clearFilter();
					vwAdmAppOwnerFacultyCampusGrid.getStore().load();
					$this.admAppOwnerSetProgressTracker(1);
				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_USER'));
				}
			},
			admFaclutyCampusNextEventAppOwner:function(btn){
				var $this = this;
		    	var facultyCampusGrid = $this.getVwadmappownerfacultycampusgrid();
		    	var selectionModel = facultyCampusGrid.getSelectionModel().getSelection();
		    	var facultyCampusIdsArr = [];
		    	selectionModel.forEach(function(obj){
		    		facultyCampusIdsArr.push(obj.get('id'));
		    	});
		    	if(facultyCampusIdsArr.length > 0){
			    	var admAppOwnerProgramBatchSeatStructure = $this.getStcadmappownerwithprogrambatchseatmap();
			    	var admProgramContainer = admAppOwnerProgramBatchSeatStructure.down('#admProgramContainerItemId');
			    	admProgramContainer.setDisabled(false);
			    	admAppOwnerProgramBatchSeatStructure.setActiveTab(admProgramContainer);
			    	var appOwnerProgramGrid = $this.getVwadmappownerprogrammapgrid();
			    	var appOwnerProgramCombo = appOwnerProgramGrid.down('#admProgramSearchAppOwnerComboItemId');
			    	appOwnerProgramCombo.getStore().getProxy().extraParams= {
			    		academyLocationIds: facultyCampusIdsArr.join()
			    	};
			    	appOwnerProgramCombo.getStore().load();
			    	var appOwnerProgramGridStore = appOwnerProgramGrid.getStore();
			    	appOwnerProgramGridStore.getProxy().extraParams= {
			    		academyLocationIds: facultyCampusIdsArr.join()
			    	};
			    	appOwnerProgramGridStore.clearFilter();
			    	appOwnerProgramGridStore.load();
			    	$this.admAppOwnerSetProgressTracker(2);
		    	} else {
		    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		    	}
		    },
		    admAppOwnerProgramMapNextEvent: function(btn){
		    	var $this = this;
		    	var admAppOwnerProgramGrid = $this.getVwadmappownerprogrammapgrid();
		    	var selectionModel = admAppOwnerProgramGrid.getSelectionModel().getSelection();
		    	var admAOProgramGridIdsArr = [];
		    	var admAOProgramIdsArr = [];
		    	selectionModel.forEach(function(obj){
		    		admAOProgramGridIdsArr.push(obj.get('academyLocationId'));
		    		admAOProgramIdsArr.push(obj.get('programId'));
		    	});
		    	
		    	if(admAOProgramIdsArr.length > 0){
			    	var admAppOwnerProgramBatchSeatStructure = $this.getStcadmappownerwithprogrambatchseatmap();
			    	var admAppOwnerProgramBatchContainer = admAppOwnerProgramBatchSeatStructure.down('#admProgramBatchContainerItemId');
			    	admAppOwnerProgramBatchContainer.setDisabled(false);
			    	admAppOwnerProgramBatchSeatStructure.setActiveTab(admAppOwnerProgramBatchContainer);
			    	
			    	var admAOProgramBatchGrid = $this.getVwadmappownerprogrambatchmapgrid();
			    	
			    	var admAOProgramBatchSearchCombo = admAOProgramBatchGrid.down('#admPBSAppOwnerComboItemId');
			    	admAOProgramBatchSearchCombo.getStore().getProxy().extraParams= {
			    		academyLocationIds: admAOProgramGridIdsArr.join(),
			    		programIds:admAOProgramIdsArr.join()
			    	};
			    	admAOProgramBatchSearchCombo.getStore().load();
			    	
			    	var admAOProgramBatchGridStore = admAOProgramBatchGrid.getStore();
			    	admAOProgramBatchGridStore.getProxy().extraParams= {
			    		academyLocationIds: admAOProgramGridIdsArr.join(),
			    		programIds:admAOProgramIdsArr.join()
			    	};
			    	admAOProgramBatchGridStore.clearFilter();
			    	admAOProgramBatchGridStore.load();
			    	$this.admAppOwnerSetProgressTracker(3);
		    	} else {
		    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		    	}
		    },
		    admAppOwnerProgramBatchMapNextEvent:function(btn){
		    	var $this = this;
		    	var admAOProgramBatchgrid = this.getVwadmappownerprogrambatchmapgrid();
		    	var selectionModel = admAOProgramBatchgrid.getSelectionModel().getSelection();
		    	var admAOProgramGridIdsArr = [];
		    	var admAOProgramIdsArr = [];
		    	var admAOBatchIdsArr = [];
		    	selectionModel.forEach(function(obj){
		    		admAOProgramGridIdsArr.push(obj.get('academyLocationId'));
		    		admAOProgramIdsArr.push(obj.get('programId'));
		    		admAOBatchIdsArr.push(obj.get('batchId'));
		    	});
		    	
		    	if(admAOBatchIdsArr.length > 0){
			    	var admAppOwnerProgramBatchSeatStructure = $this.getStcadmappownerwithprogrambatchseatmap();
			    	var admProgramBatchSeatContainer = admAppOwnerProgramBatchSeatStructure.down('#admProgramBatchSeatTypeContainerItemId');
			    	admProgramBatchSeatContainer.setDisabled(false);
			    	admAppOwnerProgramBatchSeatStructure.setActiveTab(admProgramBatchSeatContainer);
			    	
			    	var admAOProgramBatchSeatGrid = this.getVwadmappownerprogrambatchseatmapgrid();
			
			    	var admAOProgramBatchSeatGridStore = admAOProgramBatchSeatGrid.getStore();
			    	admAOProgramBatchSeatGridStore.getProxy().extraParams= {
			    		academyLocationIds: admAOProgramGridIdsArr.join(),
			    		programIds:admAOProgramIdsArr.join(),
			    		batchIds:admAOBatchIdsArr.join()
			    	};
			    	admAOProgramBatchSeatGridStore.clearFilter();
			    	admAOProgramBatchSeatGridStore.load();
			    	this.admAppOwnerSetProgressTracker(4);
		    	} else {
		    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		    	}
		    },
			admAppOwnerResetProgressTracker : function(){
				var structure = this.getStcadmaddappownermappingtab();
				var adjustmentprogresstracker = structure.down("#vwadmappownersetupprogresstracker");
				var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
				var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
				var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
				var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
				var progresstracker5 = adjustmentprogresstracker.down("#progresstracker5");
				progresstracker1.reset();
				progresstracker1.updateText('');
				progresstracker2.reset();
				progresstracker2.updateText('');
				progresstracker3.reset();
				progresstracker3.updateText('');
				progresstracker4.reset();
				progresstracker4.updateText('');
				progresstracker5.reset();
				progresstracker5.updateText('');
			},
			admAppOwnerSetProgressTracker : function(progresstracker){
				var structure = this.getStcadmaddappownermappingtab();
				var adjustmentprogresstracker = structure.down("#vwadmappownersetupprogresstracker");

				var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
				var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
				var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
				var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
				var progresstracker5 = adjustmentprogresstracker.down("#progresstracker5");

				if(progresstracker==1){
					for(var i = 0; i < 11; i ++ ){
						progresstracker1.updateProgress((i * 0.1), '');
					}
					progresstracker1.textEl.addCls("custom-progress-text");
					progresstracker1.textEl.removeCls("inProgressCss-progress-text");
					progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
					progresstracker2.textEl.addCls("inProgressCss-progress-text");
					progresstracker2.updateText("Step 2 In Progress");
					progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
				}
				if(progresstracker==2){
					for(var i = 0; i < 11; i ++ ){
						progresstracker2.updateProgress((i * 0.1), '');
					}
					progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
					progresstracker3.textEl.addCls("inProgressCss-progress-text");
					progresstracker3.updateText("Step 3 In Progress");
					progresstracker2.textEl.removeCls("inProgressCss-progress-text");
					progresstracker2.textEl.addCls("custom-progress-text");
					progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
				}
				if(progresstracker==3){
					for(var i = 0; i < 11; i ++ ){
						progresstracker3.updateProgress((i * 0.1), '');
					}
					progresstracker4.textEl.removeCls("x-progress-text x-progress-text-back");
					progresstracker4.textEl.addCls("inProgressCss-progress-text");
					progresstracker4.updateText("Step 4 In Progress");
					progresstracker3.textEl.removeCls("inProgressCss-progress-text");
					progresstracker3.textEl.addCls("custom-progress-text");
					progresstracker3.updateText(getCommonTranslation('STEP_3_COMPLETE'));
				}
				if(progresstracker==4){
					for(var i = 0; i < 11; i ++ ){
						progresstracker4.updateProgress((i * 0.1), '');
					}
					progresstracker5.textEl.removeCls("x-progress-text x-progress-text-back");
					progresstracker5.textEl.addCls("inProgressCss-progress-text");
					progresstracker5.updateText("Step 5 In Progress");
					progresstracker4.textEl.removeCls("inProgressCss-progress-text");
					progresstracker4.textEl.addCls("custom-progress-text");
					progresstracker4.updateText(getCommonTranslation('STEP_4_COMPLETE'));
					
				}
				if(progresstracker==5){
					for(var i = 0; i < 11; i ++ ){
						progresstracker5.updateProgress((i * 0.1), '');
					}
					progresstracker5.textEl.removeCls("inProgressCss-progress-text");
					progresstracker5.textEl.addCls("custom-progress-text");
					progresstracker5.updateText(getCommonTranslation('STEP_5_COMPLETE'));
				}
			},
			admAppOwnerMappingSubmitAction: function(btn){
				var $this = this;
		    	var addAppOwnerProgramMappingTab = $this.getStcadmappownerwithprogrambatchseatmap();
		    	var admUserItemId = addAppOwnerProgramMappingTab.down('#admUserItemId').getValue();
		    	var submitJsonArr = null;
		    	if(btn.itemId =='admSubmitBtnFacultyCampusItemId'){
		    		var facultyCampusIdsArr = [];
		    		var activeGrid = this.getVwadmappownerfacultycampusgrid();
			    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
			    	selectedRecord.forEach(function(obj){
			    		facultyCampusIdsArr.push(obj.get('id'));
			    	});
			    	var facultyCampusIds = String(facultyCampusIdsArr);
			    	var programIds = null;
			    	var batchIds = null;
		    	}else if(btn.itemId =='admProgramSubmitAppOwnerItemId'){
		    		var programsIdsArr = [];
		    		var activeGrid = $this.getVwadmappownerprogrammapgrid();
			    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
			    	selectedRecord.forEach(function(obj){
			    		programsIdsArr.push(obj.get('programId'));
			    	});
			    	var programIds = String(programsIdsArr);
			    	var facultyCampusIds = null;
			    	var batchIds = null;
		    	}else if(btn.itemId =='admProgramBatchSubmitAppOwnerItemId'){
		    		var batchIdsArr = [];
		    		var activeGrid = $this.getVwadmappownerprogrambatchmapgrid();
			    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
			    	selectedRecord.forEach(function(obj){
			    		batchIdsArr.push(obj.get('batchId'));
			    	});
			    	var batchIds = String(batchIdsArr);
			    	var facultyCampusIds = null;
			    	var programIds = null;
			    	var pbsIds = null;
		    	}else if(btn.itemId =='admPBSeatSubmitAppOwnerItemId'){
		    		var pbsIdsArr = [];
		    		var activeGrid = $this.getVwadmappownerprogrambatchseatmapgrid();
			    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
			    	selectedRecord.forEach(function(obj){
			    		pbsIdsArr.push(obj.get('programBatchSeatTypeId'));
			    	});
			    	var pbsIds = String(pbsIdsArr);
			    	var facultyCampusIds = null;
			    	var programIds = null;
			    	var batchIds = null;
		    	}
		    	if(selectedRecord.length>0){
		    		var submitUrl = SERVERURL.PATH_APPLICATION_OWNER_SETUP_CREATE;
			    			submitJsonArr={
			    				user: {id:parseInt(admUserItemId)},
			    				academyLocationIds: facultyCampusIds,
			    				programIds:programIds,
			    				batchIds:batchIds,
			    				pbsIds:pbsIds
			    			}
			    			  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			    			Ext.Ajax.request({
			    				method: "POST",
			    				type: 'rest',
			    				url: submitUrl,
			    				scope:$this,
			    				jsonData:submitJsonArr,
			    				success : function(response, action) {
			    					Ext.getBody().unmask();
			    					var contentpanel = $this.getContentpanel();
			    					var tabName = getCommonTranslation('MANAGE_APPLICATION_OWNER');
			    					var getcontroller=$this.getController('menu.CoreERPNavigationController');
			    					var getTab=getcontroller.getTab(tabName);
			    					if(getTab!=null){
			    						contentpanel.remove(getTab, true);
			    					}
			    					var grid = $this.getVwadmapplicationownersetupresultgrid();
			    					var grdStore = grid.getStore();
			    					grdStore.load();
			    					var data = response.responseText;
			    					if(data == 'success'){
			    						showSuccessMessage(getCommonTranslation('MANAGE_APPLICATION_OWNER'), getCommonTranslation('APPLICATION_OWNER_SETUP_MAPPING_CREATED_SUCCESS'));
			    					} 
			    				},
			    				failure: function(form, action) {
			    					Ext.getBody().unmask();
			    					var data = Ext.decode(form.responseText);
			    					var key = data[0].key;
			    					if(key == 'USER_ALREADY_EXIST_PBS'){
//			    						showWarningMessage(getCommonTranslation('MANAGE_APPLICATION_OWNER'), getCommonTranslation('USER_ALREADY_EXIST_PBS')); 
			    					}
			    				}
			    			});
		    	} else {
		    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		    	}
		    },
		    //*************** delete records from DO MAPPING*******************
		    admDeleteAppOwnerMappingAction:function(){
		    	var grid = this.getVwadmapplicationownersetupresultgrid();
		    	var grdStore = grid.getStore();
		    	if (grid.getSelectionModel().getCount() > 0) {
		    		showConfirmMessage(getCommonTranslation('APPLICATION_OWNER_SETUP'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
		    			if (btn == 'yes') {
		    				var records = grid.getSelectionModel().getSelection();
		    				var id = records[0].get("id");
		    				Ext.Ajax.request({
		    					method: "DELETE",
		    					type: 'rest',
		    					url: SERVERURL.PATH_APPLICATION_OWNER_SETUP_DELETE+'?id='+id,
		    					headers: {
		    						'Content-Type': 'application/json'
		    					},
		    					success: function(form, action) {
		    						grdStore.reload();
		    						showSuccessMessage(getCommonTranslation('APPLICATION_OWNER_SETUP'), getCommonTranslation('APPLICATION_OWNER_SETUP_MAPPING_DELETED_SUCCESSFULLY'));
		    					}
		    				});
		    			}
		    		});
		    	} else {
		    		showWarningMessage(getCommonTranslation('APPLICATION_OWNER_SETUP'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
		    	} 
		    },
		    
		    admEditAppOwnerMappingAction:function(){
		    	var grid = this.getVwadmapplicationownersetupresultgrid();
		    	var grdStore = grid.getStore();
		    	if (grid.getSelectionModel().getCount() > 0) {
		    				var records = grid.getSelectionModel().getSelection();
		    				var $this = this;
		    		    	var formWindow = $this.getStcadmeditwindow();
		    		    	if (!formWindow) {
		    		    		Ext.widget('stcadmeditwindow');
		    		    		formWindow = $this.getStcadmeditwindow();
		    		    		formWindow.down("#userApplicationOwnerId").setValue(records[0].data.printName)
		    		    	}
		    		    	
		    		    	formWindow.show();
		    			
		    	} else {
		    		showWarningMessage(getCommonTranslation('APPLICATION_OWNER_SETUP'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
		    	} 
		    },
		    
		    admSaveEditAppOwnerMappingAction:function(obj){
		    	var $this = this;
		    	var grid = this.getVwadmapplicationownersetupresultgrid();
		    	var records = grid.getSelectionModel().getSelection();
		    	var form = $this.getStcadmeditwindow();
				var  userId = form.down("#userApplicationOwnerId").value;
				var record = records[0].data;
				var submitUrl = SERVERURL.PATH_APPLICATION_OWNER_SETUP_UPDATE;
    			submitJsonArr={
    				id:parseInt(record.id),	
    				user: {id:parseInt(userId)},
    				programBatchSeatConfiguration:{id:record.seatId}
    			}
    			 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				Ext.Ajax.request({
    				method: "POST",
    				type: 'rest',
    				url: submitUrl,
    				scope:$this,
    				jsonData:submitJsonArr,
    				success : function(response, action) {
    					
    					var contentpanel = $this.getContentpanel();
    					var grid = $this.getVwadmapplicationownersetupresultgrid();
    					var grdStore = grid.getStore();
    					grdStore.load();
    					Ext.getBody().unmask();
    					var data = response.responseText;
    						var formWindow = $this.getStcadmeditwindow();
    						if (!formWindow) {
    				    		Ext.widget('stcadmeditwindow');
    				    		formWindow = $this.getStcadmeditwindow();
    				    	}
    						formWindow.close();
    						grid.getSelectionModel().deselectAll();
    						
    						showSuccessMessage(getCommonTranslation('MANAGE_APPLICATION_OWNER'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
    				}
    			});
				
				
		    
		    },
		    
		    DisableApplicatonOwnerSetupPrivileges:function(grid,permissionsMap){
		    	var buttonsToolBar = grid.query('toolbar')[0];
		    	buttonsToolBar.query('#admBtnAddAppOwnerItemId')[0].setVisible(false);
		    	buttonsToolBar.query('#admBtnEditAppOwnerItemId')[0].setVisible(false);
		    	buttonsToolBar.query('#admBtnDeleteAppOwnerItemId')[0].setVisible(false);
	            var associatedAcadLocationIds = new Array();	            
	            associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	    		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getAPPLICANT_OWNER_SETUP_PERMISSIONS());
		    	Ext.each(permissionList, function(privilege) {
		    	if (privilege === 'CREATE') {
		    		buttonsToolBar.query('#admBtnAddAppOwnerItemId')[0].setVisible(true);
				}
				if (privilege === 'EDIT') {
					buttonsToolBar.query('#admBtnEditAppOwnerItemId')[0].setVisible(true);
				}
				if (privilege === 'DELETE') {
					buttonsToolBar.query('#admBtnDeleteAppOwnerItemId')[0].setVisible(true);
				}
		    		
		    	});
		    }

});