Ext.define('Academia.controller.attendance.ConsolidateAttendanceController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['coursetransaction.studentenrollment.studentenrollmentdetail.AdmissionCodeBySmartSearch',
		'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch','attendance.FacultyCodeSmartSearch','program.ProgramCodeOrNameSmartSearch','program.programDetails.programBatches.programCourse.ProgramCourseCodeStore'
		,'coursetransaction.studentenrollment.enrollmentmaster.CourseEnrollmentCombo','program.ProgramGroupStore','feeandpayment.reports.Program',
		'common.ProgramByAcademyLocationStore','common.AssignedProgramStore',
		'attendance.AssignedSectionByCourseNComponent','attendance.EditStudentAttendanceListStore','attendance.AttendanceCountStore',
		'attendance.AttendanceMarkingTypeStore','attendance.MultipleSessionValueStore','admission.applicationFormSale.ProgramGroupComboStore',
		'personinfo.common.personalinfo.AttendanceReportProgramGroupStore','common.BatchIntakeYearStore','coursetransaction.facultytopicassignment.ParameterizedFaculties',
		'program.ProgramCategoryByAlStore','common.ParameterizedProgramBatchPeriodStore','attendance.ConsolidateAttendanceTotalStudentGridStore','coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.TopicByCourseId','course.coursetopic.AssignTopicDetailGridStore'],
		model: ['attendance.EditStudentAttendanceListModel','attendance.AttendanceCountModel','common.ClassTeacherProgramStore'],
		views: ['attendance.EditAttendanceRecordStructure','attendance.EditStudentAttendance',
			'attendance.EditStudentAttendanceGrid','attendance.EditStudentAttendanceCountGrid',
			'attendance.ConsolidateSearchAttendance','attendance.ConsolidateAttendanceStructure','attendance.ConsolidateAttendanceGrid',
			'attendance.DailyAttendanceStructureForFaculty','attendance.ConsolidateCourseWiseSearchAttendance','attendance.ConsolidateAttendanceCourseWiseGrid',
			'attendance.consolidateCourseWiseAttendance','attendance.ConsolidateAttendanceTotalStudentGrid','attendance.CourseWiseTotalStudentDetail',
			'attendance.CourseWiseDailyAttendanceSearch', 'facultyPortal.detailScheduleFaculty.StudentCourseTopicCovered',
			'attendance.QRCodeWindow'],
			config: {
				CONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES'),
				FACULTY_CONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_CONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES'),
				PENDING_ATTENDANCE_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PENDING_ATTENDANCE_REPORT_PRIVILEGES'),
				FACULTY_PENDING_ATTENDANCE_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PENDING_ATTENDANCE_REPORT_PRIVILEGES'),
				ATTENDANCE_ENTRY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_ENTRY_PRIVILEGES'),
				ATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES'),
				EMPLOYEE_PORTAL_ATTENDANCE_DASHLET_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_PORTAL_ATTENDANCE_DASHLET_PRIVILEGES')
			},
			refs: [{
				ref: 'attendancestudentsearch',
				selector: 'attendancestudentsearch'
			},{
				ref: 'consolidateattendancestructure',
				selector: 'consolidateattendancestructure'
			},{
				ref: 'consolidatesearchattendance',
				selector: 'consolidatesearchattendance'
			},{
				ref: 'consolidateattendancegrid',
				selector: 'consolidateattendancegrid'
			},{
				ref: 'contentPanel',
				selector: 'contentPanel'
			},{
				ref :'editstudentattendance',
				selector : 'editstudentattendance'
			},{
				ref :'editattendancerecordstructure',
				selector : 'editattendancerecordstructure'
			},{
				ref :'editstudentattendancegrid',
				selector : 'editstudentattendancegrid'
			},{
				ref :'editstudentattendancecountgrid',
				selector : 'editstudentattendancecountgrid'
			},{
				ref :'dailyattendancestructureforfaculty',
				selector : 'dailyattendancestructureforfaculty'
			},{
				ref :'consolidatecoursewisesearchattendance',
				selector : 'consolidatecoursewisesearchattendance'
			},{
				ref :'consolidateattendancecoursewisegrid',
				selector : 'consolidateattendancecoursewisegrid[itemId=consolidateattendancecoursewisegrid]'
			},{
				ref :'consolidatecoursewiseattendance',
				selector : 'consolidatecoursewiseattendance'
			},{
				ref :'consolidateattendancetotalstudentgrid',
				selector : 'consolidateattendancetotalstudentgrid'
			},{
				ref :'coursewisetotalstudentdetail',
				selector : 'coursewisetotalstudentdetail'
			},{
				ref: 'coursewisedailyattendancesearch',
				selector: 'coursewisedailyattendancesearch'
			},{
	        	 ref: 'studentcoursetopiccovered',
	        	 selector: 'studentcoursetopiccovered'
	         },{
					ref: 'qrcodewindow',
					selector: 'qrcodewindow'
				}],
			init: function(application) {
				this.control({
					'consolidateattendancestructure' : {
						render : function() {
							var form = this.getConsolidatesearchattendance();
//							this.getConsolidateattendancegrid().setVisible(true);
							var academyLocationId = this$.getCurrentAcademyLocation();
							var programGroupStore = this.getStore('personinfo.common.personalinfo.AttendanceReportProgramGroupStore');
							programGroupStore.getProxy().extraParams = {
								academyLocationId: academyLocationId
							};
							programGroupStore.load();
							var portalId = this.getCurrentLoggedPortalId();
							var permissionsMap = new Ext.util.HashMap();
							if (portalId == 2) {
								permissionsMap= this.getFACULTY_CONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES();
							}else{
								permissionsMap=this.getCONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES();
							}
							var associatedAcadLocationIds = new Array();
							associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
							var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

							this.consolidateStudentAttendanceTypeRadio(form,permissionList);
						},
						afterrender : function(structure) {
							var grid = structure.down('consolidateattendancegrid');
							var  contentPanelMain = this.getContentPanel().getActiveTab();
							contentPanelMain.scrollBy(0,1);
							contentPanelMain.scrollBy(0,-1);
							var $this=this;
							var form = $this.getConsolidatesearchattendance();
							if(this.getCurrentLoggedPortalId()==2){
								var newStructure = structure.up('personinfofacultyportal');
								Ext.defer(function() {
									var attendanceType=$this.getConsolidateattendancestructure().down('#attendanceTypeRadio').getValue().attendanceTypeWise;
									$this.loadConsolidateAttendanceGrid(attendanceType);
								},500);
							} 
							
							var me = this;
		    				setTimeout(function(){
		    					me.addDataGridConfigButton(grid,me.getCONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES());
		    				},1500);
		    				var attendanceform = $this.getConsolidatesearchattendance();
		    				var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
		    				if(wheatherSchool){
								var parogramField = attendanceform.down('#programBatch_programId');
								var batchField = attendanceform.down('#programBatch_batchId');
								var periodField = attendanceform.down('#periodIdItemId');
								$this.setAllowBlank(parogramField, true);
								$this.setAllowBlank(batchField, true);
								$this.setAllowBlank(periodField, true);
							}
							
						}
					},
					'consolidateattendancestructure radiogroup[itemId=attendanceTypeRadio]':{
						change : function(obj,record){
							this.consolidateAttendanceTypeDropdown(record); 
						}
					},
					
					
					'consolidateattendancegrid' : {
						show: function(grid) {
							setTimeout(function(){
								var structure = grid.up('attendancemainstructure');
								if(!isNullOrEmpty(structure)){
									structure.scrollBy(0,1);
									structure.scrollBy(0,-1);  
								}
								grid.el.dom.style.opacity = 1;
							},200);
						},
						beforerender : function() {
							this
							.getStore(
							'attendance.ConsolidateAttendanceGridStore')
							.removeAll();
						},
						render : function(grid) {
							var portalId = this.getCurrentLoggedPortalId();
							var facultyId = null;
							if (portalId == 2) {
								this.doAccessControlValidation(grid, this.getFACULTY_CONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES());
							}else{
								this.doAccessControlValidation(grid, this.getCONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES());
							}
						},
						afterrender:function(grid){
							var me = this;
							setTimeout(function(){
								me.addDataGridConfigButton(grid,me.getCONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES());
							},1500);
						}
					},
					'consolidateattendancecoursewisegrid' : {
						show: function(grid) {
							setTimeout(function(){
								var structure = grid.up('attendancemainstructure');
								if(!isNullOrEmpty(structure)){
									structure.scrollBy(0,1);
									structure.scrollBy(0,-1);
								}
								grid.el.dom.style.opacity = 1;
							},200);
						},
						render : function(grid) {
							var portalId = this.getCurrentLoggedPortalId();
							var facultyId = null;
							if (portalId == 2) {
								this.doAccessControlValidation(grid, this.getFACULTY_CONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES());
							}else{
								this.doAccessControlValidation(grid, this.getCONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES());
							}
						},
						afterrender:function(grid){
							var me = this;
							setTimeout(function(){
								me.addDataGridConfigButton(grid,me.getCONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES());
							},1500);
						},
					},
					'consolidateattendancetotalstudentgrid' : {
						render : function(grid) {
							var portalId = this.getCurrentLoggedPortalId();
							var facultyId = null;
							if (portalId == 2) {
								this.doAccessControlValidation(grid, this.getFACULTY_CONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES());
							}else{
								this.doAccessControlValidation(grid, this.getCONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES());
							}
						}
					},
					'consolidatesearchattendance combo#ProgramGroupItemId' : {
						select : function(obj, record) {
							var this$ = this;
							var facultyId = null;
							if(this$.getCurrentLoggedPortalId()==2){
								facultyId = this$.getCurrentlyLoggedInUser().id;
							}  
							var form=this$.getConsolidatesearchattendance();
							form.down("#programBatch_programId").reset();
							form.down("#programBatch_batchId").reset();
							form.down("#periodIdItemId").reset();
							form.down("#programCoursection_ID").reset();
							form.down("#facultyName_Id").reset();
							form.down("#programBatch_batchId").setDisabled(true);
							form.down("#periodIdItemId").setDisabled(true);
							form.down("#programCoursection_ID").setDisabled(true);
							var programGroupId = record[0].get("id");
							var programStore = this$.getStore('common.ClassTeacherProgramStore');
							var academyLocationIds = this$.getCurrentAcademyLocation();

							programStore.getProxy().extraParams = {
								programGroupId: programGroupId,
								academyLocationIds :academyLocationIds,
								facultyId :facultyId
							};
							programStore.load();
							
						}
					},
					'consolidatesearchattendance button[itemId=searchBtn]' : {
						click : function() {
							var $this = this;
							var attendanceType=$this.getConsolidateattendancestructure().down('#attendanceTypeRadio').getValue().attendanceTypeWise;
							this.loadConsolidateAttendanceGrid(attendanceType);
						}
					},
					
					'consolidatesearchattendance button[itemId=GenrateQR]' : {
						click : function() {
							var $this = this;
							var attendanceType=$this.getConsolidateattendancestructure().down('#attendanceTypeRadio').getValue().attendanceTypeWise;
                            var grid = this.getConsolidateattendancegrid();
							var form = this.getConsolidatesearchattendance().getForm();
							var values = form.getValues();
							grid.setVisible(true);
							var store = grid.getStore();
							var academyLocationId = this.getCurrentAcademyLocation();
							var programGroupId = values.programGroup;
							var programId = values.programId;
							var batchId = values.batchId;
							var periodId = values.periodId;
							var sectionId = values.sectionId;
							var facultyName = values.facultyName;
							var facultyCode = values.facultyCode;
							var sessionNo = values.sessionNo;
							var academyLocationId = this.getCurrentAcademyLocation();
							var startDate = values.consolidateStartDate;
							var endDate = values.consolidateEndDate;
							var fromTime = values.fromTime;
							var toTime = values.toTime;
							var program;
							 var qrDataModel = {};
							 var qrData = '';
							 
							if(!isNullOrEmpty(programId)){
								program = programId;
							}else{
								program = '';
							}
							var batch;
							if(!isNullOrEmpty(batchId)){
								batch = batchId;
							}else{
								batch = '';
							}
							var period;
							if(!isNullOrEmpty(periodId)){
								period = periodId;
							}else{
								period = '';
							}
							var section;
							if(!isNullOrEmpty(sectionId)){
								section = sectionId;
							}else{
								section = '';
							}
							var faculty;
							if(!isNullOrEmpty(facultyName)){
								faculty = facultyName;
							}else if(!isNullOrEmpty(facultyCode)){
								faculty = facultyCode;
							}else{
								faculty = '';
							}
							if(this.getCurrentLoggedPortalId() == 2) {
								faculty=this.getCurrentlyLoggedInUser().id;
								grid.columns[7].setVisible(false);
							}
							if(attendanceType=='Multiple Session' || attendanceType=='MULTIPLE_SESSION')
							{
								var alinfomodel = Academia.model.authentication.ALInfoModel;
								var wheatherSchool = alinfomodel.get('wheatherSchool');
								if(wheatherSchool){
									grid.columns[3].setVisible(false);
								}else{
									grid.columns[3].setVisible(true);
								}	
								grid.columns[7].setVisible(true);
								qrDataModel.qrData = {
										   qrId: form.responseText,
										   programGroupId:programGroupId,
										   programId:programId,
										   batchId: batchId,
										   sectionId:sectionId,
										   facultyName:facultyName,
										   startDate:startDate
								   };
								 var qrDisplayData =  $this.getConsolidateattendancestructure().getForm().findField('programId').getDisplayValue() 
								 						+ ' | ' + $this.getConsolidateattendancestructure().getForm().findField('batchId').getDisplayValue()  
								 						+ ' | ' + $this.getConsolidateattendancestructure().getForm().findField('sectionId').getDisplayValue() 
								 						+ ' | ' + $this.getConsolidateattendancestructure().getForm().findField('facultyName').getDisplayValue() 
								 						+ ' | ' + dateRender(startDate)
								 						+ ' | ' + $this.getConsolidateattendancestructure().getForm().findField('sessionNo').getDisplayValue();
								 Ext.Ajax.request({
					                    type: 'rest',
					                    url: SERVERURL.PATH_PROGRAM_ATTENDANCE_QR, //URL-"rest/studentAttendance/getProgramAttendanceQR"													 
					                    method: 'GET',
					                    headers: {
					                        'Content-Type': 'application/json'
					                    },
					                    params: {
					                    	programId:program,
											batchId:batch,
											periodId:period,
											sectionId:section,
											academyLocationId:academyLocationId,
											facultyId:faculty,
											attendanceDate:startDate,
											sessionNo:sessionNo,
											attendanceType:attendanceType,
											programGroupId :programGroupId
					                    },
					                    success: function(form, action) {
					                    	if(isNullOrEmpty(form.responseText)){
					                    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('THE_QR_CODE_FOR_THIS_SESSION_IS_NOT_YET_GENERATED_YOU_CAN_GENERATE_IT_FROM_CAPTURE_ATTENDANCE_SCREEN'));
					                    	}else{

					                    		Ext.Ajax.request({
					                    			type: 'rest',
					                    			url: SERVERURL.PATH_PROGRAM_ATTENDANCE_QR_CODE, //URL-"rest/studentAttendance/getProgramAttendanceQR"													 
					                    			method: 'GET',
					                    			headers: {
					                    				'Content-Type': 'application/json'
					                    			},
					                    			params: {
					                    				programId:program,
					                    				batchId:batch,
					                    				periodId:period,
					                    				sectionId:section,
					                    				academyLocationId:academyLocationId,
					                    				facultyId:faculty,
					                    				attendanceDate:startDate,
					                    				sessionNo:sessionNo,
					                    				attendanceType:attendanceType,
					                    				programGroupId :programGroupId
					                    			},
					                    			success: function(form1, action1) {
					                    				if(isNullOrEmpty(form1.responseText)){
					                    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('THE_QR_CODE_FOR_THIS_SESSION_IS_NOT_YET_GENERATED_YOU_CAN_GENERATE_IT_FROM_CAPTURE_ATTENDANCE_SCREEN'));
					                    				}else{
					                    					
					                    					var qrCodeText = '';
								                    		if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
								                    			qrCodeText = 'CD-'+form1.responseText; //CompleteDay
								                    		}
								                    		else if(attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION'){
								                    			qrCodeText = 'MS-'+form1.responseText; //MultipleSessions
								                    		}
								                    		else{
								                    			qrCodeText = 'CW-'+form1.responseText; //CourseWise
								                    		}
					                    					
					                    					var formWindow =  $this.getQrcodewindow();
					                    					if (!formWindow) {
					                    						Ext.widget('qrcodewindow',{
					                    							qrData: Ext.encode(qrDataModel.qrData),
					                    							path:form.responseText,
					                    							qrDisplayData: qrDisplayData,
					                    							qrCode: qrCodeText,
					                    							itemId: 'attendanceReportQRWin'
					                    						})
					                    						formWindow =  $this.getQrcodewindow();
					                    					}
					                    					formWindow.show();
					                    				}

					                    			}
					                    		});
					                    	}
					     				
					                    }
					                });
							}
							else{
								var alinfomodel = Academia.model.authentication.ALInfoModel;
								var wheatherSchool = alinfomodel.get('wheatherSchool');
								if(wheatherSchool){
									grid.columns[3].setVisible(false);
								}else{
									grid.columns[3].setVisible(true);
								}	
								grid.columns[7].setVisible(false);
								qrDataModel.qrData = {
										   qrId: form.responseText,
										   programGroupId:programGroupId,
										   programId:programId,
										   batchId: batchId,
										   sectionId:sectionId,
										   facultyName:facultyName,
										   startDate:startDate
								   };
								 var qrDisplayData =  $this.getConsolidateattendancestructure().getForm().findField('programId').getDisplayValue() 
								 						+ ' | ' + $this.getConsolidateattendancestructure().getForm().findField('batchId').getDisplayValue()  
								 						+ ' | ' + $this.getConsolidateattendancestructure().getForm().findField('sectionId').getDisplayValue() 
								 						+ ' | ' + $this.getConsolidateattendancestructure().getForm().findField('facultyName').getDisplayValue() 
								 						+ ' | ' + dateRender(startDate);
								Ext.Ajax.request({
				                    type: 'rest',
				                    url: SERVERURL.PATH_PROGRAM_ATTENDANCE_QR, //URL-"rest/studentAttendance/getProgramAttendanceQR"													 
				                    method: 'GET',
				                    headers: {
				                        'Content-Type': 'application/json'
				                    },
				                    params: {
				                    	programId:program,
										batchId:batch,
										periodId:period,
										sectionId:section,
										academyLocationId:academyLocationId,
										facultyId:faculty,
										attendanceDate:startDate,
										sessionNo:'',
										attendanceType:attendanceType,
										programGroupId :programGroupId
				                    },
				                    
				                    success: function(form, action) {
				                    	if(isNullOrEmpty(form.responseText)){
				                    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('THE_QR_CODE_FOR_THIS_SESSION_IS_NOT_YET_GENERATED_YOU_CAN_GENERATE_IT_FROM_CAPTURE_ATTENDANCE_SCREEN'));
				                    	}else{ 
				                    		
				                    		Ext.Ajax.request({
							                    type: 'rest',
							                    url: SERVERURL.PATH_PROGRAM_ATTENDANCE_QR_CODE, //URL-"rest/studentAttendance/getProgramAttendanceQR"													 
							                    method: 'GET',
							                    headers: {
							                        'Content-Type': 'application/json'
							                    },
							                    params: {
							                    	programId:program,
													batchId:batch,
													periodId:period,
													sectionId:section,
													academyLocationId:academyLocationId,
													facultyId:faculty,
													attendanceDate:startDate,
													sessionNo:'',
													attendanceType:attendanceType,
													programGroupId :programGroupId
							                    },
							                    success: function(form1, action1) {
							                    	if(isNullOrEmpty(form1.responseText)){
							                    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('THE_QR_CODE_FOR_THIS_SESSION_IS_NOT_YET_GENERATED_YOU_CAN_GENERATE_IT_FROM_CAPTURE_ATTENDANCE_SCREEN'));
							                    	}else{ 
							                    		var qrCodeText = '';
							                    		if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
							                    			qrCodeText = 'CD-'+form1.responseText; //CompleteDay
							                    		}
							                    		else if(attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION'){
							                    			qrCodeText = 'MS-'+form1.responseText; //MultipleSessions
							                    		}
							                    		else{
							                    			qrCodeText = 'CW-'+form1.responseText; //CourseWise
							                    		}

							                    		var formWindow =  $this.getQrcodewindow();
							                    		if (!formWindow) {
							                    			Ext.widget('qrcodewindow',{
							                    				qrData: Ext.encode(qrDataModel.qrData),
							                    				path:form.responseText,
							                    				qrDisplayData: qrDisplayData,
							                    				qrCode: qrCodeText,
							                    				itemId: 'attendanceReportQRWin'
							                    			})
							                    			formWindow =  $this.getQrcodewindow();
							                    		}
							                    		formWindow.show();
							                    	}
							     				}
							                });
				                    	}
				     				}
				                });
							}
						}
					},
					
					'qrcodewindow[itemId=attendanceReportQRWin]':{
						afterrender: function(win){
							var me = this;
							var qrData = win.qrData;
							var qrDisplayData = win.qrDisplayData;
							var path=win.path;
							var qrDataJson = Ext.decode(qrData);

							$('#qrcode').html('<img src="'+path+'"/>');

							var test= path.src;
							var acedemyLocationName = me.getAcademyLocationDisplayName(me.getCurrentAcademyLocation());

							var printBtmVals = Object.values(qrDataJson);

							win.down('#qrALLabelCls').setText(acedemyLocationName);
							win.down('#qrOtherTxtLabelCls').setText(qrDisplayData);

							if(Ext.query('#'+win.id+' #qrcodetext').length){
								Ext.query('#'+win.id+' #qrcodetext')[0].innerText = win.qrCode;
	        				}


						}
					},
					
					
					'consolidatesearchattendance button[itemId=resetBtn]' : {
						click : function(obj, record) {
							var form=this.getConsolidatesearchattendance().getForm();
							form.getFields().each(function(field) {
								if(field.name == 'attendanceTypeRadio' || field.name == 'attendanceTypeWise') {

								}else{
									field.reset();	 
								}
							});
							var searchForm=this.getConsolidatesearchattendance();
							searchForm.down('#consolidateStartDate').setMinValue(false);
							searchForm.down('#consolidateStartDate').setMaxValue(new Date());
							searchForm.down('#consolidateEndDate').setMinValue(false);
							searchForm.down('#consolidateEndDate').setMaxValue(new Date());
							var attendanceType=this.getConsolidateattendancestructure().down('#attendanceTypeRadio').getValue().attendanceTypeWise;
							var form = this
							.getConsolidatesearchattendance();
							var portalId = this
							.getCurrentLoggedPortalId();
							var facultyId = null;
							if (portalId == 2) {
								facultyId = this
								.getCurrentlyLoggedInUser().id;
							}
							form.down("#programBatch_batchId").setDisabled(true);
							form.down("#periodIdItemId").setDisabled(true);
							form.down("#programCoursection_ID").setDisabled(true);


							var programByAcademyLocationStore = this
							.getStore('common.ClassTeacherProgramStore');
							programByAcademyLocationStore
							.getProxy().extraParams = {
								facultyId : facultyId,
								academyLocationIds : this
								.getCurrentAcademyLocation()
							};
							programByAcademyLocationStore
							.load();
							form.down('#facultyName_Id').setVisible(true);
						}
					},
					'consolidatesearchattendance customcombobox[itemId=programBatch_programId]' : {
						select : function(obj, record) {
							var this$ = this;
							var programId = record[0].get("id");
							var portalId = this.getCurrentLoggedPortalId();
							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							var facultyId = null;
							if (portalId == 2) {
								facultyId = this
								.getCurrentlyLoggedInUser().id;
							}
							
							if (programId > 0) {
								var form = this
								.getConsolidatesearchattendance();
								form.down("#programBatch_batchId").reset();
								form.down("#periodIdItemId").reset();
								form.down("#programCoursection_ID").reset();
								form
								.down(
								"#programBatch_batchId")
								.setDisabled(false);
								var store = this$.getStore('enquiry.AcademicBatchStore');
								store.getProxy().extraParams = {
									id: programId,
									pastBatch:true
									//isActive:true
								};
								store.load({
									callback: function(records, operation, success) {
										if (success) {
											if(records.length==0){
												form.down("#programCoursection_ID").setDisabled(true);
												form.down("#programCoursection_ID").clearValue();
											}
											if(records.length==1){
												form.down("#programBatch_batchId").setValue(records[0].get('id'));
												form.down("#periodIdItemId").setDisabled(false);
												var store = form.down("#periodIdItemId").getStore();
												store.getProxy().extraParams = {
													id: records[0].get('id'),
													//isCurrentPeriod:true
												};
												store.load({
													callback: function(records, operation, success) {
														if (success) {
															if(records.length==0){
																form.down("#programCoursection_ID").setDisabled(true);
																if(wheatherSchool) {
																	showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

																} 
															}
															if(records.length==1){
																form.down("#periodIdItemId").setValue(records[0].get('id'))
																form.down("#programCoursection_ID").setDisabled(false);
																var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
																store.getProxy().extraParams = {
																	periodId: records[0].get('id'),
																	facultyId : facultyId
																};
																store.load({
																	callback: function(records, operation, success) {
																		if (success) {
																			if(records.length==1){
																				form.down("#programCoursection_ID").setValue(records[0].data.sectionId);
																				// this$.loadConsolidateAttendanceGrid();
																			}
																		}
																	}
																});

															}
														}
													}
												});
											}
										}
									}
								});
							} else {
								var form = this
								.getConsolidatesearchattendance();
								var academyLocationIds = this
								.getCurrentAcademyLocation();
								var store = form
								.down(
								"#programBatch_programId")
								.getStore();
								store.getProxy().extraParams = {
									facultyId : facultyId,
									academyLocationIds : this
									.getCurrentAcademyLocation()
								};
								store.load();

							}
						},
						
						change :function(obj, record){
							this.validateQRBtn();
							this.validateSearchButton();
						}
						
					},
					'consolidatesearchattendance combo#programBatch_batchId' : {
						select : function(obj, record) {
							var this$ = this;
							var portalId = this.getCurrentLoggedPortalId();
							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							var facultyId = null;
							if (portalId == 2) {
								facultyId = this
								.getCurrentlyLoggedInUser().id;
							}
							var batchId = record[0].get("id");
							if (batchId > 0) {
								var form = this
								.getConsolidatesearchattendance();
								form.down("#periodIdItemId")
								.setDisabled(false);
								var store = form.down("#periodIdItemId").getStore();
								store.getProxy().extraParams = {
									id : batchId,
									//isCurrentPeriod : true
								};
								store.load({
									callback: function(records, operation, success) {
										if (success) {
											if(records.length==0){
												form.down("#programCoursection_ID").setDisabled(true);
												if(wheatherSchool) {
													showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

												} 
											}
											if(records.length==1){
												form.down("#periodIdItemId").setValue(records[0].get('id'))
												form.down("#programCoursection_ID").setDisabled(false);
												var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
												store.getProxy().extraParams = {
													periodId: records[0].get('id'),
													facultyId : facultyId
												};
												store.load({
													callback: function(records, operation, success) {
														if (success) {
															if(records.length==1){
																form.down("#programCoursection_ID").setValue(records[0].data.sectionId);
																//this$.loadConsolidateAttendanceGrid();
															}
														}
													}
												});

											}
										}
									}
								});
							}
						},
						change :function(obj, record){
							this.validateSearchButton();
						}
					},
					

					'consolidatesearchattendance combo#periodIdItemId' : {
						select : function(obj, record) {
							var this$ = this;
							var portalId = this.getCurrentLoggedPortalId();
							var facultyId = null;
							if (portalId == 2) {
								facultyId = this
								.getCurrentlyLoggedInUser().id;
							}
							var periodId = record[0].get("id");
							if (periodId > 0) {
								var form = this
								.getConsolidatesearchattendance();
								form
								.down(
								"#programCoursection_ID")
								.setDisabled(false);
								var store = this
								.getStore('attendance.SectionAndFacultyByPeriodID');
								store.getProxy().extraParams = {
									periodId : periodId,
									facultyId :facultyId
								};
								store.load({
									callback: function(records, operation, success) {
										if (success) {
											if(records.length==1){
												form.down("#programCoursection_ID").setValue(records[0].data.sectionId);
												//this$.loadConsolidateAttendanceGrid();
											}
										}
									}
								});

							}
						},
						
						change :function(obj, record){
							this.validateSearchButton();
						}
					},
					

					'consolidatesearchattendance' : {
						afterrender : function() {
							var form = this
							.getConsolidatesearchattendance();
							var facultyCombo = form
							.down('#facultyName_Id');
							var facultyCodeCombo = form
							.down('#facultyCode_Id');
							var portalId = this
							.getCurrentLoggedPortalId();
							if (portalId == 2) {
								facultyCombo.setVisible(false);
								facultyCodeCombo.setVisible(false);
							}
							
						}
					},
					'consolidateattendancegrid button[itemId=btnDelete]':{
						click: function() {
							var $this = this;
							var portalId = this.getCurrentLoggedPortalId();
							var studentAttendanceType = "";
							if(portalId==2){
								var form=$this.getDailyattendancestructureforfaculty();
								studentAttendanceType=form.down('#dailyAttendanceTypeRadio').getValue().dailyAttendanceTypeWise;
							}else{
								studentAttendanceType=$this.getConsolidateattendancestructure().down('#attendanceTypeRadio').getValue().attendanceTypeWise;;
							}
							this.deleteAttendanceRecord(studentAttendanceType);
						}
					},
					'consolidateattendancegrid button[itemId=btnEdit]':{
						click: function() {
							var $this = this;
							var portalId = this.getCurrentLoggedPortalId();
							var studentAttendanceType = "";
							if(portalId==2){
								var form=$this.getDailyattendancestructureforfaculty();
								studentAttendanceType=form.down('#dailyAttendanceTypeRadio').getValue().dailyAttendanceTypeWise;
							}else{
								studentAttendanceType=$this.getConsolidateattendancestructure().down('#attendanceTypeRadio').getValue().attendanceTypeWise;;
							}
							this.editAttendanceRecord(studentAttendanceType, 'edit');
						}
					},
					'consolidateattendancegrid button[itemId=btnView]':{
						click: function() {
							var $this = this;
							var portalId = this.getCurrentLoggedPortalId();
							var studentAttendanceType = "";
							if(portalId==2){
								var form=$this.getDailyattendancestructureforfaculty();
								studentAttendanceType=form.down('#dailyAttendanceTypeRadio').getValue().dailyAttendanceTypeWise;
							}else{
								studentAttendanceType=$this.getConsolidateattendancestructure().down('#attendanceTypeRadio').getValue().attendanceTypeWise;;
							}
							this.editAttendanceRecord(studentAttendanceType, 'view');
						}
					},
					'editstudentattendancegrid':{
						afterrender : function(obj){
							var editController = Academia.app.getController('Academia.controller.attendance.EditAttendanceController');
							editController.editAttendanceRadioFields();   
							this.getEditstudentattendancegrid().down('grid').getStore().removeAll();
						}
					}, 
					'tabpanel[itemId=tabpanelIds] tab':{
						activate: function(){
							var  contentPanelMain = this.getContentPanel().getActiveTab();
							contentPanelMain.scrollBy(0,1);
							contentPanelMain.scrollBy(0,-1);
						}
					},
					 
					
					
					'consolidatecoursewisesearchattendance combo#academicTermId' : {
						select : function(obj, record) {
							var form = this.getConsolidatecoursewisesearchattendance();
							var academyLocationId = this$.getCurrentAcademyLocation();
							var intakeYearCombo = form.down('#intakeYearId');
							var courseCombo = form.down('#courseId');
							var courseVariantCombo = form.down('#courseVariantId');
							var facultyCombo = form.down('#facultyId');
							var programCategoryCombo = form.down('#programCategoryId');
							var programCombo = form.down('#programId');
							var batchCombo = form.down('#batchId');
							var periodCombo = form.down('#periodId');
							var topicsCombo = form.down('#courseTopicId');
							 
							var grid = this.getConsolidateattendancecoursewisegrid();
							grid.down('#btnView').setDisabled(false);
							grid.down('#btnEdit').setDisabled(false);
							grid.down('#btnDelete').setDisabled(false);
							intakeYearCombo.reset();
							courseCombo.reset();
							facultyCombo.reset();
							courseVariantCombo.reset();
							programCategoryCombo.reset();
							programCombo.reset();
							batchCombo.reset();
							periodCombo.reset();
							topicsCombo.reset();
							topicsCombo.setDisabled(true);
							courseVariantCombo.setDisabled(true);
							batchCombo.setDisabled(true);
							periodCombo.setDisabled(true);
							
							var intakeYearStore = intakeYearCombo.getStore();
							var courseStore = courseCombo.getStore();
							var facultyStore = facultyCombo.getStore();
							var programCategoryStore = programCategoryCombo.getStore();
							var programStore = programCombo.getStore();
							var academicTermId = record[0].get('id');
							intakeYearStore.getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								academicTermId:academicTermId
							};
							intakeYearStore.load();
							courseStore.getProxy().extraParams = {
								academyLocationIds : academyLocationId,
								academicTermId:academicTermId
							};
							courseStore.load();
							facultyStore.getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								academicTermId:academicTermId
							};
							facultyStore.load();
							programCategoryStore.getProxy().extraParams = {
								 academyLocationIds:academyLocationId,
								 academicTermId:academicTermId
							 };
							 programCategoryStore.load();
							programStore.getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								academicTermId:academicTermId
							};
							programStore.load();
						}
					},
					'consolidatecoursewisesearchattendance combo#intakeYearId' : {
						select : function(obj, record) {
							var form = this.getConsolidatecoursewisesearchattendance();
							var academyLocationId = this$.getCurrentAcademyLocation();
							var academicTermCombo = form.down('#academicTermId');
							var courseCombo = form.down('#courseId');
							var courseVariantCombo = form.down('#courseVariantId');
							var facultyCombo = form.down('#facultyId');
							var programCategoryCombo = form.down('#programCategoryId');
							var programCombo = form.down('#programId');
							var batchCombo = form.down('#batchId');
							var periodCombo = form.down('#periodId');
							var topicsCombo = form.down('#courseTopicId');
							
							var grid = this.getConsolidateattendancecoursewisegrid();
							grid.down('#btnView').setDisabled(false);
							grid.down('#btnEdit').setDisabled(false);
							grid.down('#btnDelete').setDisabled(false);
							courseCombo.reset();
							facultyCombo.reset();
							courseVariantCombo.reset();
							programCategoryCombo.reset();
							programCombo.reset();
							batchCombo.reset();
							periodCombo.reset();
							topicsCombo.reset();
							topicsCombo.setDisabled(true);
							courseVariantCombo.setDisabled(true);
							batchCombo.setDisabled(true);
							periodCombo.setDisabled(true);
							var courseStore = courseCombo.getStore();
							var facultyStore = facultyCombo.getStore();
							var programCategoryStore = programCategoryCombo.getStore();
							var programStore = programCombo.getStore();
							var intakeYearId = record[0].get('id');
							var academicTermId = academicTermCombo.getValue();
							courseStore.getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								academicTermId:academicTermId,
								intakeYearId:intakeYearId
							};
							courseStore.load();
							facultyStore.getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								academicTermId:academicTermId,
								intakeYearId:intakeYearId
							};
							facultyStore.load();
							programCategoryStore.getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								academicTermId:academicTermId,
								intakeYearId:intakeYearId
							};
							programCategoryStore.load();
							programStore.getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								academicTermId:academicTermId,
								intakeYearId:intakeYearId
							};
							programStore.load();
						}
					},
					
					'consolidatecoursewisesearchattendance combo#courseId' : {
						select : function(obj, record) {
							var this$ = this;
							var form = this.getConsolidatecoursewisesearchattendance();
							var academyLocationId = this$.getCurrentAcademyLocation();
							var courseId = record[0].data.courseId;
							var componentId = record[0].data.courseComponentId;
							var academicTermCombo = form.down('#academicTermId');
							var intakeYearCombo = form.down('#intakeYearId');
							var topicsCombo = form.down('#courseTopicId');
							var courseVariantCombo = form.down('#courseVariantId');
							var facultyCombo = form.down('#facultyId');
							var programCombo = form.down('#programId');
							var batchCombo = form.down('#batchId');
							var periodCombo = form.down('#periodId');
							var programCategoryCombo = form.down('#programCategoryId');
							if(isNullOrEmpty(programCategoryCombo.getValue())){
								var grid = this.getConsolidateattendancecoursewisegrid();
								grid.down('#btnView').setDisabled(false);
								grid.down('#btnEdit').setDisabled(false);
								grid.down('#btnDelete').setDisabled(false);
							}
							
							facultyCombo.reset();
							topicsCombo.reset();
							courseVariantCombo.reset();
							programCombo.reset();
							batchCombo.reset();
							periodCombo.reset();
							batchCombo.setDisabled(true);
							periodCombo.setDisabled(true);
							topicsCombo.setDisabled(false);
							var academicTermId = academicTermCombo.getValue();
							var intakeYearId = intakeYearCombo.getValue();
							courseVariantCombo.setDisabled(false);
							var academicTermId = academicTermCombo.getValue();
							var intakeYearId = intakeYearCombo.getValue();
							var facultyStore = facultyCombo.getStore();
							var programStore = programCombo.getStore();
							var topicName = topicsCombo.getValue();
							
							
							
							var courseVariantStore = courseVariantCombo.getStore();
							courseVariantStore.getProxy().extraParams = {
								academyLocationIds : academyLocationId,
								academicTermId : academicTermId,
								intakeYearId : intakeYearId,
								courseId : courseId
							};
							courseVariantStore.load({
								callback: function(records, operation, success) {
									if (success) {
										if(records.length==1){
											courseVariantCombo.setValue(records[0].get('id'));
											facultyStore.getProxy().extraParams = {
												academyLocationIds:academyLocationId,
												academicTermId:academicTermId,
												intakeYearId:intakeYearId,
												courseId : courseId,
												courseVariantId : records[0].get('id')
											};
											//facultyStore.load();
										}else{
											facultyStore.getProxy().extraParams = {
												academyLocationIds:academyLocationId,
												academicTermId:academicTermId,
												intakeYearId:intakeYearId,
												courseId : courseId
											};
											//facultyStore.load();
										}
									}
								}	   
							});
							
							var courseTopicStore = topicsCombo.getStore();
							courseTopicStore.getProxy().extraParams = {
								courseId : courseId,
								componentId : componentId,
								topicName : topicName
							};
							//courseTopicStore.load();
							
							programStore.getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								academicTermId:academicTermId,
								intakeYearId:intakeYearId,
								courseId : courseId
							};
							//programStore.load();
						}
					},
					
					'consolidatecoursewisesearchattendance combo#courseVariantId' : {
						select : function(obj, record) {
							var this$ = this;
							var form = this.getConsolidatecoursewisesearchattendance();
							var academyLocationId = this$.getCurrentAcademyLocation();
							var facultyCombo = form.down('#facultyId');
							var courseCombo = form.down('#courseId');
							var academicTermCombo = form.down('#academicTermId');
							var intakeYearCombo = form.down('#intakeYearId');
							var programCombo = form.down('#programId');
							var batchCombo = form.down('#batchId');
							var periodCombo = form.down('#periodId');
							var programCategoryCombo = form.down('#programCategoryId');
							if(isNullOrEmpty(programCategoryCombo.getValue())){
								var grid = this.getConsolidateattendancecoursewisegrid();
								grid.down('#btnView').setDisabled(false);
								grid.down('#btnEdit').setDisabled(false);
								grid.down('#btnDelete').setDisabled(false);
							}
							facultyCombo.reset();
							programCategoryCombo.reset();
							programCombo.reset();
							batchCombo.reset();
							periodCombo.reset();
							batchCombo.setDisabled(true);
							periodCombo.setDisabled(true);
							var academicTermId = academicTermCombo.getValue();
							var intakeYearId = intakeYearCombo.getValue();
							var courseId=courseCombo.getValue();
							var courseVariantId = record[0].data.id;
							var programStore = programCombo.getStore();
							var facultyStore = facultyCombo.getStore();
							facultyStore.getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								academicTermId:academicTermId,
								intakeYearId:intakeYearId,
								courseId : courseId,
								courseVariantId : courseVariantId
							};
							//facultyStore.load();
							programStore.getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								academicTermId:academicTermId,
								intakeYearId:intakeYearId,
								courseId : courseId,
								courseVariantId : courseVariantId
							};
							//programStore.load();
						}
					},
					'consolidatecoursewisesearchattendance combo#programCategoryId' : {
						select : function(obj, record) {
							var this$ = this;
							var form = this.getConsolidatecoursewisesearchattendance();
							var academyLocationId = this$.getCurrentAcademyLocation();
							var programCombo = form.down('#programId');
							var courseCombo = form.down('#courseId');
							var academicTermCombo = form.down('#academicTermId');
							var intakeYearCombo = form.down('#intakeYearId');
							var batchCombo = form.down('#batchId');
							var periodCombo = form.down('#periodId');
							var grid = this.getConsolidateattendancecoursewisegrid();
							grid.down('#btnView').setDisabled(true);
							grid.down('#btnEdit').setDisabled(true);
							grid.down('#btnDelete').setDisabled(true);
							
							programCombo.reset();
							batchCombo.reset();
							periodCombo.reset();
							batchCombo.setDisabled(true);
							periodCombo.setDisabled(true);
							var academicTermId = academicTermCombo.getValue();
							var intakeYearId = intakeYearCombo.getValue();
							var courseId=courseCombo.getValue();
							var programCategoryId = record[0].data.id;
							var programStore = programCombo.getStore();
							programStore.getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								academicTermId:academicTermId,
								intakeYearId:intakeYearId,
								programCategoryId:programCategoryId,
								courseId:courseId
							};
							//programStore.load();
						}
					},
					'consolidatecoursewisesearchattendance combo#programId' : {
						select : function(obj, record) {
							var this$ = this;
							var form = this.getConsolidatecoursewisesearchattendance();
							var academyLocationId = this$.getCurrentAcademyLocation();
							var programCategoryCombo = form.down('#programCategoryId');
							var courseCombo = form.down('#courseId');
							var academicTermCombo = form.down('#academicTermId');
							var intakeYearCombo = form.down('#intakeYearId');
							var academicTermId = academicTermCombo.getValue();
							var intakeYearId = intakeYearCombo.getValue();
							var courseId=courseCombo.getValue();
							var programCategoryId = programCategoryCombo.getValue();
							var programId = record[0].data.id;
							var batchCombo = form.down('#batchId');
							batchCombo.setDisabled(false);
							var periodCombo = form.down('#periodId');
							var grid = this.getConsolidateattendancecoursewisegrid();
							grid.down('#btnView').setDisabled(true);
							grid.down('#btnEdit').setDisabled(true);
							grid.down('#btnDelete').setDisabled(true);
							batchCombo.reset();
							periodCombo.reset();
							periodCombo.setDisabled(true);
							var periodStore = periodCombo.getStore();
							var batchStore = batchCombo.getStore();
							batchStore.getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								academicTermId:academicTermId,
								intakeYearId:intakeYearId,
								programCategoryId:programCategoryId,
								courseId:courseId,
								programId:programId
							};
							batchStore.load({
								callback: function(records, operation, success) {
									if (success) {
										if(records.length==1){
											batchCombo.setValue(records[0].get('id'));
											periodCombo.setDisabled(false);
											periodStore.getProxy().extraParams = {
												academyLocationIds:academyLocationId,
												academicTermId:academicTermId,
												intakeYearId:intakeYearId,
												programCategoryId:programCategoryId,
												courseId:courseId,
												programId:programId,
												batchId:records[0].get('id')
											};
											periodStore.load({
												callback: function(records, operation, success) {
													if (success) {
														if(records.length==1){
															periodCombo.setValue(records[0].get('id'));
														}
													}
												}
											});
										}
										else{
											periodStore.getProxy().extraParams = {
												academyLocationIds:academyLocationId,
												academicTermId:academicTermId,
												intakeYearId:intakeYearId,
												programCategoryId:programCategoryId,
												courseId:courseId,
												programId:programId
											};
											periodStore.load();
										}
									}
								}
							});
						}
					},
					'consolidatecoursewisesearchattendance combo#batchId' : {
						select : function(obj, record) {
							var this$ = this;
							var form = this.getConsolidatecoursewisesearchattendance();
							var academyLocationId = this$.getCurrentAcademyLocation();
							var programCategoryCombo = form.down('#programCategoryId');
							var courseCombo = form.down('#courseId');
							var academicTermCombo = form.down('#academicTermId');
							var intakeYearCombo = form.down('#intakeYearId');
							var academicTermId = academicTermCombo.getValue();
							var intakeYearId = intakeYearCombo.getValue();
							var courseId=courseCombo.getValue();
							var programCategoryId = programCategoryCombo.getValue();
							var batchId = record[0].data.id;
							var programCombo = form.down('#programId');
							var programId = programCombo.getValue();
							var periodCombo = form.down('#periodId');
							periodCombo.reset();
							periodCombo.setDisabled(false);
							var periodStore = periodCombo.getStore();
							periodStore.getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								academicTermId:academicTermId,
								intakeYearId:intakeYearId,
								programCategoryId:programCategoryId,
								courseId:courseId,
								programId:programId,
								batchId:batchId
							};
							periodStore.load({
								callback: function(records, operation, success) {
									if (success) {
										if(records.length==1){
											periodCombo.setValue(records[0].get('id'));
										}
									}
								}
							});
						}
					},
					'consolidatecoursewisesearchattendance button[itemId=resetBtn]' : {
						click : function(obj, record) {
							this.courseWiseReportRender();
							var form = this.getConsolidatecoursewisesearchattendance();
							form.down('#moreDetailId').collapse(true);
							form.down("#consolidateStartDate").reset();
							form.down("#consolidateEndDate").reset();
							form.down('#fromTime').reset();
							form.down("#toTime").reset();
							form.down('#courseTopicId').reset();
							form.down('#courseTopicId').setDisabled(true);
							form.down('#consolidateStartDate').setMinValue(false);
							form.down('#consolidateStartDate').setMaxValue(new Date());
							form.down('#consolidateEndDate').setMinValue(false);
							form.down('#consolidateEndDate').setMaxValue(new Date());
							form.down('#fromTime').setMinValue(false);
							form.down('#fromTime').setMaxValue(false);
							form.down('#toTime').setMinValue(false);
							form.down('#toTime').setMaxValue(false);
							form.down('#toTime').setMaxValue(false);
						}
					},
					'consolidateattendancecoursewisegrid button[itemId=btnDelete]':{
						click: function() {
							var $this = this;
							var portalId = this.getCurrentLoggedPortalId();
							var studentAttendanceType = "";
							if(portalId==2){
								var form=$this.getDailyattendancestructureforfaculty();
								studentAttendanceType=form.down('#dailyAttendanceTypeRadio').getValue().dailyAttendanceTypeWise;
							}else{
								studentAttendanceType=$this.getConsolidateattendancestructure().down('#attendanceTypeRadio').getValue().attendanceTypeWise;;
							}
							this.deleteAttendanceRecord(studentAttendanceType);
						}
					},
					'consolidateattendancecoursewisegrid button[itemId=btnEdit]':{
						click: function() {
							var $this = this;
							var portalId = this.getCurrentLoggedPortalId();
							var studentAttendanceType = "";
							if(portalId==2){
								var form=$this.getDailyattendancestructureforfaculty();
								studentAttendanceType=form.down('#dailyAttendanceTypeRadio').getValue().dailyAttendanceTypeWise;
							}else{
								studentAttendanceType=$this.getConsolidateattendancestructure().down('#attendanceTypeRadio').getValue().attendanceTypeWise;;
							}
							
							$this.editAttendanceRecord(studentAttendanceType, 'edit');
						}
					},
					'consolidateattendancecoursewisegrid button[itemId=btnView]':{
						click: function() {
							var $this = this;
							var portalId = this.getCurrentLoggedPortalId();
							var studentAttendanceType = "";
							if(portalId==2){
								var form=$this.getDailyattendancestructureforfaculty();
								studentAttendanceType=form.down('#dailyAttendanceTypeRadio').getValue().dailyAttendanceTypeWise;
							}else{
								studentAttendanceType=$this.getConsolidateattendancestructure().down('#attendanceTypeRadio').getValue().attendanceTypeWise;;
							}
							this.editAttendanceRecord(studentAttendanceType, 'view');
						}
					},
					'consolidatecoursewisesearchattendance button[itemId=searchBtn]' : {
						click : function() {
							var $this = this;
							var attendanceType=$this.getConsolidateattendancestructure().down('#attendanceTypeRadio').getValue().attendanceTypeWise;
							this.loadConsolidateAttendanceCourseWiseGrid(attendanceType);
						}
					
					},
					
					'consolidatecoursewisesearchattendance button[itemId=GenrateQR]' : {
						click : function() {
							var $this = this;
							var attendanceType=$this.getConsolidateattendancestructure().down('#attendanceTypeRadio').getValue().attendanceTypeWise;
							var grid = this.getConsolidateattendancecoursewisegrid();
							var form = this.getConsolidatecoursewisesearchattendance().getForm();
							var values = form.getValues();
							var store = grid.getStore();
							var academyLocationId = this.getCurrentAcademyLocation();
							var sectionId = values.sectionId;
							var courseId = values.courseId;
							var courseVariantId = values.courseVariant;
							var facultyId = values.faculty;
							var academyLocationId = this.getCurrentAcademyLocation();
							var startDate = values.consolidateStartDate;
							var endDate = values.consolidateEndDate;
							var fromTime = values.fromTime;
							var toTime = values.toTime;
							var programId = values.program;
							var batchId = values.batch;
							var periodId = values.period;
							var academicTermId = values.academicTerm;
							var intakeYearId = values.intakeYear;
							var programCategoryId = values.programCategory;
							//var topicName = values.topicName;
							var courseTopicId = values.courseTopic;
							var qrDataModel = {};
							var qrData = '';
							
							qrDataModel.qrData = {
									   qrId: form.responseText,
									   courseVariantId:courseVariantId,
									   courseId:courseId
									
							   };
							
							var qrDisplayData = $this.getConsolidatecoursewisesearchattendance().getForm().findField('courseId').getDisplayValue()
	                        + ' | ' + $this.getConsolidatecoursewisesearchattendance().getForm().findField('courseVariant').getDisplayValue();
	 						
							
							Ext.Ajax.request({
			                    type: 'rest',
			                    url: SERVERURL.PATH_COURSE_ATTENDANCE_QR,										 
			                    method: 'GET',
			                    headers: {
			                        'Content-Type': 'application/json'
			                    },
			                    params: {
			                    
									courseVariantId:courseVariantId,
									academyLocationId:academyLocationId,
									sectionId:sectionId,
									attendanceType:attendanceType,
									facultyId:facultyId,
									attendanceDate:startDate,
									slotFrom:fromTime,
									slotTo:toTime,
									programId:programId,
									batchId:batchId,
									periodId:periodId	
			                    },
			                    success: function(form, action) {
			                    	if(isNullOrEmpty(form.responseText)){
			                    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('THE_QR_CODE_FOR_THIS_SESSION_IS_NOT_YET_GENERATED_YOU_CAN_GENERATE_IT_FROM_CAPTURE_ATTENDANCE_SCREEN'));
			                    	}else{

			                    		Ext.Ajax.request({
						                    type: 'rest',
						                    url: SERVERURL.PATH_COURSE_ATTENDANCE_QR_CODE,											 
						                    method: 'GET',
						                    headers: {
						                        'Content-Type': 'application/json'
						                    },
						                    params: {
												courseVariantId:courseVariantId,
												academyLocationId:academyLocationId,
												sectionId:sectionId,
												attendanceType:attendanceType,
												facultyId:facultyId,
												attendanceDate:startDate,
												slotFrom:fromTime,
												slotTo:toTime,
												programId:programId,
												batchId:batchId,
												periodId:periodId	
						                    },
						                    success: function(form1, action1) {
						                    	if(isNullOrEmpty(form1.responseText)){
						                    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('THE_QR_CODE_FOR_THIS_SESSION_IS_NOT_YET_GENERATED_YOU_CAN_GENERATE_IT_FROM_CAPTURE_ATTENDANCE_SCREEN'));
						                    	}else{
						                    		
						                    		var qrCodeText = '';
						                    		if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
						                    			qrCodeText = 'CD-'+form1.responseText; //CompleteDay
						                    		}
						                    		else if(attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION'){
						                    			qrCodeText = 'MS-'+form1.responseText; //MultipleSessions
						                    		}
						                    		else{
						                    			qrCodeText = 'CW-'+form1.responseText; //CourseWise
						                    		}
						                    		
						                    		var formWindow =  $this.getQrcodewindow();
						                    		if (!formWindow) {
						                    			Ext.widget('qrcodewindow',{
						                    				qrData: Ext.encode(qrDataModel.qrData),
						                    				path:form.responseText,
						                    				qrDisplayData: qrDisplayData,
						                    				qrCode: qrCodeText,
						                    				itemId: 'attendanceReportQRWin'
						                    			})
						                    			formWindow =  $this.getQrcodewindow();
						                    		}
						                    		formWindow.show();
						                    	}
						     				
						                    }
						                });
			                    	
			                    	}
			     				
			                    }
			                });
						}
					
					},
					
					'consolidateattendancecoursewisegrid[itemId=consolidateattendancecoursewisegrid]':{
						cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							var $this=this;
							var searchResultGrid = $this.getConsolidateattendancecoursewisegrid();
							var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

							if(columnName=='totalStudents' &&  record.data.totalStudents > 0){
								this.totalStudentRecords(record);
							}	
							if (e.target.tagName == 'A' && columnName=='assignedTopicCount') {
		 		           		this.viewAssignedTopics('View', record);
		 		           	}
						}
					},
					
				
					
					'consolidatesearchattendance customcombobox[itemId=programBatch_batchId]':{
						change :this.validateQRBtn
					},
					'consolidatesearchattendance customcombobox[itemId=programCoursection_ID]':{
						change :this.validateQRBtn
					},
					'consolidatesearchattendance customcombobox[itemId=facultyName_Id]':{
						change :this.validateQRBtn
					},
					'consolidatesearchattendance datefield[itemId=consolidateStartDate]':{
						change :this.validateQRBtn
					},
					'consolidatecoursewisesearchattendance customcombobox[itemId=courseId]':{
						change :this.validateQRBtnForCourseWiseAttendance
					},
					
					'consolidatecoursewisesearchattendance customcombobox[itemId=courseVariantId]':{
						change :this.validateQRBtnForCourseWiseAttendance
					},
					'consolidatecoursewisesearchattendance customcombobox[itemId=facultyId]':{
						change :this.validateQRBtnForCourseWiseAttendance
					},
					'consolidatecoursewisesearchattendance datefield[itemId=consolidateStartDate]':{
						change :this.validateQRBtnForCourseWiseAttendance
					},
					'consolidatecoursewisesearchattendance timefield[itemId=fromTime]':{
						change :this.validateQRBtnForCourseWiseAttendance
					},

				});
			},
			
			validateQRBtn: function(btn){
				var form = this.getConsolidatesearchattendance();
				//var field1;
				var programField=form.down('#programBatch_programId').getValue();
				var batchField=form.down('#programBatch_batchId').getValue();
				var sectionField=form.down('#programCoursection_ID').getValue();
				var facultyField=form.down('#facultyName_Id').getValue();
				var StartDateField=form.down('#consolidateStartDate').getValue();
				 var button=form.down('#GenrateQR');
				
				if(!isNullOrEmpty(programField) && !isNullOrEmpty(batchField) && !isNullOrEmpty(sectionField) && !isNullOrEmpty(facultyField) && !isNullOrEmpty(StartDateField)){
					button.setDisabled(false);
				}
				else{
					button.setDisabled(true);
				}

			},
			
			validateSearchButton: function(btn){
				var form = this.getConsolidatesearchattendance();
				var searchButton=form.down('#searchBtn');
				
				var isValid=true;
				var fieldsArray=[
					form.down('#programBatch_programId'),
					form.down('#programBatch_batchId'),
				    form.down('#periodIdItemId')
				];
				
				Ext.each(fieldsArray,function(field){
					if(field.isVisible()&& !field.allowBlank && isNullOrEmpty(field.getValue())){
						isValid=false;
					}
				});
				
				if(isValid){
					searchButton.setDisabled(false);	
				}else{
					searchButton.setDisabled(true);
				}

			},
			
			validateQRBtnForCourseWiseAttendance: function(btn){
				
				var form = this.getConsolidatecoursewisesearchattendance();
				//var field1;
				var courseField=form.down('#courseId').getValue();
				var courseVariantField=form.down('#courseVariantId').getValue();
				var facultyField=form.down('#facultyId').getValue();
				var StartDate=form.down('#consolidateStartDate').getValue();
				var StartTime=form.down('#fromTime').getValue();
				
				 var button=form.down('#GenrateQR');
				
				if(!isNullOrEmpty(courseField) && !isNullOrEmpty(courseVariantField) && !isNullOrEmpty(facultyField) && !isNullOrEmpty(StartDate) && !isNullOrEmpty(StartTime)){
					button.setDisabled(false);
				}
				else{
					button.setDisabled(true);
				}
			},
			
			
			
			consolidateStudentAttendanceTypeRadio:function(form,permissionList){
				var this$ = this;
				var academyLocationId = this.getCurrentAcademyLocation();
				var studentAttendanceType = [];
				var attendanceType=[];
				form = this$.getConsolidateattendancestructure();
				var attendanceTypeRadio=form.down('#attendanceTypeRadio');
				Ext.Ajax.request({
					type : 'rest',
					async: false,
					url : SERVERURL.GET_SESSION_VALUE_BY_ACA_LOCATION,
					params : {
						academyLocatonId : academyLocationId
					},
					method : 'GET',
					success : function(f, action) {
						if(isNullOrEmpty(f.responseText))
						{
							showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));	 
						}else{
							var res = Ext.JSON.decode(f.responseText);
							Ext.each(res, function(data) {
								attendanceType.push(data.studentAttendanceType);
							});
						}
					}
				});
				//--setting initial values to false
				var tab2=false, tab3=false,tab4=false;

				//--initially setting all radio fields to true
				var completeDayRadio = form.down('[inputValue=COMPLETE_DAY]');
				var courseLevelRadio = form.down('[inputValue=COURSE_LEVEL]');
				var multipleSessionRadio = form.down('[inputValue=MULTIPLE_SESSION]');
				attendanceTypeRadio.items.items[0].setVisible(true);
				attendanceTypeRadio.items.items[1].setVisible(true);
				attendanceTypeRadio.items.items[2].setVisible(true);

				//--checking for the visible tabs
				if((Ext.Array.contains(permissionList, 'PROGRAM_WISE'))&&(Ext.Array.contains(attendanceType, 'COMPLETE_DAY') || Ext.Array.contains(attendanceType, 'Complete Day'))){
					tab2=true;
				}
				if((Ext.Array.contains(permissionList, 'COURSE_WISE'))&&(Ext.Array.contains(attendanceType, 'COURSE_LEVEL') || Ext.Array.contains(attendanceType, 'Course Level'))){
					tab3=true;
				}
				if((Ext.Array.contains(permissionList, 'SESSION_WISE'))&&(Ext.Array.contains(attendanceType, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceType, 'Multiple Session'))){
					tab4=true;
				}

				if(!tab2 && !tab3 && !tab4){
					tab2=true;
				}

				if((!tab2 && !tab3) || (!tab3 && !tab4) || (!tab4 && !tab2)){
					attendanceTypeRadio.setVisible(false);
				}
				else {
					attendanceTypeRadio.setVisible(true);
				}

				//-- setting values to true/false on the basis of visible tabs
				if(!tab2){
					attendanceTypeRadio.items.items[0].setVisible(false);
				}
				if(!tab3){
					attendanceTypeRadio.items.items[1].setVisible(false);
				}
				if(!tab4){
					attendanceTypeRadio.items.items[2].setVisible(false);
				}

				//-- setting radioGroup value on the basis of visible tabs
				setTimeout(function(){
					if(tab2){
						completeDayRadio.setValue(true);
					}
					else if(tab3){
						courseLevelRadio.setValue(true);
					}
					else if(tab4){
						multipleSessionRadio.setValue(true);
					}
				},300);
			},
			consolidateAttendanceTypeDropdown:function(record){
				var this$ = this;
				var academyLocationId = this.getCurrentAcademyLocation();
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var wheatherSchool = alinfomodel.get('wheatherSchool');
				var attendanceType = "";
				var facultyAttendanceType = "";
				var sessionNumber = "";
				var attendanceType = record.attendanceTypeWise;
				Ext.Ajax.request({
					type : 'rest',
					async: false,
					url : SERVERURL.GET_SESSION_VALUE_BY_ACA_LOCATION,
					params : {
						academyLocatonId : academyLocationId,
						attendanceType :attendanceType,
					},
					method : 'GET',
					success : function(f, action) {
						if(isNullOrEmpty(f.responseText))
						{
							showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));	 
						}else{
							var res = Ext.JSON.decode(f.responseText);
							var data=res[0];
							attendanceType = data.studentAttendanceType;
							facultyAttendanceType = data.facultyAttendanceType;
							sessionNumber = data.sessionNo;
						}
					}
				});


				var portalId = this.getCurrentLoggedPortalId();
				var facultyId = this.getCurrentlyLoggedInUser();

				if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
					this$.getConsolidatesearchattendance().setVisible(false);
					var structure = this$.getConsolidateattendancestructure();
					structure.down('#consolidateattendancegrid').hide();
					structure.down('#consolidateattendancecoursewisegrid').show();
					if(!isNullOrEmpty(this$.getConsolidateattendancecoursewisegrid())){
						this$.getConsolidateattendancecoursewisegrid().getStore().removeAll(); 
						try {
							this$.getConsolidateattendancecoursewisegrid().down('custompagingtoolbar').hide();
						}
						catch(e){
						}
					}
					var form = this$.getConsolidatecoursewisesearchattendance();
					form.down('#moreDetailId').collapse(true);
					form.setVisible(true);
					form.down("#consolidateStartDate").reset();
					form.down("#consolidateEndDate").reset();
					form.down('#fromTime').reset();
					form.down("#toTime").reset();
					form.down('#consolidateStartDate').setMinValue(false);
					form.down('#consolidateStartDate').setMaxValue(new Date());
					form.down('#consolidateEndDate').setMinValue(false);
					form.down('#consolidateEndDate').setMaxValue(new Date());
					form.down('#fromTime').setMinValue(false);
					form.down('#fromTime').setMaxValue(false);
					form.down('#toTime').setMinValue(false);
					form.down('#toTime').setMaxValue(false);
					this$.courseWiseReportRender();
				}else {
					var form = this$.getConsolidatesearchattendance();
					form.setVisible(true);
					this$.getConsolidatecoursewisesearchattendance().setVisible(false);
					var structure = this$.getConsolidateattendancestructure();
					structure.down('#consolidateattendancegrid').show();
					structure.down('#consolidateattendancecoursewisegrid').hide();
					form.down("#consolidateStartDate").reset();
					form.down("#consolidateEndDate").reset();
					form.down('#consolidateStartDate').setMinValue(false);
					form.down('#consolidateStartDate').setMaxValue(new Date());
					form.down('#consolidateEndDate').setMinValue(false);
					form.down('#consolidateEndDate').setMaxValue(new Date());
					form.down('#ProgramGroupItemId').setVisible(true);
					if(!isNullOrEmpty(this$.getConsolidateattendancegrid())){
						this$.getConsolidateattendancegrid().getStore().removeAll(); 
						try {
							this$.getConsolidateattendancegrid().down('custompagingtoolbar').hide();
						}
						catch(e){
						}
					}

					var facultyId = null;
					if(portalId==2){
						facultyId = this.getCurrentlyLoggedInUser().id;
					}
					var programByAcademyLocationStore = form.down("#programBatch_programId").getStore();
					programByAcademyLocationStore.getProxy().extraParams = {	
						facultyId : facultyId,
						academyLocationIds:academyLocationId
					};
					programByAcademyLocationStore.load();

					if(wheatherSchool){
						form.down("#periodIdItemId").hide();
						form.down("#periodIdItemId").allowBlank=true;
					}else{
						form.down("#periodIdItemId").setVisible(true);
					}
					form.down("#periodIdItemId").reset();
					form.down("#periodIdItemId").setDisabled(true)
					form.down("#programBatch_programId").setVisible(true);
					//form.down("#programBatch_programId").allowBlank=true;
					form.down("#programBatch_programId").clearValue();
					form.down("#programBatch_batchId").setVisible(true);
					//form.down("#programBatch_batchId").allowBlank=true;
					form.down("#programBatch_batchId").reset();
					form.down("#programBatch_batchId").setDisabled(true);
					form.down("#programCoursection_ID").setVisible(true);
					form.down("#programCoursection_ID").reset();
					form.down("#programCoursection_ID").setDisabled(true);
					form.down("#sessionItemId1").setVisible(false);
					form.down("#sessionItemId1").allowBlank=true;
					form.down('#facultyName_Id').setVisible(true);

					if(attendanceType=='Multiple Session' || attendanceType=='MULTIPLE_SESSION'){
						form.down("#sessionItemId1").setVisible(true);
						var storeArray = [];
						var multipleSessionStore = this.getStore('attendance.MultipleSessionValueStore');
						multipleSessionStore.getProxy().extraParams = {
							type:"multipleSession"
						};
						multipleSessionStore.load({
							callback: function(records, operation, success) {
								if (success) {
									for (s=1;s<=sessionNumber;s++) {
										if(multipleSessionStore.find("code",s)>=0){
											storeArray.push({
												'val':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('value'),
												'code':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('code')
											});
										} else {
											storeArray.push({'val':s,
												'code': s});
										}
									}
								}
								var store1 = Ext.create('Ext.data.Store', {
									fields: ['val','code'],
									data : storeArray
								});
								var l = Ext.ComponentQuery.query('[itemId=sessionItemId1]').length-1;
								Ext.ComponentQuery.query('[itemId=sessionItemId1]')[l].bindStore(store1);
								if(storeArray.length>0)
								{
									Ext.ComponentQuery.query('[itemId=sessionItemId1]')[l].setValue(1);
								}
							}
						})
					}
				}
			},
			loadConsolidateAttendanceGrid:function(record){
				var grid = this.getConsolidateattendancegrid();
				var formFilter = this.getConsolidatesearchattendance();
				formFilter.down('#searchBtn').setDisabled(true);
				var form = formFilter.getForm();
				var values = form.getValues();
				grid.setVisible(true);
				var attendanceType = "";
				var store = grid.getStore();
				var academyLocationId = this.getCurrentAcademyLocation();
				var attendanceType=record;
				var programGroupId = values.programGroup;
				var programId = values.programId;
				var batchId = values.batchId;
				var periodId = values.periodId;
				var sectionId = values.sectionId;
				var facultyName = values.facultyName;
				var facultyCode = values.facultyCode;
				
				var sessionNo = values.sessionNo;
				var academyLocationId = this.getCurrentAcademyLocation();
				var startDate = values.consolidateStartDate;
				var endDate = values.consolidateEndDate;
				var fromTime = values.fromTime;
				var toTime = values.toTime;
				var program;
				if(!isNullOrEmpty(programId)){
					program = programId;
				}else{
					program = '';
				}
				var batch;
				if(!isNullOrEmpty(batchId)){
					batch = batchId;
				}else{
					batch = '';
				}
				var period;
				if(!isNullOrEmpty(periodId)){
					period = periodId;
				}else{
					period = '';
				}
				var section;
				if(!isNullOrEmpty(sectionId)){
					section = sectionId;
				}else{
					section = '';
				}
				var faculty;
				if(!isNullOrEmpty(facultyName)){
					faculty = facultyName;
				}else if(!isNullOrEmpty(facultyCode)){
					faculty = facultyCode;
				}else{
					faculty = '';
				}
				if(this.getCurrentLoggedPortalId() == 2) {
					faculty=this.getCurrentlyLoggedInUser().id;
					grid.columns[7].setVisible(false);
				}
				if(attendanceType=='Multiple Session' || attendanceType=='MULTIPLE_SESSION')
				{
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					if(wheatherSchool){
						grid.columns[3].setVisible(false);
					}else{
						grid.columns[3].setVisible(true);
					}	
					grid.columns[7].setVisible(true);
					
					var submitURL=SERVERURL.GET_COMPLETE_DAY_CONSOLIDATE_ATTENDANCE_REPORT;
					store.getProxy().api.read=submitURL;
					store.getProxy().extraParams = {
						programId:program,
						batchId:batch,
						periodId:period,
						sectionId:section,
						academyLocationId:academyLocationId,
						facultyId:faculty,
						startDate:startDate,
						endDate:endDate,
						sessionNo:sessionNo,
						attendanceType:attendanceType,
						programGroupId :programGroupId
					};
					Ext.getBody().unmask();
					this.resetPageSetting(store);
					store.load({
						callback: function(rec, operation, success) {
							formFilter.down('#searchBtn').setDisabled(false);
						}
					});
					grid.config.searchFilterForm = this.getConsolidatesearchattendance();

				}
				else{
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					if(wheatherSchool){
						grid.columns[3].setVisible(false);
					}else{
						grid.columns[3].setVisible(true);
					}	
					grid.columns[7].setVisible(false);

					var submitURL=SERVERURL.GET_COMPLETE_DAY_CONSOLIDATE_ATTENDANCE_REPORT;
					store.getProxy().api.read=submitURL;
					store.getProxy().extraParams = {
						programId:program,
						batchId:batch,
						periodId:period,
						sectionId:section,
						academyLocationId:academyLocationId,
						facultyId:faculty,
						startDate:startDate,
						endDate:endDate,
						//sessionNo:sessionNo,
						attendanceType:attendanceType,
						programGroupId :programGroupId
					};
					Ext.getBody().unmask();
					this.resetPageSetting(store);
					store.load({
						callback: function(rec, operation, success) {
							formFilter.down('#searchBtn').setDisabled(false);
						}
					});
					grid.config.searchFilterForm = this.getConsolidatesearchattendance();
				}
				var  contentPanelMain = this.getContentPanel().getActiveTab();
				contentPanelMain.scrollBy(0,1);
				contentPanelMain.scrollBy(0,-1);
			},
			deleteAttendanceRecord:function(attendanceType){
				var $this=this;
				var academyLocationId = this.getCurrentAcademyLocation();
				var submitUrl = "";
				if(attendanceType == 'COMPLETE_DAY' || attendanceType == 'Complete Day'){
					var grid = $this.getConsolidateattendancegrid();
					submitUrl = "rest/studentAttendance/deleteCompleteDayAttendance";
				}
				else if(attendanceType == 'MULTIPLE_SESSION' || attendanceType == 'Multiple Session'){
					var grid = $this.getConsolidateattendancegrid();
					submitUrl = "rest/studentAttendance/deleteMultipleSessionAttendance";
				}
				else{
					var grid = $this.getConsolidateattendancecoursewisegrid();
					submitUrl = "rest/studentAttendance/deleteCourseLevelAttendance";
				}
				if (grid.getSelectionModel().getCount() > 0) {
					showConfirmMessage(getProgramandcourseTranslation('ATTENDANCE_RECORD'), getCommonTranslation("DELETE_CONFIRM_MESSAGE"),function(btn,text){
						if (btn == 'yes') {
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							var records = grid.getSelectionModel().getSelection();
							var ids;
							var selectedRecords = new Array();
							var courseIds;
							if(records !=undefined && records.length > 0){
								for(var i=0;i<records.length;i++){
									selectedRecords.push(records[i].raw.attendanceId);
								}
							}
							ids = selectedRecords.join();
							Ext.Ajax.request({
								method : "DELETE",
								type : 'rest',
								url : submitUrl+'?ids='+ ids,
								headers : {
									'Content-Type' : 'application/json'
								},
								success : function(res,form,action) {
									Ext.getBody().unmask();
									if(res.responseText="success"){
										grid.getStore().reload();
										showSuccessMessage(getProgramandcourseTranslation('ATTENDANCE_RECORD'),getProgramandcourseTranslation('ATTENDANCE_DELETED_SUCESSFULLY'));
									}
								}

							});
						}
					});
				}else {
					showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
				}
			},
			editAttendanceRecord : function(studentAttendanceType, etype){
				var $this=this;
				if(studentAttendanceType == 'Course Level' || studentAttendanceType == 'COURSE_LEVEL'){
					var grid = $this.getConsolidateattendancecoursewisegrid();
				}else{
					var grid = $this.getConsolidateattendancegrid();
				}
				
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var wheatherSchool = alinfomodel.get('wheatherSchool');
				var consolidateSearchAttendanceform=$this.getConsolidatesearchattendance();
				var attendanceType = "";
				var academyLocationId = this.getCurrentAcademyLocation();
				var facultyId = null;
				var portalId = this.getCurrentLoggedPortalId();
				if(portalId == 2) {
					var faculty = this.getCurrentlyLoggedInUser();
					facultyId = faculty.id;
				}
				if (grid.getSelectionModel().getCount() == 1) {
					var selectedRecord = grid.getSelectionModel().getSelection()[0];
					if (selectedRecord != "" && selectedRecord != null && selectedRecord != undefined) {
						Ext.Ajax.request({
							type : 'rest',
							async: false,
							url : SERVERURL.CHECK_ALLOWED_BACK_DATE,
							params : {
								academyLocationId : academyLocationId,
								portalId : portalId,
								attendanceDate : Ext.Date.format(new Date(selectedRecord.get('date')), 'Y-m-d'),
								attendanceType : studentAttendanceType
							},
							method : 'GET',
							success : function(f, action) {
								var data = Ext.JSON.decode(f.responseText);
								if(data.id == null && (typeof etype == "undefined" || etype =="edit") )
								{
									showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('BACK_DATE_ATTENDANCE_CAPTURE')+data.backDateAllowed+getProgramandcourseTranslation('CALENDAR_DAYS'));
								}else if(data.id != null || etype =="view"){
									attendanceType = studentAttendanceType;
									var contentPanel = grid.up().up().up(); //get hold of the content panel where we are adding all the tabs
									var structure = Ext.widget('editattendancerecordstructure');
									if(etype=="view"){
										var tabName = getProgramandcourseTranslation('VIEW_MARK_ATTENDANCE');
									}else{
										var tabName = getProgramandcourseTranslation('EDIT_MARK_ATTENDANCE');
									}
									/**
									 * This is to remove tab from content panel and open same tab again
									 */
									var getcontroller=$this.getController('menu.CoreERPNavigationController');
									var attendanceController = Academia.app.getController('Academia.controller.attendance.AttendanceController')
									var getTab = null;
									for(var i =0 ;i<contentPanel.items.length;i++){
										if(contentPanel.items.items[i].title == getProgramandcourseTranslation('EDIT_MARK_ATTENDANCE') || contentPanel.items.items[i].title == getProgramandcourseTranslation('VIEW_MARK_ATTENDANCE')){
											getTab= contentPanel.items.items[i];
										}
									}
									if(getTab!=null){
										contentPanel.remove(getTab, true);
									}
									openTab(contentPanel, tabName, structure);


									try{
										var nGrid = $this.getEditstudentattendancegrid();
										if(etype=="view"){
											nGrid.eType = "view";
										}
										else{
											nGrid.eType = "edit";
										}
									}
									catch(e){}
								}
							}
						});
						if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
							var form = this.getEditstudentattendance();
							var editForm=form.getForm();
							editForm.findField('attendanceType').setValue(attendanceType);
							var grid =  $this.getEditstudentattendancegrid();
							var store = $this.getStore('attendance.EditStudentAttendanceListStore');
							store.getProxy().extraParams = {
								attendanceId : selectedRecord.get('attendanceId'),
								attendanceType : attendanceType
							};
							store.load({
								callback: function(records, operation, success) {
									records = Ext.decode(operation.response.responseText);
									var tempArray =  grid.temp;
									if(tempArray.length > 0){
										tempArray.pop();
									}
									if (success) {
										if(!isNullOrEmpty(records)){
											form.down('#programBatch_Id').setVisible(false);   
											form.down('#programName').setVisible(false);
											form.down('#batchName').setVisible(false);
											form.down('#periodIdItemId').setVisible(false);
											form.down('#programCoursection_ID').setVisible(false);
											form.down('#facutlyId').setVisible(false);
											form.down('#dateOfAttendance_Id').setVisible(false);
											form.down('#courseId').setVisible(true);
											form.down('#courseId').setValue(records.courseName);
											form.down('#sessionItemId').setVisible(false);
											tempArray.push({
												courseId : records.courseId,
												courseVariantId : records.courseVariantId,
												sectionId : records.sectionId,
												facultyId : records.facultyId,
												dateOfAttendance : records.dateOfAttendance,
												fromTime : records.fromTime,
												toTime : records.toTime,
												attendanceId : records.attendanceId
											})
											if(!isNullOrEmpty(records.componentName)){
												form.down('#componentId').setVisible(false);
												form.down('#componentId').setValue(records.componentName);
												if(tempArray.length > 0){
													tempArray[0].componentId = records.componentId

												}
											}
											if(!isNullOrEmpty(records.courseVariantCode)){
												form.down('#courseVariantId').setVisible(true);
												form.down('#courseVariantId').setValue(records.courseVariantCode);
											}
											if(!isNullOrEmpty(records.programName)){
												form.down('#courseProgramID').setVisible(true);
												form.down('#programBatchCourseID').setVisible(true);
												form.down('#courseProgramID').setValue(records.programName);
												form.down('#programBatchCourseID').setValue(records.batchName);
												form.down('#coursePeriodIdItemId').setVisible(true);
												form.down('#coursePeriodIdItemId').setValue(records.periodName);
												form.down('#programCoursection_ID').setVisible(true);
												form.down('#programCoursection_ID').setValue(records.sectionName);
												if(tempArray.length > 0){
													tempArray[0].programId = records.programId;
													tempArray[0].batchId = records.batchId;
													tempArray[0].periodId = records.periodId;
													tempArray[0].sectionId = records.sectionId;
												}
											}
											form.down('#facutlyId').setVisible(true);
											form.down('#facutlyId').setValue(records.facultyName);
											form.down('#dateOfAttendance_Id').setVisible(true);
											form.down('#dateOfAttendance_Id').setValue(dateRender(records.dateOfAttendance));
											form.down('#timeContainer').setVisible(true);
											form.down('#sessionTime').setVisible(true);
											form.down('#sessionTime').setValue(records.sessionTime);
											form.down('#topicName').setVisible(true);
											form.down('#topicName').setValue(records.topicName);

											var editController = Academia.app.getController('Academia.controller.attendance.EditAttendanceController');
											editController.loadEditAttendanceSummary();
											$this.getEditattendancerecordstructure().down('#submitAttendanceBtn').setDisabled(false);
										}else{
											$this.getEditattendancerecordstructure().down('#submitAttendanceBtn').setDisabled(true);
										}

										try{
											if(etype == "view"){
												$this.getEditattendancerecordstructure().down('#markOnlyAttendance_Id').setVisible(false);
												$this.getEditattendancerecordstructure().down('#editOtherStatusId').setVisible(false);
												$this.getEditattendancerecordstructure().down('#submitAttendanceBtn').setVisible(false);
												$this.getEditattendancerecordstructure().down('#cancelAttendanceBtn').setVisible(false);
											}
										}
										catch(e){}
									}
								}	   
							});
						}else if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
							var form = this.getEditstudentattendance();
							var editForm=form.getForm();
							editForm.findField('attendanceType').setValue(attendanceType);
							var grid = $this.getEditstudentattendancegrid();
							var store = $this.getStore('attendance.EditStudentAttendanceListStore');
							store.getProxy().extraParams = {
								attendanceId : selectedRecord.get('attendanceId'),
								attendanceType : attendanceType
							};
							store.load({
								callback: function(records, operation, success) {
									var records = Ext.decode(operation.response.responseText);
									var tempArray =  grid.temp;
									if(tempArray.length > 0){
										tempArray.pop();
									}
									if (success) {
										if(!isNullOrEmpty(records)){
											form.down('#programName').setVisible(true);
											form.down('#programName').setValue(records.programName);
											tempArray.push({
												programId : records.programId,
												batchId : records.batchId,
												periodId : records.periodId,
												sectionId : records.sectionId,
												dateOfAttendance : records.dateOfAttendance,
												facultyId : records.facultyId,
												attendanceId : records.attendanceId
											})

											if(wheatherSchool) {
												form.down('#periodIdItemId').setVisible(false);
											}else{
												form.down('#periodIdItemId').setVisible(true);
											}
											form.down('#batchName').setVisible(true);
											form.down('#batchName').setValue(records.batchName);
											form.down('#periodIdItemId').setValue(records.periodName);
											form.down('#programCoursection_ID').setVisible(true);
											form.down('#programCoursection_ID').setValue(records.sectionName);
											form.down('#facutlyId').setVisible(true);
											form.down('#sessionItemId').setVisible(false);
											form.down('#facutlyId').setValue(records.facultyName);
											form.down('#dateOfAttendance_Id').setVisible(true);
											form.down('#dateOfAttendance_Id').setValue(dateRender(records.dateOfAttendance));
											var editController = Academia.app.getController('Academia.controller.attendance.EditAttendanceController');
											editController.loadEditAttendanceSummary();
											$this.getEditattendancerecordstructure().down('#submitAttendanceBtn').setDisabled(false);
										}else{
											$this.getEditattendancerecordstructure().down('#submitAttendanceBtn').setDisabled(true);
										}
										try{
											if(etype == "view"){
												$this.getEditattendancerecordstructure().down('#markOnlyAttendance_Id').setVisible(false);
												$this.getEditattendancerecordstructure().down('#editOtherStatusId').setVisible(false);
												$this.getEditattendancerecordstructure().down('#submitAttendanceBtn').setVisible(false);
												$this.getEditattendancerecordstructure().down('#cancelAttendanceBtn').setVisible(false);
											}
										}
										catch(e){}
									}
								}	   
							});
						}
						else if(attendanceType=='Multiple Session' || attendanceType=='MULTIPLE_SESSION'){
							var form = this.getEditstudentattendance();
							var editForm=form.getForm();
							editForm.findField('attendanceType').setValue(attendanceType);
							var grid = $this.getEditstudentattendancegrid();
							var store = $this.getStore('attendance.EditStudentAttendanceListStore');
							store.getProxy().extraParams = {
								attendanceId : selectedRecord.get('attendanceId'),
								attendanceType : attendanceType
							};
							store.load({
								callback: function(records, operation, success) {
									var records = Ext.decode(operation.response.responseText);
									var tempArray =  grid.temp;
									if(tempArray.length > 0){
										tempArray.pop();
									}
									if (success) {
										if(!isNullOrEmpty(records)){
											form.down('#programName').setVisible(true);
											form.down('#programName').setValue(records.programName);
											tempArray.push({
												programId : records.programId,
												batchId : records.batchId,
												periodId : records.periodId,
												sectionId : records.sectionId,
												dateOfAttendance : records.dateOfAttendance,
												facultyId : records.facultyId,
												attendanceId : records.attendanceId,
												sessionNo : records.sessionNo
											})
											form.down('#batchName').setVisible(true);
											form.down('#batchName').setValue(records.batchName);
											if(wheatherSchool) {
												form.down('#periodIdItemId').setVisible(false);
											}else{
												form.down('#periodIdItemId').setVisible(true);
											} 
											form.down('#periodIdItemId').setValue(records.periodName);
											form.down('#programCoursection_ID').setVisible(true);
											form.down('#sessionItemId').setVisible(true);
											var multipleSessionStore = $this.getStore('attendance.MultipleSessionValueStore');
											multipleSessionStore.getProxy().extraParams = {
												type:"multipleSession"
											};
											multipleSessionStore.load({
												callback: function(rec, operation, success) {
													if (rec.length > 0) {
														for (s=0;s<rec.length;s++) {
															if(records.sessionNo == rec[s].data.code) {
																form.down('#sessionItemId').setValue(rec[s].data.value);
															} else {
																form.down('#sessionItemId').setValue(records.sessionNo);
															}
														}
													} else {
														form.down('#sessionItemId').setValue(records.sessionNo);
													}
												}
											});
											form.down('#programCoursection_ID').setValue(records.sectionName);
											form.down('#facutlyId').setVisible(true);
											form.down('#facutlyId').setValue(records.facultyName);
											form.down('#dateOfAttendance_Id').setVisible(true);
											form.down('#dateOfAttendance_Id').setValue(dateRender(records.dateOfAttendance));
											var editController = Academia.app.getController('Academia.controller.attendance.EditAttendanceController');
											editController.loadEditAttendanceSummary();
											$this.getEditattendancerecordstructure().down('#submitAttendanceBtn').setDisabled(false);
										}else{
											$this.getEditattendancerecordstructure().down('#submitAttendanceBtn').setDisabled(true);
										}
										try{
											if(etype == "view"){
												$this.getEditattendancerecordstructure().down('#markOnlyAttendance_Id').setVisible(false);
												$this.getEditattendancerecordstructure().down('#editOtherStatusId').setVisible(false);
												$this.getEditattendancerecordstructure().down('#submitAttendanceBtn').setVisible(false);
												$this.getEditattendancerecordstructure().down('#cancelAttendanceBtn').setVisible(false);
											}
										}
										catch(e){}
									}
								}	   
							});
						}
						var statusStore = $this.getStore('attendance.AttendanceMarkingTypeStore');
						statusStore.on('load', function(){
							for(var i=0; i< statusStore.data.items.length;i++){
								if(statusStore.data.items[i].data.value == 'Present'){
									statusStore.removeAt(i);
								} 
								if(statusStore.data.items[i].data.value == 'Absent'){
									statusStore.removeAt(i);
								}
							}
						});
					}else {
						showWarningMessage(getProgramandcourseTranslation('ATTENDANCE_RECORD'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
					}
				}else if (grid.getSelectionModel().getCount() > 1) {
					showWarningMessage(getProgramandcourseTranslation('ATTENDANCE_RECORD'), getCommonTranslation('PLEASE_SELECT_ONLY_SINGLE_RECORD')); //Please select a record.
				}else{
					showWarningMessage(getProgramandcourseTranslation('ATTENDANCE_RECORD'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
				}
			},
			
			courseWiseReportRender:function(){
				var this$ = this;
				var form = this.getConsolidatecoursewisesearchattendance();
				var academyLocationId = this$.getCurrentAcademyLocation();
				var academicTermCombo = form.down('#academicTermId');
				var intakeYearCombo = form.down('#intakeYearId');
				var courseCombo = form.down('#courseId');
				var courseVariantCombo = form.down('#courseVariantId');
				var facultyCombo = form.down('#facultyId');
				var programCategoryCombo = form.down('#programCategoryId');
				var programCombo = form.down('#programId');
				var batchCombo = form.down('#batchId');
				var periodCombo = form.down('#periodId');
				academicTermCombo.reset();
				intakeYearCombo.reset();
				courseCombo.reset();
				facultyCombo.reset();
				courseVariantCombo.reset();
				programCategoryCombo.reset();
				programCombo.reset();
				batchCombo.reset();
				periodCombo.reset();
				courseVariantCombo.setDisabled(true);
				batchCombo.setDisabled(true);
				periodCombo.setDisabled(true);
				var grid = this.getConsolidateattendancecoursewisegrid();
				grid.down('#btnView').setDisabled(false);
				grid.down('#btnEdit').setDisabled(false);
				grid.down('#btnDelete').setDisabled(false);
				if(!isNullOrEmpty(grid)){
					grid.getStore().removeAll(); 
					try {
						grid.down('custompagingtoolbar').hide();
					}
					catch(e){
					}
				}
				var intakeYearStore = intakeYearCombo.getStore();
				var courseStore = courseCombo.getStore();
				var facultyStore = facultyCombo.getStore();
				var programCategoryStore = programCategoryCombo.getStore();
				var programStore = programCombo.getStore();
				var academicTermComboStore = academicTermCombo.getStore();
				 academicTermComboStore.getProxy().extraParams = {
					 academyLocationIds : academyLocationId
				 };
				 var academicTermId = 0;
				 academicTermComboStore.load({
					 callback: function(rec, success) {
						 if (success) {
								 for(var i in rec){
									 if(rec[i].get('sequence')==1){
										 academicTermCombo.setValue(rec[i].get('id'));
										 academicTermId =rec[i].get('id');
										 intakeYearStore.getProxy().extraParams = {
											 academyLocationIds:academyLocationId,
											 academicTermId:academicTermId
										 };
										 //intakeYearStore.load();
										 courseStore.getProxy().extraParams = {
											 academyLocationIds : academyLocationId,
											 academicTermId:academicTermId
										 };
										 //courseStore.load();
										 facultyStore.getProxy().extraParams = {
											 academyLocationIds:academyLocationId,
											 academicTermId:academicTermId
										 };
										 //facultyStore.load();
										 programStore.getProxy().extraParams = {
											 academyLocationIds:academyLocationId,
											 academicTermId:academicTermId
										 };
										 //programStore.load();
										 programCategoryStore.getProxy().extraParams = {
											 academyLocationIds:academyLocationId,
											 academicTermId:academicTermId
										 };
										 //programCategoryStore.load();
									 }
								 }
								 if(academicTermId == 0) {
									 intakeYearStore.getProxy().extraParams = {
										 academyLocationIds:academyLocationId
									 };
									 //intakeYearStore.load();
									 courseStore.getProxy().extraParams = {
										 academyLocationIds : academyLocationId
									 };
									 //courseStore.load();
									 facultyStore.getProxy().extraParams = {
										 academyLocationIds:academyLocationId
									 };
									 //facultyStore.load();
									 programStore.getProxy().extraParams = {
										 academyLocationIds:academyLocationId
									 };
									 //programStore.load();
									 programCategoryStore.getProxy().extraParams = {
										 academyLocationIds:academyLocationId
									 };
									 //programCategoryStore.load();
								 }

						 }
					 }
				 });
			},
			loadConsolidateAttendanceCourseWiseGrid:function(record){
				var grid = this.getConsolidateattendancecoursewisegrid();
				var formFilter = this.getConsolidatecoursewisesearchattendance()
				formFilter.down('#searchBtn').setDisabled(true);
				var form = formFilter.getForm();
				var values = form.getValues();
				var store = grid.getStore();
				var academyLocationId = this.getCurrentAcademyLocation();
				var sectionId = values.sectionId;
				var courseId = values.courseId;
				var courseVariantId = values.courseVariant;
				var facultyId = values.faculty;
				var academyLocationId = this.getCurrentAcademyLocation();
				var startDate = values.consolidateStartDate;
				var endDate = values.consolidateEndDate;
				var fromTime = values.fromTime;
				var toTime = values.toTime;
				var programId = values.program;
				var batchId = values.batch;
				var periodId = values.period;
				var academicTermId = values.academicTerm;
				var intakeYearId = values.intakeYear;
				var programCategoryId = values.programCategory;
				//var topicName = values.topicName;
				var courseTopicId = values.courseTopic;
				
				var submitURL=SERVERURL.GET_COURSE_LEVEL_CONSOLIDATE_ATTENDANCE_REPORT1;
				store.getProxy().api.read=submitURL;
				store.getProxy().extraParams = {
					courseId:courseId,
					courseVariantId:courseVariantId,
					academyLocationId:academyLocationId,
					facultyId:facultyId,
					startDate:startDate,
					endDate:endDate,
					fromTime:fromTime,
					toTime:toTime,
					academicTermId:academicTermId,
					intakeYearId:intakeYearId,
					programCategoryId:programCategoryId,
					programId:programId,
					batchId:batchId,
					periodId:periodId,
					isCurrentPeriod:false,
					courseTopicId: courseTopicId
					
					
					
				};
				Ext.getBody().unmask();
				this.resetPageSetting(store);
				store.load({
					callback: function(records, operation, success) {
						if (success) {
							formFilter.down('#searchBtn').setDisabled(false);
						}
					}
				});
				grid.config.searchFilterForm = this.getConsolidatecoursewisesearchattendance();
				var  contentPanelMain = this.getContentPanel().getActiveTab();
				contentPanelMain.scrollBy(0,1);
				contentPanelMain.scrollBy(0,-1);
			},
		
		      viewAssignedTopics: function(view, record) {
		    	  var $this =this;
		    	  var studentCourseAttendanceId = record.data.attendanceId;
		    	  var formWindow = $this.getStudentcoursetopiccovered();
		    	  if (!formWindow) {
		    		 var formWindow= Ext.widget('studentcoursetopiccovered');
		    		 
		    	  }
		    	  
		    	  formWindow.show();
		    	  
		    	  
		    	  var store = formWindow.down('grid').getStore();
		    	  store.getProxy().extraParams = {
		    		  studentCourseAttendanceId: studentCourseAttendanceId,
		    	  };
		    	  store.load();
		    	  formWindow.down('grid').down('custompagingtoolbar').moveFirst();
		      },
			totalStudentRecords:function(record,status){
				var $this =this;
				
				var formWindow = $this.getConsolidatecoursewiseattendance();
				if (!formWindow) {
					Ext.widget('consolidatecoursewiseattendance');
					formWindow = $this.getConsolidatecoursewiseattendance();
				}
				formWindow.show();
				if(this.getCurrentLoggedPortalId() != 2) {
					var form = this.getConsolidatecoursewisesearchattendance().getForm();
					var values = form.getValues();
					var facultyName = values.facultyName;
					var facultyCode = values.facultyCode;
					var academyLocationId = this.getCurrentAcademyLocation();
					var programId = values.program;
					var batchId = values.batch;
					var periodId = values.period;
					var academicTermId = values.academicTerm;
					var intakeYearId = values.intakeYear;
					var programCategoryId = values.programCategory;
					var faculty;
					if(!isNullOrEmpty(facultyName)){
						faculty = facultyName;
					}else if(!isNullOrEmpty(facultyCode)){
						faculty = facultyCode;
					}else{
						faculty = '';
					}
				}else{
					var form = this.getCoursewisedailyattendancesearch().getForm();
					var values = form.getValues();
					var academicTermId = values.academicTerm;
				}
				
				var gridValues = record.data;
				var form = $this.getCoursewisetotalstudentdetail();
				form.down('#courseCodeId').setValue(gridValues.courseName);
				form.down('#courseVariantCodeId').setValue(gridValues.courseVaraintName);
				form.down('#facultyNameId').setValue(gridValues.facultyName);
				form.down('#dateId').setValue(dateRender(gridValues.date));
				form.down('#timeId').setValue(gridValues.fromTime+"-"+gridValues.toTime);
				form.down('#totalStudentId').setValue(gridValues.totalStudents);
				
				
				var store = $this.getConsolidateattendancetotalstudentgrid().getStore();
				store.getProxy().extraParams = {
					attendanceId:gridValues.attendanceId,
					academicTermId:academicTermId,
					intakeYearId:intakeYearId,
					programCategoryId:programCategoryId,
					programId:programId,
					batchId:batchId,
					periodId:periodId
				};
				this.resetPageSetting(store);
				store.loadPage(1);
				
			},
			
			
});
