
Ext.define('Academia.controller.attendance.attendancesettings.AttendanceSettingController', {
	//extend : 'Ext.app.Controller',
	extend : 'Academia.controller.base.BaseController',
	models : ['attendance.attendancesettings.AttendanceModelSettings'],
	stores : ['attendance.StudentAttendanceType','common.AcademyLocationNameSeparated',
	          'attendance.attendancesettings.AttendanceSettingsGrid',
	          'common.AcademyLocationByName','attendance.AttendanceSortingStore','attendance.AttendanceSettingSlot'
	          ],
	views : ['attendance.attendancesettings.AttendanceSettingsMaster','attendance.attendancesettings.AttendanceSettingsGrid',
	         'attendance.attendancesettings.AttendanceSettings'
	         ],	
	requires:['Ext.ux.InputTextMask'],
	         config : {
            	
            	 /**
            	  * @cfg {Array} ATTENDANCE_SETTINGS_PERMISSIONS array (required) The
            	  *      array of permissions to use for Access control
            	  *      wise enabling and disabling buttons.
            	  * @accessor
            	  */
	        	 ATTENDANCE_SETTINGS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_SETTINGS_PRIVILEGES')
             },         
	         refs : [{
	                	 ref: 'attendancesettingsgrid',
	                	 selector: 'attendancesettingsgrid'
	                 },{
	                	 ref: 'attendancesettings',
	                	 selector: 'attendancesettings'
	                 },{
	                	 ref: 'attendanceSettings',
	                	 selector: 'attendancesettings form'
	                 }],
	init : function() {
		this.control({
			
			'attendancesettingsgrid button[itemId=btnAdd]':{
            	click: function() {
                	this.showAttendanceSetting();
                }
            },
            'attendancesettingsgrid button[itemId=btnEdit]':{
            	click: function() {
                	this.editAttendanceSetting();
                }
            },
            'attendancesettingsgrid button[itemId=btnDelete]':{
            	click: function() {
                	this.deleteAttendanceSetting();
                }
            },
            'attendancesettings button[itemId=btnAdd]':{
            	click: function() {
                	this.addAttendanceSetting();
                }
            },
            'attendancesettings button[itemId=btnCancel]':{
            	click: function(obj) {
            		this.getAttendancesettings().close();
                }
            },
            'attendancesettingsgrid':{
            	render:function(grid, options){
       			 var $this = this;
       			 $this.doAccessControlValidation(grid,$this.getATTENDANCE_SETTINGS_PERMISSIONS());
            		var store = this.getStore('attendance.attendancesettings.AttendanceSettingsGrid');
            		store.load();
            	}
            },
            /*'attendancesettings radiogroup[itemId=timeTablePlanningId]':{
            	change: function(obj,record) {
            		var form = this.getAttendancesettings();
            		var val = record.timeTablePlanning;
            		var biometricAttendanceAllowed = this.getAttendancesettings().down("#biometricAttendanceIntegrationRequireId");
            		form.down('#adhocRequiredId').setValue(false);
       			 if (val) {
   					form.down('#adhocRequiredId').setVisible(false);
   					biometricAttendanceAllowed.setVisible(true);
   					biometricAttendanceAllowed.setValue(false);
   				 } else {
   					form.down('#adhocRequiredId').setVisible(true);
   					biometricAttendanceAllowed.setVisible(false);
   					biometricAttendanceAllowed.setValue(false);
   				 }
                }
            },*/
            
            'attendancesettings customcombobox[itemId=studentAttdndaceTypeID]':{
            	change: function(obj,record) {
            		var $this=this;
            		var form = this.getAttendancesettings();
            		var  sessionNoIdField = this.getAttendancesettings().down("#sessionNoId");
            		var  attendanceSlotId = this.getAttendancesettings().down("#attendanceSlotId");
            		var concurrentAttendanceAllowed = this.getAttendancesettings().down("#concurrentAttendanceAllowedId");
            		var biometricAttendanceIntReq = this.getAttendancesettings().down("#biometricAttendanceIntegrationRequireId"),
            		expirytime = form.down('#expirytime');

            		form.down('#adhocRequiredId').setValue(false);
            		attendanceSlotId.reset();
            		if(record =='Multiple Session'){
            			sessionNoIdField.setDisabled(false);
            			form.down('#sessionNoId').setVisible(true);
            			concurrentAttendanceAllowed.setVisible(false);
            		}
            		else{
            			form.down('#sessionNoId').setVisible(false);
            			sessionNoIdField.setDisabled(true);
            			sessionNoIdField.allowBlank = true;
            			sessionNoIdField.reset();
            		}
            		if(record =='Complete Day' || record =='Multiple Session' || record =='Service Level'){
            			attendanceSlotId.setVisible(false);
            			$this.setAllowBlank(attendanceSlotId,true);
            			form.down('#adhocRequiredId').setVisible(false);
            			concurrentAttendanceAllowed.setVisible(false);
            			if(record =='Complete Day'){
            				biometricAttendanceIntReq.setVisible(true);
            			} else{
            				biometricAttendanceIntReq.setVisible(false);
            				biometricAttendanceIntReq.setValue(false);
            			}
            		}
            		else{
            			attendanceSlotId.setVisible(true);
            			$this.setAllowBlank(attendanceSlotId,false);

            			var attendanceSlotStore=attendanceSlotId.getStore();
            			attendanceSlotStore.load({
            				callback : function(records,operation,success) {
            					if (success) {
            						attendanceSlotId.setValue("TIME_TABLE_SLOTS");
            					}
            				}
            			});

            			concurrentAttendanceAllowed.setVisible(true);
            			biometricAttendanceIntReq.setVisible(true);
            		}
            		if(record =='Service Level'){
            			form.down('#adhocRequiredId').setVisible(true);
            			//attendanceSlotId.setVisible(true);
            		}

            		if(record =='Multiple Session' || record =='Complete Day' || record =='Course Level' || record =='MULTIPLE_SESSION' || record =='COURSE_LEVEL' || record =='COMPLETE_DAY'){
            			expirytime.setVisible(true);
            		}else{
            			expirytime.setVisible(false);
            		}
            	}
            },
            'attendancesettings customcombobox[itemId=attendanceSlotId]':{
            	change: function(obj,record) {
            		var $this=this;
            		var form = this.getAttendancesettings();
            		if(!isNullOrEmpty(record)){
            			var  adhocRequiredId = form.down("#adhocRequiredId");
            			var concurrentAttendanceAllowed = form.down("#concurrentAttendanceAllowedId");
            			var biometricAttendanceIntReq = form.down("#biometricAttendanceIntegrationRequireId");
            			var studentAttdndaceType = form.down("#studentAttdndaceTypeID").getValue();
            			adhocRequiredId.setVisible(false);
            			
            			if(studentAttdndaceType =='Service Level'){
            				adhocRequiredId.setVisible(true);
            			}
            			if(studentAttdndaceType =='Complete Day'){
            				biometricAttendanceIntReq.setVisible(true);
            			} else {
            				biometricAttendanceIntReq.setVisible(false);
                			biometricAttendanceIntReq.setValue(false);
            			}
            			if(record =='TIME_TABLE_SLOTS'){
            				biometricAttendanceIntReq.setVisible(true);
            				adhocRequiredId.setVisible(true);
            			}else if(record =='CALENDAR_SLOTS'){
            				adhocRequiredId.setVisible(true);
            			}else{
            				adhocRequiredId.items.items[0].setValue(true);
            				adhocRequiredId.items.items[1].setValue(false);
            			}	
            		}
            	}
            },
            
            'attendancesettings checkbox[itemId=biometricAttendanceIntegrationRequireId]':{
            	change: function(checkbox) {
            		var $this=this;
            		var form = $this.getAttendancesettings().down('form');
            		form.down('#punchAllowanceRangeId').setValue();
            		form.down('#beforeSessionStartId').setValue();
            		form.down('#beforeSessionEndId').setValue();
            		form.down('#punchTypeId').setValue();
            		if(checkbox.value==true){
            			if(form.isValid()){
                            form.down('#btnAdd').setDisabled(true);
                        }
	            		form.down('#rangeSessionId').setVisible(true);
	            		form.down('#sessionPunchId').setVisible(true);
	            		$this.setAllowBlank(form.down('#punchAllowanceRangeId'),false);
	            		$this.setAllowBlank(form.down('#beforeSessionStartId'),false);
	            		$this.setAllowBlank(form.down('#beforeSessionEndId'),false);
	            		$this.setAllowBlank(form.down('#punchTypeId'),false);
	            		form.down('#punchAllowanceRangeId').clearInvalid()
	            		form.down('#beforeSessionStartId').clearInvalid()
	            		form.down('#beforeSessionEndId').clearInvalid()
	            		form.down('#punchTypeId').clearInvalid()
            		}
            		else{
            		    if(form.isValid()){
            		    	form.down('#btnAdd').setDisabled(false);
            		    }
            			//form.down('#btnAdd').setDisabled(false);
            			form.down('#rangeSessionId').setVisible(false);
	            		form.down('#sessionPunchId').setVisible(false);
	            		$this.setAllowBlank(form.down('#punchAllowanceRangeId'),true);
	            		$this.setAllowBlank(form.down('#beforeSessionStartId'),true);
	            		$this.setAllowBlank(form.down('#beforeSessionEndId'),true);
	            		$this.setAllowBlank(form.down('#punchTypeId'),true);
            		}
            		if(form.isValid()){
                        form.down('#btnAdd').setDisabled(false);
                    }
            	}
            	
            }
		});
	},showAttendanceSetting:function(){
		  var formWindow = this.getAttendancesettings();
	        if (!formWindow) {
	            Ext.widget('attendancesettings');
	            formWindow = this.getAttendancesettings();
	        }
	        formWindow.show();
	},addAttendanceSetting:function(){
		var $this = this;
		var form = $this.getAttendanceSettings().getForm();
		var values = form.getValues();

		var attendanceSettings =  new  Academia.model.attendance.attendancesettings.AttendanceModelSettings();
		var typeOfFacultyAttendanc=null;
		/*if(values.facultyAttendanceType == 'Complete Day' || values.facultyAttendanceType == 'COMPLETE_DAY'){
			typeOfFacultyAttendanc = 'COMPLETE_DAY';
		}else if(values.facultyAttendanceType == 'Multiple Session' || values.facultyAttendanceType == 'MULTIPLE_SESSION'){
			typeOfFacultyAttendanc = 'MULTIPLE_SESSION';
		}else{
			typeOfFacultyAttendanc = 'COURSE_LEVEL';
		}*/

		var typeOfStudentAttendanc;
		var attendanceSlot="NONE";
		var whetherAdhocRequired=false;
		if(values.studentAttendaceType == 'Complete Day' || values.studentAttendaceType == 'COMPLETE_DAY'){
			typeOfStudentAttendanc = 'COMPLETE_DAY';
		}else if(values.studentAttendaceType == 'Multiple Session' || values.studentAttendaceType == 'MULTIPLE_SESSION'){
			typeOfStudentAttendanc = 'MULTIPLE_SESSION';
		}else if(values.studentAttendaceType == 'Service Level' || values.studentAttendaceType == 'SERVICE_LEVEL'){
			typeOfStudentAttendanc = 'SERVICE_LEVEL';
			whetherAdhocRequired=values.whetherAdhocRequired;
		}else {
			typeOfStudentAttendanc = 'COURSE_LEVEL';
			attendanceSlot=values.attendanceSlot;
			whetherAdhocRequired=values.whetherAdhocRequired;
			if(values.attendanceSlot=="AD_HOC_SLOTS"){
				whetherAdhocRequired=true;	
			}
		}
		
		var sortBy;
		if(values.sortBy == getCommonTranslation('ADMISSION_CODE') || values.sortBy == 'Admission Code' || values.sortBy == getAdmissionTranslation('ADMISSION_ID')){
			sortBy = 'ADMISSION_CODE';
		}else if(values.sortBy == getCommonTranslation('STUDENT_CODE') || values.sortBy == 'Student Code' || values.sortBy == getAdmissionTranslation('STUDENT_ID')){
			sortBy = 'STUDENT_CODE';
		}else{
			sortBy = 'STUDENT_NAME';
		}
		
		if(!(values.studentAttendaceType == 'Service Level' || values.studentAttendaceType == 'SERVICE_LEVEL')){
			attendanceSettings.set("qrCodeExpiryTime", values.expiryTime);
		}
		attendanceSettings.set("facultyAttendanceType", typeOfFacultyAttendanc );
		attendanceSettings.set("studentAttendanceType", typeOfStudentAttendanc );
		attendanceSettings.set("academyLocationId", values.academyLocation);
		attendanceSettings.set("backDateAllowed", values.backedDateAllowed);
		attendanceSettings.set("backDateAllowedForFaculty", values.backDateAllowedForFaculty);
		attendanceSettings.set("whetherAdhocRequired", whetherAdhocRequired);
		attendanceSettings.set("sortBy", sortBy);
		attendanceSettings.set("sessionNo", values.sessionNo);
		attendanceSettings.set("biometricAttendanceIntegrationRequire", values.biometricAttendanceIntegrationRequire);
		attendanceSettings.set("punchAllowanceRange", values.punchAllowanceRange);
		attendanceSettings.set("beforeSessionStart", values.beforeSessionStart);
		attendanceSettings.set("beforeSessionEnd", values.beforeSessionEnd);
		attendanceSettings.set("concurrentAttendanceAllowed", values.concurrentAttendanceAllowed);
		attendanceSettings.set("attendanceSlot", attendanceSlot);
		if(!isNullOrEmpty(values.punchType)){		 
			if(values.punchType.length==2){
				attendanceSettings.set("punchType", "BOTH");
			}else{
				if(values.punchType=="punchIn"){
					attendanceSettings.set("punchType", "PUNCH_IN");
				}
				else if(values.punchType=="punchOut"){
					attendanceSettings.set("punchType", "PUNCH_OUT");
				}
				else{
					attendanceSettings.set("punchType", "DEFAULT");
				}
			}
		}
		else{
			attendanceSettings.set("punchType", "DEFAULT");
		}

		var submitUrl;
		if (form.findField('id').getSubmitValue() == null
				|| form.findField('id').getSubmitValue() == "") {
			/*if(typeOfStudentAttendanc != 'Course Level' || typeOfStudentAttendanc != 'COURSE_LEVEL'){
				if(values.timeTablePlanning){
					attendanceSettings.set("whetherAdhocRequired", false);
				}
			}*/
			submitUrl = SERVERURL.ATTENDANCE_SETTING_CREATE;
		} else {
			attendanceSettings.set("id", values.id);
			submitUrl = SERVERURL.ATTENDANCE_SETTING_UPDATE;
		}
		delete attendanceSettings.data.academyLocation;
		var formData = Ext.encode(attendanceSettings.data);
		$this.applyWindowMask(); 
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : formData,
			method : 'POST',
			success : function(f, action) {
				$this.hideWindowMask();
				if(f.responseText == 'DUPLICATE'){
					showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('DUPLICATE_ATTENDANCE_SETTING'));
				}else if(f.responseText == 'CAN_NOT_UPDATE'){
					showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTINGS_DEPENDANCEY'));
				}
				else{
					showSuccessMessage(getProgramandcourseTranslation('ATTENDANCE_SETTINGS'),getCommonTranslation('SUCCESS'));
					$this.getStore('attendance.attendancesettings.AttendanceSettingsGrid').load();
					var grid = $this.getAttendancesettingsgrid();
					grid.getSelectionModel().deselectAll(true);
					$this.getAttendancesettings().close();
				}
				//var data = Ext.JSON.decode(form.responseText);
				//showSuccessMessage(getCommonTranslation('PERIOD_BREAKS_FORM'),getCommonTranslation('SUCCESS'));

			}
		});
	},
	editAttendanceSetting:function(){
		 var grid = this.getAttendancesettingsgrid();
    	 if (grid.getSelectionModel().getCount() > 0) {

    		 var records = grid.getSelectionModel().getSelection();
    		 this.showAttendanceSetting();
    		 
    		 var form =  this.getAttendanceSettings();
    		 var attendanceSettingForm = form.getForm();
    		 
    		 if (records != undefined && records != ""&& records != null) {
    			 
    			 var id = records[0].data.id;
    			 var academyLocationId = records[0].data.academyLocationId;
    			 var backDateAllowed = records[0].data.backDateAllowed;
    			 var backDateAllowedForFaculty = records[0].data.backDateAllowedForFaculty;
    			 var sessionNo = records[0].data.sessionNo;
    			 /*var facultyAttendanceType = records[0].data.facultyAttendanceType;
    			 var studentAttendanceType = records[0].data.studentAttendanceType;*/
    			 var timeTablePlanningFlag = records[0].data.timeTablePlanningFlag;   			 
    			 
    			 var academyLocationCombo = form.down("#academyLocationId");
    			 academyLocationCombo.readOnly=true;
    			 academyLocationCombo.store.load({
					 callback : function(records,operation,success) {
						 if (success) {
							 academyLocationCombo.setValue(academyLocationId);
							 
						 }
					 }
				 });
    			 
    			 var typeOfFacultyAttendanc=null;
 				/*if(records[0].data.facultyAttendanceType == 'Complete Day' || records[0].data.facultyAttendanceType == 'COMPLETE_DAY'){
 					typeOfFacultyAttendanc = 'Complete Day';
 				}else if(records[0].data.facultyAttendanceType == 'Multiple Session' || records[0].data.facultyAttendanceType == 'MULTIPLE_SESSION'){
 					typeOfFacultyAttendanc = 'Multiple Session';
 				}else{
 					typeOfFacultyAttendanc = 'Course Level';
 				}*/

 				
 				var typeOfStudentAttendanc;
 				if(records[0].data.studentAttendanceType == 'Complete Day' || records[0].data.studentAttendanceType == 'COMPLETE_DAY'){
 					typeOfStudentAttendanc = 'Complete Day';
 				}else if(records[0].data.studentAttendanceType == 'Multiple Session' || records[0].data.studentAttendanceType == 'MULTIPLE_SESSION'){
 					typeOfStudentAttendanc = 'Multiple Session';
 				}else if(records[0].data.studentAttendanceType == 'Service Level' || records[0].data.studentAttendanceType == 'SERVICE_LEVEL'){
 					typeOfStudentAttendanc = 'Service Level';
 				}else{
 					typeOfStudentAttendanc = 'Course Level';
 				}
 				
    			 attendanceSettingForm.findField('id').setValue(id);
    			 attendanceSettingForm.findField('backedDateAllowed').setValue(backDateAllowed);
				// attendanceSettingForm.findField('facultyAttendanceType').setValue(typeOfFacultyAttendanc);
    			 attendanceSettingForm.findField('studentAttendaceType').readOnly=true;
				 attendanceSettingForm.findField('studentAttendaceType').setValue(typeOfStudentAttendanc);
				 
				 attendanceSettingForm.findField('backDateAllowedForFaculty').setValue(backDateAllowedForFaculty);
				 attendanceSettingForm.findField('sortBy').setValue(getCommonTranslation(records[0].data.sortBy));
				 attendanceSettingForm.findField('sessionNo').setValue(sessionNo);
				 attendanceSettingForm.findField('concurrentAttendanceAllowed').setValue(records[0].data.concurrentAttendanceAllowed);
				 attendanceSettingForm.findField('expiryTime').setValue(records[0].data.qrCodeExpiryTime);
				 
				 
    			 /*var sesstionPlanningFields = form.down("#timeTablePlanningId");
    			 if (timeTablePlanningFlag) {
					 sesstionPlanningFields.items.items[0].setValue(true);
					 sesstionPlanningFields.items.items[1].setValue(false);
				 } else {
					 sesstionPlanningFields.items.items[0].setValue(false);
					 sesstionPlanningFields.items.items[1].setValue(true);
				 }*/
				 setTimeout(function(){
					 attendanceSettingForm.findField('attendanceSlot').setValue(records[0].data.attendanceSlot);
	    			 var whetherAdhocRequired = records[0].data.whetherAdhocRequired;
	    			 var adhocRequiredId = form.down("#adhocRequiredId");
	    			 adhocRequiredId.setValue(whetherAdhocRequired);
	    			 if (whetherAdhocRequired) {
	    				 adhocRequiredId.items.items[0].setValue(true);
	    				 adhocRequiredId.items.items[1].setValue(false);
					 } else {
						 adhocRequiredId.items.items[0].setValue(false);
						 adhocRequiredId.items.items[1].setValue(true);
					 }
	    			 attendanceSettingForm.findField('biometricAttendanceIntegrationRequire').setValue(records[0].data.biometricAttendanceIntegrationRequire);
	    			 attendanceSettingForm.findField('punchAllowanceRange').setValue(records[0].data.punchAllowanceRange);
	    			 attendanceSettingForm.findField('beforeSessionStart').setValue(records[0].data.beforeSessionStart);
	    			 attendanceSettingForm.findField('beforeSessionEnd').setValue(records[0].data.beforeSessionEnd);
	    			 var punchTypeField = form.down("#punchTypeId");
	    			 if(records[0].data.punchType=="BOTH"){
	    			 	punchTypeField.items.items[0].setValue(true);
	    			 	punchTypeField.items.items[1].setValue(true);
	    		 	 }else if(records[0].data.punchType=="PUNCH_IN"){
	    		 		punchTypeField.items.items[0].setValue(true);
		 	 		 }else if(records[0].data.punchType=="PUNCH_OUT"){
		 	 			punchTypeField.items.items[1].setValue(true);
		 	 		 } 
	    			 if(records[0].data.biometricAttendanceIntegrationRequire){
	    				 form.down('#btnAdd').setDisabled(false);
	    			 }
				 },500);
    		 }
    	 }
    	 else {
    		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
         }
	},
	deleteAttendanceSetting:function(){
		 var grid = this.getAttendancesettingsgrid();
		 if (grid.getSelectionModel().getCount() > 0) {
			 showConfirmMessage( 'Attendance Settings',getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
			 function(btn, text) {
				 if (btn == 'yes') {
					 var records = grid.getSelectionModel().getSelection()[0];
					 var id = records.data.id;
					 var academyLocationId = records.data.academyLocationId;
					 var studentAttendanceType=records.data.studentAttendanceType;
					 Ext.Ajax.request({
						 method : "GET",
						 type : 'rest',
						 url : SERVERURL.ATTENDANCE_SETTING_DELETE+ '?id='+ id + '&academyLocationId=' + academyLocationId+'&studentAttendanceType='+studentAttendanceType,
						 headers : {
							 'Content-Type' : 'application/json'
						 },
						/* params : {
							 id : id
						 },*/
						 success : function(f,action) {
							 if(f.responseText == 'ERROR_DEPENDENT'){
								showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTINGS_DELET_DEPENDANCEY'));
							 }else{
								 showSuccessMessage(getProgramandcourseTranslation('ATTENDANCE_SETTINGS'),getCommonTranslation('SUCCESS'));
								 grid.getStore().reload();
							 }
						 }
					 });
				 }
			 });
		 } else {
    		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	 }	
	}
});
