/**
 * @author Utsav Chandvaniya
 * @author Seshagiri.k
 */
Ext.define('Academia.controller.course.reports.CourseReportController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['course.reports.CourseReportTabStore', 'course.CourseComboStore', 'common.AcademyLocationByAcademyId',
            'common.AcademyLocationNameSeparated','course.coursegroup.ProgramBYCourseGroup',
            'course.coursegroup.CourseGroupAssociatedGridStore'],
    views: ['course.reports.CourseReportStructure','course.reports.CourseReportSearchForm',
            'course.reports.CourseReportTreePanelAndGrid', 'course.reports.CourseReportTabStructure',
            'course.reports.coursereporttab.CourseBasicInfoForm',
            'course.reports.coursereporttab.CourseReportTopicsCreatedStructure',
            'course.reports.coursereporttab.CourseReportCourseGroupAssociatedStructure',
            'course.reports.coursereporttab.CourseReportCourseComponentAssociatedStructure',
            'course.reports.coursereporttab.CourseReportProgramBatchAssociatedStructure',
            'course.reports.coursereporttab.CourseReportCourseVariantsAssociatedStructure',
            'course.reports.coursereporttab.CourseReportCourseReadingMaterialAssociatedStructure',
            'course.reports.coursereporttab.CourseEvaluationStructure','course.coursegroup.NoOfProgram',
            'course.coursegroup.CourseGroupAssociatedGrid'],
            config: {
        	  	  PANDCDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_REPORT_PRIVILEGES'),
        	  	COURSE_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_REPORT_PRIVILEGES'),
        	  	//COURSE_CREDIT_GRADE_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_CREDIT_GRADE_REPORT_PRIVILEGES')
        	  	COURSE_GROUP_ASSOCIATED_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_GROUP_ASSOCIATED_REPORT_PRIVILEGES'),
        	  	COURSE_COMPONENT_ASSOCIATED_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_COMPONENT_ASSOCIATED_REPORT_PRIVILEGES'),
        	  	READING_MATERIAL_ASSOCIATED_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('READING_MATERIAL_ASSOCIATED_REPORT_PRIVILEGES'),
        	  	COURSE_VARIENTS_ASSOCIATED_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_VARIENTS_ASSOCIATED_REPORT_PRIVILEGES'),
        	  	TOPICS_CREATED_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TOPICS_CREATED_REPORT_PRIVILEGES'),
        	  	COURSE_ASSESSMENT_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_ASSESSMENT_REPORT_PRIVILEGES')
            },
    refs: [{
        ref: 'coursereporttreepanelandgrid',
        selector: 'coursereporttreepanelandgrid'
    },{
        ref: 'coursereporttabstructure',
        selector: 'coursereporttabstructure'
    },{
        ref: 'coursereportsearchform',
        selector: 'coursereportsearchform'
    },{
        ref: 'searchresultgrid',
        selector: 'searchresultgrid'  
    },{
        ref: 'courseReportTopicsCreatedGrid',
        selector: 'courseReportTopicsCreatedStructure [itemId=courseReportTopicsCreatedGrid]'
    },{
        ref: 'courseReportCourseGroupAssociatedGrid',
        selector: 'courseReportCourseGroupAssociatedStructure [itemId=courseReportCourseGroupAssociatedGrid]'
    },{
        ref: 'courseReportCourseComponentAssociatedGrid',
        selector: 'courseReportCourseComponentAssociatedStructure [itemId=courseReportCourseComponentAssociatedGrid]'
    },{
        ref: 'courseReportProgramBatchAssociatedGrid',
        selector: 'courseReportProgramBatchAssociatedStructure [itemId=courseReportProgramBatchAssociatedGrid]'
    },{
        ref: 'courseReportCourseVariantsAssociatedGrid',
        selector: 'courseReportCourseVariantsAssociatedStructure [itemId=courseReportCourseVariantsAssociatedGrid]'
    },{
        ref: 'courseReportCourseReadingMaterialAssociatedGrid',
        selector: 'courseReportCourseReadingMaterialAssociatedStructure [itemId=courseReportCourseReadingMaterialAssociatedGrid]'
    },{
        ref: 'courseevaluationstructureGrid',
        selector: 'courseEvaluationStructure [itemId=courseevaluationstructureGrid]'
    },{
        ref: 'coursereportstructure',
        selector: 'coursereportstructure'  
    },{
    	ref : 'noofprogram',
	    selector : 'noofprogram' 
    }/*,{
        ref: 'courseCreditGradeReportGrid',
        selector: 'courseCreditGradeReportStructure [itemId=courseCreditGradeReportGrid]'
    }*/,{
    	ref : 'coursegroupassociatedgrid',
	    selector : 'coursegroupassociatedgrid' 
    }/*,
    {
    	ref : 'coursecreditgradereportgrid',
	    selector : 'coursecreditgradereportgrid' 
    }*/],
    
    init: function() {
        this.control({
        	
        	'coursereportstructure':{
        		afterrender : function(structure){
        			var $this = this;
        			var coursereporttreepanelandgrid = structure.down('#coursereporttreepanelandgrid');
        			structure.body.on('scroll', function(e, target) {
        				var activeTab = structure.down('#tabpanelIds').getActiveTab();
        				if(!isNullOrEmpty(activeTab)){
        					var baseStructure = activeTab;
        					var grid = activeTab.down('searchresultgrid');
        					if(grid != undefined){
        						//$this.getMultipleCBGridHeaderFreezeCourseReport(grid,structure,true);
        					}
        				}
        			});
        		} 
        	},
        	'coursereporttreepanelandgrid treepanel[itemId=courseReportTreePanelItemId]' : {
        		itemclick : this.getOpenCourseReportStructure,
        		afterrender: function(tree, eOpts){
        			var $this = this;
        			
        			setTimeout(function(){
               	    	var associatedAcadLocationIds = new Array();
               	    	associatedAcadLocationIds.push($this.getCurrentAcademyLocation());
               	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, $this.getCOURSE_REPORT_PRIVILEGES());
               	    	//var permissionList1 = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, $this.getCOURSE_CREDIT_GRADE_REPORT_PRIVILEGES());
               	    	
               	    	if(!Ext.Array.contains(permissionList, 'COURSE_GROUP_ASSOCIATED')){
               	    		try{
                   	    		var nodeRecord = tree.getRootNode().findChild('reportXtype','courseReportCourseGroupAssociatedStructure');
                   	    		var node = tree.getView().getNodeByRecord(nodeRecord);
                   	    		Ext.get(node).destroy();
               	    		}
               	    		catch(e){
               	    			
               	    		}
    					}
               	    	if(!Ext.Array.contains(permissionList, 'COURSE_COMPONENT_ASSOCIATED')){
               	    		try{
                   	    		var nodeRecord = tree.getRootNode().findChild('reportXtype','courseReportCourseComponentAssociatedStructure');
	               	    		var node = tree.getView().getNodeByRecord(nodeRecord);
	               	    		Ext.get(node).destroy();
	               	    	}
	           	    		catch(e){
	           	    			
	           	    		}
    					}
               	    	if(!Ext.Array.contains(permissionList, 'READING_MATERIAL_ASSOCIATED')){
               	    		try{
                   	    		var nodeRecord = tree.getRootNode().findChild('reportXtype','courseReportCourseReadingMaterialAssociatedStructure');
	               	    		var node = tree.getView().getNodeByRecord(nodeRecord);
	               	    		Ext.get(node).destroy();
	               	    	}
	           	    		catch(e){
	           	    			
	           	    		}
    					}
               	    	if(!Ext.Array.contains(permissionList, 'COURSE_VARIANTS_ASSOCIATED')){
               	    		try{
                   	    		var nodeRecord = tree.getRootNode().findChild('reportXtype','courseReportCourseVariantsAssociatedStructure');
	               	    		var node = tree.getView().getNodeByRecord(nodeRecord);
	               	    		Ext.get(node).destroy();
	               	    	}
	           	    		catch(e){
	           	    			
	           	    		}
    					}
               	    	if(!Ext.Array.contains(permissionList, 'COURSE_TOPICS_CREATED')){
               	    		try{
                   	    		var nodeRecord = tree.getRootNode().findChild('reportXtype','courseReportTopicsCreatedStructure');
	               	    		var node = tree.getView().getNodeByRecord(nodeRecord);
	               	    		Ext.get(node).destroy();
	               	    	}
	           	    		catch(e){
	           	    			
	           	    		}
    					}
               	    if(!Ext.Array.contains(permissionList, 'COURSE_ASSESSMENT')){
               	    		try{
                   	    		var nodeRecord = tree.getRootNode().findChild('reportXtype','courseEvaluationStructure');
	               	    		var node = tree.getView().getNodeByRecord(nodeRecord);
	               	    		Ext.get(node).destroy();
	               	    	}
	           	    		catch(e){
	           	    			
	           	    		}
    					}
               	    if(!Ext.Array.contains(permissionList, 'COURSE_GROUP_REPORT')){
               	    	try{
               	    		var nodeRecord = tree.getRootNode().findChild('reportXtype','coursegroupreport');
               	    		var node = tree.getView().getNodeByRecord(nodeRecord);
               	    		Ext.get(node).destroy();
               	    	}
               	    	catch(e){

               	    	}
               	    }
               	   /* 	if(!Ext.Array.contains(permissionList1, 'COURSE_CREDIT_GRADE_REPORT')){
               	    		try{
                   	    		var nodeRecord = tree.getRootNode().findChild('reportXtype','courseCreditGradeReportStructure');
	               	    		var node = tree.getView().getNodeByRecord(nodeRecord);
	               	    		Ext.get(node).destroy();
	               	    	}
	           	    		catch(e){
	           	    			
	           	    		}
    					}*/
        			},500);
           	    	
        		}
        	},
          'coursereportsearchform button[itemId=courseReportSearchButtonId]': {
        	  click:function(){
        		  this.courseReportSearchButton();  
        	  } 
          	},
          	'coursereportsearchform button[itemId=resetBtn]': {
          	  click:function(){
          		  this.getCoursereportsearchform().getForm().reset();
          		var courseReportSearchForm = this.getCoursereportsearchform();
                courseReportSearchForm.down('#courseReportCourseId').setDisabled(true);
          		//var grid= this.getCoursereportstructure().down('coursecreditgradereportgrid');
      /*    		if(!isNullOrEmpty(grid) && !isNullOrEmpty(courseReportSearchForm.down('#academyLocationId').getValue())){
        			grid.down('#btnExportToPDF').setDisabled(false);
        			grid.down('#btnExportToExcel').setDisabled(false);
        		}else{
        			grid.down('#btnExportToPDF').setDisabled(true);
        			grid.down('#btnExportToExcel').setDisabled(true);
        		}*/
          	  } 
             },
          	'searchresultgrid[itemId=courseReportTopicsCreatedGrid]': {
                afterrender: function(grid) {
                	//var RESULT_GRID = this.getCourseReportTopicsCreatedGrid();
                	this.gridRenderFunction(grid);
     				 this.checkExportButtonPermission(grid,this.getTOPICS_CREATED_REPORT_PRIVILEGES());
                	this.getDynamicCourseReportGrid(CONSTANTS.CB.CR_TOPIC_CREATED_LIST_VIEWCODE,
                			CONSTANTS.CB.CR_TOPIC_CREATED_LIST_CONFIGCODE,getCommonTranslation('CR_TOPICS_CREATED'),grid);
                }
            },
            'coursegroupassociatedgrid': {
                render: function(grid) {
                	this.loadCourseGroup(grid);
                	this.checkExportButtonPermission(grid, this.getCOURSE_GROUP_ASSOCIATED_REPORT_PRIVILEGES());
                },
                cellclick : function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
                	var $this = this;
          			 var columnName=View.ownerCt.columnManager.columns[ColIdx].dataIndex;
          			 if(columnName=='programAssociated'){
          				 var store=$this.getStore('course.coursegroup.ProgramBYCourseGroup');
   		                  	store.getProxy().extraParams = {
   		                  		courseGroupId: record.data.courseGroupId
   		    					    };
   		                  	store.load();
   		                  	
   		                  	var formWindow = $this.getNoofprogram();
   		     	       		        if (!formWindow) {
   		     	       		             Ext.widget('noofprogram');
   		     	       		            formWindow = $this.getNoofprogram();
   		     	       		       }
   		  	       		        formWindow.show();
   		              	   }
          			 }
               },
              /* 'coursecreditgradereportgrid': {
                   render: function(grid) {
                   	this.loadCourseCreditGradeReport(grid);
                   },
                 },*/
            'searchresultgrid[itemId=courseReportCourseComponentAssociatedGrid]': {
                afterrender: function(grid) {
                	this.gridRenderFunction(grid);
     				 this.checkExportButtonPermission(grid,this.getCOURSE_COMPONENT_ASSOCIATED_REPORT_PRIVILEGES());
                	this.getDynamicCourseReportGrid(CONSTANTS.CB.CR_COURSE_COMPONENT_ASSOCIATED_VIEWCODE,
   						 CONSTANTS.CB.CR_COURSE_COMPONENT_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_COURSE_COMPONENT_ASSOCIATED'),grid);
                }
            },
            'searchresultgrid[itemId=courseReportProgramBatchAssociatedGrid]': {
                afterrender: function(grid) {
                	this.gridRenderFunction(grid);
     				 this.checkExportButtonPermission(grid,this.getPANDCDASHBOARD_PERMISSIONS());
                	this.getDynamicCourseReportGrid(CONSTANTS.CB.CR_PREOGRAM_BATCH_ASSOCIATED_VIEWCODE,
   						 CONSTANTS.CB.CR_PREOGRAM_BATCH_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_PROGRAM_BATCH_ASSOCIATED'),grid);
                }
            },
            'searchresultgrid[itemId=courseReportCourseVariantsAssociatedGrid]': {
                afterrender: function(grid) {
                	this.gridRenderFunction(grid);
     				 this.checkExportButtonPermission(grid,this.getCOURSE_VARIENTS_ASSOCIATED_REPORT_PRIVILEGES());
                	this.getDynamicCourseReportGrid(CONSTANTS.CB.CR_COURSE_VARIANTS_ASSOCIATED_VIEWCODE,
   						 CONSTANTS.CB.CR_COURSE_VARIANTS_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_COURSE_VARIANTS_ASSOCIATED'),grid);
                	this.addDataGridConfigButton(grid, this.getCOURSE_REPORT_PRIVILEGES());
                },
                
            	/*afterrender:function(grid){
        			var me=this;
        			me.addDataGridConfigButton(grid, this.getCOURSE_REPORT_PRIVILEGES());
        		}*/
                
            },
            'searchresultgrid[itemId=courseReportCourseReadingMaterialAssociatedGrid]': {
                afterrender: function(grid) {
                	this.gridRenderFunction(grid);
     				 this.checkExportButtonPermission(grid,this.getREADING_MATERIAL_ASSOCIATED_REPORT_PRIVILEGES());
                	this.getDynamicCourseReportGrid(CONSTANTS.CB.CR_READING_MATERIAL_ASSOCIATED_VIEWCODE,
   						 CONSTANTS.CB.CR_READING_MATERIAL_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_READING_MATERIAL_ASSOCIATED'),grid);
                }
            },
            
            'searchresultgrid[itemId=courseevaluationstructureGrid]': {
                afterrender: function(grid) {
                	this.gridRenderFunction(grid);
     				 this.checkExportButtonPermission(grid,this.getCOURSE_ASSESSMENT_REPORT_PRIVILEGES());
                	this.getDynamicCourseReportGrid(CONSTANTS.CB.CR_COURSE_EVALUATION_VIEWCODE,
   						 CONSTANTS.CB.CR_COURSE_EVALUATION_CONFIGCODE,getCommonTranslation('COURSE_EVALUATION_REPORT_TITLE'),grid);
                }
            },
            
            /*'searchresultgrid[itemId=coursecreditgradereportgridId]': {
                render: function(grid) {
                	this.gridRenderFunction(grid);
     				 this.checkExportButtonPermission(grid,this.getPANDCDASHBOARD_PERMISSIONS());
                	this.getDynamicCourseReportGrid(CONSTANTS.CB.CR_COURSE_CREDIT_GRADE_VIEWCODE,
   						 CONSTANTS.CB.CR_COURSE_CREDIT_GRADE_CONFIGCODE,getCommonTranslation('COURSE_CREDIT_GRADE_REPORT_TITLE'),grid);
                }
            },*/
          //***1**************Export For Report**********************************************************************
			  'searchresultgrid[itemId=courseReportTopicsCreatedGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getCourseReportTopicsCreatedGrid();
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,CONSTANTS.CB.CR_TOPIC_CREATED_LIST_CONFIGCODE,getCommonTranslation('CR_TOPICS_CREATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportTopicsCreatedGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getCourseReportTopicsCreatedGrid();
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,CONSTANTS.CB.CR_TOPIC_CREATED_LIST_CONFIGCODE,getCommonTranslation('CR_TOPICS_CREATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportTopicsCreatedGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getCourseReportTopicsCreatedGrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,CONSTANTS.CB.CR_TOPIC_CREATED_LIST_CONFIGCODE,getCommonTranslation('CR_TOPICS_CREATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportTopicsCreatedGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getCourseReportTopicsCreatedGrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,CONSTANTS.CB.CR_TOPIC_CREATED_LIST_CONFIGCODE,getCommonTranslation('CR_TOPICS_CREATED'));
		            }
		        },
		       //***2*************************************************************************************************** 
		        /*'searchresultgrid[itemId=courseCreditGradeReportGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getCourseCreditGradeReportGrid();
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,CONSTANTS.CB.CR_COURSE_EVALUATION_CONFIGCODE,getCommonTranslation('COURSE_EVALUATION_REPORT_TITLE'));
		            }
		        },*/
		       /* 'searchresultgrid[itemId=courseCreditGradeReportGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getCourseCreditGradeReportGrid();
		                this.exportUserList(SERVERRL.PDFEXPORT,'pdf',true,grid,CONSTANTS.CB.CR_COURSE_EVALUATION_CONFIGCODE,getCommonTranslation('COURSE_EVALUATION_REPORT_TITLE'));
		            }
		        },*/
		       /* 'searchresultgrid[itemId=courseCreditGradeReportGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getCourseCreditGradeReportGrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,CONSTANTS.CB.CR_COURSE_EVALUATION_CONFIGCODE,getCommonTranslation('COURSE_EVALUATION_REPORT_TITLE'));
		            }
		        },*/
		       /* 'searchresultgrid[itemId=courseCreditGradeReportGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getCourseCreditGradeReportGrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,CONSTANTS.CB.CR_COURSE_EVALUATION_CONFIGCODE,getCommonTranslation('COURSE_EVALUATION_REPORT_TITLE'));
		            }
		        },	*/	       
		        //*********************************************************************************************************************   

		        'searchresultgrid[itemId=courseReportCourseGroupAssociatedGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getCourseReportCourseGroupAssociatedGrid();
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,CONSTANTS.CB.CR_COURSE_GROUP_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_COURSE_GROUP_ASSOCIATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportCourseGroupAssociatedGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getCourseReportCourseGroupAssociatedGrid();
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,CONSTANTS.CB.CR_COURSE_GROUP_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_COURSE_GROUP_ASSOCIATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportCourseGroupAssociatedGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getCourseReportCourseGroupAssociatedGrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,CONSTANTS.CB.CR_COURSE_GROUP_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_COURSE_GROUP_ASSOCIATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportCourseGroupAssociatedGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getCourseReportCourseGroupAssociatedGrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,CONSTANTS.CB.CR_COURSE_GROUP_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_COURSE_GROUP_ASSOCIATED'));
		            }
		        },  
		      //****3**********************************************************************************************************
		        'searchresultgrid[itemId=courseReportCourseComponentAssociatedGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getCourseReportCourseComponentAssociatedGrid();
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,CONSTANTS.CB.CR_COURSE_COMPONENT_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_COURSE_COMPONENT_ASSOCIATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportCourseComponentAssociatedGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getCourseReportCourseComponentAssociatedGrid();
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,CONSTANTS.CB.CR_COURSE_COMPONENT_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_COURSE_COMPONENT_ASSOCIATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportCourseComponentAssociatedGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getCourseReportCourseComponentAssociatedGrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,CONSTANTS.CB.CR_COURSE_COMPONENT_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_COURSE_COMPONENT_ASSOCIATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportCourseComponentAssociatedGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getCourseReportCourseComponentAssociatedGrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,CONSTANTS.CB.CR_COURSE_COMPONENT_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_COURSE_COMPONENT_ASSOCIATED'));
		            }
		        },
		      //***4**********************************************************************************************************  
		        'searchresultgrid[itemId=courseReportProgramBatchAssociatedGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getCourseReportProgramBatchAssociatedGrid();
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,CONSTANTS.CB.CR_PREOGRAM_BATCH_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_PROGRAM_BATCH_ASSOCIATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportProgramBatchAssociatedGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getCourseReportProgramBatchAssociatedGrid();
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,CONSTANTS.CB.CR_PREOGRAM_BATCH_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_PROGRAM_BATCH_ASSOCIATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportProgramBatchAssociatedGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getCourseReportProgramBatchAssociatedGrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,CONSTANTS.CB.CR_PREOGRAM_BATCH_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_PROGRAM_BATCH_ASSOCIATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportProgramBatchAssociatedGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getCourseReportProgramBatchAssociatedGrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,CONSTANTS.CB.CR_PREOGRAM_BATCH_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_PROGRAM_BATCH_ASSOCIATED'));
		            }
		        },
		      //**5***********************************************************************************************************  
		        'searchresultgrid[itemId=courseReportCourseVariantsAssociatedGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getCourseReportCourseVariantsAssociatedGrid();
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,CONSTANTS.CB.CR_COURSE_VARIANTS_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_COURSE_VARIANTS_ASSOCIATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportCourseVariantsAssociatedGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getCourseReportCourseVariantsAssociatedGrid();
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,CONSTANTS.CB.CR_COURSE_VARIANTS_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_COURSE_VARIANTS_ASSOCIATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportCourseVariantsAssociatedGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getCourseReportCourseVariantsAssociatedGrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,CONSTANTS.CB.CR_COURSE_VARIANTS_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_COURSE_VARIANTS_ASSOCIATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportCourseVariantsAssociatedGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getCourseReportCourseVariantsAssociatedGrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,CONSTANTS.CB.CR_COURSE_VARIANTS_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_COURSE_VARIANTS_ASSOCIATED'));
		            }
		        },
		      //*********************************************************************************************************************      
		      //**6***********************************************************************************************************  
		        'searchresultgrid[itemId=courseReportCourseReadingMaterialAssociatedGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getCourseReportCourseReadingMaterialAssociatedGrid();
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,CONSTANTS.CB.CR_READING_MATERIAL_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_READING_MATERIAL_ASSOCIATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportCourseReadingMaterialAssociatedGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getCourseReportCourseReadingMaterialAssociatedGrid();
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,CONSTANTS.CB.CR_READING_MATERIAL_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_READING_MATERIAL_ASSOCIATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportCourseReadingMaterialAssociatedGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getCourseReportCourseReadingMaterialAssociatedGrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,CONSTANTS.CB.CR_READING_MATERIAL_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_READING_MATERIAL_ASSOCIATED'));
		            }
		        },
		        'searchresultgrid[itemId=courseReportCourseReadingMaterialAssociatedGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getCourseReportCourseReadingMaterialAssociatedGrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,CONSTANTS.CB.CR_READING_MATERIAL_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_READING_MATERIAL_ASSOCIATED'));
		            }
		        },
		      //*********************************************************************************************************************   
		       
		        'searchresultgrid[itemId=courseevaluationstructureGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getCourseevaluationstructureGrid();
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,CONSTANTS.CB.CR_COURSE_EVALUATION_CONFIGCODE,getCommonTranslation('COURSE_EVALUATION_REPORT_TITLE'));
		            }
		        },
		        'searchresultgrid[itemId=courseevaluationstructureGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getCourseevaluationstructureGrid();
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,CONSTANTS.CB.CR_COURSE_EVALUATION_CONFIGCODE,getCommonTranslation('COURSE_EVALUATION_REPORT_TITLE'));
		            }
		        },
		        'searchresultgrid[itemId=courseevaluationstructureGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getCourseevaluationstructureGrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,CONSTANTS.CB.CR_COURSE_EVALUATION_CONFIGCODE,getCommonTranslation('COURSE_EVALUATION_REPORT_TITLE'));
		            }
		        },
		        'searchresultgrid[itemId=courseevaluationstructureGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getCourseevaluationstructureGrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,CONSTANTS.CB.CR_COURSE_EVALUATION_CONFIGCODE,getCommonTranslation('COURSE_EVALUATION_REPORT_TITLE'));
		            }
		        },
		        //*********************************************************************************************************************   
			       
		        'coursereportsearchform combo[itemId=academyLocationId]': {
        		 select: function(obj, record) {
        			 var academyLocationId = record[0].get("id");        			 
        			 obj.nextSibling().clearValue();
        			 this.getCoursereportsearchform().down('#courseReportCourseId').setDisabled(false);
        			 //this.getcoursereporttreepanelandgrid
        			/*var grid= this.getCoursereportstructure().down('coursecreditgradereportgrid');
        			if(!isNullOrEmpty(grid)){
        			grid.down('#btnExportToPDF').setDisabled(false);
        			grid.down('#btnExportToExcel').setDisabled(false);
        			}*/
        			 var store = this.getStore('course.CourseComboStore');
        			 store.getProxy().extraParams = {
        				 academyLocationId : academyLocationId
        			 };
        			 store.load();                    
        		 }
        	 },
        	 
        	 'coursereportsearchform combo[itemId=courseReportCourseId]': {
                 beforeselect: function(combo, comboInitVal) {
                     var tbpnl = combo.up('coursereportstructure').down('tabpanel');
                     var openTabs = tbpnl.items.items;
                     if (openTabs.length) {
                         showConfirmMessage(getCommonTranslation('COURSE_REPORT'), getCommonTranslation('ON_COURSE_CHANGE_ALL_SUB_REPORTS_CLOSED'),
                             function(btn, text) {
                                 if (btn == 'yes') {
                                     tbpnl.removeAll();
                                     combo.setValue(comboInitVal);
                                     combo.fireEvent('select', combo, [comboInitVal]);
                                 }
                                 else {
                                     var activeItem = combo.getPicker().down('.x-boundlist-item.x-item-selected');
                                     if (activeItem) {
                                         activeItem.removeCls('x-item-selected');
                                     }
                                     combo.setValue(combo.getValue());
                                 }
                             });
                         return false;
                     }
                 },
            },
            
        	 'coursereportsearchform':{
        		 render : function(){
        			 var ALField = this.getCoursereportsearchform().down("#academyLocationId");
        			 this.setDefaultAcademyLocation(ALField);
        		 }
        	 }
        	 /*'searchresultgrid[itemId=courseReportCourseGroupAssociatedGrid]': {
        		 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
        			 var searchResultGrid = this.getSearchresultgrid();
        			 var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
        			 if(columnName=='PROGRAM_ASSOCIATED'){
        				 var store=$this.getStore('course.coursegroup.ProgramBYCourseGroup');
		                  	store.getProxy().extraParams = {
		                  		courseGroupId: record.data.ID
		    					    };
		                  	store.load();
		                  	
		                  	var formWindow = $this.getNoofprogram();
		     	       		        if (!formWindow) {
		     	       		             Ext.widget('noofprogram');
		     	       		            formWindow = $this.getNoofprogram();
		     	       		       }
		  	       		        formWindow.show();
		              	   }
        			 }
        		 }*/
        });
    },
    
    /************************ START: Common functions for dynamic grid links  ****************************************/
    	getDynamicCourseReportGrid : function(respectiveLinkViewCode, respectiveLinkConfigCode, tabName,resultGrid,model, records) {
    	
    	/*var searchResultGridCG = this.getSearchresultgrid();
		if (!searchResultGridCG) {
			Ext.widget('searchresultgrid');
			searchResultGridCG = this.getSearchresultgrid();
		}*/
		
		searchResultGridCG = resultGrid;
		
		
		searchResultGridCG.setTitle(tabName);
		
        var courseReportSearchForm = this.getCoursereportsearchform();
        courseReportSearchForm.down('#courseReportSearchButtonId').setDisabled(true);

        var jsonFormatFormData = this.createJsonFormat(courseReportSearchForm, respectiveLinkConfigCode, records);

        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        
        resultViewUrl = resultViewUrl.concat(respectiveLinkViewCode);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
       
        searchResultGridCG.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData,courseReportSearchForm.down('#courseReportSearchButtonId'));
        Ext.getBody().unmask();
    },
    createJsonFormat: function(courseReportSearchForm, respectiveLinkConfigCode, records) {
      //  var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();
        var courseId = courseReportSearchForm.getForm().findField('courseId');
        var academyLocationId = courseReportSearchForm.getForm().findField('academyLocationId');
        values.configCode = respectiveLinkConfigCode;
        
        var COURSE_ID = this.getJsonObject('COURSE_ID', courseId.getValue());
        this.pushJsonObjectInArray(COURSE_ID,searchcriteria);
        
        var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID', academyLocationId.getValue());
        this.pushJsonObjectInArray(ACADEMY_LOCATION_ID,searchcriteria);

        values.searchCriterias = searchcriteria;
        return values;
    },
    getJsonObject: function(key, value, additionalValue) {
      	 if (value != '' && value != null && additionalValue == undefined) {
      		 return {
      			 "paramCode": key,
      			 "paramValues": [value]
      		 };
      	 } else if (value != '' && additionalValue != undefined) {
      		 return {
      			 "paramCode": key,
      			 "paramValues": [value, additionalValue]
      		 };
      	 }
       },
       pushJsonObjectInArray: function(object, array) {
      	 if (object) {
      		 array.push(object);
      	 }
       },
       courseReportSearchButton:function(){
    	   var $this = this;
    	   var contentPanel = $this.getCoursereportstructure().down('tabpanel').items.items[0];
    	   if(!isNullOrEmpty(contentPanel.items) && contentPanel.items.items[0]){
    		 /*  var itm = $this.getCoursereportstructure().down('tabpanel').items.items[0].items.items[0].items.items[0];*/
    		   var itm = $this.getCoursereportstructure().down('tabpanel').getActiveTab().items.items[0].items.items[0];
    		   if(itm.itemId == 'coursegroupassociatedgridId'){
    			   this.loadCourseGroup(itm);

    		   } else if(itm.itemId == 'courseReportCourseComponentAssociatedGrid') {
    			   var grid = $this.getSearchresultgrid();
    			   this.gridRenderFunction(grid);
    			   this.checkExportButtonPermission(grid,this.getCOURSE_COMPONENT_ASSOCIATED_REPORT_PRIVILEGES());
    			   this.getDynamicCourseReportGrid(CONSTANTS.CB.CR_COURSE_COMPONENT_ASSOCIATED_VIEWCODE,
    					   CONSTANTS.CB.CR_COURSE_COMPONENT_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_COURSE_COMPONENT_ASSOCIATED'),grid);

    		   } else if(itm.itemId == 'courseReportProgramBatchAssociatedGrid') {
    			   var grid = $this.getSearchresultgrid();
    			   this.gridRenderFunction(grid);
    			   this.checkExportButtonPermission(grid,this.getPANDCDASHBOARD_PERMISSIONS());
    			   this.getDynamicCourseReportGrid(CONSTANTS.CB.CR_PREOGRAM_BATCH_ASSOCIATED_VIEWCODE,
    					   CONSTANTS.CB.CR_PREOGRAM_BATCH_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_PROGRAM_BATCH_ASSOCIATED'),grid);

    		   } else if(itm.itemId == 'courseReportCourseVariantsAssociatedGrid') {
    			   var grid = $this.getSearchresultgrid();
    			   this.gridRenderFunction(grid);
    			   this.checkExportButtonPermission(grid,this.getCOURSE_VARIENTS_ASSOCIATED_REPORT_PRIVILEGES());
    			   this.getDynamicCourseReportGrid(CONSTANTS.CB.CR_COURSE_VARIANTS_ASSOCIATED_VIEWCODE,
    					   CONSTANTS.CB.CR_COURSE_VARIANTS_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_COURSE_VARIANTS_ASSOCIATED'),grid);

    		   } else if(itm.itemId == 'courseReportCourseReadingMaterialAssociatedGrid') {
    			   var grid = $this.getSearchresultgrid();
    			   this.gridRenderFunction(grid);
    			   this.checkExportButtonPermission(grid,this.getREADING_MATERIAL_ASSOCIATED_REPORT_PRIVILEGES());
    			   this.getDynamicCourseReportGrid(CONSTANTS.CB.CR_READING_MATERIAL_ASSOCIATED_VIEWCODE,
    					   CONSTANTS.CB.CR_READING_MATERIAL_ASSOCIATED_CONFIGCODE,getCommonTranslation('CR_READING_MATERIAL_ASSOCIATED'),grid);
    		   } else if(itm.itemId == 'courseevaluationstructureGrid') {
    			   var grid = $this.getSearchresultgrid();
    			   this.gridRenderFunction(grid);
    			   this.checkExportButtonPermission(grid,this.getCOURSE_ASSESSMENT_REPORT_PRIVILEGES());
    			   this.getDynamicCourseReportGrid(CONSTANTS.CB.CR_COURSE_EVALUATION_VIEWCODE,
    					   CONSTANTS.CB.CR_COURSE_EVALUATION_CONFIGCODE,getCommonTranslation('COURSE_EVALUATION_REPORT_TITLE'),grid);
    		   } else if(itm.itemId == 'courseReportTopicsCreatedGrid') {
    			   var grid = $this.getSearchresultgrid();
    			   this.gridRenderFunction(grid);
    			   this.checkExportButtonPermission(grid,this.getTOPICS_CREATED_REPORT_PRIVILEGES());
    			   this.getDynamicCourseReportGrid(CONSTANTS.CB.CR_TOPIC_CREATED_LIST_VIEWCODE,
    					   CONSTANTS.CB.CR_TOPIC_CREATED_LIST_CONFIGCODE,getCommonTranslation('CR_TOPICS_CREATED'),grid);
    		   }
    		/*   else if(itm.itemId == 'coursecreditgradereportgridId') {
    			   this.loadCourseCreditGradeReport(itm);
    			 //  this.gridRenderFunction(grid);
    			  // this.checkExportButtonPermission(grid,this.getPANDCDASHBOARD_PERMISSIONS());
    			  // this.getDynamicCourseReportGrid(CONSTANTS.CB.CR_COURSE_CREDIT_GRADE_VIEWCODE,
    					//   CONSTANTS.CB.CR_COURSE_CREDIT_GRADE_CONFIGCODE,getCommonTranslation('COURSE_CREDIT_GRADE_REPORT_TITLE'),grid);
    		   }*/ 
    	   }
       },
       gridRenderFunction:function(grid){
       	 grid.addButtonToolbar();
        },
    /************************ END: Common functions for dynamic grid links  ****************************************/
        //**********************************Export Functionality********************************************************
          exportUserList : function(exportUrl,filetype,whetherAll,grid,configcode,reportTitle) {
       	   var quickSearchForm = null;
       	   var searchResultGrid = null;
       	   var pagingtoolbaroptions = null; 
       	   var searchCriteriaString = null;
       	   var jsonFormatFormData = null;
         
       	     quickSearchForm=this.getCoursereportsearchform(); 
       	     searchResultGrid = grid;
       	     pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
       	     searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
       	     jsonFormatFormData=this.createJsonFormat(quickSearchForm,configcode,null);
       	  
       	   
       	   var visibleColumns=this.getVisibleColumns(searchResultGrid);
       	   //var reportTitle=getCommonTranslation("COURSE_REPORT_LIST");
       	   if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
       		   jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
       	   }
       	   searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
       	   console.log("exportSuccess");
          }, 
        //**************************************End*********************************************************************  
       	   createSearchCriteriaString: function(searchForm) {
       		   var me=this;
       		   var formValues = new Array();
       		   formValues = searchForm.getValues();        
       		   var searchCriteriaString="";
       		   for (var key in formValues) {
       			   var value = formValues[key];            
       			   if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
       				   //  var keyValueJsonObject = me.getJsonObject( key , value);
       				   //searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
       			   }
       		   }
       		   searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
       		   return searchCriteriaString;
       	   },
       	   getOpenCourseReportStructure : function(treePanel, record, item,index, e, eOpts){
       		   var $this = this;
       		   var containpanel = $this.getCoursereporttreepanelandgrid();
       		   var treePanel = containpanel.down('#courseReportTreePanelItemId');
       		   var tabDetail = record.data;
       		   var structure = Ext.widget(tabDetail.reportXtype);
       		   var tabstructure = containpanel.down('#tabpanelIds');

       		   if (!isNullOrEmpty(tabDetail.text)
       				   && !isNullOrEmpty(tabDetail.reportXtype)
       				   && !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
       			   treePanel.toggleCollapse();
       			   openTab(tabstructure, tabDetail.text,structure);
       			   treePanel.getSelectionModel().deselectAll();
       		   }
       	   }/*,
          	loadCourseCreditGradeReport: function(grid) {
          		this.doAccessControlValidation(grid, this.getCOURSE_CREDIT_GRADE_REPORT_PRIVILEGES());
          		
			  	var gridStore = grid.getStore();
           		var courseReportSearchForm = this.getCoursereportsearchform();
           		if(isNullOrEmpty(courseReportSearchForm.down('#academyLocationId').getValue())){
              		grid.down('#btnExportToPDF').setDisabled(true);
              		grid.down('#btnExportToExcel').setDisabled(true);
              		}else{
              			grid.down('#btnExportToPDF').setDisabled(false);
                  		grid.down('#btnExportToExcel').setDisabled(false);
              		}
           		var courseId = courseReportSearchForm.down('#courseReportCourseId').getValue();
           		var academyLocationId = courseReportSearchForm.down('#academyLocationId').getValue();
           		gridStore.getProxy().extraParams = {
    				   courseId:courseId,
    				   academyLocationId:academyLocationId
    				   };
           		this.resetPageSetting(gridStore);
           		gridStore.load();
				grid.config.searchFilterForm = courseReportSearchForm;
           	}*/
       	   ,  
       	loadCourseGroup: function(grid) {
       		var gridStore = grid.getStore();
       		var courseReportSearchForm = this.getCoursereportsearchform();
       		courseReportSearchForm.down('#courseReportSearchButtonId').setDisabled(true);
       		var courseId = courseReportSearchForm.down('#courseReportCourseId').getValue();
       		var academyLocationId = courseReportSearchForm.down('#academyLocationId').getValue();
       		gridStore.getProxy().extraParams = {
				   courseId:courseId,
				   academyLocationId:academyLocationId
				   };
       		this.resetPageSetting(gridStore);
       		gridStore.load({
				callback: function(records, operation, success) {
					courseReportSearchForm.down('#courseReportSearchButtonId').setDisabled(false);
					}
	    		   });
       	},
       	
       	checkExportButtonPermission: function(gridReference, privilegeList) {
       		var associatedAcadLocationIds = new Array();
    		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegeList);
    		
    		buttonsToolBar = gridReference.query('toolbar')[0];
        	/*
        	 * querying the buttons and unhiding them if any.
        	 */
        	var buttons = buttonsToolBar.query('button');
        	Ext.each(buttons, function(button) {
        		button.setVisible(false);
        	});
        	
        	Ext.each(permissionList, function(privilege) {
        		 if (privilege === 'EXPORT') {
            		var buttonsArray = new Array();
            		buttonsArray.push(buttonsToolBar.query('#exportToPdfBtn')[0]);
            		buttonsArray.push(buttonsToolBar.query('#exportToXcelBtn')[0]);
            		buttonsArray.push(buttonsToolBar.query('#btnExportToCSV')[0]);
            		buttonsArray.push(buttonsToolBar.query('#btnExportToPDF')[0]);
            		buttonsArray.push(buttonsToolBar.query('#btnExportToExcel')[0]);
            		Ext.each(buttonsArray, function(button) {
            			if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}  
            		});
            	}
        	});
        }
});