/*
 *  @author Dharmendra.prajapati
 * 
 */
Ext
		.define(
				'Academia.controller.coursetransaction.sectioncoursecoverageplan.CourseCoveragePlanDetailsController',
				{
					extend : 'Academia.controller.base.BaseController',
					models : [
							'common.IdValueCodeDataModel',
							'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CoveragePlanGrid',
							'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CoveragePlanDetails',
							'facilitiesresources.resourcebooking.FacilityTreeModel'],

					stores : [
							'coursetransaction.sectionmanagement.CoruseSectionStore',
							'course.coursetopic.CourseComponentStore',
							'coursetransaction.facultytopicassignment.CourseSectionByIDStore',
							'common.ProgramStore',
							'enquiry.AcademicBatchStore',
							'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
							'coursetransaction.facultytopicassignment.CourseComboStore',
							'course.coursetopic.CourseComponentStore',
							'coursetransaction.facultytopicassignment.CourseSectionByPeriodIDCourseIDStore',
							'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoom',
							'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CoveragePlanGrid',
							'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.FacultyByTopicAndSection',
							'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.Topic',
							'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.TopicByCourseId',
							'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore',
							'facilitiesresources.resourcebooking.ResourceBookingFormFacilitiesTreeStore',
							'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.RoomBlankStore',
							'common.AcademicTermStore',
							'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoomStore',
							'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.NewClassRoomStore',
							'program.programDetails.programBatches.courseParameter.ExtendedTimeTablePBSGridStore',
							'program.programDetails.programBatches.courseParameter.ExtendedTimeTableCBSGridStore',
							'programCourseDashboard.ParameterisedSectionDetailsStore'
							],

					views : [
							'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.SectionCourseCvrgPlan',
							'coursetransaction.sectioncoursecoverageplan.CourseCoveragePlanDetailsStructure',
							'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.SectionCourseCvrgPlanGrid',
							'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CoverageDetails',
							'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.NewSession',
							'coursetransaction.sectioncoursecoverageplan.CourseCoveragePlanMasterStructure',
							'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.UpdateCoverageDetail',
							'coursetransaction.sectioncoursecoverageplan.CourseCoveragePlanBasicSearchFilter',
							'coursetransaction.sectioncoursecoverageplan.ExtendedTimeTableCBSGrid',
							'coursetransaction.sectioncoursecoverageplan.ExtendedTimeTablePBSGrid'],

					config : {
						/*
						 * CODE FOR setting up the featurePrivileges from
						 * FeaturePrivilegeManager which sets the privileges for
						 * the passed parameter screen.
						 */
						/**
						 * @cfg {Array} CREATE_TIME_TABLE_PRIVILEGES array
						 *      (required) The array of permissions to use for
						 *      Access control wise enabling and disabling
						 *      buttons.
						 * @accessor
						 */
						CREATE_TIME_TABLE_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager
								.getFeaturePrivilegesMap('CREATE_TIME_TABLE_PRIVILEGES')
					},

					refs : [
							{
								ref : 'updatecoveragedetail',
								selector : 'updatecoveragedetail'
							},
							{
								ref : 'updatecoverageDetail',
								selector : 'updatecoveragedetail form'
							},
							{
								ref : 'newsession',
								selector : 'newsession'
							},
							{
								ref : 'newSession',
								selector : 'newsession form'
							},
							{
								ref : 'coveragedetails',
								selector : 'coveragedetails'
							},
							{
								ref : 'coverageDetails',
								selector : 'coveragedetails form'
							},
							{
								ref : 'sectioncoursecvrgplangrid',
								selector : 'sectioncoursecvrgplangrid'
							},
							{
								ref : 'coursecoverageplandetailsstructure',
								selector : 'coursecoverageplandetailsstructure'
							},
							{
								ref : 'coursecoverageplanbasicsearchfilter',
								selector : 'coursecoverageplanbasicsearchfilter'
							},
							{
								ref : 'sectioncoursecvrgplan',
								selector : 'sectioncoursecvrgplan'
							},{
					        	 ref: 'extendedtimetablepbsgrid',
					        	 selector: 'extendedtimetablepbsgrid'
					         },{
					        	 ref: 'extendedtimetablecbsgrid',
					        	 selector: 'extendedtimetablecbsgrid'
					         }],
					init : function() {
						this
								.control({
									'coursecoverageplanbasicsearchfilter' : {
										render : function(obj) {
											this.loadResourseType();
										}
									},
									

					        		 'extendedtimetablecbsgrid button[itemId=btnAdd]': {
					        			 click : function() {
					        				 this.newSessionWindow();
					        			 }
					        		 },
					        		 'extendedtimetablepbsgrid button[itemId=btnAdd]': {
					        			 click : function() {
					        				 this.newSessionWindow();
					        			 }
					        		 },
					        		 'extendedtimetablepbsgrid':{
					        			 afterrender:function(grid){
					 						var newStructure = grid.up('coursecoverageplanbasicsearch');
					 						this.getGridHeaderFreeze(grid,newStructure, false);
					 					
					        			 }
					        		 },'extendedtimetablecbsgrid':{
					        			 afterrender:function(grid){
						 						var newStructure = grid.up('coursecoverageplanbasicsearch');
						 						this.getGridHeaderFreeze(grid,newStructure, false);
						 					
						        			 }
						        		 },
									'extendedtimetablecbsgrid button[itemId=btnEdit]' : {
										click : function() {
											var grid = this.getExtendedtimetablecbsgrid();
											this.updateCoverage(grid);
										}
									},
									'extendedtimetablepbsgrid button[itemId=btnEdit]' : {
										click : function() {
											var grid = this.getExtendedtimetablepbsgrid();
											this.updateCoverage(grid);
										}
									},
									'sectioncoursecvrgplangrid button[itemId=addCoverageDetails]' : {
										click : function() {
											this.showCoverageDetails();
										}
									},
									'sectioncoursecvrgplangrid button[itemId=addNewSession]' : {
										click : function(obj) {
											this.newSessionWindow();
										}
									},
									'sectioncoursecvrgplan radiogroup[itemId=courseSectionRadio_Id]' : {
										change : function() {
											this.sectionDropDown();
										}
									},
									'sectioncoursecvrgplan button[itemId=courseCoverageGetTopics]' : {
										click : function() {
											this.coveragePlanGridRender();
										}
									},
									'coveragedetails combo[itemId=classRommId]' : {
										select : function(obj, record) {
											this.checkAvailability(obj, record);
										}
									},
									'newsession combo[itemId=classRommId]' : {
										select : function(obj, record) {
											this.checkAvailability(obj, record);
										}
									},
									'updatecoveragedetail combo[itemId=classRommId]' : {
										select : function(obj, record) {
											this.checkAvailability(obj, record);
										}
									},
									'coveragedetails button[itemId=SubmitBtn]' : {
										click : function() {
											var form = this
													.getCoverageDetails()
													.getForm();
											this.addCoverageDetails(form);
										}
									},
									'updatecoveragedetail button[itemId=SubmitBtn]' : {
										click : function() {
											var form = this
													.getUpdatecoverageDetail()
													.getForm();
											this.updateCoverageDetails(form);
										}
									},
									'updatecoveragedetail button[itemId=CancelBtn]' : {
										click : function() {
											this.getUpdatecoveragedetail()
													.close();
										}
									},
									'coveragedetails button[itemId=CancelBtn]' : {
										click : function() {
											this.getCoveragedetails().close();
										}
									},
									'newsession button[itemId=CancelBtn]' : {
										click : function() {
											this.getNewsession().close();
										}
									},
									'newsession button[itemId=SubmitBtn]' : {
										click : function() {
											var form = this.getNewSession()
													.getForm();
											
											
											this.addCoverageDetails(form);
										}
									},
									

									'newsession' : {
										render : function() {
											//this.sectionDropDown();
											var academyLocationId = this.getCurrentAcademyLocation();
											var courseCombo = this.getNewsession().down('customcombobox#courseId');
											var sectionType=this.getCoursecoverageplanbasicsearchfilter().down('#courseSectionTypeRadio').getValue();
											var sectionTypeValue=null;
											if(sectionType == 'CBS'){
												sectionTypeValue='CourseSection';
											}else{
												sectionTypeValue='ProgramBatchSection';
											}
											var courseStore = courseCombo.getStore();
											courseStore.getProxy().extraParams = {
												sectionType : sectionTypeValue,
												academyLocationId : academyLocationId
											};
											courseStore.load();

										}
									},
									
									'newsession' : {
										afterrender : function() {
											var searchForm = this.getCoursecoverageplanbasicsearchfilter().getForm();
											var sectionType=this.getCoursecoverageplanbasicsearchfilter().down('#courseSectionTypeRadio').getValue().sectionType;
											//var courseCombo1 = this.getNewsession().down('combo#courseId_1');
											var courseCombo = this.getNewsession().down('combo#courseId');
											//

											var sectionTypeValue=null;
											if(sectionType != "CBS" && sectionType != "CourseSection"){
												sectionTypeValue='ProgramBatchSection';
											}
											else{
												sectionTypeValue='CourseSection';
											}
											var courseStore = courseCombo.getStore();
											courseStore.getProxy().extraParams = {
												sectionType : sectionTypeValue,
												academyLocationIds : this.getCurrentAcademyLocation()
											};
											courseStore.load();

											var form = this.getNewSession().getForm();
											form.findField('sectionType').setValue(sectionType);
											this.showTotalStudentNo(form);
										},
									},
									'newsession combo#newSessionTopic_Id' : {
										select : function(obj, record) {
											this.getSessionOfNewSeeion(obj,
													record);
										}
									},
									'newsession customcombobox#courseSection_Id' : {
										select : function(obj, record) {
											this.getSessionOfNewSeeion(obj,
													record);
										}
									},
									'newsession datefield#sessionDateId' : {
										select : function(obj, record) {
											this.getSessionOfNewSeeion(obj,
													record);
										}
									},
									'newsession customcombobox#courseId' : {
										select : function(obj, record) {
					        			var this$ = this;
					        			var form = this.getNewSession().getForm();
					        			var courseId = record[0].get("id");
					        			var academyLocationId = this.getCurrentAcademyLocation();
					        			var alinfomodel = Academia.model.authentication.ALInfoModel;
						                var wheatherSchool = alinfomodel.get('wheatherSchool');
					        								                
						                var courseComponentBox = this.getNewsession().down('customcombobox#courseId');
					        			
					        			var courseSectionComboBox = this.getNewsession().down('customcombobox#courseSection_Id');
					        			courseSectionComboBox.clearValue();
											
										var topicComboBox = this.getNewsession().down('multiselectcombofield#newSessionTopic_Id');
										var courseId = this.getNewsession().down('customcombobox#courseId').getValue();
										
										var courseComponentId =courseComponentBox.getStore().findRecord("id",courseId).data.componentId;	

										topicComboBox.clearValue();
										topicComboBox.setDisabled(false);
										var topicStore = topicComboBox.getStore();
													
										topicStore.getProxy().extraParams = {
												courseId : courseId,
												componentId : courseComponentId
										};
										topicStore.load();
											
									    var sectionBox = this.getNewsession().down('customcombobox#courseSection_Id');
									    sectionBox.setDisabled(false);
									    sectionBox.clearValue();
									    var sectionStore = sectionBox.getStore();
									    sectionStore.getProxy().extraParams = {
										courseId : courseId
									    };
									    sectionStore.load();
									        					 
			        					courseSectionComboBox.setDisabled(false);
			        					var courseSectionStore = courseSectionComboBox.getStore();
			        					 courseSectionStore.getProxy().extraParams = {
			        						 courseId: courseId,
			        						 academyLocationIds:academyLocationId
			        					 };
			        					 courseSectionStore.load({
				        						 callback: function(records, operation, success) {
				        							 if (success) {
				        								 if(records.length==1){
				        									 var sectionId = records[0].get('id');
				        									 
				        									 this$.getNewsession().down('#courseSection_Id').setValue(sectionId);
				        								 }
				        							 }
				        						 }
				        					 });
				        					 
				        					 
			        					 var slotFrom = this.getNewsession().down('timefield#slotFrom');
										    
			        					 slotFrom.clearValue();
			        					 slotFrom.reset();
			        					 var slotTo = this.getNewsession().down('timefield#slotTo');
										 slotTo.clearValue();
			        					 slotTo.reset();
			        					 
			        					// this.getNewsession().down('timefield#classRommId').setDisabled(true);
			        					// this.getNewsession().down('timefield#assignFacultyId').setDisabled(true);

			        					 		        					 
			        				}
									},
									'sectioncoursecvrgplan' : {
										render : function() {
											this.sectionDropDown();
											var academyLocationId = this.getCurrentAcademyLocation();
											var courseCombo = this.getSectioncoursecvrgplan().down('combo#course_Id');
											var courseStore = courseCombo.getStore();
											courseStore.getProxy().extraParams = {
												sectionType : 'CourseSection',
												academyLocationId : academyLocationId
											};
											courseStore.load();

										}
									},
									'sectioncoursecvrgplan combo#course_Id' : {
										select : function(obj, record) {
											var courseId = record[0]
													.get("courseId");
											var courseComponentBox = this
													.getSectioncoursecvrgplan()
													.down(
															'combo#componentSectionId');
											var sectionBox = this
													.getSectioncoursecvrgplan()
													.down(
															'combo#courseSection_Id');
											courseComponentBox.clearValue();
											sectionBox.clearValue();
											if (record[0]
													.get("sectionAtComponentLevel")) {
												courseComponentBox.show();
												courseComponentBox.allowBlank = false;
												sectionBox.setDisabled(true);
												var store = courseComponentBox
														.getStore();
												store.getProxy().extraParams = {
													id : courseId
												};
												store.load();
											} else {
												var courseComboBox = this
														.getSectioncoursecvrgplan()
														.down(
																'combo#courseSection_Id');
												courseComboBox.clearValue();
												courseComponentBox.hide();
												courseComponentBox.allowBlank = true;
												sectionBox.setDisabled(false);
												var courseStore = courseComboBox
														.getStore();
												courseStore.getProxy().extraParams = {
													parentCourseId : courseId
												};
												courseStore.load();
											}
										}
									},
									'sectioncoursecvrgplan combo#componentSectionId' : {
										select : function(obj, record) {
											var componentId = record[0]
													.get("id");
											var courseId = this
													.getSectioncoursecvrgplan()
													.getForm().findField(
															'course')
													.getValue();
											var sectionBox = this
													.getSectioncoursecvrgplan()
													.down(
															'combo#courseSection_Id');
											sectionBox.setDisabled(false);
											sectionBox.clearValue();
											var store = sectionBox.getStore();
											store.getProxy().extraParams = {
												componentId : componentId,
												parentCourseId : courseId
											};
											store.load();
										}
									},
									'sectioncoursecvrgplan combo#courseSection_Id' : {
										select : function(obj, record) {
											var id = record[0].get("sectionId");
											var courseVariantId = record[0].data.courseVariantId;
											var searchForm = this
													.getSectioncoursecvrgplan()
													.getForm();
											searchForm.findField(
													'courseVariantId')
													.setValue(courseVariantId);
											this.setRoomNteacherBySection(id);
										}
									},

									// program batch course section
									'sectioncoursecvrgplan combo#program_Id' : {
										select : function(obj, record) {
											var programId = record[0].get("id");
											var batchComboBox = this
													.getSectioncoursecvrgplan()
													.down('combo#batch_Id');
											batchComboBox.clearValue();
											batchComboBox.setDisabled(false);
											var batchStore = batchComboBox
													.getStore();
											batchStore.getProxy().extraParams = {
												id : programId
											};
											batchStore.load();
											var courseBox = this
													.getSectioncoursecvrgplan()
													.down(
															'combo#programCourse_Id');
											var courseComponentBox = this
													.getSectioncoursecvrgplan()
													.down(
															'combo#componentSectionItemId');
											var sectionBox = this
													.getSectioncoursecvrgplan()
													.down(
															'combo#programCoursesection_ID');
											var periodBox = this
													.getSectioncoursecvrgplan()
													.down('combo#period_Id');
											courseBox.clearValue();
											courseComponentBox.clearValue();
											sectionBox.clearValue();
											periodBox.clearValue();

											courseBox.setDisabled(true);
											courseComponentBox
													.setDisabled(true);
											sectionBox.setDisabled(true);
											periodBox.setDisabled(true);
										}
									},

									'sectioncoursecvrgplan combo#batch_Id' : {
										select : function(obj, record) {
											var batch_Id = record[0].get("id");
											var periodComboBox = this
													.getSectioncoursecvrgplan()
													.down('combo#period_Id');
											periodComboBox.clearValue();
											periodComboBox.setDisabled(false);
											var periodStore = periodComboBox
													.getStore();
											periodStore.getProxy().extraParams = {
												id : batch_Id
											};
											periodStore.load();
											var courseBox = this
													.getSectioncoursecvrgplan()
													.down(
															'combo#programCourse_Id');
											var courseComponentBox = this
													.getSectioncoursecvrgplan()
													.down(
															'combo#componentSectionItemId');
											var sectionBox = this
													.getSectioncoursecvrgplan()
													.down(
															'combo#programCoursesection_ID');
											courseBox.clearValue();
											courseComponentBox.clearValue();
											sectionBox.clearValue();

											courseBox.setDisabled(true);
											courseComponentBox
													.setDisabled(true);
											sectionBox.setDisabled(true);
										}
									},
									'sectioncoursecvrgplan combo#period_Id' : {
										select : function(obj, record) {
											var period_Id = record[0].get("id");
											var programCourseComboBox = this
													.getSectioncoursecvrgplan()
													.down(
															'combo#programCourse_Id');
											programCourseComboBox.clearValue();
											programCourseComboBox
													.setDisabled(false);
											var programBatchStore = programCourseComboBox
													.getStore();
											programBatchStore.getProxy().extraParams = {
												periodId : period_Id,
												sectionType : 'ProgramBatchSection'
											};
											programBatchStore.load();
											var courseComponentBox = this
													.getSectioncoursecvrgplan()
													.down(
															'combo#componentSectionItemId');
											var sectionBox = this
													.getSectioncoursecvrgplan()
													.down(
															'combo#programCoursesection_ID');
											courseComponentBox.clearValue();
											sectionBox.clearValue();

											courseComponentBox
													.setDisabled(true);
											sectionBox.setDisabled(true);
										}
									},
									'sectioncoursecvrgplan combo#componentSectionItemId' : {
										select : function(obj, record) {
											var componentId = record[0]
													.get("id");
											var periodId = this
													.getSectioncoursecvrgplan()
													.getForm().findField(
															'period')
													.getValue();
											var courseId = this
													.getSectioncoursecvrgplan()
													.getForm().findField(
															'programCourse_Id')
													.getValue();
											var sectionBox = this
													.getSectioncoursecvrgplan()
													.down(
															'combo#programCoursesection_ID');
											sectionBox.setDisabled(false);
											sectionBox.clearValue();
											var sectionStore = sectionBox
													.getStore();
											sectionStore.getProxy().extraParams = {
												courseId : courseId,
												periodId : periodId,
												componentId : componentId
											};
											sectionStore.load();
										}
									},
									'sectioncoursecvrgplan combo#programCourse_Id' : {
										select : function(obj, record) {
											var courseId = record[0].get("id");
											var courseComponentBox = this
													.getSectioncoursecvrgplan()
													.down(
															'combo#componentSectionItemId');
											var sectionBox = this
													.getSectioncoursecvrgplan()
													.down(
															'combo#programCoursesection_ID');
											courseComponentBox.clearValue();
											sectionBox.clearValue();
											if (record[0]
													.get("sectionAtComponentLevel")) {
												courseComponentBox.show();
												courseComponentBox
														.setDisabled(false);
												courseComponentBox.allowBlank = false;
												sectionBox.setDisabled(true);
												var store = courseComponentBox
														.getStore();
												store.getProxy().extraParams = {
													id : courseId
												};
												store.load();
											} else {
												var courseComboBox = this
														.getSectioncoursecvrgplan()
														.down(
																'combo#programCoursesection_ID');
												courseComboBox.clearValue();
												courseComponentBox.hide();
												courseComponentBox.allowBlank = true;
												sectionBox.setDisabled(false);
												var courseStore = courseComboBox
														.getStore();
												var periodId = this
														.getSectioncoursecvrgplan()
														.getForm().findField(
																'period')
														.getValue();
												courseStore.getProxy().extraParams = {
													courseId : courseId,
													periodId : periodId
												};
												courseStore.load();
											}
										}
									},
									'sectioncoursecvrgplan combo#programCoursesection_ID' : {
										select : function(obj, record) {
											var id = record[0].get("id");
											var courseVariantId = record[0].data.code;
											var searchForm = this
													.getSectioncoursecvrgplan()
													.getForm();
											searchForm.findField(
													'courseVariantId')
													.setValue(courseVariantId);
											this.setRoomNteacherBySection(id);
										}
									},
									'coursecoverageplandetailsstructure' : {
										render : function() {
											var store = this
													.getStore('coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CoveragePlanGrid');
											store.getProxy().extraParams = {
												courseId : 0,
												sectionId : 0
											};
											store.load();
										}
									},
									'sectioncoursecvrgplangrid' : {
										itemclick : function(dv, record, item,
												index, e) {
											var id = record.data.id;
											var coverageGrid = this
													.getSectioncoursecvrgplangrid();
											var buttonsToolBar = coverageGrid
													.query('toolbar')[0];
											var coverageDetailBtn = buttonsToolBar
													.query('#addCoverageDetails')[0];

											if (id > 0 && id != null) {
												coverageDetailBtn
														.setVisible(false);
											} else {
												coverageDetailBtn
														.setVisible(true);
											}
										}
									},
									'sectioncoursecvrgplangrid' : {
										render : function(grid) {
											var permissionsMap = new Ext.util.HashMap();
											permissionsMap = this
													.getCREATE_TIME_TABLE_PERMISSIONS();
											this.disableMoreActionPivileges(
													grid, permissionsMap);
										}
									},
									/*'updatecoveragedetail' : {
										beforerender : function() {
											this.commonRoom();
										}
									},*/
									'updatecoveragedetail datefield[itemId=sessionDateId]' : {
										select : function(field, value) {
											var form = this
													.getUpdatecoverageDetail()
													.getForm();
											var date = form.findField(
													'sessionDate').getValue();
											this.updateFacutlyAndRoomOnUpdateCoverageDetail(
															field, value, form);// in
																				// side
																				// again
																				// common
																				// room
																				// calling
										}
									},
									'newsession datefield[itemId=sessionDateId]' : {
										select : function(field, value) {
											var form = this.getNewSession().getForm();
											this.getFacutlyAndRoom(field,value, form);
										}
									},
									'newsession customcombobox[itemId=courseSection_Id]' : {
										change : function(field, value) {
											var form = this.getNewSession().getForm();
											this.showTotalStudentNo(form);
										}
									},
									'newsession datefield[itemId=sessionDateId]' : {
										select : function(field, value) {
											var form = this.getNewSession().getForm();
											this.showTotalStudentNo(form);
										}
									},
									'coveragedetails datefield[itemId=sessionDateId]' : {
										select : function(field, value) {
											var form = this.getCoverageDetails().getForm();
											this.getFacutlyAndRoom(field,value, form);
										}
									},
									'newsession timefield[itemId=slotFrom]' : {
										select : function(field, value) {
											var form = this.getNewSession();
											this.slotFromTimeField(form);
										},
										blur : function(field, value) {
											var form = this.getNewSession();
											this.slotFromTimeField(form);
										}
									},
									'newsession timefield[itemId=slotTo]' : {
										select : function(field, value) {
											var form = this.getNewSession();
											this.slotFromTimeField(form);
										},
										blur : function(field, value) {
											var form = this.getNewSession();
											this.slotFromTimeField(form);
										}
									},
									'coveragedetails timefield[itemId=slotFrom]' : {
										select : function(field, value) {
											var form = this.getCoverageDetails();
											this.slotFromTimeField(form);
										},
										blur : function(field, value) {
											var form = this.getCoverageDetails();
											this.slotFromTimeField(form);
										}
									},
									'coveragedetails timefield[itemId=slotTo]' : {
										select : function(field, value) {
											var form = this.getCoverageDetails();
											this.slotFromTimeField(form);
										},
										blur : function(field, value) {
											var form = this.getCoverageDetails();
											this.slotFromTimeField(form);
										}
									},
									'updatecoveragedetail timefield[itemId=slotTo]' : {
										select : function(obj, value) {
											var form = obj.up('form').getForm();
											this.updateFacutlyAndRoomOnUpdateCoverageDetail(obj, value, form);
										},
										blur : function(obj, value) {
											var form = obj.up('form').getForm();
											this.updateFacutlyAndRoomOnUpdateCoverageDetail(obj, value, form);
										}
									},
									'updatecoveragedetail timefield[itemId=slotFrom]' : {
										select : function(obj, value) {
											var form = obj.up('form').getForm();
											this.updateFacutlyAndRoomOnUpdateCoverageDetail(obj, value, form);
										},
										blur : function(obj, value) {
											var form = obj.up('form').getForm();
											this.updateFacutlyAndRoomOnUpdateCoverageDetail(obj, value, form);
										}
									}
								});
					},
					getSessionOfNewSeeion : function(obj, record) {
						var $this = this;
						var searchForm = $this.getNewSession().getForm();
						var topicId =this.getNewsession().down('customcombobox#newSessionTopic_Id');
						var courseId =this.getNewsession().down('customcombobox#courseId').getValue();
						var section = this.getNewsession().down('customcombobox#courseSection_Id').getValue();
						
						var sectionId;
						if (section != null && section != '') {
							sectionId = section;
						} 	
						var session = this.getNewsession().down('textfield#session_Id').getValue();
						//this.getNewsession().down('customcombobox#session_Id').setDisabled(false);
						Ext.Ajax.request({
							type : 'rest',
							url : SERVERURL.GET_SESSION_BY_SECTION_TOPIC_ID,
							params : {
								topicId : topicId,
								sectionId : sectionId,
								courseId : courseId
							},
							method : 'GET',
							success : function(form, action) {
								var res = Ext.JSON.decode(form.responseText);
								//searchForm.findField('session').setDisabled(false);
								searchForm.findField('session').setValue(res);
							}
						});
					},

					/**
					 * getFacutlyAndRoom use to get faculty and room both data
					 */
					getFacutlyAndRoom : function(field, value, form) {
						var $this = this;
						var searchForm = $this.getSectioncoursecvrgplan()
								.getForm();
						var fromTime = form.findField('slotFrom').getRawValue();
						var toTime = form.findField('slotTo').getRawValue();

						var slotFrom = form.findField('slotFrom').getValue();
						var slotTo = form.findField('slotTo').getValue();
						
						var courseVariantId = searchForm.findField('courseVariantId').getValue();

						var timeFrom;
						var timeTo;
						if (fromTime != "" && fromTime != null) {
							timeFrom = fromTime;
						} else {
							timeFrom = null;
						}

						if (toTime != "" && toTime != null) {
							timeTo = toTime;
						} else {
							timeTo = null;
						}

						var grid = $this.getSectioncoursecvrgplangrid();
						var records = grid.getSelectionModel().getSelection();

						var topicId;
						if (form.owner.itemId == 'coverageDetail') {
							topicId = records[0].data.topicId;
						} else {
							topicId = form.findField('courseTopic').getValue();
						}

						var section = searchForm.findField('section')
								.getValue();
						var programCoursesectionId = searchForm.findField(
								'programCoursesection').getValue();

						var sectionId;
						if (section != null && section != '') {
							sectionId = section;
						} else {
							sectionId = programCoursesectionId;
						}

						var valueDate = form.findField('sessionDate')
								.getValue();
						var date = Ext.Date
								.format(new Date(valueDate), 'Y-m-d');

						var formattedStartTime = Ext.Date.format(slotFrom,
								'H:i:s');
						var formattedEndTime = Ext.Date.format(slotTo, 'H:i:s');

						var classTeacherId = searchForm.findField('classTeacher').getValue();
						var store = $this.getStore('coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.FacultyByTopicAndSection');
						store.load({
									params : {
										courseVariantId:courseVariantId,
										startDate : date,
										startTime : formattedStartTime,
										endTime : formattedEndTime
									},
									callback : function(records, operation,
											success) {
										if (success) {
											var assignFacultyCombo = form
													.findField('assignFaculty');
											if (records.length > 0) {
												for (var i = 0; i < records.length; i++) {
													if (records[i].data.id == classTeacherId) {
														assignFacultyCombo.store
																.load({
																	params : {
																		topicId : topicId,
																		sectionId : sectionId,
																		startDate : date,
																		startTime : formattedStartTime,
																		endTime : formattedEndTime
																	},
																	callback : function(
																			records,
																			operation,
																			success) {
																		if (success) {
																			assignFacultyCombo
																					.setValue([ parseInt(classTeacherId) ]);
																		}
																	}
																});
													}
												}
											}
										}
									}
								});

						this.commonRoom(null, null, null, date, timeFrom,
								timeTo, form);
					},
					/**
					 * on render get room and faculties
					 */
					covrageDetailsRender : function() {
						var $this = this;
						var form = $this.getCoverageDetails().getForm();
						var searchForm = $this.getSectioncoursecvrgplan().getForm();

						var sectionId;
						var section = searchForm.findField('section').getValue();
						var programCoursesectionId = searchForm.findField('programCoursesection').getValue();
						var sectionType = searchForm.findField('sectionCourse').getValue();
						var periodId = searchForm.findField('period').getValue();
                        //var portalId =   $this.getCurrentLoggedPortalId()
						if (section != null && section != '') {
							sectionId = section;
						} else {
							sectionId = programCoursesectionId;
						}

						var date = form.findField('sessionDate').getValue();
						if(date !=null){
						var formattedDate = Ext.Date.format(new Date(date),'Y-m-d');
						}
						var course = searchForm.findField('course').getValue();
						var programCourse_Id = searchForm.findField('programCourse_Id').getValue();

						var componentId = searchForm.findField('componentSectionId').getValue();
                       
						var courseId;
						if (course != '' && course != null) {
							courseId = course;
						} else if (programCourse_Id != ''
								&& programCourse_Id != null) {
							courseId = programCourse_Id;
						} else {
							courseId = null;
						}

						var component;
						if (componentId != '' && componentId != null) {
							component = componentId;
						} else {
							component = null;
						}

						Ext.Ajax
								.request({
									type : 'rest',
									url : SERVERURL.GET_STUDENT_ENROLLED_IN_VARIANT,
									params : {
										courseId : courseId,
										sectionId : sectionId,
										componentId : component,
										attendanceDate :formattedDate
									},
									method : 'GET',
									success : function(form, action) {
										var res = Ext.JSON.decode(form.responseText);
										var form = $this.getCoverageDetails().getForm();
										form.findField('studentNum').setVisible(true);
										form.findField('studentNum').setValue(res.length);
									}
								});
						/**
						 * Program periods date range will show only 
						 * Dates validation- dates show b/w period start and end date.
   						 *                   disabled all preivous date.
   						 *                   (DATES_AVAILABLE_FOR_BREAKS)using rest call for disabled dates 
						 */                  
						if (sectionType == true) {
							
							Ext.Ajax.request({
								type : 'rest',
								url : SERVERURL.PERIOD_FIND_BY_ID,
								params : {
									id : periodId
								},
								method : 'GET',
								success : function(form, action) {
									var data = Ext.JSON.decode(form.responseText);
									var form = $this.getCoverageDetails().getForm();
									form.findField('sessionDate').setMinValue(new Date());/*data.programPeriodStart*/
									form.findField('sessionDate').setMaxValue(dateRender(data.programPeriodEnd));
									   
									Ext.Ajax.request({
										type : 'rest',
										url : SERVERURL.DATES_AVAILABLE_FOR_BREAKS,//GET_WORKING_DATE_PERIOD,
										params : {
											periodId : periodId
										},
										method : 'GET',
										success : function(form, action) {
											var res = Ext.JSON.decode(form.responseText);
											var form = $this.getCoverageDetails().getForm();
											form.findField('sessionDate').setDisabledDates(res);
											form.findField('sessionDate').isValid();
										}
									});
								}
							});
							
							
						}
					},
					/**
					 * commonRoom function are using for get Room for coverage
					 * detial,new session and update ditails.
					 */
					commonRoom : function(locationId, resourceTypeId,
							bookingPurposeId, eventDate, timeFrom, timeTo,
							commonForm) {
						var $this = this;
						var form = $this.getCoursecoverageplanbasicsearchfilter().getForm();
						var academyLocationId = this.getCurrentAcademyLocation();
						var resourceTypeId = form.findField('resourceTypeId').getValue();
						var locationId = form.findField('locationId').getValue();
						var roomStore = commonForm.findField('classRoom').getStore();
						roomStore.clearFilter();
						var date = Ext.Date.format(new Date(eventDate), 'Y-m-d');
						var fromTime;
						var toTime;

						if (timeFrom != null && timeFrom != '') {
							fromTime = timeFrom;
						} else {
							fromTime = null;
						}

						if (timeTo != null && timeTo != '') {
							toTime = timeTo;
						} else {
							toTime = null;
						}
						roomStore.getProxy().extraParams = {
							"locationId" : locationId,
							"resourceTypeId" : resourceTypeId,
							"bookingPurposeId" : 1,
							"eventDate" : date,
							"isCompleteDay" : false,
							"timeFrom" : fromTime,
							"timeTo" : toTime,
							"isRecurring" : false
						};
						roomStore.load();
					},
					sectionDropDown : function() {
						var $this = this;
						var form = $this.getSectioncoursecvrgplan().getForm();

						var sectionCourse = form.findField('sectionCourse')
								.getValue();
						// if(r.sectionCourse == "programBatchSection"){
						if (sectionCourse) {
							$this.getSectioncoursecvrgplangrid().getStore()
							.removeAll();
							try {
								$this.getSectioncoursecvrgplangrid().down('custompagingtoolbar').hide();
							}
							catch(e){
							}
							form.findField('course').hide();
							form.findField('course').setValue(null);

							form.findField('section').hide();
							form.findField('section').setValue(null);

							form.findField('course').allowBlank = true;
							form.findField('section').allowBlank = true;
							var academyLocationId = this
									.getCurrentAcademyLocation();
							var programCombo = this.getSectioncoursecvrgplan()
									.down('combo#program_Id');
							var programStore = programCombo.getStore();
							programStore.getProxy().extraParams = {
								academyLocationId : academyLocationId
							};
							programStore.load();
							form.findField('program').show();
							form.findField('program').reset();

							form.findField('batch').show();
							form.findField('batch').reset();
							form.findField('batch').setDisabled(true);
							form.findField('programCourse_Id').show();
							form.findField('programCourse_Id').reset();
							form.findField('programCourse_Id')
									.setDisabled(true);
							form.findField('programCoursesection').show();
							form.findField('programCoursesection').reset();
							form.findField('programCoursesection').setDisabled(
									true);
							form.findField('period').show();
							form.findField('period').reset();
							form.findField('period').setDisabled(true);
							form.findField('componentSectionId').hide();
							form.findField('componentSectionId').setValue(null);
							form.findField('componentSectionId').reset();
							form.findField('componentSectionId').allowBlank = true;

							form.findField('program').allowBlank = false;
							form.findField('batch').allowBlank = false;
							form.findField('programCourse_Id').allowBlank = false;
							form.findField('programCoursesection').allowBlank = false;
							form.findField('period').allowBlank = false;
							form.findField('componentSection_Id').allowBlank = false;
						} else {
							$this.getSectioncoursecvrgplangrid().getStore()
									.removeAll();
							try {
								$this.getSectioncoursecvrgplangrid().down('custompagingtoolbar').hide();
							   }
							   catch(e){
							   }
							var programBox = $this.getSectioncoursecvrgplan()
									.down('combo#program_Id');
							programBox.clearValue();
							form.findField('course').show();
							form.findField('course').reset();
							form.findField('section').show();
							form.findField('section').reset();
							form.findField('section').setDisabled(true);

							form.findField('program').hide();
							form.findField('program').setValue(null);
							form.findField('batch').hide();
							form.findField('batch').setValue(null);
							form.findField('programCourse_Id').hide();
							form.findField('programCourse_Id').setValue(null);
							form.findField('programCoursesection').hide();
							form.findField('programCoursesection').setValue(
									null);
							form.findField('period').hide();
							form.findField('period').setValue(null);
							form.findField('componentSection_Id').hide();
							form.findField('componentSection_Id')
									.setValue(null);

							form.findField('program').allowBlank = true;
							form.findField('batch').allowBlank = true;
							form.findField('programCourse_Id').allowBlank = true;
							form.findField('programCoursesection').allowBlank = true;
							form.findField('period').allowBlank = true;
							form.findField('componentSection_Id').allowBlank = true;

							form.findField('course').allowBlank = false;
							form.findField('section').allowBlank = false;
							form.findField('componentSectionId').allowBlank = false;
						}
					},

					/**
					 * coverageDetailsWin method used for update window
					 */

					coverageDetailsWin : function() {
						var $this = this;

						var formWindow = $this.getUpdatecoveragedetail();
						if (!formWindow) {
							Ext.widget('updatecoveragedetail');
							formWindow = $this.getUpdatecoveragedetail();
						}
						formWindow.setTitle(getProgramandcourseTranslation('EDIT_SESSION_DETAILS'));
						formWindow.show();
					},
					showCoverageDetails : function() {
						var $this = this;
						var grid = $this.getSectioncoursecvrgplangrid();
						if (grid.getSelectionModel().getCount() > 0) {

							var formWindow = $this.getCoveragedetails();
							if (!formWindow) {
								Ext.widget('coveragedetails');
								formWindow = $this.getCoveragedetails();
							}
							formWindow.show();

							var form = $this.getCoverageDetails().getForm();
							var records = grid.getSelectionModel().getSelection();
							if (records != undefined && records != ""&& records != null) {
								var topicName = records[0].data.topicName;
								var session = records[0].data.session;
								$this.covrageDetailsRender();
								form.findField('courseTopic').setValue(topicName).disable(true);
								form.findField('session').setValue(session).disable(true);
							}
						} else {
							showWarningMessage(getCommonTranslation('ALERT'),
									getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
					},
					showNewSession : function() {
						var formWindow = this.getNewsession();
						if (!formWindow) {
							Ext.widget('newsession');
							formWindow = this.getNewsession();
						}
						formWindow.show();
					},
					coveragePlanGridRender : function() {
						var form = this.getSectioncoursecvrgplan();
						var searchForm = form.getForm();
						var sectionType = form.down(
								'radiogroup#courseSectionRadio_Id').getValue().sectionCourse;

						var courseId = null;
						var componentId = null;
						var sectionId = null;
						if (sectionType == "courseSection") {
							courseId = searchForm.findField('course')
									.getValue();
							componentId = searchForm.findField(
									'componentSectionId').getValue();
							sectionId = searchForm.findField('section')
									.getValue();
						} else {
							courseId = searchForm.findField('programCourse_Id')
									.getValue();
							componentId = searchForm.findField(
									'componentSection_Id').getValue();
							sectionId = searchForm.findField(
									'programCoursesection').getValue();
						}
						var store = this
								.getStore('coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CoveragePlanGrid');
						if (componentId != null) {
							store.getProxy().extraParams = {
								courseId : courseId,
								componentId : componentId,
								sectionId : sectionId
							};
						} else {
							store.getProxy().extraParams = {
								courseId : courseId,
								sectionId : sectionId
							};
						}

						store.load();
					},
					/**
					 * save coverage details and new session
					 * 
					 */

					addCoverageDetails : function(form) {
						var $this = this;
						
						var grid = $this.getExtendedtimetablepbsgrid();
						if(grid==null){
							grid = $this.getExtendedtimetablecbsgrid();
						}
						//var records = grid.getSelectionModel().getSelection();

						var searchForm = $this.getNewSession().getForm();
								
						var values = form.getValues();
						var academyLocationId = this.getCurrentAcademyLocation();	
						var academyLocationName = this.getCurrentAcademyLocation();	

						var sessionStatus = form.findField('sessionStatus').getValue();
								
						var courseId;
						var courseName;

						var courseI = searchForm.findField('course').getValue();
						var courseN = searchForm.findField('course').getRawValue();
							
						var sectionId;
						var sectionName;
						var courseVariantId;
						var batchId;
						var periodId;
						
						var secID = searchForm.findField('courseSection').getValue();
						var secName = searchForm.findField('courseSection')
								.getRawValue();
						
						
						var sectionType=this.getCoursecoverageplanbasicsearchfilter().down('#courseSectionTypeRadio').getValue();
						
						if(sectionType.sectionType== 'PBS'){					
							batchId = searchForm.findField('courseSection').getStore().findRecord("id",secID).data.secondValue;
							periodId = searchForm.findField('courseSection').getStore().findRecord("id",secID).data.secondId;
							
						}
						
						courseVariantId = searchForm.findField('courseSection').getStore().findRecord("id",secID).data.code;						
						

						if (secID != '' && secID != null) {
							sectionId = secID;
							sectionName = secName;
						} 
						
						if (courseI != '' && courseI != null) {
							courseId = courseI;
							courseName = courseN;
						} 

						var courseVariantCombo = this.getIdValueJson(courseVariantId);
						var batchCombo = this.getIdValueJson(batchId);
						var periodCombo = this.getIdValueJson(periodId);
						var courseCombo = this.getIdValueJson(courseId,courseName);
						var sectionCombo = this.getIdValueJson(sectionId,sectionName);

						var academyLocationCombo = this
								.getIdValueJson(academyLocationId,academyLocationName);

						var classId = form.findField('classRoom').getValue();
						var classValue = form.findField('classRoom').getRawValue();

						var classCombo = this.getIdValueJson(classId,classValue);

						var coverageDetails = new Academia.model.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CoveragePlanDetails();

						coverageDetails.set("sessionDate", values.sessionDate);
						coverageDetails.set("slotFrom", values.slotFrom);
						coverageDetails.set("slotTo", values.slotTo);

						if (form.owner.itemId == 'coverageDetail') {
							var session = records[0].data.session;
							coverageDetails.set("sessionNumber", session);
						}else
						{
							var session = form.findField('session').getValue();
							coverageDetails.set("sessionNumber", session);
						}

						if (form.owner.itemId == 'coverageDetail') {
							var topicValue = records[0].data.topicName;
							var topicId = records[0].data.topicId;
							var topicCombo = this.getIdValueJson(topicId,
									topicValue);
							coverageDetails.set("courseTopic", topicCombo);
						} else {
							var courseTopics = form.findField('courseTopic').getValue();
							var allTopics = [];
							Ext.each(courseTopics,function(courseTopic){
								if(typeof courseTopic=="number"){
									allTopics.push($this.getIdValueJson(courseTopicId));
								}else if(typeof courseTopic == "object"){
									allTopics.push($this.getIdValueJson(courseTopic.data.id));
								}
							});
							coverageDetails.set("courseTopic", allTopics);
						}
					    
						
						coverageDetails.set("courseVariant", courseVariantCombo);
						coverageDetails.set("batch", batchCombo);
					    coverageDetails.set("period", periodCombo);
						
						coverageDetails.set("academyLocation",
								academyLocationCombo);
						coverageDetails.set("section", sectionCombo);
						coverageDetails.set("course", courseCombo);
						coverageDetails.set("classRoom", classCombo);

						coverageDetails.set("optionalSession",
								values.optionalSession);
						coverageDetails.set("whetherAttendanceToBeEntered",
								values.whetherAttendanceToBeEntered);
						coverageDetails.set("whetherPlannedSession",
								values.sessionPlanned);
						coverageDetails.set("sessionStatus", sessionStatus);
						coverageDetails.set("noOfParticipants",
								values.studentNum);


						//var topicsId;
						var topicsId = new Array();
						/* var topics = searchForm.findField('courseTopic').getValue();
						 if(Ext.isObject(values.courseTopic)){
						 topicsId.push(topics[i].get("id")); }
						 else{
						 topicsId.push(topics[i]);
						 }
						 
						 */
						  var topics = searchForm.findField('courseTopic').getValue();
		    				if(topics != undefined && topics.length > 0){
		    					if(!isNaN(topics[0])){
		    						if(topics[0] !=""){
		    							topicsId.push(topics[0].data.id);	
		    						}
		    					}
		    					else{
		    						for(var i in topics){
		    							topicsId.push(topics[i].data.id);
		    						}
		    					}
		    				}
						 

						if(Ext.isObject(values.assignFaculty[0]) && values.assignFaculty.length >0){
							for(i=1; i <= values.assignFaculty.length; i++){
								if (Ext.isObject(values.assignFaculty[0])
										&& i==1) {
									var facultyId = values.assignFaculty[0].data.id;
									var facultyValue = values.assignFaculty[0].data.value;
									var facultyCombo = this.getIdValueJson(facultyId);
									coverageDetails.set("facultyByFacultyId",
											facultyCombo);
									coverageDetails.set(
											"facultyByAdditionalFacultyOne", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyTwo", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyThree", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyFour", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyFive", null);
								}
								if (i==2) {
									var facultyId1 = values.assignFaculty[1].data.id;
									var facultyValue1 =values.assignFaculty[1].data.value;
									var facultyCombo1 = this.getIdValueJson(facultyId1);
									coverageDetails.set(
											"facultyByAdditionalFacultyOne",
											facultyCombo1);
									coverageDetails.set(
											"facultyByAdditionalFacultyTwo", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyThree", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyFour", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyFive", null);
								}
								if (i==3) {
									var facultyId2 = values.assignFaculty[2].data.id;
									var facultyValue2 =values.assignFaculty[2].data.value;
									var facultyCombo2 = this.getIdValueJson(facultyId2);
									coverageDetails.set(
											"facultyByAdditionalFacultyTwo",
											facultyCombo2);
									coverageDetails.set(
											"facultyByAdditionalFacultyThree", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyFour", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyFive", null);
								}
								if (i==4) {
									var facultyId3 = values.assignFaculty[3].data.id;
									var facultyValue3 =values.assignFaculty[3].data.value;
									var facultyCombo3 = this.getIdValueJson(facultyId3);
									coverageDetails.set(
											"facultyByAdditionalFacultyThree",
											facultyCombo3);
									coverageDetails.set(
											"facultyByAdditionalFacultyFour", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyFive", null);
								}
								if (i==5) {
									var facultyId4 = values.assignFaculty[4].data.id;
									var facultyValue4 =values.assignFaculty[4].data.value;
									var facultyCombo4 = this.getIdValueJson(facultyId4);
									coverageDetails.set(
											"facultyByAdditionalFacultyFour",
											facultyCombo4);
									coverageDetails.set(
											"facultyByAdditionalFacultyFive", null);
								}
								if (i==6) {
									var facultyId5 = values.assignFaculty[5].data.id;
									var facultyValue5 =values.assignFaculty[5].data.value;
									var facultyCombo5 = this.getIdValueJson(facultyId5);
									coverageDetails.set(
											"facultyByAdditionalFacultyFive",
											facultyCombo5);
								}
							}
						/*if (Ext.isObject(values.assignFaculty[0])
								&& values.assignFaculty.length == 1) {

							var facultyId = values.assignFaculty[0].data.id;
							var facultyValue = values.assignFaculty[0].data.value;
							var facultyCombo = this.getIdValueJson(facultyId);
							coverageDetails.set("facultyByFacultyId",
									facultyCombo);
							coverageDetails.set(
									"facultyByAdditionalFacultyOne", null);
							coverageDetails.set(
									"facultyByAdditionalFacultyTwo", null);

						} else {
							var facultyId = values.assignFaculty;
							var facultyCombo = this.getIdValueJson(facultyId);
							coverageDetails.set("facultyByFacultyId",
									facultyCombo);
							coverageDetails.set(
									"facultyByAdditionalFacultyOne", null);
							coverageDetails.set(
									"facultyByAdditionalFacultyTwo", null);
						}

						if (values.assignFaculty.length == 2) {

							var facultyId = values.assignFaculty[0].data.id;
							var facultyValue =values.assignFaculty[0].data.value;

							var facultyId1 = values.assignFaculty[1].data.id;
							var facultyValue1 =values.assignFaculty[1].data.value;

							var facultyCombo = this.getIdValueJson(facultyId);
							var facultyCombo1 = this.getIdValueJson(facultyId1);
							coverageDetails.set("facultyByFacultyId",
									facultyCombo);
							coverageDetails.set(
									"facultyByAdditionalFacultyOne",
									facultyCombo1);
							coverageDetails.set(
									"facultyByAdditionalFacultyTwo", null);

						} else if (values.assignFaculty.length == 3) {
							var facultyId = values.assignFaculty[0].data.id;
							var facultyValue =values.assignFaculty[0].data.value;

							var facultyId1 = values.assignFaculty[1].data.id;
							var facultyValue1 = values.assignFaculty[1].data.value;

							var facultyId2 = values.assignFaculty[2].data.id;
							var facultyValue2 =values.assignFaculty[2].data.value;

							var facultyCombo = this.getIdValueJson(facultyId);
							var facultyCombo1 = this.getIdValueJson(facultyId1);
							var facultyCombo2 = this.getIdValueJson(facultyId2);
							coverageDetails.set("facultyByFacultyId",
									facultyCombo);
							coverageDetails.set(
									"facultyByAdditionalFacultyOne",
									facultyCombo1);
							coverageDetails.set(
									"facultyByAdditionalFacultyTwo",
									facultyCombo2);
						}*/
						}
						if (form.findField('id').getSubmitValue() == null
								|| form.findField('id').getSubmitValue() == "") {
							submitUrl = SERVERURL.CREATE_COURSE_COVERAGE;
						} else {
							coverageDetails.set("id", value.id);
							submitUrl = SERVERURL.UPDATE_COURSE_COVERAGE;
						}
						coverageDetails.data.courseTopic;
						var formData = Ext.encode(coverageDetails.data);
						$this.applyWindowMask(); 
						Ext.Ajax
								.request({
									type : 'rest',
									url : submitUrl,
									jsonData : formData,
									method : 'POST',
									success : function(response, form, action) {
										 $this.hideWindowMask();
							if (response.responseText == "Not-Autorize") {
                            showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("GOOGLE_CALENDAR_NOT_AUTORIZED"))
                        } else if (response.responseText == "Connection_refused") {
                                showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("GOOGLE_CALENDAR_SERVICE_DOWN"))
                            }else if (response.responseText == 'SUCCESS' || response.responseText.indexOf('<br/>') == -1) {
											showSuccessMessage(
													getCourseTxCommonTranslation('ADD_CVG_DETAILS'),
													getCommonTranslation('SUCCESS'));
											$this
													.getStore(
															'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CoveragePlanGrid')
													.load();
										} else {
											var conflict = response.responseText
													.replace('<br/>', '<br>');
											showWarningMessage(
													getCommonTranslation('ALERT'),
													conflict);
										}
									}
								});
						if (form.owner.itemId == 'coverageDetail') {
							$this.getCoveragedetails().close();
						} else {
							$this.getNewsession().close();
						}
					},
					getIdValueJson : function(id, value, code) {
						if (id)
							return {
								id : id,
								value : value
							};
					},
					/**
					 * find By id of coverage details and new session
					 * 
					 */
					updateCoverage : function(grid) {
						var $this = this;
						if (grid.getSelectionModel().getCount() == 1 ) {
							$this.coverageDetailsWin();// Open Update form
							var records = grid.getSelectionModel().getSelection();
							if (records != undefined && records != ""&& records != null) {
								var id = records[0].data.id;
								Ext.Ajax.request({
									type : 'rest',
									url : SERVERURL.COURSE_COVERAGE_FIND_BY_ID,
									params : {
										id : id
									},
									method : 'GET',
									success : function(response) {
										var data = Ext.decode(response.responseText);
										var form = $this.getUpdatecoverageDetail().getForm();
										var coverageDetails = new Academia.model.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CoveragePlanDetails();
										form.loadRecord(coverageDetails);
										form.findField('id').setValue(data.id);
										/*var fromDate = new Date(data.slotFrom);
										var toDate = new Date(data.slotTo);
										var fromTime = Ext.Date.format(fromDate, CONSTANTS.DISPLAY_TIME_FORMAT);
										var toTime = Ext.Date.format(toDate, CONSTANTS.DISPLAY_TIME_FORMAT);*/
										form.findField('slotFrom').setValue(data.slotFrom);
										form.findField('slotTo').setValue(data.slotTo);

										form.findField('optionalSession').setValue(data.optionalSession);
										form.findField('whetherAttendanceToBeEntered').setValue(data.whetherAttendanceToBeEntered);
										form.findField('sessionPlanned').setValue(data.whetherPlannedSession);
										form.findField('session').setValue(data.sessionNumber);
										form.findField('sessionStatus').setValue('Rescheduled');
										form.findField('sessionDate').setValue(dateRender(data.sessionDate));
										form.findField('sessionDate').setMinValue(dateRender(data.sessionDate));
										form.findField('calendarEventId').setValue(data.calendarEventId);
										
										var courseId = data.course.id;
										var sectionId = data.section.id;
										var courseVariant = data.courseVariant.id;
										var courseComponentId = data.componentId;
										
										if (courseComponentId != '' && courseComponentId != null) {
											componentId = parseInt(data.componentId);
										} else {
											componentId = null;
										}
										
										var oldTopics = data.courseCoveragePlanTopics;
										
									   var oldTopicArray=[];
									   for(var i in oldTopics){
											if (oldTopics[i].code != null) {
												var topicId="";
												topicId=parseInt(oldTopics[i].code);
												oldTopicArray.push(parseInt(oldTopics[i].code));
											}
											}
										var topicStore = form.findField('courseTopic').getStore();
										topicStore.getProxy().extraParams = {
											courseId : courseId,
											componentId: componentId
										};
										topicStore.load({
											callback : function(records, operation, success) {
												if (success) {
													var topicCombo = form.findField('courseTopic');
												
													if (oldTopicArray.length > 0) {
														topicCombo.setValue(oldTopicArray);
														topicCombo.setValue(oldTopicArray);
													}
												
												}
											}
										});

										form.findField('courseId').setValue(courseId);
										form.findField('sectionId').setValue(sectionId);
										form.findField('courseVariant').setValue(courseVariant);

										$this.showTotalStudentNoUpdate(courseVariant, sectionId);

										var date = data.sessionDate;
										var timeFrom = data.slotFrom;
										var timeTo = data.slotTo;

										form.findField('roomId').setValue(data.classRoom.id);
										$this.updateFacutlyAndRoomOnUpdateCoverageDetail(null, null,form, data);

										var classRoomCombo = form.findField('classRoom');

										if (data.batch != null) {
											form.findField('batch').setVisible(true);
											form.findField('batchId').setValue(data.batch.id);
											form.findField('batch').setRawValue(data.batch.value);
										}
										if (data.period != null) {
											form.findField('period').setVisible(true);
											form.findField('periodId').setRawValue(data.period.id);
											form.findField('period').setRawValue(data.period.value);
										}
										
										
										if (data.course != null) {
											form.findField('course').setVisible(true);
											form.findField('course').setRawValue(data.course.value);
										}

										if (data.section != null) {
											form.findField('section').setVisible(true);
											form.findField('section').setRawValue(data.section.value);
										}

									}
								});
							}
						} else if (grid.getSelectionModel().getCount() > 1) {
							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ONLY_SINGLE_RECORD')); //Please select a record.
						} else{
							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
						}
					},
					/**
					 * Update Coverage details
					 * 
					 */
					updateCoverageDetails : function(form) {
						var $this = this;
						$this.applyWindowMask();
						var values = form.getValues();
						var academyLocationId = this
								.getCurrentAcademyLocation();

						var courseId = values.courseId;
						//var courseTopicId = values.courseTopic;
						var sectionId = values.sectionId;
						var session = this.getUpdatecoverageDetail().down('textfield#session_Id').getValue();
						var courseVariant = values.courseVariant;
						var batchId = values.batchId;
						var periodId = values.periodId;

						var courseVariantCombo = this
								.getIdValueJson(courseVariant);
						var courseCombo = this.getIdValueJson(courseId);
						var sectionCombo = this.getIdValueJson(sectionId);
						//var courseTopicCombo = this
							//	.getIdValueJson(courseTopicId);
						var academyLocationCombo = this
								.getIdValueJson(academyLocationId);

						var assignFaculty = form.findField('assignFaculty')
								.getValue();
						var classId = form.findField('classRoom').getValue();
						var classValue = form.findField('classRoom')
								.getRawValue();
						var classCombo = this.getIdValueJson(classId,
								classValue);

						var coverageDetails = new Academia.model.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CoveragePlanDetails();

						coverageDetails.set("sessionDate", values.sessionDate);
						coverageDetails.set("slotFrom", values.slotFrom);
						coverageDetails.set("slotTo", values.slotTo);
						coverageDetails.set("sessionNumber", session);
					//	coverageDetails.set("courseTopic", courseTopicCombo);

						if (batchId != undefined && batchId != ''
								&& batchId != null) {
							var batchCombo = this.getIdValueJson(batchId);
							coverageDetails.set("batch", batchCombo);
						} else {
							coverageDetails.set("batch", null);
						}

						if (periodId != undefined && periodId != ''
								&& periodId != null) {
							var periodCombo = this.getIdValueJson(periodId);
							coverageDetails.set("period", periodCombo);
						} else {
							coverageDetails.set("period", null);
						}
						
						coverageDetails
								.set("courseVariant", courseVariantCombo);
						coverageDetails.set("academyLocation",
								academyLocationCombo);
						coverageDetails.set("section", sectionCombo);
						coverageDetails.set("course", courseCombo);
						coverageDetails.set("classRoom", classCombo);

						coverageDetails.set("optionalSession",
								values.optionalSession);
						coverageDetails.set("whetherAttendanceToBeEntered",
								values.whetherAttendanceToBeEntered);
						coverageDetails.set("whetherPlannedSession",
								values.sessionPlanned);
						coverageDetails.set("sessionStatus", 'Rescheduled');
						coverageDetails.set("noOfParticipants",
								values.studentNum);
						coverageDetails.set("calendarEventId",values.calendarEventId);
						
						var topicsId = new Array();
											 

						var assignFacultyData;
						var assignFacultyArrayData = [];

						if (assignFaculty != "" && assignFaculty != null) {
							for ( var i in assignFaculty) {
								if (Ext.isObject(assignFaculty[0])) {
									assignFacultyData = assignFaculty[i]
											.get("id");
									assignFacultyArrayData
											.push(assignFacultyData);
								} else {
									assignFacultyData = assignFaculty[i];
									assignFacultyArrayData
											.push(assignFacultyData);
								}
							}
						}
						
					//	var courseTopics = form.findField('courseTopic').getValue();
						//var allTopics = [];
												
						//var ccpIds = values.id;
						//var courseCovergaPlanIds = ccpIds.split(',');
						
					var courseTopics = form.findField('courseTopic').getValue();
						var allTopics = [];
						var courseTopicData;
						//var assignFacultyArrayData = [];
						/*if(courseTopics != "" && courseTopics != null){
						for(var rec in courseTopics) {
							
							allTopics.push($this.getIdValueJson(courseTopics[rec].data.id));
							}
								
						}*/
						
						
						
						if (courseTopics != "" && courseTopics != null) {
							for ( var i in courseTopics) {
								if (Ext.isObject(courseTopics[0])) {
									courseTopicData = courseTopics[i]
											.get("id");
									allTopics
											.push($this.getIdValueJson(courseTopicData));
								} else {
									courseTopicData = courseTopics[i];
									allTopics
											.push($this.getIdValueJson(courseTopicData));
								}
							}
						}
						
				
						coverageDetails.set("courseTopic", allTopics);

						if (assignFacultyArrayData.length > 0) {
							for(i=1; i <= assignFacultyArrayData.length; i++){
								if (i==1) {
									var facultyId = assignFacultyArrayData[0];
									var facultyCombo = this.getIdValueJson(facultyId);
									coverageDetails.set("facultyByFacultyId",
											facultyCombo);
									coverageDetails.set(
											"facultyByAdditionalFacultyOne", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyTwo", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyThree", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyFour", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyFive", null);
								}
								if (i==2) {
									var facultyId1 = assignFacultyArrayData[1];
									var facultyCombo1 = this.getIdValueJson(facultyId1);
									coverageDetails.set(
											"facultyByAdditionalFacultyOne",
											facultyCombo1);
									coverageDetails.set(
											"facultyByAdditionalFacultyTwo", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyThree", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyFour", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyFive", null);
								}
								if (i==3) {
									var facultyId2 = assignFacultyArrayData[2];
									var facultyCombo2 = this.getIdValueJson(facultyId2);
									coverageDetails.set(
											"facultyByAdditionalFacultyTwo",
											facultyCombo2);
									coverageDetails.set(
											"facultyByAdditionalFacultyThree", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyFour", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyFive", null);
								}
								if (i==4) {
									var facultyId3 = assignFacultyArrayData[3];
									var facultyCombo3 = this.getIdValueJson(facultyId3);
									coverageDetails.set(
											"facultyByAdditionalFacultyThree",
											facultyCombo3);
									coverageDetails.set(
											"facultyByAdditionalFacultyFour", null);
									coverageDetails.set(
											"facultyByAdditionalFacultyFive", null);
								}
								if (i==5) {
									var facultyId4 = assignFacultyArrayData[4];
									var facultyCombo4 = this.getIdValueJson(facultyId4);
									coverageDetails.set(
											"facultyByAdditionalFacultyFour",
											facultyCombo4);
									coverageDetails.set(
											"facultyByAdditionalFacultyFive", null);
								}
								if (i==6) {
									var facultyId5 = assignFacultyArrayData[5];
									var facultyCombo5 = this.getIdValueJson(facultyId5);
									coverageDetails.set(
											"facultyByAdditionalFacultyFive",
											facultyCombo5);
								}
							}
							/*if (assignFacultyArrayData.length == 1) {
								var facultyId = assignFacultyArrayData[0];
								var facultyCombo = this
										.getIdValueJson(facultyId);
								coverageDetails.set("facultyByFacultyId",
										facultyCombo);
								coverageDetails.set(
										"facultyByAdditionalFacultyOne", null);
								coverageDetails.set(
										"facultyByAdditionalFacultyTwo", null);
							}
							if (assignFacultyArrayData.length == 2) {
								var facultyId = assignFacultyArrayData[0];
								var facultyId1 = assignFacultyArrayData[1];

								var facultyCombo = this
										.getIdValueJson(facultyId);
								var facultyCombo1 = this
										.getIdValueJson(facultyId1);
								coverageDetails.set("facultyByFacultyId",
										facultyCombo);
								coverageDetails.set(
										"facultyByAdditionalFacultyOne",
										facultyCombo1);
								coverageDetails.set(
										"facultyByAdditionalFacultyTwo", null);

							}
							if (assignFacultyArrayData.length == 3) {
								var facultyId = assignFacultyArrayData[0];
								var facultyId1 = assignFacultyArrayData[1];
								var facultyId2 = assignFacultyArrayData[2];

								var facultyCombo = this
										.getIdValueJson(facultyId);
								var facultyCombo1 = this
										.getIdValueJson(facultyId1);
								var facultyCombo2 = this
										.getIdValueJson(facultyId2);
								coverageDetails.set("facultyByFacultyId",
										facultyCombo);
								coverageDetails.set(
										"facultyByAdditionalFacultyOne",
										facultyCombo1);
								coverageDetails.set(
										"facultyByAdditionalFacultyTwo",
										facultyCombo2);
							}*/
						}
						//delete coverageDetails.data.courseTopic;
						if (values.id > 0 || values.id != ""
								|| values.id != null) {
							coverageDetails.set("id", values.id);
							submitUrl = SERVERURL.UPDATE_COURSE_COVERAGE;

							var formData = Ext.encode(coverageDetails.data);
							//$this.applyWindowMask(); 
							Ext.Ajax
									.request({
										type : 'rest',
										url : submitUrl,
										jsonData : formData,
										method : 'POST',
										success : function(response, form1,
												action) {
											$this.hideWindowMask();
											if (response.responseText == 'SUCCESS') {
												showSuccessMessage(getCourseTxCommonTranslation('ADD_CVG_DETAILS'),getCommonTranslation('SUCCESS'));
												$this.getUpdatecoveragedetail().close();
												$this.getExtendedtimetablecbsgrid().getStore().reload();
												$this.getExtendedtimetablepbsgrid().getStore().reload();
												$this.getExtendedtimetablecbsgrid().getSelectionModel().deselectAll(true);
												$this.getExtendedtimetablepbsgrid().getSelectionModel().deselectAll(true);
											}else if(response.responseText=='Not-Autorize'){
												showWarningMessage(
														getCommonTranslation('ALERT'),
														getCommonTranslation('GOOGLE_CALENDAR_NOT_AUTORIZED'));
											}else if(response.responseText=='Connection_refused'){
												showWarningMessage(
														getCommonTranslation('ALERT'),
														getCommonTranslation('GOOGLE_CALENDAR_SERVICE_DOWN'));
											}else {
												var conflict = response.responseText
														.replace('</br>',
																'<br>');
												showWarningMessage(
														getCommonTranslation('ALERT'),
														conflict);
											}
										}
									});
						}
					},
					/**
					 * loadResourseType function are used to get resourse Type
					 * id and get location id from currend logged in
					 * academyLocationId
					 * 
					 */
					loadResourseType : function() {
						var form = this
								.getCoursecoverageplanbasicsearchfilter()
								.getForm();

						var academyLocationId = this
								.getCurrentAcademyLocation();
						Ext.Ajax.request({
							type : 'rest',
							url : SERVERURL.FIND_RESOURCE_TYPE_ID,
							method : 'GET',
							success : function(form1, action) {
								var res = Ext.JSON.decode(form1.responseText);
								form.findField('resourceTypeId').setValue(res);
							}
						});

						var submitUrl = SERVERURL.GET_LOCATION_BY_ACADEMY_LOCATION
								+ '?id=' + academyLocationId;
						Ext.Ajax.request({
							type : 'rest',
							url : SERVERURL.GET_LOCATION_BY_ACADEMY_LOCATION
									+ '?id=' + academyLocationId,
							method : 'GET',
							success : function(form1, action) {
								var res = Ext.JSON.decode(form1.responseText);
								form.findField('locationId').setValue(res);
							}
						});
					},
					/**
					 * checkAvailability function are used for check room
					 * capacity and number of student.
					 * 
					 */
					checkAvailability : function(obj, record) {
						var capacity = record[0].data.capacity;
						var form = obj.up('form').getForm();
						var studentNum = form.findField('studentNum')
								.getValue();
						var availabilityStatus = record[0].data.availabilityStatus;
						if (availabilityStatus == 'PARTLY_AVAILABLE') {
							if (capacity != undefined && capacity != null) {
								if (capacity < studentNum) {
									form.findField('classRoom').clearValue();
									showWarningMessage(getCommonTranslation('ALERT'),
											getCourseTxCommonTranslation('CAPACITY_MSG'));// 'No. of
																	// students
																	// are more
																	// than the
																	// classroom
																	// capacity');
								}
							}
						}
					},
					showTotalStudentNo : function(form) {
						var $this = this;
						var commonForm = form;
						var searchForm = $this.getNewsession();
						var date = commonForm.findField('sessionDate').getValue();
						var formattedDate = Ext.Date.format(new Date(date),'Y-m-d');
						var form=this.getNewsession();
						var sectionCourse = this.getCoursecoverageplanbasicsearchfilter().down('radiogroup#courseSectionTypeRadio').getValue();
						var courseId = this.getNewsession().down('customcombobox#courseId').getValue();
						var sectionId =this.getNewsession().down('customcombobox#courseSection_Id').getValue();
						var newform = this.getNewSession().getForm();
						var portalId =   $this.getCurrentLoggedPortalId();
						newform.findField('sectionType').setValue(sectionCourse);
						if(!isNullOrEmpty(sectionId)) {
							Ext.Ajax.request({
								type : 'rest',
								url : SERVERURL.GET_STUDENT_ENROLLED_IN_VARIANT,
								params : {
									courseId : courseId,
									sectionId : sectionId,
									attendanceDate : formattedDate,
									portalId : portalId
								},
								method : 'GET',
								success : function(form, action) {
									var res = Ext.JSON.decode(form.responseText);
									commonForm.findField('studentNum').setVisible(
											true);
									commonForm.findField('studentNum').setValue(
											res.length);
								}
							});
						}
					},

					/**
					 * showTotalStudentNoUpdate method used for show number of
					 * student at update time
					 * 
					 */
					showTotalStudentNoUpdate : function(courseVariantId, sectionId) {
						var updateForm = this.getUpdatecoverageDetail()
								.getForm();
						var date = updateForm.findField('sessionDate')
								.getValue();
						var formattedDate = Ext.Date.format(new Date(date),
								'Y-m-d');

						Ext.Ajax.request({
							type : 'rest',
							url : SERVERURL.GET_STUDENT_ENROLLED_COUNT,
							params : {
								sectionId : sectionId,
								attendanceDate : formattedDate,
								courseVariantId : courseVariantId
							},
							method : 'GET',
							success : function(form, action) {
								var res = Ext.JSON.decode(form.responseText);
								updateForm.findField('studentNum').setVisible(
										true);
								updateForm.findField('studentNum').setValue(
										res);
							}
						});
					},
					/**
					 * newSessionWindow function are using for new session
					 * window not able to open without select course and section
					 */

					newSessionWindow : function() {
						//var form = this.getCoursecoverageplanbasicsearchfilter().getForm();
						 var form=this.getCoursecoverageplanbasicsearchfilter();
        				 var sectionCourse = this.getCoursecoverageplanbasicsearchfilter().down('radiogroup#courseSectionTypeRadio').getValue();
        				 var course = this.getCoursecoverageplanbasicsearchfilter().down('customcombobox#courseId').getValue();
        				 
        	        	 var section =this.getCoursecoverageplanbasicsearchfilter().down('customcombobox#courseSection_Id').getValue();
        	        	 var programCourse = this.getCoursecoverageplanbasicsearchfilter().down('customcombobox#courseId_1').getValue();
        	        	 var programCoursesection = this.getCoursecoverageplanbasicsearchfilter().down('customcombobox#courseSection_Id_1').getValue();
        	        	     	        	
        	        	 
						/*var course = form.findField('course').getValue();
						var section = form.findField('section').getValue();
						var sectionCourse = form.findField('sectionType')
								.getValue();
						var programCourse = form.findField('programCourse_Id')
								.getValue();
						var programCoursesection = form.findField(
								'programCoursesection').getValue();
						*/var error = null;

						if (!sectionCourse) {
							this.showNewSession();
						} else {
						
								this.showNewSession();
							}
						
					},

					/**
					 * 
					 * slotFromTimeField() are using for get fauclty on
					 * selection of from time and to time for both
					 * coverageDetails and newSession form
					 * 
					 */
					slotFromTimeField : function(form) {
						var $this = this;
						var coverageDetailForm = form.getForm();
						var searchForm = $this.getNewSession().getForm();
						
						
						var sessionDate = coverageDetailForm.findField('sessionDate').getValue();
								
						var date = coverageDetailForm.findField('sessionDate').getValue();
						var fromTime = coverageDetailForm.findField('slotFrom').getRawValue();
						var toTime = coverageDetailForm.findField('slotTo').getRawValue();
						var slotFrom = coverageDetailForm.findField('slotFrom').getValue();
						var slotTo = coverageDetailForm.findField('slotTo').getValue();
						var sectionId = coverageDetailForm.findField('courseSection').getValue();
						var courseVariantId = searchForm.findField('courseId');

						if (slotFrom != null && slotTo != null) {
							form.down("#classRommId").setDisabled(false);
							form.down("#assignFacultyId").setDisabled(false);
						} else {
							form.down("#classRommId").setDisabled(true);
							form.down("#assignFacultyId").setDisabled(true);
						}

						var timeFrom;
						var timeTo;

						if (fromTime != "" && fromTime != null) {
							timeFrom = fromTime;
						} else {
							timeFrom = null;
						}

						if (toTime != "" && toTime != null) {
							timeTo = toTime;
						} else {
							timeTo = null;
						}

						var formattedStartTime = Ext.Date.format(slotFrom,
								'H:i:s');
						var formattedEndTime = Ext.Date.format(slotTo, 'H:i:s');

						var topicId;
						if (coverageDetailForm.owner.itemId == 'coverageDetail') {
							var grid = $this.getSectioncoursecvrgplangrid();
							var records = grid.getSelectionModel().getSelection();
									
							topicId = records[0].data.topicId;
						} else {
							topicId = coverageDetailForm.findField('courseTopic').getValue();
									
						}

						var section = searchForm.findField('courseSection_Id');
								
						var sectionId;
						if (section != null && section != '') {
							sectionId = section;
						} /*else {
							sectionId = programCoursesectionId;
						}*/
						var classTeacherId = searchForm.findField(
								'assignFacultyId');

						var formattedDate = Ext.Date.format(new Date(
								sessionDate), 'Y-m-d');
						var store = $this.getStore('coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.FacultyByTopicAndSection');
						
						store.getProxy().extraParams = {
							courseVariantId:courseVariantId,
							startDate : formattedDate,
							startTime : formattedStartTime,
							endTime : formattedEndTime,
							sectionId:sectionId
						}
						store.load({
							callback : function(records, operation,success) {
								if (success) {
									var assignFacultyCombo = form.getForm().findField('assignFaculty');
									if (records.length > 0) {
										for (var i = 0; i < records.length; i++) {
											if (records[i].data.id == classTeacherId) {
												assignFacultyCombo.setValue(parseInt(classTeacherId));
											}
										}
									}
								}
							}
						});
						$this.commonRoom(null, null, null,date, timeFrom, timeTo,coverageDetailForm);

					},
					disableMoreActionPivileges : function(gridReference,
							permissionsMap) {

						var associatedAcadLocationIds = new Array();
						associatedAcadLocationIds.push(this
								.getCurrentAcademyLocation());
						var permissionList = Academia.utilities.accessControl.AccessControlManager
								.checkFeaturePrivelages(
										associatedAcadLocationIds,
										permissionsMap);

						buttonsToolBar = gridReference.query('toolbar')[0];

						var addCoverageDetailsButton = buttonsToolBar
								.query('#addCoverageDetails')[0];
						addCoverageDetailsButton.setVisible(false);

						var addNewSessionButton = buttonsToolBar
								.query('#addNewSession')[0];
						addNewSessionButton.setVisible(false);

						/*
						 * Ext.each(splitbuttons.menu.items.items,
						 * function(menuItems) { menuItems.setVisible(false);
						 * });
						 */

						Ext.each(permissionList, function(privilege) {
							/*
							 * if (privilege === 'MOREACTIONS') { var button =
							 * buttonsToolBar.query('#spBtnMoreActions')[0];
							 * if(!isNullOrEmpty(button)){
							 * button.setVisible(true); } }
							 */
							if (privilege === 'ADDCOVERAGEDETAILS') {
								var button = buttonsToolBar
										.query('#addCoverageDetails')[0];
								if (!isNullOrEmpty(button)) {
									addCoverageDetailsButton.setVisible(true);
								}
							}
							if (privilege === 'ADDNEWSESSION') {
								var button = buttonsToolBar
										.query('#addNewSession')[0];
								if (!isNullOrEmpty(button)) {
									addNewSessionButton.setVisible(true);
								}
							}
						});
					},
					/**
					 * setRoomNteacherBySection checks faculty and room already
					 * exists or not if yes then prepopulated room and faculty
					 * 
					 */
					setRoomNteacherBySection : function(id) {
						var form = this.getSectioncoursecvrgplan();
						var searchForm = form.getForm();

						Ext.Ajax.request({
							type : 'rest',
							url : SERVERURL.SECTION_FIND_BY_ID,
							params : {
								id : id
							},
							method : 'GET',
							success : function(form, action) {
								var res = Ext.JSON.decode(form.responseText);
								if (res.homeRoom != null) {
									searchForm.findField('roomId').setValue(
											res.homeRoom.id);
								}
								if (res.classTeacher != null) {
									searchForm.findField('classTeacher')
											.setValue(res.classTeacher.id);
								}
							}
						});
					},
					updateFacutlyAndRoomOnUpdateCoverageDetail : function(field,
							value, form, record) {
						var $this = this;
						var fromTime = form.findField('slotFrom').getRawValue();
						var toTime = form.findField('slotTo').getRawValue();
						var sessionDate = form.findField('sessionDate')
								.getValue();
						var slotFrom = form.findField('slotFrom').getValue();
						var slotTo = form.findField('slotTo').getValue();
						var courseVariantId = form.findField('courseVariant').getValue();
						var timeFrom;
						var timeTo;
						if (fromTime != "" && fromTime != null) {
							timeFrom = fromTime;
						} else {
							timeFrom = null;
						}
						if (toTime != "" && toTime != null) {
							timeTo = toTime;
						} else {
							timeTo = null;
						}
						var topicId = form.findField('courseTopicId')
								.getValue();
						var sectionId = form.findField('sectionId').getValue();
						var date = Ext.Date.format(new Date(sessionDate),'Y-m-d');
						var formattedStartTime = Ext.Date.format(slotFrom,'H:i:s');
						var formattedEndTime = Ext.Date.format(slotTo, 'H:i:s');
						var id = form.findField('id').getValue();
						var assignFacultyCombo = form.findField('assignFaculty');

						var store = assignFacultyCombo.getStore();
						store.getProxy().extraParams = {
							startDate : date,
							startTime : formattedStartTime,
							endTime : formattedEndTime,
							coveragePlanId : id,
							courseVariantId:courseVariantId
						};
						store.load({
							callback: function(records, operation, success) {
								if (success) {
									var facultyArray = [];

									if(!isNullOrEmpty(record)) {
										if (record.facultyByFacultyId != null) {
											facultyArray.push(record.facultyByFacultyId.id);
										}
										if (record.facultyByAdditionalFacultyOne != null) {
											facultyArray.push(record.facultyByAdditionalFacultyOne.id);
										}
										if (record.facultyByAdditionalFacultyTwo != null) {
											facultyArray.push(record.facultyByAdditionalFacultyTwo.id);
										}
										if (record.facultyByAdditionalFacultyThree != null) {
											facultyArray.push(record.facultyByAdditionalFacultyThree.id);
										}
										if (record.facultyByAdditionalFacultyFour != null) {
											facultyArray.push(record.facultyByAdditionalFacultyFour.id);
										}
										if (record.facultyByAdditionalFacultyFive!= null) {
											facultyArray.push(record.facultyByAdditionalFacultyFive.id);
										}
									}
									if (facultyArray.length > 0) {
											assignFacultyCombo.setValue(facultyArray);
											assignFacultyCombo.setValue(facultyArray);
									}
								}
							}
						});
						this.updateCommonRoom(null, null, null, date, timeFrom,
								timeTo, form);
					},
					updateCommonRoom : function(locationId, resourceTypeId,bookingPurposeId, eventDate, timeFrom, timeTo,commonForm) {
						var $this = this;
						var form = $this.getCoursecoverageplanbasicsearchfilter().getForm();
						var resourceTypeId = form.findField('resourceTypeId').getValue();
						var locationId = form.findField('locationId').getValue();
						var academyLocationId = this.getCurrentAcademyLocation();
						var roomStore = commonForm.findField('classRoom').getStore();
						roomStore.clearFilter();

						var date = Ext.Date.format(new Date(eventDate), 'Y-m-d');
						var fromTime;
						var toTime;

						if (timeFrom != null && timeFrom != '') {
							fromTime = timeFrom;
						} else {
							fromTime = null;
						}

						if (timeTo != null && timeTo != '') {
							toTime = timeTo;
						} else {
							toTime = null;
						}

						var $this = this;
						var roomId = null;
						if (commonForm != undefined
								&& commonForm.owner.itemId == 'updateCoverageDetails') {
							var rId = commonForm.findField('roomId').getValue();
							roomId = rId;
						}

						if (commonForm != undefined
								&& ((commonForm.owner.itemId == 'newSession') || (commonForm.owner.itemId == 'coverageDetail'))) {
							var searchForm = this.getSectioncoursecvrgplan()
									.getForm();
							roomId = searchForm.findField('roomId')
									.getValue();
						}
						roomStore.getProxy().extraParams = {
							"locationId" : locationId,
							"resourceTypeId" : resourceTypeId,
							"bookingPurposeId" : 1,
							"eventDate" : date,
							"isCompleteDay" : false,
							"timeFrom" : fromTime,
							"timeTo" : toTime,
							"isRecurring" : false,
							"node" : "",
							"resourceId":roomId
						};
						roomStore.load({
							   callback: function(records, operation, success) {
								   if (success) {
									   commonForm.findField('classRoom').setValue(parseInt(roomId));
								   }
							   }
						   });
					},
				});
