/*
 *  @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.controller.coursetransaction.studymaterialdistributionnew.StudyMaterialDistributionNewController', {
	extend : 'Academia.controller.base.BaseController',
	models : [],

	stores : ['coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch','enquiry.AcademicBatchStore',
	          'coursetransaction.studymaterialdistributionnew.StudentSmdStr','common.ProgramByAcademyLocationStore',
	          'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','attendance.SectionAndFacultyByPeriodID',
	          'coursetransaction.studymaterialdistributionnew.CourseSmdStr','attendance.StudentCourses',
	          'coursetransaction.studymaterialdistributionnew.DistributionListStr','coursetransaction.studymaterialdistributionnew.ServiceProviderSmdStr',
	          'course.readingmaterial.ReadingMaterialConditionStore','coursetransaction.studymaterialdistributionnew.PacketNoGridStr',
	          'coursetransaction.studymaterialdistributionnew.UpdateStatusUploadDocSmdStr','course.readingmaterial.ReadingMaterialRetDamStore',
	          'examinationcenters.evaluation.evaluationPlanHeirarchy.createGroup.StudentListForAcademic',
	          'coursetransaction.sectioncoursecoverageplan.mastertimetable.VariantBySection',
	          'common.AcademyLocationNameSeparated','common.AccesibleAcademyLocationNameSeparated'
	          ],


	          views : ['coursetransaction.studymaterialdistributionnew.CreateSmdStructure',
	                   'coursetransaction.studymaterialdistributionnew.StudentSmdStructure','coursetransaction.studymaterialdistributionnew.StudentSmdSearch',
	                   'coursetransaction.studymaterialdistributionnew.StudentSmdGrid','coursetransaction.studymaterialdistributionnew.CourseSmdStructure',
	                   'coursetransaction.studymaterialdistributionnew.CourseSmdSearch','coursetransaction.studymaterialdistributionnew.CourseSmdGrid',
	                   'coursetransaction.studymaterialdistributionnew.StudyMaterialDistributionNewStructure',
	                   'coursetransaction.studymaterialdistributionnew.StudyMaterialdistSearch',
	                   'coursetransaction.studymaterialdistributionnew.UpdateStatusSMD','coursetransaction.studymaterialdistributionnew.StudyMatrialDownlodDocGrid',
	                   'coursetransaction.studymaterialdistributionnew.SentStudentSMD','coursetransaction.studymaterialdistributionnew.PacketNoSMD',
	                   'coursetransaction.studymaterialdistributionnew.PacketNoSMDGrid','coursetransaction.studymaterialdistributionnew.StudyMaterialListingView'

	                   ],	           
	                   config: {
	                	   STUDY_MATERIAL_DISTRIBUTION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDY_MATERIAL_DISTRIBUTION_L_PRIVILEGES'),
	                	   STUDY_MATERIAL_DISTRIBUTION_LIST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDY_MATERIAL_DISTRIBUTION_LIST_PRIVILEGES')

	                   },       
	                   refs : [{
	                	   ref:'studentsmdstructure',
	                	   selector:'studentsmdstructure'
	                   },{
	                	   ref:'createsmdstructure',
	                	   selector:'createsmdstructure'
	                   },{
	                	   ref:'studentsmdsearch',
	                	   selector:'studentsmdsearch'
	                   },{
	                	   ref:'studentsmdgrid',
	                	   selector:'studentsmdgrid'
	                   },{
	                	   ref:'coursesmdsearch',
	                	   selector:'coursesmdsearch'
	                   },{
	                	   ref:'coursesmdgrid',
	                	   selector:'coursesmdgrid'
	                   },{
	                	   ref:'studymaterialdistsearch',
	                	   selector:'studymaterialdistsearch'
	                   },{
	                	   ref: 'searchresultgrid',
	                	   selector: 'searchresultgrid[itemId=studyMaterialSearchGridId]'
	                   },{
	                	   ref : 'contentpanel',
	                	   selector : 'contentpanel' 
	                   },{
	                	   ref : 'coursesmdstructure',
	                	   selector : 'coursesmdstructure' 
	                   },{
	                	   ref : 'updatestatussmd',
	                	   selector : 'updatestatussmd' 
	                   },{
	                	   ref : 'updateStatussmd',
	                	   selector : 'updatestatussmd form' 
	                   },{
	                	   ref : 'sentstudentsmd',
	                	   selector : 'sentstudentsmd' 
	                   },{
	                	   ref : 'sentStudentsmd',
	                	   selector : 'sentstudentsmd form' 
	                   },{
	                	   ref : 'packetNosmd',
	                	   selector : 'packetnosmd form' 
	                   },{
	                	   ref : 'packetnosmd',
	                	   selector : 'packetnosmd' 
	                   },{
	                	   ref : 'packetnosmdgrid',
	                	   selector : 'packetnosmdgrid' 
	                   },{
    						ref : 'studymaterialdistributionnewstructure',
					  	    selector : 'studymaterialdistributionnewstructure' 
	                   },{
	                	   ref : 'simpledocumentform',
	                	   selector : 'simpledocumentform'
	                   },{
	                	   ref : 'studymatrialdownloddocgrid',
	                	   selector : 'studymatrialdownloddocgrid'
	                   }],


	init : function() {
		this.control({
			'studymaterialdistributionnewstructure':{
				 afterrender : function(structure){
					 var grid = structure.down('#studyMaterialSearchGridId');
	   				 this.getCBGridHeaderFreeze(grid,structure);
				 } 
			},
			'advancedsearchquerybuilder[itemId=advancedsearchquerybuilderSMD] searchresultgrid[itemId=userAdvSearchResultGrid]': {
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

					var searchResultGrid = this.getSearchresultgrid();
					var columnName=grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					if(columnName=='PACKET_STATUS'){
						if (e.target.tagName == 'A') {
							if(record.data.PACKET_STATUS == 'SENT' || record.data.PACKET_STATUS == 'Sent'){
								this.openSentWind(grid, rowIndex, record);
							}
						}
					}
					if(columnName=='PACKET_NO'){
						if (e.target.tagName == 'A') {
							this.openPacketWind(grid, rowIndex, record);
						}
					}
					if(columnName=='READING_MATERIAL_SENT'){
						if (e.target.tagName == 'A') {
							this.openReadingMaterialWin(grid, rowIndex, record);
						}
					}
					if(columnName=='ADMISSION_CODE'){
						if (e.target.tagName == 'A') {
							var userId = record.get('STUDENT_ID');
							if(!isNullOrEmpty(userId)) {
								var tabTitle = record.get('ADMISSION_CODE');
								var personId = record.get('PERSON_ID');
								var programBatchSeatTypeConfigId = record.get('progamBatchSeatConfigId');
								Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
								var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
								personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, null, programBatchSeatTypeConfigId);
							}
						}
					}
				}
			},
			
			'searchresultgrid[itemId=studyMaterialSearchGridId]':{
				render : function(grid){
					this.gridRenderFunction(grid);
					this.genericCBGridAccessControlValidation(grid, this.getSTUDY_MATERIAL_DISTRIBUTION_PERMISSIONS());
                    this.disableMoreActionPivileges(grid, this.getSTUDY_MATERIAL_DISTRIBUTION_PERMISSIONS());
				},
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

					var searchResultGrid = this.getSearchresultgrid();
					var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
					
					if(isNullOrEmpty(record.data.ID)){
						 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SENT_READING_MATERIAL_FIRST'));
						 searchResultGrid.getSelectionModel().deselect(record);
					}				
					
					if(columnName=='PACKET_STATUS'){
						if (e.target.tagName == 'A') {
							if(record.data.PACKET_STATUS == 'SENT' || record.data.PACKET_STATUS == 'Sent'){
								this.openSentWind(grid, rowIndex, record);
							}
						}
					}
					if(columnName=='PACKET_NO'){
						if (e.target.tagName == 'A') {
							this.openPacketWind(grid, rowIndex, record);
						}
					}
					if(columnName=='READING_MATERIAL_SENT'){
						if (e.target.tagName == 'A') {
							this.openReadingMaterialWin(grid, rowIndex, record);
						}
					}
					if(columnName=='ADMISSION_CODE'){
						if (e.target.tagName == 'A') {
							var userId = record.get('STUDENT_ID');
							if(!isNullOrEmpty(userId)) {
								var tabTitle = record.get('ADMISSION_CODE');
								var personId = record.get('PERSON_ID');
								var programBatchSeatTypeConfigId = record.get('progamBatchSeatConfigId');
								Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
								var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
								personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, null, programBatchSeatTypeConfigId);
							}
						}
					}
					  if (columnName == "Document") {
						if (e.target.tagName == 'A') {
							var documentPath = record.get("Document");
							if (!isNullOrEmpty(documentPath)) {
								/* var reportParams =new Object();
			                	   reportParams.filePath=documentPath;
								var code ="STUDENT_WISE_DISPATCH_FORM";
								var exportUrl = SERVERURL.PATH_DOWNLOAD_DISPATCH_FORM;
								   $this.exportJRXMLReport(code,reportParams,documentPath,'.pdf',exportUrl);*/

								var submitUrl= SERVERURL.PATH_DOWNLOAD_DISPATCH_FORM;
								var csvForm = Ext.create('Ext.form.Panel'); 
								csvForm.getForm().submit({
									url : submitUrl+"?filePath="+documentPath,
									method : 'POST',
									target: '_blank',
									params :{
										access_token : Ext.Ajax.defaultHeaders.access_token
									},
									headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
									standardSubmit :true
								});
							}
						}
					}
				}

			},
			'coursesmdgrid combo[itemId=disributionId]':{
				select:function(){
					this.loadCoourseGrid();
//					var form = this.getCoursesmdstructure();
//					form.down('#saveBtn').setDisabled(false);
					this.getCoursesmdgrid().down('#printCourseDispatchForm').setDisabled(false);
				}
			},
			'coursesmdgrid button[itemId=printCourseDispatchForm]':{
				   click:function(){ 
					   var $this = this;
						 var grid = this.getCoursesmdgrid();
						 if (grid.getSelectionModel().getCount() > 0) {						
								 $this.genrateCourseWiseDispatchForm();						
						 }else{
							 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						 }
				   }
			},'coursesmdgrid':{
				cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					var $this = this;
					var documentGrid = $this.getCoursesmdgrid();
					var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

					if (columnName == "documentPath") {
						if (e.target.tagName == 'A') {
							var documentPath = record.get("documentPath");
							if (!isNullOrEmpty(documentPath)) {
								/* var reportParams =new Object();
			                	   reportParams.filePath=documentPath;
								var code ="STUDENT_WISE_DISPATCH_FORM";
								var exportUrl = SERVERURL.PATH_DOWNLOAD_DISPATCH_FORM;
								   $this.exportJRXMLReport(code,reportParams,documentPath,'.pdf',exportUrl);*/

								var submitUrl= SERVERURL.PATH_DOWNLOAD_DISPATCH_FORM;
								var csvForm = Ext.create('Ext.form.Panel'); 
								csvForm.getForm().submit({
									url : submitUrl+"?filePath="+documentPath,
									method : 'POST',
									target: '_blank',
									params :{
										access_token : Ext.Ajax.defaultHeaders.access_token
									},
									headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
									standardSubmit :true
								});
							}
						}
					}
				},
				select:function(obj, record,rowIndex, e){
					var studentGrid=this.getCoursesmdgrid();

					/**
					 * this condition is for student's can't selected with students whose marksheet already created.   
					 */
					/*if(obj.selected.items.length>1){
						var newLength=obj.selected.items.length-2;
						if((!obj.selected.items[newLength].data.documentPath && record.data.documentPath) ||
								(!record.data.documentPath && obj.selected.items[newLength].data.documentPath)){
							obj.deselect(record);
							showWarningMessage(getCommonTranslation('ALERT'),getCourseTxCommonTranslation('STUDENT_MARKSHEET_WITHOUT_MARKSHEET_CANNOT_BE_SELECTED_TOGETHER'));
						}
					}*/	        				 

					if (studentGrid.getSelectionModel().getCount() > 0) {
						var records = studentGrid.getSelectionModel().getSelection();
						//this.enableDisablePublishBtn(studentGrid,records);
						this.enableDisableDownloadAllBtn(studentGrid,records);
					} else {
						var buttonsToolBar = studentGrid.query('toolbar')[0];
						/*var publishButton = buttonsToolBar.query('#btnPublishMarksheet')[0];
						publishButton.disable();*/
						var downloadAllButton = buttonsToolBar.query('#btnDownloadDispatchForms')[0];
						downloadAllButton.disable();
					}
				},
				deselect:function(obj, record, rowIndex, e){
					var studentGrid=this.getCoursesmdgrid();
					if (studentGrid.getSelectionModel().getCount() > 0) {
						var records = studentGrid.getSelectionModel().getSelection();
						//this.enableDisablePublishBtn(studentGrid,records);
						this.enableDisableDownloadAllBtn(studentGrid,records);
					} else {
						var buttonsToolBar = studentGrid.query('toolbar')[0];
						/*var publishButton = buttonsToolBar.query('#btnPublishMarksheet')[0];
						publishButton.disable();*/
						var downloadAllButton = buttonsToolBar.query('#btnDownloadDispatchForms')[0];
						downloadAllButton.disable();
					}
				}
			},'coursesmdgrid button[itemId=btnDownloadDispatchForms]':{
				click:function(obj){
					this.downloadAllDispatchFormsZip();
				}
			},
			/*'studentsmdsearch combo[itemId=studentId]':{
				render:function(){
					this.getStudentsmdsearch().isValid();
				}
			},*/
			'searchresultgrid[itemId=studyMaterialSearchGridId] button[itemId=searchResultGridBtnAdd]': {
				click : this.openCreateSmd
			},
			 'searchresultgrid[itemId=studyMaterialSearchGridId] menuitem[itemId=updateStatusId]': {
    			 click : function() {
    				 var grid = this.getSearchresultgrid();
    				 if (grid.getSelectionModel().getCount() > 0) {
    					 this.updateStatusSmd();
    				 }else{
    					 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    				 }
    			 }
    		 },
			'createsmdstructure radiogroup[itemId=studentCourseId]':{
				change:function(obj,rec){ 
					this.studentCourseChange(obj,rec);
				}
			},
 		   'studentsmdsearch button[itemId=searchBtn]':{
			   click:function(obj){ 
				   this.loadStudentGrid(obj);
			   }
		   },
 		  'studentsmdsearch button[itemId=resetBtn]':{
			   click:function(obj){ 
				   var $this = this;
				   $this.resetStudentSmdFields();
				   var smdForm=$this.getStudentsmdsearch();
				   var academyLocFeild = smdForm.down('#multiselectAcademyLocationId');
				   var studentCombo = smdForm.down('#studentId');
				   var academyLocationId=$this.getCurrentAcademyLocation();
				   academyLocFeild.reset();
				   studentCombo.reset();
				   var alIds=[];
				   var academyLocationIds; 
				   alIds.push(this.getCurrentAcademyLocation());
					academyLocationIds = alIds.join();
				   var studentComboStore=studentCombo.getStore();
				   
	          		studentComboStore.getProxy().extraParams = {
							academyLocationIds : academyLocationIds
						};
	          		studentComboStore.load({
						   callback: function(records, operation, success) {
				 			   if (success) {
				 				  academyLocFeild.setValue(academyLocationId);
				 			   }
						   }
					   });
			   }
		   },
		   'studentsmdsearch multiselectcombofield#multiselectAcademyLocationId':{
			   blur : function(obj, record) {
  				var studentCombo = obj.up('form').down('#studentId');
  				var academyLocationId = obj.up('form').down('#multiselectAcademyLocationId').getValue();
  				var alIds=[];
				var academyLocationIds; 
				if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
					for(var i in academyLocationId){
						if(Ext.isObject(academyLocationId[0])){
							alIds.push(academyLocationId[i].get("id"));
						}else{
							alIds.push(academyLocationId[i]);
						}
					}
					academyLocationIds = alIds.join();
				} else {
					alIds.push(this.getCurrentAcademyLocation());
					academyLocationIds = alIds.join();
				}
          		studentCombo.reset();
          		var studentComboStore=studentCombo.getStore();
          		studentComboStore.getProxy().extraParams = {
						academyLocationIds : academyLocationIds
					};
          		studentComboStore.load();
  			 }
		   },
		   'coursesmdsearch button[itemId=searchBtn]':{
			   click:function(obj){ 
				   this.loadCoourseGrid(obj);
			   }
		   },
		   'coursesmdsearch button[itemId=resetBtn]':{
			   click:function(obj){ 
				   this.resetCourseSmdFields();
			   }
		   },
		   'coursesmdsearch multiselectcombofield#multiselectAcademyLocationId':{
			   blur : function(obj, record) {
  				var programCombo = obj.up('form').down('#programId');
  				var academyLocationId = obj.up('form').down('#multiselectAcademyLocationId').getValue();
  				var coursesmdgrid=this.getCoursesmdgrid();
  				var disributionListCombo=coursesmdgrid.down('#disributionId');
  				var alIds=[];
				var academyLocationIds; 
				if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
					for(var i in academyLocationId){
						if(Ext.isObject(academyLocationId[0])){
							alIds.push(academyLocationId[i].get("id"));
						}else{
							alIds.push(academyLocationId[i]);
						}
					}
					academyLocationIds = alIds.join();
				} else {
					alIds.push(this.getCurrentAcademyLocation());
					academyLocationIds = alIds.join();
				}
          		programCombo.reset();
          		var programComboStore=programCombo.getStore();
          		programComboStore.getProxy().extraParams = {
						academyLocationIds : academyLocationIds
					};
          		programComboStore.load();
          		disributionListCombo.reset();
          		var disributionListComboStore=disributionListCombo.getStore();
          		disributionListComboStore.getProxy().extraParams = {
						academyLocationIds : academyLocationIds
					};
          		disributionListComboStore.load();
  			 }
		   },
 		  'studentsmdgrid button[itemId=btnAddSentMaterial]':{
			   click:function(){ 
				   var $this = this;
					 var grid = this.getStudentsmdgrid();
					 
					   var record = grid.getSelectionModel().getSelection();
					   var sendFlag = false;
					   var isInStock = false;
					   for(i in record){
						   if(record[i].data.updateFlag){
							   sendFlag = true;
						   }
						   if(record[i].data.isInStock){
							   isInStock = true;						 
						   }
					   }					 
					   if (grid.getSelectionModel().getCount() > 0) {	

						   if(sendFlag){
							   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DISPATCH_FORM_ALREADY_SENT'));							 
						   }else{
							   if(isInStock){
								   showConfirmMessage(getCourseTxCommonTranslation('STUDY_MATERIAL_DISTRIBUTION'),getCommonTranslation('SEND_STUDY_MATERIAL_MESSAGE'),
										   function(btn, text) {
									   if (btn == 'yes') {
										   $this.sendingMaterials();
									   }
								   });
							   }else{
								   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DISPATCH_FORM_INSUFFICIENT_QUANTITY'));  
							   }
						   }
					   }					 
					   else{
						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					   }
			   }
		   },
		   'studentsmdgrid button[itemId=printDispatchForm]':{
			   click:function(){ 
				   var $this = this;
					 var grid = this.getStudentsmdgrid();
					 if (grid.getSelectionModel().getCount() > 0) {						
							 $this.printStudentWiseDispatchForm();						
					 }else{
						 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					 }
			   }
		   },
		   'searchresultgrid[itemId=studyMaterialSearchGridId] button[itemId=dispatchFormItemId]':{
			   click:function(){ 
				   var $this = this;
				   var structure = this.getStudymaterialdistributionnewstructure();
				   var  grid= structure.down('#studyMaterialSearchGridId');
					 if (grid.getSelectionModel().getCount() > 0) {						
							 $this.printStudentWiseMaterialDistributionDispatchForm(grid);						
					 }else{
						 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					 }
			   }
		   },
		   'studentsmdgrid':{
			   //cellclick: this.cellClickSendMaterial,
			   /*render: function(grid) {
               	this.gridRenderFunction(grid); 		
               	this.genericCBGridAccessControlValidation(grid, this.getFACULTY_LIST_PERMISSIONS());
               	this.disableMoreActionPivileges(grid, this.getFACULTY_LIST_PERMISSIONS());
 					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false);
	    		},
	    		selectionchange: function(column, selected,eOpts ){
               	this.disableExtraButton(column,selected);                	
               }*/
		   },
		   'studymaterialdistsearch':{
			   render: function(obj) {
				   var form=this.getStudymaterialdistsearch();
				   var academylocation=form.down('#multiselectAcademyLocationId');
				   var academyLocationStore=academylocation.getStore();
				   var academylocationId=this.getCurrentAcademyLocation();
				   academyLocationStore.load({
					   callback: function(records, operation, success) {
			 			   if (success) {
			 				  academylocation.setValue(academylocationId);
			 			   }
					   }
				   });
			   }
		   },
		   'studymaterialdistsearch multiselectcombofield[itemId=multiselectAcademyLocationId]': {
			   blur: function(ob, rec) {
				     var form = this.getStudymaterialdistsearch();
				     var academyLocationId = ob.up('form').down('#multiselectAcademyLocationId').getValue();
				     var alIds = [];
				     var academyLocationIds;
				     if (academyLocationId != undefined && academyLocationId.length > 0 && academyLocationId[0] != "") {
				         for (var i in academyLocationId) {
				             if (Ext.isObject(academyLocationId[0])) {
				                 alIds.push(academyLocationId[i].get("id"));
				             } else {
				                 alIds.push(academyLocationId[i]);
				             }
				         }
				         academyLocationIds = alIds.join();
				     } else {
				         alIds.push(this.getCurrentAcademyLocation());
				         academyLocationIds = alIds.join();
				     }
				     var programId = form.down('#programId');
				     var batchId = form.down('#batchId');
				     var periodId = form.down('#periodId');
				     var sectionId = form.down('#sectionId');
				     var variantId = form.down('#variantId');
				     var studentId = form.down('#studentId');
				     var distributionId = form.down('#distributionId');
				     programId.reset();
				     batchId.reset();
				     periodId.reset();
				     sectionId.reset();
				     variantId.reset();
				     studentId.reset();
				     distributionId.reset();
				     batchId.setDisabled(true);
				     periodId.setDisabled(true);
				     sectionId.setDisabled(true);
				     
				     var programStore = programId.getStore();
				     programStore.getProxy().extraParams = {
				         academyLocationIds: academyLocationIds
				     };
				     programStore.load();
				     var variantStore = variantId.getStore();
				     variantStore.getProxy().extraParams = {
				         academyLocationIds: academyLocationIds
				     };
				     variantStore.load();
				     var studentStore = studentId.getStore();
				     studentStore.getProxy().extraParams = {
				         academyLocationIds: academyLocationIds
				     };
				     studentStore.load();
				     var distributionStore = distributionId.getStore();
				     distributionStore.getProxy().extraParams = {
				         academyLocationIds: academyLocationIds
				     };
				     distributionStore.load();

				 }
		   },
		   'studymaterialdistsearch button[itemId=searchBtn]':{
			   click:function(obj){ 
				   this.loadSmdGrid();
			   }
		   },
		   'studymaterialdistsearch button[itemId=resetBtn]':{
			   click:function(obj){ 
				   var form = this.getStudymaterialdistsearch();
				   form.getForm().reset();
				   var programId = form.down('#programId');
				   var batchId = form.down('#batchId');
				   var periodId = form.down('#periodId');
				   var sectionId = form.down('#sectionId');
				   var variantId = form.down('#variantId');
				   var studentId = form.down('#studentId');
				   var distributionId = form.down('#distributionId');
				   programId.reset();
				   batchId.reset();
				   periodId.reset();
				   sectionId.reset();
				   variantId.reset();
				   studentId.reset();
				   distributionId.reset();
				   batchId.setDisabled(true);
				   periodId.setDisabled(true);
				   sectionId.setDisabled(true);

					var alIds=[];
					alIds.push(this.getCurrentAcademyLocation());
					   var academylocation=form.down('#multiselectAcademyLocationId');
					   var academyLocationStore=academylocation.getStore();
					   var academylocationId=this.getCurrentAcademyLocation();
					   academyLocationStore.load({
						   callback: function(records, operation, success) {
				 			   if (success) {
				 				  academylocation.setValue(academylocationId);
				 			   }
						   }
					   });
			     }
		   },
		   'studymaterialdistsearch combo#programId' : {
			   render:function(obj){
				   var $this = this;
				   var academyLocationId = $this.getCurrentAcademyLocation();
				   var programCombo = obj.up('form').down('#programId');

				   var periodStore = programCombo.getStore();
				   periodStore.getProxy().extraParams = {
					   academyLocationId : academyLocationId
				   };
				   periodStore.load();
			   },
			   select : function(obj, record) {
				     this.getStudymaterialdistsearch().down('#periodId').reset();
				     this.getStudymaterialdistsearch().down('#batchId').reset();
				     this.getStudymaterialdistsearch().down('#sectionId').reset();
				   var programId = record[0].get("id");
				   var batchComboBox = obj.up('form').down('#batchId');
				   batchComboBox.clearValue();
				   batchComboBox.setDisabled(false);
				   var batchStore = batchComboBox.getStore();
				   batchStore.getProxy().extraParams = {
					   id: programId,
					   isActive:true
				   };
				   batchStore.load();
				   var form = obj.up('form');
				   if(programId > 0){
					   var batchStore = batchComboBox.getStore();
					   batchStore.getProxy().extraParams = {
						   id: programId,
						   isActive:true
              		   };
					   batchStore.load({

  						   callback: function(record, operation, success) {
  							   if (success) {
  								   if(record.length==0){
  									   form.down("#sectionId").setDisabled(true);
  									   form.down("#sectionId").clearValue();
  								   }
  								   if(record.length==1){
  									   form.down("#batchId").setValue(record[0].get('id'));
  									   form.down("#periodId").setDisabled(false);
  									   var store = this$.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
  									   store.getProxy().extraParams = {
  										   id: record[0].get('id'),
  										   isCurrentPeriod:true
  									   };
  									   store.load({
  										   callback: function(record, operation, success) {
  											   if (success) {
  												   if(record.length==0){
  													   if(wheatherSchool) {
  														   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

  													   } 
  												   }
  												   else if(record.length==1){
  													   form.down("#periodId").setValue(record[0].get('id'));
  													   form.down("#sectionId").setDisabled(false);
  													   var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
  													   store.getProxy().extraParams = {
  														 periodId: record[0].get('id')
  													   };
  													   store.load({
  														   callback: function(record, operation, success) {
  															   if (success) {
  																   if(record.length==1){
  																	   form.down("#sectionId").setValue(record[0].get('sectionId'));
  																   }
  															   }
  														   }
  													   });

  												   }else{
  													   form.down('#periodId').setVisible(true); 
  												   }
  											   }
  										   }
  									   });
  								   }
  							   }
  						   }
  					   
              		   });
              	   }
				   var academyLocationId = obj.up('form').down('#multiselectAcademyLocationId').getValue();
				     var alIds = [];
				     var academyLocationIds;
				     if (academyLocationId != undefined && academyLocationId.length > 0 && academyLocationId[0] != "") {
				         for (var i in academyLocationId) {
				             if (Ext.isObject(academyLocationId[0])) {
				                 alIds.push(academyLocationId[i].get("id"));
				             } else {
				                 alIds.push(academyLocationId[i]);
				             }
				         }
				         academyLocationIds = alIds.join();
				     } else {
				         alIds.push(this.getCurrentAcademyLocation());
				         academyLocationIds = alIds.join();
				     }
				   
				  var studentField = obj.up('form').down('#studentId');
				  studentField.clearValue();
				   var studentStore = studentField.getStore();
				   studentStore.getProxy().extraParams = {
					   programId: programId,
					   academyLocationIds:academyLocationIds
				   };
				   studentStore.load();

			   }
		   },
			'studymaterialdistsearch combo#batchId' : {
				select : function(obj, record) {
					var batch_Id = record[0].get("id");
					this.getStudymaterialdistsearch().down('#periodId').reset();
				    this.getStudymaterialdistsearch().down('#sectionId').reset();
					var periodComboBox = obj.up('form').down('#periodId');
					periodComboBox.clearValue();
					periodComboBox.setDisabled(false);
					  var form = obj.up('form');
					  if(batch_Id > 0){	    	        					  
						  var periodStore = periodComboBox.getStore();
							periodStore.getProxy().extraParams = {
								id: batch_Id,
								isCurrentPeriod : true
							};
							periodStore.load({

							   callback: function(records, operation, success) {
								   if (success) {
									   if(records.length==0){
										   if(wheatherSchool) {
											   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

										   } 
									   }
									   else if(records.length==1){
										   form.down("#periodId").setValue(records[0].get('id'))
										   form.down("#sectionId").setDisabled(false);
										   var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
			        					   var batch = form.down('#batchId');
			        					   var sectionId = form.down('#sectionId');
			        					   sectionId.reset();
			        					   sectionId.setDisabled(false);
			        					   var storeSection = sectionId.getStore();
			        					   storeSection.getProxy().extraParams = {
			        						   periodId:periodId
			        					   };
			        					   storeSection.load();
										   store.getProxy().extraParams = {
											   periodId: records[0].get('id')
										   };
										   store.load({
											   callback: function(records, operation, success) {
												   if (success) {
													   if(records.length==1){
														   form.down("#sectionId").setValue(records[0].get('sectionId'));
													   }
												   }
											   }
										   });

									   }else{
										   form.down('#periodId').setVisible(true); 
									   }
								   }
							   }
						   
						   });
					   }
					
					var academyLocationId = obj.up('form').down('#multiselectAcademyLocationId').getValue();
				     var alIds = [];
				     var academyLocationIds;
				     if (academyLocationId != undefined && academyLocationId.length > 0 && academyLocationId[0] != "") {
				         for (var i in academyLocationId) {
				             if (Ext.isObject(academyLocationId[0])) {
				                 alIds.push(academyLocationId[i].get("id"));
				             } else {
				                 alIds.push(academyLocationId[i]);
				             }
				         }
				         academyLocationIds = alIds.join();
				     } else {
				         alIds.push(this.getCurrentAcademyLocation());
				         academyLocationIds = alIds.join();
				     }
					var programId = obj.up('form').down('#programId').getValue();
					var studentField = obj.up('form').down('#studentId');
					  studentField.clearValue();
					   var studentStore = studentField.getStore();
					   studentStore.getProxy().extraParams = {
						   programId: programId,
						   batchId:batch_Id,
						   academyLocationIds:academyLocationIds
					   };
					   studentStore.load();

				}
			},
			'studymaterialdistsearch combo#periodId' : {
				select : function(obj, record) {
					var academyLocationId = obj.up('form').down('#multiselectAcademyLocationId').getValue();
				     var alIds = [];
				     this.getStudymaterialdistsearch().down('#sectionId').reset();
				     var academyLocationIds;
				     if (academyLocationId != undefined && academyLocationId.length > 0 && academyLocationId[0] != "") {
				         for (var i in academyLocationId) {
				             if (Ext.isObject(academyLocationId[0])) {
				                 alIds.push(academyLocationId[i].get("id"));
				             } else {
				                 alIds.push(academyLocationId[i]);
				             }
				         }
				         academyLocationIds = alIds.join();
				     } else {
				         alIds.push(this.getCurrentAcademyLocation());
				         academyLocationIds = alIds.join();
				     }
					var periodId = record[0].get("id");
					var sectionCombo = obj.up('form').down('#sectionId');
					sectionCombo.clearValue();
					sectionCombo.setDisabled(false);
					var form = obj.up('form');
					   if(periodId > 0){
						   var sectionStore =sectionCombo.getStore(); 
							sectionStore.getProxy().extraParams = {	
								periodId: periodId
							};
							sectionStore.load({

								   callback: function(records, operation, success) {
									   if (success) {
										   if(records.length==0){
											   if(wheatherSchool) {
												   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

											   } 
										   }
										   else if(records.length==1){
											   form.down("#sectionId").setValue(record[0].get('id'));
											 }
									   }
								   }
							   
							   });
					   }
					
					var programId = obj.up('form').down('#programId').getValue();
					var batchId = obj.up('form').down('#batchId').getValue();
					var studentField = obj.up('form').down('#studentId');
					  studentField.clearValue();
					   var studentStore = studentField.getStore();
					   studentStore.getProxy().extraParams = {
						   programId: programId,
						   batchId:batchId,
						   periodId: periodId,
						   academyLocationIds:academyLocationIds
					   };
					   studentStore.load();
					   
				}

			},
			'studymaterialdistsearch combo#sectionId' : {
				select : function(obj, record) {
					var academyLocationId = obj.up('form').down('#multiselectAcademyLocationId').getValue();
				     var alIds = [];
				     var academyLocationIds;
				     if (academyLocationId != undefined && academyLocationId.length > 0 && academyLocationId[0] != "") {
				         for (var i in academyLocationId) {
				             if (Ext.isObject(academyLocationId[0])) {
				                 alIds.push(academyLocationId[i].get("id"));
				             } else {
				                 alIds.push(academyLocationId[i]);
				             }
				         }
				         academyLocationIds = alIds.join();
				     } else {
				         alIds.push(this.getCurrentAcademyLocation());
				         academyLocationIds = alIds.join();
				     }
					var sectionId = record[0].get("sectionId");
					var programId = obj.up('form').down('#programId').getValue();
					var batchId = obj.up('form').down('#batchId').getValue();
					var periodId = obj.up('form').down('#periodId').getValue();
					var studentField = obj.up('form').down('#studentId');
					  studentField.clearValue();
					   var studentStore = studentField.getStore();
					   studentStore.getProxy().extraParams = {
						   programId: programId,
						   batchId:batchId,
						   periodId: periodId,
						   sectionId:sectionId,
						   academyLocationIds:academyLocationIds
					   };
					   studentStore.load();
					   
						var variantField = obj.up('form').down('#variantId');
						variantField.clearValue();
						   var variantStore = variantField.getStore();
						   variantStore.getProxy().extraParams = {
							   sectionId: sectionId,
							   academyLocationIds:academyLocationIds
						   };
						   variantStore.load();
				}

			},
			'studymaterialdistsearch combo#variantId' : {
				select : function(obj, record) {
					var academyLocationId = obj.up('form').down('#multiselectAcademyLocationId').getValue();
				     var alIds = [];
				     var academyLocationIds;
				     if (academyLocationId != undefined && academyLocationId.length > 0 && academyLocationId[0] != "") {
				         for (var i in academyLocationId) {
				             if (Ext.isObject(academyLocationId[0])) {
				                 alIds.push(academyLocationId[i].get("id"));
				             } else {
				                 alIds.push(academyLocationId[i]);
				             }
				         }
				         academyLocationIds = alIds.join();
				     } else {
				         alIds.push(this.getCurrentAcademyLocation());
				         academyLocationIds = alIds.join();
				     }
					var variantId = record[0].get("id");
					var programId = obj.up('form').down('#programId').getValue();
					var batchId = obj.up('form').down('#batchId').getValue();
					var periodId = obj.up('form').down('#periodId').getValue();
					var sectionId = obj.up('form').down('#sectionId').getValue();
					
					var studentField = obj.up('form').down('#studentId');
					  studentField.clearValue();
					   var studentStore = studentField.getStore();
					   studentStore.getProxy().extraParams = {
						   programId: programId,
						   batchId:batchId,
						   periodId: periodId,
						   sectionId:sectionId,
						   courseVariantId:variantId,
						   academyLocationIds:academyLocationIds
					   };
					   studentStore.load();
				}

			},
			/*'studymaterialdistsearch combo#courseId' : {
				render:function(obj){
					var $this = this;
					var academyLocationId = $this.getCurrentAcademyLocation();
					var courseCombo = obj.up('form').down('#courseId');

					var courseStore = courseCombo.getStore();
					courseStore.getProxy().extraParams = {
						academyLocationId : academyLocationId
					};
					courseStore.load();
				}
			},*/
		   'coursesmdsearch combo#programId' : {
				render:function(obj){
					var $this = this;
					var academyLocationId = $this.getCurrentAcademyLocation();
					var programCombo = obj.up('form').down('#programId');

					var periodStore = programCombo.getStore();
					periodStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId
					};
					periodStore.load();
				},
				select : function(obj, record) {
				var $this = this;
				 $this.getCoursesmdsearch().down('#periodId').reset();
				 $this.getCoursesmdsearch().down('#batchId').reset();
				 $this.getCoursesmdsearch().down('#sectionId').reset();
				var programId = record[0].get("id");
   				var batchComboBox = obj.up('form').down('#batchId');
   				$this.getCoursesmdgrid().down('#printCourseDispatchForm').setDisabled(true);
   				batchComboBox.clearValue();
   				batchComboBox.setDisabled(false);
   			    var form = obj.up('form');
   				if(programId > 0){
					   var batchStore = batchComboBox.getStore();
					   batchStore.getProxy().extraParams = {
						   id: programId,
						   isActive:true
           		   };
					   batchStore.load({

						   callback: function(record, operation, success) {
							   if (success) {
								   if(record.length==0){
									   form.down("#sectionId").setDisabled(true);
									   form.down("#sectionId").clearValue();
								   }
								   if(record.length==1){
									   form.down("#batchId").setValue(record[0].get('id'));
									   form.down("#periodId").setDisabled(false);
									   var store = this$.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
									   store.getProxy().extraParams = {
										   id: record[0].get('id'),
										   isCurrentPeriod:true
									   };
									   store.load({
										   callback: function(record, operation, success) {
											   if (success) {
												   if(record.length==0){
													   if(wheatherSchool) {
														   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

													   } 
												   }
												   else if(record.length==1){
													   form.down("#periodId").setValue(record[0].get('id'));
													   form.down("#sectionId").setDisabled(false);
													   var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
													   store.getProxy().extraParams = {
														 periodId: record[0].get('id')
													   };
													   store.load({
														   callback: function(record, operation, success) {
															   if (success) {
																   if(record.length==1){
																	   form.down("#sectionId").setValue(record[0].get('sectionId'));
																   }
															   }
														   }
													   });
													   var disModeField = $this.getCoursesmdstructure().down('#disributionId');
														//$this.getCoursesmdgrid().down('#printCourseDispatchForm').setDisabled(true);
														var dStore = disModeField.getStore();
														var values = form.getValues();
														var programId = values.programId;
														var batchId = values.batchId;
														var records=values.multiselectAcademyLocation;
														var academyLocation=[];
														if(!isNullOrEmpty(records.length)){
															Ext.each(records, function(privilege) {
											          			 academyLocation.push(privilege.data.id);
											          		 });
														}else{
															academyLocation.push(records); 
														}
										          		
										          		var academyLocationIds=academyLocation.join();
														
														dStore.getProxy().extraParams = {	
															programId:programId,
															batchId:batchId,
															periodId: periodId,
															academyLocationIds:academyLocationIds
														};
														dStore.load();

												   }else{
													   form.down('#periodId').setVisible(true); 
												   }
											   }
										   }
									   });
								   }
							   }
						   }
					   
           		   });
           	   }

				}
			},
			'coursesmdsearch combo#batchId' : {
				select : function(obj, record) {
					var batch_Id = record[0].get("id");
					var $this = this;
					$this.getCoursesmdsearch().down('#periodId').reset();
					$this.getCoursesmdsearch().down('#sectionId').reset();
					var periodComboBox = obj.up('form').down('#periodId');
					periodComboBox.clearValue();
					periodComboBox.setDisabled(false);
					var periodStore = periodComboBox.getStore();
					  var form = obj.up('form');
					  if(batch_Id > 0){	    	        					  
						  var periodStore = periodComboBox.getStore();
							periodStore.getProxy().extraParams = {
								id: batch_Id,
								isCurrentPeriod : true
							};
							periodStore.load({

							   callback: function(records, operation, success) {
								   if (success) {
									   if(records.length==0){
										   if(wheatherSchool) {
											   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

										   } 
									   }
									   else if(records.length==1){
										   form.down("#periodId").setValue(records[0].get('id'))
										   form.down("#sectionId").setDisabled(false);
										   var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
			        					   var batch = form.down('#batchId');
			        					   var sectionId = form.down('#sectionId');
			        					   sectionId.reset();
			        					   sectionId.setDisabled(false);
			        					   var storeSection = sectionId.getStore();
			        					   storeSection.getProxy().extraParams = {
			        						   periodId:periodId
			        					   };
			        					   storeSection.load();
										   store.getProxy().extraParams = {
											   periodId: records[0].get('id')
										   };
										   store.load({
											   callback: function(records, operation, success) {
												   if (success) {
													   if(records.length==1){
														   form.down("#sectionId").setValue(records[0].get('sectionId'));
													   }
												   }
											   }
										   });
										   
										   var disModeField = $this.getCoursesmdstructure().down('#disributionId');
											//$this.getCoursesmdgrid().down('#printCourseDispatchForm').setDisabled(true);
											var dStore = disModeField.getStore();
											var values = form.getValues();
											var programId = values.programId;
											var batchId = values.batchId;
											var records=values.multiselectAcademyLocation;
											var academyLocation=[];
											if(!isNullOrEmpty(records.length)){
												Ext.each(records, function(privilege) {
								          			 academyLocation.push(privilege.data.id);
								          		 });
											}else{
												academyLocation.push(records); 
											}
							          		
							          		var academyLocationIds=academyLocation.join();
											
											dStore.getProxy().extraParams = {	
												programId:programId,
												batchId:batchId,
												periodId: periodId,
												academyLocationIds:academyLocationIds
											};
											dStore.load();

									   }else{
										   form.down('#periodId').setVisible(true); 
									   }
								   }
							   }
						   
						   });
					   }
					
				}
			},
			'coursesmdsearch combo#periodId' : {
				select : function(obj, record) {
					var $this = this;
					$this.getCoursesmdsearch().down('#sectionId').reset();
					var periodId = record[0].get("id");
					var form = obj.up('form').getForm();
					var sectionCombo = obj.up('form').down('#sectionId');
					sectionCombo.clearValue();
					sectionCombo.setDisabled(false);
					var sectionStore =sectionCombo.getStore(); 
					sectionStore.getProxy().extraParams = {	
						periodId: periodId
					};
					sectionStore.load();
					  var form = obj.up('form');
					   if(periodId > 0){
						   var sectionStore =sectionCombo.getStore(); 
							sectionStore.getProxy().extraParams = {	
								periodId: periodId
							};
							sectionStore.load({

								   callback: function(records, operation, success) {
									   if (success) {
										   if(records.length==0){
											   if(wheatherSchool) {
												   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

											   } 
										   }
										   else if(records.length==1){
											   form.down("#sectionId").setValue(records[0].get('id'));
											 }
									   }
								   }
							   
							   });
					   }
					
					var disModeField = $this.getCoursesmdstructure().down('#disributionId');
					//$this.getCoursesmdgrid().down('#printCourseDispatchForm').setDisabled(true);
					var dStore = disModeField.getStore();
					var values = form.getValues();
					var programId = values.programId;
					var batchId = values.batchId;
					var records=values.multiselectAcademyLocation;
					var academyLocation=[];
					if(!isNullOrEmpty(records.length)){
						Ext.each(records, function(privilege) {
		          			 academyLocation.push(privilege.data.id);
		          		 });
					}else{
						academyLocation.push(records); 
					}
	          		
	          		var academyLocationIds=academyLocation.join();
					
					dStore.getProxy().extraParams = {	
						programId:programId,
						batchId:batchId,
						periodId: periodId,
						academyLocationIds:academyLocationIds
					};
					dStore.load();
					
				}
			},
			'coursesmdstructure button[itemId=saveBtn]':{
				click:function(obj){ 
					var grid = this.getCoursesmdgrid();
					var record = grid.getSelectionModel().getSelection();
					//var flag = record.get('isAlreadyExist');
					var isAlreadySent = false;
					for(i in record){
						if(record[i].data.isAlreadyExist){
							isAlreadySent = true;
						}
					}
					if (grid.getSelectionModel().getCount() > 0) {

						if (isAlreadySent) {
							showWarningMessage(getCommonTranslation('ALERT'),"This study material is already sent");
						} else {
							this.saveCourseSmd(obj);
						}	 

					}else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
		/*	'updatestatussmd combo#packetStatus':{
				select:function(obj,rec){
					this.changeFieldsOnSelect(obj,rec);
				}
			},*/

			/*'updatestatussmd button[itemId=SubmitBtn]':{
				click:function(){
					this.saveUpdateStaus();
				}
			},*/
			/*'sentstudentsmd button[itemId=SubmitBtn]':{
				click:function(){
					this.saveSentSmdStaus();
				}
			},*/
			/*'sentstudentsmd button[itemId=cancelBtn]':{
				click:function(){
					this.getSentstudentsmd().close();
				}
			},*/
			'sentstudentsmd checkboxfield[itemId=useCommAddId]':{
				change:function($this, newValue, oldValue, eOpts ){
					this.getStudentAddress($this, newValue, oldValue, eOpts );
				}
			},
			  'updatestatussmd combo#packetStatus':{
				  select:function(obj,rec){
					  this.changeFieldsOnSelect(obj,rec);
				  }
			  },
			  
			  'updatestatussmd button[itemId=SubmitBtn]':{
				  click:function(){
					  this.saveUpdateStaus();
				  }
			  },
			  'updatestatussmd button[itemId=CancelBtn]':{
				  click:function(obj){
					  obj.up('window').close();
				  }
			  },
			  'sentstudentsmd button[itemId=SubmitBtn]':{
				  click:function(){
					  this.saveSentSmdStaus();
				  }
			  },
			  'sentstudentsmd button[itemId=cancelBtn]':{
				  click:function(){
					  this.getSentstudentsmd().close();
				  }
			  },
			  
			  
			  'searchresultgrid[itemId=studyMaterialSearchGridId] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false);
		            }
		        },
		        'searchresultgrid[itemId=studyMaterialSearchGridId] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true);
		            }
		        },
		        'searchresultgrid[itemId=studyMaterialSearchGridId] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
		            }
		        },
		        'searchresultgrid[itemId=studyMaterialSearchGridId] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
		            }
		        },
		        'updatestatussmd button#updateStatusDocument': {
      			  click:function(){
      				  this.getDocumentController().showDocumentFormWindow('updateStatusSmd', 'DOCUMENT');
      			  }
      		  },
      		'studymatrialdownloddocgrid button#btnDelete': {
    			  click:function(){
          				var $this = this;
          				var grid = $this.getStudymatrialdownloddocgrid();
          				if (grid.getSelectionModel().getCount() > 0) {
          					 showConfirmMessage(getProgramandcourseTranslation('READING_MATERIAL_DISTRIBUTION_UPDATE_STATUS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
          							function(btn,text) {
          								if (btn == 'yes') {
          									var records = grid.getSelectionModel().getSelection();
          									var id = records[0].get("id");
          								if (!isNullOrEmpty(id)) {
          									Ext.Ajax.request({
          										method : "DELETE",
          										type : 'rest',
          										//url : SERVERURL.COURSE_DOCUMENT_DELETE_DOCUMENT_URL+ '?id='+ id,,// need url for delete document
          										headers : {
          											'Content-Type' : 'application/json'
          										},
          										success : function(form,action) {
          											grid.getStore().reload();
          											showSuccessMessage(getProgramandcourseTranslation('READING_MATERIAL_DISTRIBUTION_UPDATE_STATUS'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
          										}
          									});
          								}else{
          									var store = grid.getStore();
          									store.remove(records[0]);
          									showSuccessMessage(getProgramandcourseTranslation('READING_MATERIAL_DISTRIBUTION_UPDATE_STATUS'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
          								}	
          							}
          							});
          				} else {
          					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
          				}
          		
    			  }
    		  },
      		  'documentformwindow[itemId=updateStatusSmd] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId':{
    			  click:function(){
    				  var $this=this;
    				  var isTransient = true;
    				  var module = 'updateStatusSMD';
    				  var entityId ;
    				  var entityType = 'updateStatusSMD';

    				  $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){
    					  var documentModel=new Academia.model.coursetransaction.studymaterialdistributionnew.UpdateStatusUploadDocSmdMdl();
    					  documentModel.set("documentName",response.name);
    					  documentModel.set("path",response.path);
    					  documentModel.set("type",response.type);
    					  documentModel.set("documentName",response.name);
    					  documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
    					  
    					  var store=$this.getStore('coursetransaction.studymaterialdistributionnew.UpdateStatusUploadDocSmdStr');
    					  store.add(documentModel);
    					  $this.getDocumentController().closeDocumentFormWindow();
    				  }, isTransient);
    			  }
    		  },
    		  'studentsmdstructure':{
    			  render : function(structure){
    				  this.doAccessControlValidation(structure, this.getSTUDY_MATERIAL_DISTRIBUTION_LIST_PERMISSIONS());
    				  this.disableStudyMaterialListPivileges(structure, this.getSTUDY_MATERIAL_DISTRIBUTION_LIST_PERMISSIONS()); 
    			  }
    		  },
    		  'coursesmdstructure':{
    			  render :  function(structure){
    				  this.doAccessControlValidation(structure, this.getSTUDY_MATERIAL_DISTRIBUTION_LIST_PERMISSIONS());
    				  this.disableStudyMaterialListPivileges(structure, this.getSTUDY_MATERIAL_DISTRIBUTION_LIST_PERMISSIONS()); 

    			  }
    		  }
		});
	},
	/************************************ START : STUDENT *******************************************************/
	studentCourseChange:function(obj,rec){
		var $this = this;
		var form = $this.getCreatesmdstructure();
		if(rec.studentandcourse == "student"){
			form.down('#studentsmdstructureId').setVisible(true);
			form.down('#coursesmdstructureId').setVisible(false);
		}else{
			form.down('#coursesmdstructureId').setVisible(true);
			form.down('#studentsmdstructureId').setVisible(false);
			$this.getCoursesmdsearch().down('#programId').setDisabled(false);
		}
	},
	loadStudentGrid:function(obj){
		var $this = this;
		var searchForm = obj.up('form');
		var form = searchForm.getForm();
		var studentId = form.findField('studentName').getValue();
		var store = $this.getStudentsmdgrid().getStore();
		var buttonFlag = false;
		store.getProxy().extraParams={
			studentId:studentId
		},
		store.load({
	 		   callback: function(records, operation, success) {
	 			   if (success) {
	 				   for(var i in records){
	 					   if(records[i].get("updateFlag") == true){
	 						  buttonFlag = true;				   
	 					   }else{
	 						  buttonFlag = false;
	 					   }
	 				   }
	 				  if(buttonFlag == true){
	 						$this.getStudentsmdgrid().down('#btnAddSentMaterial').setDisabled(true);
	 					}else{
	 						$this.getStudentsmdgrid().down('#btnAddSentMaterial').setDisabled(false);
	 					}
	 			   }
	 		   }	   
	 	   });
	},
	sendingMaterials:function(){
		var $this = this;
		var form = $this.getStudentsmdsearch().getForm();
		var studentId = form.findField('studentName').getValue();

		var grid = $this.getStudentsmdgrid();
		var dataFlag = false;

		var courseReadingVar = [];
		if (grid.getSelectionModel().getCount() > 0) {
			var selected = grid.selModel.getSelection();

			if( selected.length > 0){
				for(var i in selected){
					if(selected[i].data.updateFlag == null ){
						dataFlag = true;
						courseReadingVar.push({
							"courseReadingVariant" : $this.getIdValueJson(selected[i].data.courseReadingVariantId)
						});						
					}					
				}	

			}
		}
		if(dataFlag){
			var data = {
					"studentId":$this.getIdValueJson(studentId),
					"packetStatus":"Sent",
					"wsInvtStudentDistributionDetails" :courseReadingVar,
					"useCommunicationAddress":true
			};			

			submitUrl = SERVERURL.SENT_STUDY_MATERIAL_DISTRIBUTION;
			Ext.Ajax.request({
				type : 'rest',
				url : submitUrl,
				jsonData : [data],
				method : 'POST',
				success : function(form1, action) {
					showSuccessMessage(getCourseTxCommonTranslation('STUDY_MATERIAL_DISTRIBUTION'),getCommonTranslation('SUCCESS'));
					$this.resetStudentSmdFields();
				}
			});			
		}
	},
	resetStudentSmdFields:function(){
		 var form = this.getStudentsmdsearch().getForm();
    	 //form.reset();
    	 var grid = this.getStudentsmdgrid();
    	 grid.getStore().removeAll();
    	 grid.down('#custompagingtoolbarstudentsmd').setVisible(false);
	},
	
    
    /****************************** For Course **********************************/
    
    loadCoourseGrid:function(obj){
		var $this = this;
		var searchForm = $this.getCoursesmdsearch();
		var form = searchForm.getForm();
		
		var saveBnt = $this.getCoursesmdstructure().down('#saveBtn');
		var grid = $this.getCoursesmdgrid();
		buttonsToolBar = grid.query('toolbar')[0];
		var disributionField = buttonsToolBar.query('#disributionId')[0];
		var dId = disributionField.getValue();
		
		var values = form.getValues();
		var store = $this.getCoursesmdgrid().getStore();
		var programId = values.programId;
		var batchId = values.batchId;
		var periodId = values.periodId;
		var sectionId = values.sectionId;
		
		store.getProxy().extraParams={
			programId:programId,
			batchId:batchId,
			periodId : periodId,
			sectionId : sectionId,
			distributionListId:dId > 0 ? dId :0 
		 },
		store.load({
	 		   callback: function(records, operation, success) {
	 			   if (success) {
	 				  grid.down('#btnDownloadDispatchForms').setDisabled(true);
	 				  if(isNullOrEmpty(dId)){
	 					 grid.down('#printCourseDispatchForm').setDisabled(true);
	 				  }
	 				  
	 				  var count = 0;
	 				   for(var i in records){
	 					   if(records[i].get("isAlreadyExist") == true){
	 						  buttonFlag = true;
	 						 count++;
	 					   }else{
	 						  buttonFlag = false;
	 					   }
	 				   }
	 				   /*if(buttonFlag == true){
	 					   saveBnt.setDisabled(true);
	 				   }else{
	 						saveBnt.setDisabled(false);
	 					}*/
	 				  
	 				  if(count === records.length){
	 					 saveBnt.setDisabled(true);
	 				  }else{
	 					 saveBnt.setDisabled(false);
	 				  }
	 			   }
	 		   }	   
	 	   });
		
	
     },
     resetCourseSmdFields:function(){
    	 var form = this.getCoursesmdsearch().getForm();
    	 form.reset();
    	 form.findField('batchId').setDisabled(true);
    	 form.findField('periodId').setDisabled(true);
    	 form.findField('sectionId').setDisabled(true);
    	 var grid = this.getCoursesmdgrid();
    	 buttonsToolBar = grid.query('toolbar')[0];
    	 printBtn = grid.down('#printCourseDispatchForm');
    	 var disributionField = buttonsToolBar.query('#disributionId')[0];
    	 disributionField.reset();
    	 grid.getStore().removeAll();
    	 grid.down('#custompagingtoolbarcoursesmd').setVisible(false);
    	 this.getCoursesmdstructure().down('#saveBtn').setDisabled(true);
    	 printBtn.setDisabled(true);
     },
     resetProgramSmdFields:function(){
    	 var form = this.getCoursesmdsearch().getForm();
    	 this.getCoursesmdsearch().down('#programId').reset();
    	 this.getCoursesmdsearch().down('#batchId').reset();
    	 this.getCoursesmdsearch().down('#periodId').reset();
    	 this.getCoursesmdsearch().down('#sectionId').reset();
    	 var grid = this.getCoursesmdgrid();
    	 buttonsToolBar = grid.query('toolbar')[0];
    	 printBtn = grid.down('#printCourseDispatchForm');
    	 var disributionField = buttonsToolBar.query('#disributionId')[0];
    	 disributionField.reset();
    	 grid.getStore().removeAll();
    	 grid.down('#custompagingtoolbarcoursesmd').setVisible(false);
    	 this.getCoursesmdstructure().down('#saveBtn').setDisabled(true);
    	 printBtn.setDisabled(true);
     },
     openCreateSmd:function(){
    	 var $this = this;
    	 var contentpanel = $this.getContentpanel();
    	 var coursegroupstructure = Ext.widget('createsmdstructure');
    	 var tabName = getCourseTxCommonTranslation('STUDY_MATERIAL_DISTRIBUTION_LIST');

    	 var getcontroller=$this.getController('menu.CoreERPNavigationController');
    	 var getTab=getcontroller.getTab(tabName);
    	 if(getTab!=null){
    		 contentpanel.remove(getTab, true);
    	 }
    	 openTab(contentpanel, tabName, coursegroupstructure,CONSTANTS.MENU_COLOR_THREE);
    	 var smdForm=$this.getStudentsmdsearch();
    	 var academyLocationId=$this.getCurrentAcademyLocation();
    	 var multiALBox=smdForm.down('#multiselectAcademyLocationId');
    	 var multiALBoxStore=multiALBox.getStore();
    	 multiALBoxStore.load({
    			 callback : function(records, operation, success) {
						if (success) {
							multiALBox.setValue(academyLocationId);
						}
					}
    	 });
    	 var studentBox=smdForm.down('#studentId');
    	 var studentBoxStore=studentBox.getStore();
    	 studentBoxStore.getProxy().extraParams = {
    		 academyLocationIds:academyLocationId
			};
    	 studentBoxStore.load();
    	var courseSmdForm=$this.getCoursesmdsearch();
    	var courseMultiALBox=courseSmdForm.down('#multiselectAcademyLocationId');
   	 	var courseMultiALBoxStore=courseMultiALBox.getStore();
   	 	courseMultiALBoxStore.load({
   			 callback : function(records, operation, success) {
						if (success) {
							courseMultiALBox.setValue(academyLocationId);
						}
					}
   	 	});
    	 
     },
     saveCourseSmd:function(){
    	 var $this = this;
    	 var grid = $this.getCoursesmdgrid();

    	 var csmdForm = $this.getCoursesmdstructure().getForm();
    	 var courseReadingVar = [];
    	 var submitData = [];
    	 var disField = csmdForm.findField('disributionId');
    	 var distributionModeId = disField.getValue();
    	 if(!isNullOrEmpty(distributionModeId)){    	 
    	 var courseReadingVariant = disField.valueModels[0].get('courseReadingVariantId');
    	 
    	 var userId = $this.getCurrentlyLoggedInUser().id;
    	 for(var i in courseReadingVariant){
    		 courseReadingVar.push({
    			 'courseReadingVariant':$this.getIdValueJson(courseReadingVariant[i])
    		 });
    	 }

    	 if (grid.getSelectionModel().getCount() > 0) {
    		 var selected = grid.selModel.getSelection();

    		 if( selected.length > 0){
    			 for(var i in selected){
    				 submitData.push({
    					 "studentId":$this.getIdValueJson(selected[i].data.studentId),
    					 "packetStatus":"Sent",
    					 "wsInvtStudentDistributionDetails" :courseReadingVar,
    					 "useCommunicationAddress":true,
    					 "invtDistributionList":$this.getIdValueJson(distributionModeId),
    					 "sentBy":$this.getIdValueJson(userId)
    				 });
    			 }	

    		 }
    	 }
    	 submitUrl = SERVERURL.SENT_STUDY_MATERIAL_DISTRIBUTION;
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	 
    	 Ext.Ajax.request({
    		 type : 'rest',
    		 url : submitUrl,
    		 jsonData : submitData,
    		 method : 'POST',
    		 success : function(form, action) {
    			 Ext.getBody().unmask();
    			 showSuccessMessage(getCourseTxCommonTranslation('STUDY_MATERIAL_DISTRIBUTION'),getCommonTranslation('SUCCESS'));
    			 $this.getCoursesmdstructure().down('#saveBtn').setDisabled(true);
    			 $this.resetProgramSmdFields();
    		 }
    	 });
    }else{
    	showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PLEASE_SELECT_DISTRIBUTION_LIST'));
    }

     },
	/************************************* Funcitonality on update *****************************************/
	updateStatusSmd:function(){
		
        var formWindow = this.getUpdatestatussmd();
        if (!formWindow) {
            Ext.widget('updatestatussmd');
            formWindow = this.getUpdatestatussmd();
        }
        formWindow.show();
    },
    changeFieldsOnSelect:function(obj,rec){
    	var $this = this;
    	var grid = $this.getSearchresultgrid();
    	var gridData = grid.getSelectionModel().getSelection();
    	var sentDate = null;
    	
    	var form = obj.up('form').getForm();
    	var deliveryDate = form.findField('deliveryDate');
    	var returnDate = form.findField('returnDate');
    	var lostDate = form.findField('lostDate');
    	var returnTextField = form.findField('returnReason');
    	var lostTextField = form.findField('lostReason');
    	var recievedAndPodField = obj.up('form').down('#recievedAndPodField');
    	if(rec[0].get("value") == 'Returned'){

    		returnDate.setVisible(true);
    		returnDate.allowBlank=false;
    		deliveryDate.allowBlank=true;
    		deliveryDate.reset();
    		deliveryDate.setVisible(false);
    		returnTextField.setVisible(true);
    		lostDate.allowBlank=true;
    		lostDate.reset();
    		lostDate.setVisible(false);
    		lostTextField.setVisible(false);
    		recievedAndPodField.setVisible(false);

    	}else if(rec[0].get("value") == 'Delivered'){
    		returnDate.setVisible(false);
    		returnDate.reset();
    		deliveryDate.allowBlank=false;
    		returnDate.allowBlank=true;
    		deliveryDate.setVisible(true);
    		returnTextField.setVisible(false);
    		recievedAndPodField.setVisible(true);
    		lostDate.allowBlank=true;
    		lostDate.reset();
    		lostDate.setVisible(false);
    		lostTextField.setVisible(false);
    	}else if(rec[0].get("value") == 'Lost'){
    		
    		if(gridData.length>0){
        		sentDate = gridData[0].get('SENT_DATE');
        	}
        	if(!isNullOrEmpty(sentDate)){
        		lostDate.setMinValue(sentDate);	
        	}
        	
    		lostDate.allowBlank=false;
    		lostDate.setVisible(true);
    		lostTextField.setVisible(true);
    		
    		returnDate.setVisible(false);
    		returnDate.reset();
    		returnDate.allowBlank=true;
    		returnTextField.setVisible(false);
    		
    		deliveryDate.allowBlank=true;
    		deliveryDate.reset();
    		deliveryDate.setVisible(false);
    		recievedAndPodField.setVisible(false);

    	}else{
    		returnDate.setVisible(false);
    		deliveryDate.setVisible(false);
    		recievedAndPodField.setVisible(false);
    	}
    	form.isValid(true);
    },
    saveUpdateStaus:function(){
    	var $this = this;
    	var grid = $this.getSearchresultgrid();
    	var form =  $this.getUpdateStatussmd().getForm();
    	var values = form.getValues();
    	var packetStatus =  form.findField('packetStatus').getRawValue();
    	
    	var rDate;
    	if(!isNullOrEmpty(values.returnDate)){
    		rDate = values.returnDate; 
    	}else{
    		rDate = null;
    	}
    	var dDate;
    	if(!isNullOrEmpty(values.deliveryDate)){
    		dDate = values.deliveryDate;
    	}else{
    		dDate = null;
    	}
    	var lDate;
    	if(!isNullOrEmpty(values.lostDate)){
    		lDate = values.lostDate;
    	}else{
    		lDate = null;
    	}
    	
      var docStore=$this.getStore('coursetransaction.studymaterialdistributionnew.UpdateStatusUploadDocSmdStr');
  	  var docArray=[]; 
  	  if(docStore.data.items!=null && docStore.data.items.length>0){
  	  Ext.each(docStore.data.items, function (val) {
  		  var newData={
  				  "name":val.data.documentName,
  				  "path":val.data.path,
  				  "type":val.data.type,
  				  "createdBy":$this.getIdValueJson(val.data.createdBy.id,val.data.createdBy.value)
  		  };
  		  if(val.data.documentId==""){
  			  docArray.push(newData);  
  		  }
		   });
  	  }
  	  /*if(docArray.length > 0 ){
  		  courseReading.set("documents",docArray);  
  	  }else{
      	  courseReading.set("documents",null);	        		  
  	  }*/
    	
    	var userId = $this.getCurrentlyLoggedInUser().id;
     		var submitData = [];
     		
     		if (grid.getSelectionModel().getCount() > 0) {
     			var selected = grid.selModel.getSelection();

     			if( selected.length > 0){
     				for(var i in selected){
     					
     					var sentDate;
     					if(!isNullOrEmpty(selected[i].data.SENT_DATE)){
     						 sentDate=Ext.Date.format(new Date(selected[i].data.SENT_DATE.split('/')[1]+'/'+selected[i].data.SENT_DATE.split('/')[0]+'/'+selected[i].data.SENT_DATE.split('/')[2]),CONSTANTS.DATE_FORMAT)
     						 var  dt = Ext.Date.parse(sentDate, CONSTANTS.DATE_FORMAT);
     						 sentDate = Ext.Date.format(new Date(dt),CONSTANTS.SUBMIT_DATE_FORMAT);
     					}else{
     						sentDate = null;
     					}
     					submitData.push({
     						"id":selected[i].data.ID,
     						"packetNo":selected[i].data.PACKET_NO,
     						"packetStatus":packetStatus,
     						"returnedDate":rDate,
     						"deliveredDate":dDate,
     						"lostDate":lDate,
     						"lostReason":values.lostReason,
     						"remarks":values.returnReason,
     						"pod":values.podNo,
     						"consignmentNo":selected[i].data.CONSIGNMENT_NO,
     						"sentBy":$this.getIdValueJson(userId),
     						"sentDate":sentDate,
     						"serviceProvider":$this.getIdValueJson(selected[i].data.SERVICE_PROVIDER),
     						"studentAddress":selected[i].data.STUDENT_ADDRESS,
     						"studentId":$this.getIdValueJson(selected[i].data.STUDENT_ID),
     						"invtDistributionList":$this.getIdValueJson(selected[i].data.INVENTORY_DISTRIBUTIONLIST_ID),
     						"documents": docArray.length > 0 ? docArray : null 
     					});
     				}	
     			}
     		}
     		submitUrl = SERVERURL.UPDATE_STUDY_MATERIAL_DISTRIBUTION;
     		Ext.Ajax.request({
     			type : 'rest',
     			url : submitUrl,
     			jsonData : submitData,
     			method : 'POST',
     			success : function(form, action) {
     				showSuccessMessage(getProgramandcourseTranslation('READING_MATERIAL_DISTRIBUTION_UPDATE_STATUS'),getCommonTranslation('SUCCESS'));
     				grid.getStore().reload();
     				$this.getUpdatestatussmd().close();
     			}
     		});
    },
    openSentWind:function(grid, rowIndex, record){
     var grid = this.getSearchresultgrid();
	 if (grid.getSelectionModel().getCount() > 0) {
		var $this = this;
    	var formWindow = $this.getSentstudentsmd();
    	if (!formWindow) {
    		Ext.widget('sentstudentsmd');
    		formWindow = $this.getSentstudentsmd();
    	}
    	formWindow.show();
    	var sForm = $this.getSentStudentsmd().getForm();
    	var userId = $this.getCurrentlyLoggedInUser().id;
    	var userValue = $this.getCurrentlyLoggedInUser().value;
    	Ext.Ajax.request({
    		type : 'rest',
    		url : SERVERURL.GET_PACKET_DETAILS,
    		params : {
    			id:record.data.ID
    		},
    		method : 'GET',
    		success : function(form, action) {
    			var res = Ext.JSON.decode(form.responseText);

    			var serviceField =  sForm.findField('serviceProvideId');
    			var serviceStore = serviceField.getStore();
    			
    			sForm.findField('id').setValue(res.id);
    			if(!isNullOrEmpty(userId ) && !isNullOrEmpty(userValue)){
    				sForm.findField('sentByName').setValue(userValue);
    			}
    			if(!isNullOrEmpty(res.consignmentNo )){
    				sForm.findField('conRefNo').setValue(res.consignmentNo);
    			}
    			if(!isNullOrEmpty(record.data.SENT_DATE)){
//    				var  dt = Ext.Date.parse(record.data.SENT_DATE, "d/m/Y");
//    				var date = Ext.Date.format(new Date(dt),CONSTANTS.DATE_FORMAT);
    				sForm.findField('sentDate').setValue(record.data.SENT_DATE);
    			}

    			if(!isNullOrEmpty(res.packetNo)){
    				sForm.findField('packNo').setValue(res.packetNo);
    			}
    			if(!isNullOrEmpty(res.serviceProvider)){
    				serviceStore.load({
    					callback : function(records, operation, success) {
    						if (success) {
    							serviceField.setValue(res.serviceProvider.id);
    						}
    					}
    				});
    			}
    			if(!isNullOrEmpty(res.studentAddress)){
    				sForm.findField('remarks').setValue(res.studentAddress);					   
    			}
    		}
    	});
    	}else{
			 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		 }
    },
    /***
     * getStudentAddress function checks student address already exists or not,
     * if yes then populate on remarks field
     */
    getStudentAddress:function($this, newValue, oldValue, eOpts ){
    	var me = this;
    	var form =  me.getSentStudentsmd().getForm();
    	var remarksField = form.findField('remarks');
    	if(newValue){
    		var grid = me.getSearchresultgrid();
    		var selected = grid.selModel.getSelection();
    		var studentId = selected[0].data.STUDENT_ID;
    		Ext.Ajax.request({
    			type : 'rest',
    			url : SERVERURL.PAYMENT_STUDENT_FO_FLYOUT_INFO,
    			params : {
    				studentId:studentId
    			},
    			method : 'GET',
    			success : function(form, action) {
    				var res = Ext.JSON.decode(form.responseText);
    				if(!isNullOrEmpty(res.addressText)){
    					remarksField.setValue(res.addressText);   
    				}
    			}
    		});
    	}else{
    		remarksField.reset();
    	}
    },
    saveSentSmdStaus:function(){
    	var $this = this;
    	var grid = $this.getSearchresultgrid();
    	var form =  $this.getSentStudentsmd().getForm();
    	var values = form.getValues();
    	var id=values.id;
    	var useCommAdd=values.useCommAdd;
    	// for bug v2d-22763
    	var userId = $this.getCurrentlyLoggedInUser().id;
     		var submitData = [];
     		if (grid.getSelectionModel().getCount() > 0) {
     			var selected = grid.selModel.getSelection();
     			if( selected.length > 0){
     				for(var i in selected){
     					if(id==selected[i].data.ID){
     					submitData.push({
     						"id":selected[i].data.ID,
     						"packetNo":values.packNo,
     						"packetStatus":'Sent',
     						"consignmentNo":values.conRefNo,
     						"sentBy":$this.getIdValueJson(userId),
     						"sentDate":values.sentDate,
     						"serviceProvider":$this.getIdValueJson(values.serviceProvideId),
     						"studentAddress":useCommAdd==true ? values.remarks:null,
     						"remarks":values.remarks,
     						"studentId":$this.getIdValueJson(selected[i].data.STUDENT_ID),
     						"invtDistributionList":$this.getIdValueJson(selected[i].data.INVENTORY_DISTRIBUTIONLIST_ID)
     					});
     				}
     				}	
     			}
     		}
     		submitUrl = SERVERURL.UPDATE_STUDY_MATERIAL_DISTRIBUTION;
     		Ext.Ajax.request({
     			type : 'rest',
     			url : submitUrl,
     			jsonData : submitData,
     			method : 'POST',
     			success : function(form, action) {
     				showSuccessMessage(getCourseTxCommonTranslation('STUDY_MATERIAL_DISTRIBUTION'),getCommonTranslation('SUCCESS'));
     				grid.getStore().reload();
     				$this.getSentstudentsmd().close();
     			}
     		});
    },
    openPacketWind:function(grid, rowIndex, record){
    	var $this = this;
    	var formWindow = $this.getPacketnosmd();
    	if (!formWindow) {
    		Ext.widget('packetnosmd');
    		formWindow = $this.getPacketnosmd();
    	}
    	formWindow.show();

    	var sForm = $this.getPacketNosmd().getForm();
    	Ext.Ajax.request({
    		type : 'rest',
    		url : SERVERURL.GET_PACKET_DETAILS,
    		params : {
    			id:record.data.ID
    		},
    		method : 'GET',
    		success : function(form, action) {
    			var res = Ext.JSON.decode(form.responseText);

    			var serviceField =  sForm.findField('serviceProvider');

    			if(!isNullOrEmpty(res.studentId.printName)){
    				sForm.findField('studentName').setValue(res.studentId.printName);
    			}
    			if(!isNullOrEmpty(res.sentBy.value)){
    				sForm.findField('sentBy').setValue(res.sentBy.value);
    			}
    			if(!isNullOrEmpty(res.consignmentNo )){
    				sForm.findField('conNo').setValue(res.consignmentNo);
    			}
    			if(!isNullOrEmpty(res.packetNo)){
    				sForm.findField('packNo').setValue(res.packetNo);
    			}
    			if(!isNullOrEmpty(res.serviceProvider)){
    				serviceField.setValue(res.serviceProvider.value);
    			}
    			if(!isNullOrEmpty(res.sentDate )){
    				sForm.findField('sentDate').setValue(dateRender(res.sentDate));
    			}
    			var store = $this.getPacketnosmdgrid().getStore();
    			store.getProxy().extraParams = {
    				id:record.data.ID
    			};
    			store.load();
    		}
    	});

    },
    
    exportUserList : function(exportUrl,filetype,whetherAll) {
        var quickSearchForm=this.getStudymaterialdistributionnewstructure(); 
        var searchResultGrid = this.getSearchresultgrid();
        var pagingtoolbaroptions = this.getSearchresultgrid().down('pagingtoolbar').getStore().lastOptions;
        var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
        var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
        var visibleColumns=this.getVisibleColumns(searchResultGrid);
        var reportTitle=getCommonTranslation('STUDY_MATERIAL_DISTRIBUTION_LIST');
        if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
                jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
         }
        searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
    },
    
    createSearchCriteriaString: function(searchForm) {
    	 var me=this;
        var formValues = new Array();
        formValues = searchForm.getValues();        
        var searchCriteriaString="";
        for (var key in formValues) {
        	var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = me.getJsonObject( key , value);
            	searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        return searchCriteriaString;
    },
		getJsonObject : function(key, value, additionalValue) {
			if (value != '' && value != null
					&& additionalValue == undefined) {
				return {
					"paramCode" : key,
					"paramValues" : [ value ]
				};
			} else if (value != '' && additionalValue != undefined) {
				return {
					"paramCode" : key,
					"paramValues" : [ value, additionalValue ]
				};
			}
		},
    

    disableMoreActionPivileges: function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	buttonsToolBar = gridReference.query('toolbar')[0];
    	var moreActionButton = gridReference.down('#spBtnMoreActions');
    	var dispatchFormItemIdBtn = gridReference.down('#dispatchFormItemId');
    	moreActionButton.setVisible(false);
    	dispatchFormItemIdBtn.setVisible(false);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'MOREACTIONS') {
    			var button = buttonsToolBar.query('#spBtnMoreActions')[0];
    			if(!isNullOrEmpty(button)){
    				moreActionButton.setVisible(true);
    			}        		
    		}
    		if (privilege === 'PRINT_DISPATCH_FORM') {
    			var button = buttonsToolBar.query('#dispatchFormItemId')[0];
    			if(!isNullOrEmpty(button)){
    				dispatchFormItemIdBtn.setVisible(true);
    			}        		
    		}
    	});
    },
    /********************** On Search of SMD CB************************************/
    loadSmdGrid:function(){
     	var quickSearchForm = this.getStudymaterialdistsearch();
     	quickSearchForm.down('#searchBtn').setDisabled(true);
 		var jsonFormatFormData = this.createJsonFormat(quickSearchForm);
 		var searchResultGrid = this.getSearchresultgrid();
 		var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
     	resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.STUDY_MATERIAL_DISTRIBUTION_REPORT_CONFIG_CODE);
     	searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData, quickSearchForm.down('#searchBtn'));
 	
     },
 	createJsonFormat:function(quickSearchForm){
 		var form = quickSearchForm.getForm();
 		var value = form.getValues();
 		
 		var academyLocationId = value.multiselectAcademyLocation;
			var alIds=[];
		var academyLocationIds; 
		if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
			for(var i in academyLocationId){
				if(Ext.isObject(academyLocationId[0])){
					alIds.push(academyLocationId[i].get("id"));
				}else{
					alIds.push(academyLocationId[i]);
				}
			}
			academyLocationIds = alIds.join();
		} else {
			alIds.push(this.getCurrentAcademyLocation());
			academyLocationIds = alIds.join();
		}
 		
		var values = new Object();
		values.configCode = CONSTANTS.CB.STUDY_MATERIAL_DISTRIBUTION_REPORT_VIEW_CODE;
		var searchcriteria = new Array();
		if(!isNullOrEmpty(value.programId)){
			searchcriteria.push({paramCode:"PROGRAM_ID", paramValues:[value.programId]});
		}
		if(!isNullOrEmpty(value.batchId)){
			searchcriteria.push({paramCode:"BATCH_ID", paramValues:[value.batchId]});
		}
		if(!isNullOrEmpty(value.periodId)){
			searchcriteria.push({paramCode:"PERIOD_ID", paramValues:[value.periodId]});
		}
		if(!isNullOrEmpty(value.sectionId)){
			searchcriteria.push({paramCode:"SECTION_ID", paramValues:[value.sectionId]});
		}
		if(!isNullOrEmpty(value.variant)){
			searchcriteria.push({paramCode:"COURSE_ID", paramValues:[value.variant]});
		}
		
		
		if(!isNullOrEmpty(value.studentName)){
			var studentName = form.findField('studentName');
			//var userId = studentName.valueModels[0].data.userId;
			var userId = studentName.valueModels[0].data.id;
			
			searchcriteria.push({paramCode:"STUDENT_ID", paramValues:[userId]});
		}
		if(!isNullOrEmpty(value.distributionId)){
			searchcriteria.push({paramCode:"DISTRIBUTION_LIST_ID", paramValues:[value.distributionId]});
		}
		if(!isNullOrEmpty(value.pacletNo)){
			searchcriteria.push({paramCode:"PACKET_NO", paramValues:[value.pacletNo]});
		}
		if(!isNullOrEmpty(value.consignmentRefNo)){
			searchcriteria.push({paramCode:"CONSIGNMENT_NO", paramValues:[value.consignmentRefNo]});
		}
		if(!isNullOrEmpty(value.serviceProvideId)){
			searchcriteria.push({paramCode:"SERVICE_PROVIDER_ID", paramValues:[value.serviceProvideId]});
		}
		if(!isNullOrEmpty(value.packetStatus)){
			searchcriteria.push({paramCode:"PACKET_STATUS", paramValues:[value.packetStatus]});
		}
		//var academyLocationId=this.getCurrentAcademyLocation();
		if(!isNullOrEmpty(academyLocationId)){
			searchcriteria.push({paramCode:"ACADEMY_LOCATION_ID", paramValues:[academyLocationIds]});
		}
		var fromDate;
		if(!isNullOrEmpty(value.fromDate)){
			fromDate = value.fromDate
		}else{
			if(!isNullOrEmpty(value.toDate)){
			myDate = Ext.Date.parse(value.toDate, "Y-m-d");
			fromDate = Ext.Date.add(myDate, Ext.Date.YEAR, -5);
		}
		}
		
		var toDate;
		if(!isNullOrEmpty(value.toDate)){
			toDate = value.toDate+" 23:59:59"
		}else{
			if(!isNullOrEmpty(value.fromDate)){	
				myDate = Ext.Date.parse(value.fromDate, "Y-m-d");
				toDate = Ext.Date.add(myDate, Ext.Date.YEAR, 5);
			}
		}
		
		if(!isNullOrEmpty(fromDate) && !isNullOrEmpty(toDate)){
			searchcriteria.push({paramCode:"SENT_DATE", paramValues:[fromDate,toDate]});
		}
		values.searchCriterias=searchcriteria;
		return values;
	},
	gridRenderFunction:function(grid){
		grid.addButtonToolbar();
		var calButton	={
				xtype : 'splitbutton',
				itemId:'spBtnMoreActions',
				text : getCommonTranslation('MOREACTIONS'),
				menu:[{
					text:getCourseTxCommonTranslation('UPDATE_STATUS'),
					itemId:'updateStatusId'
				}],
				listeners: { click: function() { this.showMenu(); } }
		};
		var calButton1	={
				xtype : 'button',
				itemId:'dispatchFormItemId',
				text : getCourseTxCommonTranslation('DISPATCH_FORM'),
		};
		
		grid.down('#functionButtonsToolbar').insert(4,calButton);
		grid.down('#functionButtonsToolbar').insert(5,calButton1);
	},
    getIdValueJson: function(id, value,code) {
    	if (id) return {
    		id: id,
    		value: value,
    		code: code
    	};
    },
    openReadingMaterialWin:function(grid, rowIndex, record){
    	var $this = this;
    	var formWindow = $this.getPacketnosmd();
    	if (!formWindow) {
    		Ext.widget('packetnosmd');
    		formWindow = $this.getPacketnosmd();
    	}
    	formWindow.show();

		$this.getPacketNosmd().down('#fieldcontainer1').setVisible(false);
		$this.getPacketNosmd().down('#fieldcontainer2').setVisible(false);
		
    	/*var sForm = $this.getPacketNosmd().getForm();
    	Ext.Ajax.request({
    		type : 'rest',
    		url : SERVERURL.GET_PACKET_DETAILS,
    		params : {
    			id:record.data.ID
    		},
    		method : 'GET',
    		success : function(form, action) {
				var res = Ext.JSON.decode(form.responseText);
    			$this.getPacketNosmd().down('#fieldcontainer1').setVisible(false);
    			$this.getPacketNosmd().down('#fieldcontainer2').setVisible(false);*/
    			/*var serviceField =  sForm.findField('serviceProvider');

    			if(!isNullOrEmpty(res.studentId.printName)){
    				sForm.findField('studentName').setValue(res.studentId.printName);
    			}
    			if(!isNullOrEmpty(res.sentBy.printName)){
    				sForm.findField('sentBy').setValue(res.sentBy.printName);
    			}
    			if(!isNullOrEmpty(res.consignmentNo )){
    				sForm.findField('conNo').setValue(res.consignmentNo);
    			}
    			if(!isNullOrEmpty(res.packetNo)){
    				sForm.findField('packNo').setValue(res.packetNo);
    			}
    			if(!isNullOrEmpty(res.serviceProvider)){
    				serviceField.setValue(res.serviceProvider.value);
    			}
    			if(!isNullOrEmpty(res.sentDate )){
    				sForm.findField('sentDate').setValue(res.sentDate);
    			}*/
    			
    			var store = $this.getPacketnosmdgrid().getStore();
    			store.getProxy().extraParams = {
    				id:record.data.ID
    			};
    			store.load();
//    		}
//    	});
     	
    },
    getDocumentController : function(){
    	var this$ = this;
    	return this$.getController('Academia.controller.document.DocumentController');
    },

    printStudentWiseDispatchForm:function(){
    	var $this = this;
    	var form = $this.getStudentsmdsearch().getForm();
    	var studentId = form.findField('studentName').getValue();

    	var grid = $this.getStudentsmdgrid();

    	var courseVariantId = [];
    	var courseId=[];
    	var readingId=[];
    	if (grid.getSelectionModel().getCount() > 0) {
    		var selected = grid.selModel.getSelection();

    		if( selected.length > 0){
    			for(var i in selected){
    				courseVariantId.push(
    						selected[i].data.courseVariantId
    				);
    				courseId.push(
    						selected[i].data.courseId
    				);
    				readingId.push(
    						selected[i].data.readingId+""
    				);
    			}	

    		}
    	}
    	
    	 user=$this.getCurrentlyLoggedInUser();
		   var code ="STUDENT_WISE_DISPATCH_FORM";
		   var contentPanel=$this.getContentpanel();
		   //var studentId=contentPanel.getActiveTab().userId;
		   //var studentPersonId=contentPanel.getActiveTab().personId;
		   var reportParams =new Object();
		   var title= contentPanel.getActiveTab().title+"-"+ new Date().getTime();
		   var courseVarIds=courseVariantId.join();
		   var courseIds=courseId.join();
		   reportParams.reportTitle=title;
		   reportParams.userId=user.id;
		   reportParams.studentId=studentId;
		   reportParams.courseVarId=courseVarIds;
		   reportParams.courseId=courseIds;
		   reportParams.userName=user.value;
		   //reportParams.studentPersonId = studentPersonId;
		   //reportParams.academyLocationId = $this.getCurrentAcademyLocation();
		   reportParams.code = code;
		   reportParams.readingId = readingId;
		   var exportUrl = SERVERURL.PRINT_STUDENT_WISE_DISPATCH_FORM;
		   $this.exportJRXMLReport(code,reportParams,title,'.pdf',exportUrl);


    },
    /*Generate dispatch form for course wise DL*/
    genrateCourseWiseDispatchForm:function(){
    	var $this = this;
    	var form = $this.getCoursesmdsearch().getForm();
    	var programId = form.findField('programId').getValue();
    	var batchId = form.findField('batchId').getValue();
    	var periodId = form.findField('periodId').getValue();
    	var sectionId = form.findField('sectionId').getValue();

    	var grid = $this.getCoursesmdgrid();
    	var disributionId = grid.down('#disributionId').getValue();

    	var studentIds = [];
    	if (grid.getSelectionModel().getCount() > 0) {
    		var selected = grid.selModel.getSelection();

    		if( selected.length > 0){
    			for(var i in selected){
    				studentIds.push(
    						selected[i].data.studentId
    				);
    			}	

    		}
    	}
    	
    	 user=$this.getCurrentlyLoggedInUser();
		   var code ="STUDENT_WISE_DISPATCH_FORM";
		   var contentPanel=$this.getContentpanel();
		   var reportParams =new Object();
		   var title= contentPanel.getActiveTab().title+"-"+ new Date().getTime();
		   var studentId=studentIds.join();
	    	
		   var submitData = null;
		   var submitData = {
			   "reportTitle":title,
			   "userId":user.id,
			   "programId":programId,
			   "batchId":batchId,
			   "periodId":periodId,
			   "sectionIds":sectionId,
			   "listId":disributionId,
			   "studentIds":studentIds,
			   "userName":user.value,
			   "userCode":user.code,
			   "code":code
		   };
		   submitUrl = SERVERURL.PATH_EXPORT_COURSE_WISE_DISPATCH_FORM;
		   Ext.Ajax.request({
			   type : 'rest',
			   url : submitUrl,
			   jsonData : submitData,
			   method : 'POST',
			   success : function(form, action) {
				   showSuccessMessage(getCourseTxCommonTranslation('DISPATCH_DOCUMENT_GENRATE'),getCommonTranslation('SUCCESS'));
				   grid.getStore().reload();
			   }
		   });
    },
    printStudentWiseMaterialDistributionDispatchForm:function(grid){
    	var $this = this;
    	var form = $this.getStudymaterialdistsearch().getForm();
    	var programId = form.findField('programId').getValue();
    	var batchId = form.findField('batchId').getValue();
    	var periodId = form.findField('periodId').getValue();
    	var sectionId = form.findField('sectionId').getValue();
    	var studentIds = [];
    	var ids=[];
    	if (grid.getSelectionModel().getCount() > 0) {
    		var selected = grid.selModel.getSelection();
    		
    		if( selected.length > 0){
    			for(var i in selected){
    				/*studentIds.push(
    						selected[i].data.STUDENT_ID
    				);*/
    				ids.push(
    						selected[i].data.ID
    				);
    				
    			}	

    		}
    	}
    	
    	user=$this.getCurrentlyLoggedInUser();
		   var code ="STUDENT_WISE_DISPATCH_FORM";
		   var contentPanel=$this.getContentpanel();
		   var reportParams =new Object();
		   var title= contentPanel.getActiveTab().title+"-"+ new Date().getTime();
		  // var studentId=studentIds.join();
		   var submitData = null;
		   var submitData = {
			   "reportTitle":title,
			   "userId":user.id,
			   "programId":programId,
			   "batchId":batchId,
			   "periodId":periodId,
			   "sectionIds":sectionId,
			  // "studentIds":studentIds,
			   "userName":user.value,
			   "userCode":user.code,
			   "code":code,
			   "ids" :ids
		   };
		   submitUrl = SERVERURL.PRINT_DISTRIBUTION_DISPATCH_FORM;
		   Ext.Ajax.request({
			   type : 'rest',
			   url : submitUrl,
			   jsonData : submitData,
			   method : 'POST',
			   success : function(form, action) {
				   showSuccessMessage(getCourseTxCommonTranslation('DISPATCH_DOCUMENT_GENRATE'),getCommonTranslation('SUCCESS'));
				   grid.getStore().reload();
			   }
		   });
 },
	 /**
	  * Download all dispatch form generation
	  */
	 downloadAllDispatchFormsZip:function(){
		 var $this=this;
		 var courseGrid=$this.getCoursesmdgrid();
		 if (courseGrid.getSelectionModel().getCount() > 0) {
			 //courseGrid.getSelectionModel().deselectAll();
			 var records = courseGrid.getSelectionModel().getSelection();
			 var saveModel=[];  

			 var dispatchZipName = "DispatchForm"+records[0].get('documentPath');
			 for(var i in records){
				 if(!isNullOrEmpty(records[i].get('documentPath'))) {
					 saveModel.push(records[i].get('documentPath'));
				 }
			 }
			 showConfirmMessage(getCourseTxCommonTranslation('DISPATCH_DOCUMENT'),getCourseTxCommonTranslation('DISPATCH_DOCUMENT_ALERT'),function(btn, text) {
				 if (btn == 'yes') {
					 var directoryType = CONSTANTS.DIRECTORY_TYPE_DISPATCHFORM;
					 $this.getDocumentController().downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
				 }});
		 }else {
			 $this.hideWindowMask();
			 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		 }
	 },
	 /**
      * Enable disable check for download all button.
      */
	 enableDisableDownloadAllBtn : function(grid,records) {
		 var studentGrid=this.getCoursesmdgrid();
		 if (studentGrid.getSelectionModel().getCount() > 0) {
			 //studentGrid.getSelectionModel().deselectAll();
			 var records = studentGrid.getSelectionModel().getSelection();
			 var studentFlag = false; 
			 for(var i in records){
				 if(!isNullOrEmpty(records[i].get('documentPath'))){
					 var buttonsToolBar = grid.query('toolbar')[0];
					 var downloadButton = buttonsToolBar.query('#btnDownloadDispatchForms')[0];
					 downloadButton.enable();
				 }
			 }
		 }  
	 },
	 disableStudyMaterialListPivileges: function(structure,permissionsMap) {
	    	var associatedAcadLocationIds = new Array();
	    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	    	var sendMaterialBtn = structure.down('#btnAddSentMaterial');
	    	if(!isNullOrEmpty(sendMaterialBtn)){
	    	sendMaterialBtn.setVisible(false);
	    	}
	    	var printCourseDispatchBtn = structure.down('#printCourseDispatchForm');
	    	if(!isNullOrEmpty(printCourseDispatchBtn)){
	    	printCourseDispatchBtn.setVisible(false);
	    	}
	    	var downloadAllBtn = structure.down('#btnDownloadDispatchForms');
	    	if(!isNullOrEmpty(downloadAllBtn)){
	    	downloadAllBtn.setVisible(false);
	    	}
	    	var printStudentDispatchBtn = structure.down('#printDispatchForm');
	    	if(!isNullOrEmpty(printStudentDispatchBtn)){
	    	printStudentDispatchBtn.setVisible(false);
	    	}
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'SENDMATERIAL') {
	        		if(!isNullOrEmpty(sendMaterialBtn)){
	        			sendMaterialBtn.setVisible(true);
	        		}        		
	        	}
	    		if (privilege === 'PRINT_DISPATCH_FORM') {
	        		if(!isNullOrEmpty(printCourseDispatchBtn)){
	        			printCourseDispatchBtn.setVisible(true);
	        		}
	        		if(!isNullOrEmpty(printStudentDispatchBtn)){
	        			printStudentDispatchBtn.setVisible(true);
	        		}
	        	}
	    		if (privilege === 'DOWNLOAD_ALL') {
	        		if(!isNullOrEmpty(downloadAllBtn)){
	        			downloadAllBtn.setVisible(true);
	        		}        		
	        	}
	    	});
	    },
});
