Ext.define('Academia.controller.coursetransaction.viewschedule.ViewScheduleController', {
	extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',
    stores: ['attendance.StudentCourses','course.coursetopic.CourseComponentStore','common.ProgramByAcademyLocationStore',
             'attendance.SectionByCourseNComponent','enquiry.AcademicBatchStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
             'attendance.SectionAndFacultyByPeriodID','coursetransaction.coursereading.CourseByPeriod','attendance.FacultyCodeSmartSearch',
             'attendance.FacultyNameSmartSearch','attendance.StudentSearch','coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch',
             'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoom','Academia.store.common.AcademicTermStore',
             'common.AssignedProgramStore','programCourseDashboard.ScheduleGridStore','course.AssignedPeriodCoursesFacultyStore',
             'program.programDetails.programBatches.courseParameter.FacultyCombo','Academia.store.common.IntakeYearStore',
             'programCourseDashboard.ActiveStudentStore','resourceutilization.ResourcesStore','program.programbatchdetail.BatchStore',
             'coursetransaction.sectionmanagement.SectionGroup','programCourseDashboard.ProgramsBySectionGroupIdStore','enquiry.AcademicBatchForSectionGroupStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
             'coursetransaction.sectionmanagement.GetProgramPeriodListing','coursetransaction.sectionmanagement.GetCourseVariantListing'],
    views: ['coursetransaction.viewschedule.ViewScheduleSearch','coursetransaction.viewschedule.ViewScheduleStructure',
            'coursetransaction.viewschedule.ViewScheduleCalendar','coursetransaction.viewschedule.ViewScheduleMainStructure',
            'coursetransaction.viewschedule.ViewScheduleGridStructure','coursetransaction.viewschedule.ViewScheduleGrid',
            'coursetransaction.sectionmanagement.MappedCourseVariantGrid','coursetransaction.sectionmanagement.MappedProgramPeriodGrid',
            'coursetransaction.sectionmanagement.SectionGroupCourseVariantDetail','coursetransaction.sectionmanagement.SectionGroupProgramDetail',
            ],
            config: {
            	MASTER_TIME_TABLE_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MASTER_TIME_TABLE_PRIVILEGES'),
            	VIEWSCHEDULE_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('VIEWSCHEDULE_PRIVILEGES'),
            },
    refs: [{
        ref: 'viewschedulesearch',
        selector: 'viewschedulesearch'
    },{
        ref: 'viewschedulestructure',
        selector: 'viewschedulestructure'
    },{
        ref: 'viewschedulecalendar',
        selector: 'viewschedulecalendar'
    },{
 	   ref: 'organizationunit',
 	   selector: 'organizationunit[itemId=viewScheduleOrgranizationStructureItemId]'
    },
    {
   	 ref : 'sectiongroupprogramdetail',
	 selector : 'sectiongroupprogramdetail'
     },
     {
	 ref : 'sectiongroupcoursevariantdetail',
	 selector : 'sectiongroupcoursevariantdetail'
     },
     {
    	 ref : 'mappedProgramPeriodGrid',
    	 selector : 'mappedprogramperiodgrid'
     },
     {
    	 ref : 'mappedCourseVariantGrid',
    	 selector : 'mappedcoursevariantgrid'
     },{
        ref: 'viewschedulegrid',
        selector: 'viewschedulegrid'
    },{
        ref: 'viewschedulegridstructure',
        selector: 'viewschedulegridstructure'
    }, {
    	ref: 'viewschedulemainstructure',
    	selector: 'viewschedulemainstructure'
    }],
    init: function(application) {
    	this.control({
    		'viewschedulesearch radiogroup[itemId=courseSectionRadio_Id]' : {
    			change : function(cb, nv, ov) {
    				this.sectionDropDown(cb, nv, ov);
    			}
    		},'viewschedulestructure':{
    			afterrender : function(structure){
    				var me = this;
    				var this$ = this;
    				var viewScheduleSearchForm=this.getViewschedulestructure().down('#viewScheduleSearchItemId');
    				permissionsMap = this.getVIEWSCHEDULE_PRIVILEGES();
    				this.disableRadioSelectionsPivilegesOnScheduleSearchForm(viewScheduleSearchForm, permissionsMap);
    		        var calendar = structure.down('#viewCalendarId');
    		       // calendar.setActiveView(calendar.itemid + '-week');
    		        
    				structure.down('viewschedulecalendar').on('render', function(obj){
    					permissionsMap=me.getVIEWSCHEDULE_PRIVILEGES();
    					var associatedAcadLocationIds = new Array();
    					setTimeout(function(){
    						associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
    						var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    						var exportBtn = obj.down('#exportToPngBtn');
    						if(Ext.Array.contains(permissionList, 'EXPORT_TO_PNG')){
    							exportBtn.setVisible(true);
    						}
    						else {
    							exportBtn.setVisible(false);
    						}
    					},300);
    				});
    			}
    		},
    		'viewschedulesearch customcombobox#course_Id' : {
    			select : function(obj, record) {
    				var courseId = record[0].get("courseId");
    				this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(false);
    				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);
    				var academicTermId=this.getViewschedulesearch().down("#courseAcademicTerm").getValue();
    				var sectionBox = this.getViewschedulesearch().down('customcombobox#courseSection_Id');
    				sectionBox.clearValue();
    				if(record[0].get("sectionAtComponentLevel")){
    					courseComponentBox.show();
    					courseComponentBox.allowBlank = false;
    					sectionBox.setDisabled(true);
    					var store = courseComponentBox.getStore();
    					store.getProxy().extraParams = {
    						id: courseId
    					};
    					store.load();
    				}
    				else{
    					var courseComboBox = this.getViewschedulesearch().down('customcombobox#courseSection_Id');
    					courseComboBox.clearValue();
    					sectionBox.setDisabled(false);
    					var courseStore = courseComboBox.getStore();
    					courseStore.getProxy().extraParams = {
    						parentCourseId: courseId,
    						academicTermId:academicTermId
    					};
    					courseStore.load();
    				}
    			}
    		},
    		'viewschedulesearch customcombobox#programAcademicTerm' : {
    			select : function(obj, record) {
    				var academicTermId = record[0].get("id");
    				
    				var programComboBox = this.getViewschedulesearch().down('#program_Id');
    				academyLocationIds = this.getAcademyLocationIds();
    				programComboBox.clearValue();
    				programComboBox.setDisabled(false);
    				var programStore = programComboBox.getStore();
    				programStore.getProxy().extraParams = {
    					academyLocationIds : academyLocationIds,
    					academicTermId : academicTermId
    				};
    				programStore.load();
    				var sectionBox = this.getViewschedulesearch().down('customcombobox#programCoursesection_ID');
    				var periodBox = this.getViewschedulesearch().down('customcombobox#period_Id');
    				var batchComboBox = this.getViewschedulesearch().down('customcombobox#batch_Id');
    				var courseComboBox = this.getViewschedulesearch().down("#courseId");
    				sectionBox.clearValue();
    				periodBox.clearValue();
    				sectionBox.setDisabled(true);
    				periodBox.setDisabled(true);
    				batchComboBox.clearValue();
    				batchComboBox.setDisabled(true);
    				courseComboBox.clearValue();
    				courseComboBox.setDisabled(true);
    				var organizationUnitController =  Academia.app.getController('programCourseDashboard.organizationUnit.organizationUnitController');
    		    	var organizationUnitForm = organizationUnitController.getOrganizationunit().getForm();
    		    	var academyLocation;
    		    	var values = organizationUnitForm.getValues();
    		    	
    		    	var mAL = values.multiselectAcademyLocation;
    				
    		    	if(mAL==""){
    		    		this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(true);
        				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(false);
    		    		
    		    	}
    		    	else{
    		    		this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(false);
        				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);
    		    	}

    				
    			}
    		},
    		// program batch course section	
    		'viewschedulesearch customcombobox#program_Id' : {
    			select : function(obj, record) {
    				var programId = record[0].get("id");
    				this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(false);
    				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);
    				var batchComboBox = this.getViewschedulesearch().down('customcombobox#batch_Id');
    				batchComboBox.clearValue();
    				batchComboBox.setDisabled(false);
    				var batchStore = batchComboBox.getStore();
    				batchStore.getProxy().extraParams = {
    					id: programId
    				};
    				batchStore.load();
    				var sectionBox = this.getViewschedulesearch().down('customcombobox#programCoursesection_ID');
    				var periodBox = this.getViewschedulesearch().down('customcombobox#period_Id');
    				var courseComboBox = this.getViewschedulesearch().down("#courseId");
    				sectionBox.clearValue();
    				periodBox.clearValue();
    				sectionBox.setDisabled(true);
    				periodBox.setDisabled(true);
    				courseComboBox.clearValue();
    				courseComboBox.setDisabled(true);
    			}
    		},
    		'viewschedulesearch customcombobox#batch_Id' : {
    			select : function(obj, record) {
    				var batch_Id = record[0].get("id");
    				var academicTermId = this.getViewschedulesearch().down("#programAcademicTerm").getValue();
    				this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(false);
    				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);
    				var periodComboBox = this.getViewschedulesearch().down('customcombobox#period_Id');
    				periodComboBox.clearValue();
    				periodComboBox.setDisabled(false);
    				var periodStore = periodComboBox.getStore();
    				periodStore.getProxy().extraParams = {
    					id: batch_Id,
    					academicTermId : academicTermId
    				};
    				periodStore.load();
    				var sectionBox = this.getViewschedulesearch().down('customcombobox#programCoursesection_ID');
    				var courseComboBox = this.getViewschedulesearch().down("#courseId");
    				sectionBox.clearValue();
    				sectionBox.setDisabled(true);
    				courseComboBox.clearValue();
    				courseComboBox.setDisabled(true);
    			}
    		},
    		'viewschedulesearch customcombobox#period_Id' : {
    			select : function(obj, record) {
    				var period_Id = record[0].get("id");
    				this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(false);
    				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);
    				this.getViewschedulesearch().down("#programCoursesection_ID").setDisabled(false);
    				var store = this.getStore('attendance.SectionAndFacultyByPeriodID');
    				store.getProxy().extraParams = {
    					periodId:period_Id
    				};
    				store.load();
    				var courseComboBox = this.getViewschedulesearch().down("#courseId");
    				courseComboBox.clearValue();
    				courseComboBox.setDisabled(true);
    			}
    		},
    		'viewschedulesearch customcombobox#programCoursesection_ID' : {
    			select : function(obj, record) {
    				var sectionId = record[0].get("sectionId");
    				var periodId = this.getViewschedulesearch().down("#period_Id").getValue();
    				this.getViewschedulesearch().down("#courseId").setDisabled(false);
    				this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(false);
    				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);
    				var store = this.getStore('coursetransaction.coursereading.CourseByPeriod');
    				store.getProxy().extraParams = {
    					periodId:periodId,
    					sectionId:sectionId
    				};
    				store.load();
    			}
    		},
    		'viewschedulesearch customcombobox#courseId' : {
    			select : function(obj, record) {
    				var courseVariantPBS = record[0].get("id");
    				this.getViewschedulesearch().getForm().findField('courseVariantPBS').setValue(courseVariantPBS);
    				this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(true);
    				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(false);

    			}
    		},
    		'viewschedulesearch customcombobox#courseSection_Id' : {
    			select : function(obj, record) {
    				var courseVariantId = record[0].get("courseVariantId");
    				var form = this.getViewschedulesearch().getForm();
    				form.findField('courseVariantId').setValue(courseVariantId);
    				this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(true);
    				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(false);

    			}
    		},
    		'viewschedulesearch button[itemId=viewCalanderId]' : {
    			click : function() {
    				this.openCalendarWin();
    			}
    		},
    		'viewschedulesearch button[itemId=scheduleResetBtn]' : {
    			click : function() {
    				this.resetSchedule();
    			}
    		},
    		'viewschedulesearch button[itemId=scheduleSearchBtn]' : {
    			click : function() {
    				this.getSchedules();
    			}
    		},
    		'organizationunit[itemId=viewScheduleOrgranizationStructureItemId] radiogroup[itemId=organizationRadioUnitId]': {
    			change:function(obj,record){
    				this.organizationUnitChange(obj,record);
    			},
    			render:function(obj){
    				var permission = this.getVIEWSCHEDULE_PRIVILEGES();
    				this.organizationUnitChange(obj,null,permission);
    			}
    		},
    		'organizationunit[itemId=viewScheduleOrgranizationStructureItemId] button[itemId=resetBtn]': {
    			click:function(obj,record){ 
    				this.resetOrganizationunit(obj);
    			}
    		},
    		'viewschedulegrid button[itemId=scheduleCalendarViewId]':{
    			click : function() {
    				this.openCalendarView();
    			}
    		},'viewschedulegrid':{
   			 cellclick: function (grid, cell, cellIndex, record, row, rowIndex, e) {
				 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				
				 if(columnName==='periodCount'){
					 if(e.target.tagName=='A'){
						 this.getAllProgramBatchPeriod(record);
					 }
				 }
				 
				 if(columnName==='courseVariantCount'){
					 if(e.target.tagName=='A'){
						 this.getAllCoursesCourseVariant(record);
					 }
				 }
				 
				
			 }
		 },
    		'viewschedulesearch customcombobox#courseAcademicTerm' : {
    			select : function(obj, record) {
    				var academicTermId = record[0].get("id");
    				
    				
    				if(this.getViewschedulesearch().getValues().sectionCourse == 'student'){
    					var intakeYearId = this.getViewschedulesearch().down('#intakeYear').getValue();
    					var programComboBox = this.getViewschedulesearch().down('#student_program_Id');
    					var studentStore = this.getViewschedulesearch().down('#studentId').getStore();
    					academyLocationIds = this.getAcademyLocationIds();
    					programComboBox.clearValue();
    					var programStore = programComboBox.getStore();
    					programStore.getProxy().extraParams = {
    						academyLocationIds : academyLocationIds,
    						academicTermId : academicTermId,
    						intakeYearId : intakeYearId,
    					};
    					programStore.load();
    					studentStore.getProxy().extraParams ={
    						academyLocationIds : academyLocationIds,
    						intakeYearId : intakeYearId,
    						academicTermId : academicTermId,
    					}
    					studentStore.load();
    				} else{
    					var organizationUnitController =  Academia.app.getController('programCourseDashboard.organizationUnit.organizationUnitController');
        		    	var organizationUnitForm = organizationUnitController.getOrganizationunit().getForm();
        		    	var academyLocation;
        		    	var values = organizationUnitForm.getValues();
        		    	
        		    	var mAL = values.multiselectAcademyLocation;
        		    	if( mAL.length == 1 && mAL==""){
        		  
        		    		this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(true);
            				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(false);
        		    		
        		    	}
        		    	else{
        		    		this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(false);
            				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);
        		    	}
    					
    					var courseComboBox = this.getViewschedulesearch().down('#course_Id');
    					academyLocationIds = this.getAcademyLocationIds();
    					courseComboBox.clearValue();
    					courseComboBox.setDisabled(false);
    					var courseStore = courseComboBox.getStore();
    					courseStore.getProxy().extraParams = {
    						academyLocationIds : academyLocationIds,
    						academicTermId : academicTermId,
    						sectionType : 'CourseSection',
    						isCurrentPeriod : false
    					};
    					courseStore.load();
    					var sectionBox = this.getViewschedulesearch().down('customcombobox#courseSection_Id');
    					sectionBox.clearValue();
    					sectionBox.setDisabled(true);
    				}
    			}
    		},
    		'viewschedulesearch customcombobox#intakeYear' : {
    			select : function(obj, record) {
    				var intakeId = record[0].get("id");
    				var programComboBox = this.getViewschedulesearch().down('#student_program_Id');
    				var studentStore = this.getViewschedulesearch().down('#studentId').getStore();
    				academyLocationIds = this.getAcademyLocationIds();
    				programComboBox.clearValue();
    				var programStore = programComboBox.getStore();
    				programStore.getProxy().extraParams = {
    					academyLocationIds : academyLocationIds,
    					intakeYearId : intakeId,
    				};
    				programStore.load();
    				studentStore.getProxy().extraParams ={
    					academyLocationIds : academyLocationIds,
    					intakeYearId : intakeId,
    				}
    				studentStore.load();
    			}
    		},
    		'viewschedulesearch customcombobox#student_program_Id' : {
    			select : function(obj, record) {
    				var $this = this;
    				var programId = record[0].get("id");
    				var batchComboBox = this.getViewschedulesearch().down('customcombobox#student_batch_Id');
    				var studentStore = this.getViewschedulesearch().down('#studentId').getStore();
    				batchComboBox.clearValue();
    				batchComboBox.setDisabled(false);
    				var batchStore = batchComboBox.getStore();
    				batchStore.getProxy().extraParams = {
    					id: programId
    				};
    				batchStore.load();
    				studentStore.getProxy().extraParams ={
    					academyLocationIds : $this.getAcademyLocationIds(),
    					programId : programId
    				}
    				studentStore.load();
    				var periodBox = this.getViewschedulesearch().down('customcombobox#student_period_Id');
    				periodBox.clearValue();
    				periodBox.setDisabled(true);
    			}
    		},
    		'viewschedulesearch customcombobox#student_batch_Id' : {
    			select : function(obj, record) {
    				var $this = this;
    				var batch_Id = record[0].get("id");
    				var academicTermId = this.getViewschedulesearch().down("#courseAcademicTerm").getValue();
    				var periodComboBox = this.getViewschedulesearch().down('customcombobox#student_period_Id');
    				var studentStore = this.getViewschedulesearch().down('#studentId').getStore();
    				periodComboBox.clearValue();
    				periodComboBox.setDisabled(false);
    				var periodStore = periodComboBox.getStore();
    				periodStore.getProxy().extraParams = {
    					id: batch_Id,
    					academicTermId : academicTermId
    				};
    				periodStore.load();
    				studentStore.getProxy().extraParams ={
    					academyLocationIds : $this.getAcademyLocationIds(),
    					batchId : batch_Id
    				}
    				studentStore.load();
    			}
    		},
    		'viewschedulesearch customcombobox#student_period_Id' : {
    			select : function(obj, record) {
    				var $this = this;
    				var period_Id = record[0].get("id");
    				var studentStore = this.getViewschedulesearch().down('#studentId').getStore();
    				this.getViewschedulesearch().down("#studentId").setDisabled(false);
    				studentStore.getProxy().extraParams ={
    					academyLocationIds : $this.getAcademyLocationIds(),
    					periodId : period_Id
    				}
    				studentStore.load();
    			}
    		},
    		'viewschedulesearch customcombobox#facultyId_itemId' : {
    			select : function(obj, record) {
    				var courseVariantPBS = record[0].get("id");
    				this.getViewschedulesearch().getForm().findField('courseVariantPBS').setValue(courseVariantPBS);
    				this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(true);
    				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(false);
    			}
    		},
    		'viewschedulesearch customcombobox#studentId' : {
    			select : function(obj, record) {
    				this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(true);
    				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(false);
    			}
    		},
    		'viewschedulesearch customcombobox#roomId' : {
    			select : function(obj, record) {
    				this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(true);
    				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(false);
    			}
    		},
    		'organizationunit[itemId=viewScheduleOrgranizationStructureItemId] combo[itemId=academyLocationId]': {
    			change: function() {
    				this.loadDataOfAcademyLocation();
    			}
    		},
    		'organizationunit[itemId=viewScheduleOrgranizationStructureItemId] combo[itemId=multiselectAcademyLocationId]': {
    			change: function() {
    				this.loadDataOfAcademyLocation();
    			}
    		},
    		'viewschedulesearch customcombobox#sectionGroupAcademicTerm' : {
    			select : function(obj, record) {
    				    var academicTermId = record[0].get("id");
    				    academyLocationIds = this.getAcademyLocationIds();
    				    
    				    var organizationUnitController =  Academia.app.getController('programCourseDashboard.organizationUnit.organizationUnitController');
        		    	var organizationUnitForm = organizationUnitController.getOrganizationunit().getForm();
        		    	var academyLocation;
        		    	var values = organizationUnitForm.getValues();
        		    	
        		    	var mAL = values.multiselectAcademyLocation;
        		    	if( mAL.length == 1 && mAL==""){
        		  
        		    		this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(true);
            				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(false);
        		    		
        		    	}
        		    	else{
        		    		this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(false);
            				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);
        		    	}
    					var programComboBox = this.getViewschedulesearch().down('#sectionGroupProgramId');
    					var sectionGroupComboBox = this.getViewschedulesearch().down('#sectionGroupId');
    					programComboBox.clearValue();
    					sectionGroupComboBox.setDisabled(false);
    					var sectionGroupStore=sectionGroupComboBox.getStore();
    					sectionGroupStore.getProxy().extraParams = {
    						academyLocationIds : academyLocationIds,
    						academicTermId : academicTermId,
    					};
    					sectionGroupStore.load();
    					
    					programComboBox.clearValue();
    					programComboBox.setDisabled(false);
    					var programStore = programComboBox.getStore();
    					programStore.getProxy().extraParams = {
    						academyLocationIds : academyLocationIds,
    						academicTermId : academicTermId,
    						
    					};
    					programStore.load();
    					var courseComboBox = this.getViewschedulesearch().down('#sectionGroupcourse_Id');
    					courseComboBox.clearValue();
    					courseComboBox.setDisabled(false);
    					var courseStore = courseComboBox.getStore();
    					courseStore.getProxy().extraParams = {
    						academyLocationIds : academyLocationIds,
    						academicTermId : academicTermId,
    						//sectionType : 'CourseSection',
    						//isCurrentPeriod : false
    					};
    					courseStore.load();
    					
    			
    			}
    		
    		},'viewschedulesearch customcombobox#sectionGroupId' : {
    			select : function(obj, record) {
    				 var sectionGroupId = record[0].get("id");
 					 this.getViewschedulesearch().down('#viewCalanderId').setDisabled(false);
 					 this.getViewschedulesearch().down('#scheduleSearchBtn').setDisabled(true);
    			}
    		},'viewschedulesearch combo#sectionGroupProgramId': {
			    select: function(obj, record) {
			        var programId = record[0].get("id");
			        if (programId > 0) {
			            var form = this.getViewschedulesearch();
			            var academicTermId=form.down('#sectionGroupAcademicTerm').getValue();
			            form.down("#sectionGroupBatchId").setDisabled(false);
			            var store = form.down("#sectionGroupBatchId").getStore();
			            store.getProxy().extraParams = {
			                id: programId,
			                //isActive: true
			            };
			            store.load();
			            form.down("#sectionGroupPeriodId").setDisabled(true);
			            form.down("#sectionGroupPeriodId").clearValue();
			            var courseComboBox = this.getViewschedulesearch().down('#sectionGroupcourse_Id');
    					courseComboBox.clearValue();
    					courseComboBox.setDisabled(false);
    					var courseStore = courseComboBox.getStore();
    					courseStore.getProxy().extraParams = {
    						academyLocationIds : academyLocationIds,
    						academicTermId : academicTermId,
    						programId : programId
    						//sectionType : 'CourseSection',
    						//isCurrentPeriod : false
    					};
    					courseStore.load();
			        }
			    }
			},
			'viewschedulesearch combo#sectionGroupBatchId': {
			    select: function(obj, record) {
			        var batchId = record[0].get("id");
			        if (batchId > 0) {
			            var form = this.getViewschedulesearch();
			            form.down("#sectionGroupPeriodId").setDisabled(false);
			            if(form.down("#sectionGroupPeriodId").getStore().storeId=="ext-empty-store"){
			            	var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
				            form.down("#sectionGroupPeriodId").bindStore(store);
			            }
			            else{
				            var store = form.down("#sectionGroupPeriodId").getStore();
			            }
			            store.getProxy().extraParams = {
			                id: batchId,
			                //isCurrentPeriod: true
			            };
			            store.load();
			        }
			    }
			},'viewschedulesearch customcombobox#sectionGroupcourse_Id' : {
   			 select : function(obj, record) {
				 var courseId = record[0].get("id");
				 this.getViewschedulesearch().getForm().findField('SECTION_GROUP_COURSE_VARIENT_NAME').setDisabled(false);
				 var courseVariantComboBox = this.getViewschedulesearch().down('combo#sectionGroupCourseVariantId');
				 courseVariantComboBox.clearValue();
				 var currentAcademyLocation = this.getCurrentAcademyLocation();
				 var courseVariantStore = courseVariantComboBox.getStore();
				 courseVariantStore.getProxy().extraParams = {
					 courseId : courseId,
					 //academyLocationId : currentAcademyLocation 											
				 };
				 courseVariantStore.load();
			 }
		 },
    	});
    },
    /**
     * This function is used to open calendar window on click view schedule button from filter
     */
    openCalendarWin:function(){
    	var $this =this;
    	var structure = $this.getViewschedulestructure();
    	structure.down('#viewScheduleGridStructureItemId').setVisible(true);
    	var gridTabStructure = this.getViewschedulegridstructure();
    	gridTabStructure.setActiveTab(gridTabStructure.down('#viewschedulecalendarItemId'));
    	var formWindow = $this.getViewschedulecalendar();
    	if (!formWindow) {
    		Ext.widget('viewschedulecalendar');
    		formWindow = $this.getViewschedulecalendar();
    	}
    	formWindow.show();
    	this.showCalendarData();
    },
    /**
     * This function to display filter according radio button selection
     */
    sectionDropDown:function(cb, nv, ov){
    	var $this = this;
    	var structure = $this.getViewschedulestructure();
    	structure.down('#viewScheduleGridStructureItemId').setVisible(false);
    	var form = $this.getViewschedulesearch().getForm();
    	var grid = $this.getViewschedulegrid();
    	if(nv.sectionCourse == 'programBatchSection' || nv == true){
    		form.findField('scheduleFor').setValue('programBatchSection');
    		$this.getViewschedulesearch().down('#facultyCodeNameId').setVisible(false);
    		$this.getViewschedulesearch().down('#studentPeriodContainerItemId').setVisible(false);
    		$this.getViewschedulesearch().down('#roomComboId').setVisible(false);
    		
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupId').setVisible(false);
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupPBSId').setVisible(false);
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupCVId').setVisible(false);
    		
    		$this.getViewschedulesearch().down('#fieldcontainerCourseAndSectionId').setVisible(true);
    		$this.getViewschedulesearch().down('#fieldcontainerAcademicTermAndProgramAndBatchId').setVisible(true);
    		$this.getViewschedulesearch().down('#fieldcontainerPeriodAndSectionAndCourseId').setVisible(true);
    		
    		form.findField('COURSE_ID').show();
    		form.findField('COURSE_ID').setDisabled(true);
    		form.findField('COURSE_ID').reset();
    		
    		form.findField('course').hide();
    		form.findField('course').setValue(null);
    		form.findField('section').hide();
    		form.findField('section').setValue(null);
    		form.findField('program').show();
    		form.findField('program').reset();
    		form.findField('program').setDisabled(true);
    		form.findField('batch').show();
    		form.findField('batch').reset();
    		form.findField('batch').setDisabled(true);
    		form.findField('programCoursesection').show();
    		form.findField('programCoursesection').reset();
    		form.findField('programCoursesection').setDisabled(true);
    		form.findField('period').show();
    		form.findField('period').reset();
    		form.findField('period').setDisabled(true);

    		form.findField('intakeYear').hide();
    		form.findField('intakeYear').reset();

    		form.findField('studentProgramId').hide();
    		form.findField('studentProgramId').reset();


    		form.findField('facultyId').reset();
    		form.findField('studentId').reset();

    		form.findField('room').setVisible(false);
    		form.findField('room').reset();

    		form.findField('COURSE_ACADEMIC_TERM').setVisible(false);
    		form.findField('COURSE_ACADEMIC_TERM').reset();
    		form.findField('COURSE_ACADEMIC_TERM').allowBlank = true;

    		form.findField('PROGRAM_ACADEMIC_TERM').setVisible(true);
    		form.findField('PROGRAM_ACADEMIC_TERM').reset();
    		form.findField('PROGRAM_ACADEMIC_TERM').allowBlank = false;
    		
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').setVisible(false);
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').reset();
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').allowBlank = true;
    		
    		form.findField('SECTION_GROUP_NAME').hide();
    		form.findField('SECTION_GROUP_NAME').setValue(null);
    		
    		form.findField('sectionGroupProgramName').hide();
    		form.findField('sectionGroupProgramName').setValue(null);
    		
    		form.findField('sectionGroupBatchName').hide();
    		form.findField('sectionGroupBatchName').setValue(null);
    		
    		form.findField('sectionGroupPeriodName').hide();
    		form.findField('sectionGroupPeriodName').setValue(null);
    		
    		form.findField('sectionGroupCourse').hide();
    		form.findField('sectionGroupCourse').setValue(null);
    		
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').hide();
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').setValue(null);
    		
    		form.isValid();
    		this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);

    		grid.columns[0].setVisible(true);
    		grid.columns[1].setVisible(false);
    		grid.columns[2].setVisible(false);
    		grid.columns[3].setVisible(false);
    		grid.columns[4].setVisible(true);
    		grid.columns[5].setVisible(true);
    		grid.columns[6].setVisible(true);
    		grid.columns[7].setVisible(false);
    		grid.columns[8].setVisible(true);
    		grid.columns[9].setVisible(false);
    		grid.columns[10].setVisible(false);
    		grid.columns[11].setVisible(false);
    		grid.columns[12].setVisible(false);
    		grid.columns[13].setVisible(false);
    		grid.columns[14].setVisible(false);
    		grid.columns[15].setVisible(false);
    		grid.columns[16].setVisible(false);

    	}else if(nv.sectionCourse == 'courseSection'){
    		form.findField('scheduleFor').setValue('courseSection');
    		$this.getViewschedulesearch().down('#facultyCodeNameId').setVisible(false);
    		$this.getViewschedulesearch().down('#studentPeriodContainerItemId').setVisible(false);
    		$this.getViewschedulesearch().down('#roomComboId').setVisible(false);
    		
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupId').setVisible(false);
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupPBSId').setVisible(false);
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupCVId').setVisible(false);
    		
    		$this.getViewschedulesearch().down('#fieldcontainerCourseAndSectionId').setVisible(true);
    		$this.getViewschedulesearch().down('#fieldcontainerAcademicTermAndProgramAndBatchId').setVisible(true);
    		$this.getViewschedulesearch().down('#fieldcontainerPeriodAndSectionAndCourseId').setVisible(true);
    		
    		var programBox = $this.getViewschedulesearch().down('customcombobox#program_Id');
    		programBox.clearValue();
    		form.findField('courseVariantPBS').setValue(null);
    		form.findField('COURSE_ID').hide();
    		form.findField('COURSE_ID').reset();
    		form.findField('course').show();
    		form.findField('course').reset();
    		form.findField('course').setDisabled(true);
    		form.findField('section').show();
    		form.findField('section').reset();
    		form.findField('section').setDisabled(true);
    		form.findField('program').hide();
    		form.findField('program').setValue(null);
    		form.findField('batch').hide();
    		form.findField('batch').setValue(null);
    		form.findField('programCoursesection').hide();
    		form.findField('programCoursesection').setValue(null);
    		form.findField('period').hide();
    		form.findField('period').setValue(null);
    		form.findField('facultyId').reset();
    		form.findField('studentId').reset();

    		form.findField('room').setVisible(false);
    		form.findField('room').reset();

    		form.findField('COURSE_ACADEMIC_TERM').setVisible(true);
    		form.findField('COURSE_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').setVisible(false);
    		form.findField('PROGRAM_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').allowBlank = true;
    		
    		form.findField('COURSE_ACADEMIC_TERM').allowBlank = false;
    		form.findField('COURSE_ACADEMIC_TERM').setFieldLabel(getCommonTranslation('ACADEMIC_TERM')+'<span class="required" style="color:red"> *</span>');
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').setVisible(false);
    		
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').reset();
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').allowBlank = true;

    		form.findField('intakeYear').hide();
    		form.findField('intakeYear').reset();

    		form.findField('studentProgramId').hide();
    		form.findField('studentProgramId').reset();
    		
    		form.findField('SECTION_GROUP_NAME').hide();
    		form.findField('SECTION_GROUP_NAME').setValue(null);
    		
    		form.findField('sectionGroupProgramName').hide();
    		form.findField('sectionGroupProgramName').setValue(null);
    		
    		form.findField('sectionGroupBatchName').hide();
    		form.findField('sectionGroupBatchName').setValue(null);
    		
    		form.findField('sectionGroupPeriodName').hide();
    		form.findField('sectionGroupPeriodName').setValue(null);
    		
    		form.findField('sectionGroupCourse').hide();
    		form.findField('sectionGroupCourse').setValue(null);
    		
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').hide();
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').setValue(null);

    		form.isValid();
    		this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);

    		grid.columns[0].setVisible(true);
    		grid.columns[1].setVisible(false);
    		grid.columns[2].setVisible(false);
    		grid.columns[3].setVisible(false);
    		grid.columns[4].setVisible(false);
    		grid.columns[5].setVisible(false);
    		grid.columns[6].setVisible(false);
    		grid.columns[7].setVisible(true);
    		grid.columns[8].setVisible(true);
    		grid.columns[9].setVisible(true);
    		grid.columns[10].setVisible(false);
    		grid.columns[11].setVisible(false);
    		grid.columns[12].setVisible(false);
    		grid.columns[13].setVisible(false);
    		grid.columns[14].setVisible(false);
    		grid.columns[15].setVisible(false);
    		grid.columns[16].setVisible(false);

    	}else if(nv.sectionCourse == 'faculty'){
    		form.findField('scheduleFor').setValue('faculty');
    		$this.getViewschedulesearch().down('#studentPeriodContainerItemId').setVisible(false);
    		$this.getViewschedulesearch().down('#facultyCodeNameId').setVisible(true);
    		$this.getViewschedulesearch().down('#roomComboId').setVisible(false);
    		
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupId').setVisible(false);
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupPBSId').setVisible(false);
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupCVId').setVisible(false);
    		
    		$this.getViewschedulesearch().down('#fieldcontainerCourseAndSectionId').setVisible(true);
    		$this.getViewschedulesearch().down('#fieldcontainerAcademicTermAndProgramAndBatchId').setVisible(true);
    		$this.getViewschedulesearch().down('#fieldcontainerPeriodAndSectionAndCourseId').setVisible(true);
    		
    		form.findField('courseVariantPBS').setValue(null);
    		form.findField('COURSE_ID').hide();
    		form.findField('COURSE_ID').reset();
    		form.findField('course').hide();
    		form.findField('course').reset();
    		form.findField('section').hide();
    		form.findField('section').reset();
    		form.findField('section').setDisabled(true);

    		form.findField('program').hide();
    		form.findField('program').setValue(null);
    		form.findField('batch').hide();
    		form.findField('batch').setValue(null);
    		form.findField('programCoursesection').hide();
    		form.findField('programCoursesection').setValue(null);
    		form.findField('period').hide();
    		form.findField('period').setValue(null);

    		form.findField('facultyId').reset();
    		form.findField('studentId').reset();

    		form.findField('room').setVisible(false);
    		form.findField('room').reset();

    		form.findField('COURSE_ACADEMIC_TERM').setVisible(false);
    		form.findField('COURSE_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').setVisible(false);
    		form.findField('PROGRAM_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').allowBlank = true;
    		form.findField('COURSE_ACADEMIC_TERM').allowBlank = true;
    		
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').setVisible(false);
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').reset();
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').allowBlank = true;

    		form.findField('intakeYear').hide();
    		form.findField('intakeYear').reset();

    		form.findField('studentProgramId').hide();
    		form.findField('studentProgramId').reset();
    		form.findField('SECTION_GROUP_NAME').hide();
    		form.findField('SECTION_GROUP_NAME').setValue(null);
    		
    		form.findField('sectionGroupProgramName').hide();
    		form.findField('sectionGroupProgramName').setValue(null);
    		
    		form.findField('sectionGroupBatchName').hide();
    		form.findField('sectionGroupBatchName').setValue(null);
    		
    		form.findField('sectionGroupPeriodName').hide();
    		form.findField('sectionGroupPeriodName').setValue(null);
    		
    		form.findField('sectionGroupCourse').hide();
    		form.findField('sectionGroupCourse').setValue(null);
    		
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').hide();
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').setValue(null);

    		form.isValid();
    		this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(false);
    		this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);

    		var store = form.findField('facultyId').getStore();
    		store.getProxy().extraParams ={
    			academyLocationIds : $this.getAcademyLocationIds(),
    			restrictToFacultyRole : true,
    			nameOrCode : ''
    		}
    		store.load();

    		grid.columns[0].setVisible(true);
    		grid.columns[1].setVisible(false);
    		grid.columns[2].setVisible(false);
    		grid.columns[3].setVisible(false);
    		grid.columns[4].setVisible(false);
    		grid.columns[5].setVisible(false);
    		grid.columns[6].setVisible(false);
    		grid.columns[7].setVisible(false);
    		grid.columns[8].setVisible(false);
    		grid.columns[9].setVisible(false);
    		grid.columns[10].setVisible(true);
    		grid.columns[11].setVisible(true);
    		grid.columns[12].setVisible(false);
    		grid.columns[13].setVisible(false);
    		grid.columns[14].setVisible(false);
    		grid.columns[15].setVisible(false);
    		grid.columns[16].setVisible(false);

    	}else if(nv.sectionCourse == 'student'){
    		form.findField('scheduleFor').setValue('student');
    		$this.getViewschedulesearch().down('#studentPeriodContainerItemId').setVisible(true);
    		$this.getViewschedulesearch().down('#facultyCodeNameId').setVisible(false);
    		$this.getViewschedulesearch().down('#roomComboId').setVisible(false);
    		
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupId').setVisible(false);
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupPBSId').setVisible(false);
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupCVId').setVisible(false);
    		
    		$this.getViewschedulesearch().down('#fieldcontainerCourseAndSectionId').setVisible(false);
    		$this.getViewschedulesearch().down('#fieldcontainerAcademicTermAndProgramAndBatchId').setVisible(false);
    		$this.getViewschedulesearch().down('#fieldcontainerPeriodAndSectionAndCourseId').setVisible(false);
    		
    		form.findField('courseVariantPBS').setValue(null);
    		form.findField('COURSE_ID').hide();
    		form.findField('COURSE_ID').reset();
    		form.findField('course').hide();
    		form.findField('course').reset();
    		form.findField('section').hide();
    		form.findField('section').reset();
    		form.findField('section').setDisabled(true);

    		form.findField('program').hide();
    		form.findField('program').setValue(null);
    		form.findField('batch').hide();
    		form.findField('batch').setValue(null);
    		form.findField('programCoursesection').hide();
    		form.findField('programCoursesection').setValue(null);
    		form.findField('period').hide();
    		form.findField('period').setValue(null);

    		form.findField('facultyId').reset();

    		form.findField('room').setVisible(false);
    		form.findField('room').reset();
    		form.findField('COURSE_ACADEMIC_TERM').setFieldLabel(getCommonTranslation('ACADEMIC_TERM'));
    		form.findField('COURSE_ACADEMIC_TERM').setVisible(true);
    		form.findField('COURSE_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').setVisible(false);
    		form.findField('PROGRAM_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').allowBlank = true;
    		form.findField('COURSE_ACADEMIC_TERM').allowBlank = true;
    		
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').setVisible(false);
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').reset();
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').allowBlank = true;

    		form.findField('intakeYear').show();
    		form.findField('intakeYear').reset();

    		form.findField('studentProgramId').show();
    		form.findField('studentProgramId').reset();
    		form.findField('studentBatch').setDisabled(true);
    		form.findField('studentBatch').reset();
    		form.findField('studentPeriod').setDisabled(true);
    		form.findField('studentPeriod').reset();
    		form.findField('studentId').reset();
    		form.findField('SECTION_GROUP_NAME').hide();
    		form.findField('SECTION_GROUP_NAME').setValue(null);
    		
    		form.findField('sectionGroupProgramName').hide();
    		form.findField('sectionGroupProgramName').setValue(null);
    		
    		form.findField('sectionGroupBatchName').hide();
    		form.findField('sectionGroupBatchName').setValue(null);
    		
    		form.findField('sectionGroupPeriodName').hide();
    		form.findField('sectionGroupPeriodName').setValue(null);
    		
    		form.findField('sectionGroupCourse').hide();
    		form.findField('sectionGroupCourse').setValue(null);
    		
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').hide();
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').setValue(null);
    		
    		form.isValid();
    		this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(false);
    		this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);

    		var programStore = form.findField('studentProgramId').getStore();
    		var studentStore = form.findField('studentId').getStore();

    		programStore.getProxy().extraParams ={
    			academyLocationIds : $this.getAcademyLocationIds()
    		}
    		programStore.load();
    		studentStore.getProxy().extraParams ={
    			academyLocationIds : $this.getAcademyLocationIds()
    		}
    		studentStore.load();
    		grid.columns[0].setVisible(true);
    		grid.columns[1].setVisible(true);
    		grid.columns[2].setVisible(true);
    		grid.columns[3].setVisible(true);
    		grid.columns[4].setVisible(true);
    		grid.columns[5].setVisible(true);
    		grid.columns[6].setVisible(true);
    		grid.columns[7].setVisible(false);
    		grid.columns[8].setVisible(true);
    		grid.columns[9].setVisible(false);
    		grid.columns[10].setVisible(false);
    		grid.columns[11].setVisible(false);
    		grid.columns[12].setVisible(false);
    		grid.columns[13].setVisible(false);
    		grid.columns[14].setVisible(false);
    		grid.columns[15].setVisible(false);
    		grid.columns[16].setVisible(false);

    	} else if(nv.sectionCourse == 'room'){
    		form.findField('scheduleFor').setValue('room');
    		$this.getViewschedulesearch().down('#studentPeriodContainerItemId').setVisible(false);
    		$this.getViewschedulesearch().down('#facultyCodeNameId').setVisible(false);
    		$this.getViewschedulesearch().down('#roomComboId').setVisible(true);
    		
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupId').setVisible(false);
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupPBSId').setVisible(false);
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupCVId').setVisible(false);
    		
    		$this.getViewschedulesearch().down('#fieldcontainerCourseAndSectionId').setVisible(true);
    		$this.getViewschedulesearch().down('#fieldcontainerAcademicTermAndProgramAndBatchId').setVisible(true);
    		$this.getViewschedulesearch().down('#fieldcontainerPeriodAndSectionAndCourseId').setVisible(true);
    		
    		form.findField('courseVariantPBS').setValue(null);
    		form.findField('COURSE_ID').hide();
    		form.findField('COURSE_ID').reset();
    		form.findField('course').hide();
    		form.findField('course').reset();
    		form.findField('section').hide();
    		form.findField('section').reset();
    		form.findField('section').setDisabled(true);

    		form.findField('program').hide();
    		form.findField('program').setValue(null);
    		form.findField('batch').hide();
    		form.findField('batch').setValue(null);
    		form.findField('programCoursesection').hide();
    		form.findField('programCoursesection').setValue(null);
    		form.findField('period').hide();
    		form.findField('period').setValue(null);

    		form.findField('facultyId').reset();
    		form.findField('room').reset();
    		form.findField('room').setVisible(true);
    		form.findField('COURSE_ACADEMIC_TERM').setVisible(false);
    		form.findField('COURSE_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').setVisible(false);
    		form.findField('PROGRAM_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').allowBlank = true;
    		form.findField('COURSE_ACADEMIC_TERM').allowBlank = true;
    		
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').setVisible(false);
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').reset();
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').allowBlank = true;
    		
    		form.findField('SECTION_GROUP_NAME').hide();
    		form.findField('SECTION_GROUP_NAME').setValue(null);
    		
    		form.findField('sectionGroupProgramName').hide();
    		form.findField('sectionGroupProgramName').setValue(null);
    		
    		form.findField('sectionGroupBatchName').hide();
    		form.findField('sectionGroupBatchName').setValue(null);
    		
    		form.findField('sectionGroupPeriodName').hide();
    		form.findField('sectionGroupPeriodName').setValue(null);
    		
    		form.findField('sectionGroupCourse').hide();
    		form.findField('sectionGroupCourse').setValue(null);
    		
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').hide();
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').setValue(null);

    		form.findField('intakeYear').hide();
    		form.findField('intakeYear').reset();

    		form.findField('studentProgramId').hide();
    		form.findField('studentProgramId').reset();
    		
    		form.isValid();
    		this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(false);
    		this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);

    		var roomStore = form.findField('room').getStore();
    		roomStore.getProxy().extraParams ={
    			academyLocationIds : $this.getAcademyLocationIds(),
    			onlyClassRoom : true,
    			name :''
    		}
    		roomStore.load();

    		grid.columns[0].setVisible(true);
    		grid.columns[1].setVisible(false);
    		grid.columns[2].setVisible(false);
    		grid.columns[3].setVisible(false);
    		grid.columns[4].setVisible(false);
    		grid.columns[5].setVisible(false);
    		grid.columns[6].setVisible(false);
    		grid.columns[7].setVisible(false);
    		grid.columns[8].setVisible(false);
    		grid.columns[9].setVisible(false);
    		grid.columns[10].setVisible(false);
    		grid.columns[11].setVisible(false);
    		grid.columns[12].setVisible(true);
    		grid.columns[13].setVisible(true);
    		grid.columns[14].setVisible(false);
    		grid.columns[15].setVisible(false);
    		grid.columns[16].setVisible(false);
    		
    	}else if(nv.sectionCourse == 'sectionGroup'){
    		
    		form.findField('scheduleFor').setValue('sectionGroup');
    		$this.getViewschedulesearch().down('#studentPeriodContainerItemId').setVisible(false);
    		$this.getViewschedulesearch().down('#facultyCodeNameId').setVisible(false);
    		$this.getViewschedulesearch().down('#roomComboId').setVisible(false);
    		
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupId').setVisible(true);
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupPBSId').setVisible(true);
    		$this.getViewschedulesearch().down('#fieldContainerSectionGroupCVId').setVisible(true);
    		
    		$this.getViewschedulesearch().down('#fieldcontainerCourseAndSectionId').setVisible(true);
    		$this.getViewschedulesearch().down('#fieldcontainerAcademicTermAndProgramAndBatchId').setVisible(true);
    		$this.getViewschedulesearch().down('#fieldcontainerPeriodAndSectionAndCourseId').setVisible(true);
    		
    		form.findField('courseVariantPBS').setValue(null);
    		form.findField('COURSE_ID').hide();
    		form.findField('COURSE_ID').reset();
    		form.findField('course').hide();
    		form.findField('course').reset();
    		form.findField('section').hide();
    		form.findField('section').reset();
    		form.findField('section').setDisabled(true);

    		form.findField('program').hide();
    		form.findField('program').setValue(null);
    		form.findField('batch').hide();
    		form.findField('batch').setValue(null);
    		form.findField('programCoursesection').hide();
    		form.findField('programCoursesection').setValue(null);
    		form.findField('period').hide();
    		form.findField('period').setValue(null);

    		form.findField('facultyId').reset();
    		form.findField('room').reset();
    		form.findField('room').setVisible(false);
    		
    		form.findField('COURSE_ACADEMIC_TERM').setVisible(false);
    		form.findField('COURSE_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').setVisible(false);
    		form.findField('PROGRAM_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').allowBlank = true;
    		form.findField('COURSE_ACADEMIC_TERM').allowBlank = true;
    		
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').setVisible(true);
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').reset();
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').allowBlank = false;

    		form.findField('intakeYear').hide();
    		form.findField('intakeYear').reset();

    		form.findField('studentProgramId').hide();
    		form.findField('studentProgramId').reset();
    		
    		form.findField('SECTION_GROUP_NAME').show();
    		form.findField('SECTION_GROUP_NAME').reset();
    		form.findField('SECTION_GROUP_NAME').setDisabled(true);
    		
    		form.findField('sectionGroupProgramName').show();
    		form.findField('sectionGroupProgramName').reset();
    		form.findField('sectionGroupProgramName').setDisabled(true);
    		
    		form.findField('sectionGroupBatchName').show();
    		form.findField('sectionGroupBatchName').reset();
    		form.findField('sectionGroupBatchName').setDisabled(true);
    		
    		form.findField('sectionGroupPeriodName').show();
    		form.findField('sectionGroupPeriodName').reset();
    		form.findField('sectionGroupPeriodName').setDisabled(true);
    		
    		form.findField('sectionGroupCourse').show();
    		form.findField('sectionGroupCourse').reset();
    		form.findField('sectionGroupCourse').setDisabled(true);
    		
    		
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').show();
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').reset();
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').setDisabled(true);
    		
    		
    		
    		form.isValid();
    		//this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(false);
    		this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);

    		grid.columns[0].setVisible(false);
    		grid.columns[1].setVisible(false);
    		grid.columns[2].setVisible(false);
    		grid.columns[3].setVisible(false);
    		grid.columns[4].setVisible(false);
    		grid.columns[5].setVisible(false);
    		grid.columns[6].setVisible(false);
    		grid.columns[7].setVisible(false);
    		grid.columns[8].setVisible(false);
    		grid.columns[9].setVisible(false);
    		grid.columns[10].setVisible(false);
    		grid.columns[11].setVisible(false);
    		grid.columns[12].setVisible(false);
    		grid.columns[13].setVisible(false);
    		grid.columns[14].setVisible(true);
    		grid.columns[15].setVisible(true);
    		grid.columns[16].setVisible(true);
    		
    	}
    	
    },
    getAllProgramBatchPeriod : function(record){

   	 var frmWin = this.getMappedProgramPeriodGrid();
		 if (!frmWin) {
			 Ext.widget('mappedprogramperiodgrid');
			 frmWin = this.getMappedProgramPeriodGrid();
		 }
   	 
   	 frmWin.show();
   	 var id = record.get('sectionGroupId');
   	 var grid = this.getSectiongroupprogramdetail();
   	 var store = grid.getStore();
   	 store.getProxy().extraParams={
   		 sectionGroupId : id
   	 }
   	 this.resetPageSetting(store);
   	 store.load();
   	 /* store.load({
   		 callback : function(){
   			 frmWin.show(); 
   		 }
   	 });*/
    },
    getAllCoursesCourseVariant : function(record){
   	 var frmWin = this.getMappedCourseVariantGrid();
	 if (!frmWin) {
		 Ext.widget('mappedcoursevariantgrid');
		 frmWin = this.getMappedCourseVariantGrid();
	 }
	 frmWin.show();
	 var id = record.get('sectionGroupId');
	 var grid = this.getSectiongroupcoursevariantdetail();
	 var store = grid.getStore();
	 store.getProxy().extraParams={
		 sectionGroupId : id
	 }
	 this.resetPageSetting(store);
	 store.load();
 },
    /**
     * This function is used to show data on calendar
     */
    showCalendarData:function(){
    	var me = this;
    	var calendar = this.getViewschedulecalendar();
    	var grid =  this.getViewschedulegrid();

    	this.getGridReload();
    	calendar.eventStore.removeAll();
    	calendar.eventStore.getProxy().actionMethods.read='GET';
    	submitURL=SERVERURL.VIEW_SCHEDULE_CALENDAR;  //URL-rest/courseCoveragePlan/calendar
     	var searchForm = this.getViewschedulesearch().getForm();
        var scheduleFor = searchForm.findField('scheduleFor').getValue();
    	var courseVariant = searchForm.findField('courseVariantId').getValue();
    	var sectionId = searchForm.findField('programCoursesection').getValue();
    	var facultyId = searchForm.findField('facultyId').getValue();
    	var studentId = searchForm.findField('studentId').getValue();
    	var roomId = searchForm.findField('room').getValue();
    	var sectionGroupId=searchForm.findField('SECTION_GROUP_NAME').getValue();
    	if(scheduleFor == 'programBatchSection'){ 
    		var courseId = null;
    		if(!isNullOrEmpty(searchForm.findField('COURSE_ID').getValue())){
    			courseId = searchForm.findField('COURSE_ID').getValue();
    		}
    		calendar.eventStore.getProxy().url = submitURL;//'http://localhost:8080/serosoft-academia-web/rest/courseCoveragePlan/calendar?id=71&resourceName=section';

    		if(!isNullOrEmpty(courseId)){
                calendar.eventStore.getProxy().extraParams = {
					id:courseId,
					resourceName:'variant',
					sectionId:sectionId,
					courseType:'PBS'
				};
    			calendar.eventStore.load(
    					/*{
    						params: {
    							id:courseId,
    							resourceName:'variant',
    							sectionId:sectionId,
    							courseType:'PBS'
    						}
    					}*/
    			);	
    		}
    	}else if(scheduleFor == 'courseSection'){
    		calendar.eventStore.getProxy().url =submitURL;//'http://localhost:8080/serosoft-academia-web/rest/courseCoveragePlan/calendar?id=71&resourceName=variant';   
    		calendar.eventStore.getProxy().extraParams = {
				id:courseVariant,
				resourceName:'variant'
			};
            calendar.eventStore.load(
    				/*{
    					params: {
    						id:courseVariant,
    						resourceName:'variant'
    					}
    				}*/
    		);	
    	}else if(scheduleFor == 'faculty'){
    		var facultyUrl = SERVERURL.FACULTY_SCHEDULE_DETAILS_WITH_DATE;
    		calendar.eventStore.getProxy().url = facultyUrl;//'http://localhost:8080/serosoft-academia-web/rest/courseCoveragePlan/getFacultyCalendar?facultyId=3';   
    		calendar.eventStore.getProxy().extraParams = {
				facultyId:facultyId
			};
            calendar.eventStore.load(
    				/*{
    					params: {
    						facultyId:facultyId
    					}
    				}*/
    		);	
    	}else if(scheduleFor == 'student'){
    		var studentUrl = SERVERURL.STUDENT_SCHEDULE_DETAILS;
    		calendar.eventStore.getProxy().url =studentUrl;//'http://localhost:8080/serosoft-academia-web/rest/courseCoveragePlan/getStudentCalendar?studentId=13';   
    		calendar.eventStore.getProxy().extraParams = {
				studentId:studentId
			};
            calendar.eventStore.load(
    				/*{
    					params: {
    						studentId:studentId
    					}
    				}*/
    		);	
    	}else if(scheduleFor == 'room'){
    		var roomUrl = SERVERURL.ROOM_SCHEDULE_DETAILS;
    		calendar.eventStore.getProxy().url =roomUrl;//'http://localhost:8080/serosoft-academia-web/rest/courseCoveragePlan/getRoomWiseCalendar?roomId=01';   
    		calendar.eventStore.getProxy().extraParams = {
				roomId:roomId
			};
            calendar.eventStore.load(
    				/*{
    					params: {
    						roomId:roomId
    					}
    				}*/
    		);	
        	
    	}else if(scheduleFor == 'sectionGroup'){
    		courseVariant=searchForm.findField('SECTION_GROUP_COURSE_VARIENT_NAME').getValue()
    		//  form.down('#courseSectionRadio_Id').collapse(true);
    		calendar.eventStore.getProxy().url =submitURL;//'http://localhost:8080/serosoft-academia-web/rest/courseCoveragePlan/calendar?id=71&resourceName=variant';   
    		calendar.eventStore.getProxy().extraParams = {
				id:sectionGroupId,
				resourceName:'sectionGroup',
				sectionId:courseVariant
			};
            calendar.eventStore.load();	
    	}
    	if(scheduleFor == 'room' || scheduleFor == 'faculty'){
    		me.scrollToCurrentTimeForRoomAndFaculty();
    	}else if(scheduleFor == 'sectionGroup')
    		me.scrollToCurrentTimeForSection();
    	else
    		me.scrollToCurrentTime();
    },
    /**
     * This function is used to scroll calendar view to 08:00am
     */
    scrollToCurrentTime: function(){
    	try{
    		var me = this;
    		var structure = me.getViewschedulemainstructure();
    		var structureBody = structure.body;
    		var currentTimeHour = 8;//new Date().getHours();
    		structureBody.setScrollTop();
    		structureBody.scrollBy(0,704);
    		setTimeout(function(){
    			structureBody.scrollBy(0,((75*currentTimeHour)));
    		},100);
    	}
    	catch(e){}
    }, 

    scrollToCurrentTimeForRoomAndFaculty: function(){
    	try{
    		var me = this;
    		var structure = me.getViewschedulemainstructure();
    		var structureBody = structure.body;
    		var currentTimeHour = 8;//new Date().getHours();
    		structureBody.setScrollTop();
    		structureBody.scrollBy(0,625);
    		setTimeout(function(){
    			structureBody.scrollBy(0,((75*currentTimeHour)));
    		},100);
    	}
    	catch(e){}
    },

    scrollToCurrentTimeForSection: function(){
    	try{
    		var me = this;
    		var structure = me.getViewschedulemainstructure();
    		var structureBody = structure.body;
    		var currentTimeHour = 8;//new Date().getHours();
    		structureBody.setScrollTop();
    		structureBody.scrollBy(0,782);
    		setTimeout(function(){
    			structureBody.scrollBy(0,((75*currentTimeHour)));
    		},100);
    	}
    	catch(e){}
    },
    /**
     * This function is used to reset search selection criteria
     */
    resetSchedule:function(){
    	var form = this.getViewschedulesearch().getForm();
    	this.onResetDropDown(this.getViewschedulesearch().down('#courseSectionRadio_Id').getValue());
    	//form.reset();
    	/*form.findField('program').setDisabled(true);
    	form.findField('batch').setDisabled(true);
    	form.findField('period').setDisabled(true);
    	form.findField('programCoursesection').setDisabled(true);
    	form.findField('COURSE_ID').setDisabled(true);
    	form.findField('COURSE_ID').setValue(null);
    	form.findField('scheduleFor').setValue('programBatchSection');
    	form.findField('PROGRAM_ACADEMIC_TERM').allowBlank = false;
    	form.findField('COURSE_ACADEMIC_TERM').allowBlank = true;
    	this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);*/
    },
    /**
     * This function is used to show data on grid.
     */
    getSchedules : function(){
    	var $this = this;
    	var submitURL='';
    	var structure = $this.getViewschedulestructure();
    	structure.down('#viewScheduleGridStructureItemId').setVisible(true);
    	var form = this.getViewschedulesearch().getForm();
    	var academyLocationIds = this.getAcademyLocationIds();
    	var gridTabStructure = this.getViewschedulegridstructure();
    	gridTabStructure.setActiveTab(gridTabStructure.down('#viewschedulegridTab'));
    	var grid = this.getViewschedulegrid();
    	grid.down('#scheduleCalendarViewId').setDisabled(true);
    	var gridStore = grid.getStore();
    	
    	var courseId = form.findField('course').getValue();
    	var facultyId = form.findField('facultyId').getValue();
    	var studentId = form.findField('studentId').getValue();
    	var intakeYearId = form.findField('intakeYear').getValue();
    	
    	var academicTermId = null;
    	var sectionId = null;
    	var programId = null;
    	var batchId =  null;
    	var periodId = null;
    	var sectionGroupId=null;
    	var courseVariantId=null;
    	if(form.getValues().sectionCourse == 'programBatchSection'){
    		academicTermId = form.findField('PROGRAM_ACADEMIC_TERM').getValue();
    		sectionId = form.findField('programCoursesection').getValue();
    		submitURL = SERVERURL.PATH_PBS_COURSE_SCHEDULE
    		programId = form.findField('program').getValue();
    		batchId = form.findField('batch').getValue();
    		periodId = form.findField('period').getValue();
    	} else if(form.getValues().sectionCourse == 'courseSection'){
    		academicTermId = form.findField('COURSE_ACADEMIC_TERM').getValue();
    		sectionId = form.findField('section').getValue();
    		submitURL = SERVERURL.PATH_PBS_COURSE_SCHEDULE
    	} else if(form.getValues().sectionCourse == 'sectionGroup'){
    		submitURL = SERVERURL.PATH_FIND_LIST_OF_SECTION_GROUP;
    		academicTermId=form.findField('SECTION_GROUP_ACADEMIC_TERM').getValue();
    		sectionGroupId=form.findField('SECTION_GROUP_NAME').getValue();
    		programId=form.findField('sectionGroupProgramName').getValue();
    		batchId=form.findField('sectionGroupBatchName').getValue();
    		periodId=form.findField('sectionGroupPeriodName').getValue();
    		courseId=form.findField('sectionGroupCourse').getValue();
    		courseVariantId=form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').getValue();
    		
    	}else if(form.getValues().sectionCourse == 'faculty'){
    		submitURL = SERVERURL.PATH_GET_ACTIVE_FACULTY
    	} else if(form.getValues().sectionCourse == 'student'){
    		submitURL = SERVERURL.PATH_STUDENT_BY_CRITERIA
    		academicTermId = form.findField('COURSE_ACADEMIC_TERM').getValue();
    		programId = form.findField('studentProgramId').getValue();
    		batchId = form.findField('studentBatch').getValue();
    		periodId = form.findField('studentPeriod').getValue();
    		var organizationUnitController =  Academia.app.getController('programCourseDashboard.organizationUnit.organizationUnitController');
	    	var organizationUnitForm = organizationUnitController.getOrganizationunit().getForm();
	    	var academyLocation;
	    	var values = organizationUnitForm.getValues();
	    	
	    	var mAL = values.multiselectAcademyLocation;
			
	    	if(mAL==""){
	    		this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(true);
				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(false);
	    		
	    	}
	    	else{
	    		this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(false);
				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);
	    	}

    	} else if(form.getValues().sectionCourse == 'room'){
    		submitURL = SERVERURL.PATH_ROOM_BY_CRITERIA
    	}
    	

    	gridStore.getProxy().api.read=submitURL;
    	gridStore.getProxy().extraParams = {
    		academyLocationIds : academyLocationIds,
    		academicTermId : academicTermId,
    		programId : programId,
    		batchId : batchId,
    		periodId : periodId,
    		sectionId : sectionId,
    		courseId : courseId,
    		courseVariantId:courseVariantId,
    		sectionGroupId:sectionGroupId,
    		courseType : form.getValues().sectionCourse,
    		facultyId : facultyId,
    		studentId : studentId,
    		intakeYearId : intakeYearId,
    		onlyClassRoom: true
    	};
    	gridStore.removeAll();
    	this.resetPageSetting(gridStore);
    	gridStore.load();
    	grid.config.searchFilterForm = this.getViewschedulesearch();
    },
    /**
     * This function is used to load primary filter on selection academy locations
     */
    loadDataOfAcademyLocation:function(){
    	var form = this.getViewschedulesearch().getForm();
    	form.findField('COURSE_ACADEMIC_TERM').reset();
    	form.findField('PROGRAM_ACADEMIC_TERM').reset();
    	form.findField('intakeYear').reset();
    	form.findField('course').setDisabled(true);
    	form.findField('course').reset();
    	form.findField('program').setDisabled(true);
    	form.findField('program').reset();
    	form.findField('studentBatch').setDisabled(true);
		form.findField('studentBatch').reset();
		form.findField('studentPeriod').setDisabled(true);
		form.findField('studentPeriod').reset();
    	var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
    	if(form.getValues().sectionCourse == 'faculty'){
    		var store = form.findField('facultyId').getStore();
    		store.getProxy().extraParams ={
    			academyLocationIds : acadLocationIdsCommaSepeated,
    			restrictToFacultyRole : true,
    			nameOrCode : ''
    		}
    		store.load();
    	} else if(form.getValues().sectionCourse == 'student'){
    		var programStore = form.findField('studentProgramId').getStore();
    		var studentStore = form.findField('studentId').getStore();

    		programStore.getProxy().extraParams ={
    			academyLocationIds : acadLocationIdsCommaSepeated
    		}
    		programStore.load();
    		studentStore.getProxy().extraParams ={
    			academyLocationIds : acadLocationIdsCommaSepeated
    		}
    		studentStore.load();
    	} else if (form.getValues().sectionCourse == 'room'){
    		var roomStore = form.findField('room').getStore();
    		roomStore.getProxy().extraParams ={
    			academyLocationIds : acadLocationIdsCommaSepeated,
    			onlyClassRoom : true,
    			name :''
    		}
    		roomStore.load();
    	}
    },
    /**
     * This function is used to open calendar window on click view schedule button from grid
     */
    openCalendarView:function(){
    	var $this =this;
    	var structure = $this.getViewschedulestructure();
    	structure.down('#viewScheduleGridStructureItemId').setVisible(true);
    	var gridTabStructure = this.getViewschedulegridstructure();
    	gridTabStructure.setActiveTab(gridTabStructure.down('#viewschedulecalendarItemId'));
    	var formWindow = $this.getViewschedulecalendar();
    	if (!formWindow) {
    		Ext.widget('viewschedulecalendar');
    		formWindow = $this.getViewschedulecalendar();
    	}
    	formWindow.show();
    	this.showCalendarGridData();
   // 	this.scrollToCurrentTime();
    },
    /**
     * This function is used to show data on calendar
     */
    showCalendarGridData:function(){
    	var me=this;
    	var calendar = this.getViewschedulecalendar();
    	var grid =  this.getViewschedulegrid();

    	calendar.eventStore.removeAll();
    	calendar.eventStore.getProxy().actionMethods.read='GET';
    	submitURL=SERVERURL.VIEW_SCHEDULE_CALENDAR;  //URL-rest/courseCoveragePlan/calendar


    	var searchForm = this.getViewschedulesearch().getForm();

    	var scheduleFor = searchForm.findField('scheduleFor').getValue();

    	if(scheduleFor == 'programBatchSection'){ 

    		if(grid.getSelectionModel().getCount() > 0){
    			var record = grid.getSelectionModel().getSelection();
    			var sectionId = record[0].data.sectionId;
    		}
    		calendar.eventStore.getProxy().url = submitURL;//'http://localhost:8080/serosoft-academia-web/rest/courseCoveragePlan/calendar?id=71&resourceName=section';
            calendar.eventStore.getProxy().extraParams = {
				id:sectionId,
				resourceName:'section'
			};
    		calendar.eventStore.load(
    				/*{
    					params: {
    						id:sectionId,
    						resourceName:'section'
    					}
    				}*/
    		);
    	}else if(scheduleFor == 'courseSection'){
    		if(grid.getSelectionModel().getCount() > 0){
    			var record = grid.getSelectionModel().getSelection();
    			var courseVariant = record[0].data.courseVariantId;
    		}
    		calendar.eventStore.getProxy().url =submitURL;//'http://localhost:8080/serosoft-academia-web/rest/courseCoveragePlan/calendar?id=71&resourceName=variant';   
    		calendar.eventStore.getProxy().extraParams = {
				id:courseVariant,
				resourceName:'variant'
			};
            calendar.eventStore.load(
    				/*{
    					params: {
    						id:courseVariant,
    						resourceName:'variant'
    					}
    				}*/
    		);	
    	}else if(scheduleFor == 'faculty'){
    		if(grid.getSelectionModel().getCount() > 0){
    			var record = grid.getSelectionModel().getSelection();
    			var facultyId = record[0].data.facultyId;
    		}
    		//var facultyUrl = SERVERURL.FACULTY_SCHEDULE_DETAILS;
    		var facultyUrl = SERVERURL.FACULTY_SCHEDULE_DETAILS_WITH_DATE;
    		calendar.eventStore.getProxy().url = facultyUrl;//'http://localhost:8080/serosoft-academia-web/rest/courseCoveragePlan/getFacultyCalendar?facultyId=3';   
    		calendar.eventStore.getProxy().extraParams = {
				facultyId:facultyId
			};
            calendar.eventStore.load(
    				/*{
    					params: {
    						facultyId:facultyId
    					}
    				}*/
    		);	
    	}else if(scheduleFor == 'student'){
    		if(grid.getSelectionModel().getCount() > 0){
    			var record = grid.getSelectionModel().getSelection();
    			var studentId = record[0].data.studentId;
    		}
    		var studentUrl = SERVERURL.STUDENT_SCHEDULE_DETAILS;
    		calendar.eventStore.getProxy().url =studentUrl;//'http://localhost:8080/serosoft-academia-web/rest/courseCoveragePlan/getStudentCalendar?studentId=13';   
    		calendar.eventStore.getProxy().extraParams = {
				studentId:studentId
			};
            calendar.eventStore.load(
    				/*{
    					params: {
    						studentId:studentId
    					}
    				}*/
    		);	
    	}else if(scheduleFor == 'room'){
    		if(grid.getSelectionModel().getCount() > 0){
    			var record = grid.getSelectionModel().getSelection();
    			var roomId = record[0].data.roomId;
    		}
    		var roomUrl = SERVERURL.ROOM_SCHEDULE_DETAILS;
    		calendar.eventStore.getProxy().url =roomUrl;//'http://localhost:8080/serosoft-academia-web/rest/courseCoveragePlan/getRoomWiseCalendar?roomId=01';   
    		calendar.eventStore.getProxy().extraParams = {
				roomId:roomId
			};
            calendar.eventStore.load(
    				/*{
    					params: {
    						roomId:roomId
    					}
    				}*/
    		);	
    	}else if(scheduleFor == 'sectionGroup'){
    		 

    		if(grid.getSelectionModel().getCount() > 0){
    			var record = grid.getSelectionModel().getSelection();
    			var sectionGroupId = record[0].data.sectionGroupId;
    		}
    		calendar.eventStore.getProxy().url = submitURL;//'http://localhost:8080/serosoft-academia-web/rest/courseCoveragePlan/calendar?id=71&resourceName=section';
            calendar.eventStore.getProxy().extraParams = {
				id:sectionGroupId,
				resourceName:'sectionGroup'
			};
    		calendar.eventStore.load(
    				/*{
    					params: {
    						id:sectionGroupId,
    						resourceName:'sectionGroup'
    					}
    				}*/
    		);
    		
         	
    	}
    	if(scheduleFor == 'room' || scheduleFor == 'faculty'){
    		me.scrollToCurrentTimeForRoomAndFaculty();
    	}else if(scheduleFor == 'sectionGroup')
    		me.scrollToCurrentTimeForSection();
    	else
    		me.scrollToCurrentTime();

    },
    getGridReload : function(){
    	var $this = this;
    	var submitURL='';
    	var structure = $this.getViewschedulestructure();
    	structure.down('#viewScheduleGridStructureItemId').setVisible(true);
    	var form = this.getViewschedulesearch().getForm();
    	var academyLocationIds = this.getAcademyLocationIds();
    	var grid = this.getViewschedulegrid();
    	var gridStore = grid.getStore();
    	
    	var academicTermId = null;
    	var sectionId = null;
    	var programId = null;
    	var batchId =  null;
    	var periodId = null;
    	var roomId = null;
    	var sectionGroupId=null;
    	var courseVariantId=null;
    	var courseId=null;
    	if(form.getValues().sectionCourse == 'programBatchSection'){
    		academicTermId = form.findField('PROGRAM_ACADEMIC_TERM').getValue();
    		sectionId = form.findField('programCoursesection').getValue();
    		submitURL = SERVERURL.PATH_PBS_COURSE_SCHEDULE
    		programId = form.findField('program').getValue();
    		batchId = form.findField('batch').getValue();
    		periodId = form.findField('period').getValue();
    	} else if(form.getValues().sectionCourse == 'courseSection'){
    		academicTermId = form.findField('COURSE_ACADEMIC_TERM').getValue();
    		sectionId = form.findField('section').getValue();
    		submitURL = SERVERURL.PATH_PBS_COURSE_SCHEDULE
    	}else if(form.getValues().sectionCourse == 'sectionGroup'){
    		submitURL = SERVERURL.PATH_FIND_LIST_OF_SECTION_GROUP;
    		academicTermId=form.findField('SECTION_GROUP_ACADEMIC_TERM').getValue();
    		sectionGroupId=form.findField('SECTION_GROUP_NAME').getValue();
    		programId=form.findField('sectionGroupProgramName').getValue();
    		batchId=form.findField('sectionGroupBatchName').getValue();
    		periodId=form.findField('sectionGroupPeriodName').getValue();
    		courseId=form.findField('sectionGroupCourse').getValue();
    		courseVariantId=form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').getValue();
    		
    	} else if(form.getValues().sectionCourse == 'faculty'){
    		submitURL = SERVERURL.PATH_GET_ACTIVE_FACULTY
    	} else if(form.getValues().sectionCourse == 'student'){
    		submitURL = SERVERURL.PATH_STUDENT_BY_CRITERIA
    		academicTermId = form.findField('COURSE_ACADEMIC_TERM').getValue();
    		programId = form.findField('studentProgramId').getValue();
    		batchId = form.findField('studentBatch').getValue();
    		periodId = form.findField('studentPeriod').getValue();
    	} else if(form.getValues().sectionCourse == 'room'){
    		roomId = form.findField('room').getValue();
    		submitURL = SERVERURL.PATH_ROOM_BY_CRITERIA
    	}
    	var courseId = form.findField('course').getValue();
    	var facultyId = form.findField('facultyId').getValue();
    	var studentId = form.findField('studentId').getValue();
    	var intakeYearId = form.findField('intakeYear').getValue();

    	gridStore.getProxy().api.read=submitURL;
    	gridStore.getProxy().extraParams = {
    		academyLocationIds : academyLocationIds,
    		academicTermId : academicTermId,
    		programId : programId,
    		batchId : batchId,
    		periodId : periodId,
    		sectionId : sectionId,
    		courseId : courseId,
    		courseVariantId:courseVariantId,
    		sectionGroupId:sectionGroupId,
    		courseType : form.getValues().sectionCourse,
    		facultyId : facultyId,
    		studentId : studentId,
    		intakeYearId : intakeYearId,
    		roomId : roomId,
    		onlyClassRoom: true
    	};
    	gridStore.removeAll();
    	this.resetPageSetting(gridStore);
    	gridStore.load();
    },
    onResetDropDown:function(value){
    	var $this = this;
    	var structure = $this.getViewschedulestructure();
    	structure.down('#viewScheduleGridStructureItemId').setVisible(false);
    	var form = $this.getViewschedulesearch().getForm();
    	var grid = $this.getViewschedulegrid();
    	if(value.sectionCourse == 'programBatchSection'){
    		form.findField('scheduleFor').setValue('programBatchSection');
    		$this.getViewschedulesearch().down('#facultyCodeNameId').setVisible(false);
    		$this.getViewschedulesearch().down('#studentPeriodContainerItemId').setVisible(false);
    		$this.getViewschedulesearch().down('#roomComboId').setVisible(false);
    		form.findField('COURSE_ID').show();
    		form.findField('COURSE_ID').setDisabled(true);
    		form.findField('COURSE_ID').reset();

    		form.findField('course').hide();
    		form.findField('course').setValue(null);
    		form.findField('section').hide();
    		form.findField('section').setValue(null);
    		form.findField('program').show();
    		form.findField('program').reset();
    		form.findField('program').setDisabled(true);
    		form.findField('batch').show();
    		form.findField('batch').reset();
    		form.findField('batch').setDisabled(true);
    		form.findField('programCoursesection').show();
    		form.findField('programCoursesection').reset();
    		form.findField('programCoursesection').setDisabled(true);
    		form.findField('period').show();
    		form.findField('period').reset();
    		form.findField('period').setDisabled(true);

    		form.findField('intakeYear').hide();
    		form.findField('intakeYear').reset();

    		form.findField('studentProgramId').hide();
    		form.findField('studentProgramId').reset();


    		form.findField('facultyId').reset();
    		form.findField('studentId').reset();

    		form.findField('room').setVisible(false);
    		form.findField('room').reset();

    		form.findField('COURSE_ACADEMIC_TERM').setVisible(false);
    		form.findField('COURSE_ACADEMIC_TERM').reset();
    		form.findField('COURSE_ACADEMIC_TERM').allowBlank = true;

    		form.findField('PROGRAM_ACADEMIC_TERM').setVisible(true);
    		form.findField('PROGRAM_ACADEMIC_TERM').reset();
    		form.findField('PROGRAM_ACADEMIC_TERM').allowBlank = false;
    		
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').setVisible(false);
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').reset();
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').allowBlank = true;
    		
    		form.findField('SECTION_GROUP_NAME').hide();
    		form.findField('SECTION_GROUP_NAME').setValue(null);
    		
    		form.findField('sectionGroupProgramName').hide();
    		form.findField('sectionGroupProgramName').setValue(null);
    		
    		form.findField('sectionGroupBatchName').hide();
    		form.findField('sectionGroupBatchName').setValue(null);
    		
    		form.findField('sectionGroupPeriodName').hide();
    		form.findField('sectionGroupPeriodName').setValue(null);
    		
    		form.findField('sectionGroupCourse').hide();
    		form.findField('sectionGroupCourse').setValue(null);
    		
    		
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').hide();
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').setValue(null);
    		
    		form.isValid();
    		this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);

    		grid.columns[0].setVisible(true);
    		grid.columns[1].setVisible(false);
    		grid.columns[2].setVisible(false);
    		grid.columns[3].setVisible(false);
    		grid.columns[4].setVisible(true);
    		grid.columns[5].setVisible(true);
    		grid.columns[6].setVisible(true);
    		grid.columns[7].setVisible(false);
    		grid.columns[8].setVisible(true);
    		grid.columns[9].setVisible(false);
    		grid.columns[10].setVisible(false);
    		grid.columns[11].setVisible(false);
    		grid.columns[12].setVisible(false);
    		grid.columns[13].setVisible(false);
    		grid.columns[14].setVisible(false);
    		grid.columns[15].setVisible(false);
    		grid.columns[16].setVisible(false);
    		

    	}else if(value.sectionCourse == 'courseSection'){
    		form.findField('scheduleFor').setValue('courseSection');
    		$this.getViewschedulesearch().down('#facultyCodeNameId').setVisible(false);
    		$this.getViewschedulesearch().down('#studentPeriodContainerItemId').setVisible(false);
    		$this.getViewschedulesearch().down('#roomComboId').setVisible(false);
    		var programBox = $this.getViewschedulesearch().down('customcombobox#program_Id');
    		programBox.clearValue();
    		form.findField('courseVariantPBS').setValue(null);
    		form.findField('COURSE_ID').hide();
    		form.findField('COURSE_ID').reset();
    		form.findField('course').show();
    		form.findField('course').reset();
    		form.findField('course').setDisabled(true);
    		form.findField('section').show();
    		form.findField('section').reset();
    		form.findField('section').setDisabled(true);
    		form.findField('program').hide();
    		form.findField('program').setValue(null);
    		form.findField('batch').hide();
    		form.findField('batch').setValue(null);
    		form.findField('programCoursesection').hide();
    		form.findField('programCoursesection').setValue(null);
    		form.findField('period').hide();
    		form.findField('period').setValue(null);
    		form.findField('facultyId').reset();
    		form.findField('studentId').reset();

    		form.findField('room').setVisible(false);
    		form.findField('room').reset();

    		form.findField('COURSE_ACADEMIC_TERM').setVisible(true);
    		form.findField('COURSE_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').setVisible(false);
    		form.findField('PROGRAM_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').allowBlank = true;
    		form.findField('COURSE_ACADEMIC_TERM').allowBlank = false;
    		form.findField('COURSE_ACADEMIC_TERM').setFieldLabel(getCommonTranslation('ACADEMIC_TERM')+'<span class="required" style="color:red"> *</span>');

    		form.findField('intakeYear').hide();
    		form.findField('intakeYear').reset();

    		form.findField('studentProgramId').hide();
    		form.findField('studentProgramId').reset();
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').setVisible(false);
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').reset();
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').allowBlank = true;
    		
    		form.findField('SECTION_GROUP_NAME').hide();
    		form.findField('SECTION_GROUP_NAME').setValue(null);
    		
    		form.findField('sectionGroupProgramName').hide();
    		form.findField('sectionGroupProgramName').setValue(null);
    		
    		form.findField('sectionGroupBatchName').hide();
    		form.findField('sectionGroupBatchName').setValue(null);
    		
    		form.findField('sectionGroupPeriodName').hide();
    		form.findField('sectionGroupPeriodName').setValue(null);
    		
    		form.findField('sectionGroupCourse').hide();
    		form.findField('sectionGroupCourse').setValue(null);
    		
    		
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').hide();
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').setValue(null);

    		form.isValid();
    		this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);

    		grid.columns[0].setVisible(true);
    		grid.columns[1].setVisible(false);
    		grid.columns[2].setVisible(false);
    		grid.columns[3].setVisible(false);
    		grid.columns[4].setVisible(false);
    		grid.columns[5].setVisible(false);
    		grid.columns[6].setVisible(false);
    		grid.columns[7].setVisible(true);
    		grid.columns[8].setVisible(true);
    		grid.columns[9].setVisible(true);
    		grid.columns[10].setVisible(false);
    		grid.columns[11].setVisible(false);
    		grid.columns[12].setVisible(false);
    		grid.columns[13].setVisible(false);
    		grid.columns[14].setVisible(false);
    		grid.columns[15].setVisible(false);
    		grid.columns[16].setVisible(false);

    	}else if(value.sectionCourse == 'faculty'){
    		form.findField('scheduleFor').setValue('faculty');
    		$this.getViewschedulesearch().down('#studentPeriodContainerItemId').setVisible(false);
    		$this.getViewschedulesearch().down('#facultyCodeNameId').setVisible(true);
    		$this.getViewschedulesearch().down('#roomComboId').setVisible(false);
    		form.findField('courseVariantPBS').setValue(null);
    		form.findField('COURSE_ID').hide();
    		form.findField('COURSE_ID').reset();
    		form.findField('course').hide();
    		form.findField('course').reset();
    		form.findField('section').hide();
    		form.findField('section').reset();
    		form.findField('section').setDisabled(true);

    		form.findField('program').hide();
    		form.findField('program').setValue(null);
    		form.findField('batch').hide();
    		form.findField('batch').setValue(null);
    		form.findField('programCoursesection').hide();
    		form.findField('programCoursesection').setValue(null);
    		form.findField('period').hide();
    		form.findField('period').setValue(null);

    		form.findField('facultyId').reset();
    		form.findField('studentId').reset();

    		form.findField('room').setVisible(false);
    		form.findField('room').reset();

    		form.findField('COURSE_ACADEMIC_TERM').setVisible(false);
    		form.findField('COURSE_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').setVisible(false);
    		form.findField('PROGRAM_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').allowBlank = true;
    		form.findField('COURSE_ACADEMIC_TERM').allowBlank = true;

    		form.findField('intakeYear').hide();
    		form.findField('intakeYear').reset();

    		form.findField('studentProgramId').hide();
    		form.findField('studentProgramId').reset();
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').setVisible(false);
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').reset();
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').allowBlank = true;
    		
    		form.findField('SECTION_GROUP_NAME').hide();
    		form.findField('SECTION_GROUP_NAME').setValue(null);
    		
    		form.findField('sectionGroupProgramName').hide();
    		form.findField('sectionGroupProgramName').setValue(null);
    		
    		form.findField('sectionGroupBatchName').hide();
    		form.findField('sectionGroupBatchName').setValue(null);
    		
    		form.findField('sectionGroupPeriodName').hide();
    		form.findField('sectionGroupPeriodName').setValue(null);
    		
    		form.findField('sectionGroupCourse').hide();
    		form.findField('sectionGroupCourse').setValue(null);
    		
    		
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').hide();
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').setValue(null);

    		form.isValid();
    		this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(false);
    		this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);

    		var store = form.findField('facultyId').getStore();
    		store.getProxy().extraParams ={
    			academyLocationIds : $this.getAcademyLocationIds(),
    			restrictToFacultyRole : true,
    			nameOrCode : ''
    		}
    		store.load();

    		grid.columns[0].setVisible(true);
    		grid.columns[1].setVisible(false);
    		grid.columns[2].setVisible(false);
    		grid.columns[3].setVisible(false);
    		grid.columns[4].setVisible(false);
    		grid.columns[5].setVisible(false);
    		grid.columns[6].setVisible(false);
    		grid.columns[7].setVisible(false);
    		grid.columns[8].setVisible(false);
    		grid.columns[9].setVisible(false);
    		grid.columns[10].setVisible(true);
    		grid.columns[11].setVisible(true);
    		grid.columns[12].setVisible(false);
    		grid.columns[13].setVisible(false);
    		grid.columns[14].setVisible(false);
    		grid.columns[15].setVisible(false);
    		grid.columns[16].setVisible(false);

    	}else if(value.sectionCourse == 'student'){
    		form.findField('scheduleFor').setValue('student');
    		$this.getViewschedulesearch().down('#studentPeriodContainerItemId').setVisible(true);
    		$this.getViewschedulesearch().down('#facultyCodeNameId').setVisible(false);
    		$this.getViewschedulesearch().down('#roomComboId').setVisible(false);
    		form.findField('courseVariantPBS').setValue(null);
    		form.findField('COURSE_ID').hide();
    		form.findField('COURSE_ID').reset();
    		form.findField('course').hide();
    		form.findField('course').reset();
    		form.findField('section').hide();
    		form.findField('section').reset();
    		form.findField('section').setDisabled(true);

    		form.findField('program').hide();
    		form.findField('program').setValue(null);
    		form.findField('batch').hide();
    		form.findField('batch').setValue(null);
    		form.findField('programCoursesection').hide();
    		form.findField('programCoursesection').setValue(null);
    		form.findField('period').hide();
    		form.findField('period').setValue(null);

    		form.findField('facultyId').reset();

    		form.findField('room').setVisible(false);
    		form.findField('room').reset();
    		form.findField('COURSE_ACADEMIC_TERM').setFieldLabel(getCommonTranslation('ACADEMIC_TERM'));
    		form.findField('COURSE_ACADEMIC_TERM').setVisible(true);
    		form.findField('COURSE_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').setVisible(false);
    		form.findField('PROGRAM_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').allowBlank = true;
    		form.findField('COURSE_ACADEMIC_TERM').allowBlank = true;

    		form.findField('intakeYear').show();
    		form.findField('intakeYear').reset();

    		form.findField('studentProgramId').show();
    		form.findField('studentProgramId').reset();
    		form.findField('studentBatch').setDisabled(true);
    		form.findField('studentBatch').reset();
    		form.findField('studentPeriod').setDisabled(true);
    		form.findField('studentPeriod').reset();
    		form.findField('studentId').reset();
    		
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').setVisible(false);
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').reset();
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').allowBlank = true;
    		
    		form.findField('SECTION_GROUP_NAME').hide();
    		form.findField('SECTION_GROUP_NAME').setValue(null);
    		
    		form.findField('sectionGroupProgramName').hide();
    		form.findField('sectionGroupProgramName').setValue(null);
    		
    		form.findField('sectionGroupBatchName').hide();
    		form.findField('sectionGroupBatchName').setValue(null);
    		
    		form.findField('sectionGroupPeriodName').hide();
    		form.findField('sectionGroupPeriodName').setValue(null);
    		
    		form.findField('sectionGroupCourse').hide();
    		form.findField('sectionGroupCourse').setValue(null);
    		
    		
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').hide();
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').setValue(null);

    		form.isValid();
    		this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(false);
    		this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);


    		var programStore = form.findField('studentProgramId').getStore();
    		var studentStore = form.findField('studentId').getStore();

    		programStore.getProxy().extraParams ={
    			academyLocationIds : $this.getAcademyLocationIds()
    		}
    		programStore.load();
    		studentStore.getProxy().extraParams ={
    			academyLocationIds : $this.getAcademyLocationIds()
    		}
    		studentStore.load();
    		grid.columns[0].setVisible(true);
    		grid.columns[1].setVisible(true);
    		grid.columns[2].setVisible(true);
    		grid.columns[3].setVisible(true);
    		grid.columns[4].setVisible(true);
    		grid.columns[5].setVisible(true);
    		grid.columns[6].setVisible(true);
    		grid.columns[7].setVisible(false);
    		grid.columns[8].setVisible(true);
    		grid.columns[9].setVisible(false);
    		grid.columns[10].setVisible(false);
    		grid.columns[11].setVisible(false);
    		grid.columns[12].setVisible(false);
    		grid.columns[13].setVisible(false);
    		grid.columns[14].setVisible(false);
    		grid.columns[15].setVisible(false);
    		grid.columns[16].setVisible(false);
    		var organizationUnitController =  Academia.app.getController('programCourseDashboard.organizationUnit.organizationUnitController');
	    	var organizationUnitForm = organizationUnitController.getOrganizationunit().getForm();
	    	var academyLocation;
	    	var values = organizationUnitForm.getValues();
	    	
	    	var mAL = values.multiselectAcademyLocation;
	    	if( mAL.length == 1 && mAL==""){
	  
	    		this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(true);
				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(false);
	    		
	    	}
	    	else{
	    		this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(false);
				this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);
	    	}
			

    	} else if(value.sectionCourse == 'room'){
    		form.findField('scheduleFor').setValue('room');
    		$this.getViewschedulesearch().down('#studentPeriodContainerItemId').setVisible(false);
    		$this.getViewschedulesearch().down('#facultyCodeNameId').setVisible(false);
    		$this.getViewschedulesearch().down('#roomComboId').setVisible(true);
    		form.findField('courseVariantPBS').setValue(null);
    		form.findField('COURSE_ID').hide();
    		form.findField('COURSE_ID').reset();
    		form.findField('course').hide();
    		form.findField('course').reset();
    		form.findField('section').hide();
    		form.findField('section').reset();
    		form.findField('section').setDisabled(true);

    		form.findField('program').hide();
    		form.findField('program').setValue(null);
    		form.findField('batch').hide();
    		form.findField('batch').setValue(null);
    		form.findField('programCoursesection').hide();
    		form.findField('programCoursesection').setValue(null);
    		form.findField('period').hide();
    		form.findField('period').setValue(null);

    		form.findField('facultyId').reset();
    		form.findField('room').reset();
    		form.findField('room').setVisible(true);
    		form.findField('COURSE_ACADEMIC_TERM').setVisible(false);
    		form.findField('COURSE_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').setVisible(false);
    		form.findField('PROGRAM_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').allowBlank = true;
    		form.findField('COURSE_ACADEMIC_TERM').allowBlank = true;

    		form.findField('intakeYear').hide();
    		form.findField('intakeYear').reset();

    		form.findField('studentProgramId').hide();
    		form.findField('studentProgramId').reset();
    		
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').setVisible(false);
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').reset();
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').allowBlank = true;
    		
    		form.findField('SECTION_GROUP_NAME').hide();
    		form.findField('SECTION_GROUP_NAME').setValue(null);
    		
    		form.findField('sectionGroupProgramName').hide();
    		form.findField('sectionGroupProgramName').setValue(null);
    		
    		form.findField('sectionGroupBatchName').hide();
    		form.findField('sectionGroupBatchName').setValue(null);
    		
    		form.findField('sectionGroupPeriodName').hide();
    		form.findField('sectionGroupPeriodName').setValue(null);
    		
    		form.findField('sectionGroupCourse').hide();
    		form.findField('sectionGroupCourse').setValue(null);
    		
    		
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').hide();
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').setValue(null);

    		form.isValid();
    		this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(false);
    		this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);

    		var roomStore = form.findField('room').getStore();
    		roomStore.getProxy().extraParams ={
    			academyLocationIds : $this.getAcademyLocationIds(),
    			onlyClassRoom : true,
    			name :''
    		}
    		roomStore.load();

    		grid.columns[0].setVisible(true);
    		grid.columns[1].setVisible(false);
    		grid.columns[2].setVisible(false);
    		grid.columns[3].setVisible(false);
    		grid.columns[4].setVisible(false);
    		grid.columns[5].setVisible(false);
    		grid.columns[6].setVisible(false);
    		grid.columns[7].setVisible(false);
    		grid.columns[8].setVisible(false);
    		grid.columns[9].setVisible(false);
    		grid.columns[10].setVisible(false);
    		grid.columns[11].setVisible(false);
    		grid.columns[12].setVisible(true);
    		grid.columns[13].setVisible(true);
    		grid.columns[14].setVisible(false);
    		grid.columns[15].setVisible(false);
    		grid.columns[16].setVisible(false);
    	}
    	else if(value.sectionCourse == 'sectionGroup'){
    		
    		form.findField('scheduleFor').setValue('sectionGroup');
    		$this.getViewschedulesearch().down('#studentPeriodContainerItemId').setVisible(false);
    		$this.getViewschedulesearch().down('#facultyCodeNameId').setVisible(false);
    		$this.getViewschedulesearch().down('#roomComboId').setVisible(false);
    		form.findField('courseVariantPBS').setValue(null);
    		form.findField('COURSE_ID').hide();
    		form.findField('COURSE_ID').reset();
    		form.findField('course').hide();
    		form.findField('course').reset();
    		form.findField('section').hide();
    		form.findField('section').reset();
    		form.findField('section').setDisabled(true);

    		form.findField('program').hide();
    		form.findField('program').setValue(null);
    		form.findField('batch').hide();
    		form.findField('batch').setValue(null);
    		form.findField('programCoursesection').hide();
    		form.findField('programCoursesection').setValue(null);
    		form.findField('period').hide();
    		form.findField('period').setValue(null);

    		form.findField('facultyId').reset();
    		form.findField('room').reset();
    		form.findField('room').setVisible(false);
    		
    		form.findField('COURSE_ACADEMIC_TERM').setVisible(false);
    		form.findField('COURSE_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').setVisible(false);
    		form.findField('PROGRAM_ACADEMIC_TERM').reset();

    		form.findField('PROGRAM_ACADEMIC_TERM').allowBlank = true;
    		form.findField('COURSE_ACADEMIC_TERM').allowBlank = true;
    		
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').setVisible(true);
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').reset();
    		form.findField('SECTION_GROUP_ACADEMIC_TERM').setFieldLabel(getCommonTranslation('ACADEMIC_TERM')+'<span class="required" style="color:red"> *</span>');

    		form.findField('SECTION_GROUP_ACADEMIC_TERM').allowBlank = false;

    		form.findField('intakeYear').hide();
    		form.findField('intakeYear').reset();

    		form.findField('studentProgramId').hide();
    		form.findField('studentProgramId').reset();
    		
    		form.findField('SECTION_GROUP_NAME').show();
    		form.findField('SECTION_GROUP_NAME').reset();
    		form.findField('SECTION_GROUP_NAME').setDisabled(true);
    		
    		form.findField('sectionGroupProgramName').show();
    		form.findField('sectionGroupProgramName').reset();
    		form.findField('sectionGroupProgramName').setDisabled(true);
    		
    		form.findField('sectionGroupBatchName').show();
    		form.findField('sectionGroupBatchName').reset();
    		form.findField('sectionGroupBatchName').setDisabled(true);
    		
    		form.findField('sectionGroupPeriodName').show();
    		form.findField('sectionGroupPeriodName').reset();
    		form.findField('sectionGroupPeriodName').setDisabled(true);
    		
    		form.findField('sectionGroupCourse').show();
    		form.findField('sectionGroupCourse').reset();
    		form.findField('sectionGroupCourse').setDisabled(true);
    		
    		
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').show();
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').reset();
    		form.findField('SECTION_GROUP_COURSE_VARIENT_NAME').setDisabled(true);
    		
    		
    		
    		form.isValid();
    		this.getViewschedulesearch().down("#scheduleSearchBtn").setDisabled(true);
    		this.getViewschedulesearch().down("#viewCalanderId").setDisabled(true);

    		grid.columns[0].setVisible(false);
    		grid.columns[1].setVisible(false);
    		grid.columns[2].setVisible(false);
    		grid.columns[3].setVisible(false);
    		grid.columns[4].setVisible(false);
    		grid.columns[5].setVisible(false);
    		grid.columns[6].setVisible(false);
    		grid.columns[7].setVisible(false);
    		grid.columns[8].setVisible(false);
    		grid.columns[9].setVisible(false);
    		grid.columns[10].setVisible(false);
    		grid.columns[11].setVisible(false);
    		grid.columns[12].setVisible(false);
    		grid.columns[13].setVisible(false);
    		grid.columns[14].setVisible(true);
    		grid.columns[15].setVisible(true);
    		grid.columns[16].setVisible(true);
    	}
    },
    disableRadioSelectionsPivilegesOnScheduleSearchForm: function(form, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        
        var permissionsMap2 = this.getMASTER_TIME_TABLE_PRIVILEGES();
        var permissionList2 = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap2);
        
        var programBatchSection=false, courseSection=false, courseGroup = false;
        var filterForm = form.getForm();
        var radioButton = filterForm.findField('courseSectionRadio');
        var criteriaBasedGradeFieldId = form.down('#courseSectionRadio_Id');
        criteriaBasedGradeFieldId.setVisible(false);
        var visible=[],count=0;
        if (Ext.Array.contains(permissionList2, "PROGRAM_BATCH_SECTION")) {
            criteriaBasedGradeFieldId.setVisible(false);
            radioButton.items.items[0].setValue(true);
            radioButton.items.items[1].setValue(false);
            radioButton.items.items[2].setValue(false);
            radioButton.items.items[3].setValue(false);
            radioButton.items.items[4].setValue(false);
            radioButton.items.items[5].setValue(false);
            visible.push(0);
            count++;

        }
        if (Ext.Array.contains(permissionList2, "COURSE_SECTION")) {
            criteriaBasedGradeFieldId.setVisible(false);
            radioButton.items.items[0].setValue(false);
            radioButton.items.items[1].setValue(true);
            radioButton.items.items[2].setValue(false);
            radioButton.items.items[3].setValue(false);
            radioButton.items.items[4].setValue(false);
            radioButton.items.items[5].setValue(false);
            visible.push(1);
            count++;
        }
        Ext.each(permissionList, function(privilege) {
            if (privilege === 'SECTION_GROUP') {
                criteriaBasedGradeFieldId.setVisible(false);
                radioButton.items.items[0].setValue(false);
                radioButton.items.items[1].setValue(false);
                radioButton.items.items[2].setValue(true);
                radioButton.items.items[3].setValue(false);
                radioButton.items.items[4].setValue(false);
                radioButton.items.items[5].setValue(false);
                visible.push(2);
                count++;
            }else if (privilege === 'FACULTY') {
                criteriaBasedGradeFieldId.setVisible(false);
                radioButton.items.items[0].setValue(false);
                radioButton.items.items[1].setValue(false);
                radioButton.items.items[2].setValue(false);
                radioButton.items.items[3].setValue(true);
                radioButton.items.items[4].setValue(false);
                radioButton.items.items[5].setValue(false);
                visible.push(3);
                count++;
            }else if (privilege === 'STUDENT') {
                criteriaBasedGradeFieldId.setVisible(false);
                radioButton.items.items[0].setValue(false);
                radioButton.items.items[1].setValue(false);
                radioButton.items.items[2].setValue(false);
                radioButton.items.items[3].setValue(false);
                radioButton.items.items[4].setValue(true);
                radioButton.items.items[5].setValue(false);
                visible.push(4);
                count++;
            }else if (privilege === 'ROOM') {
                criteriaBasedGradeFieldId.setVisible(false);
                radioButton.items.items[0].setValue(false);
                radioButton.items.items[1].setValue(false);
                radioButton.items.items[2].setValue(false);
                radioButton.items.items[3].setValue(false);
                radioButton.items.items[4].setValue(false);
                radioButton.items.items[5].setValue(true);
                visible.push(5);
                count++;
            }
           
        });
       if(count==0){
    	   criteriaBasedGradeFieldId.setVisible(false);
    	   radioButton.items.items[0].setValue(true);
       }else if(count>1){
    	   criteriaBasedGradeFieldId.setVisible(true);
    	  if(visible.length==radioButton.items.items.length){
    		  radioButton.items.items[0].setValue(true);
    	  }else{
    		  var flag=null;
    		  for(var j=0;j<radioButton.items.items.length;j++){
    			  if (visible.indexOf(j) > -1) {
    				  if(isNullOrEmpty(flag)){
    					  flag="value";
    					  var k=j;
    					  radioButton.items.items[k].setValue(true)
    				  }
    				  radioButton.items.items[j].setVisible(true);
    				}else{
    					radioButton.items.items[j].setVisible(false);
    				}
    		  }
    	  }
    	   
       }
       
    }
});
