Ext.define('Academia.controller.dashboard.OveriddenUserDashletsController', {
	extend : 'Academia.controller.base.BaseController',

	views : [ 'dashboard.OveriddenUserDashlets' ,"dashboard.UserAccessibleGrid",'dashboard.OveriddenUserAccessibleGrid',
	          'dashboard.GrantAccessWindow'],
	stores : [ 'securitysetup.PortalStore','dashboard.UserDashletStore','dashboard.UserOveriddenDashletStore',
	           'dashboard.NotAccessibleDashletStore'],
	           
	   refs : [ {
			ref : 'overiddenUserDashlets',
			selector : 'overiddenuserdashlets'
		} ],
   
	 init: function() {
	     this.control({
	         'overiddenuserdashlets livesearchcombo#user': {
	        	 select: function(combo,value) {
	        		 this.loadPortalCombo(combo,value);
	        		 this.enableGridTabPanle(combo,value);
	        	 }
	         },
	         'overiddenuserdashlets nestedJsonCombo#portalCombo': {
	        	 select : function(combo){
	       			 this.loadActiveTabGrid(combo.up('overiddenuserdashlets'));
	        		}
	        			
	         },
            'overiddenuserdashlets overiddenuseraccessiblegrid': {
                render: function(grid) {
//                    this.disableMoreActionPivileges(grid, this.getSELECTIONSTAGE_TRANSFERSEATS_PERMISSIONS(), '#transferseatsgrid');
                },
                activate: function( grid, eOpts ){
           			this.loadActiveTabGrid(grid.up('overiddenuserdashlets'));
                }
            },
            'useraccessiblegrid':{
            	 activate: function( grid, eOpts ){
            		 var form=grid.up('overiddenuserdashlets');
            		 this.loadActiveTabGrid(form);
            	 }
            },
			'useraccessiblegrid button#revokeAccessBtn' : {
				   click:  function(button){
					   this.revokeAccess(button);
				   }
			},
			'overiddenuseraccessiblegrid button#grantAccess' : {
				   click:  function(button){
					   this.showGrantAccessWindow(button);
				   }
			},
			'overiddenuseraccessiblegrid button#deleteBtn' : {
				   click:  function(button){
					   this.deleteRecord(button);
				   }
		   },
			'grantaccesswindow grid#grantAccessGrid':{
				 render: function(grid) {
					var overiddenuserdashletsForm= this.getOveriddenUserDashlets();
					 this.loadActiveGrid(overiddenuserdashletsForm,grid);
				 }
			},
			'grantaccesswindow button#grantAccessBtn':{
				click: function(button) {
					 this.saveAccessGranted(button);
				 }
			}
	     });
	 },
	 
	 enableGridTabPanle: function(combo,value) {
		 var form=combo.up('overiddenuserdashlets'),tabPanel=form.down('tabpanel#gridTabPanel');
		 if(value){
			 tabPanel.setDisabled(false);
			 this.loadActiveTabGrid(form);
		 }else{
			 tabPanel.setDisabled(true);
		 }
	 },
		
		loadPortalCombo: function(combo,date) {
			var id=combo.getValue(),comboPortal = combo.up('overiddenuserdashlets').down('#portalCombo');
        	  var store = Ext.create('Academia.store.authentication.PortalStore');
      		comboPortal.reset();
        	  var  url= SERVERURL.PORRAL_BY_USER;
        	  url = url.concat('?userId='+id); 
        	  store.getProxy().api.read = url;
        		 store.load();	 
        	  comboPortal.bindStore(store);
		},
		
		loadActiveTabGrid:function(overiddenuserdashletsForm){
			 var tabpanel=overiddenuserdashletsForm.down('tabpanel#gridTabPanel'), 
			 	grid=tabpanel.getActiveTab();
			 this.loadActiveGrid(overiddenuserdashletsForm,grid);
		},

		loadActiveGrid:function(overiddenuserdashletsForm,grid){
			 var portalId = overiddenuserdashletsForm.down('nestedJsonCombo#portalCombo').getValue(),
			 userId = overiddenuserdashletsForm.down('livesearchcombo#user').getValue();
			 if(userId){
	        	 var store= grid.getStore(),url=this.getUrlOfStore(store);
				 url = url.concat('?userId='+userId);
				 if(portalId){
						 url = url.concat('&portalId='+portalId); 
				 }
		    	 store.getProxy().api.read = url;
		    	 store.currentPage = 1;
		    	 store.load();	 
				 }
		},
	 revokeAccess : function(button){
			var this$=this,  grid=button.up('useraccessiblegrid'), form=grid.up('overiddenuserdashlets'), userId = form.down('livesearchcombo#user').getValue();
			this.overrideUserAccess(grid,userId, false,
					function(selectedRecord){ return this$.getNestedObject(selectedRecord.get('portalId')); },
					function(selectedRecord){ return this$.getNestedObject(selectedRecord.get('dashletId')); });
	 },
	 
	 saveAccessGranted :function(button){
			var this$=this,  grid=button.up('grantaccesswindow').down('#grantAccessGrid'), form= this.getOveriddenUserDashlets(),
				portalId = form.down('customcombobox#portalCombo').getValue(),
				userId = form.down('livesearchcombo#user').getValue();
			
			this.overrideUserAccess(grid,userId, true, 
					function(selectedRecord){ return this$.getNestedObject(portalId);},
					function(selectedRecord){ return this$.getNestedObject(selectedRecord.get('id'));} );
	 },
	 
	 overrideUserAccess :function(grid,userId,whetherAccessGranted,getPoratlId,getDashletId){
		 var $this = this;
        if (grid.getSelectionModel().getCount() > 0) {
            var selectedRecords = grid.getSelectionModel().getSelection();
            var submitData = new Array();
            for (var count = 0; count < selectedRecords.length; count++) {
                var selectedRecord = selectedRecords[count];
                if (!isEmpty(selectedRecord.data)) {
                	var selectedRecordObject = new Object();
	                selectedRecordObject.id = null;
	                selectedRecordObject.whetherAccessGranted = whetherAccessGranted;
	                selectedRecordObject.userId = userId;
	                selectedRecordObject.portal = getPoratlId(selectedRecord);
	                selectedRecordObject.dashlet = getDashletId(selectedRecord);
	                submitData.push(selectedRecordObject);
                }
            }
            this.sendSaveAjaxRequest(SERVERURL.SAVE_ALL_USER_OVERIDDEN_DASHLETS, 'POST', submitData, function(opt,success,response){
            	if(success){
            		$this.resetPageSetting(grid.getStore());
            		grid.getStore().load();
            		showSuccessMessage(getCommonTranslation('USER_ACCESSIBLE_DASHLETS'), getCommonTranslation('SUCCESS'));
            	}
	  		});
        } else {
            showWarningMessage(getCommonTranslation('USER_ACCESSIBLE_DASHLETS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
		 
	 },
	 
	 showGrantAccessWindow: function(button){
		 var form=button.up('overiddenuserdashlets'), portalId = form.down('#portalCombo').getValue();
		 if(portalId){
				this.showWindow('grantaccesswindow');
		 }else{
			   showWarningMessage(getCommonTranslation('GRANT_ACCESS_TO_DASHLET'), getCommonTranslation('PLEASE_SELECT_PORTAL'));
		 }
	 },	 
	 deleteRecord : function(button){
         var $this = this;
			var  grid=button.up('overiddenuseraccessiblegrid');
			if (grid.getSelectionModel().getCount() > 0) {
	            var selectedRecords = grid.getSelectionModel().getSelection();
	            var submitData = new Array();
	            for (var count = 0; count < selectedRecords.length; count++) {
	                var selectedRecord = selectedRecords[count];
	            	submitData.push(selectedRecord.get('id'));
		        }
	            Ext.Ajax.request({
                    method: "DELETE",
                    type: 'rest',
                    url: SERVERURL.DELETE_ALL_USER_OVERIDDEN_DASHLETS + '?ids=' + submitData.join(','),
                    headers: {
                        'Content-Type': 'application/json'
                    },
                   /* params: {
                        ids: submitData.join(',')
                    },*/
                    success: function(form, action) {
                    	$this.resetPageSetting(grid.getStore());
                        grid.getStore().load();
                        showSuccessMessage(getCommonTranslation('OVERIDDEN_USER_ACCESSIBLE_GRID'),getCommonTranslation('SUCCESS'));
                    }
                });
	            
        	/*showConfirmMessage(getCommonTranslation('OVERIDDEN_USER_ACCESSIBLE_GRID'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    
                }
            });*/
		} else {
	            showWarningMessage(getCommonTranslation('OVERIDDEN_USER_ACCESSIBLE_GRID'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	 }
});