Ext.define('Academia.controller.datasetting.IdGeneratorController', {
    extend: 'Ext.app.Controller',

	views:['common.IdGeneratorForm','common.IdGeneratorCustomForm'],

	
	stores : ['common.StatusComboStore',
	            'common.LiveSearchCombos',
	            'Academia.store.common.AcademyStore',
	            'Academia.store.common.SeatTypesByBatchId',
	            'Academia.store.common.LocationStore',
	            'Academia.store.common.ProgramsByAcademyIdLocationId',
	            'Academia.store.common.BatchesByProgramId', 
	            'Academia.store.common.SeatTypesByBatchId',
	            'Academia.store.common.Checklist',
	            'Academia.store.common.DocumentTypeStore',
	            'common.ActiveUserStore',
	            'Academia.store.messaging.MessageTemplate',
	            'datasetting.IdGeneratorMappingStore',
	            'datasetting.IdTableMappingStore'],
	            
    requires:[
	          'Academia.constants.CurrencyFormatConstants',
	          'Academia.utilities.CommonUtil',
               'Academia.utilities.vTypeValidations.Validation',
               'Academia.utilities.ErrorHandler',
               'Academia.utilities.plugins.AsteriskPlugin',
               'Academia.utilities.CustomAlerts',
               'Academia.utilities.JsonAjaxRequest',
               'Academia.utilities.ImageActionColumn',
               'Academia.utilities.accessControl.AccessControlManager',
               'Academia.utilities.accessControl.FeaturePrivilegeManager',
               // from base controller
               'Academia.utilities.plugins.TreeFilter',
               'Academia.utilities.ckEditor.CkEditor',
               'Academia.utilities.gridExporter',
               'Academia.utilities.DisplayFormatMap',
               'Academia.utilities.CurrencyFormatMap',
               'Academia.utilities.plugins.SessionMonitor',
               'Academia.utilities.currency.CurrencyManager',
               'Academia.utilities.date.DateHelper',
               'Academia.utilities.ux.PageSize', 
               'Academia.utilities.ux.CustomPagingToolBar',
               'Academia.utilities.ux.AutoGroupedColumn',
               'Academia.utilities.ux.GroupingComboBox','Academia.view.common.ExtendedDatePicker',
               'Academia.utilities.ux.CustomComboBox',
               'Academia.view.MultipleFileUpload',
               'Academia.view.MultipleDragAndDrop',
               'Academia.utilities.ImageCrop',
               'Academia.utilities.ColumnProgressBar'
               ],

	init : function(application) {
		this.control({
			'idgeneratorform' : {
				'render' : function(form, eOpts) {
					this.toggleReadOnlyFormItems(form);
				}
			},
			'idgeneratorcustomform' : {
				'render' : function(form, eOpts) {
					this.toggleReadOnlyFormItems(form);
				}
			}
		});
	},

	toggleReadOnlyFormItems : function(form) {
		var formCode = form.formCode; //
		if (formCode) {
			var store = Ext.data.StoreManager.lookup('datasetting.IdGeneratorMappingStore');
			if(store){
				var record = store.findRecord('formCode', formCode); // idFormMap[formCode]
				if(record){
					var tableName = record.get('tableName');
					if (tableName) {
						var idTableMappingStore = Ext.data.StoreManager.lookup('datasetting.IdTableMappingStore');
						if (idTableMappingStore) {
							var idTableMappingRecord = idTableMappingStore.findRecord('tableName', tableName,0,false,true,true);  
							if (idTableMappingRecord) {
								var fieldName = idTableMappingRecord.get('columnName');
								var configField = record.get('fieldConfig');
								var formFieldName = configField[fieldName];
								if(formFieldName){
									var basicForm = form.getForm();
									Ext.suspendLayouts();
									var field = basicForm.findField(formFieldName);
									field.setReadOnly(true);
									field.allowBlank=true;
								
									var listnerFunction=null;
									listnerFunction=function(value){
										 field.setReadOnly(false);
										 field.allowBlank=false;
										 field.removeListener('change',listnerFunction);
									};
									field.on('change',listnerFunction);
								       
									Ext.resumeLayouts();
									form.doLayout() ;
								}
							}
						}
					}
				}
			}
		}
	}
});
