/**
 * @author Utsav Chandvaniya
 */
Ext.define('Academia.controller.enquiry.checkList.CheckListController', {
	extend : 'Ext.app.Controller',
	alias : "widget.checklistcontroller",
	views :  ['enquiry.checkList.CheckListStructure'],

	          refs : [{
	        	  ref : 'examdetailForm',
	        	  selector : 'examdetailform form'
	          },{
	        	  ref : 'examdetailform',
	        	  selector : 'examdetailform'
	          },{
	        	  ref : 'examdetailgrid',
	        	  selector : 'examdetailgrid'
	          },{
	        	  ref : 'examdetailstructure',
	        	  selector : 'examdetailstructure' 
	          },{
	        	  ref : 'enquirytabstructure',
	        	  selector : 'enquirytabstructure' 
	          }],
	          init : function() {
	        	  this.control({
	        		  'examdetailgrid button[itemId=btnAdd]':{
	        			  click:this.showFormWindow 
	        		  },
	        		  'examdetailgrid button[itemId=btnEdit]':{
	        			  click:this.editFormWindow 
	        		  },
	        		  'examdetailgrid button[itemId=btnDelete]':{
	        			  click:this.deleteFormWindow 
	        		  },
	        		  'examdetailgrid button[itemId=btnView]':{
	        			  click:this.viewFormWindow 
	        		  },
	        		  'examdetailform button[itemId=examdetail_submitbuttonId]':{
	        			  click:this.saveExamDetail 
	        		  },
	        		  'examdetailform button[itemId=examdetail_cancelbuttonId]':{
	        			  click:this.cancelExamDetail 
	        		  },
	        		  'examdetailform radiogroup[itemId=ED_radioBtn]':{
	        			  change:function(f){
	        				  this.onProgramSelection(f);
	        			  }
	        		  },
	        		  'examdetailstructure':{
	        			  render:function(component,options){
	        				  this.onExamFormRender(component,options);
	        			  }
	        		  },'examdetailform combo[itemId=programId]':{
	        			  select:function(c,r){
	        				  this.getExamdetailForm().getForm().findField('programCodeExamDeatil').setValue(r[0].data.code);
	        			  }
	        		  }
	        	  });
	          },
	          enableRadioButton : function(){

	        	  var form = this.getExamdetailForm();
	        	  var examform = form.getForm();
	        	  var radiobutton = examform.findField("programExam");
	        	  radiobutton.items.items[0].setValue(false);
	        	  radiobutton.items.items[1].setValue(true);
	          },

	          cancelExamDetail : function(){
	        	  var form = this.getExamdetailform();	
	        	  form.close();
	          },
	          showFormWindow : function() {

	        	  var formWindow = this.getExamdetailform();
	        	  if (!formWindow) {
	        		  Ext.widget('examdetailform');
	        		  formWindow = this.getExamdetailform();
	        	  }
	        	  formWindow.show();

	          },
	          editFormWindow: function() {

	        	  //  var grid = this.getExamdetailgrid();

	        	  var grid = Ext.getCmp('examDetail_grid');
	        	  var store=this.getStore('enquiry.exam.ExamDetailStore');
	        	  var selectedRecord = grid.getSelectionModel().getSelection()[0];
	        	  var row = store.indexOf(selectedRecord);
	        	  var storedata=store.getAt(row);
	        	  if (grid.getSelectionModel().getCount() > 0) {
	        		  this.showFormWindow();
	        		  var form = this.getExamdetailForm();
	        		  var f=form.getForm();
	        		  var records = grid.getSelectionModel().getSelection();
	        		  var programCombo=f.findField('program');
	        		  if (storedata != undefined && storedata != "" && storedata != null) {
	        			  form.loadRecord(storedata);

	        			  var pursuingExamDetal = Ext.ComponentQuery.query('radiogroup#ED_radioBtn')[0]; 
	        			  if(storedata.data.programExamType==="Current Pursuing"){
	        				  pursuingExamDetal.items.items[0].setValue(true);
	        				  pursuingExamDetal.items.items[1].setValue(false);
	        				  Ext.ComponentQuery.query('combo#examStatusDetail')[0].reset()
	        			  }else{
	        				  pursuingExamDetal.items.items[0].setValue(false);
	        				  pursuingExamDetal.items.items[1].setValue(true);

	        			  }

	        			  programCombo.store.load({
	        				  callback: function(r, operation, success) {
	        					  if (success) {
	        						  programCombo.setValue(records[0].data.enqProgramMaster.id);
	        					  }
	        				  }
	        			  });



	        		  }

	        		  //  this.enableRadioButton();

	        	  } else {
	        		  showWarningMessage(getCommonTranslation('EXAMTITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	        	  }
	          },
	          deleteFormWindow : function (){
	        	  var grid =  Ext.getCmp('examDetail_grid');
	        	  var grdStore = grid.getStore();  

	        	  if(grid.getSelectionModel().getCount()>0){
	        		  var records=grid.getSelectionModel().getSelection();						        
	        		  var id=records[0].get("id");
	        		  Ext.Ajax.request({
	        			  method: "DELETE",
	        			  type: 'rest',
	        			  url: SERVERURL.ENQUIRY_EXAM_DETAIL_DELETE+'?id='+id,
	        			  headers: {
	        				  'Content-Type': 'application/json'
	        			  },
	        			  success:function(form, action){
	        				  grdStore.reload();
	        				  showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('DELETE_ENQUIRY_MSG'));//Location deleted successfully
	        			  }
	        		  });
	        	  }else{
	        		  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
	        	  }
	          },
	          viewFormWindow : function(){

	        	  this.editFormWindow();
	        	  var form =this.getExamdetailForm();
	        	  if (form) {
	        		  form.down('#examdetail_submitbuttonId').setVisible(false);
	        		  form = form.getForm();
	        		  toggleReadOnlyFormItems(form, true);
	        	  }
	          },
	          saveExamDetail : function(){

	        	  var me = this;

	        	  var grid =  Ext.getCmp('examDetail_grid');
	        	  var grdStore = grid.getStore();  

	        	  var formWindow = me.getExamdetailForm().getForm();	

	        	  var commonForm = me.getEnquirytabstructure().getForm();
	        	  var commonVal = commonForm.getValues();
	        	  var enquiryId = commonVal.enqId;
	        	  var programExamDetal=formWindow.findField('program');
	        	  var value = formWindow.getValues();
	        	  var pursuingExamDetal = Ext.ComponentQuery.query('radiogroup#ED_radioBtn')[0];
	        	  var curntlyPrsuing = pursuingExamDetal.items.items[0].checked;

	        	  var examdetailgridModel = new Academia.model.enquiry.exam.ExamDetailModel();
	        	  examdetailgridModel.set("programYear",value.programYear);


	        	  if(curntlyPrsuing){
	        		  examdetailgridModel.set("examStatus","Pur");
	        		  examdetailgridModel.set("examResult");
	        	  }else{
	        		  examdetailgridModel.set("examStatus",value.examStatus);
	        		  examdetailgridModel.set("examResult",value.examResult);
	        	  }

	        	  /*if(value.examStatus==null || value.examStatus==''){
	        	      examdetailgridModel.set("examStatus","Pur");
	        	  }else{
	        		  examdetailgridModel.set("examStatus",value.examStatus);
	        	  }*/

	        	  examdetailgridModel.set("programConductedBy",value.programConductedBy);
	        	  examdetailgridModel.set("enqProgramMaster",me.getIdValueJson(programExamDetal.getValue(),programExamDetal.getRawValue(),value.programCodeExamDeatil));
	        	  examdetailgridModel.set("enquiry",me.getIdValueJson(enquiryId));
	        	  examdetailgridModel.set("whetherDeleted",false);
	        	  if(curntlyPrsuing){
	        		  examdetailgridModel.set("programExamType","Current Pursuing");
	        	  }else{
	        		  examdetailgridModel.set("programExamType","Previous Passed Exam");
	        	  }


	        	  if (value.id == null ||value.id == "") {
	        		  submitUrl = SERVERURL.ENQUIRY_EXAM_DETAIL_CREATE;
	        	  } else {
	        		  examdetailgridModel.set("id",value.id);
	        		  submitUrl = SERVERURL.ENQUIRY_EXAM_DETAIL_UPDATE;
	        	  }

	        	  var submitData = Ext.encode(examdetailgridModel.data);


	        	  Ext.Ajax.request({
	        		  url: submitUrl,
	        		  jsonData: submitData,
	        		  method: 'POST',
	        		  success: function(response) {
	        			  grdStore.reload();
	        			  me.cancelExamDetail();
	        			  showSuccessMessage(getCommonTranslation('EXAMTITLE'),getCommonTranslation('SUCCESS'));
	        		  }
	        	  });

	          },

	          onProgramSelection : function(f){

	        	  var form = this.getExamdetailForm().getForm();
	        	  var curntlyPrsuing = f.items.items[0].checked;
	        	  if(!curntlyPrsuing){
	        		  var result = form.findField("examResult");
	        		  var status = form.findField("examStatus");
	        		  result.show();
	        		  status.show();
	        		  result.allowBlank = false;
	        		  status.allowBlank = false;

	        		  result.setFieldLabel(getCommonTranslation('EXAM_RESULT')+'<span class="required" style="color:red"> *</span>');
	        		  status.setFieldLabel(getCommonTranslation('STATUS')+'<span class="required" style="color:red"> *</span>');

	        		  //f.ownerCt.getPlugin().onBeforeRender(this.getExamdetailForm());

	        	  }else{
	        		  var result = form.findField("examResult");
	        		  var status = form.findField("examStatus");
	        		  result.reset();
	        		  status.reset();
	        		  result.hide();
	        		  status.hide(); 
	        		  result.allowBlank = true;
	        		  status.allowBlank = true;
	        		  form.isValid()
	        	  }
	          },
	          onExamFormRender:function(component,options){


	        	  var commonForm = this.getEnquirytabstructure().getForm();
	        	  var commonVal = commonForm.getValues();
	        	  var enquiryId = commonVal.enqId;

	        	 /// var examStructure = this.getExamdetailstructure();
	        	  
	        		  
	        		  var grid = this.getExamdetailgrid();
	        		  var store = grid.getStore();

	        		  store.getProxy().extraParams = {
	        			  id: enquiryId
	        		  };
	        		  store.load();
	          },
	          getIdValueJson: function(id, value,code) {
	        	  if (id) return {
	        		  id: id,
	        		  value: value,
	        		  code:code
	        	  };
	          }
});
