/**
 * @author Dharmendra.prajapti
 * 
 */
Ext.define('Academia.controller.examCenter.sequenceManagement.AssignSequenceController', {
	extend : 'Academia.controller.base.BaseController',
	models : ['common.IdValueCodeDataModel','genericmodels.dropdowns.EnumCombo','examCenter.assignSequence.assignSequence',
	          'enquiry.AcademicBatchModel'
	          ],
	stores : ['Academia.store.examCenter.AssignSequence.AssignSeqenceMethodStore','examCenter.AssignSequence.Program',
	          'enquiry.AcademicBatchStore','examCenter.AssignSequence.EvaluationType',
	          'examCenter.AssignSequence.AssignSeqItemSelector','common.ProgramStore','enquiry.AcademicBatchStore'],
	views : ['Academia.view.examCenter.assignSequence.AssignSequencGrid','examCenter.assignSequence.AssignSequencStructure','examCenter.assignSequence.AssignSequencesDropDown',
	         'examCenter.assignSequence.AssignSequenceWin','examCenter.assignSequence.AssignSequenceGridWin' 
	         ],	    
	config:{
	        	 /*
	            	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
	             		   	 */
	             	   	/**
	             	        * @cfg {Array} ASSIGN_SEQUENCE_PERMISSION array (required)
	             	        * The array of permissions to use for Access control wise enabling and disabling buttons.
	             	        * @accessor
	             	        */
			ASSIGN_SEQUENCE_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ASSIGN_SEQUENCE_PRIVILEGES')
	             
	         },            

	          refs : [{
	               ref: 'assignsequencgrid',  
	               selector: 'assignsequencgrid' // searchresultgrid[itemId=assignSequenceGridId]
	           },{
	               ref: 'assignSequenceGridWin',
	               selector: 'searchresultgrid[itemId=assignSequenceGridWinItemId]'
	           },{
	               ref: 'assignsequencesdropdown',
	               selector: 'assignsequencesdropdown'
	           },{
	               ref: 'assignSequencewin',
	               selector: 'assignsequencewin form'
	           },{
	               ref: 'assignsequencewin',
	               selector: 'assignsequencewin'
	           },{
	               ref: 'assignsequencegridwin',
	               selector: 'assignsequencegridwin'
	           }/*{
	               ref: 'searchresultgrid',
	               selector: 'searchresultgrid[itemId=assignSequenceGridId]'
	           },*/
	          ],
	          
	          init : function() {
	        	  this.control({
	        		  'assignsequencewin': {
	        			afterrender:function(window){
	        				$this = this;
	        				var filterForm = window.down('form');
	        				window.body.on('click',function() {
          						$this.hideInvalidIconFromField(filterForm);
        			       });
	        			}  
	        		  },
	        		  'assignsequencgrid splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	      	            click: function() {
	      	            	var searchResultGrid = this.getAssignSequenceGrid();
	      	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,searchResultGrid);
	      	            }
	      	        },
	      	        'assignsequencgrid splitbutton[itemId=exportToPdfBtn] #exportAll': {
	      	            click: function() {
	      	            	var searchResultGrid = this.getAssignSequenceGrid();
	      	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,searchResultGrid);
	      	            }
	      	        },
	      	        'assignsequencgrid splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	      	            click: function() {
	      	            	var searchResultGrid = this.getAssignSequenceGrid();
	      	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,searchResultGrid);
	      	            }
	      	        },
	      	        'assignsequencgrid splitbutton[itemId=exportToXcelBtn] #exportAll': {
	      	            click: function() {
	      	            	var searchResultGrid = this.getAssignSequenceGrid();
	      	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,searchResultGrid);
	      	            }
	      	        },
	        		  'assignsequencewin button[itemId=assingSeqSubmit]':{
	        			  click:this.addAssignSeqences
	        		  },
	        		  'assignsequencewin button[itemId=assingSeqCancel]':{
	        			  click:function(){
	        				 this.getAssignsequencewin().close();
	        			  }
	        		  },
	        		  'assignsequencgrid button[itemId=btnAdd]': {  
	            			 click: this.openSeqAssignForm
	            		 },
            		 'assignsequencgrid button[itemId=btnEdit]': {
            			 click: this.editAssignSeqForm
            		 }, 
            		 'assignsequencgrid button[itemId=btnDelete]': {
	            			 click: this.deleteAssignSeqForm
	                 },
	        		 'assignsequencgrid': {  
	                         render: function(grid){
							    this.gridRenderFunction(grid);                            
	                             //this.genericCBGridAccessControlValidation(grid,this.getASSIGN_SEQUENCE_PERMISSION());
								 this.doAccessControlValidation(grid,this.getASSIGN_SEQUENCE_PERMISSION());
	                         },
							  beforerender:function(grid){
	        			       grid.getStore().removeAll();
	        		            },  
	        		            cellclick:function(View, CellEl, ColIdx, Store, RowEl, RowIdx, Event){
	        		            	if(Event.target.tagName == 'A') {
	        		            		var grid= this.getAssignsequencgrid();
	        		            		var columnName = grid.columnManager.columns[ColIdx].dataIndex;
	        		            		if(columnName=='countOfSequenceAssigned'){   
	        		            			this.openSeqAssignGridWindow(View, CellEl, ColIdx, Store, RowEl, RowIdx, Event);
	        		            		}
	        		            	}
	        		            }
	                 },
					gridpermissionControlValidation: function(grid,map){
							var me=this;
					       var associatedAcadLocationIds = new Array();
				         associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
				        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,me.getASSIGN_SEQUENCE_PERMISSION());
            		 
				},
	        		
            		 'assignsequencesdropdown button[itemId=searchBtn]': {
                         click: this.loadAssignSequenceGridData 
                     },
                     'assignsequencesdropdown button[itemId=resetBtn]': {
                         click: function(obj){
                        	var form= obj.up('form').getForm()
                        	form.findField('batch').setDisabled(true);
                        	form.reset();
                         }
                     },
                    /* 'assignsequencesgrid button[itemId=btnEdit]':{
		      				click : this.editAssignSeqWindow
		      			},*/
            		 'assignsequencesdropdown combo[itemId=programId]':{
            			 select:function(obj,rec){	    
	        				  var data=rec[0].data.id;	        				   				  
	        				  var form=obj.up('form').getForm();	       				 
	        				  var batchField=form.findField('batch');
	        				  batchField.enable();
	        				  batchField.clearValue();
	        				  batchField.getStore().getProxy().extraParams = {
	        					 id: data
    	    				   };
	        				 batchField.getStore().load();
	        				 var evaluationTypeField=form.findField('evaluationType');
	        				 evaluationTypeField.enable();
	        				 evaluationTypeField.clearValue();
	        				 evaluationTypeField.getStore().getProxy().extraParams = {
	        					 id: data
   	    				   };
	        				 evaluationTypeField.getStore().load();
	        			  }
            		 },
            		 'assignsequencewin combo[itemId=programId]':{
            			 select:function(obj,rec){	    
	        				  var data=rec[0].data.id;	        				   				  
	        				  var form=obj.up('form').getForm();	       				 
	        				  var batchField=form.findField('batch');
	        				  batchField.enable();
	        				  batchField.clearValue();
	        				  batchField.getStore().getProxy().extraParams = {
	        					 id: data
    	    				   };
	        				 batchField.getStore().load();
	        			  }
            		 }
	        	  });
	        	  this.callParent(arguments);
	          },
	          openSeqAssignGridWindow:function(){
		        	var formWindow = this.getAssignsequencegridwin();
					if (!formWindow) {
						Ext.widget('assignsequencegridwin');
						formWindow = this.getAssignsequencegridwin();
					}
					formWindow.show();
					this.loadAssignSequenceGridWin();
					formWindow.center();
					Ext.defer(function() {
						formWindow.center();
						Ext.defer(function() {
							formWindow.center();
						}, 100);
					}, 100);
		       },
	          loadAssignSequenceGridWin : function(model,records){
	      		var quickSearchForm = this.getAssignsequencesdropdown();
	      		var searchResultGridMain = this.getAssignsequencgrid();  
	    		 if(searchResultGridMain.getSelectionModel().getCount()>0){
           		var records=searchResultGridMain.getSelectionModel().getSelection()[0];
	            var jsonFormatFormData = this.createJsonFormatWin(quickSearchForm, records);
	            var searchResultGrid = this.getAssignSequenceGridWin();
	            var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	            resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.EXAM_SEQUENCE_LISTING_VIEWCODE);
	            searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	    		}
	    	},
	    	createJsonFormatWin: function(quickSearchForm, records) {
	    		 var form =  quickSearchForm.getForm();
	    		 var values =form.getValues();
	    	     var values = new Object();
	    	     var searchcriteria = new Array();
	             values.configCode = CONSTANTS.CB.EXAM_SEQUENCE_LISTING_CONFIGCODE;
	            
	             var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID', records.data.academyLocationId);
	    	     this.pushJsonObjectInArray(ACADEMY_LOCATION_ID,searchcriteria);
	    	     
	    	     var PROGRAM_BATCH_ID = this.getJsonObject('PROGRAM_BATCH_ID', records.data.programBatchId);
	    	     this.pushJsonObjectInArray(PROGRAM_BATCH_ID,searchcriteria);
	             
	    	    
    	    	 var EVALUATION_TYPE = this.getJsonObject('EVALUATION_TYPE',records.data.evaluationType);
	    	     this.pushJsonObjectInArray(EVALUATION_TYPE,searchcriteria); 
	    	    	
	             values.searchCriterias = searchcriteria;
	             return values;
	    	    },
	    	    getJsonObject: function(key, value, additionalValue) {
	    	         if (value != '' && value != null && additionalValue == undefined) {
	    	             return {
	    	                 "paramCode": key,
	    	                 "paramValues": [value]
	    	             };
	    	         } else if (value != '' && additionalValue != undefined) {
	    	             return {
	    	                 "paramCode": key,
	    	                 "paramValues": [value, additionalValue]
	    	             };
	    	         }
	    	     },
	    	     pushJsonObjectInArray: function(object, array) {
	    	         if (object) {
	    	             array.push(object); 
	    	         }
	    	     },
	      	gridRenderFunction: function(grid) {
	            grid.addDocked({
	                xtype: 'toolbar',
	                dock: 'top',
	                items: [{
	                    xtype: 'button',
	                    itemId: 'btnAdd',
	                    tooltip: getCommonTranslation('ADD'),
	                    iconCls:'icon-addbutton',
						 cls:'addbutton'
	                }, {
	                    xtype: 'button',
	                    itemId: 'btnEdit',
	                    tooltip: getCommonTranslation('EDIT'),
	                    iconCls:'icon-editbutton',
						cls:'editbutton'
	                },
	                /*{
	                    xtype: 'button',
	                    itemId: 'btnView',
	                    tooltip: getCommonTranslation('VIEW'),
	                    iconCls: 'view-icon'
	                },*/
	                {
	                    xtype: 'button',
	                    itemId: 'btnDelete',
	                    cls: 'CustomToolbarBtnReject',
	                    tooltip: getCommonTranslation('DELETE'),
	                    iconCls: 'icon-Delete',
						cls:'iconDelete'
	                }]
	            });
	        },
	        /**
	         * This function is not in use.
	         * This function is previously used.
	         */
	        openAssignSeqForm:function(){
	        	var form =this.getAssignsequencesdropdown().getForm();
	        	 var values =form.getValues();
	        	 var error = getExaminationTranslation('RECORD');
	    		 var batchId = values.batch;
	    		 var evaluationType = values.evaluationType;
	    		 var programId =values.program;
	    		 if(programId == ""){
	    			 error = getExaminationTranslation('PROGRAM');
	    		 }else if(batchId ==""){
	    			 error = getExaminationTranslation('BATCH');
	    		 }else if(evaluationType ==""){
	    			 error = getExaminationTranslation('EVALUATION_TYPE');
	    		 }
	        	if(batchId!="" && batchId!=null &&programId!="" && programId!=null && evaluationType!="" && evaluationType!=null){
	        	var formWindow = this.getAssignsequencewin();
				if (!formWindow) {
					Ext.widget('assignsequencewin');
					formWindow = this.getAssignsequencewin();
				}
				formWindow.show();
			var store = this.getStore('examCenter.AssignSequence.AssignSeqItemSelector');	
				store.load();
	        }else{
	        	showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation("PLEASE_SELECT")+" "+ error );
	        }
	       },
	       openSeqAssignForm:function(){
	        	var formWindow = this.getAssignsequencewin();
				if (!formWindow) {
					Ext.widget('assignsequencewin');
					formWindow = this.getAssignsequencewin();
				}
				formWindow.show();
			var store = this.getStore('examCenter.AssignSequence.AssignSeqItemSelector');	
				store.load();
	       },
	         // add Assign Seqences
	     addAssignSeqences:function(){
	        var $this = this;
	    	var searchForm =$this.getAssignsequencesdropdown().getForm();
	       	var values =searchForm.getValues();
	       	var form = $this.getAssignSequencewin().getForm();
            var formfields = $this.getAssignSequencewin();
            var submitButton = formfields.down("#assingSeqSubmit");       
            submitButton.setDisabled(true); 
	       	var assignSeqValues =form.getValues();
	       	
	        seqId = assignSeqValues.seqName;
	   		var assignSequence = new Academia.model.examCenter.assignSequence.assignSequence();
	   		assignSequence.set("batchId",assignSeqValues.batch);
	   		assignSequence.set("programId",assignSeqValues.program);
	   		assignSequence.set("evaluationType",assignSeqValues.evaluationType);
	   		var sequenceHeaders=[];
	   		
	   		if(seqId.length>0){ 
				 for( var i in seqId) {
					 if(Ext.isObject(seqId[i])){
						 sequenceHeaders.push({
		        			  "id":seqId[i].data.id,
		        			  "value":seqId[i].data.value,
		        			  "code":seqId[i].data.code
		      			  });
		                }else{
	                	  sequenceHeaders.push({
		        			  "id":seqId[i]
		      			  });
		                }
	        		}
		   		}
	   		assignSequence.set("sequenceHeaders",sequenceHeaders);
	   		
	   		var submitUrl;
			if (assignSeqValues.id == null || assignSeqValues.id == "") {
				assignSequence.set("academyLocationId",$this.getCurrentAcademyLocation());
				submitUrl = SERVERURL.ASSIGN_SEQ_CREATE;
			} else {
				assignSequence.set("id", assignSeqValues.id);
				assignSequence.set("academyLocationId",$this.getCurrentAcademyLocation());
				
				// ids to deleted at update time
		   		var idsToDelete =[];
		   		var deleteIds = assignSeqValues.idsToDelete;
		   		if(assignSeqValues.id!="" && assignSeqValues.id > 0){
		   			var array = deleteIds.split(',');
		   			var result=[];
		   			for (var i=0,l=array.length;i<l;i++){
		   			result.push(+array[i]); 
		   			}
					assignSequence.set("idsToDelete",result);
		   		}
				
				submitUrl = SERVERURL.ASSIGN_SEQ_UPDATE;
			}
			delete assignSequence.data.academyId;
			delete assignSequence.data.locationId;
			var formData = Ext.encode(assignSequence.data);
			 $this.applyWindowMask(); 
			Ext.Ajax.request({
						type : 'rest',
						url : submitUrl,
						jsonData : formData,
						method : 'POST',
						success : function(form, action) {
							 $this.hideWindowMask();
							showSuccessMessage(getExaminationTranslation('SEQUENCE'),getCommonTranslation('SUCCESS'));
							$this.getStore('examCenter.AssignSequence.Program').load();
			    			$this.getAssignsequencewin().close();
			    			$this.getAssignsequencgrid().getStore().reload(); 
						},
			failure : function(form, action) {
				submitButton.setDisabled(false);
			}
			
					});
		
	        },
	        
	        /***********Edit**********************/
	        editAssignSeqForm:function(){
	        	var $this = this;
				var grid = $this.getAssignsequencgrid();  
				if (grid.getSelectionModel().getCount() > 0) {
					$this.openSeqAssignForm();
					var records = grid.getSelectionModel().getSelection();
					if (records != undefined && records != ""&& records != null) {
						var ACADEMY_LOCATION_ID = records[0].data.academyLocationId;
						var PROGRAM_BATCH_ID = records[0].data.programBatchId;
						var EVALUATION_TYPE = records[0].data.evaluationType;
				        Ext.Ajax.request({
							type : 'rest',
							url : SERVERURL.ASSIGN_SEQ_FIND_BY_IDS,
							params : {
								academyLocationId : ACADEMY_LOCATION_ID,
								batchId:PROGRAM_BATCH_ID,
								evaluationType:EVALUATION_TYPE
							},
					        method : 'GET',
					        success : function(response) { 
					        var form = $this.getAssignSequencewin().getForm();	
					        var data = Ext.decode(response.responseText);
							var assignSequence = new Academia.model.examCenter.assignSequence.assignSequence(data);
							form.loadRecord(assignSequence);
							var programField=form.findField('program');
							var batchField=form.findField('batch');
							/**
							 * Load Asign Seq Window Data
							 * 
							 */
					        //form.findField('academylocationId').setValue(data.academyLocationId);
							if(data.programId!=null){
								programField.enable();
								programField.getStore().load({
		        					 callback: function(records, operation, success) {
		      	              			 if (success) {
		      	              				programField.setValue(data.programId);
		      	              			 }
		      	              		 }
		        				});
								
								if(data.batchId!=null){
									batchField.enable();
									batchField.getStore().getProxy().extraParams = {
										id:data.programId
				    				   };
									batchField.getStore().load({
			        					 callback: function(records, operation, success) {
			      	              			 if (success) {
			      	              				batchField.setValue(data.batchId);
			      	              			 }
			      	              		 }
			        				});
								}
							}
							var arrayData=[];
							var sequenceHeader =data.sequenceHeaders;
							if(sequenceHeader.length > 0){
							for(var i=0; i<sequenceHeader.length;i++)
		    					arrayData.push(sequenceHeader[i].id);
							}
							form.findField('seqName').setValue(arrayData);
							
							var idsToDelete =[];
							if(data.idsToDelete.length > 0){
								for(var i=0;i<data.idsToDelete.length;i++){
									idsToDelete.push(data.idsToDelete[i]);
								}
							}
	 				       form.findField('idsToDelete').setValue(idsToDelete);
						}
					});
					}
				} else {
					showWarningMessage(getExaminationTranslation('SEQUENCE'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
	        },
	        deleteAssignSeqForm:function(){
	        	var $this = this;
				var grid = $this.getAssignsequencgrid();
				if (grid.getSelectionModel().getCount() > 0) {
					showConfirmMessage(getExaminationTranslation('SEQUENCE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
					function(btn, text) {
						if (btn == 'yes') { 
							var records = grid.getSelectionModel().getSelection()[0];
							var id = records.data.id;  
							Ext.Ajax.request({
								method : "DELETE",
								type : 'rest',
								url : SERVERURL.ASSIGN_SEQ_DELETE+ '?id='+ id,
								headers : {
									'Content-Type' : 'application/json'
								},
								params : {  
									id : id
								},
								success : function(form,action) {
									showSuccessMessage(getExaminationTranslation('SEQUENCE'),getCommonTranslation('SUCCESS'));									
									grid.getStore().reload();
								}
							});
					  }
				   });
				}else{
					showWarningMessage(getExaminationTranslation('SEQUENCE'),getCommonTranslation('PLEASE_SELECT_RECORD'));	
				}
	        },
	           loadAssignSequenceGridData : function(model,records){
					this.saveAssignsequencgrid(model); 
		       },

				saveAssignsequencgrid: function(btn) { 
					var me = this;
            		var assignsequencesdropdown = btn.up('assignsequencesdropdown');
            		var assignsequencstructure = btn.up('assignsequencstructure');
            		var assignsequencgrid = assignsequencstructure.down('assignsequencgrid');
            		var assignsequencform = assignsequencstructure.down('assignsequencesdropdown');
            		var gridStore = assignsequencgrid.getStore();
            		var assignsequencformValues = assignsequencform.getForm().getValues();
            		gridStore.removeAll();  
            		//assignsequencform.getForm().reset();
					me.resetPageSetting(gridStore, assignsequencgrid);  
                    //assignsequencgrid.getStore().load();     
		            assignsequencgrid.getStore().pageSize=100;    
					
					gridStore.getProxy().extraParams={
            			evaluationType: assignsequencformValues.evaluationType,
            			programBatchId: assignsequencformValues.batch, 
            			academyLocationId:me.getCurrentAcademyLocation()
            		};
					
					gridStore.load({
            			scope:this,
            			callback: function (records, operation, success) {
            				if(success){
            					
            					if(records.length){
            						assignsequencgrid.down('#btnExportToPDF').setDisabled(false);
            						assignsequencgrid.down('#btnExportToExcel').setDisabled(false);
            					}
            					else{
            						assignsequencgrid.down('#btnExportToPDF').setDisabled(true);
            						assignsequencgrid.down('#btnExportToExcel').setDisabled(true);
            					}
            					 
            				}
            			}
            		});
				},
		    	 createJsonFormat: function(quickSearchForm, record) {
		    		 var form =  quickSearchForm.getForm();
		    		 var values =form.getValues();
		    		 var batchId = values.batch;
		    		 var evaluationType = values.evaluationType;
		    		 var academyLocationId=this.getCurrentAcademyLocation();
		    	     var values = new Object();
		    	     var searchcriteria = new Array();
		             values.configCode = CONSTANTS.CB.EXAM_ASSIGN_SEQUENCE_LISTING_CONFIGCODE;
		             
		             var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID', academyLocationId);
		    	     this.pushJsonObjectInArray(ACADEMY_LOCATION_ID,searchcriteria); 
		    	     
		             if(batchId !=null && batchId !=""){
		    	     var PROGRAM_BATCH_ID = this.getJsonObject('PROGRAM_BATCH_ID', batchId);
		    	     this.pushJsonObjectInArray(PROGRAM_BATCH_ID,searchcriteria);
		             }
		    	     if(evaluationType !=null && evaluationType !=""){
	    	    	 var EVALUATION_TYPE = this.getJsonObject('EVALUATION_TYPE', evaluationType);
		    	     this.pushJsonObjectInArray(EVALUATION_TYPE,searchcriteria);
		    	     }	
		             values.searchCriterias = searchcriteria;
		             return values;
		    	    },
		    	    getJsonObject: function(key, value, additionalValue) {
		    	         if (value != '' && value != null && additionalValue == undefined) {
		    	             return {
		    	                 "paramCode": key,
		    	                 "paramValues": [value]
		    	             };
		    	         } else if (value != '' && additionalValue != undefined) {
		    	             return {
		    	                 "paramCode": key,
		    	                 "paramValues": [value, additionalValue]
		    	             };
		    	         }
		    	     },
		    	     pushJsonObjectInArray: function(object, array) {
		    	         if (object) {
		    	             array.push(object);
		    	         }
		    	     },
			      	gridRenderFunction: function(grid) {
			      		//grid.addButtonToolbar();
			      /*		grid.addDocked({
			                xtype: 'toolbar',
			                dock: 'top',
			                items: [{
			                    xtype: 'button',
			                    itemId: 'btnAdd',
			                    tooltip: getCommonTranslation('ADD'),
			                    glyph: ICONGLYPH.ADDGLYPH
			                }, {
			                    xtype: 'button',
			                    itemId: 'btnEdit',
			                    tooltip: getCommonTranslation('EDIT'),
			                    glyph: ICONGLYPH.EDITGLYPH
			                },
			                {
			                    xtype: 'button',
			                    itemId: 'btnView',
			                    tooltip: getCommonTranslation('VIEW'),
			                    iconCls: 'view-icon'
			                },
			                {
			                    xtype: 'button',
			                    itemId: 'btnDelete',
			                    cls: 'CustomToolbarBtnReject',
			                    tooltip: getCommonTranslation('DELETE'),
			                    glyph: ICONGLYPH.DELETEGLYPH
			                }]
			            });  */
			        },
		    	     //
		    	     exportUserList : function(exportUrl,filetype,whetherAll,searchResultGrid) {
		    	         var quickSearchForm=this.getAssignsequencesdropdown(); 
		    	         var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
		    	         var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
		    	         var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
		    	         var visibleColumns=this.getVisibleColumns(searchResultGrid);
		    	         var reportTitle=getCommonTranslation('ASSIGN_EVALUATION_METHOD_LIST');
		    	 if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
		    	                       jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		    	                }
		    	 searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

		    	 },

		    	 		createSearchCriteriaString: function(searchForm) {
		    	 		    	 var me=this;
		    	 		        var formValues = new Array();
		    	 		        formValues = searchForm.getValues();        
		    	 		        var searchCriteriaString="";
		    	 		        for (var key in formValues) {
		    	 		        	var value = formValues[key];            
		    	 		            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
		    	 		                var keyValueJsonObject = me.getJsonObject( key , value);
		    	 		searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
		    	 		            }
		    	 		        }
		    	 		        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
		    	 		        return searchCriteriaString;
		    	 		}
});
