/**
 * @author Sumit meena
 * 
 */
Ext.define('Academia.controller.examinationcenters.centerunavailability.CenterUnavailabilityMasterController', {
	//extend : 'Ext.app.Controller',
	extend: 'Academia.controller.base.BaseController',
	models : ['common.IdValueCodeDataModel','examinationcenters.centerunavailability.CenterUnavailabilityGridModel','examinationcenters.centerunavailability.CenterUnavailabilityCreateModel'],
	stores : ['examinationcenters.centerunavailability.CenterCode','examinationcenters.centerunavailability.CenterUnavailabilityGridStore'],
	views : ['examinationcenters.centerunavailability.CenterUnavailabilityMasterStructure','examinationcenters.centerunavailability.CenterUnavailabilityMasterGrid','examinationcenters.centerunavailability.CenterUnavailabilityQuickFilter',
	         'examinationcenters.centerunavailability.CenterUnavailabilityForm'],
	config:{
		      /** CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
		                		   	 */
		         /**
		          * @cfg {Array}  CENTER_UNAVAILABILITY_PERMISSION array (required)
		          * The array of permissions to use for Access control wise enabling and disabling buttons.
		           * @accessor	                	        */
			CENTER_UNAVAILABILITY_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CENTER_UNAVAILABILITY_PRIVILEGES')
     
		   }, 	         
	          refs : [{
	        	  ref:'centerunavailabilitystructure',
	        	  selector:'centerunavailabilitystructure'
	          },{
	        	  ref:'centerunavailabilityquickfilter',
	        	  selector:'centerunavailabilityquickfilter'
	          },{
	        	  ref:'centerunavailabilitymastergrid',
	        	  selector:'centerunavailabilitymastergrid'
	          },{
	        	  ref:'centerunavailabilityform',
	        	  selector:'centerunavailabilityform'
	          },{
				ref : 'contentPanel',
				selector : 'contentPanel'
	          },{
	        	  ref :'centerunavailabilitymasterstructure',
	        	  selector :'centerunavailabilitymasterstructure'	  
	          }
	          ],
	          init : function() {
	        	  this.control({
	        		  'centerunavailabilitymastergrid':{
							render:function(grid){
								this.doAccessControlValidation(grid, this.getCENTER_UNAVAILABILITY_PERMISSION());
							},
							beforerender: function(grid) {
								grid.getStore().removeAll();
							}
						},
						'centerunavailabilityquickfilter':{
		        			render:function(obj){
		        				var form=obj.getForm();
		        				var centerCodeField=form.findField('centerCode');
		        				centerCodeField.getStore().getProxy().extraParams = {
		        					centerType:getExaminationTranslation("CNTRL_EXTERNAL"),
		        					stageType:"COURSE_EXECUTION" // V2D-454858
			   	  				};
		        				centerCodeField.getStore().load();
		        			}
		        		},
	        		/*'centerunavailabilityquickfilter customcombobox[itemId=centerTypeItemId]':{
	        			select:function(obj,rec){
	        				var centerType=rec[0].data.id;
	        				var form=obj.up('form').getForm();
	        				var centerCodeField=form.findField('centerCode');
	        				centerCodeField.enable();
	        				centerCodeField.getStore().getProxy().extraParams = {
	        					centerType:centerType,
	        					stageType:getExaminationTranslation('CNTRL_COURSE_EXECUTION')
		   	  				};
	        				centerCodeField.getStore().load();
	        			}
	        		},*/
	        		'centerunavailabilityquickfilter button[itemId=searchBtn]':{
	        			click:function(obj){
	        				var form=obj.up('form').getForm();
	        				var formValues=form.getValues();
	        				var store=this.getCenterunavailabilitymastergrid().getStore();
	        				store.getProxy().extraParams = {
	        					centerCode:formValues.centerCode,
	        					fromDate:formValues.fromDate,
	        					toDate:formValues.toDate
		   	  				};
	        				store.load();
	        				var grid = this.getCenterunavailabilitymastergrid();
	        				var searchForm =  this.getCenterunavailabilityquickfilter();
	        				grid.config.searchFilterForm  = searchForm;
	        			}
	        		},
	        		'centerunavailabilityquickfilter button[itemId=resetBtn]':{
	        			click:function(obj){
	        				obj.up('form').getForm().isValid();
	        				obj.up('form').getForm().reset();
	        			}
	        		},
	        		'centerunavailabilityquickfilter datefield[itemId=fromdateItemId]':{
	        			select:function( obj, value){
	        				var toDateField=obj.nextSibling();
	        				toDateField.setMinValue(value);
	        			}
	        		},
	        		'centerunavailabilityquickfilter datefield[itemId=toDateItemId]':{
                         select:function(obj, value){
                        	 var fromDateField=obj.previousSibling();
                        	 fromDateField.setMaxValue(value);
	        			}
	        		},
	        		'centerunavailabilitymastergrid button[itemId=btnAdd]':{
                        click:function(){
                       	    this.openCenterUnavailabilityTab();
	        			}
	        		},
	        		'centerunavailabilitymastergrid button[itemId=btnEdit]':{
                        click:function(){
//                        	this.openCenterUnavailabilityTab();
                       	    this.loadDataOnCenterUnavaialbility();
	        			}
	        		},
	        		'centerunavailabilitymastergrid button[itemId=btnDelete]':{
                        click:function(){
                       	    this.deleteCenterUnavailability();
	        			}
	        		},
        		    'centerunavailabilityform button[itemId=timeBtn]':{
        			   click: this.addMultipleTimeSlots
        		    },
        		    'centerunavailabilityform button[itemId=btnSave]':{
        			   click: function(){
        				   this.saveCenterUnavailabilityData();
        			   }
        		    },
        		    'centerunavailabilityform button[itemId=btnReset]':{
         			   click: function(obj){
         				   //obj.up('form').getForm().reset();
         				   //this.removeNewlyAddedContainer();
         				  var form=obj.up('form');
         				  var getForm=form.getForm();
         				  /***
         				   * remove newly added container
         				   */
         				  this.removeNewlyAddedContainer();
         				  
         				  var fromTimeField=getForm.findField('fromTime');
         				  getForm.findField('unavailableFor').reset();
         				  var toTimeField=getForm.findField('toTime');
         				  var multipleAddTimeButton=Ext.ComponentQuery.query('button#timeBtn')[0];
         				    fromTimeField.setVisible(true);
	     					toTimeField.setVisible(true);
	     					multipleAddTimeButton.setVisible(true);
         				    fromTimeField.allowBlank=true;
         				    toTimeField.allowBlank=true;
	     					fromTimeField.reset();
	     					toTimeField.reset();
	     					getForm.isValid();
	     					getForm.reset();
         			   }
         		    },
	        		/*'centerunavailabilityform customcombobox[itemId=centerTypeItemId]':{
	        			select:function(obj,rec){
	        				var centerType=rec[0].data.id;
	        				var form=obj.up('form').getForm();
	        				var centerCodeField=form.findField('centerCode');
	        				centerCodeField.enable();
	        				centerCodeField.getStore().getProxy().extraParams = {
	        					centerType:centerType,
	        					stageType:getExaminationTranslation('CNTRL_COURSE_EXECUTION')
		   	  				};
	        				centerCodeField.getStore().load();
	        			}
	        		},*/
        		    'centerunavailabilityform datefield[itemId=fromdateItemId]':{
         			   change: function(obj,value){
                         var form=obj.up('form').getForm();
                         var tillDateField=form.findField('tillDate');
                        	 tillDateField.setMinValue(value);
                        	 tillDateField.isValid();
         			   }
         		    },
        		    'centerunavailabilityform datefield[itemId=tillDateItemId]':{
        		    	change: function(obj,value){
         				  var form=obj.up('form').getForm();
                          var fromDateField=form.findField('fromDate');
                         	fromDateField.setMaxValue(value);
                         	fromDateField.isValid();
         			   }
         		    },
        		    'centerunavailabilityform radiogroup[itemId=unavailableForItemId]':{
        		    	change: function(obj,value){
         				  var form=obj.up('form');
         				  var getForm=form.getForm();
         				  /***
         				   * remove newly added container
         				   */
         				  this.removeNewlyAddedContainer();
         				  
         				  var fromTimeField=getForm.findField('fromTime');
         				  var toTimeField=getForm.findField('toTime');
         				  var multipleAddTimeButton=Ext.ComponentQuery.query('button#timeBtn')[0];
         				    fromTimeField.setVisible(false);
	     					toTimeField.setVisible(false);
	     					multipleAddTimeButton.setVisible(false);
         				    fromTimeField.allowBlank=true;
         				    toTimeField.allowBlank=true;
	     					fromTimeField.reset();
	     					toTimeField.reset();
         				  if(value.days==true){
         					  /**
         					   * All logics put in one condition
         					   */
         				  }else if(value.days==false){
         					fromTimeField.setVisible(true);
         					toTimeField.setVisible(true);
         					multipleAddTimeButton.setVisible(true);
         					fromTimeField.allowBlank=false;
           				    toTimeField.allowBlank=false;
         				  }
         				 getForm.isValid();
         			   }
         		    },
         		    
         		    'centerunavailabilitymasterstructure':{
			        	afterrender : function(structure){
			        		//var container = structure.items.items[0];
			        		var form = structure.down('form');
			        		var grid = structure.down('centerunavailabilitymastergrid');
			        	    this.getGridHeaderFreeze(grid,form);
			        	}
         		    }
	        	  });
	          },
	          openCenterUnavailabilityTab : function(tabNameForCenter) {
	                	 var me = this;
	                	 var contentpanel = me.getContentPanel();
	                	 var centerunavailabilitytab = Ext.widget('centerunavailabilityform');
	                	 var tabName = getExaminationTranslation('CREATE_CENTER_UNAVAILABILITY');
	                	 if(tabNameForCenter=='EDITTAB')
	                		 {
	                		 var tabName = getExaminationTranslation('EDIT_CENTER_UNAVAILABILITY');
	                		 }else
	                			 {
	                			 var tabName = getExaminationTranslation('CREATE_CENTER_UNAVAILABILITY');
	                			 }
	                	 
	                	 /**
		              	   * This is to remove tab from content panel and open same tab again 
		              	   */
		              	  var getcontroller=this.getController('menu.CoreERPNavigationController');
		              	  var getTab=getcontroller.getTab(tabName);
		              	   if(getTab!=null){
		              		 contentpanel.remove(getTab, true);
		              	   }
	                	 openTab(contentpanel, tabName, centerunavailabilitytab,CONSTANTS.MENU_COLOR_FOUR);
				},
				saveCenterUnavailabilityData:function(){
					var $this=this;
					var form=$this.getCenterunavailabilityform().getForm();
					var formValues=form.getValues();
					var grid=$this.getCenterunavailabilitymastergrid();
					var centerField=form.findField('centerCode');
					var timeContiner = $this.getCenterunavailabilityform().down('#timePanelId');
		        	var timeFieldsCount = timeContiner.items.length;
		        	
					 var timeList =[];
	        		 if(timeFieldsCount>1){
	        			  for(var j=0; j<formValues.fromTime.length &&  j<formValues.toTime.length &&  j<formValues.timeId.length; j++){
	        				  
	        				  timeList.push({
	        					  "id":formValues.timeId[j],
	        					  "fromTime":formValues.fromTime[j],
	        					  "toTime": formValues.toTime[j]
	        				  });
	        			  }
	        		  }else{
	        			  if(formValues.fromTime!=null||formValues.toTime!=null){
	        				  timeList.push({
	        					  "id":formValues.timeId,
	        					  "fromTime":formValues.fromTime,
	        					  "toTime": formValues.toTime
	        				  });
	        			  }
        		        }
	        		  /**
	        		   * centerType,centerCode,centerName,toDate,timeId,fromTime,toTime,reason -->
	        		   *  All the above parameter have no values while creating data and their are two parameter centerCode(this param is used for Listing) and cetreCode(this param is used for create) 
	        		   * these parameter are additional which create problem while create data  
	        		   */
	        		 var submitData=new Academia.model.examinationcenters.centerunavailability.CenterUnavailabilityCreateModel();
	        		  submitData.set('centerId',centerField.getValue());
	        		  submitData.set('centerType',formValues.centerType);
	        		  submitData.set('centreCode',centerField.getRawValue());
	        		  submitData.set('centerName',formValues.centerName);
	        		  submitData.set('fromDate',formValues.fromDate);
	        		  submitData.set('tillDate',formValues.tillDate);
	        		  submitData.set('wsCenterUnavailabilityTime',timeList);
	        		  submitData.set('unavailabilityReason',formValues.unavailabilityReason);
	        		  
	        		  if(formValues.id>0&&formValues.id!=null){
	        			  submitData.set('id',formValues.id);
	        			  submitUrl=SERVERURL.CENTER_UNAVAILABILITY_UPDATE_URL;	        			 
	        		  }else{
	        			  submitUrl=SERVERURL.CENTER_UNAVAILABILITY_CREATE_URL;  
	        		  }
	        		  var formData = Ext.encode(submitData.data);
	        		  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        		  Ext.Ajax.request({
		        		  type : 'rest',
		        		  url : submitUrl,
		        		  jsonData : formData,
		        		  method : 'POST',
		        		  success : function() {
		        			  Ext.getBody().unmask();
		        			showSuccessMessage(getExaminationTranslation('CENTER_UNAVAILABILITY'),getCommonTranslation('SUCCESS'));
		        			
		        			$this.getContentPanel().getActiveTab().close();
		        			/**
	         				  * remove newly added container
	         				  */
		        			//form.reset();
		        			//  var form=this.getCenterunavailabilityform();
	         				/*  var getForm=form;
	         				  *//***
	         				   * remove newly added container
	         				   *//*
	         				 // $this.removeNewlyAddedContainer();
	         				  
	         				  var fromTimeField=getForm.findField('fromTime');
	         				 //getForm.reset();
	         				  getForm.findField('unavailableFor').reset();
	         				  var toTimeField=getForm.findField('toTime');
	         				 var fromTimeField=getForm.findField('fromTime');
	         				  var multipleAddTimeButton=Ext.ComponentQuery.query('button#timeBtn')[0];
	         				    fromTimeField.setVisible(false);
		     					toTimeField.setVisible(false);
		     					multipleAddTimeButton.setVisible(false);
	         				    fromTimeField.allowBlank=true;
	         				    toTimeField.allowBlank=true;
	         				   var fromDateField=getForm.findField('fromDate');
	         				  var tillDateField=getForm.findField('tillDate');
	         				 var centerCodeField=getForm.findField('centerCode');
		     					fromDateField.reset();
		     					tillDateField.reset();
		     					centerCodeField.reset();
	         				 getForm.isValid();
		        			//$this.removeNewlyAddedContainer();*/
		        			grid.getStore().reload();
		        		  }
		        	  });
				},
				deleteCenterUnavailability:function(){
					 var $this=this;
					 var grid = $this.getCenterunavailabilitymastergrid();

                	 if (grid.getSelectionModel().getCount() > 0) {
                		 var records = grid.getSelectionModel().getSelection()[0];
                		 
                			var timeId=records.data.timeId>0?records.data.timeId:'';
                			var dateId=records.data.centerUnAvailableDateId;
                		 
                			showConfirmMessage(getExaminationTranslation('CENTER_UNAVAILABILITY'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
                				 function(btn, text) {
                			 if (btn == 'yes'){
                		 Ext.Ajax.request({
                			 method: "DELETE",
                			 type: 'rest',
                			 url: SERVERURL.CENETER_UNAVAILABILITY_DELETE_URL+'?timeId='+timeId+'&dateId='+dateId,
                			 headers: {
                				 'Content-Type': 'application/json'
                			 },
                			 success: function(form, action) {
                				 grid.store.reload();
                				 showSuccessMessage(getExaminationTranslation('CENTER_UNAVAILABILITY'), getExaminationTranslation('CENTER_UNAVAILABILITY_SUCCESFULLY_DELETED'));
                			 }
                		 });
                			 }
                		 });
                	 } else {
                		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
                	 }
				},
				loadDataOnCenterUnavaialbility:function(){
				  var $this=this;
				  var grid=null;
			      grid = $this.getCenterunavailabilitymastergrid();
               	 if (grid.getSelectionModel().getCount() > 0) {
               		$this.openCenterUnavailabilityTab('EDITTAB');
               		 
               		var records=null;
               		records = grid.getSelectionModel().getSelection()[0];
               		var serverUrl=null;
               		serverUrl=SERVERURL.CENTER_UNAVAILABILITY_FIND_BY_URL;
					 Ext.Ajax.request({
                		 method: "GET",
                		 type: 'rest',
                		 url: serverUrl,
                		 headers: {
                			 'Content-Type': 'application/json'
                		 },
                		 params: {
                			 dateId: records.data.centerUnAvailableDateId,
                			 centerId: records.data.centerId
                		 },
                		 success: function(f, action) {
                			 var data = f.responseText;
                			 var  jData=Ext.JSON.decode(data);
                			 if(jData.wsCenterUnavailabilityTime["0"]!=undefined){
                				 jData.wsCenterUnavailabilityTime["0"].fromTime;
                			 }
                			 var centerunavailabilityform =$this.getCenterunavailabilityform();
                			 var form = centerunavailabilityform.getForm();
                			 var idHiddenField=form.findField('id');
                			 idHiddenField.setValue(jData.id);
                			 
                			 centerunavailabilityform.down('#btnReset').setVisible(false);
                			 
                			// if(!isNullOrEmpty(jData.centerType)){
                				 
                			/* var centerTypeField=form.findField('centerType');
                			 centerTypeField.getStore().load({
                				 callback:function(resp,success){
                					 centerTypeField.setValue(jData.centerType);	
                				 }
                			 });*/
                			 
                			 var centerCodeField=form.findField('centerCode');
                			 centerCodeField.getStore().getProxy().extraParams = {
 	        					centerType:getExaminationTranslation('CNTRL_EXTERNAL'),
 	        					stageType:"COURSE_EXECUTION" // V2D-454858
 		   	  				 };
                			 centerCodeField.getStore().load({
                				 callback:function(resp,success){
                					var centerCodeStore=resp[0].store;
                					var storeValue= centerCodeStore.findRecord('id',jData.centerId , 0, false, true, true);
                					if(storeValue!=null){
                						centerCodeField.setValue(storeValue.data.id);	
                					}
                				 }
                			 });
                			 
                			 //}
                			 
                			 var fromDateField=form.findField('fromDate');
                			 var tillDateField=form.findField('tillDate');
                			 fromDateField.setMinValue(null);
                			 fromDateField.setMaxValue(dateRender(jData.tillDate));
                			 fromDateField.setValue(dateRender(jData.fromDate));
                			 tillDateField.setMinValue(dateRender(jData.fromDate));
                			 tillDateField.setMaxValue(null);
                			 tillDateField.setValue(dateRender(jData.tillDate));
                			 //form.isValid();
                			 /**
                			  * Show Radio button selected on the bases of time slot and populate tile slot
                			  */
                			var radioButonUnavailableFor= Ext.ComponentQuery.query('radiogroup#unavailableForItemId')[0].items;
                			   /**
                			    * this condition is for radio button
                			    */
                			 if(jData.wsCenterUnavailabilityTime.length==0){
                				 radioButonUnavailableFor.items[0].setValue(false);
                				 radioButonUnavailableFor.items[1].setValue(true);
                			 }else{
                				 radioButonUnavailableFor.items[0].setValue(true);
                				 radioButonUnavailableFor.items[1].setValue(false);
                			  Ext.Array.each(jData.wsCenterUnavailabilityTime,function(value,index){
                				 var fieldContainer=Ext.ComponentQuery.query('fieldcontainer#timePanelId')[0];
                				 /**
                				  * if time is multiple than first condition for greater than zero index and 
                				  * for zero index else condition will run  
                				  */
                				 if(index>=1){
                					 $this.addMultipleTimeSlots();	 
                					 var currentFieldContainer=fieldContainer.items.items[index];
                					 currentFieldContainer.items.items[0].setValue(value.id);
                					 var frmTime = currentFieldContainer.items.items[1];
                					 frmTime.setValue(timeRender(jData.wsCenterUnavailabilityTime[index].fromTime));
                					 frmTime.expand();
                					 frmTime.lastSelection = frmTime.picker.getSelectionModel().getSelection();
                					 frmTime.collapse();
                					 frmTime.blur();
                					 var triggerWrap = frmTime.getEl().down('.x-form-trigger-wrap-focus');
                					 if(triggerWrap) {
                						 triggerWrap.removeCls('x-form-trigger-wrap-focus');
                					 }
                					 
                					 var toTime = currentFieldContainer.items.items[2];
                					 toTime.setValue(timeRender(jData.wsCenterUnavailabilityTime[index].toTime));
                					 toTime.expand();
                					 toTime.lastSelection = toTime.picker.getSelectionModel().getSelection();
                					 toTime.collapse();
                					 toTime.blur();
                					 var toTriggerWrap = toTime.getEl().down('.x-form-trigger-wrap-focus');
                					 if(toTriggerWrap) {
                						 toTriggerWrap.removeCls('x-form-trigger-wrap-focus');
                					 }
                				 }else{
                					 var firstFieldContainer=fieldContainer.items.items[0];
                					 firstFieldContainer.items.items[0].setValue(value.id);
                					 var frmTime = firstFieldContainer.items.items[1];
                					 frmTime.setValue(timeRender(jData.wsCenterUnavailabilityTime[index].fromTime));
                					 frmTime.expand();
                					 frmTime.lastSelection = frmTime.picker.getSelectionModel().getSelection();
                					 frmTime.collapse();
                					 frmTime.blur();
                					 var triggerWrap = frmTime.getEl().down('.x-form-trigger-wrap-focus');
                					 if(triggerWrap) {
                						 triggerWrap.removeCls('x-form-trigger-wrap-focus');
                					 }
                					 
                					 var toTime = firstFieldContainer.items.items[2];
                					 toTime.setValue(timeRender(jData.wsCenterUnavailabilityTime[index].toTime));
                					 toTime.expand();
                					 toTime.lastSelection = toTime.picker.getSelectionModel().getSelection();
                					 toTime.collapse();
                					 toTime.blur();
                					 var toTriggerWrap = toTime.getEl().down('.x-form-trigger-wrap-focus');
                					 if(toTriggerWrap) {
                						 toTriggerWrap.removeCls('x-form-trigger-wrap-focus');
                					 }
                				 }
                			 });
                			}
                		 }
					 });
               	 }else {
            		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
            	 }
				},
				 /**
	              * Add multiple time slots in window
	              */
		           addMultipleTimeSlots:function(){
		        	   var $this = this;
		        	   var timeContiner = $this.getCenterunavailabilityform().down('#timePanelId');
		        	   var timeFieldsCount = timeContiner.items.length;
		        	   var panelItem = new Array();
		        	   
		        	   panelItem.push({
		        		   xtype:'fieldcontainer',
		        		   width: '100%',
		        		   layout : 'hbox',
		        		   defaults : {
		        			   width: 226,
		        			   labelAlign : 'top'
		        		   },
		        		   items : [{
		        			   xtype:'hidden',
		        			   name:'timeId'
		        		   },{
		        			   xtype : 'timefield',
		        			   name : 'fromTime',		
		        			   itemId : 'fromTime'+timeFieldsCount,			
		        			   fieldLabel:getExaminationTranslation('FROM_TIME')+':'+'<span class="required" style="color:red"> *</span>',
		        			   format:'g:i A',
		        			   labelSeparator:'',
		        			   vtype: 'timerange',
		        			   endTimeField : 'toTime'+timeFieldsCount,
		        			   allowBlank:false,
		        			   listeners: {
		        				   blur: function() {
		        					   assertTimeValue(this);
		        				   }
		        			   }
		        		   },{
		        			   xtype : 'timefield',
		        			   name : 'toTime',		
		        			   itemId : 'toTime'+timeFieldsCount,			
		        			   fieldLabel:getExaminationTranslation('TILL_TIME')+':'+'<span class="required" style="color:red"> *</span>',
		        			   format:'g:i A',
		        			   vtype: 'timerange',
		        			   labelSeparator:'',
		        			   startTimeField :'fromTime'+timeFieldsCount,
		        			   allowBlank:false,
		        			   listeners: {
		        				   blur: function() {
		        					   assertTimeValue(this);
		        				   }
		        			   }
		        		   },{
		        			   xtype: 'button',
		        			   glyph: ICONGLYPH.DELETEGLYPH,
		        			   cls: 'CustomBodyBtnReject',
		        			   tooltip: getCommonTranslation('DELETETOOLTIP'),
		        			   style:{
		        				   marginTop:'30px'
		        			   },
		        			   listeners:{
		        				   click:function(obj){
		        					   var container = obj.up('fieldcontainer');
		        					   var panelContiner = $this.getCenterunavailabilityform().down('#timePanelId');
		        					   panelContiner.remove(container);
		        					   $this.getCenterunavailabilityform().getForm().isValid();
		        				   }
		        			   }
		        		   }]
		        	   });
		        	   timeContiner.add(panelItem);
		        	   timeContiner.doLayout();
		           },
		           /**
		            * Remove newly added container from time slot field
		            */
		           removeNewlyAddedContainer:function(){
		        	  var timeSlotPanel=Ext.ComponentQuery.query('fieldcontainer#timePanelId')[0];
      				  timeSlotPanel.removeAll();
      				  var firstContainer={
      						xtype : 'fieldcontainer',
      						width: '100%',
      						itemId:'timeContainer',
      						layout : 'hbox',
      						defaults: {
      			                width: 226,
      			                labelAlign: 'top'
      			            },
      						items : [{
      							xtype:'hidden',
      							name:'timeId'
      						},{
      							xtype : 'timefield',
      							name : 'fromTime',		
      							itemId : 'fromTime',			
      							fieldLabel:getExaminationTranslation('FROM_TIME'),
      							format:'g:i A',
      							vtype: 'timerange',
      							allowBlank:false,
      							listeners:{
      								change:function(obj,val){
      									obj.nextSibling().setMinValue(val);
      								},
      								blur: function() {
 		        					   assertTimeValue(this);
 		        				   }
      							}
      						},{
      							xtype : 'timefield',
      							name : 'toTime',		
      							itemId : 'toTime',			
      							fieldLabel:getExaminationTranslation('TILL_TIME'),
      							format:'g:i A',
      							vtype: 'timerange',
      							allowBlank:false,
      							listeners:{
      								change:function(obj,val){
      									obj.previousSibling().setMaxValue(val);
      								},
      								blur: function() {
 		        					   assertTimeValue(this);
 		        				   }
      							}
      						},{
      							xtype: 'button',
      							itemId: 'timeBtn',
      							cls: 'CustomBodyBtnSettings',
      							text: getCommonTranslation('ADDBUTTONTEXT'),
      							tooltip: getCommonTranslation('ADD'),
      							style:{
      								marginTop:'30px'
      							}
      						 } 
      						]};

      				  timeSlotPanel.add(firstContainer);
      				  timeSlotPanel.doLayout();
		           }
});
