/**
 * @author Abhishek Bais
 */
Ext.define('Academia.controller.facultyportal.attendance.FacultyPortalPendingAttendanceReportController',{
	extend: 'Academia.controller.base.BaseController',
	stores: ['attendance.PendingAttendanceGridStore','personinfo.common.personalinfo.AttendanceReportProgramGroupStore','attendance.facultyportal.AttendanceProgramStore',
		'attendance.PendingAttendanceStatusStore','attendance.PendingAttendanceDatesGridStore'],
		model: ['attendance.PendingAttendanceGridModel','attendance.AttendanceCountModel','common.ClassTeacherProgramStore'],
		views: ['facultyPortal.attendance.PendingAttendanceReportStructureForFaculty','facultyPortal.attendance.CompleteDayPendingAttendanceReportSearch',
			'facultyPortal.attendance.CourseLevelPendingAttendanceReportSearch','facultyPortal.attendance.SessionWisePendinngAttendanceReportSearch',
			'facultyPortal.attendance.PendingAttendanceReportGridForFaculty','facultyPortal.attendance.CourseLevelPendingAttendanceReportGridForFaculty'
			,'attendance.pendingattendance.MarkedAttendanceDetailsWindow','attendance.pendingattendance.PendingDetailsWindow',
			'attendance.pendingattendance.PendingAttendanceDatesGrid','attendance.pendingattendance.MarkedAttendanceDetailGrid'],
			config: {
				FACULTY_PENDING_ATTENDANCE_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PENDING_ATTENDANCE_REPORT_PRIVILEGES'),
				ATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES'),
				FACULTY_PENDING_ATTENDANCE_DATES_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PENDING_ATTENDANCE_DATES_PRIVILEGES')
			},
			refs: [{
				ref: 'pendingattendancereportstructureforfaculty',
				selector: 'pendingattendancereportstructureforfaculty'
			},{
				ref: 'pendingattendancereportgridforfaculty',
				selector: 'pendingattendancereportgridforfaculty'
			},{
				ref: 'courselevelpendingattendancereportgridforfaculty',
				selector: 'courselevelpendingattendancereportgridforfaculty'
			},{
				ref: 'completedaypendingattendancereportsearch',
				selector: 'completedaypendingattendancereportsearch'
			},{
				ref: 'courselevelpendingattendancereportsearch',
				selector: 'courselevelpendingattendancereportsearch'
			},{
				ref: 'sessionwisependinngattendancereportsearch',
				selector: 'sessionwisependinngattendancereportsearch'
			},{
				ref: 'contentPanel',
				selector: 'contentPanel'
			},{
		    	ref: 'markedattendancedetailswindow',
		    	selector: 'markedattendancedetailswindow'
		    },{
		    	ref: 'markedAttendanceDetailsWindow',
		    	selector: 'markedattendancedetailswindow form'
		    },{
		    	ref: 'pendingdetailswindow',
		    	selector: 'pendingdetailswindow'
		    },{
		    	ref: 'pendingattendancedatesgrid',
		    	selector: 'pendingattendancedatesgrid'
		    },{
		    	ref: 'markedattendancedetailgrid',
		    	selector: 'markedattendancedetailgrid'
		    }],
			init: function(application) {
				this.control({
					'pendingattendancereportstructureforfaculty':{
						render:function(){
							var $this = this;
							var form = this.getPendingattendancereportstructureforfaculty();
							var portalId = this.getCurrentLoggedPortalId();
							var permissionsMap = new Ext.util.HashMap();
							permissionsMap= this.getFACULTY_PENDING_ATTENDANCE_REPORT_PRIVILEGES();
							var academyLocationId = this$.getCurrentAcademyLocation();
							var associatedAcadLocationIds = new Array();
							associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
							var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
							this.pendingAttendanceReportRadioTypePermission(form,permissionList);
						},
					},
					'pendingattendancereportgridforfaculty':{
						cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
							var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
							if (e.target.tagName == 'A') {
								this.openDetailsWindowForFaculty(columnName, record);
							}
						}	
					},
					'courselevelpendingattendancereportgridforfaculty':{
						cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
							var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
							if (e.target.tagName == 'A') {
								this.openDetailsWindowForFaculty(columnName, record);
							}
						}	
					},
					'pendingattendancereportstructureforfaculty radiogroup[itemId=attendanceTypeRadio]':{
						change : function(obj, record){
							var this$ = this;
							var academyLocationId = this.getCurrentAcademyLocation();
							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							var attendanceType = "";
							var facultyAttendanceType = "";
							var sessionNumber = "";
							var attendanceType = record.attendanceTypeWise;
							var facultyId=this.getCurrentlyLoggedInUser().id;
							var pendingAttendanceReportStructureForFaculty = obj.up('pendingattendancereportstructureforfaculty');
							var courseWise = pendingAttendanceReportStructureForFaculty.down('#courseLevelPendingAttendanceReportPanelItemId');
							var programWise = pendingAttendanceReportStructureForFaculty.down('#completeDayPendingAttendanceReportPanelItemId');
							var multipleSession = pendingAttendanceReportStructureForFaculty.down('#sessionWisePendinngAttendanceReportPanelItemId');

							if(!isNullOrEmpty(this$.getPendingattendancereportgridforfaculty())){
								this$.getPendingattendancereportgridforfaculty().getStore().removeAll(); 
								try{
									this$.getPendingattendancereportgridforfaculty().down('custompagingtoolbar').hide();
								}catch(e){
								}
							}
							if(!isNullOrEmpty(this$.getCourselevelpendingattendancereportgridforfaculty())){
								this$.getCourselevelpendingattendancereportgridforfaculty().getStore().removeAll(); 
								try{
									this$.getCourselevelpendingattendancereportgridforfaculty().down('custompagingtoolbar').hide();
								}catch(e){
								}
							}
							if(attendanceType == 'COURSE_LEVEL'){
								courseWise.show();
								programWise.hide();
								multipleSession.hide();
								var courseLevelSearch=this.getCourselevelpendingattendancereportsearch();
								this.loadPendingAttendanceFormForCourseWise(courseLevelSearch,attendanceType);
								if(!isNullOrEmpty(this$.getCourselevelpendingattendancereportgridforfaculty())){
									try{
										this$.getCourselevelpendingattendancereportgridforfaculty().show();
									}catch(e){
									}
								}
								if(!isNullOrEmpty(this$.getPendingattendancereportgridforfaculty())){
									try{
										this$.getPendingattendancereportgridforfaculty().hide();
									}catch(e){
									}
								}

							}
							else if(attendanceType == 'COMPLETE_DAY'){
								courseWise.hide();
								programWise.show();
								multipleSession.hide();
								var completedaysearch=this.getCompletedaypendingattendancereportsearch();
								if(wheatherSchool){
									completedaysearch.down('#sectionItemId').setFieldLabel(getCourseTxCommonTranslation('ATTENDANCE_PROGRAM_BATCH_SECTION'));
								}
								this.loadPendingAttendanceFormForCompleteDayAndSessionWise(completedaysearch,attendanceType);
								if(!isNullOrEmpty(this$.getCourselevelpendingattendancereportgridforfaculty())){
									try{
										this$.getCourselevelpendingattendancereportgridforfaculty().hide();
									}catch(e){
									}
								}
								if(!isNullOrEmpty(this$.getPendingattendancereportgridforfaculty())){
									try{
										this$.getPendingattendancereportgridforfaculty().show();
									}catch(e){
									}
								}
							}
							else if(attendanceType == 'MULTIPLE_SESSION'){
								courseWise.hide();
								programWise.hide();
								multipleSession.show();
								var sessionwisesearch=this.getSessionwisependinngattendancereportsearch();
								if(wheatherSchool){
									sessionwisesearch.down('#sectionItemId').setFieldLabel(getCourseTxCommonTranslation('ATTENDANCE_PROGRAM_BATCH_SECTION'));
								}
								this.loadPendingAttendanceFormForCompleteDayAndSessionWise(sessionwisesearch,attendanceType);
								if(!isNullOrEmpty(this$.getCourselevelpendingattendancereportgridforfaculty())){
									try{
										this$.getCourselevelpendingattendancereportgridforfaculty().hide();
									}catch(e){
									}
								}
								if(!isNullOrEmpty(this$.getPendingattendancereportgridforfaculty())){
									try{
										this$.getPendingattendancereportgridforfaculty().show();
									}catch(e){
									}
								}
							}
						}
					},
					'completedaypendingattendancereportsearch customcombobox[itemId=programGroupItemId]' :{
						change : function(obj, record){
							var form = obj.up('form');
							var programGroupId = obj.getValue();
							if(programGroupId > 0) {
								this.programGroupChangeEvent(programGroupId,form);
							}
						}
					},
					'completedaypendingattendancereportsearch button[itemId=completeDayResetBtn]':{
						click:function(obj, rec){
							var $this = this;
							var attendanceType=$this.getPendingattendancereportstructureforfaculty().down('#attendanceTypeRadio').getValue().attendanceTypeWise;
							var form=this.getCompletedaypendingattendancereportsearch();
							this.loadPendingAttendanceFormForCompleteDayAndSessionWise(form,attendanceType);
						}
					},
					'completedaypendingattendancereportsearch button[itemId=completeDaySearchBtn]':{
						click: function() {
							var $this = this;
							var attendanceType=$this.getPendingattendancereportstructureforfaculty().down('#attendanceTypeRadio').getValue().attendanceTypeWise;
							this.loadPendingAttendanceReportGridForFaculty(attendanceType);
						}
					},
					'sessionwisependinngattendancereportsearch customcombobox[itemId=programGroupItemId]' :{
						change : function(obj, record){
							var form = obj.up('form');
							var programGroupId = obj.getValue();
							if(programGroupId > 0) {
								this.programGroupChangeEvent(programGroupId,form);
							}
						}
					},
					'sessionwisependinngattendancereportsearch button[itemId=sessionWiseResetBtn]':{
						click:function(obj, rec){
							var $this = this;
							var attendanceType=$this.getPendingattendancereportstructureforfaculty().down('#attendanceTypeRadio').getValue().attendanceTypeWise;
							var form=this.getSessionwisependinngattendancereportsearch();
							this.loadPendingAttendanceFormForCompleteDayAndSessionWise(form,attendanceType);
						}
					},
					'sessionwisependinngattendancereportsearch button[itemId=sessionWiseSearchBtn]':{
						click: function() {
							var $this = this;
							var attendanceType=$this.getPendingattendancereportstructureforfaculty().down('#attendanceTypeRadio').getValue().attendanceTypeWise;
							this.loadPendingAttendanceReportGridForFaculty(attendanceType);
						}
					},
					'courselevelpendingattendancereportsearch customcombobox[itemId=academicTerm]' :{
						change : function(obj, record){
							var me = this;
							var form = obj.up('form');
							var academicTermId = obj.getValue();
							if(academicTermId > 0) {
								var courseVariantStore = form.down('#courseVariantId').getStore();
								var facultyId=this.getCurrentlyLoggedInUser().id;
								var academyLocationId = this.getCurrentAcademyLocation();
								courseVariantStore.getProxy().extraParams = {
									academyLocationIds: academyLocationId,
									facultyId: facultyId,
									isCurrentPeriod:true,
									academicTermId:academicTermId
								};
								courseVariantStore.load();
							}
						}
					},
					'courselevelpendingattendancereportsearch button[itemId=courseLevelResetBtn]':{
						click:function(obj, rec){
							var $this = this;
							var attendanceType=$this.getPendingattendancereportstructureforfaculty().down('#attendanceTypeRadio').getValue().attendanceTypeWise;
							var form=this.getCourselevelpendingattendancereportsearch();
							this.loadPendingAttendanceFormForCourseWise(form,attendanceType);
						}
					},
					'courselevelpendingattendancereportsearch button[itemId=courseLevelSearchBtn]':{
						click: function() {
							var $this = this;
							var attendanceType=$this.getPendingattendancereportstructureforfaculty().down('#attendanceTypeRadio').getValue().attendanceTypeWise;
							this.loadPendingAttendanceReportGridForFaculty(attendanceType);
						}
					},
					'pendingDetailsWindow' : {
		            	beforerender:function(){
		            		this.getStore('attendance.PendingAttendanceDatesGridStore').removeAll();
		            	}
		            },
		            'pendingattendancedatesgrid' : {
		            	beforerender : function(grid){
		            		var permissionMap = this.getATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES();
		            		Ext.apply(grid,{
		            			code:null,
		            			setCode : function(code){
		            				grid.code = code;
		            			},
		            			getCode:function(){
		            				return grid.code;
		            			}
		            		});

		            		var associatedAcadLocationIds = new Array();
		            		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		            		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
		            		for (var i = 0; i < permissionList.length; i++) {
		            			if (permissionList[i] === "VIEW") {
		            				grid.setCode(true);
		            				return;
		            			}else{
		            				grid.setCode(false);
		            			}
		            		}
		            	},
		            	cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
		            		var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
		            		if (e.target.tagName == 'A') {
		            			this.openMarkedAttendanceStructureForFaculty(record);
		            		}
		            	},
		            	render : function(grid){
		            		this.doAccessControlValidation(grid, this.getFACULTY_PENDING_ATTENDANCE_DATES_PRIVILEGES());
		            	}
		            }
				});
			},
			pendingAttendanceReportRadioTypePermission:function(form,permissionList){
				var this$ = this;
				var academyLocationId = this.getCurrentAcademyLocation();
				var studentAttendanceType = [];
				var attendanceTypeRadio=form.down('#attendanceTypeRadio');
				var studentAttendanceType = [];
				var attendanceType=[];
				var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
				if(!isNullOrEmpty(attendanceTypess.data.COMPLETE_DAY) && attendanceTypess.data.COMPLETE_DAY.academyLocationId == academyLocationId) {
					attendanceType.push(attendanceTypess.data.COMPLETE_DAY.studentAttendanceType);
				} else {
					var authenticationController = Academia.app.getController('Academia.controller.authentication.AuthenticationController');
					authenticationController.loadMultipleLangFilePerAL(this.getCurrentAcademyLocation());
					attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
					if(!isNullOrEmpty(attendanceTypess.data.COMPLETE_DAY)) {
						attendanceType.push(attendanceTypess.data.COMPLETE_DAY.studentAttendanceType);
					}
				}
				if(!isNullOrEmpty(attendanceTypess.data.MULTIPLE_SESSION)) {
					attendanceType.push(attendanceTypess.data.MULTIPLE_SESSION.studentAttendanceType);
				}
				if(!isNullOrEmpty(attendanceTypess.data.COURSE_LEVEL)) {
					attendanceType.push(attendanceTypess.data.COURSE_LEVEL.studentAttendanceType);
				}
				if(attendanceType.length > 0){
					studentAttendanceType=attendanceType.join();
				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));
				}
				//--setting initial values to false
				var tab2=false, tab3=false,tab4=false;

				//--initially setting all radio fields to true
				var completeDayRadio = form.down('[inputValue=COMPLETE_DAY]');
				var courseLevelRadio = form.down('[inputValue=COURSE_LEVEL]');
				var multipleSessionRadio = form.down('[inputValue=MULTIPLE_SESSION]');
				attendanceTypeRadio.items.items[0].setVisible(true);
				attendanceTypeRadio.items.items[1].setVisible(true);
				attendanceTypeRadio.items.items[2].setVisible(true);

				//--checking for the visible tabs
				if((Ext.Array.contains(permissionList, 'PROGRAM_WISE'))&&(Ext.Array.contains(attendanceType, 'COMPLETE_DAY') || Ext.Array.contains(attendanceType, 'Complete Day'))){
					tab2=true;
				}
				if((Ext.Array.contains(permissionList, 'COURSE_WISE'))&&(Ext.Array.contains(attendanceType, 'COURSE_LEVEL') || Ext.Array.contains(attendanceType, 'Course Level'))){
					tab3=true;
				}
				if((Ext.Array.contains(permissionList, 'SESSION_WISE'))&&(Ext.Array.contains(attendanceType, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceType, 'Multiple Session'))){
					tab4=true;
				}
				if(!tab2 && !tab3 && !tab4){
					tab2=true;
				}

				if((!tab2 && !tab3) || (!tab3 && !tab4) || (!tab4 && !tab2)){
					attendanceTypeRadio.setVisible(false);
				}
				else {
					attendanceTypeRadio.setVisible(true);
				}
				//-- setting values to true/false on the basis of visible tabs
				if(!tab2){
					attendanceTypeRadio.items.items[0].setVisible(false);
				}
				if(!tab3){
					attendanceTypeRadio.items.items[1].setVisible(false);
				}
				if(!tab4){
					attendanceTypeRadio.items.items[2].setVisible(false);
				}
				//-- setting radioGroup value on the basis of visible tabs
				setTimeout(function(){
					if(tab2){
						completeDayRadio.setValue(true);
					}
					else if(tab3){
						courseLevelRadio.setValue(true);
					}
					else if(tab4){
						multipleSessionRadio.setValue(true);
					}
				},300);
			},
			loadPendingAttendanceFormForCompleteDayAndSessionWise:function(form,attendanceType){
				var academyLocationId = this.getCurrentAcademyLocation();
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var wheatherSchool = alinfomodel.get('wheatherSchool');
				var facultyId=this.getCurrentlyLoggedInUser().id;
				var programGroup=form.down('#programGroupItemId');
				var programWiseStartDate=form.down('#programWiseStartDate');
				var programWiseEndDate=form.down('#programWiseEndDate');
				var sectionIdField=form.down('#sectionItemId');

				form.down("#pendingAttendanceStatusId").setValue('PENDING');
				programGroup.reset();
				programWiseStartDate.reset();
				programWiseEndDate.reset();
				sectionIdField.reset();
				programWiseStartDate.setMinValue(false);
				programWiseStartDate.setMaxValue(new Date());
				programWiseEndDate.setMinValue(false);
				programWiseEndDate.setMaxValue(new Date());

				var sectionIdFieldStore = sectionIdField.getStore();
				sectionIdFieldStore.getProxy().extraParams = {
					academyLocationIds: academyLocationId,
					facultyId: facultyId,
					onlyCurrentRecords:true,
					wheatherSchool:wheatherSchool
				};
				sectionIdFieldStore.load();
				var proramGroupStore=programGroup.getStore();
				proramGroupStore.getProxy().extraParams = {
					academyLocationId : academyLocationId,
					facultyId:facultyId

				};
			},
			loadPendingAttendanceFormForCourseWise:function(courseLevelSearch,attendanceType){
				var academyLocationId = this.getCurrentAcademyLocation();
				var academicTerm = courseLevelSearch.down('#academicTerm');
				var courseVariantId=courseLevelSearch.down('#courseVariantId');
				var facultyId=this.getCurrentlyLoggedInUser().id;
				var pendingAttendanceStatusId=courseLevelSearch.down('#pendingAttendanceStatusId');
				var courseWiseStartDate=courseLevelSearch.down('#courseWiseStartDate');
				var courseWiseEndDate=courseLevelSearch.down('#courseWiseEndDate');

				courseWiseStartDate.reset();
				courseWiseEndDate.reset();
				academicTerm.reset();
				courseVariantId.reset();
				pendingAttendanceStatusId.reset();

				courseWiseStartDate.setMinValue(false);
				courseWiseStartDate.setMaxValue(new Date());
				courseWiseEndDate.setMinValue(false);
				courseWiseEndDate.setMaxValue(new Date());
				pendingAttendanceStatusId.setValue('PENDING');

				var academicTermStore = academicTerm.getStore();
				var currentAcademicTermDefine=false; 
				academicTermStore.load({
					callback: function(record, operation, success) {
						if (success) {
							if(record.length>0){
								Ext.each(record, function(value) {
									if(value.get('whetherCurrentAcademicTerm')){
										courseLevelSearch.down("#academicTerm").setValue(value.get('id'));
										currentAcademicTermDefine=true;
									}
								});
							}
						}
					}
				});
				setTimeout(function(){
					if(!currentAcademicTermDefine){
						var courseVariantStore = courseVariantId.getStore();
						courseVariantStore.getProxy().extraParams = {
							academyLocationIds: academyLocationId,
							facultyId: facultyId,
							isCurrentPeriod:true
						}
						courseVariantStore.load();
					}
				},500);
			},
			programGroupChangeEvent:function(programGroupId,form){
				var me = this;
				var sectionIdField = form.down("#sectionItemId");
				var programGroupId = form.down("#programGroupItemId").getValue();
				var facultyId=this.getCurrentlyLoggedInUser().id;
				var academyLocationIds=me.getCurrentAcademyLocation();
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var wheatherSchool = alinfomodel.get('wheatherSchool');
				sectionIdField.reset();
				var sectionIdFieldStore = sectionIdField.getStore();
				sectionIdFieldStore.getProxy().extraParams = {
					academyLocationIds: academyLocationIds,
					facultyId: facultyId,
					onlyCurrentRecords:true,
					programGroupId:programGroupId,
					wheatherSchool:wheatherSchool
				};
				sectionIdFieldStore.load();
			},
			loadPendingAttendanceReportGridForFaculty:function(attendanceType){
				var me = this;
				var academyLocationId=me.getCurrentAcademyLocation();
				var facultyId =this.getCurrentlyLoggedInUser().id;
				var completeDayGrid = this.getPendingattendancereportgridforfaculty();
				var courseLevelGrid = this.getCourselevelpendingattendancereportgridforfaculty();
				if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
					courseLevelGrid.setVisible(true);
					completeDayGrid.setVisible(false);
					courseLevelGrid.focus();

					var form = this.getCourselevelpendingattendancereportsearch();
					var academicTermId=form.down('#academicTerm').getValue();
					var courseVariantId=form.down('#courseVariantId').getValue();
					var attendanceStatus=form.down('#pendingAttendanceStatusId').getValue();
					var fromDate=form.down('#courseWiseStartDate').getValue();
					var toDate=form.down('#courseWiseEndDate').getValue();

					var store = this.getStore('attendance.PendingAttendanceGridStore');
					var submitURL=SERVERURL.STUDENT_PENDING_ATTENDANCE_REPORT_FACULTY_PORTAL_COURSE_LEVEL;
					store.getProxy().api.read=submitURL;
					store.getProxy().extraParams = {
						academyLocationId : academyLocationId,
						facultyId : facultyId,
						academicTermId : academicTermId,
						courseVariantId : courseVariantId,
						attendanceStatus : attendanceStatus,
						startDate : Ext.Date.format(fromDate,'Y-m-d'),
						endDate : Ext.Date.format(toDate,'Y-m-d')
					};
					this.resetPageSetting(store);
					store.load();
				}
				else if(attendanceType=='Multiple Session' || attendanceType=='MULTIPLE_SESSION'){
					courseLevelGrid.setVisible(false);
					completeDayGrid.setVisible(true);
					completeDayGrid.focus();

					var sessionLevelForm = this.getSessionwisependinngattendancereportsearch();

					var programGroupId=sessionLevelForm.down('#programGroupItemId').getValue();
					var sectionId=sessionLevelForm.down('#sectionItemId').getValue();
					var attendanceStatus=sessionLevelForm.down('#pendingAttendanceStatusId').getValue();
					var fromDate=sessionLevelForm.down('#programWiseStartDate').getValue();
					var toDate=sessionLevelForm.down('#programWiseEndDate').getValue();

					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					if(wheatherSchool){
						completeDayGrid.columns[3].setVisible(false);
					}else{
						completeDayGrid.columns[3].setVisible(true);
					}	
					var store = this.getStore('attendance.PendingAttendanceGridStore');
					var submitURL=SERVERURL.STUDENT_PENDING_ATTENDANCE_RECORDS_FOR_FACULTY;
					store.getProxy().api.read=submitURL;
					store.getProxy().extraParams = {
						sectionId : sectionId,
						programGroupId : programGroupId,
						academyLocationId : academyLocationId,
						startDate : Ext.Date.format(fromDate,'Y-m-d'),
						endDate : Ext.Date.format(toDate,'Y-m-d'),
						facultyId : facultyId,
						attendanceStatus : attendanceStatus,
						// sessionNo:sessionNo,
						attendanceType : attendanceType
					};
					this.resetPageSetting(store);
					store.load();
				}
				else{
					courseLevelGrid.setVisible(false);
					completeDayGrid.setVisible(true);
					completeDayGrid.focus();

					var completeDayForm = this.getCompletedaypendingattendancereportsearch();

					var programGroupId=completeDayForm.down('#programGroupItemId').getValue();
					var sectionId=completeDayForm.down('#sectionItemId').getValue();
					var attendanceStatus=completeDayForm.down('#pendingAttendanceStatusId').getValue();
					var fromDate=completeDayForm.down('#programWiseStartDate').getValue();
					var toDate=completeDayForm.down('#programWiseEndDate').getValue();

					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					if(wheatherSchool){
						completeDayGrid.columns[3].setVisible(false);
					}else{
						completeDayGrid.columns[3].setVisible(true);
					}
					var store = this.getStore('attendance.PendingAttendanceGridStore');
					var submitURL=SERVERURL.STUDENT_PENDING_ATTENDANCE_RECORDS_FOR_FACULTY;
					store.getProxy().api.read=submitURL;
					store.getProxy().extraParams = {
						sectionId : sectionId,
						programGroupId : programGroupId,
						academyLocationId : academyLocationId,
						startDate : Ext.Date.format(fromDate,'Y-m-d'),
						endDate : Ext.Date.format(toDate,'Y-m-d'),
						facultyId : facultyId,
						attendanceStatus : attendanceStatus,
						// sessionNo:sessionNo,
						attendanceType : attendanceType
					};
					this.resetPageSetting(store);
					store.load();
				}
			},
			openMarkedAttendanceStructureForFaculty : function(rec) {
		    	   this$=this;
		    	   var contentPanel = this.getContentPanel();
		    	   var pendingStructure = this.getPendingdetailswindow();
		    	   var academyLocationId = this.getCurrentAcademyLocation();
        		   var attendanceDate="";
		    	   var backDate="";
		    	   var portalId = this.getCurrentLoggedPortalId();
		    	   var attendanceType=pendingStructure.down('#attendanceTypeId').getValue();
		    	   var facultyDateGrid = this.getPendingattendancedatesgrid();
	    		   var selectedRecord = facultyDateGrid.getSelectionModel().getSelection()[0];
	    		   attendanceDate=rec.data.date;
	    		   Ext.Ajax.request({
					   type : 'rest',
					   async: false,
					   url : SERVERURL.CHECK_ALLOWED_BACK_DATE,
					   params : {
						   academyLocationId : academyLocationId,
						   portalId : portalId,
						   attendanceDate : Ext.Date.format(new Date(attendanceDate), 'Y-m-d'),
						   attendanceType : attendanceType
					   },
					   method : 'GET',
					   success : function(f, action) {
						   var data = Ext.JSON.decode(f.responseText);
						   if(data.id == null)
						   {
							   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('BACK_DATE_ATTENDANCE_CAPTURE')+data.backDateAllowed+getProgramandcourseTranslation('CALENDAR_DAYS'));
						   }else{
								   var attendanceController = Academia.app.getController('Academia.controller.facultyportal.attendance.FacultyCaptureAttendanceController')
								   var structure = Ext.widget('facultycaptureattendancemasterstructure');
						    	   var tabName = getMegaMenuTranslation('FP_MARK_ATTENDANCE');
						    	   var getcontroller= Academia.app.getController('menu.CoreERPNavigationController');
						    	   var getTab=getcontroller.getTab(tabName);
						    	   if(getTab!=null){
						    		   contentPanel.remove(getTab, true);
						    	   }
						    	   openTab(contentPanel, tabName, structure);
						    	   Ext.defer(function() {
						    		   var attendanceTypeRadio=attendanceController.getStudentcaptureattendancestructure().down('#newAttendanceTypeRadio');
						    		   if(attendanceType=="COMPLETE_DAY"){
							       			attendanceTypeRadio.items.items[0].setValue(true);
						        			attendanceTypeRadio.items.items[1].setValue(false);
						        			attendanceTypeRadio.items.items[2].setValue(false);
							       		} else if(attendanceType=="MULTIPLE_SESSION"){
							       			attendanceTypeRadio.items.items[0].setValue(false);
						        			attendanceTypeRadio.items.items[1].setValue(false);
						        			attendanceTypeRadio.items.items[2].setValue(true);
							       		} else if(attendanceType=="COURSE_LEVEL"){
							       			attendanceController.getContentPanel().getActiveTab().academicTermId = selectedRecord.data.academicTermId;
							       			attendanceTypeRadio.items.items[0].setValue(false);
						        			attendanceTypeRadio.items.items[1].setValue(true);
						        			attendanceTypeRadio.items.items[2].setValue(false);
							       			
							       		}
						    	   this$.OnfacultyPortalfillSearchFormValues(attendanceController,attendanceType)
						    	   },500);						    	   
						   }
					   }});
		       },
		       OnfacultyPortalfillSearchFormValues : function(attendanceController,attendanceType){
		       		var $this =  this;
		       		var this$ = attendanceController;
		       		var academyLocationId = this.getCurrentAcademyLocation();
		       		var pendingStructure = this.getPendingdetailswindow();
		       		var dateGrid = this.getPendingattendancedatesgrid();
		       		var dateRecords = dateGrid.getSelectionModel().getSelection();
		       		var portalId = this.getCurrentLoggedPortalId();
		       		var facultyId = this.getCurrentlyLoggedInUser().id;;
		       		if(attendanceType=="COMPLETE_DAY"){
		       			var sectionId = pendingStructure.down('#sectionId').getValue();
		       			var programWiseSearch = this$.getProgramwisecaptureattendancesearch();
		       			var programByAcademyLocationStore = programWiseSearch.down('#facultyAttendanceProgramId').getStore();
		       	    	programByAcademyLocationStore.getProxy().extraParams = {
		       	    		academyLocationIds:academyLocationId,
		       	    		facultyId:facultyId,
		       	    		onlyCurrentRecords:true
		       	    	};
		       	    	programByAcademyLocationStore.load({
		       	    		callback: function(records, operation, success) {
		       	    			if (success) {
		       	    				Ext.defer(function(){
		       	    					var record = programByAcademyLocationStore.findRecord('sectionId', sectionId).data;
		       	    					programWiseSearch.down('#facultyAttendanceProgramId').setValue(record.sectionId);
		       	    					var dateField = programWiseSearch.down('#completeDayDate_Id');
		       			       			dateField.setValue(dateFormatRender(dateRecords[0].data.dateValue));
		       	    					this$.loadCaptureAttendanceStudentGrid();
		       	    				}, 500, this);
		       	    			}
		       	    		}
		       	    	});
		       		}  else if(attendanceType=='MULTIPLE_SESSION'){
		       			var sectionId = pendingStructure.down('#sectionId').getValue();
		       			var sessionWiseSearch = this$.getMultiplesessionwisecaptureattendancesearch();
		       			var programByAcademyLocationStore = sessionWiseSearch.down('#session_programBatch_programId').getStore();
		       	    	programByAcademyLocationStore.getProxy().extraParams = {
		       	    		academyLocationIds:academyLocationId,
		       	    		facultyId:facultyId,
		       	    		onlyCurrentRecords:true
		       	    	};
		       	    	programByAcademyLocationStore.load({
		       	    		callback: function(records, operation, success) {
		       	    			if (success) {
		       	    				Ext.defer(function(){
		       	    					var record = programByAcademyLocationStore.findRecord('sectionId', sectionId).data;
		       	    					sessionWiseSearch.down('#session_programBatch_programId').setValue(record.sectionId);
		       	    					var dateField = sessionWiseSearch.down('#session_dateOfAttendance_Id');
		       			       			dateField.setValue(dateFormatRender(dateRecords[0].data.dateValue));
		       	    					this$.loadCaptureAttendanceStudentGrid();
		       	    				}, 500, this);
		       	    			}
		       	    		}
		       	    	});
		       		} else if(attendanceType=='COURSE_LEVEL') {
		       			var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
		       			var backDaysAllowed = attendanceTypess.data.COURSE_LEVEL.backDateAllowedForFaculty;
		       			var courseVariantId = pendingStructure.down('#courseVariantId').getValue();
		       			var courseWiseSearch = this$.getCoursewisecaptureattendancesearch();
		       			var courseVariantStore = courseWiseSearch.down('#courseVariantId').getStore();
		       			var academicTermId=dateRecords[0].data.academicTermId;
		       			courseVariantStore.getProxy().extraParams = {
		       				academyLocationIds:academyLocationId,
		       				facultyId:facultyId,
		       				isCurrentPeriod:true,
		       				academicTermId:academicTermId
		       	    	};
		       			courseVariantStore.load({
		       	    		callback: function(records, operation, success) {
		       	    			if (success) {
		       	    				Ext.defer(function() {
		       	    					var record = courseVariantStore.findRecord('id', courseVariantId).data;
		       	    					courseWiseSearch.down('#courseVariantId').setValue(record.id);
		       	    					var dateField = courseWiseSearch.down('#dateOfAttendance_Id');
		       	    					var timeSlotField = courseWiseSearch.down('#timetableSlotListId');
		       	    					dateField.setValue(dateFormatRender(dateRecords[0].data.dateValue));
		       	    					timeSlotFieldStore = timeSlotField.getStore();
		       	    					timeSlotFieldStore.getProxy().extraParams = {
		       	    						courseVariantId:courseVariantId,
		       								facultyId:facultyId,
		       								backDaysAllowed:backDaysAllowed
		       			       	    	};
		       	    					timeSlotFieldStore.load({
		       			       	    		callback: function(records, operation, success) {
		       			       	    			if (success) {
		       			       	    				timeSlotField.setDisabled(false);
		       			       	    				timeSlotField.setValue([dateRecords[0].data.courseCoveragePlanId]);
		       			       	    				timeSlotField.setValue([dateRecords[0].data.courseCoveragePlanId]);
		       			       	    				courseWiseSearch.down('#fromTime').clearValue();
		       			       	    				courseWiseSearch.down('#toTime').clearValue();
		       			       	    				courseWiseSearch.down('#dateOfAttendance_Id').setDisabled(true);
		       			       	    				courseWiseSearch.down('#fromTime').setDisabled(true);
		       			       	    				courseWiseSearch.down('#toTime').setDisabled(true);
		       			       	    				courseWiseSearch.down('#fromTime').allowBlank=true;
		       			       	    				courseWiseSearch.down('#toTime').allowBlank=true;
		       			       	    				courseWiseSearch.down('#dateOfAttendance_Id').allowBlank=true;
		       			       	    				courseWiseSearch.down('#timeBtnAdd').setDisabled(true);
		       			       	    				var cvId = courseWiseSearch.down('#courseVariantId').getValue();
		       			       	    				var courseValues = courseWiseSearch.down('#courseVariantId').getStore().findRecord('id',cvId).data;
		       			       	    				var courseId = courseValues.courseId;
		       			       	    				var componentId = "";
		       			       	    				if(courseValues.courseComponentId > 0) {
		       			       	    					courseId = courseValues.parentCourseId;
		       			       	    					componentId = courseValues.courseComponentId;
		       			       	    				}
		       			       	    				this$.loadTopics(courseWiseSearch, courseId, componentId);
		       			       	    				this$.loadCaptureAttendanceStudentGrid();
		       			       	    			}
		       			       	    		}
		       	    					});
		       	    				}, 500, this);
		       	    			}
		       	    		}
		       	    	});
		       		}
		       	},
			openDetailsWindowForFaculty:function(title, record){
				var $this = this;
				var tabName = '';
				var structure ='';
				var pendingAttendanceDatesGrid = this.getPendingattendancedatesgrid();;
				if(title=='totalPendings'){
					tabName = getCommonTranslation('ATTENDANCE_PENDING');
					structure = Ext.widget('pendingdetailswindow');
				}else{
					tabName = getCommonTranslation('ATTENDANCE_MARKED');
					structure = Ext.widget('markedattendancedetailswindow');
				}
				var contentPanel = $this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
				/**
				 * This is to remove tab from content panel and open same tab again
				 */
				var getcontroller=$this.getController('menu.CoreERPNavigationController');
				var getTab = null;
				for(var i =0 ;i<contentPanel.items.length;i++){
					if(contentPanel.items.items[i].title == tabName){
						getTab= contentPanel.items.items[i];
					}
				}
				if(getTab!=null){
					contentPanel.remove(getTab, true);
				}
				openTab(contentPanel, tabName, structure);
				var attendanceType=$this.getPendingattendancereportstructureforfaculty().down('#attendanceTypeRadio').getValue().attendanceTypeWise;
				if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
					if(title=="totalPendings"){
						var markStruct = $this.getMarkedattendancedetailswindow();
						var pendingSturct = this.getPendingdetailswindow();
						pendingSturct.down('#attendanceTypeId').setValue('COURSE_LEVEL');
						pendingSturct.down('#courseVariantId').setValue(record.data.courseVariantId);
						var markGrid = $this.getMarkedattendancedetailgrid();
						var pendingGrid = $this.getPendingattendancedatesgrid();
						//pendingGrid.columns[1].setVisible(true);
						//pendingGrid.columns[2].setVisible(true);
						var facultyId = this.getCurrentlyLoggedInUser().id;
						pendingGrid.columns[3].setVisible(false);
						
						var form = this.getCourselevelpendingattendancereportsearch().getForm();
						var values = form.getValues();
						
						var courseId= record.data.courseId;
						var courseVariantId = record.data.courseVariantId;
						var sectionId = record.data.sectionId;
						
						pendingSturct.down('#programName').setValue(record.data.programName);
						pendingSturct.down('#batchName').setValue(record.data.batchName);
						pendingSturct.down('#periodName').setValue(record.data.periodName);
						pendingSturct.down('#sectionName').setValue(record.data.sectionCode);
						pendingSturct.down('#courseName').setValue(record.data.courseName);
						pendingSturct.down('#courseVariantName').setValue(record.data.courseVaraintName);
						pendingSturct.down('#programName').setVisible(false);
						pendingSturct.down('#batchName').setVisible(false);
						pendingSturct.down('#periodName').setVisible(false);
						pendingSturct.down('#sectionName').setVisible(false);
						pendingSturct.down('#courseName').setVisible(true);
						pendingSturct.down('#courseVariantName').setVisible(true);
						pendingSturct.down('#FacultyName').setVisible(false);
						
						var startDate = values.courseWiseStartDate;
						var endDate = values.courseWiseEndDate;
						
						var academyLocationId = $this.getCurrentAcademyLocation();
						var store = pendingGrid.getStore();
						var submitURL=SERVERURL.COURSE_LEVEL_STUDENT_PENDING_DATES;
						store.getProxy().api.read=submitURL;
						store.getProxy().extraParams = {
							courseId: courseId,
							courseVariantId:courseVariantId,
							sectionId:sectionId,
							facultyId:facultyId,
							academyLocationId:academyLocationId,
							startDate:startDate,
							endDate:endDate
						};
						this.resetPageSetting(store, pendingGrid);
						store.load();
					}
					if(title=="totalMarkedAttendance"){
						var markStruct = $this.getMarkedattendancedetailswindow();
						var pendingSturct = this.getPendingdetailswindow();
						var markGrid = $this.getMarkedattendancedetailgrid();
						var pendingGrid = $this.getPendingattendancedatesgrid();
						
						var form = this.getCourselevelpendingattendancereportsearch().getForm();
						var values = form.getValues();
						
						var courseId= record.data.courseId;
						var courseVariantId = record.data.courseVariantId;
						var startDate = values.courseWiseStartDate;
						var endDate = values.courseWiseEndDate;
						var store = markGrid.getStore();
						var facultyId =this.getCurrentlyLoggedInUser().id;
						
						markStruct.down('#courseName').setValue(record.data.courseName);
						markStruct.down('#courseVariantName').setValue(record.data.courseVaraintName);
						markStruct.down('#programName').setVisible(false);
						markStruct.down('#batchName').setVisible(false);
						markStruct.down('#periodName').setVisible(false);
						markStruct.down('#sectionName').setVisible(false);
						markStruct.down('#courseName').setVisible(true);
						markStruct.down('#courseVariantName').setVisible(true);
						markStruct.down('#FacultyName').setVisible(false);

						markGrid.columns[0].setVisible(true);
						markGrid.columns[1].setVisible(true);
						markGrid.columns[2].setVisible(true);
						markGrid.columns[4].setVisible(true);
						markGrid.columns[5].setVisible(true);
						markGrid.columns[6].setVisible(true);
						markGrid.columns[3].setVisible(false);
						
						var submitURL=SERVERURL.COURSE_LEVEL_STUDENT_MARKED_ATTENDANCE;
						store.getProxy().api.read=submitURL;
						store.getProxy().extraParams = {
							courseId: courseId,
							courseVariantId:courseVariantId,
							facultyId:facultyId,
							startDate:startDate,
							endDate:endDate
						};
						this.resetPageSetting(store, markGrid);
						store.load();
					}
				}
				else if(attendanceType=='Multiple Session' || attendanceType=='MULTIPLE_SESSION'){
					if(title=="totalPendings"){
						var markStruct = this.getMarkedattendancedetailswindow();
						var pendingSturct = this.getPendingdetailswindow();
						pendingSturct.down('#attendanceTypeId').setValue('MULTIPLE_SESSION');
						pendingSturct.down('#sectionId').setValue(record.data.sectionId);
						var markGrid = $this.getMarkedattendancedetailgrid();
						var pendingGrid = $this.getPendingattendancedatesgrid();
						var facultyId =this.getCurrentlyLoggedInUser().id;
						
						var form = this.getSessionwisependinngattendancereportsearch().getForm();
						var values = form.getValues();
						
						var alinfomodel = Academia.model.authentication.ALInfoModel;
						var wheatherSchool = alinfomodel.get('wheatherSchool');
						if(wheatherSchool){
							pendingSturct.down('#periodName').setVisible(false);
						}else{
							pendingSturct.down('#periodName').setVisible(true);
						}	 
						pendingSturct.down('#programName').setValue(record.data.programName);
						pendingSturct.down('#batchName').setValue(record.data.batchName);
						pendingSturct.down('#periodName').setValue(record.data.periodName);
						pendingSturct.down('#sectionName').setValue(record.data.sectionCode);
						pendingSturct.down('#programName').setVisible(true);
						pendingSturct.down('#batchName').setVisible(true);
						pendingSturct.down('#sectionName').setVisible(true);
						pendingSturct.down('#courseName').setVisible(false);
						pendingSturct.down('#courseVariantName').setVisible(false);
						pendingSturct.down('#FacultyName').setVisible(false);

						var programId = record.data.programId;
						var batchId = record.data.batchId;
						var periodId =  record.data.periodId;
						var sectionId = record.data.sectionId;
						var startDate = values.programWiseStartDate;
						var endDate = values.programWiseEndDate;
						var sessionNo=1;
						pendingGrid.columns[1].setVisible(false);
						pendingGrid.columns[2].setVisible(false);
						pendingGrid.columns[3].setVisible(false);
						var store = pendingGrid.getStore();

						var submitURL=SERVERURL.PENDING_ATTENDANCE_DATES;
						store.getProxy().api.read=submitURL;
						store.getProxy().extraParams = {
							programId: programId,
							batchId:batchId,
							periodId:periodId,
							sectionId:sectionId,
							startDate:startDate,
							endDate:endDate,
							facultyId:facultyId,
							sessionNo:sessionNo,
							attendanceType:attendanceType
						};
						this.resetPageSetting(store, pendingGrid);
						store.load();
					}
					if(title=="totalMarkedAttendance"){
						var markStruct = $this.getMarkedattendancedetailswindow();
						var pendingSturct = this.getPendingdetailswindow();
						var markGrid = $this.getMarkedattendancedetailgrid();
						var pendingGrid = $this.getPendingattendancedatesgrid();
						
						var form = this.getSessionwisependinngattendancereportsearch().getForm();
						var values = form.getValues();
						var programId = record.data.programId;
						var batchId = record.data.batchId;
						var periodId =  record.data.periodId;
						var sectionId = record.data.sectionId;
						var startDate = values.programWiseStartDate;
						var endDate = values.programWiseEndDate;
						var store = markGrid.getStore();
						var alinfomodel = Academia.model.authentication.ALInfoModel;
						var wheatherSchool = alinfomodel.get('wheatherSchool');
						if(wheatherSchool){
							markStruct.down('#periodName').setVisible(false);
						}else{
							markStruct.down('#periodName').setVisible(true);
						}	 
						markStruct.down('#programName').setValue(record.data.programName);
						markStruct.down('#batchName').setValue(record.data.batchName);
						markStruct.down('#periodName').setValue(record.data.periodName);
						markStruct.down('#sectionName').setValue(record.data.sectionCode);
						markStruct.down('#programName').setVisible(true);
						markStruct.down('#batchName').setVisible(true);
						markStruct.down('#sectionName').setVisible(true);
						markStruct.down('#courseName').setVisible(false);
						markStruct.down('#courseVariantName').setVisible(false);
						markStruct.down('#FacultyName').setVisible(false);

						markGrid.columns[0].setVisible(true);
						markGrid.columns[1].setVisible(false);
						markGrid.columns[2].setVisible(false);
						markGrid.columns[3].setVisible(false);
						markGrid.columns[4].setVisible(true);
						markGrid.columns[5].setVisible(true);
						markGrid.columns[6].setVisible(true);

						var submitURL=SERVERURL.MULTIPLE_SESSION_MARKED_ATTENDANCE;
						store.getProxy().api.read=submitURL;
						store.getProxy().extraParams = {
							programId: programId,
							batchId:batchId,
							periodId:periodId,
							sectionId:sectionId,
							startDate:startDate,
							endDate:endDate,
							attendanceType:attendanceType
						};
						this.resetPageSetting(store, markGrid);
						store.load();
					}
				}
				else{
					if(title=="totalPendings"){
						var markStruct = $this.getMarkedattendancedetailswindow();
						var pendingSturct = this.getPendingdetailswindow();
						pendingSturct.down('#attendanceTypeId').setValue('COMPLETE_DAY');
						pendingSturct.down('#sectionId').setValue(record.data.sectionId);
						var markGrid = $this.getMarkedattendancedetailgrid();
						var pendingGrid = $this.getPendingattendancedatesgrid();
						var facultyId=this.getCurrentlyLoggedInUser().id;
						var form = this.getCompletedaypendingattendancereportsearch().getForm();
						var values = form.getValues();
						var alinfomodel = Academia.model.authentication.ALInfoModel;
						var wheatherSchool = alinfomodel.get('wheatherSchool');
						if(wheatherSchool){
							pendingSturct.down('#periodName').setVisible(false);
						}else{
							pendingSturct.down('#periodName').setVisible(true);
						}	 
						pendingSturct.down('#programName').setValue(record.data.programName);
						pendingSturct.down('#batchName').setValue(record.data.batchName);
						pendingSturct.down('#periodName').setValue(record.data.periodName);
						pendingSturct.down('#sectionName').setValue(record.data.sectionCode);
						pendingSturct.down('#programName').setVisible(true);
						pendingSturct.down('#batchName').setVisible(true);
						pendingSturct.down('#sectionName').setVisible(true);
						pendingSturct.down('#courseName').setVisible(false);
						pendingSturct.down('#courseVariantName').setVisible(false);
						pendingSturct.down('#FacultyName').setVisible(false);

						var programId = record.data.programId;
						var batchId = record.data.batchId;
						var periodId =  record.data.periodId;
						var sectionId = record.data.sectionId;
						var startDate = values.programWiseStartDate;
						var endDate = values.programWiseEndDate;
						pendingGrid.columns[1].setVisible(false);
						pendingGrid.columns[2].setVisible(false);
						pendingGrid.columns[3].setVisible(false);
						var store = pendingGrid.getStore();

						var submitURL=SERVERURL.PENDING_ATTENDANCE_DATES;
						store.getProxy().api.read=submitURL;
						store.getProxy().extraParams = {
							programId: programId,
							batchId:batchId,
							periodId:periodId,
							sectionId:sectionId,
							startDate:startDate,
							endDate:endDate,
							facultyId:facultyId,
							attendanceType:attendanceType

						};
						this.resetPageSetting(store, pendingGrid);
						store.load();
					}
					if(title=="totalMarkedAttendance"){
						var markStruct = $this.getMarkedattendancedetailswindow();
						var pendingSturct = this.getPendingdetailswindow();
						var markGrid = $this.getMarkedattendancedetailgrid();
						var pendingGrid = $this.getPendingattendancedatesgrid();
						var form = this.getCompletedaypendingattendancereportsearch().getForm();
						var values = form.getValues();
						var programId = record.data.programId;
						var batchId = record.data.batchId;
						var periodId =  record.data.periodId;
						var sectionId = record.data.sectionId;
						var startDate = values.programWiseStartDate;
						var endDate = values.programWiseEndDate;
						var store = markGrid.getStore();

						var alinfomodel = Academia.model.authentication.ALInfoModel;
						var wheatherSchool = alinfomodel.get('wheatherSchool');
						if(wheatherSchool){
							markStruct.down('#periodName').setVisible(false);
						}else{
							markStruct.down('#periodName').setVisible(true);
						}	 
						markStruct.down('#programName').setValue(record.data.programName);
						markStruct.down('#batchName').setValue(record.data.batchName);
						markStruct.down('#periodName').setValue(record.data.periodName);
						markStruct.down('#sectionName').setValue(record.data.sectionCode);
						markStruct.down('#programName').setVisible(true);
						markStruct.down('#batchName').setVisible(true);
						markStruct.down('#sectionName').setVisible(true);
						markStruct.down('#courseName').setVisible(false);
						markStruct.down('#courseVariantName').setVisible(false);
						markStruct.down('#FacultyName').setVisible(false);

						markGrid.columns[0].setVisible(true);
						markGrid.columns[1].setVisible(false);
						markGrid.columns[2].setVisible(false);
						markGrid.columns[3].setVisible(false);
						markGrid.columns[4].setVisible(true);
						markGrid.columns[5].setVisible(true);
						markGrid.columns[6].setVisible(true);

						var submitURL=SERVERURL.MARKED_ATTENDANCE;
						store.getProxy().api.read=submitURL;
						store.getProxy().extraParams = {
							programId: programId,
							batchId:batchId,
							periodId:periodId,
							sectionId:sectionId,
							startDate:startDate,
							endDate:endDate,
							attendanceType:attendanceType
						};
						this.resetPageSetting(store, markGrid);
						store.load();
					}
				}
			}
});