/**
 * This controller is used for the Front Desk Management Add/Edit/Delete/View
 * 
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.controller.fdmanagement.FDManagementController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['fdmanagement.EntryTypeStore',
        'common.CountryStore',
        'coursetransaction.studymaterialdistributionnew.ServiceProviderSmdStr',
        'course.readingmaterial.ReadingTypeStore',
        'fdmanagement.FDManagementStore',
        'fdmanagement.FDManagementDocumentStore',
        'fdmanagement.FDItemDetailsStore',
        'fdmanagement.AcknowledgeStatusStore',
        'fdmanagement.InsuranceType',
        'fdmanagement.FDManagementOutwardStore',
        'fdmanagement.FDManagementOutwardDocumentStore',
        'fdmanagement.FDOutwardItemStatusStore',
        'fdmanagement.FDOutwardItemDetailsStore',
        'fdmanagement.FDManagementOutwardUpdateStatusDocumentStore',
        'fdmanagement.FDItemSmartSearchByInwardNoStore',
        'fdmanagement.FDOutwardItemSmartSearchByOutwardNoStore',
        'fdmanagement.FDItemSmartSearchByBillNoStore',
        'fdmanagement.FDItemSmartSearchByDocketNoStore',
        'fdmanagement.FDOutwardItemSmartSearchByInternalPacketNoStore',
        'fdmanagement.FDOutwardItemSmartSearchByDocketNoStore',
        'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
        'user.UserByALAndGroupId',
        'fdmanagement.FDTemplateForStore',
        'importutility.ModuleName',
        'fdmanagement.ImportFDInwardOutward'
    ],
    views: ['fdmanagement.FDManagementStructure',
        'fdmanagement.FDManagementTabStructure',
        'fdmanagement.FDManagementFilter',
        'fdmanagement.FDManagementGrid',
        'fdmanagement.FDAddItemEntryForm',
        'baselayout.contentarea.ContentPanel',
        'fdmanagement.FDItemEntryDocumentGrid',
        'fdmanagement.FDItemDocumentWin',
        'fdmanagement.FDItemDetailsWin',
        'fdmanagement.FDItemDetailsGrid',
        'fdmanagement.facultyPortal.FDMEStructure',
        'fdmanagement.facultyPortal.FDMETabStructure',
        'fdmanagement.facultyPortal.FDMEFilter',
        'fdmanagement.facultyPortal.FDMEGrid',
        'fdmanagement.facultyPortal.FDMEUpdateStatusWin',
        'fdmanagement.facultyPortal.FDMEBillDetailsWin',
        'fdmanagement.FDManagementOutwardGrid',
        'fdmanagement.FDOutwardItemEntryDocumentGrid',
        'fdmanagement.FDItemInsuranceDetailsWin',
        'fdmanagement.FDOutwardItemDocumentWin',
        'fdmanagement.FDMOutwardItemUpdateStatusWin',
        'fdmanagement.facultyPortal.FDMEOutwardGrid',
        'fdmanagement.FDOutwardItemDetailsWin',
        'fdmanagement.FDOutwardItemDetailsGrid',
        'fdmanagement.FDOutwardItemUpdateStatusDocumentGrid',
        'fdmanagement.FDInwardForm',
        'fdmanagement.FDManagementLoaderStructure',
        'fdmanagement.DownloadFDInwardOutwardItem',
        'fdmanagement.ImportFDInwardOutwardUploadForm',
        'UploadOptionRadioGroup',
        'fdmanagement.ImportFDInwardOutwardItemGrid'
    ],
    models: ['fdmanagement.FDManagementOutwardModel'],
    refs: [{
        ref: 'contentpanel',
        selector: 'contentpanel'
    }, {
        ref: 'fdadditementryform',
        selector: 'fdadditementryform'
    }, {
        ref: 'fdmanagementgrid',
        selector: 'fdmanagementgrid'
    }, {
        ref: 'fdmanagementfilter',
        selector: 'fdmanagementfilter'
    }, {
        ref: 'fditementrydocumentgrid',
        selector: 'fditementrydocumentgrid'
    }, {
        ref: 'fditemdocumentwin',
        selector: 'fditemdocumentwin'
    }, {
        ref: 'fditemdetailsgrid',
        selector: 'fditemdetailsgrid'
    }, {
        ref: 'fditemdetailswin',
        selector: 'fditemdetailswin'
    }, {
        ref: 'fdmeupdatestatuswin',
        selector: 'fdmeupdatestatuswin'
    }, {
        ref: 'fdmegrid',
        selector: 'fdmegrid'
    }, {
        ref: 'fdmefilter',
        selector: 'fdmefilter'
    }, {
        ref: 'fdmebilldetailswin',
        selector: 'fdmebilldetailswin'
    }, {
        ref: 'fdmanagementoutwardgrid',
        selector: 'fdmanagementoutwardgrid'
    }, {
        ref: 'fdoutwarditementrydocumentgrid',
        selector: 'fdoutwarditementrydocumentgrid'
    }, {
        ref: 'fditeminsurancedetailswin',
        selector: 'fditeminsurancedetailswin'
    }, {
        ref: 'fdoutwarditemdocumentwin',
        selector: 'fdoutwarditemdocumentwin'
    }, {
        ref: 'fdmoutwarditemupdatestatuswin',
        selector: 'fdmoutwarditemupdatestatuswin'
    }, {
        ref: 'fdmeoutwardgrid',
        selector: 'fdmeoutwardgrid'
    }, {
        ref: 'fdoutwarditemdetailswin',
        selector: 'fdoutwarditemdetailswin'
    }, {
        ref: 'fdoutwarditemdetailsgrid',
        selector: 'fdoutwarditemdetailsgrid'
    }, {
        ref: 'fdoutwarditemupdatestatusdocumentgrid',
        selector: 'fdoutwarditemupdatestatusdocumentgrid'
    },{
    	ref: 'fdmanagementtabstructure',
        selector: 'fdmanagementtabstructure'
    },{
    	ref: 'fdmanagementloaderstructure',
        selector: 'fdmanagementloaderstructure'
    },{
    	ref: 'downloadfdinwardoutwarditem',
        selector: 'downloadfdinwardoutwarditem'
    },{
    	ref: 'importfdinwardoutwarditemgrid',
        selector: 'importfdinwardoutwarditemgrid'
    },{
    	ref: 'importfdinwardoutwarduploadform',
        selector: 'importfdinwardoutwarduploadform'
    },{
    	ref: 'uploadoptionradiogroup',
        selector: 'uploadoptionradiogroup'
    },{
    	ref:'fdmestructure',
    	selector:'fdmestructure'
    }],
    config: {
        FRONT_DESK_MANAGEMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FRONT_DESK_MANAGEMENT_PRIVILEGES'),
        FRONT_DESK_MANAGEMENT_EMP_PORTAL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FRONT_DESK_MANAGEMENT_EMP_PORTAL_PRIVILEGES'),
        FRONT_DESK_MANAGEMENT_STUDENT_PORTAL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FRONT_DESK_MANAGEMENT_STUDENT_PORTAL_PRIVILEGES'),
        FRONT_DESK_MANAGEMENT_PARENT_PORTAL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FRONT_DESK_MANAGEMENT_PARENT_PORTAL_PRIVILEGES'),
    },
    init: function() {
        this.control({
            'fdmanagementgrid button[itemId=btnAdd]': {
                click: this.openAddItemEntryTabAndFillEntryType
            },
            'fdmanagementoutwardgrid button[itemId=btnAdd]': {
                click: this.openAddItemEntryTabAndFillEntryType
            },
            'fdmanagementgrid button[itemId=btnView]': {
                click: function() {
                    this.viewItemEntry('Inward')
                }
            },
            'fdmanagementoutwardgrid button[itemId=btnView]': {
                click: function() {
                    this.viewItemEntry('Outward')
                }
            },
            'fdmanagementgrid button[itemId=btnEdit]': {
                click: function() {
                    this.editFDItemEntry('EDIT', 'Inward');
                }
            },
            'fdmanagementoutwardgrid button[itemId=btnEdit]': {
                click: function() {
                    this.editFDItemEntry('EDIT', 'Outward');
                }
            },
            'fdmanagementgrid button[itemId=btnDelete]': {
                click: function() {
                    this.deleteFDItemEntry('Inward');
                }
            },
            'fdmanagementoutwardgrid button[itemId=btnDelete]': {
                click: function() {
                    this.deleteFDItemEntry('Outward');
                }
            },
            'fdadditementryform button[itemId=addFilterBtn]': {
                click: function(obj) {
                    this.addMultipleDocketNoTextField(obj, true);
                }
            },
            'fdadditementryform combo#insuredByIdItemId': {
                render: function(obj) {
                    var store = obj.getStore();
                    store.getProxy().extraParams = {
                        type: 'InsuranceType'
                    };
                    store.load();
                }
            },
            
            'fdmanagementtabstructure':{
            	afterrender:function(structure){
            		var $this = this;
            		var grid = null;
     				 //var structure =$this.getFdmanagementtabstructure();
     				var fdmanagementgrid = $this.getFdmanagementgrid();
     				var fdmanagementoutwardgrid = $this.getFdmanagementoutwardgrid();
     				//structure = structure.down('panel');
     				structure.body.on('scroll', function(e, target) {
     					
     					if(!fdmanagementgrid.isHidden()){
     						grid = fdmanagementgrid;
     					}
     					else if(!fdmanagementoutwardgrid.isHidden()){
     						grid = fdmanagementoutwardgrid;
     					}
     					
                    	if(grid!=null){
            				 //$this.getMultipleGridHeaderFreeze(grid,structure,true); 
            			 }
                    });
            	}
            },
            'fdadditementryform button[itemId=saveFdadditementryformItemId]': {
                click: this.saveFDAddItemEntry
            },
            'fdadditementryform checkboxfield#billReceivedItemId': {
                change: function(obj, newValue, oldValue, eOpts) {
                    var form = obj.up('fdadditementryform');
                    var billNoItemId = form.down("#billNoItemId");
                    var billAmountItemId = form.down("#billAmountItemId");
                    var insuredByIdItemId = form.down("#insuredByIdItemId");
                    var policyNoItemId = form.down("#policyNoItemId");
                    var insuranceAmountItemId = form.down("#insuranceAmountItemId");

                    if (newValue) {
                        billNoItemId.setVisible(true);
                        billAmountItemId.setVisible(true);
                        billNoItemId.allowBlank = false;
                        billAmountItemId.allowBlank = false;
                    } else {
                        billNoItemId.setVisible(false);
                        billAmountItemId.setVisible(false);
                        billNoItemId.allowBlank = true;
                        billAmountItemId.allowBlank = true;
                    }
                    billNoItemId.reset();
                    billAmountItemId.reset();

                    insuredByIdItemId.setVisible(false);
                    policyNoItemId.setVisible(false);
                    insuranceAmountItemId.setVisible(false);
                    insuredByIdItemId.reset();
                    policyNoItemId.reset();
                    insuranceAmountItemId.reset();
                    insuredByIdItemId.allowBlank = true;
                    policyNoItemId.allowBlank = true;
                    insuranceAmountItemId.allowBlank = true;

                    form.getForm().isValid();
                }
            },
            'fdadditementryform combo#receiverNameItemId': {
                select: function(obj, record) {
                    this.getReceiverDetails(record);
                }
            },
            'fdadditementryform combo#outwardSenderIdItemId': {
                select: function(obj, record) {
                    this.getSenderDetails(record);
                }
            },
            'fdmanagementfilter button[itemId=searchBtnFfdmanagementfilterItemId]': {
                click: function() {
                    this.loadFDManagementGrid();
                }
            },
            'fdmanagementfilter button[itemId=resetBtnFfdmanagementfilterItemId]': {
                click: function() {
                    this.resetFDmanagementfilter();
                }
            },
            'fdadditementryform button[itemId=resetFdadditementryformItemId]': {
                click: function() {
                    this.resetFDadditementryform();
                }
            },
            'fdadditementryform button#itementryDocumentUploadId': {
                click: function() {
                    this.getDocumentController().showDocumentFormWindow('fdadditementryformItemId', 'DOCUMENT');
                }
            },
            'documentformwindow[itemId=fdadditementryformItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId': {
                click: function() {
                    var $this = this;
                    var isTransient = true;
                    var module = 'toolnservice';
                    var entityId;
                    var entityType = 'itemdocument';
                    var entryType = $this.getFdadditementryform().getForm().getValues().entryType;
                    var documentGrid;
                    if (entryType == 'Inward') {
                        documentGrid = $this.getFditementrydocumentgrid();
                    } else {
                        documentGrid = $this.getFdoutwarditementrydocumentgrid();
                    }

                    $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient) {
                        var documentModel = new Academia.model.fdmanagement.FDManagementDocumentModel();
                        documentModel.set("documentName", response.name);
                        documentModel.set("path", response.path);
                        documentModel.set("type", response.type);
                        documentModel.set("documentName", response.name);
                        documentModel.set("isNewRecord", true);
                        documentModel.set("createdBy", $this.getIdValueJson(response.createdBy.id, response.createdBy.value));

                        var store = documentGrid.getStore();
                        store.add(documentModel);
                        documentGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ store.getCount());
                        if (documentGrid.isHidden() && store.data.items.length > 0) {
                            documentGrid.setVisible(true);
                        }
                        Ext.apply(documentGrid, {
                            code: null,
                            setCode: function(code) {
                                documentGrid.code = code;
                            },
                            getCode: function() {
                                return documentGrid.code;
                            }
                        });
                        documentGrid.setCode(documentModel);
                        $this.getDocumentController().closeDocumentFormWindow();
                    }, isTransient);
                }
            },
            'documentformwindow[itemId=fdadditementryformItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId': {
                click: function() {
                    this.getDocumentController().closeDocumentFormWindow();
                }
            },
            'fditementrydocumentgrid button#btnDelete': {
                click: function() {
                    this.deleteDocumentFromGrid('Inward');
                }
            },
            'fdoutwarditementrydocumentgrid button#btnDelete': {
                click: function() {
                    this.deleteDocumentFromGrid('Outward');
                }
            },
            'fdoutwarditemupdatestatusdocumentgrid button[itemId=btnDelete]': {
                click: function() {
                    this.deleteDocumentFromGrid('OutwardUpdateStatus');
                }
            },
            'fdmanagementgrid': {
                beforerender: function() {
                    this.getStore('fdmanagement.FDManagementStore').removeAll();
                },
                render: function(grid) {
                    this.doAccessControlValidation(grid, this.getFRONT_DESK_MANAGEMENT_PERMISSIONS());
                    this.disableMoreActionPivileges(grid, this.getFRONT_DESK_MANAGEMENT_PERMISSIONS());
                },
                afterrender:function(grid){
					var me = this;
					setTimeout(function(){
						me.addDataGridConfigButton(grid,me.getFRONT_DESK_MANAGEMENT_PERMISSIONS());
					},1500);
				 },
                cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
                    if (e.target.tagName == 'A') {
                        var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
                        var $this = this;
                        var grid = $this.getFdmanagementgrid();
                        if (columnName == 'fdItemDetails') {
                            var formWindow = $this.getFditemdetailswin();
                            if (!formWindow) {
                                Ext.widget('fditemdetailswin');
                                formWindow = $this.getFditemdetailswin();
                            }
                            formWindow.show();
                            var documentGrid = $this.getFditemdetailsgrid();
                            documentGrid.getStore().getProxy().extraParams = {
                                fdManagementItemId: record.data.id
                            };
                            documentGrid.down('#btnDelete').setVisible(false);
                            documentGrid.getStore().load();
                        } else {
                            var formWindow = $this.getFditemdocumentwin();
                            if (!formWindow) {
                                Ext.widget('fditemdocumentwin');
                                formWindow = $this.getFditemdocumentwin();
                            }
                            formWindow.show();
                            var documentGrid = $this.getFditementrydocumentgrid();
                            documentGrid.getStore().getProxy().extraParams = {
                                fdManagementItemId: record.data.id
                            };
                            documentGrid.down('#btnDelete').setVisible(false);
                            documentGrid.getStore().load();
                        }
                    }
                }
            },
            'fditementrydocumentgrid': {
            	afterrender:function(grid){
            		var store = grid.store;
            		setTimeout(function(){
            		  grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ store.getCount());
					},1000);
            	},
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var documentGrid = $this.getFditementrydocumentgrid();
                    var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

                    if (columnName == "documentName") {
                        if (e.target.tagName == 'A') {
                            var documentId = record.get("documentId");
                            if (!isNullOrEmpty(documentId)) {
                                $this.getDocumentController().downloadDocumentFile(documentId);
                            }
                        }
                    }
                }
            },
            'fdoutwarditementrydocumentgrid': {
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var documentGrid = $this.getFdoutwarditementrydocumentgrid();
                    var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
                    if (columnName == "documentName") {
                        if (e.target.tagName == 'A') {
                            var documentId = record.get("documentId");
                            if (!isNullOrEmpty(documentId)) {
                                $this.getDocumentController().downloadDocumentFile(documentId);
                            }
                        }
                    }
                }
            },
            'fdoutwarditemupdatestatusdocumentgrid': {
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var documentGrid = $this.getFdoutwarditemupdatestatusdocumentgrid();
                    var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

                    if (columnName == "documentName") {
                        if (e.target.tagName == 'A') {
                            var documentId = record.get("documentId");
                            if (!isNullOrEmpty(documentId)) {
                                $this.getDocumentController().downloadDocumentFile(documentId);
                            }
                        }
                    }
                }
            },
            'fdmefilter button[itemId=searchBtnFdmefilterItemId]': {
                click: function() {
                    this.loadFDMEGrid();
                }
            },
            'fdmegrid': {
                beforerender: function() {
                    this.getStore('fdmanagement.FDManagementStore').removeAll();
                },
                render: function(grid) {
                	if(portalId == 2) {
                		this.doAccessControlValidation(grid, this.getFRONT_DESK_MANAGEMENT_EMP_PORTAL_PERMISSIONS());
                        this.disableMoreActionPivileges(grid, this.getFRONT_DESK_MANAGEMENT_EMP_PORTAL_PERMISSIONS());
                	} else if(portalId == 3) {
                		this.doAccessControlValidation(grid, this.getFRONT_DESK_MANAGEMENT_STUDENT_PORTAL_PERMISSIONS());
                		this.disableMoreActionPivileges(grid, this.getFRONT_DESK_MANAGEMENT_STUDENT_PORTAL_PERMISSIONS());
                	}
                	else if(portalId == 7) {
                		this.doAccessControlValidation(grid, this.getFRONT_DESK_MANAGEMENT_PARENT_PORTAL_PERMISSIONS());
                		this.disableMoreActionPivileges(grid, this.getFRONT_DESK_MANAGEMENT_PARENT_PORTAL_PERMISSIONS());
                	}
                },
                cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
                    if (e.target.tagName == 'A') {
                        var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
                        var $this = this;
                        var grid = $this.getFdmegrid();
                        if (columnName == 'fdItemDetails') {
                            var formWindow = $this.getFditemdetailswin();
                            if (!formWindow) {
                                Ext.widget('fditemdetailswin');
                                formWindow = $this.getFditemdetailswin();
                            }
                            formWindow.show();
                            var documentGrid = $this.getFditemdetailsgrid();
                            documentGrid.getStore().getProxy().extraParams = {
                                fdManagementItemId: record.data.id
                            };
                            documentGrid.down('#btnDelete').setVisible(false);
                            documentGrid.getStore().load();
                        } else if (columnName == 'isBillReceived') {
                            var formWindow = $this.getFdmebilldetailswin();
                            if (!formWindow) {
                                Ext.widget('fdmebilldetailswin');
                                formWindow = $this.getFdmebilldetailswin();
                            }

                            var record = grid.getSelectionModel().getSelection()[0];
                            var inwardNo = record.get("inwardNo");
                            var senderName = record.get("senderName");
                            var noOfPackets = record.get("noOfPackets");
                            var billNo = record.get("billNo");
                            var billAmount = record.get("billAmount");

                            var form = formWindow.down('#fdmeBillDetailFormItemId');
                            var inwardNoItemId = form.down('#inwardNoItemId');
                            var nameOfSenderItemId = form.down('#nameOfSenderItemId');
                            var noOfPiecesItemId = form.down('#noOfPiecesItemId');
                            var billNoItemId = form.down('#billNoItemId');
                            var billAmountItemId = form.down('#billAmountItemId');

                            inwardNoItemId.setValue(inwardNo);
                            nameOfSenderItemId.setValue(senderName);
                            noOfPiecesItemId.setValue(noOfPackets);
                            billNoItemId.setValue(billNo);
                            billAmountItemId.setValue(billAmount);

                            formWindow.show();
                        } else {
                            var formWindow = $this.getFditemdocumentwin();
                            if (!formWindow) {
                                Ext.widget('fditemdocumentwin');
                                formWindow = $this.getFditemdocumentwin();
                            }
                            formWindow.show();
                            var documentGrid = $this.getFditementrydocumentgrid();
                            documentGrid.getStore().getProxy().extraParams = {
                                fdManagementItemId: record.data.id
                            };
                            documentGrid.down('#btnDelete').setVisible(false);
                            documentGrid.getStore().load();
                        }
                    }
                }
            },
            'fdmegrid button[itemId=btnUpdateStatusItemId]': {
                click: function() {
                    var $this = this;
                    var grid = this.getFdmegrid();
                    if (grid.getSelectionModel().getCount() > 0) {
                        var formWindow = $this.getFdmeupdatestatuswin();
                        if (!formWindow) {
                            Ext.widget('fdmeupdatestatuswin');
                            formWindow = $this.getFdmeupdatestatuswin();
                        }
                        var record = grid.getSelectionModel().getSelection()[0];
                        var inwardNo = record.get("inwardNo");
                        var senderName = record.get("senderName");
                        var noOfPackets = record.get("noOfPackets");

                        var acknowledgeStatus = record.get("acknowledgeStatus");
                        var acknowledgmentDate = record.get("acknowledgmentDate");
                        var receiverRemarks = record.get("receiverRemarks");

                        var form = formWindow.down('#fdmeUpdateStatusFormItemId');
                        var inwardNoItemId = form.down('#inwardNoItemId');
                        var nameOfSenderItemId = form.down('#nameOfSenderItemId');
                        var noOfPiecesItemId = form.down('#noOfPiecesItemId');

                        var acknowledgeStatusItemId = form.down('#acknowledgeStatusItemId');
                        var acknowledgmentDateItemId = form.down('#acknowledgmentDateItemId');
                        var receiverRemarksItemId = form.down('#receiverRemarksItemId');
                        formWindow.show();
                        inwardNoItemId.setValue(inwardNo);
                        nameOfSenderItemId.setValue(senderName);
                        noOfPiecesItemId.setValue(noOfPackets);
                        acknowledgeStatusItemId.setValue(acknowledgeStatus);
                        acknowledgmentDateItemId.setValue(dateRender(acknowledgmentDate));
                        receiverRemarksItemId.setValue(receiverRemarks);
                    } else {
                        showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
                    }
                }
            },
            'fdmanagementgrid splitbutton[itemId=spBtnMoreActions] #btnUpdateStatusItemId': {
                click: function() {
                    var $this = this;
                    var grid = this.getFdmanagementgrid();
                    if (grid.getSelectionModel().getCount() > 0) {
                        var formWindow = $this.getFdmeupdatestatuswin();
                        if (!formWindow) {
                            Ext.widget('fdmeupdatestatuswin');
                            formWindow = $this.getFdmeupdatestatuswin();
                        }
                        if(portalId == 1) {
                        	formWindow.setTitle(getServiceRequestTranslation('FD_UPDATE_STATUS'));
                        }
                        var record = grid.getSelectionModel().getSelection()[0];
                        var inwardNo = record.get("inwardNo");
                        var senderName = record.get("senderName");
                        var noOfPackets = record.get("noOfPackets");

                        var acknowledgeStatus = record.get("acknowledgeStatus");
                        var acknowledgmentDate = record.get("acknowledgmentDate");
                        var receiverRemarks = record.get("receiverRemarks");

                        var form = formWindow.down('#fdmeUpdateStatusFormItemId');
                        var inwardNoItemId = form.down('#inwardNoItemId');
                        var nameOfSenderItemId = form.down('#nameOfSenderItemId');
                        var noOfPiecesItemId = form.down('#noOfPiecesItemId');

                        var acknowledgeStatusItemId = form.down('#acknowledgeStatusItemId');
                        var acknowledgmentDateItemId = form.down('#acknowledgmentDateItemId');
                        var receiverRemarksItemId = form.down('#receiverRemarksItemId');
                        formWindow.show();
                        inwardNoItemId.setValue(inwardNo);
                        nameOfSenderItemId.setValue(senderName);
                        noOfPiecesItemId.setValue(noOfPackets);
                        acknowledgeStatusItemId.setValue(acknowledgeStatus);
                        acknowledgmentDateItemId.setValue(dateRender(acknowledgmentDate));
                        acknowledgmentDateItemId.setMinValue(new Date(record.data.deliveryDate));
                        receiverRemarksItemId.setValue(receiverRemarks);
                    } else {
                        showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
                    }
                }
            },
            'fdmeupdatestatuswin button[itemId=saveFdmeupdatestatuswinItemId]': {
                click: function() {
                    var $this = this;
                    var formWindow = $this.getFdmeupdatestatuswin();
                    var grid;
                    if(portalId == 1) {
                    	grid = $this.getFdmanagementgrid();
                    } else {
                    	grid = $this.getFdmegrid();
                    }
                    var record = grid.getSelectionModel().getSelection()[0];
                    var id = record.get("id");

                    var form = formWindow.down('#fdmeUpdateStatusFormItemId');
                    var formValues = form.getValues();

                    var acknowledgeStatus = formValues.acknowledgeStatus;
                    var acknowledgmentDate = formValues.acknowledgmentDate;
                    var receiverRemarks = formValues.receiverRemarks;

                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.FD_MANAGEMENT_ITEMS_UPDATE_STATUS,
                        jsonData: {
                            id: id,
                            acknowledgeStatus: acknowledgeStatus,
                            acknowledgmentDate: acknowledgmentDate,
                            receiverRemarks: receiverRemarks
                        },
                        method: 'POST',
                        success: function(frm, action) {
                            Ext.getBody().unmask();
                            var grid;
                            if(portalId == 1) {
                            	grid = $this.getFdmanagementgrid();
                            } else {
                            	grid = $this.getFdmegrid();
                            }
                            $this.resetPageSetting(grid.getStore());
                            grid.getStore().reload();
                            grid.getSelectionModel().deselectAll();
                            showSuccessMessage(getCommonTranslation('FD_MANAGEMENT_ITEMS_STATUS_UPDATED_SUCCESSFULLY'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
                            formWindow.close();
                        }
                    });
                }
            },
            'fdadditementryform combo#entryTypeItemId': {
                select: function(obj, record) {
                    var $this = this;
                    var fdAddItemEntryForm = this.getFdadditementryform();

                    var fdinwardformItemId = fdAddItemEntryForm.down('#fdinwardformItemId');
                    var inwardNoItemId = fdAddItemEntryForm.down('#inwardNoItemId');
                    var outwardNoItemId = fdAddItemEntryForm.down('#outwardNoItemId');

                    var nameOfSenderItemId = fdAddItemEntryForm.down('#nameOfSenderItemId');
                    var outwardSenderIdItemId = fdAddItemEntryForm.down('#outwardSenderIdItemId');

                    var receiverNameItemId = fdAddItemEntryForm.down('#receiverNameItemId');
                    var deliverToItemId = fdAddItemEntryForm.down('#deliverToItemId');
                    var deliveryAddressItemId = fdAddItemEntryForm.down('#deliveryAddressItemId');

                    var dateOfDeliveryItemId = fdAddItemEntryForm.down('#dateOfDeliveryItemId');
                    var sentDateItemId = fdAddItemEntryForm.down('#sentDateItemId');

                    var serviceProviderItemId = fdAddItemEntryForm.down('#serviceProviderItemId');

                    var billReceivedItemId = fdAddItemEntryForm.down('#billReceivedItemId');
                    var itemInsuredItemId = fdAddItemEntryForm.down('#itemInsuredItemId');

                    var inwardEntryByItemId = fdAddItemEntryForm.down('#inwardEntryByItemId');
                    var outwardEntryByItemId = fdAddItemEntryForm.down('#outwardEntryByItemId');

                    var insuredByIdItemId = fdAddItemEntryForm.down("#insuredByIdItemId");
                    var policyNoItemId = fdAddItemEntryForm.down("#policyNoItemId");
                    var insuranceAmountItemId = fdAddItemEntryForm.down("#insuranceAmountItemId");
                    var billNoItemId = fdAddItemEntryForm.down("#billNoItemId");
                    var billAmountItemId = fdAddItemEntryForm.down("#billAmountItemId");

                    var noOfPiecesItemId = fdAddItemEntryForm.down("#noOfPiecesItemId");
                    var internalPacketNoItemId = fdAddItemEntryForm.down("#internalPacketNoItemId");

                    var stopContiner = fdAddItemEntryForm.down('#docketNoContainerItemId');
                    var containerLength = stopContiner.items.length;
                    for (var j = 1; j < containerLength; j++) {
                        var docketNoPanelContainer = stopContiner.items.items[1];
                        stopContiner.remove(docketNoPanelContainer);
                    }

                    var inwardDocumentGrid = $this.getFditementrydocumentgrid();
                    var outwardDocumentGrid = $this.getFdoutwarditementrydocumentgrid();

                    var idTableMappingStore = Ext.data.StoreManager.lookup('datasetting.IdTableMappingStore');

                    if (record[0].data.value == 'Inward') {
                        fdinwardformItemId.setVisible(true);
                        inwardNoItemId.setVisible(true);
                        outwardNoItemId.setVisible(false);

                        nameOfSenderItemId.setVisible(true);
                        outwardSenderIdItemId.setVisible(false);

                        receiverNameItemId.setVisible(true);
                        deliverToItemId.setVisible(false);
                        deliveryAddressItemId.setVisible(false);

                        dateOfDeliveryItemId.setVisible(true);
                        sentDateItemId.setVisible(false);

                        billReceivedItemId.setVisible(true);
                        itemInsuredItemId.setVisible(false);

                        inwardEntryByItemId.setVisible(true);
                        outwardEntryByItemId.setVisible(false);
                        internalPacketNoItemId.setVisible(false);

                        receiverNameItemId.allowBlank = false;
                        receiverNameItemId.forceSelection = true;
                        inwardEntryByItemId.allowBlank = false;
                        inwardEntryByItemId.forceSelection = true;

                        outwardSenderIdItemId.allowBlank = true;
                        outwardSenderIdItemId.forceSelection = false;
                        outwardEntryByItemId.allowBlank = true;
                        outwardEntryByItemId.forceSelection = false;

                        nameOfSenderItemId.allowBlank = false;
                        deliverToItemId.allowBlank = true;

                        inwardDocumentGrid.setVisible(true);
                        outwardDocumentGrid.setVisible(false);

                        dateOfDeliveryItemId.allowBlank = false;
                        sentDateItemId.allowBlank = true;

                        var idTableMappingRecord = idTableMappingStore.findRecord('tableName', 'fd_management_items', 0, false, true, true);
                        if (!idTableMappingRecord) {
                            inwardNoItemId.allowBlank = false;
                        }
                        outwardNoItemId.allowBlank = true;

                        this.setAllowBlank(serviceProviderItemId,true);
                    } else {
                        fdinwardformItemId.setVisible(false);
                        inwardNoItemId.setVisible(false);
                        outwardNoItemId.setVisible(true);

                        nameOfSenderItemId.setVisible(false);
                        outwardSenderIdItemId.setVisible(true);

                        receiverNameItemId.setVisible(false);
                        deliverToItemId.setVisible(true);
                        deliveryAddressItemId.setVisible(true);

                        dateOfDeliveryItemId.setVisible(false);
                        sentDateItemId.setVisible(true);

                        billReceivedItemId.setVisible(false);
                        itemInsuredItemId.setVisible(true);

                        inwardEntryByItemId.setVisible(false);
                        outwardEntryByItemId.setVisible(true);
                        internalPacketNoItemId.setVisible(true);

                        receiverNameItemId.allowBlank = true;
                        receiverNameItemId.forceSelection = false;
                        inwardEntryByItemId.allowBlank = true;
                        inwardEntryByItemId.forceSelection = false;

                        outwardSenderIdItemId.allowBlank = false;
                        outwardSenderIdItemId.forceSelection = true;
                        outwardEntryByItemId.allowBlank = false;
                        outwardEntryByItemId.forceSelection = true;

                        nameOfSenderItemId.allowBlank = true;
                        deliverToItemId.allowBlank = false;

                        inwardDocumentGrid.setVisible(false);
                        outwardDocumentGrid.setVisible(true);

                        dateOfDeliveryItemId.allowBlank = true;
                        sentDateItemId.allowBlank = false;

                        var idTableMappingRecord = idTableMappingStore.findRecord('tableName', 'invt_student_distribution', 0, false, true, true);
                        if (!idTableMappingRecord) {
                            outwardNoItemId.allowBlank = false;
                        }
                        inwardNoItemId.allowBlank = true;

                        this.setAllowBlank(serviceProviderItemId,false);
                    }
                    noOfPiecesItemId.setValue(1);
                    billReceivedItemId.setValue(false);
                    itemInsuredItemId.setValue(false);
                    insuredByIdItemId.setVisible(false);
                    policyNoItemId.setVisible(false);
                    insuranceAmountItemId.setVisible(false);
                    billNoItemId.setVisible(false);
                    billAmountItemId.setVisible(false);
                    insuredByIdItemId.allowBlank = true;
                    policyNoItemId.allowBlank = true;
                    insuranceAmountItemId.allowBlank = true;
                    billNoItemId.allowBlank = true;
                    billAmountItemId.allowBlank = true;
                    /*insuredByIdItemId.reset();
    				 policyNoItemId.reset();
    				 insuranceAmountItemId.reset();
    				 billNoItemId.reset();
                    billAmountItemId.reset();*/
                    $this.resetFDadditementryform();
                    $this.removePlaceHolder(record[0].data.value);
                }
            },
            'fdadditementryform checkboxfield#itemInsuredItemId': {
                change: function(obj, newValue, oldValue, eOpts) {
                    var form = obj.up('fdadditementryform');
                    var insuredByIdItemId = form.down("#insuredByIdItemId");
                    var policyNoItemId = form.down("#policyNoItemId");
                    var insuranceAmountItemId = form.down("#insuranceAmountItemId");
                    var billNoItemId = form.down("#billNoItemId");
                    var billAmountItemId = form.down("#billAmountItemId");

                    if (newValue) {
                        insuredByIdItemId.setVisible(true);
                        policyNoItemId.setVisible(true);
                        insuranceAmountItemId.setVisible(true);
                        insuredByIdItemId.allowBlank = false;
                        policyNoItemId.allowBlank = false;
                        insuranceAmountItemId.allowBlank = false;
                    } else {
                        insuredByIdItemId.setVisible(false);
                        policyNoItemId.setVisible(false);
                        insuranceAmountItemId.setVisible(false);
                        insuredByIdItemId.allowBlank = true;
                        policyNoItemId.allowBlank = true;
                        insuranceAmountItemId.allowBlank = true;
                    }
                    insuredByIdItemId.reset();
                    policyNoItemId.reset();
                    insuranceAmountItemId.reset();

                    billNoItemId.setVisible(false);
                    billAmountItemId.setVisible(false);
                    billNoItemId.reset();
                    billAmountItemId.reset();
                    billNoItemId.allowBlank = true;
                    billAmountItemId.allowBlank = true;

                    form.getForm().isValid();
                }
            },
            'fdmanagementfilter combo#entryTypeItemId': {
                select: function(obj, record) {
                    this.entryTypeChnage();
                    //this.resetFDmanagementfilter();
                }
            },
            'fdmanagementoutwardgrid': {
                beforerender: function() {
                    this.getStore('fdmanagement.FDManagementOutwardStore').removeAll();
                },
                render: function(grid) {
                    this.doAccessControlValidation(grid, this.getFRONT_DESK_MANAGEMENT_PERMISSIONS());
                    this.disableMoreActionPivileges(grid, this.getFRONT_DESK_MANAGEMENT_PERMISSIONS());
                },
                afterrender:function(grid){
					var me = this;
					setTimeout(function(){
						me.addDataGridConfigButton(grid,me.getFRONT_DESK_MANAGEMENT_PERMISSIONS());
					},1500);
				 },
                cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
                    if (e.target.tagName == 'A') {
                        var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
                        var $this = this;
                        var grid = $this.getFdmanagementoutwardgrid();
                        if (columnName == 'isItemInsured') {
                            var formWindow = $this.getFditeminsurancedetailswin();
                            if (!formWindow) {
                                Ext.widget('fditeminsurancedetailswin');
                                formWindow = $this.getFditeminsurancedetailswin();
                            }

                            var record = grid.getSelectionModel().getSelection()[0];
                            var outwardNo = record.get("outwardNo");
                            var deliverTo = record.get("deliverTo");
                            var noOfPackets = record.get("noOfPackets");
                            var sentDate = record.get("sentDate");
                            var insuredBy = record.get("insuredBy");
                            var policyNo = record.get("policyNo");
                            var insuranceAmount = record.get("insuranceAmount");

                            var form = formWindow.down('#fdItemInsuranceDetailsItemId');
                            var outwardNoItemId = form.down('#outwardNoItemId');
                            var deliverToItemId = form.down('#deliverToItemId');
                            var noOfPiecesItemId = form.down('#noOfPiecesItemId');
                            var sentDateItemId = form.down('#sentDateItemId');
                            var insuredByIdItemId = form.down('#insuredByIdItemId');
                            var policyNoItemId = form.down('#policyNoItemId');
                            var insuranceAmountItemId = form.down('#insuranceAmountItemId');

                            outwardNoItemId.setValue(outwardNo);
                            deliverToItemId.setValue(deliverTo);
                            noOfPiecesItemId.setValue(noOfPackets);
                            sentDateItemId.setValue(dateRender(sentDate));
                            if (!isNullOrEmpty(insuredBy) && !isNullOrEmpty(insuredBy.value)) {
                                insuredByIdItemId.setValue(insuredBy.value);
                            }
                            policyNoItemId.setValue(policyNo);
                            insuranceAmountItemId.setValue(insuranceAmount);

                            formWindow.show();
                        } else if (columnName == 'documents') {
                            var formWindow = $this.getFdoutwarditemdocumentwin();
                            if (!formWindow) {
                                Ext.widget('fdoutwarditemdocumentwin');
                                formWindow = $this.getFdoutwarditemdocumentwin();
                            }
                            formWindow.show();
                            var documentGrid = $this.getFdoutwarditementrydocumentgrid();
                            documentGrid.getStore().getProxy().extraParams = {
                                fdManagementOutwardItemId: record.data.id
                            };
                            documentGrid.down('#btnDelete').setVisible(false);
                            documentGrid.getStore().load();
                        } else if (columnName == 'fdOutwardItemDetails') {
                            var formWindow = $this.getFdoutwarditemdetailswin();
                            if (!formWindow) {
                                Ext.widget('fdoutwarditemdetailswin');
                                formWindow = $this.getFdoutwarditemdetailswin();
                            }
                            formWindow.show();
                            var documentGrid = $this.getFdoutwarditemdetailsgrid();
                            documentGrid.getStore().getProxy().extraParams = {
                                fdManagementOutwardItemId: record.data.id
                            };
                            documentGrid.down('#btnDelete').setVisible(false);
                            documentGrid.getStore().load();
                        } else if (columnName == 'packetStatus') {
                            var formWindow = $this.getFdmoutwarditemupdatestatuswin();
                            if (!formWindow) {
                                Ext.widget('fdmoutwarditemupdatestatuswin');
                                formWindow = $this.getFdmoutwarditemupdatestatuswin();
                            }
                            var record = grid.getSelectionModel().getSelection()[0];
                            var outwardNo = record.get("outwardNo");
                            var sentBy = record.get("sentBy");
                            var itemCategory = record.get("itemCategory");
                            var sentDate = record.get("sentDate");

                            var packetStatus = record.get("packetStatus");
                            var deliveredDate = record.get("deliveredDate");
                            var receivedBy = record.get("receivedBy");
                            var pod = record.get("pod");
                            var returnedDate = record.get("returnedDate");
                            var returnReason = record.get("returnReason");

                            var form = formWindow.down('#fdmOutwardItemUpdateStatusFormItemId');
                            var outwardNoItemId = form.down('#outwardNoItemId');
                            var outwardSenderIdItemId = form.down('#outwardSenderIdItemId');
                            var itemCategoryItemId = form.down('#itemCategoryItemId');
                            var sentDateItemId = form.down('#sentDateItemId');

                            outwardNoItemId.setValue(outwardNo);
                            outwardSenderIdItemId.setValue(sentBy.value);
                            if (!isNullOrEmpty(itemCategory) && !isNullOrEmpty(itemCategory.value)) {
                                itemCategoryItemId.setValue(itemCategory.value);
                            }
                            sentDateItemId.setValue(sentDate);

                            var outwordItemStatusItemId = form.down('#outwordItemStatusItemId');
                            var outwardDeliveryDateItemId = form.down('#outwardDeliveryDateItemId');
                            var outwardeReturnDateItemId = form.down('#outwardeReturnDateItemId');
                            var outwardReceivedByItemId = form.down('#outwardReceivedByItemId');
                            var outwardPODNoItemId = form.down('#outwardPODNoItemId');
                            var outwardReturnReasonItemId = form.down('#outwardReturnReasonItemId');

                            outwordItemStatusItemId.setValue(packetStatus);
                            if (packetStatus == 'Delivered') {
                                formWindow.setTitle(getServiceRequestTranslation('FD_DELIVERED_STATUS'));
                                outwardDeliveryDateItemId.setVisible(true);
                                outwardeReturnDateItemId.setVisible(false);
                                outwardReceivedByItemId.setVisible(true);
                                outwardPODNoItemId.setVisible(true);
                                outwardReturnReasonItemId.setVisible(false);

                                outwardDeliveryDateItemId.setValue(deliveredDate);
                                outwardReceivedByItemId.setValue(receivedBy);
                                outwardPODNoItemId.setValue(pod);
                            } else if (packetStatus == 'Returned') {
                                formWindow.setTitle(getServiceRequestTranslation('FD_RETURNED_STATUS'));
                                outwardDeliveryDateItemId.setVisible(false);
                                outwardeReturnDateItemId.setVisible(true);
                                outwardReceivedByItemId.setVisible(false);
                                outwardPODNoItemId.setVisible(false);
                                outwardReturnReasonItemId.setVisible(true);

                                outwardeReturnDateItemId.setValue(returnedDate);
                                outwardReturnReasonItemId.setValue(returnReason);
                            }

                            outwordItemStatusItemId.setReadOnly(true);
                            outwardDeliveryDateItemId.setReadOnly(true);
                            outwardeReturnDateItemId.setReadOnly(true);
                            outwardReceivedByItemId.setReadOnly(true);
                            outwardPODNoItemId.setReadOnly(true);
                            outwardReturnReasonItemId.setReadOnly(true);

                            var grid = $this.getFdoutwarditemupdatestatusdocumentgrid();
                            grid.setVisible(false);
                            var saveFdmoutwarditemupdatestatuswinItemId = form.down('#saveFdmoutwarditemupdatestatuswinItemId');
                            var fdmoutwarditemupdatestatuswinUploadId = form.down('#fdmoutwarditemupdatestatuswinUploadId');
                            saveFdmoutwarditemupdatestatuswinItemId.setVisible(false);
                            fdmoutwarditemupdatestatuswinUploadId.setVisible(false);
                            formWindow.show();
                        }
                    }
                }
            },
            'fdmanagementoutwardgrid splitbutton[itemId=spBtnMoreActions] #btnUpdateStatusItemId': {
                click: function() {
                    var $this = this;
                    var grid = $this.getFdmanagementoutwardgrid();
                    if (grid.getSelectionModel().getCount() > 0) {
                        var formWindow = $this.getFdmoutwarditemupdatestatuswin();
                        if (!formWindow) {
                            Ext.widget('fdmoutwarditemupdatestatuswin');
                            formWindow = $this.getFdmoutwarditemupdatestatuswin();
                        }
                        var record = grid.getSelectionModel().getSelection()[0];
                        var outwardNo = record.get("outwardNo");
                        var sentBy = record.get("sentBy");
                        var itemCategory = record.get("itemCategory");
                        var sentDate = record.get("sentDate");

                        var packetStatus = record.get("packetStatus");
                        var deliveredDate = record.get("deliveredDate");
                        var receivedBy = record.get("receivedBy");
                        var pod = record.get("pod");
                        var returnedDate = record.get("returnedDate");
                        var returnReason = record.get("returnReason");

                        var form = formWindow.down('#fdmOutwardItemUpdateStatusFormItemId');
                        var outwardNoItemId = form.down('#outwardNoItemId');
                        var outwardSenderIdItemId = form.down('#outwardSenderIdItemId');
                        var itemCategoryItemId = form.down('#itemCategoryItemId');
                        var sentDateItemId = form.down('#sentDateItemId');

                        outwardNoItemId.setValue(outwardNo);
                        outwardSenderIdItemId.setValue(sentBy.value);
                        if (!isNullOrEmpty(itemCategory) && !isNullOrEmpty(itemCategory.value)) {
                            itemCategoryItemId.setValue(itemCategory.value);
                        }
                        sentDateItemId.setValue(dateRender(sentDate));

                        var outwordItemStatusItemId = form.down('#outwordItemStatusItemId');
                        var outwardDeliveryDateItemId = form.down('#outwardDeliveryDateItemId');
                        var outwardeReturnDateItemId = form.down('#outwardeReturnDateItemId');
                        var outwardReceivedByItemId = form.down('#outwardReceivedByItemId');
                        var outwardPODNoItemId = form.down('#outwardPODNoItemId');
                        var outwardReturnReasonItemId = form.down('#outwardReturnReasonItemId');

                        formWindow.show();
                        if (packetStatus == 'Delivered') {
                            outwordItemStatusItemId.setValue(packetStatus);
                            outwardDeliveryDateItemId.setVisible(true);
                            outwardeReturnDateItemId.setVisible(false);
                            outwardReceivedByItemId.setVisible(true);
                            outwardPODNoItemId.setVisible(true);
                            outwardReturnReasonItemId.setVisible(false);

                            outwardDeliveryDateItemId.setValue(dateRender(deliveredDate));
                            outwardReceivedByItemId.setValue(receivedBy);
                            outwardPODNoItemId.setValue(pod);
                        } else if (packetStatus == 'Returned') {
                            outwordItemStatusItemId.setValue(packetStatus);
                            outwardDeliveryDateItemId.setVisible(false);
                            outwardeReturnDateItemId.setVisible(true);
                            outwardReceivedByItemId.setVisible(false);
                            outwardPODNoItemId.setVisible(false);
                            outwardReturnReasonItemId.setVisible(true);

                            outwardeReturnDateItemId.setValue(dateRender(returnedDate));
                            outwardReturnReasonItemId.setValue(returnReason);
                        }

                        var grid = $this.getFdoutwarditemupdatestatusdocumentgrid();
                        var docStore = grid.getStore();
                        docStore.removeAll();

                        /*var grid = $this.getFdoutwarditemupdatestatusdocumentgrid();
    	    			 var docStore = grid.getStore();
    	        		 docStore.getProxy().extraParams={
    	        			 fdManagementOutwardItemId: record.get('id')
    	        		 };
    	        		 docStore.load();*/

                    } else {
                        showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
                    }
                }
            },
            'fdmoutwarditemupdatestatuswin form[itemId=fdmOutwardItemUpdateStatusFormItemId] combo#outwordItemStatusItemId': {
                select: function(obj, record) {
                    var form = obj.up('#fdmOutwardItemUpdateStatusFormItemId');

                    var outwardDeliveryDateItemId = form.down('#outwardDeliveryDateItemId');
                    var outwardeReturnDateItemId = form.down('#outwardeReturnDateItemId');

                    var outwardReceivedByItemId = form.down('#outwardReceivedByItemId');
                    var outwardPODNoItemId = form.down('#outwardPODNoItemId');

                    var outwardReturnReasonItemId = form.down('#outwardReturnReasonItemId');

                    if (record[0].data.value == 'Delivered') {
                        outwardDeliveryDateItemId.setVisible(true);
                        outwardeReturnDateItemId.setVisible(false);
                        outwardReceivedByItemId.setVisible(true);
                        outwardPODNoItemId.setVisible(true);
                        outwardReturnReasonItemId.setVisible(false);
                        outwardDeliveryDateItemId.setValue(new Date());
                    } else {
                        outwardDeliveryDateItemId.setVisible(false);
                        outwardeReturnDateItemId.setVisible(true);
                        outwardReceivedByItemId.setVisible(false);
                        outwardPODNoItemId.setVisible(false);
                        outwardReturnReasonItemId.setVisible(true);
                        outwardeReturnDateItemId.setValue(new Date());
                    }
                    outwardReceivedByItemId.reset();
                    outwardPODNoItemId.reset();
                    outwardReturnReasonItemId.reset();
                }
            },
            'fdmoutwarditemupdatestatuswin button[itemId=saveFdmoutwarditemupdatestatuswinItemId]': {
                click: function() {
                    var $this = this;
                    var formWindow = $this.getFdmoutwarditemupdatestatuswin();
                    var grid = $this.getFdmanagementoutwardgrid();
                    var record = grid.getSelectionModel().getSelection()[0];
                    var id = record.get("id");

                    var form = formWindow.down('#fdmOutwardItemUpdateStatusFormItemId');
                    var formValues = form.getValues();

                    var outwordItemStatus = formValues.outwordItemStatus;
                    var outwardDeliveryDate = formValues.outwardDeliveryDate;
                    var outwardeReturnDate = formValues.outwardeReturnDate;
                    var outwardReceivedBy = formValues.outwardReceivedBy;
                    var outwardPODNo = formValues.outwardPODNo;
                    var outwardReturnReason = formValues.outwardReturnReason;

                    var documentGrid = $this.getFdoutwarditemupdatestatusdocumentgrid();
                    var docStore = documentGrid.getStore();
                    var docArray = [];
                    try {
                        if (!isNullOrEmpty(documentGrid.getCode()) && documentGrid.getCode() != undefined) {
                            docStore.add(documentGrid.getCode());
                            if (docStore.data.items != null && docStore.data.items.length > 0) {
                                Ext.each(docStore.data.items, function(val) {
                                    if (val.data.isNewRecord != undefined && val.data.isNewRecord) {
                                        var newData = {
                                            "name": val.data.documentName,
                                            "path": val.data.path,
                                            "type": "DOCUMENT",
                                            "createdBy": $this.getIdValueJson(val.data.createdBy.id, val.data.createdBy.value)
                                        };
                                        docArray.push(newData);
                                    }
                                });
                            }
                            var arr = [];
                            docStore.add(arr);
                        }
                    } catch (err) {

                    }

                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.FD_MANAGEMENT_OUTWARD_ITEMS_UPDATE_STATUS,
                        jsonData: {
                            id: id,
                            packetStatus: outwordItemStatus,
                            deliveredDate: outwardDeliveryDate,
                            returnedDate: outwardeReturnDate,
                            receivedBy: outwardReceivedBy,
                            pod: outwardPODNo,
                            returnReason: outwardReturnReason,
                            documents: docArray
                        },
                        method: 'POST',
                        success: function(frm, action) {
                            Ext.getBody().unmask();
                            var grid = $this.getFdmanagementoutwardgrid();
                            $this.resetPageSetting(grid.getStore());
                            grid.getStore().reload();
                            grid.getSelectionModel().deselectAll();
                            showSuccessMessage(getCommonTranslation('FD_MANAGEMENT_ITEMS_STATUS_UPDATED_SUCCESSFULLY'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
                            formWindow.close();
                        }
                    });
                }
            },
            'fdmefilter radiogroup[itemId=itemEntryTypeItemId]': {
                change: function(cb, nv, ov) {
                    $this = this;
                    var fdmefilter = this.getFdmefilter();

                    var inwardNoItemId = fdmefilter.down('#inwardNoItemId');
                    var outwardNoItemId = fdmefilter.down('#outwardNoItemId');

                    var internalPacketNoItemId = fdmefilter.down('#internalPacketNoItemId');
                    var billNoItemId = fdmefilter.down('#billNoItemId');

                    var docketNoItemId = fdmefilter.down('#docketNoItemId');
                    var docketNoOutwardItemId = fdmefilter.down('#docketNoOutwardItemId');

                    var inwardEntryByItemId = fdmefilter.down('#inwardEntryByItemId');
                    var outwardEntryByItemId = fdmefilter.down('#outwardEntryByItemId');

                    var inwardGrid = $this.getFdmegrid();
                    var outwardGrid = $this.getFdmeoutwardgrid();
                    if (nv.itemEntryType == 'Received') {
                        inwardNoItemId.setVisible(true);
                        outwardNoItemId.setVisible(false);

                        internalPacketNoItemId.setVisible(false);
                        billNoItemId.setVisible(true);

                        inwardEntryByItemId.setVisible(true);
                        outwardEntryByItemId.setVisible(false);

                        docketNoItemId.setVisible(true);
                        docketNoOutwardItemId.setVisible(false);

                        var store = inwardGrid.getStore();
                        inwardGrid.setVisible(true);
                        outwardGrid.setVisible(false);
                        store.removeAll();
                        if (inwardGrid.down('#dockedItemsItemId') != null)
                            inwardGrid.down('#dockedItemsItemId').setVisible(false);
                    } else {
                        inwardNoItemId.setVisible(false);
                        outwardNoItemId.setVisible(true);

                        internalPacketNoItemId.setVisible(true);
                        billNoItemId.setVisible(false);

                        inwardEntryByItemId.setVisible(false);
                        outwardEntryByItemId.setVisible(true);

                        docketNoItemId.setVisible(false);
                        docketNoOutwardItemId.setVisible(true);

                        var store = outwardGrid.getStore();
                        inwardGrid.setVisible(false);
                        outwardGrid.setVisible(true);
                        store.removeAll();
                        if (outwardGrid.down('#dockedItemsItemId') != null)
                            outwardGrid.down('#dockedItemsItemId').setVisible(false);
                    }
                    this.resetFDmefilter();
                }
            },
            'fdmeoutwardgrid': {
                beforerender: function() {
                    this.getStore('fdmanagement.FDManagementOutwardStore').removeAll();
                },
                render: function(grid) {
                    if(portalId == 2) {
                    	this.doAccessControlValidation(grid, this.getFRONT_DESK_MANAGEMENT_EMP_PORTAL_PERMISSIONS());
                	} else if(portalId == 3) {
                		this.doAccessControlValidation(grid, this.getFRONT_DESK_MANAGEMENT_STUDENT_PORTAL_PERMISSIONS());
                	}
                },
                cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
                    if (e.target.tagName == 'A') {
                        var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
                        var $this = this;
                        var grid = $this.getFdmeoutwardgrid();
                        if (columnName == 'isItemInsured') {
                            var formWindow = $this.getFditeminsurancedetailswin();
                            if (!formWindow) {
                                Ext.widget('fditeminsurancedetailswin');
                                formWindow = $this.getFditeminsurancedetailswin();
                            }

                            var record = grid.getSelectionModel().getSelection()[0];
                            var outwardNo = record.get("outwardNo");
                            var deliverTo = record.get("deliverTo");
                            var noOfPackets = record.get("noOfPackets");
                            var sentDate = record.get("sentDate");
                            var insuredBy = record.get("insuredBy");
                            var policyNo = record.get("policyNo");
                            var insuranceAmount = record.get("insuranceAmount");

                            var form = formWindow.down('#fdItemInsuranceDetailsItemId');
                            var outwardNoItemId = form.down('#outwardNoItemId');
                            var deliverToItemId = form.down('#deliverToItemId');
                            var noOfPiecesItemId = form.down('#noOfPiecesItemId');
                            var sentDateItemId = form.down('#sentDateItemId');
                            var insuredByIdItemId = form.down('#insuredByIdItemId');
                            var policyNoItemId = form.down('#policyNoItemId');
                            var insuranceAmountItemId = form.down('#insuranceAmountItemId');

                            outwardNoItemId.setValue(outwardNo);
                            deliverToItemId.setValue(deliverTo);
                            noOfPiecesItemId.setValue(noOfPackets);
                            sentDateItemId.setValue(sentDate);
                            if (!isNullOrEmpty(insuredBy) && !isNullOrEmpty(insuredBy.value)) {
                                insuredByIdItemId.setValue(insuredBy.value);
                            }
                            policyNoItemId.setValue(policyNo);
                            insuranceAmountItemId.setValue(insuranceAmount);

                            formWindow.show();
                        } else if (columnName == 'documents') {
                            var formWindow = $this.getFdoutwarditemdocumentwin();
                            if (!formWindow) {
                                Ext.widget('fdoutwarditemdocumentwin');
                                formWindow = $this.getFdoutwarditemdocumentwin();
                            }
                            formWindow.show();
                            var documentGrid = $this.getFdoutwarditementrydocumentgrid();
                            documentGrid.getStore().getProxy().extraParams = {
                                fdManagementOutwardItemId: record.data.id
                            };
                            documentGrid.down('#btnDelete').setVisible(false);
                            documentGrid.getStore().load();
                        } else if (columnName == 'fdOutwardItemDetails') {
                            var formWindow = $this.getFdoutwarditemdetailswin();
                            if (!formWindow) {
                                Ext.widget('fdoutwarditemdetailswin');
                                formWindow = $this.getFdoutwarditemdetailswin();
                            }
                            formWindow.show();
                            var documentGrid = $this.getFdoutwarditemdetailsgrid();
                            documentGrid.getStore().getProxy().extraParams = {
                                fdManagementOutwardItemId: record.data.id
                            };
                            documentGrid.down('#btnDelete').setVisible(false);
                            documentGrid.getStore().load();
                        }
                    }
                }
            },
            'fdmoutwarditemupdatestatuswin button#fdmoutwarditemupdatestatuswinUploadId': {
                click: function() {
                    this.getDocumentController().showDocumentFormWindow('fdmOutwardItemUpdateStatusFormItemId', 'DOCUMENT');
                }
            },
            'documentformwindow[itemId=fdmOutwardItemUpdateStatusFormItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId': {
                click: function() {
                    var $this = this;
                    var isTransient = true;
                    var module = 'toolnservice';
                    var entityId;
                    var entityType = 'itemdocument';
                    var documentGrid = $this.getFdoutwarditemupdatestatusdocumentgrid();

                    $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient) {
                        var documentModel = new Academia.model.fdmanagement.FDManagementDocumentModel();
                        documentModel.set("documentName", response.name);
                        documentModel.set("path", response.path);
                        documentModel.set("type", response.type);
                        documentModel.set("documentName", response.name);
                        documentModel.set("isNewRecord", true);
                        documentModel.set("createdBy", $this.getIdValueJson(response.createdBy.id, response.createdBy.value));

                        var store = documentGrid.getStore();
                        store.add(documentModel);
                        if (documentGrid.isHidden() && store.data.items.length > 0) {
                            documentGrid.setVisible(true);
                        }
                        Ext.apply(documentGrid, {
                            code: null,
                            setCode: function(code) {
                                documentGrid.code = code;
                            },
                            getCode: function() {
                                return documentGrid.code;
                            }
                        });
                        documentGrid.setCode(documentModel);
                        $this.getDocumentController().closeDocumentFormWindow();
                    }, isTransient);
                }
            },
            'fdmeupdatestatuswin button[itemId=cancelFdmeupdatestatuswinItemId]': {
                click: function() {
                    var $this = this;
                    var formWindow = $this.getFdmeupdatestatuswin();
                    formWindow.close();
                }
            },
            'fdmefilter button[itemId=resetBtnFdmefilterItemId]': {
                click: function() {
                    this.resetFDmefilter();
                }
            },
            'fdmefilter combo#inwardNoItemId': {
                render: function(obj) {
                    var store = obj.getStore();
                    var userId = this.getCurrentlyLoggedInUser().id;
                    store.getProxy().extraParams = {
                        receiverId: userId,
                    };
                    store.load();
                }
            },
            'fdmefilter combo#outwardNoItemId': {
                render: function(obj) {
                    var store = obj.getStore();
                    var userId = this.getCurrentlyLoggedInUser().id;
                    store.getProxy().extraParams = {
                        senderId: userId,
                    };
                    store.load();
                }
            },
            'fdmefilter combo#docketNoItemId': {
                render: function(obj) {
                    var store = obj.getStore();
                    var userId = this.getCurrentlyLoggedInUser().id;
                    store.getProxy().extraParams = {
                        receiverId: userId,
                    };
                    store.load();
                }
            },
            'fdmefilter combo#docketNoOutwardItemId': {
                render: function(obj) {
                    var store = obj.getStore();
                    var userId = this.getCurrentlyLoggedInUser().id;
                    store.getProxy().extraParams = {
                        senderId: userId,
                    };
                    store.load();
                }
            },
            'fdmefilter combo#billNoItemId': {
                render: function(obj) {
                    var store = obj.getStore();
                    var userId = this.getCurrentlyLoggedInUser().id;
                    store.getProxy().extraParams = {
                        receiverId: userId,
                    };
                    store.load();
                }
            },
            'fdmefilter combo#internalPacketNoItemId': {
                render: function(obj) {
                    var store = obj.getStore();
                    var userId = this.getCurrentlyLoggedInUser().id;
                    store.getProxy().extraParams = {
                        senderId: userId,
                    };
                    store.load();
                }
            },
            'fdadditementryform textfield#inwardNoItemId': {
                blur: function(obj, record) {
                    var data = obj.getValue();
                    if (data) {
                        var form = this.getFdadditementryform();
                        var grid = this.getFdmanagementgrid();
                        var submitUrl = SERVERURL.FD_MANAGEMENT_ITEMS_UNIQUE_INWARD_NO + '?inwardNo=' + data;
                        Ext.Ajax.request({
                            type: 'rest',
                            url: submitUrl,
                            method: 'GET',
                            success: function(response, action) {
                                var responseData = Ext.decode(response.responseText);
                                if (responseData.code == 'EXIST') {
                                    if (grid.getSelectionModel().getCount() > 0) {
                                        if (grid.getSelectionModel().getSelection()[0].data.inwardNo != data) {
                                            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('RECORD_IS_ALREADY_EXIST'));
                                            form.down("#inwardNoItemId").setValue(grid.getSelectionModel().getSelection()[0].data.inwardNo);
                                        }
                                    } else {
                                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('RECORD_IS_ALREADY_EXIST'));
                                        form.down("#inwardNoItemId").reset();
                                    }
                                }
                            }
                        });
                    }
                }
            },
            'fdadditementryform textfield#outwardNoItemId': {
                blur: function(obj, record) {
                    var data = obj.getValue();
                    if (data) {
                        var form = this.getFdadditementryform();
                        var grid = this.getFdmanagementoutwardgrid();
                        var submitUrl = SERVERURL.FD_MANAGEMENT_ITEMS_UNIQUE_OUTWARD_NO + '?outwardNo=' + data;
                        Ext.Ajax.request({
                            type: 'rest',
                            url: submitUrl,
                            method: 'GET',
                            success: function(response, action) {
                                var responseData = Ext.decode(response.responseText);
                                if (responseData.code == 'EXIST') {
                                    if (grid.getSelectionModel().getCount() > 0) {
                                        if (grid.getSelectionModel().getSelection()[0].data.outwardNo != data) {
                                            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('RECORD_IS_ALREADY_EXIST'));
                                            form.down("#outwardNoItemId").setValue(grid.getSelectionModel().getSelection()[0].data.outwardNo);
                                        }
                                    } else {
                                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('RECORD_IS_ALREADY_EXIST'));
                                        form.down("#outwardNoItemId").reset();
                                    }
                                }
                            }
                        });
                    }
                }
            },
            'fdmanagementfilter combo#serviceProviderItemId': {
                select: function(obj, record) {
                    $this = this;
                    var form = $this.getFdmanagementfilter();

                    var entryType = form.down("#entryTypeItemId").getValue();
                    if (entryType == 'Inward') {
                        var docketNoItemId = form.down('#docketNoItemId');
                        docketNoItemId.reset();
                        var store = docketNoItemId.getStore();
                        store.getProxy().extraParams = {
                            serviceProviderId: obj.getValue(),
                        };
                        store.load();
                    } else {
                        var internalPacketNoItemId = form.down('#internalPacketNoItemId');
                        internalPacketNoItemId.reset();
                        var internalPacketNoStore = internalPacketNoItemId.getStore();
                        internalPacketNoStore.getProxy().extraParams = {
                            serviceProviderId: obj.getValue(),
                        };
                        internalPacketNoStore.load();

                        var docketNoOutwardItemId = form.down('#docketNoOutwardItemId');
                        docketNoOutwardItemId.reset();
                        var docketNoStore = docketNoOutwardItemId.getStore();
                        docketNoStore.getProxy().extraParams = {
                            serviceProviderId: obj.getValue(),
                        };
                        docketNoStore.load();
                    }
                }
            },
            'fdmefilter combo#serviceProviderItemId': {
                select: function(obj, record) {
                    $this = this;
                    var form = $this.getFdmefilter();
                    var userId = this.getCurrentlyLoggedInUser().id;
                    var entryType = form.down("#itemEntryTypeItemId").getValue();
                    if (entryType.itemEntryType == 'Received') {
                        var docketNoItemId = form.down('#docketNoItemId');
                        docketNoItemId.reset();
                        var store = docketNoItemId.getStore();
                        store.getProxy().extraParams = {
                            serviceProviderId: obj.getValue(),
                            senderId: userId,
                        };
                        store.load();
                    } else {
                        var internalPacketNoItemId = form.down('#internalPacketNoItemId');
                        internalPacketNoItemId.reset();
                        var internalPacketNoStore = internalPacketNoItemId.getStore();
                        internalPacketNoStore.getProxy().extraParams = {
                            serviceProviderId: obj.getValue(),
                            receiverId: userId,
                        };
                        internalPacketNoStore.load();

                        var docketNoOutwardItemId = form.down('#docketNoOutwardItemId');
                        docketNoOutwardItemId.reset();
                        var docketNoStore = docketNoOutwardItemId.getStore();
                        docketNoStore.getProxy().extraParams = {
                            serviceProviderId: obj.getValue(),
                            receiverId: userId,
                        };
                        docketNoStore.load();
                    }
                }
            },	    	                		 
   		 'fdadditementryform customcombobox[itemId=senderMobileCountryCodeItemId]': {
  			select: function(rowModel, record){
  				var this$ = this;
              //	var personProfile = this$.getContentPanelActiveTab();
              	var form = this$.getFdadditementryform();
              	var countryCodeField = form.down("#senderMobileCountryCodeItemId");
               	var mobileField = form.down("#senderContactNoItemId");
               	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
  			}
  		},
  		'fdadditementryform numberfield[itemId=senderContactNoItemId]': {
  			change: function(record){
  				var this$ = this;
                var form = this$.getFdadditementryform();
                 var mobileField = form.down("#senderContactNoItemId");
              	mobileField.isValid();
      			form.getForm().checkValidity();
              }
  		}, 
  		'fdadditementryform customcombobox[itemId=receiverMobileCountryCodeItemId]': {
  			select: function(rowModel, record){
  				var this$ = this;
              //	var personProfile = this$.getContentPanelActiveTab();
              	var form = this$.getFdadditementryform();
              	var countryCodeField = form.down("#receiverMobileCountryCodeItemId");
               	var mobileField = form.down("#receiverContactNoItemId");
               	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
  			}
  		},
  		'fdadditementryform numberfield[itemId=receiverContactNoItemId]': {
  			change: function(record){
  				var this$ = this;
                var form = this$.getFdadditementryform();
                 var mobileField = form.down("#receiverContactNoItemId");
              	mobileField.isValid();
      			form.getForm().checkValidity();
              }
  		},
  	  'fdmanagementtabstructure': {
			 afterrender : function(structure){
				 var $this = this;
				 structure.body.on('scroll', function(e, target) {
					 var formValue = $this.getFdmanagementfilter();
					 
					 if(formValue.getValues().entryType == "Inward"){
						 var pcstructure = structure.down("fdmanagementgrid");	 
					 }else if(formValue.getValues().entryType == "Outward"){
						 var pcstructure = structure.down("fdmanagementoutwardgrid")
					 }
	   				  var academyLocationId = $this.getCurrentAcademyLocation();
	   				  var grid = null;
	   				  
	   				  if(!pcstructure.isHidden()){
	   					  grid = pcstructure;
	   				  }
	   				  if(grid != null){
	   				  //$this.getMultipleGridHeaderFreeze(grid,structure,true);
	   				  }
					 });
			 }
		},
		'downloadfdinwardoutwarditem button[itemId=fdDownoladBtnId]':{
			click:function(obj){
				var csvForm = Ext.create('Ext.form.Panel'); 
				var form = this.getDownloadfdinwardoutwarditem();
				var academyLocationId  = this.getCurrentAcademyLocation();
				var fdDownloadTemplateFor  = form.getForm().findField('fdDownloadTemplateFor').getValue();
				var submitUrl;
				var alids=[];
				var academyLocationIds = null;
				if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
					for (var i in academyLocationId) {
						if (Ext.isObject(academyLocationId[0])) {
							alids.push(academyLocationId[i].get("id"));
						} else {
							alids.push(academyLocationId[i]);
						}
					}
					academyLocationIds = alids.join();
				}
				else if(!isNullOrEmpty(academyLocationId)){
					academyLocationIds = academyLocationId;
				}
				if(fdDownloadTemplateFor == "Inward" || fdDownloadTemplateFor == "Bulk Inward Item") {
					submitUrl = SERVERURL.DOWNLOAD_TEMPLATE_FOR_INWARD_ITEM_ENTRY;
				}else{
					submitUrl = SERVERURL.DOWNLOAD_TEMPLATE_FOR_OUTWARD_ITEM_ENTRY;
				}
				csvForm.getForm().submit({
					target: '_blank',
					method:'POST',
					params :{
						access_token : Ext.Ajax.defaultHeaders.access_token,
						academyLocationIds :academyLocationIds,
					},
					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
					url: submitUrl,
					standardSubmit :true
				});
			}  
		},
			 'fdmanagementloaderstructure radiogroup[itemId=importDownloadgroupIds]':{
					change  : function(obj,newValue,oldValue){
						var form = obj.up('fdmanagementloaderstructure');	 
						var value = obj.getValue();
						var downForm = form.down('downloadfdinwardoutwarditem');
						var importForm = form.down('importfdinwardoutwarduploadform');
						var importList = form.down('importfdinwardoutwarditemgrid');

						downForm.setVisible(false);
						importForm.setVisible(false);
						importList.setVisible(false);

						if(value.downloadUploadTemplate=='forDownloadTemplate'){
							downForm.setVisible(true);
							downForm.getForm().reset();
						}else if(value.downloadUploadTemplate=='forUploadTemplate'){
							var uploadoptionradiogroupform  = this.getUploadoptionradiogroup();
							uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
								isUploadAll: false
							});
							importForm.setVisible(true);
							importList.setVisible(true);
						}
					}
				},
				'importfdinwardoutwarduploadform button[itemId=SubmitBtn]':{
					click: function(obj){
						var temForm = obj.up('importfdinwardoutwarduploadform');
						var templateFor = temForm.down('#fdUploadTemplateFor').getRawValue();
				    	var $this=this;
				    	var submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	    	            $this.getHashOfFile(temForm);
			            setTimeout(function() {
					    	temForm.getForm().submit({
					    		method : 'POST',
					    		url : submitUrl,
					    		success : function(form, action){
						        	showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
						        	temForm.getForm().isValid();
					    		},
					    		failure: function(form, action) {
	   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
					    	    }
					    	});
			        	},1000);
				    	Ext.defer(function() {
				    		$this.loadImportFDInwardOutwardGrid(templateFor);
				    	}, 2000, this);
					}
				},
				 'importfdinwardoutwarduploadform radiogroup[itemId=FDInwardOutwardRadioGroupItemId]':{
			        	change: function( radioGroup, newValue, oldValue, eOpts){
			        		var grid =this.getImportfdinwardoutwarditemgrid();
			        		var isUploadAll = newValue.isUploadAll;
			        		this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'Bulk Inward Item');
			        	}   
			     },
			     'importfdinwardoutwarduploadform button[itemId=resetBtn]':{
			        	click:function(obj){
			        		var $this=this;
			        		var form = $this.getImportfdinwardoutwarduploadform().getForm();
			        		form.reset();
			        		form.findField('file').reset();
			        		var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
			        		uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
			        			isUploadAll: false
			        		});
			        		form.isValid();
			        	}
			        },
			        'importfdinwardoutwarditemgrid button[itemId=btnForce]':{
						 click : function(obj) {
							 var grid = this.getImportfdinwardoutwarditemgrid();
				            	if (grid.getSelectionModel().getCount() > 0) {
				            		if(grid.getSelectionModel().getCount() > 1){
					        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
					        		}else{
			 	                	var id = grid.getSelectionModel().selectionStart.data.id;
			 	                	var urlAppend="?jobName="+id;
			 	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
			 	    	        	Ext.Ajax.request({
			 	    	        		url: submitURL,
			 	    	        		method: 'GET',
			 	    	        		success: function(response) {
			 	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
			 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
			 	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
			 	    	        				//console.log("Manual trigger hit");
			 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
			 	    	        			}else if(response.responseText==="SUCCESS"){
			 	    	        				//console.log("Manual trigger hit");
			     	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
			 	    	        			}
			 	    	        		}
			 	    	        	});
					        		}
				            	} else {
				            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				            	}  
				            }
					 },
					 'importfdinwardoutwarditemgrid':{
							cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
								if (e.target.tagName == 'A') {
									var fileType=null;
									if(cellIndex==1){
										fileType='successFile';
									}else if(cellIndex==6){
										fileType='errorFile';
									}else if(cellIndex==7){
										fileType='logFile';
									}
									var documentId = record.get("id");
									if (!isNullOrEmpty(documentId)) {
										this.getDownloadFile(documentId,fileType);
									}
								}
							}
						},
						  'importfdinwardoutwarduploadform customcombobox[itemId=fdUploadTemplateFor]': {
				     			 select: function(obj, record) {
				     				 var $this = this;
				     				 var form = this.getImportfdinwardoutwarduploadform().getForm();
				     				 var templateFor = obj.getValue();
				     				 var moduleName = null;
				     				 var moduleNameUi = null;
				     				 switch (templateFor){
				     				 case 'Bulk Inward Item':
				     					 moduleName = 'Bulk Inward Item';
				     					 moduleNameUi = 'Bulk Inward Item';
				     					 break;
				     				 case 'Bulk Outward Item':
				     					 moduleName = 'Bulk Outward Item';
				     					 moduleNameUi = 'Bulk Outward Item';
				     					 break;
				     				 default : null;
				     				 }
				     				 var combo = form.findField('importUtilityMasterId');
				     				 combo.getStore().load({
				     					 callback: function(records, operation, success) {
				     						 for(var i in records){
				     							 if(records[i].data.value == moduleNameUi){
				     								 combo.setValue(records[i].data.id);
				     								 combo.setReadOnly(true);
				     							 }
				     						 }
				     					 }	   
				     				 });
				     				 var grid = $this.getImportfdinwardoutwarditemgrid();
				     				 var uploadform = $this.getUploadoptionradiogroup();
				     				 var isUploadAll = uploadform.items.items[0].getValue().isUploadAll;
				     				 $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,moduleName);
				     			 }
					        },
					    	'importfdinwardoutwarduploadform':{
								render: function(obj){
									var $this = this;
									var uploadForm = $this.getImportfdinwardoutwarduploadform();
									var templateName =uploadForm.getForm().findField('importUtilityMasterId');
									var grid = $this.getImportfdinwardoutwarditemgrid();
									var form = $this.getUploadoptionradiogroup();
									var isUploadAll = form.items.items[0].getValue().isUploadAll;
									$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Inward Item');
									templateName.getStore().load({
										callback:function(record){
											for(var i in record){
												if(record[i].data.value == 'Bulk Inward Item'){
													templateName.setValue(record[i].data.id);
													templateName.setReadOnly(true);
												}
											}
										}
									});
								}
							},
							 'downloadfdinwardoutwarditem button[itemId=resetBtn]':{
						        	click:function(obj){
						        		var $this=this;
						        		var form = $this.getDownloadfdinwardoutwarditem().getForm();
						        		form.reset();
						        		form.isValid();
						        	}
						        },
						        'fdmestructure':{
						        	afterrender:function(structure){
						        		var portalId = this.getCurrentLoggedPortalId();
						        		if(portalId==2){
						        		   structure.addCls('myCourierFPCls');
						        		}
						        	}
						        }
        });
    },
    /**
     * Open tab for add new Item Entry Form
     */
    openAddItemEntryTab: function(openView) {
        var me = this;
        var contentpanel = this.getContentpanel();
        var addItemEntry = Ext.widget('fdadditementryform');
        if (openView == 'ADD') {
            addItemEntry.setTitle(getServiceRequestTranslation('FD_ADD_ITEM_ENTRY'));
            var tabName = getServiceRequestTranslation('FD_ADD_ITEM_ENTRY');
        } else if (openView == 'EDIT') {
            addItemEntry.setTitle(getServiceRequestTranslation('FD_EDIT_ITEM_ENTRY'));
            var tabName = getServiceRequestTranslation('FD_EDIT_ITEM_ENTRY');
        } else if (openView == 'VIEW') {
            addItemEntry.setTitle(getServiceRequestTranslation('FD_VIEW_ITEM_ENTRY'));
            var tabName = getServiceRequestTranslation('FD_VIEW_ITEM_ENTRY');
        }
        /**
         * This is to remove tab from content panel and open same tab again
         */
        var getcontroller = this.getController('menu.CoreERPNavigationController');
        var getAddTab = getcontroller.getTab(getServiceRequestTranslation('FD_ADD_ITEM_ENTRY'));
        var getEditTab = getcontroller.getTab(getServiceRequestTranslation('FD_EDIT_ITEM_ENTRY'));
        var getViewTab = getcontroller.getTab(getServiceRequestTranslation('FD_VIEW_ITEM_ENTRY'));
        if (getAddTab != null) {
            contentPanel.remove(getAddTab, true);
        }
        if (getEditTab != null) {
            contentPanel.remove(getEditTab, true);
        }
        if (getViewTab != null) {
            contentPanel.remove(getViewTab, true);
        }
        openTab(contentpanel, tabName, addItemEntry, CONSTANTS.MENU_COLOR_NINE);
        var docStore = this.getFditementrydocumentgrid().getStore();
        docStore.removeAll();
        docStore.loadData([]);
    },
    /**
     * Add multiple Docket No filter in panel
     */
    addMultipleDocketNoTextField: function(obj, flag) {
        var $this = this;
        var form = $this.getFdadditementryform();
        var stopContiner = form.down('#docketNoContainerItemId');
        var noOfPiecesItemId = form.down('#noOfPiecesItemId');
        var panelItem = new Array();
        var fieldContainer = obj.up('fieldcontainer');
        var newcont = stopContiner.items.items.length;
        var insertPosition = newcont + 1;
        panelItem.push({
            xtype: 'fieldcontainer',
            layout: 'hbox',
            width: '100%',
            defaults: {
                width: 226
            },
            items: [{
                xtype: 'hidden',
                name: 'docketId'
            }, {
                xtype: 'textfield',
                name: 'internalPacketNo',
                hidden: true,
                maxLength: 30,
                itemId: 'internalPacketNoItemId1'
            }, {
                xtype: 'textfield',
                name: 'docketNo',
                maxLength: 30,
                itemId: 'docketNoItemId1'
            }, {
                xtype: 'button',
                itemId: 'delFilterBtn',
                cls: 'CustomBodyBtnReject',
                glyph: ICONGLYPH.DELETEGLYPH,
                tooltip: getCommonTranslation('DELETE'),
                listeners: {
                    click: function(obj) {
                        var container = obj.up('fieldcontainer');
                        var panelContiner = $this.getFdadditementryform().down('#docketNoContainerItemId');
                        panelContiner.remove(container);
                        noOfPiecesItemId.setValue((noOfPiecesItemId.getValue() - 1));
                    }
                }
            }]
        });
        if (flag) {
            noOfPiecesItemId.setValue((parseInt(noOfPiecesItemId.getValue()) + 1));
        }
        stopContiner.insert(insertPosition, panelItem);
        stopContiner.doLayout();
        var entryTypeItemId = form.down('#entryTypeItemId');
        for (var j = 0; j < stopContiner.items.length; j++) {
            var docketNoPanelContainer = stopContiner.items.items[j];
            if (entryTypeItemId.getValue() == 'Inward') {
                docketNoPanelContainer.items.items[1].setVisible(false);
            } else {
                docketNoPanelContainer.items.items[1].setVisible(true);
            }
        }
    },
    /************** Add Item Entry records*********************/
    saveFDAddItemEntry: function() {
        var $this = this;
        var fdAddItemEntry = $this.getFdadditementryform();
        var form = fdAddItemEntry.getForm();
        var formValues = form.getValues();
        var entryType = formValues.entryType;

        var docketNoContainer = fdAddItemEntry.down('#docketNoContainerItemId');
        var docketNoArray = new Array();
        if (entryType == 'Inward') {
            for (var j = 0; j < docketNoContainer.items.length; j++) {
                var docketNoPanelContainer = docketNoContainer.items.items[j];
                var docketId = null;
                if (!isNullOrEmpty(docketNoPanelContainer.items.items[0].getValue())) {
                    docketId = docketNoPanelContainer.items.items[0].getValue();
                }

                if (!isNullOrEmpty(docketNoPanelContainer.items.items[2].getValue())) {
                    docketNoArray.push({
                        "id": docketId,
                        "docketNo": docketNoPanelContainer.items.items[2].getValue()
                    });
                }
            }
        } else {
            for (var j = 0; j < docketNoContainer.items.length; j++) {
                var docketNoPanelContainer = docketNoContainer.items.items[j];
                var docketId = null;
                if (!isNullOrEmpty(docketNoPanelContainer.items.items[0].getValue())) {
                    docketId = docketNoPanelContainer.items.items[0].getValue();
                }

                if (!(isNullOrEmpty(docketNoPanelContainer.items.items[1].getValue()) &&
                        isNullOrEmpty(docketNoPanelContainer.items.items[2].getValue()))) {
                    docketNoArray.push({
                        "id": docketId,
                        "internalPacketNo": docketNoPanelContainer.items.items[1].getValue(),
                        "docketNo": docketNoPanelContainer.items.items[2].getValue()
                    });
                }
            }
        }
        var duplicateFlag = false;
        if (entryType == 'Inward') {
            for (var i = 0; i < docketNoArray.length - 1; i++) {
                for (var j = i + 1; j < docketNoArray.length; j++) {
                    if (docketNoArray[i].docketNo == docketNoArray[j].docketNo) {
                        duplicateFlag = true;
                        break;
                    }
                }
            }
            if (duplicateFlag) {
                showWarningMessage('Docket No.', 'Duplicate Docket No. in Item Entry');
            }
        } else {
            for (var i = 0; i < docketNoArray.length - 1; i++) {
                for (var j = i + 1; j < docketNoArray.length; j++) {
                    if (docketNoArray[i].internalPacketNo == docketNoArray[j].internalPacketNo) {
                        duplicateFlag = true;
                        break;
                    }
                }
            }
            if (duplicateFlag) {
                showWarningMessage('Internal Packet No.', 'Duplicate Internal Packet No. in Item Entry');
            }
        }
        if (!duplicateFlag) {
            var itemCategory = null;
            if (!isNullOrEmpty(formValues.itemCategoryCode)) {
                itemCategory = {
                    id: formValues.itemCategoryCode
                };
            }

            var serviceProvider = null;
            if (!isNullOrEmpty(formValues.serviceProviderCode)) {
                serviceProvider = {
                    id: formValues.serviceProviderCode
                };
            }

            var senderContactNo = null;
            if (!(isNullOrEmpty(formValues.senderMobileCountryCode) && isNullOrEmpty(formValues.senderContactNo))) {
                senderContactNo = formValues.senderMobileCountryCode + '-' + formValues.senderContactNo;
            }

            var receiverContactNo = null;
            if (!(isNullOrEmpty(formValues.receiverMobileCountryCode) && isNullOrEmpty(formValues.receiverContactNo))) {
                receiverContactNo = formValues.receiverMobileCountryCode + '-' + formValues.receiverContactNo;
            }

            var fdAddItemEntryModel;
            if (entryType == 'Inward') {
                fdAddItemEntryModel = new Academia.model.fdmanagement.FDManagementModel();
                fdAddItemEntryModel.set("inwardNo", formValues.inwardNo);
                fdAddItemEntryModel.set("senderName", formValues.nameOfSenderId);
                var receiver = null;
                if (!isNullOrEmpty(formValues.receiverNameId)) {
                    receiver = {
                        id: formValues.receiverNameId
                    };
                }
                fdAddItemEntryModel.set("receiver", receiver);
                var entryBy = null;
                if (!isNullOrEmpty(formValues.inwardEntryById)) {
                    entryBy = {
                        id: formValues.inwardEntryById
                    };
                }
                fdAddItemEntryModel.set("entryBy", entryBy);
                fdAddItemEntryModel.set("deliveryDate", formValues.dateOfDelivery);
                fdAddItemEntryModel.set("isBillReceived", formValues.billReceived);
                fdAddItemEntryModel.set("billNo", formValues.billNo);
                fdAddItemEntryModel.set("billAmount", formValues.billAmount);
                fdAddItemEntryModel.set("remark", formValues.remarks);
            } else {
                fdAddItemEntryModel = new Academia.model.fdmanagement.FDManagementOutwardModel();
                fdAddItemEntryModel.set("outwardNo", formValues.outwardNo);
                var sender = null;
                if (!isNullOrEmpty(formValues.outwardSenderId)) {
                    sender = {
                        id: formValues.outwardSenderId
                    };
                }
                fdAddItemEntryModel.set("sentBy", sender);
                fdAddItemEntryModel.set("deliverTo", formValues.deliverTo);
                fdAddItemEntryModel.set("studentAddress", formValues.deliveryAddress);

                var outwardEntryById = null;
                if (!isNullOrEmpty(formValues.outwardEntryById)) {
                    outwardEntryById = {
                        id: formValues.outwardEntryById
                    };
                }
                fdAddItemEntryModel.set("entryBy", outwardEntryById);
                fdAddItemEntryModel.set("sentDate", formValues.sentDate);

                fdAddItemEntryModel.set("isItemInsured", formValues.itemInsured);
                var insuredBy = null;
                if (!isNullOrEmpty(formValues.insuredById)) {
                    insuredBy = {
                        id: formValues.insuredById
                    };
                }
                fdAddItemEntryModel.set("insuredBy", insuredBy);
                fdAddItemEntryModel.set("policyNo", formValues.policyNo);
                fdAddItemEntryModel.set("insuranceAmount", formValues.insuranceAmount);
                fdAddItemEntryModel.set("remarks", formValues.remarks);
            }
            fdAddItemEntryModel.set("id", formValues.id);
            fdAddItemEntryModel.set("entryType", formValues.entryType);
            fdAddItemEntryModel.set("itemCategory", itemCategory);
            fdAddItemEntryModel.set("senderContactNo", senderContactNo);
            fdAddItemEntryModel.set("receiverContactNo", receiverContactNo);
            fdAddItemEntryModel.set("serviceProvider", serviceProvider);
            fdAddItemEntryModel.set("noOfPackets", docketNoArray.length);

            var documentGrid;
            if (entryType == 'Inward') {
                fdAddItemEntryModel.set("fdItemDetails", docketNoArray);
                documentGrid = $this.getFditementrydocumentgrid();
            } else {
                fdAddItemEntryModel.set("fdOutwardItemDetails", docketNoArray);
                documentGrid = $this.getFdoutwarditementrydocumentgrid();
            }
            var docStore = documentGrid.getStore();
            var docArray = [];
            try {
                if (!isNullOrEmpty(documentGrid.getCode()) && documentGrid.getCode() != undefined) {
                    docStore.add(documentGrid.getCode());
                    if (docStore.data.items != null && docStore.data.items.length > 0) {
                        Ext.each(docStore.data.items, function(val) {
                            if (val.data.isNewRecord != undefined && val.data.isNewRecord) {
                                var newData = {
                                    "name": val.data.documentName,
                                    "path": val.data.path,
                                    "type": "DOCUMENT",
                                    "createdBy": $this.getIdValueJson(val.data.createdBy.id, val.data.createdBy.value)
                                };

                                if (entryType == 'Inward') {
                                    var newData2 = {
                                        "document": newData
                                    };
                                    docArray.push(newData2);
                                } else {
                                    docArray.push(newData);
                                }
                            }
                        });
                    }
                    var arr = [];
                    docStore.add(arr);
                }
            } catch (err) {

            }
            if (entryType == 'Inward') {
                fdAddItemEntryModel.set("fdItemDocuments", docArray);
            } else {
                fdAddItemEntryModel.set("documents", docArray);
            }

            var message;
            var msg;
            var url;
            var tabName;
            var status = formValues.status;
            if (entryType == 'Inward') {
                if (isNullOrEmpty(formValues.id)) {
                    message = getCommonTranslation('FD_MANAGEMENT_ITEMS_CREATED_SUCCESSFULLY');
                    msg = getCommonTranslation('RECORD_ADD_SUCCESS');
                    url = SERVERURL.FD_MANAGEMENT_ITEMS_SAVE;
                    tabName = getServiceRequestTranslation('FD_ADD_ITEM_ENTRY');
                } else {
                    message = getCommonTranslation('FD_MANAGEMENT_ITEMS_UPDATED_SUCCESSFULLY');
                    msg = getCommonTranslation('RECORD_UPDATE_SUCCESS');
                    url = SERVERURL.FD_MANAGEMENT_ITEMS_UPDATE;
                    tabName = getServiceRequestTranslation('FD_EDIT_ITEM_ENTRY');
                    fdAddItemEntryModel.set("acknowledgeStatus", status);
                }
            } else {
                if (isNullOrEmpty(formValues.id)) {
                    message = getCommonTranslation('FD_MANAGEMENT_ITEMS_CREATED_SUCCESSFULLY');
                    msg = getCommonTranslation('RECORD_ADD_SUCCESS');
                    url = SERVERURL.FD_MANAGEMENT_OUTWARD_ITEMS_SAVE;
                    tabName = getServiceRequestTranslation('FD_ADD_ITEM_ENTRY');
                } else {
                    message = getCommonTranslation('FD_MANAGEMENT_ITEMS_UPDATED_SUCCESSFULLY');
                    msg = getCommonTranslation('RECORD_UPDATE_SUCCESS');
                    url = SERVERURL.FD_MANAGEMENT_OUTWARD_ITEMS_UPDATE;
                    tabName = getServiceRequestTranslation('FD_EDIT_ITEM_ENTRY');
                    fdAddItemEntryModel.set("packetStatus", status);
                }
            }
            var formData = Ext.encode(fdAddItemEntryModel.data);
            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            Ext.Ajax.request({
                type: 'rest',
                url: url,
                jsonData: formData,
                method: 'POST',
                success: function(response, action) {
                    Ext.getBody().unmask();
                    var data = Ext.decode(response.responseText);
                    if (data.code != 'SUCCESS') {
                        /** manage internal packet and docket no alert msg */
                        var alertMsg;
                        if (data.code == 'DOCKETNO') {
                            alertMsg = getServiceRequestTranslation('FD_DOCKET_NO');
                        } else if (data.code == 'INTERNALPACKETNO') {
                            alertMsg = getServiceRequestTranslation('FD_INTERNAL_PACKET_NO');
                        }
                        showWarningMessage(alertMsg, alertMsg + ' ' + data.value + getServiceRequestTranslation('FD_ALREADY_EXIST'));
                    } else {
                        var contentpanel = $this.getContentpanel();
                        var getcontroller = $this.getController('menu.CoreERPNavigationController');
                        var getTab = getcontroller.getTab(tabName);
                        if (getTab != null) {
                            contentPanel.remove(getTab, true);
                        }

                        var grid;
                        var inwardGrid = $this.getFdmanagementgrid();
                        var outwardGrid = $this.getFdmanagementoutwardgrid();
                        var fdmanagementfilter = $this.getFdmanagementfilter();

                        var entryTypeItemIdInFilter = fdmanagementfilter.down("#entryTypeItemId");

                        if (entryType == 'Inward') {
                            entryTypeItemIdInFilter.setValue('Inward');
                            grid = inwardGrid;
                        } else {
                            entryTypeItemIdInFilter.setValue('Outward');
                            grid = outwardGrid;
                        }
                        $this.entryTypeChnage();
                        var store = grid.getStore();
                        $this.resetPageSetting(store);
                        store.getProxy().extraParams = {
                            entryType: entryType
                        };
                        store.reload();
                        grid.getSelectionModel().deselectAll();
                        if (grid.down('#dockedItemsItemId') != null)
                            grid.down('#dockedItemsItemId').setVisible(true);
                        $this.resetFilterAfterDelete();
                        showSuccessMessage(message, msg);
                    }
                }
            });
        }
    },
    getReceiverDetails: function(record) {
        $this = this;
        var form = $this.getFdadditementryform();
        var id = form.down("#receiverNameItemId").getValue();
        var mobileField = form.down("#receiverContactNoItemId");
        var countryCodeField = form.down("#receiverMobileCountryCodeItemId");
     	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
        var param;
        var urlName
        if(record[0].raw.userGroupId == 3) {
        	urlName = SERVERURL.STUDENT + id;
        	param = {
                id: id
            }
        } else {
        	urlName = SERVERURL.STAFF + id;
        	param = {
        			userId: id
                }
        }
        Ext.Ajax.request({
            method: "GET",
            type: 'rest',
            url: urlName,
            params: param,
            headers: {
                'Content-Type': 'application/json'
            },
            success: function(response, action) {
                var data = Ext.decode(response.responseText);
                countryCodeField.getStore().load({
                    callback: function(records, operation, success) {
                        countryCodeField.setValue(data.person.mobileCountryCode);
                    }
                });
                mobileField.setValue(data.person.mobileNumber);
            }
        });
    },
    getSenderDetails: function(record) {
        $this = this;
        var form = $this.getFdadditementryform();
        var id = form.down("#outwardSenderIdItemId").getValue();
        var mobileField = form.down("#senderContactNoItemId");
        var countryCodeField = form.down("#senderMobileCountryCodeItemId");
     	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);

        var param;
        var urlName
        if(record[0].raw.userGroupId == 3) {
        	urlName = SERVERURL.STUDENT + id;
        	param = {
                id: id
            }
        } else {
        	urlName = SERVERURL.STAFF + id;
        	param = {
        			userId: id
                }
        }
        Ext.Ajax.request({
            method: "GET",
            type: 'rest',
            url: urlName,
            params: param,
            headers: {
                'Content-Type': 'application/json'
            },
            success: function(response, action) {
                var data = Ext.decode(response.responseText);
                countryCodeField.getStore().load({
                    callback: function(records, operation, success) {
                    	countryCodeField.setValue(data.person.mobileCountryCode);
                    }
                });
                mobileField.setValue(data.person.mobileNumber);
            }
        });
    },
    loadFDManagementGrid: function() {
        var $this = this;
        var form = $this.getFdmanagementfilter();

        var entryType = form.down("#entryTypeItemId").getValue();
        var itemCategoryId = form.down("#itemCategoryItemId").getValue();
        var serviceProviderId = form.down("#serviceProviderItemId").getValue();
        var fromDate = form.down("#fromDateItemId").getValue();
        var toDate = form.down("#toDateItemId").getValue();

		if(fromDate != null){
            fromDate= new Date(fromDate);
            fromDate = Ext.Date.format(fromDate, 'Y-m-d');
          }
            
        if(toDate != null){
            toDate= new Date(toDate);
            toDate = Ext.Date.format(toDate, 'Y-m-d');
         }

        var inwardGrid = $this.getFdmanagementgrid();
        var outwardGrid = $this.getFdmanagementoutwardgrid();
        if (entryType == 'Inward') {
            var inwardNo = form.down("#inwardNoItemId").getValue();
            var receiverId = form.down("#receiverNameItemId").getValue();
            var docketNo = form.down("#docketNoItemId").getValue();
            var inwardEntryById = form.down("#inwardEntryByItemId").getValue();
            var billNo = form.down("#billNoItemId").getValue();

            var store = inwardGrid.getStore();
            store.getProxy().extraParams = {
                entryType: entryType,
                itemCategoryId: itemCategoryId,
                inwardNo: inwardNo,
                receiverId: receiverId,
                serviceProviderId: serviceProviderId,
                docketNo: docketNo,
                inwardEntryById: inwardEntryById,
                billNo: billNo,
                fromDate: fromDate,
                toDate: toDate
            };
            store.load();
            inwardGrid.getSelectionModel().deselectAll();
            if (inwardGrid.down('#dockedItemsItemId') != null)
                inwardGrid.down('#dockedItemsItemId').setVisible(true);
            /*inwardGrid.setVisible(true);
        	 outwardGrid.setVisible(false);*/
            inwardGrid.config.searchFilterForm = form;
        } else {
            var outwardNo = form.down("#outwardNoItemId").getValue();
            var senderId = form.down("#outwardSenderIdItemId").getValue();
            var internalPacketNo = form.down("#internalPacketNoItemId").getValue();
            var docketNoOutward = form.down("#docketNoOutwardItemId").getValue();
            var outwardEntryBy = form.down("#outwardEntryByItemId").getValue();

            var store = outwardGrid.getStore();
            store.getProxy().extraParams = {
                entryType: entryType,
                itemCategoryId: itemCategoryId,
                outwardNo: outwardNo,
                senderId: senderId,
                serviceProviderId: serviceProviderId,
                internalPacketNo: internalPacketNo,
                docketNo: docketNoOutward,
                outwardEntryBy: outwardEntryBy,
                fromDate: fromDate,
                toDate: toDate
            };
            store.load();
            outwardGrid.getSelectionModel().deselectAll();
            if (outwardGrid.down('#dockedItemsItemId') != null)
                outwardGrid.down('#dockedItemsItemId').setVisible(true);
            /*inwardGrid.setVisible(false);
        	 outwardGrid.setVisible(true);*/
            outwardGrid.config.searchFilterForm = form;
        }
    },
    viewItemEntry: function(entryType) {
        $this = this;
        $this.editFDItemEntry('VIEW', entryType);
        var form = $this.getFdadditementryform();
        var fdadditementryform = form.getForm();
        var record;
        var dataModel;
        var docStore;
        if (entryType == 'Inward') {
        	record = $this.getFdmanagementgrid().getSelectionModel().getSelection()[0];
            dataModel = new Academia.model.fdmanagement.FDManagementModel(record.data);
        } else {
        	record = $this.getFdmanagementoutwardgrid().getSelectionModel().getSelection()[0];
            dataModel = new Academia.model.fdmanagement.FDManagementOutwardModel(record.data);
        }
        this.toggleReadOnlyFormItems(fdadditementryform, true);
        form.down('#saveFdadditementryformItemId').setVisible(false);
        form.down('#resetFdadditementryformItemId').setVisible(false);
        form.down('#itementryDocumentUploadId').setVisible(false);
        $this.getFditementrydocumentgrid().down('#btnDelete').setVisible(false);
        $this.getFdoutwarditementrydocumentgrid().down('#btnDelete').setVisible(false);
        var itemCategoryItemId = form.down('#itemCategoryItemId');
        var senderMobileCountryCodeItemId = form.down('#senderMobileCountryCodeItemId');
        var senderContactNoItemId = form.down('#senderContactNoItemId');
        var receiverMobileCountryCodeItemId = form.down('#receiverMobileCountryCodeItemId');
        var receiverContactNoItemId = form.down('#receiverContactNoItemId');
        if (entryType == 'Inward') {
        docStore = $this.getFditementrydocumentgrid().getStore();
        form.loadRecord(dataModel);
        var str = dataModel.data.senderContactNo;
        if (str != null) {
            var spiltMobileNo = str.split("-");
            if (!isNullOrEmpty(str)) {
                if (spiltMobileNo.length == 2) {
                	senderMobileCountryCodeItemId.getStore().load();
                    senderMobileCountryCodeItemId.setValue(spiltMobileNo[0]);
                    senderContactNoItemId.setValue(spiltMobileNo[1]);
                }

            }
        }
        var str = dataModel.data.receiverContactNo;
        if (str != null) {
            var spiltMobileNo = str.split("-");
            if (!isNullOrEmpty(str)) {
                if (spiltMobileNo.length == 2) {
                	receiverMobileCountryCodeItemId.getStore().load();
                    receiverMobileCountryCodeItemId.setValue(spiltMobileNo[0]);
                    receiverContactNoItemId.setValue(spiltMobileNo[1]);
                }

            }
        }
        docStore.getProxy().extraParams = {
            fdManagementItemId: dataModel.data.id
        };
        docStore.load({
            callback: function(records, operation, success) {
            	$this.getFditementrydocumentgrid().down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ docStore.getCount());
            }
          });
        }
        else{
        var docStore = $this.getFdoutwarditementrydocumentgrid().getStore();
        docStore.getProxy().extraParams = {
            fdManagementItemId: dataModel.data.id
        };
        docStore.load({
            callback: function(records, operation, success) {
            	$this.getFdoutwarditementrydocumentgrid().down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ docStore.getCount());
            }
          });
        }
        var docketNoContainer = form.down('#docketNoContainerItemId');
        for (var j = 0; j < docketNoContainer.items.length; j++) {
            var docketNoPanelContainer = docketNoContainer.items.items[j];
            docketNoPanelContainer.items.items[3].setVisible(false);
        }
    },
    editFDItemEntry: function(openView, entryType) {
        var $this = this;
        var grid;
        if (entryType == 'Inward') {
            grid = $this.getFdmanagementgrid();
        } else {
            grid = $this.getFdmanagementoutwardgrid();
        }

        if (grid.getSelectionModel().getCount() > 0) {
            $this.openAddItemEntryTab(openView);
            var form = this.getFdadditementryform();
            var record = grid.getSelectionModel().getSelection()[0];
            var dataModel;
            if (entryType == 'Inward') {
                dataModel = new Academia.model.fdmanagement.FDManagementModel(record.data);
            } else {
                dataModel = new Academia.model.fdmanagement.FDManagementOutwardModel(record.data);
            }
            form.loadRecord(dataModel);
            /** Common */
            var idItemId = form.down('#idItemId');
            var statusItemId = form.down('#statusItemId');
            var entryTypeItemId = form.down('#entryTypeItemId');
            var itemCategoryItemId = form.down('#itemCategoryItemId');
            var senderMobileCountryCodeItemId = form.down('#senderMobileCountryCodeItemId');
            var senderContactNoItemId = form.down('#senderContactNoItemId');
            var receiverMobileCountryCodeItemId = form.down('#receiverMobileCountryCodeItemId');
            var receiverContactNoItemId = form.down('#receiverContactNoItemId');
            var serviceProviderItemId = form.down('#serviceProviderItemId');
            var noOfPiecesItemId = form.down('#noOfPiecesItemId');
            var remarksItemId = form.down('#remarksItemId');
            this$.setMaximumMinimumDigitsForMobileNoValidation(form,senderMobileCountryCodeItemId,senderContactNoItemId,null);
            this$.setMaximumMinimumDigitsForMobileNoValidation(form,receiverMobileCountryCodeItemId,receiverContactNoItemId,null);

            idItemId.setValue(dataModel.data.id);

            var str = dataModel.data.senderContactNo;
            if (str != null) {
                var spiltMobileNo = str.split("-");
                if (!isNullOrEmpty(str)) {
                    if (spiltMobileNo.length == 2) {
                    	senderMobileCountryCodeItemId.getStore().load();
                        senderMobileCountryCodeItemId.setValue(spiltMobileNo[0]);
                        senderContactNoItemId.setValue(spiltMobileNo[1]);
                    }

                }
            }
            var str = dataModel.data.receiverContactNo;
            if (str != null) {
                var spiltMobileNo = str.split("-");
                if (!isNullOrEmpty(str)) {
                    if (spiltMobileNo.length == 2) {
                    	receiverMobileCountryCodeItemId.getStore().load();
                        receiverMobileCountryCodeItemId.setValue(spiltMobileNo[0]);
                        receiverContactNoItemId.setValue(spiltMobileNo[1]);
                    }

                }
            }
            if (!isNullOrEmpty(dataModel.data.noOfPackets) && dataModel.data.noOfPackets > 1) {
                noOfPiecesItemId.setValue(dataModel.data.noOfPackets);
            }
            if (!isNullOrEmpty(dataModel.data.entryType)) {
                entryTypeItemId.getStore().load({
                    callback: function(records, operation, success) {
                        entryTypeItemId.setValue(dataModel.data.entryType);
                    }
                });
            }
            if (!isNullOrEmpty(dataModel.data.itemCategory) && !isNullOrEmpty(dataModel.data.itemCategory.id)) {
                itemCategoryItemId.getStore().load({
                    callback: function(records, operation, success) {
                        itemCategoryItemId.setValue(dataModel.data.itemCategory.id);
                    }
                });
            }
            if (!isNullOrEmpty(dataModel.data.serviceProvider) && !isNullOrEmpty(dataModel.data.serviceProvider.id)) {
                serviceProviderItemId.getStore().load({
                    callback: function(records, operation, success) {
                        serviceProviderItemId.setValue(dataModel.data.serviceProvider.id);
                    }
                });
            }
            var inwardNoItemId = form.down('#inwardNoItemId');
            var outwardNoItemId = form.down('#outwardNoItemId');
            var receiverNameItemId = form.down('#receiverNameItemId');
            var outwardSenderIdItemId = form.down('#outwardSenderIdItemId');
            var inwardEntryByItemId = form.down('#inwardEntryByItemId');
            var outwardEntryByItemId = form.down('#outwardEntryByItemId');
            var nameOfSenderItemId = form.down('#nameOfSenderItemId');
            var dateOfDeliveryItemId = form.down('#dateOfDeliveryItemId');
            var billReceivedItemId = form.down('#billReceivedItemId');
            var billNoItemId = form.down('#billNoItemId');
            var billAmountItemId = form.down('#billAmountItemId');
            var deliverToItemId = form.down('#deliverToItemId');
            var deliveryAddressItemId = form.down('#deliveryAddressItemId');
            var sentDateItemId = form.down('#sentDateItemId');
            var itemInsuredItemId = form.down('#itemInsuredItemId');
            var insuredByIdItemId = form.down('#insuredByIdItemId');
            var policyNoItemId = form.down('#policyNoItemId');
            var insuranceAmountItemId = form.down('#insuranceAmountItemId');
            var internalPacketNoItemId = form.down("#internalPacketNoItemId");
            var inwardGrid = $this.getFditementrydocumentgrid();
            var outwardGrid = $this.getFdoutwarditementrydocumentgrid();
            var fdinwardformItemId = form.down('#fdinwardformItemId');

            if (entryType == 'Inward') {
                fdinwardformItemId.setVisible(true);
                inwardNoItemId.setVisible(true);
                outwardNoItemId.setVisible(false);

                nameOfSenderItemId.setVisible(true);
                outwardSenderIdItemId.setVisible(false);

                receiverNameItemId.setVisible(true);
                deliverToItemId.setVisible(false);
                deliveryAddressItemId.setVisible(false);

                dateOfDeliveryItemId.setVisible(true);
                sentDateItemId.setVisible(false);
                dateOfDeliveryItemId.allowBlank = false;
                sentDateItemId.allowBlank = true;

                billReceivedItemId.setVisible(true);
                itemInsuredItemId.setVisible(false);

                inwardEntryByItemId.setVisible(true);
                outwardEntryByItemId.setVisible(false);
                internalPacketNoItemId.setVisible(false);

                inwardNoItemId.setValue(dataModel.data.inwardNo);
                nameOfSenderItemId.setValue(dataModel.data.senderName);
                if (!isNullOrEmpty(dataModel.data.receiver) && !isNullOrEmpty(dataModel.data.receiver.id)) {
                    receiverNameItemId.getStore().load({
                        callback: function(records, operation, success) {
                            receiverNameItemId.setValue(dataModel.data.receiver.id);
                        }
                    });
                }
                if (!isNullOrEmpty(dataModel.data.entryBy) && !isNullOrEmpty(dataModel.data.entryBy.id)) {
                    inwardEntryByItemId.getStore().load({
                        callback: function(records, operation, success) {
                            inwardEntryByItemId.setValue(dataModel.data.entryBy.id);
                        }
                    });
                }
                dateOfDeliveryItemId.setValue(dateRender(dataModel.data.deliveryDate));
                billReceivedItemId.setValue(dataModel.data.isBillReceived);
                if (!dataModel.data.isBillReceived) {
                    insuredByIdItemId.allowBlank = true;
                    policyNoItemId.allowBlank = true;
                    insuranceAmountItemId.allowBlank = true;
                    billNoItemId.allowBlank = true;
                    billAmountItemId.allowBlank = true;
                }
                billNoItemId.setValue(dataModel.data.billNo);
                billAmountItemId.setValue(dataModel.data.billAmount);
                remarksItemId.setValue(dataModel.data.remark);

                receiverNameItemId.allowBlank = false;
                receiverNameItemId.forceSelection = true;
                inwardEntryByItemId.allowBlank = false;
                inwardEntryByItemId.forceSelection = true;

                outwardSenderIdItemId.allowBlank = true;
                outwardSenderIdItemId.forceSelection = false;
                outwardEntryByItemId.allowBlank = true;
                outwardEntryByItemId.forceSelection = false;

                nameOfSenderItemId.allowBlank = false;
                deliverToItemId.allowBlank = true;

                inwardGrid.setVisible(true);
                outwardGrid.setVisible(false);
                var docStore = inwardGrid.getStore();
                docStore.getProxy().extraParams = {
                    fdManagementItemId: dataModel.data.id
                };
                docStore.load({
                    callback: function(records, operation, success) {
                        inwardGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ docStore.getCount());
                    }
                });
                statusItemId.setValue(dataModel.data.acknowledgeStatus);
                inwardNoItemId.allowBlank = false;
                outwardNoItemId.allowBlank = true;
                this.setAllowBlank(serviceProviderItemId,true);
                //serviceProviderItemId.allowBlank = true;
                //serviceProviderItemId.setFieldLabel(getServiceRequestTranslation('FD_SERVICE_PROVIDER'));
            } else {
                fdinwardformItemId.setVisible(false);
                inwardNoItemId.setVisible(false);
                outwardNoItemId.setVisible(true);

                nameOfSenderItemId.setVisible(false);
                outwardSenderIdItemId.setVisible(true);

                receiverNameItemId.setVisible(false);
                deliverToItemId.setVisible(true);
                deliveryAddressItemId.setVisible(true);

                dateOfDeliveryItemId.setVisible(false);
                sentDateItemId.setVisible(true);
                dateOfDeliveryItemId.allowBlank = true;
                sentDateItemId.allowBlank = false;

                billReceivedItemId.setVisible(false);
                itemInsuredItemId.setVisible(true);

                inwardEntryByItemId.setVisible(false);
                outwardEntryByItemId.setVisible(true);
                internalPacketNoItemId.setVisible(true);

                outwardNoItemId.setValue(dataModel.data.outwardNo);
                if (!isNullOrEmpty(dataModel.data.sentBy) && !isNullOrEmpty(dataModel.data.sentBy.id)) {
                    outwardSenderIdItemId.getStore().load({
                        callback: function(records, operation, success) {
                            outwardSenderIdItemId.setValue(dataModel.data.sentBy.id);
                        }
                    });
                }
                deliverToItemId.setValue(dataModel.data.deliverTo);
                deliveryAddressItemId.setValue(dataModel.data.studentAddress);
                if (!isNullOrEmpty(dataModel.data.entryBy) && !isNullOrEmpty(dataModel.data.entryBy.id)) {
                    outwardEntryByItemId.getStore().load({
                        callback: function(records, operation, success) {
                            outwardEntryByItemId.setValue(dataModel.data.entryBy.id);
                        }
                    });
                }
                sentDateItemId.setValue(dateRender(dataModel.data.sentDate));
                itemInsuredItemId.setValue(dataModel.data.isItemInsured);
                if (!isNullOrEmpty(dataModel.data.insuredBy) && !isNullOrEmpty(dataModel.data.insuredBy.id)) {
                    insuredByIdItemId.getStore().load({
                        callback: function(records, operation, success) {
                            insuredByIdItemId.setValue(dataModel.data.insuredBy.id);
                        }
                    });
                }
                policyNoItemId.setValue(dataModel.data.policyNo);
                insuranceAmountItemId.setValue(dataModel.data.insuranceAmount);
                if (!dataModel.data.insuranceAmount) {
                    insuredByIdItemId.allowBlank = true;
                    policyNoItemId.allowBlank = true;
                    insuranceAmountItemId.allowBlank = true;
                    billNoItemId.allowBlank = true;
                    billAmountItemId.allowBlank = true;
                }
                remarksItemId.setValue(dataModel.data.remarks);

                receiverNameItemId.allowBlank = true;
                receiverNameItemId.forceSelection = false;
                inwardEntryByItemId.allowBlank = true;
                inwardEntryByItemId.forceSelection = false;

                outwardSenderIdItemId.allowBlank = false;
                outwardSenderIdItemId.forceSelection = true;
                outwardEntryByItemId.allowBlank = false;
                outwardEntryByItemId.forceSelection = true;

                nameOfSenderItemId.allowBlank = true;
                deliverToItemId.allowBlank = false;

                inwardGrid.setVisible(false);
                outwardGrid.setVisible(true);
                var docStore = outwardGrid.getStore();
                docStore.getProxy().extraParams = {
                    fdManagementOutwardItemId: dataModel.data.id
                };
                docStore.load({
                    callback: function(records, operation, success) {
                    	outwardGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ docStore.getCount());
                    }
                });
                statusItemId.setValue(dataModel.data.packetStatus);
                inwardNoItemId.allowBlank = true;
                outwardNoItemId.allowBlank = false;
                this.setAllowBlank(serviceProviderItemId,false);
                //serviceProviderItemId.allowBlank = false;
                //serviceProviderItemId.setFieldLabel(getServiceRequestTranslation('FD_SERVICE_PROVIDER') + '<span class="required" style="color:red"> *</span>');
            }
            var resetButton = form.down('#resetFdadditementryformItemId');
            resetButton.setVisible(false);

            var fdItemDetailsArr;
            if (entryType == 'Inward') {
                fdItemDetailsArr = dataModel.data.fdItemDetails;
            } else {
                fdItemDetailsArr = dataModel.data.fdOutwardItemDetails;
            }

            var addFilterBtn = form.down('#addFilterBtn');
            var docketNoContainer = form.down('#docketNoContainerItemId');
            if (fdItemDetailsArr != null && fdItemDetailsArr.length > 0) {
                for (var j = 0; j < fdItemDetailsArr.length - 1; j++) {
                    $this.addMultipleDocketNoTextField(addFilterBtn, false);
                }

                for (var j = 0; j < fdItemDetailsArr.length; j++) {
                    var docketNoPanelContainer = docketNoContainer.items.items[j];
                    docketNoPanelContainer.items.items[0].setValue(fdItemDetailsArr[j].id);
                    docketNoPanelContainer.items.items[2].setValue(fdItemDetailsArr[j].docketNo);
                    if (entryType == 'Outward') {
                        docketNoPanelContainer.items.items[1].setValue(fdItemDetailsArr[j].internalPacketNo);
                    }
                }
            }
            entryTypeItemId.setReadOnly(true);
            $this.removePlaceHolder(entryType);
        } else {
            showWarningMessage(getServiceRequestTranslation('FD_ITEM_ENTRY'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        }
    },
    deleteFDItemEntry: function(entryType) {
        var $this = this;
        var grid;
        var serverURL;
        if (entryType == 'Inward') {
            grid = $this.getFdmanagementgrid();
            serverURL = SERVERURL.FD_MANAGEMENT_ITEMS_DELETE;
        } else if (entryType == 'Outward') {
            grid = $this.getFdmanagementoutwardgrid();
            serverURL = SERVERURL.FD_MANAGEMENT_OUTWARD_ITEMS_DELETE;
        }
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getServiceRequestTranslation('FD_ITEM_ENTRY'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    var records = grid.getSelectionModel().getSelection();
                    var id = records[0].get("id");
                    Ext.Ajax.request({
                        method: "DELETE",
                        type: 'rest',
                        url: serverURL + '?id=' + id,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(form, action) {
                            Ext.getBody().unmask();
                            grid.getStore().reload();
                            $this.resetFilterAfterDelete();
                            showSuccessMessage(getServiceRequestTranslation('FD_ITEM_ENTRY'), getCommonTranslation('FD_MANAGEMENT_ITEMS_DELETED_SUCCESSFULLY'));
                        }
                    });
                }
            });
        } else {
            showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
        }
    },
    getDocumentController: function() {
        var this$ = this;
        return this$.getController('Academia.controller.document.DocumentController');
    },
    getIdValueJson: function(id, value) {
        if (id)
            return {
                id: id,
                value: value
            };
    },
    loadFDMEGrid: function() {
        var $this = this;
        var form = $this.getFdmefilter();

        var entryType = form.down("#itemEntryTypeItemId").getValue();
        var itemCategoryId = form.down("#itemCategoryItemId").getValue();
        var serviceProviderId = form.down("#serviceProviderItemId").getValue();
        var fromDate = form.down("#fromDateItemId").getValue();
        var toDate = form.down("#toDateItemId").getValue();
        var userId = this.getCurrentlyLoggedInUser().id;
        var inwardGrid = $this.getFdmegrid();
        var outwardGrid = $this.getFdmeoutwardgrid();
        if (entryType.itemEntryType == 'Received') {
            var inwardNo = form.down("#inwardNoItemId").getValue();
            var inwardEntryById = form.down("#inwardEntryByItemId").getValue();
            var billNo = form.down("#billNoItemId").getValue();
            var docketNo = form.down("#docketNoItemId").getValue();

            var store = inwardGrid.getStore();
            store.getProxy().extraParams = {
                entryType: 'Inward',
                itemCategoryId: itemCategoryId,
                inwardNo: inwardNo,
                receiverId: userId,
                serviceProviderId: serviceProviderId,
                docketNo: docketNo,
                inwardEntryById: inwardEntryById,
                billNo: billNo,
                fromDate: fromDate,
                toDate: toDate
            };
            store.load();
            inwardGrid.getSelectionModel().deselectAll();
            if (inwardGrid.down('#dockedItemsItemId') != null)
                inwardGrid.down('#dockedItemsItemId').setVisible(true);
        } else {
            var outwardNo = form.down("#outwardNoItemId").getValue();
            var internalPacketNo = form.down("#internalPacketNoItemId").getValue();
            var outwardEntryBy = form.down("#outwardEntryByItemId").getValue();
            var docketNo = form.down("#docketNoOutwardItemId").getValue();

            var store = outwardGrid.getStore();
            store.getProxy().extraParams = {
                entryType: 'Outward',
                itemCategoryId: itemCategoryId,
                outwardNo: outwardNo,
                senderId: userId,
                serviceProviderId: serviceProviderId,
                internalPacketNo: internalPacketNo,
                docketNo: docketNo,
                outwardEntryBy: outwardEntryBy,
                fromDate: fromDate,
                toDate: toDate
            };
            store.load();
            outwardGrid.getSelectionModel().deselectAll();
            if (outwardGrid.down('#dockedItemsItemId') != null)
                outwardGrid.down('#dockedItemsItemId').setVisible(true);
        }
    },
    /** Disable More Action Privileges button */
    disableMoreActionPivileges: function(gridReference, permissionsMap) {

        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

        buttonsToolBar = gridReference.query('toolbar')[0];
        var splitbuttons = buttonsToolBar.query('splitbutton')[0];

        var btnUpdateStatusButton = gridReference.down('#btnUpdateStatusItemId');
        btnUpdateStatusButton.setVisible(false);
        Ext.each(permissionList, function(privilege) {
            if (privilege === 'UPDATE_ACKNOWLEDGEMENT_STATUS') {
                if (!isNullOrEmpty(btnUpdateStatusButton)) {
                    btnUpdateStatusButton.setVisible(true);
                }
            }
            if (privilege === 'UPDATESTATUS') {
                if (!isNullOrEmpty(btnUpdateStatusButton)) {
                    splitbuttons.setVisible(true);
                    btnUpdateStatusButton.setVisible(true);
                }
            }
        });
    },
    openAddItemEntryTabAndFillEntryType: function() {
        this.openAddItemEntryTab('ADD');
        var userId = this.getCurrentlyLoggedInUser();
        var form = this.getFdadditementryform();
        var outwardNoItemId = form.down('#outwardNoItemId');
        var outwardSenderIdItemId = form.down('#outwardSenderIdItemId');
        var outwardEntryByItemId = form.down('#outwardEntryByItemId');
        var deliverToItemId = form.down('#deliverToItemId');
        var sentDateItemId = form.down('#sentDateItemId');
        var insuredByIdItemId = form.down("#insuredByIdItemId");
        var policyNoItemId = form.down("#policyNoItemId");
        var insuranceAmountItemId = form.down("#insuranceAmountItemId");
        var billNoItemId = form.down("#billNoItemId");
        var billAmountItemId = form.down("#billAmountItemId");

        outwardSenderIdItemId.allowBlank = true;
        outwardEntryByItemId.allowBlank = true;
        outwardNoItemId.allowBlank = true;
        deliverToItemId.allowBlank = true;
        sentDateItemId.allowBlank = true;
        insuredByIdItemId.allowBlank = true;
        policyNoItemId.allowBlank = true;
        insuranceAmountItemId.allowBlank = true;
        billNoItemId.allowBlank = true;
        billAmountItemId.allowBlank = true;

        var inwardEntryByField = form.down('#inwardEntryByItemId');
        inwardEntryByField.store.load({
            callback: function(operation, success) {
                if (success) {
                    inwardEntryByField.setValue(userId.id);
                }
            }
        });
        outwardEntryByItemId.store.load({
            callback: function(operation, success) {
                if (success) {
                    outwardEntryByItemId.setValue(userId.id);
                }
            }
        });
        var countryCodeFieldArray = ["#senderMobileCountryCodeItemId"];
        this.setDefaultCountryCode(form, countryCodeFieldArray);
        var countryCodeField = form.down("#senderMobileCountryCodeItemId");
        var mobileField = form.down("#senderContactNoItemId");
        this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
        this.removePlaceHolder('Inward');
       },
    deleteDocumentFromGrid: function(entryType) {
        var $this = this;
        var grid;
        var serverURL;
        if (entryType == 'Inward') {
            grid = $this.getFditementrydocumentgrid();
            serverURL = SERVERURL.FD_MANAGEMENT_ITEMS_DOCUMENT_DELETE;
        } else if (entryType == 'Outward') {
            grid = $this.getFdoutwarditementrydocumentgrid();
            serverURL = SERVERURL.FD_MANAGEMENT_OUTWARD_ITEMS_DOCUMENT_DELETE;
        } else if (entryType == 'OutwardUpdateStatus') {
            grid = $this.getFdoutwarditemupdatestatusdocumentgrid();
            serverURL = SERVERURL.FD_MANAGEMENT_OUTWARD_ITEMS_DOCUMENT_DELETE;
        }
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getServiceRequestTranslation('FD_ITEM_ENTRY'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var store = grid.getStore();
                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    var record = grid.getSelectionModel().getSelection()[0];
                    var id = record.get("id");
                    if (!isNullOrEmpty(id)) {
                        Ext.Ajax.request({
                            method: "DELETE",
                            type: 'rest',
                            url: serverURL + '?id=' + id,
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            success: function(form, action) {
                                Ext.getBody().unmask();
                                store.reload();
                                showSuccessMessage(getServiceRequestTranslation('FD_ITEM_ENTRY'), getServiceRequestTranslation('FD_ITEM_ENTRY_DOCUMENT_SUCCESS_DELETE_MSG'));
                            }
                        });
                    } else {
                        if (record) {
                            store.remove(record);
                            grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ store.getCount());
                        }
                        Ext.getBody().unmask();
                    }
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('DOCMENT_NAME'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    resetFDadditementryform: function() {
        $this = this;
        var form = $this.getFdadditementryform();
        var entryTypeItemId = form.down("#entryTypeItemId");
        var entryType = entryTypeItemId.getValue();
        form.getForm().reset();
        var stopContiner = form.down('#docketNoContainerItemId');
        var containerLength = stopContiner.items.length;
        for (var j = 1; j < containerLength; j++) {
            var docketNoPanelContainer = stopContiner.items.items[1];
            stopContiner.remove(docketNoPanelContainer);
        }
        var grid;
        var userId = this.getCurrentlyLoggedInUser();
        if (entryType == 'Inward') {
            grid = $this.getFditementrydocumentgrid();
            var inwardEntryByField = form.down('#inwardEntryByItemId');
            inwardEntryByField.store.load({
                callback: function(operation, success) {
                    if (success) {
                        inwardEntryByField.setValue(userId.id);
                    }
                }
            });
            var countryCodeFieldArray = ["#senderMobileCountryCodeItemId"];
            this.setDefaultCountryCode(form, countryCodeFieldArray);
            var countryCodeField = form.down("#senderMobileCountryCodeItemId");
            var mobileField = form.down("#senderContactNoItemId");
            this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
          
        } else {
            entryTypeItemId.setValue('Outward');
            grid = $this.getFdoutwarditementrydocumentgrid();

            var outwardEntryByItemId = form.down('#outwardEntryByItemId');
            outwardEntryByItemId.store.load({
                callback: function(operation, success) {
                    if (success) {
                        outwardEntryByItemId.setValue(userId.id);
                    }
                }
            });
            var countryCodeFieldArray = ["#receiverMobileCountryCodeItemId"];
            this.setDefaultCountryCode(form, countryCodeFieldArray);
            var countryCodeField = form.down("#receiverMobileCountryCodeItemId");
            var mobileField = form.down("#receiverContactNoItemId");
            this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
          
        }
        var store = grid.getStore();
        if (store)
            store.removeAll();
        
        var dateOfDeliveryItemId = form.down('#dateOfDeliveryItemId');
        var sentDateItemId = form.down('#sentDateItemId');
        dateOfDeliveryItemId.setValue(new Date());
        sentDateItemId.setValue(new Date());
    },
    resetFDmanagementfilter: function() {
        var form = this.getFdmanagementfilter();
        var entryTypeItemId = form.down("#entryTypeItemId");
        var entryType = entryTypeItemId.getValue();
        form.getForm().reset();
        if(entryTypeItemId){
        	entryTypeItemId.fireEvent('select');
        }
        //entryTypeItemId.setValue(entryType);
        this.resetFilterAfterDelete();
    },
    resetFDmefilter: function() {
        var form = this.getFdmefilter();
        var itemCategoryItemId = form.down('#itemCategoryItemId');
        var inwardNoItemId = form.down('#inwardNoItemId');
        var outwardNoItemId = form.down('#outwardNoItemId');
        var serviceProviderItemId = form.down('#serviceProviderItemId');
        var internalPacketNoItemId = form.down('#internalPacketNoItemId');
        var billNoItemId = form.down('#billNoItemId');
        var docketNoItemId = form.down('#docketNoItemId');
        var docketNoOutwardItemId = form.down('#docketNoOutwardItemId');
        var inwardEntryByItemId = form.down('#inwardEntryByItemId');
        var outwardEntryByItemId = form.down('#outwardEntryByItemId');
        var fromDateItemId = form.down('#fromDateItemId');
        var toDateItemId = form.down('#toDateItemId');
        itemCategoryItemId.reset();
        inwardNoItemId.reset();
        outwardNoItemId.reset();
        serviceProviderItemId.reset();
        internalPacketNoItemId.reset();
        billNoItemId.reset();
        docketNoItemId.reset();
        docketNoOutwardItemId.reset();
        inwardEntryByItemId.reset();
        outwardEntryByItemId.reset();
        fromDateItemId.reset();
        toDateItemId.reset();

        var userId = this.getCurrentlyLoggedInUser().id;
        var docketNoStore = docketNoItemId.getStore();
        docketNoStore.getProxy().extraParams = {
            serviceProviderId: '',
            receiverId: userId,
        };
        docketNoStore.load();
        var internalPacketNoStore = internalPacketNoItemId.getStore();
        internalPacketNoStore.getProxy().extraParams = {
            serviceProviderId: '',
            senderId: userId,
        };
        internalPacketNoStore.load();
        var docketNoOutwardStore = docketNoOutwardItemId.getStore();
        docketNoOutwardStore.getProxy().extraParams = {
            serviceProviderId: '',
            senderId: userId,
        };
        docketNoOutwardStore.load();
    },
    resetFilterAfterDelete: function() {
        $this = this;
        var fdManagementFilter = $this.getFdmanagementfilter();

        var userId = this.getCurrentlyLoggedInUser().id;
        var inwardNoItemId = fdManagementFilter.down('#inwardNoItemId');
        var outwardNoItemId = fdManagementFilter.down('#outwardNoItemId');
        var docketNoItemId = fdManagementFilter.down('#docketNoItemId');
        var internalPacketNoItemId = fdManagementFilter.down('#internalPacketNoItemId');
        var billNoItemId = fdManagementFilter.down('#billNoItemId');
        var docketNoOutwardItemId = fdManagementFilter.down('#docketNoOutwardItemId');

        inwardNoItemId.getStore().load();
        outwardNoItemId.getStore().load();
        billNoItemId.getStore().load();

        var docketNoStore = docketNoItemId.getStore();
        docketNoStore.getProxy().extraParams = {
            serviceProviderId: '',
        };
        docketNoStore.load();
        var internalPacketNoStore = internalPacketNoItemId.getStore();
        internalPacketNoStore.getProxy().extraParams = {
            serviceProviderId: '',
        };
        internalPacketNoStore.load();
        var docketNoOutwardStore = docketNoOutwardItemId.getStore();
        docketNoOutwardStore.getProxy().extraParams = {
            serviceProviderId: '',
        };
        docketNoOutwardStore.load();
    },
    entryTypeChnage: function() {
        $this = this;
        var fdManagementFilter = $this.getFdmanagementfilter();
        var entryType = fdManagementFilter.down("#entryTypeItemId").getValue();

        var inwardNoItemId = fdManagementFilter.down('#inwardNoItemId');
        var outwardNoItemId = fdManagementFilter.down('#outwardNoItemId');

        var receiverNameItemId = fdManagementFilter.down('#receiverNameItemId');
        var outwardSenderIdItemId = fdManagementFilter.down('#outwardSenderIdItemId');

        var docketNoItemId = fdManagementFilter.down('#docketNoItemId');
        var internalPacketNoItemId = fdManagementFilter.down('#internalPacketNoItemId');

        var billNoItemId = fdManagementFilter.down('#billNoItemId');
        var docketNoOutwardItemId = fdManagementFilter.down('#docketNoOutwardItemId');

        var inwardEntryByItemId = fdManagementFilter.down('#inwardEntryByItemId');
        var outwardEntryByItemId = fdManagementFilter.down('#outwardEntryByItemId');

        var inwardGrid = $this.getFdmanagementgrid();
        var outwardGrid = $this.getFdmanagementoutwardgrid();

        var fromDateItemId = fdManagementFilter.down('#fromDateItemId');
        var toDateItemId = fdManagementFilter.down('#toDateItemId');
        fromDateItemId.reset();
        toDateItemId.reset();
        
        var displayReceivingDate = fdManagementFilter.down('#displayReceivingDate');
        var displaySentDate = fdManagementFilter.down('#displaySentDate');
        
        if (entryType == 'Inward') {
            inwardNoItemId.setVisible(true);
            outwardNoItemId.setVisible(false);

            receiverNameItemId.setVisible(true);
            outwardSenderIdItemId.setVisible(false);

            docketNoItemId.setVisible(true);
            internalPacketNoItemId.setVisible(false);

            billNoItemId.setVisible(true);
            docketNoOutwardItemId.setVisible(false);

            inwardEntryByItemId.setVisible(true);
            outwardEntryByItemId.setVisible(false);

            displayReceivingDate.setVisible(true);
            displaySentDate.setVisible(false);
            
            
            var store = inwardGrid.getStore();
            inwardGrid.setVisible(true);
            inwardGrid.getHeader().removeCls('gridFixHeader');
            inwardGrid.columnManager.headerCt.removeCls('gridFixHeader');
            inwardGrid.dockedItems.items[3].removeCls('gridFixHeader');
            outwardGrid.setVisible(false);
            store.removeAll();
        } else {
            inwardNoItemId.setVisible(false);
            outwardNoItemId.setVisible(true);

            receiverNameItemId.setVisible(false);
            outwardSenderIdItemId.setVisible(true);

            docketNoItemId.setVisible(false);
            internalPacketNoItemId.setVisible(true);

            billNoItemId.setVisible(false);
            docketNoOutwardItemId.setVisible(true);

            inwardEntryByItemId.setVisible(false);
            outwardEntryByItemId.setVisible(true);
            
            displayReceivingDate.setVisible(false);
            displaySentDate.setVisible(true);
            
            var store = outwardGrid.getStore();
            inwardGrid.setVisible(false);
            outwardGrid.setVisible(true);
            outwardGrid.getHeader().removeCls('gridFixHeader');
            outwardGrid.columnManager.headerCt.removeCls('gridFixHeader');
            outwardGrid.dockedItems.items[3].removeCls('gridFixHeader');
            store.removeAll();
        }
        if (inwardGrid.down('#dockedItemsItemId') != null)
            inwardGrid.down('#dockedItemsItemId').setVisible(false);
        if (outwardGrid.down('#dockedItemsItemId') != null)
            outwardGrid.down('#dockedItemsItemId').setVisible(false);
        
    },
	loadImportFDInwardOutwardGrid : function(templateFor){
		var $this = this;
		var grid = this.getImportfdinwardoutwarditemgrid();
		var form  = $this.getUploadoptionradiogroup();
		var isUploadAll = form.items.items[0].getValue().isUploadAll;
		if(templateFor == "Inward" || templateFor=="Bulk Inward Item") {
			$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Inward Item');
		} else {
			$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Outward Item');
		}
	},
	 getDownloadFile : function(documentId,fileType){

	    	if(!isNullOrEmpty(documentId)){
	    		var csvForm = Ext.create('Ext.form.Panel'); 
	    		csvForm.getForm().submit({
	    			target: '_blank',
	    			method:'POST',
	    			params :{
	    				access_token : Ext.Ajax.defaultHeaders.access_token
	    			},
	    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	    			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
	    			standardSubmit :true
	    		});
	    	}
	    },
	    removePlaceHolder:function(entryType){
	    	var me =this,
	    	entidyId=33;
	    	if(entryType !== 'Inward'){
	    		entidyId =34;
	    	}
	    	
	        var addfileinfoform=this.getFdadditementryform();
	                          Ext.Ajax.request({
	                             type: 'rest',
	                             url: SERVERURL.FIND_BY_ENTITY_ID,                             
	                             method: 'GET',
	                             params: {
	                                 entityId: entidyId
	                             },
	                             success: function(response,form, action) {
	                                 if(!isNullOrEmpty(response.responseText)){
	                                     var responseObject =  Ext.JSON.decode(response.responseText);                                  
	                                     if(!isEmpty(responseObject)){
	                                    	 if(entidyId == 33){
	                                         var fileNumber = addfileinfoform.down("#inwardNoItemId");
	                                    	 }else{
	                                    		 var fileNumber = addfileinfoform.down("#outwardNoItemId");
	                                    	 }
	                                         if(responseObject.whetherManualId){
	                                             fileNumber.setReadOnly(false);
	                                             fileNumber.emptyText=' ';
	                                             fileNumber.allowBlank=false;
	                                             fileNumber.labelSeparator +='<span class="required" style="color:red"> *</span>';
	                                             fileNumber.setFieldLabel(fileNumber.fieldLabel);
	                                             fileNumber.applyEmptyText();
	                                         }else{
	                                             fileNumber.setReadOnly(true);
	                                             me.setAllowBlank(fileNumber,true);
	                                             fileNumber.emptyText= getCommonTranslation('ID_AUTOGENERATE');
	                                             fileNumber.applyEmptyText();
	        
	                                        }
	                                     }
	                                 }                                                     
	                             }                
	                         });
	        
	    }
});