/**
 *  @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.controller.feeandpayment.accountingConfiguration.AccountingConfigurationController',{
	extend: 'Academia.controller.base.BaseController',
	stores : ['feeandpayment.accountingConfiguration.AccountingConfigurationList',
	          'feeandpayment.accountingConfiguration.BatchMode','feeandpayment.FeeCurrencyStore',
	          'feeandpayment.AccountingConfigCurrencyStore'],
	models :['feeandpayment.accountingConfiguration.AccountingConfigurationSave'],
	views : ['feeandpayment.accountingConfiguration.AccountingConfiguratoinStructure',
	         'feeandpayment.accountingConfiguration.AccountingConfigurationList',
	         'feeandpayment.accountingConfiguration.AccountingConfigurationForm'],
	config: {
			ACCOUNT_CONFIGURATION_GRID_CONFIGURATION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ACCOUNT_CONFIGURATION_GRID_CONFIGURATION')
	                            	 
	       },
     refs : [{
    	     ref:'contentPanel',
	         selector:'contentpanel'
            },{
    	     ref:'accountingConfigurationList',
    	     selector:'accountingconfigurationlist'
           },{
        	 ref:'accountingConfigurationForm',
      	     selector:'accountingconfigurationform'
           }],
     init : function() {
    	 this.control({
    		 'accountingconfigurationlist':{
    			 render : this.getRenderAccountingConfigurationList,
afterrender:function(grid){
					var me = this;
					setTimeout(function(){
						me.addDataGridConfigButton(grid, me.getACCOUNT_CONFIGURATION_GRID_CONFIGURATION());
					},1500);
    			 },
     		 },
		
    		 'accountingconfigurationlist button[itemId=btnAdd]':{
                click : this.openAccountingConfiguration
    		 },
    		 'accountingconfigurationlist button[itemId=btnEdit]':{
                 click : this.editAccountingConfiguration
     		 },
     		 'accountingconfigurationlist button[itemId=btnView]':{
                click : this.viewAccountingConfiguration
    		 },
    		 'accountingconfigurationlist button[itemId=btnDelete]':{
                 click : this.deleteAccountingConfiguration
     		 },
    		 'accountingconfigurationform radiogroup[itemId=modeOfTransactionId]':{
    			 change : this.enableDisableBatchPostingMode
    		 },
    		 'accountingconfigurationform radiogroup[itemId=whetherDataImportEnableId]':{
    			 change : this.enableDisableImportDays
    		 },
    		 'accountingconfigurationform button[itemId=SubmitBtn]':{
    		    click : this.saveAccountConfiguration
    		 },
    		 'accountingconfigurationform button[itemId=ResetBtn]':{
     		    click : this.resetAccountConfiguration
     		 },
     		'accountingconfigurationform' :{ 
     			render:function(obj){
     			   var form = this.getAccountingConfigurationForm();
     			   var academyLocationId = this.getCurrentAcademyLocation();
     			   var currencyField = form.getForm().findField('currency');
				   var currencyStore = currencyField.getStore();
				   currencyStore.getProxy().extraParams = {
					   academyLocationId:academyLocationId
				   };
			   },
			 }
    	 });
     },
     /**
      * get List data of Accounting configuartion grid
      */
     getRenderAccountingConfigurationList : function(){
    	 
    	 var grid = this.getAccountingConfigurationList();
    	 var store = grid.getStore();
    	 store.load();
     },
     /**
      * 
      */
     openAccountingConfiguration : function(){
    	 var $this = this;
    	 var contentpanel = $this.getContentPanel();
    	 var structure = Ext.widget('accountingconfigurationform');
    	 var tabName = getFeeAndPaymentCommonTranslation('ACCOUNT_CONFIGURATION');

    	 var getcontroller=this.getController('menu.CoreERPNavigationController');
    	 var getTab=getcontroller.getTab(tabName);
    	 if(getTab!=null){
    		 contentpanel.remove(getTab, true);
    	 }
    	 openTab(contentpanel,tabName,structure,CONSTANTS.MENU_COLOR_FIVE);
     },
     
     /**
      * Show hide Batch Posting Mode when batch mode is batch
      */
     enableDisableBatchPostingMode : function(obj,newValue,oldValue){
    	 
    	 var form=  this.getAccountingConfigurationForm();
    	 var batchPostingMode = form.down("#accountConfigurationBatchSchedulesId");
    	 batchPostingMode.setVisible(false);
    	 
    	 if(newValue.modeOfTransaction==getFeeAndPaymentCommonTranslation('BATCH_VALUE')){
    		 batchPostingMode.setVisible(true);
    	 }
     },
     
     /**
      * Show hide Importing Day when Import data is Yes
      */
     enableDisableImportDays : function(obj,newValue,oldValue){
    	 
    	 var form=  this.getAccountingConfigurationForm();
    	 var importDays = form.down("#accountConfigurationImportSchedulesId");
    	 importDays.setVisible(false);
    	 
    	 if(newValue.whetherDataImportEnable==true){
    		 importDays.setVisible(true);
    	 }
     },
     /**
      *  reset Account Configuration form 
      */
     resetAccountConfiguration : function(){
    	 this.getAccountingConfigurationForm().getForm().reset();
     },
     
     /**
      * save Account configuration information
      */
     saveAccountConfiguration : function(){
    	 var this$ = this;
    	 var form = this$.getAccountingConfigurationForm();
    	 var grid = this$.getAccountingConfigurationList();
    	 var grdStore = grid.getStore();
    	 var getForm = form.getForm();
    	 var value = getForm.getValues();
    	 var batchPostingDay =  value.batchPostingDay;
    	 var importingDay =  value.importingDay;

    	 var batchPostingDayArray = [];
    	 batchPostingDayArray.push({
    		 "id":value.batchId,
    		 "accountConfig":this$.getIdValueJson(value.id),
    		 "mon":batchPostingDay[0],
    		 "tue":batchPostingDay[1],
             "wed":batchPostingDay[2],
             "thu":batchPostingDay[3],
             "fri":batchPostingDay[4],
             "sat":batchPostingDay[5],
             "sun":batchPostingDay[6]
    	 });
    	
    	 var importingDayArray = [];
    	 importingDayArray.push({
    		 "id":value.importId,
    		 "accountConfig":this$.getIdValueJson(value.id),
    		 "mon":importingDay[0],
             "tue":importingDay[1],
             "wed":importingDay[2],
             "thu":importingDay[3],
             "fri":importingDay[4],
             "sat":importingDay[5],
             "sun":importingDay[6]
    	 });
    	 
    	 var ACModel = new Academia.model.feeandpayment.accountingConfiguration.AccountingConfigurationSave();
    	 
    	 ACModel.set("currency",this$.getIdValueJson(value.currency));
    	 ACModel.set("configName",value.configName);
    	 ACModel.set("configDesc",value.configDesc);
    	 ACModel.set("validTill",value.validTill);
    	 ACModel.set("modeOfTransaction",value.modeOfTransaction);
    	 ACModel.set("batchMode",value.batchMode);
    	 ACModel.set("whetherDataImportEnable",value.whetherDataImportEnable);
         ACModel.set("accountConfigurationBatchSchedules",batchPostingDayArray);
         ACModel.set("accountConfigurationImportSchedules",importingDayArray);
    	 
        var MESSAGE;
     	if (value.id == null ||value.id == "") {
 			submitUrl = SERVERURL.ACCOUNT_CONFIGUARTION_CREATE;
 			MESSAGE = getFeeAndPaymentCommonTranslation('ACCOUNT_CONFIGURATION_CREATED_SUCCESSFULLY');
 			delete ACModel.data.createdDate;
 		} else {
 			console.log('value.createdDate',value.createdDate);
 			ACModel.set("id",value.id);
 			ACModel.set("user",this$.getIdValueJson(value.createdById));
 			ACModel.set("currency",this$.getIdValueJson(value.currency));
 			ACModel.set("createdDate", Ext.Date.format(value.createdDate, CONSTANTS.DATE_FORMAT));
 			submitUrl = SERVERURL.ACCOUNT_CONFIGUARTION_UPDATE;
 			MESSAGE = getFeeAndPaymentCommonTranslation('ACCOUNT_CONFIGURATION_UPDATED_SUCCESSFULLY');
 		}
    	 delete ACModel.data.lastModifiedDate;
	     delete ACModel.data.createdBy;
	     delete ACModel.data.userName;
     	
	     var submitData = Ext.encode(ACModel.data);
	     Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 
     	Ext.Ajax.request({
 			url: submitUrl,
 			jsonData: submitData,
 			method: 'POST',
 			success: function(response) {
 			    Ext.getBody().unmask();
 				grdStore.reload();
 				this$.resetAccountConfiguration();
 				showSuccessMessage(getFeeAndPaymentCommonTranslation('ACCOUNT_CONFIGURATION'),MESSAGE);
 			}
 		});
     }, 
     
     /**
      * get edit Account Configuration details
      */
     editAccountingConfiguration : function(){
    	 var this$ = this;
    	 var grid = this$.getAccountingConfigurationList();
 		if (grid.getSelectionModel().getCount() > 0) {
 			this$.openAccountingConfiguration();
 			var form = this$.getAccountingConfigurationForm();
 			var record = grid.getSelectionModel().getSelection()[0];
 			var id = record.get("id");
 			var editUrl = SERVERURL.ACCOUNT_CONFIGUARTION_FIND_BY_ID;
 			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 		
             Ext.Ajax.request({
                 method: "GET",
                 type: 'rest',
                 url: editUrl,
                 params: {
                     id: id
                 },
                 success: function(f, action) {
                	 Ext.getBody().unmask();
                     var ACData = Ext.JSON.decode(f.responseText);
                     if(!isNullOrEmpty(ACData.createdDate))
                    	 ACData.createdDate = new Date(ACData.createdDate);
                     if(!isNullOrEmpty(ACData.validTill))
                    	 ACData.validTill = new Date(ACData.validTill);
                     var ACModel = new Academia.model.feeandpayment.accountingConfiguration.AccountingConfigurationSave(ACData);
 				     form.loadRecord(ACModel);
 				     
 				     var user = ACData.user;
 				     var currency = ACData.currency;
 				     var batchPostingDayValue = ACData.accountConfigurationBatchSchedules[0];
 				     var importingDayValue = ACData.accountConfigurationImportSchedules[0];

 				     var batchMode = ACData.batchMode;
 				     var modeOfTransaction = ACData.modeOfTransaction;
 				     var whetherDataImportEnable = ACData.whetherDataImportEnable;
					
 				     form.down("#ResetBtn").setVisible(false);
 				     form.down("#userfieldId").setVisible(true);
 				     form.down("#createdBy").setValue(user.value);
 				     form.down("#currency").getStore().load({
 				    	 callback: function(records, operation, success) {
 				    		 for(var i in records){
 				    			 if(records[i].data.id==currency.id){
 				    				 form.down("#currency").setValue(records[i].data.id);
 				    			 }
 				    		 }
 				    	 }
 				     });
 				     
 				     form.down("#createdById").setValue(user.id);
 				     form.down("#importId").setValue(importingDayValue.id);
				     form.down("#batchId").setValue(batchPostingDayValue.id);
				     form.down("#batchModeId").setValue(batchMode);
					
					/*if(batchMode){
						if(batchMode==getFeeAndPaymentCommonTranslation('INDIVIDUAL')){
							form.down("#batchModeId").items.items[0].setValue(true);	
						}else{
							form.down("#batchModeId").items.items[1].setValue(true);
						}
					}*/
					if(modeOfTransaction){
						if(modeOfTransaction==getFeeAndPaymentCommonTranslation('REAL_TIME_VALUE')){
							form.down("#modeOfTransactionId").items.items[0].setValue(true);	
						}else{
							form.down("#modeOfTransactionId").items.items[1].setValue(true);
							
							var batchPostingDayField = form.down("#accountConfigurationBatchSchedulesId");
							 
							 batchPostingDayField.items.items[0].setValue(batchPostingDayValue.mon);
							 batchPostingDayField.items.items[1].setValue(batchPostingDayValue.tue);
							 batchPostingDayField.items.items[2].setValue(batchPostingDayValue.wed);
							 batchPostingDayField.items.items[3].setValue(batchPostingDayValue.thu);
							 batchPostingDayField.items.items[4].setValue(batchPostingDayValue.fri);
							 batchPostingDayField.items.items[5].setValue(batchPostingDayValue.sat);
							 batchPostingDayField.items.items[6].setValue(batchPostingDayValue.sun);
						 }
					}
					if(whetherDataImportEnable){
						if(whetherDataImportEnable==true){
							form.down("#whetherDataImportEnableId").items.items[0].setValue(true);	
							 var importingDayField = form.down("#accountConfigurationImportSchedulesId");
							 
							 importingDayField.items.items[0].setValue(importingDayValue.mon);
							 importingDayField.items.items[1].setValue(importingDayValue.tue);
							 importingDayField.items.items[2].setValue(importingDayValue.wed);
							 importingDayField.items.items[3].setValue(importingDayValue.thu);
							 importingDayField.items.items[4].setValue(importingDayValue.fri);
							 importingDayField.items.items[5].setValue(importingDayValue.sat);
							 importingDayField.items.items[6].setValue(importingDayValue.sun);
							 
						}else{
							form.down("#whetherDataImportEnableId").items.items[1].setValue(true);
						 }
					}
                 }
             });
 		} else {
 			 Ext.getBody().unmask();
 			showWarningMessage(getFeeAndPaymentCommonTranslation('ACCOUNT_CONFIGURATION'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
 		}
     },
     
     /**
      * Delete Account Configuration based on id
      */
     deleteAccountingConfiguration : function(){
    	 var this$ = this;
    	 var grid = this$.getAccountingConfigurationList();
    	 var grdStore = grid.getStore();
		if(grid.getSelectionModel().getCount()>0){
			showConfirmMessage(getFeeAndPaymentCommonTranslation('ACCOUNT_CONFIGURATION'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				if (btn == 'yes') {
					var records=grid.getSelectionModel().getSelection();						        
					var id=records[0].get("id");
					Ext.Ajax.request({
						method: "DELETE",
						type: 'rest',
						url: SERVERURL.ACCOUNT_CONFIGUARTION_DELETE+'?id='+id,
						headers: {
							'Content-Type': 'application/json'
						},
						success:function(response, action){
							var id = response.responseText;
							if(id==0){
								showWarningMessage(getFeeAndPaymentCommonTranslation('ACCOUNT_CONFIGURATION'), getFeeAndPaymentCommonTranslation('DEPENDENCY_ERROR_MSSG')); //Error occured while performing transaction
							}else{
								showSuccessMessage(getFeeAndPaymentCommonTranslation('ACCOUNT_CONFIGURATION'),getFeeAndPaymentCommonTranslation('ACCOUNT_CONFIGURATION_DELETED_SUCCESSFULLY'));
							}
							grdStore.reload();
						}
					});
				}
			});
		}else{
			showWarningMessage(getFeeAndPaymentCommonTranslation('ACCOUNT_CONFIGURATION'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
		}
     },
     /**
      * get view (read only)  Accounting Configuration
      */
  	 viewAccountingConfiguration : function(){
  		var this$ = this;
  		this$.editAccountingConfiguration();
  		var form = this$.getAccountingConfigurationForm();
  		if (form) {
  			form.down("#SubmitBtn").setVisible(false);
  			form.down("#ResetBtn").setVisible(false);
  			form = form.getForm();
  			toggleReadOnlyFormItems(form, true);
  		}
  	 },
  	
     /**
      * get Create id value format
      */
     getIdValueJson: function(id, value) {
 		if (id) return {
 			id: id,
 			value: value
 		};
 	}
});