/**
 *  @author Deepak Nigam
 * 
 */
Ext.define('Academia.controller.feeandpayment.feerequest.StudentPortalFeeRequestController', {
	extend : 'Academia.controller.base.BaseController',
	models : ['feeandpayment.feerequest.FeeReqBillInstallment','feeandpayment.feerequest.TempInstallmentData',
	          'feeandpayment.feerequest.FeeRequestSave','feeandpayment.feerequest.FeeServiceRequestModel',
	          'feeandpayment.feerequest.FeeServiceRequest','feeandpayment.feerequest.FeeRelatedServiceRequestInstallment'],
	stores : ['feeandpayment.feerequest.FeeRequestFors','feeandpayment.feerequest.ChooseAgainst',
	          'feeandpayment.feerequest.ConcessionType','feeandpayment.feerequest.TempInstallmentData',
	          'feeandpayment.feerequest.FeeReqBillInstallment','feeandpayment.feerequest.FeeRelatedServiceRequestInstallment',
	          'feeandpayment.feerequest.TempInstallmentStore','feeandpayment.feerequest.ApprovalStatus',
	          'feeandpayment.feerequest.FeeConcessionDetails','feeandpayment.feerequest.ApproverFeeRequestDetails',
	          'feeandpayment.managebill.Sponsors','feeandpayment.managebill.User','feeandpayment.managebill.Student'],
	views : ['feeandpayment.feerequest.StudentFeeRequestStructure',
	         'feeandpayment.feerequest.StudentFeeReqSearchForm','feeandpayment.feerequest.StudentFeeReqBillWaiverGrid',
	         'feeandpayment.feerequest.StudentFeeReqBillInstallmentGrid','feeandpayment.feerequest.StudentFeeReqInstallmentWin'],

	refs : [{
	    	   ref:'studentfeereqsearchform',
	    	   selector:'studentfeereqsearchform'
	       },{
	    	   ref:'studentfeereqbillwaivergrid',
	    	   selector:'studentfeereqbillwaivergrid'
	       },{
	    	   ref:'studentfeerequeststructure',
	    	   selector:'studentfeerequeststructure'
	       },{
	    	   ref:'studentfeereqbillinstallmentgrid',
	    	   selector:'studentfeereqbillinstallmentgrid'	    	   
	       },{
	    	   ref:'studentfeereqinstallmentwin',
	    	   selector:'studentfeereqinstallmentwin'
	       }],
	       config: {
	    	   STUDENT_PORTAL_FEE_REQUEST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_FEE_REQUEST_PRIVILEGES'),
	    	   PARENT_PORTAL_FEE_REQUEST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_FEE_REQUEST_PRIVILEGES')
	       },
      init : function() {
    	  this.control({
    		  
    		  'studentfeereqsearchform button[itemId=searchBtn]':{
    			  click:this.getSearchFeeReqForStudentPortal
    		  },
    		  'studentfeereqsearchform button[itemId=resetBtn]':{
     			 click:this.getAutoLoadFieldsStudentPortal
     		 },
    		  
    		  'studentfeereqsearchform customcombobox[itemId=concessionType]':{
    			  select:this.getChooseAgainstAndConcessionTypeForStudentPortal
    		  },
    		  'studentfeereqsearchform customcombobox[itemId=chooseAgainst]':{
    			  select:this.getChooseAgainstAndConcessionTypeForStudentPortal
    		  },
    		  'studentfeerequeststructure':{
    			  afterrender : function(structure){
     				 var $this = this;
     				 structure.body.on('scroll', function(e, target) {
     					 var feereqbillwaivergrid = $this.getStudentfeereqbillwaivergrid();
     					 var feereqbillinstallmentgrid = $this.getStudentfeereqbillinstallmentgrid();
     					
     					 var grid = null;
     					 if(!feereqbillwaivergrid.isHidden()){
     						 grid = $this.getStudentfeereqbillwaivergrid();
     					 }
     					 if(!feereqbillinstallmentgrid.isHidden()){
     						 grid = $this.getStudentfeereqbillinstallmentgrid();
     					 }
     					 $this.getMultipleGridHeaderFreeze(grid,structure);
     				 });
     			  }
    		  },
    		  'studentfeereqsearchform':{
    			  render:function(){
    				  this.getAutoLoadFieldsStudentPortal();
    			  }
    		  },
    		  
    		  'studentfeereqbillwaivergrid':{
    			  select : function(){
    				  this.getLockedWaiverGrids();
    			  },
    			  cellclick : function(obj,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				  var grid = this.getStudentfeereqbillwaivergrid();
    				  if(e.target.tagName=='A'){
    					  this.getInstallmentForPendingBill(grid,record);
    				  }
    			  },
    			  afterrender : function(grid){
    				  grid.columns[5].hide();
    				  grid.columns[6].hide();
    				  grid.columns[7].hide();
    			  }
    		  },
    		  
    		  'studentfeereqbillwaivergrid button[itemId=btnRaiseRequest]':{
    			  click : function(){

    				  /**
    				   * call API for check request is configured or not
    				   * 
    				   */
    				  /*****/
    				  var me = this;
    				  var portalId = me.getCurrentLoggedPortalId();
    				  var form = me.getStudentfeereqsearchform();
    				  var serviceRequestGroupVal = form.down("#concessionType").getValue();
    				 
    				  var grid = me.getStudentfeereqbillwaivergrid(); 
    				  var record = grid.selModel.getSelection();

    				  Ext.Ajax.request({
    					  type: 'rest',
    					  url: SERVERURL.FEE_SERVICE_REQUEST_SETTING_FIND_ID,
    					  params: {
    						  feeRelatedCategory:serviceRequestGroupVal,
    		    			  academyLocation:me.getCurrentAcademyLocation(),
    						  portalId: portalId
    					  },
    					  method: 'GET',
    					  async: false,
    					  success: function(data, action) {
    						  var parentId = Ext.JSON.decode(data.responseText);
    						 if(isNullOrEmpty(parentId.id)){
    							 showWarningMessage(getFeeAndPaymentCommonTranslation('RAISE_REQUEST'), getFeeAndPaymentCommonTranslation('YOU_DO_NOT_HAVE_PERMISSION_TO_RAISE')+" "+getFeeAndPaymentCommonTranslation(serviceRequestGroupVal)+" request"); 
    						 }
    						 else{
    							  if(record.length>0){
        							  var concessionType = form.down("#concessionType").getValue();
        							  if(concessionType=='FEE_CONCESSION'){
        								  console.log('Remark from grid');
        								  me.getSaveFeeRequestForStudent(grid,'FEE_CONCESSION')
        							  }else{
        								  console.log('Remark from window');
        								  me.getInstallmentForPendingBill(grid);
        							  }
        						  } else{
        							  showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_REQUEST_TITLE'), getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD')); 
        						  }
    						 }

    						
    					  }
    				  });
    				  /*****/
    			  }
    		  },
    		  
    		  'studentfeereqbillinstallmentgrid':{
    			  select:function(){
    				  this.getLockedGrids();
    			  },
    			  cellclick : function(obj,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				  if(e.target.tagName=='A'){
    					  var grid = this.getFeereqbillinstallmentgrid();
    					  this.getInstallment(grid,record);
    				  }
    			  }
    		  },
    		  'studentfeereqbillinstallmentgrid button[itemId=btnRaiseRequest]':{
    			  click : function(){
    				  var grid = this.getStudentfeereqbillinstallmentgrid(); 
    				  //this.saveInstallment(grid);
    				  var record = grid.selModel.getSelection();
    				  var form = this.getStudentfeereqsearchform();

    				  if(record.length>0){
    					  var concessionType = form.down("#concessionType").getValue();
    					  if(concessionType=='FEE_CONCESSION'){
    						  console.log('Remark from grid');
    						  this.getSaveFeeRequestForStudent(grid,'FEE_CONCESSION');
    					  }else{
    						  console.log('Remark from window');
    						  this.getInstallmentForPendingBill(grid);
    					  }
    				  //this.getInstallment(grid);
    		    	  } else{
    		        	  showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_REQUEST_TITLE'), getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD')); 
    		          }
    			  }
    		  },
    		  
    		  'studentfeereqinstallmentwin button[itemId=btnAddInstallment]':{
    			  click:this.addIntallmentContainer
    		  },
    		  
    		  'studentfeereqinstallmentwin button[itemId=saveBtn]':{
    			  click: function() {
    				  this.saveInstallment();
    			  }
    		  },
    		  'studentfeereqinstallmentwin button[itemId=cancelBtn]':{
    			  click:function() {
    				  this.getStudentfeereqinstallmentwin().close();
    			  }
    		  },
    		  'studentfeereqbillwaivergrid':{
    			  render : function(grid){
    				  var portalId = this.getCurrentLoggedPortalId();
    				  if(portalId == 7){
    					  this.disableMoreActionPivileges(grid,this.getPARENT_PORTAL_FEE_REQUEST_PERMISSIONS());
    				  }else{
    					  this.disableMoreActionPivileges(grid,this.getSTUDENT_PORTAL_FEE_REQUEST_PERMISSIONS());
    				  }
    				  
    			  }
    		  }
    	  });
      },
   // **********get Save records for student ,pending billing *****
      getSaveFeeRequestForStudent : function(grid,concessionType){
    	   
    	  var $this = this;
    	 
    	  var form = $this.getStudentfeereqsearchform();
    	  var portalId = this.getCurrentLoggedPortalId();
    	  //var records = grid.selModel.getSelection();
    	  var feerequestModel = new Academia.model.feeandpayment.feerequest.FeeRequestSave();
    	  var concessionType = form.down("#concessionType").getValue();
		  

    	  var submitUrl = SERVERURL.FEE_SERVICE_REQUEST_SETTING_FIND_ID;
    	  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading')
    	  Ext.Ajax.request({
    		  url: submitUrl,
    		  method: 'GET',
    		  params:{
    			  feeRelatedCategory:concessionType,
    			  academyLocation:this.getCurrentAcademyLocation(),
    			  portalId:portalId
    		  },
    		  success: function(response) {
    			  var SRSO = Ext.decode(response.responseText);
    			  var serviceRequestSetting = {
    					  "id":SRSO.id,
    					  "isAutoApprove":SRSO.value
    			  };
    			  if(portalId==7){
    				  var portalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
    				  var studentInfo = portalInfo.student;
    				  var student ={
    						  code: studentInfo.code,
    						  id: studentInfo.id,
    						  value: studentInfo.firstName
    				  }
    			  }else
					{
						var student=$this.getCurrentlyLoggedInUser();
					}
    			  var sponsor  = null;
    			  var requestFor = 'STUDENT';
    			  var chooseAgainst = form.down("#chooseAgainst").getValue();
    			  //var requestDate = Ext.Date.format(new Date(), 'd-m-Y');
    			  //var requestDate = new Date().getTime();
    			  var requestDate = Ext.Date.format(new Date(), 'Y-m-d');
    			  var remarks = '';
    			  
    			  var proxyStore = $this.getStore('feeandpayment.feerequest.TempInstallmentData');
    			  var myItems = proxyStore.getRange();
    			  var installmentJson = new Array();
    			  if(myItems.length>0){
    				var myJson = myItems[0].get("myJson");
    				  for(var j in myJson){
    					  delete myJson[j].remark;
    					  installmentJson.push(myJson[j]);
    				  }
    			  }
    			  
    			  var feeRequestData=[];
    			  
    			  var waiverAmountRequested
    			  var billFeePlanRuleStageId
    			  var feeStageHeadConfigId
    			  var feePlanSubmissionSchedule
    			  if(concessionType == 'INSTALLMENT') {
	    			  var formWin = $this.getStudentfeereqinstallmentwin();
	    			  waiverAmountRequested = formWin.down("#waiverAmountRequested").getValue();
	    			  billFeePlanRuleStageId = formWin.down("#billFeePlanRuleStageId").getValue();
	    			  feeStageHeadConfigId = formWin.down("#feeStageHeadConfigId").getValue();
	    			  feePlanSubmissionSchedule = formWin.down("#feePlanSubmissionSchedule").getValue();
	    			  remarks = formWin.down("#remark").getValue();
	    			  //requestDate = Ext.Date.format(new Date(formWin.down("#requestDate").getValue()), 'd-m-Y');
	    			  requestDate = new Date(formWin.down("#requestDate").getValue()).getTime();
    			  } else if(concessionType == 'FEE_CONCESSION') {
    				  var records = grid.selModel.getSelection();
    				  waiverAmountRequested = records[0].get("waiverAmountRequested");
    				  billFeePlanRuleStageId = records[0].get("billFeePlanRuleStageId");
    				  feeStageHeadConfigId = records[0].get("feeStageHeadConfigId");
    				  feePlanSubmissionSchedule = records[0].get("id");
    				  remarks = records[0].get("remark");
    			  }
    			  //for(var r in records){
    				  /*var amountWaiverRequested=0;
        			  if(records[r].get("waiverAmountRequested")!= null){
        				  amountWaiverRequested =  records[r].get("waiverAmountRequested");
        			  }
					  if(isNullOrEmpty(records[r].data.remark)){
						  	Ext.getBody().unmask();
						  	showWarningMessage(getFeeAndPaymentCommonTranslation('INSERT_REMARK'), getFeeAndPaymentCommonTranslation('PLEASE_INSERT_REMARK'));
						  	return false;
					  }*/
    			  
    			  feeRequestData.push({
    				  "user":student,
    				  "student":student,
    				  "sponsor":$this.getIdValueJson(sponsor),
    				  "billFeePlanRuleStage": $this.getIdValueJson(billFeePlanRuleStageId),
    				  "feeStageHeadConfiguration":$this.getIdValueJson(feeStageHeadConfigId),
    				  "feePlanSubmissionSchedule":$this.getIdValueJson(feePlanSubmissionSchedule),
    				  "waiverAmountRequested":waiverAmountRequested,
    				  "waiverAmountApproved":null,
    				  "requestDate":requestDate,
    				  "requestFor":requestFor,
    				  "category":concessionType,
    				  "remark":remarks,//records[r].get("remark"),
    				  "feeRequestAgainst":chooseAgainst,
    				  "installmentDetails":installmentJson
    			   });
    			  //}
    			  feerequestModel.set("detail",feeRequestData);
    			  feerequestModel.set("serviceRequestSetting",serviceRequestSetting);
    			  feerequestModel.set("enteredBy",student);
    			  feerequestModel.set("requesterType",requestFor);
    			  feerequestModel.set("requester",student);
    			  feerequestModel.set("requestDate",requestDate);
    			  feerequestModel.set("remarks",remarks);
    				   
    			  var submitData = Ext.encode(feerequestModel.data);
    			  var submitUrl = SERVERURL.FEE_REQUEST_DETAILS_CREATE;

    			  Ext.Ajax.request({
    				  url: submitUrl,
    				  jsonData: submitData,
    				  method: 'POST',
    				  success: function(response) {
    					  Ext.getBody().unmask();
    					  grid.getStore().reload();
    					  proxyStore.removeAll();
    					  grid.getSelectionModel().setLocked(false);
    					  grid.getSelectionModel().deselectAll();
    					  
    					  var formWin = $this.getStudentfeereqinstallmentwin();
    					  if(formWin != undefined){
    						  formWin.close();
    					  }
    					  showSuccessMessage(getFeeAndPaymentCommonTranslation('FEE_REQUEST_TITLE'),getFeeAndPaymentCommonTranslation('FEE_REQUEST_CREATED_SUCCESS'));
    					  
    				  }
    			  });
    		  }
    	  });
      },
      
      // *********** installment for pending bills *************
      getInstallmentForPendingBill : function(grid){
    	 
         var record = grid.selModel.getSelection();
    	  
    	  if(record.length>0){
    		  
    	  var formWin = this.getStudentfeereqinstallmentwin();
	      if (!formWin) {
	            Ext.widget('studentfeereqinstallmentwin');
	            formWin = this.getStudentfeereqinstallmentwin();
	       }
	      formWin.down("#id").setValue(record[0].get("billFeePlanRuleStageId"));
	      formWin.down("#studentId").setValue(record[0].get("code"));
	      formWin.down("#studentName").setValue(record[0].get("printName"));
	      formWin.down("#billNo").setValue(record[0].get("billNo"));
	      formWin.down("#feeHead").setValue(record[0].get("feeHeadName"));
	      formWin.down("#amount").setValue(record[0].get("totalBalanceAmount"));
	      formWin.down("#billFeePlanRuleStageId").setValue(record[0].get("billFeePlanRuleStageId"));
	      formWin.down("#feeStageHeadConfigId").setValue(record[0].get("feeStageHeadConfigId"));
	      formWin.down("#feePlanSubmissionSchedule").setValue(record[0].get("feePlanSubmissionSchedule"));
	      formWin.down("#gridType").setValue(grid.itemId);
	      formWin.show();
      }else{
    	  showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_REQUEST_TITLE'), getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD')); 
      }
      },
      getCloseInstallmentWindow : function(){
    	  this.getStudentfeereqinstallmentwin().close();
      },
      
      //********add dyanmic fields**********************
      addIntallmentContainer: function() {
          var this$ = this;
          var form = this$.getStudentfeereqinstallmentwin();
          var panelItem = new Array();
          panelItem.push({
              xtype: 'fieldcontainer',
              width: '100%',
              layout: {
                  type: 'hbox',
                  align: 'bottom'
              },
	           items: [{
		            	  xtype:'datefield',
		            	  itemId:'installmentDueDate',
		            	  name:'installmentDueDate',
		            	  labelAlign: 'top',
		            	  format: CONSTANTS.DATE_FORMAT,
		            	  //--submitFormat: CONSTANTS.DATE_FORMAT,
		            	  allowBlank: false,
//		            	  value:new Date(),
//		            	  minValue:new Date()
		            	  listeners: {
		            		  render: function(obj) {
		            			  obj = dateFormatRender(obj);						
		            			  obj.setMinValue(new Date());
		            			  obj.setValue(new Date());
		            		  }
		            	  }
		              },{
		            	  xtype: 'numberfield',
		            	  itemId: 'installmentAmount',
		            	  labelAlign: 'top',
		            	  name: 'installmentAmount',
		            	  minValue: 0,
		            	  allowDecimals:false,
		            	  allowBlank: false,
		            	  hideTrigger:true,
		            	  mouseWheelEnabled:false
		              },{
		            	  xtype: 'textfield',
		            	  itemId: 'installmentStatus',
		            	  labelAlign: 'top',
		            	  name: 'installmentStatus',
		            	  readOnly:true,
		  				  value:'PENDING',
		            	  allowBlank: false
		              },{
	                      xtype: 'button',
                    	  glyph: ICONGLYPH.DELETEGLYPH,
                    	  cls: 'CustomBodyBtnReject',
                    	  tooltip: getCommonTranslation('DELETETOOLTIP'),
                    	  listeners:{
	                    		click:function(obj){
	                    			var frm = obj.ownerCt.ownerCt.ownerCt;
	                    			var installmentPanel = frm.down('#installmentPanel');
	                    			var container = obj.up('fieldcontainer');
	                    			installmentPanel.remove(container);
	                    			frm.doLayout();
	                    		}
	                    	}
	                    }]    
                 });

          var installmentPanel = form.down('#installmentPanel');
        	  installmentPanel.add(panelItem);
          form.doLayout();
      },
      //**********save installment data in temprary store***********
      saveInstallment : function(){
    	  
    	  var frm = this.getStudentfeereqinstallmentwin();
    	  var form = frm.down('form');
    	  var value = form.getValues();
    	  
    	  var totalInstallmentAmount = 0;
    	  var myJson = new Array();
    	  if (!isEmpty(value["installmentDueDate"])) {
    		  var isArr = isArray(value["installmentDueDate"]);
    		  if (isArr == true) {
    			  for (var i = 0; i < value["installmentDueDate"].length; i++) {
    				  var obj = new Object();
    				  obj.installmentDueDate = value["installmentDueDate"][i];
    				  obj.installmentAmount = value["installmentAmount"][i];
    				  obj.installmentStatus = value["installmentStatus"][i];
    				  obj.remark = value["remark"][i];
    				  myJson.push(obj);
    				  totalInstallmentAmount = parseInt(totalInstallmentAmount) + parseInt(value["installmentAmount"][i]);
    			  }
    		  }else{
    			  var obj = new Object();
    			  obj.installmentDueDate = value["installmentDueDate"];
    			  obj.installmentAmount = value["installmentAmount"];
    			  obj.installmentStatus = value["installmentStatus"];
    			  obj.remark = value["remark"];
    			  myJson.push(obj);
    			  totalInstallmentAmount = value["installmentAmount"];
    		  }
    	  }
    	  
    	  if(value.amount == totalInstallmentAmount){
    		  var data = {"myJson" : myJson};
    		  var store = this.getStore('feeandpayment.feerequest.TempInstallmentData');
    		  store.loadRawData(data, true);
    		  
    		  if(value.gridType == 'studentfeereqbillinstallmentgrid') {
    			  var grid = this.getStudentfeereqbillinstallmentgrid();
    			  this.getSaveFeeRequestForStudent(grid);
    	      }	else if(value.gridType == 'studentfeereqbillwaivergrid') {
    	    	  var grid = this.getStudentfeereqbillwaivergrid();
    			  this.getSaveFeeRequestForStudent(grid);
    	      }  
    		  //this.getCloseInstallmentWindow();
    	  }else{
    		  showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_REQUEST_TITLE'), getFeeAndPaymentCommonTranslation('AMOUNT_AND_INSTALLMENT_AMOUNT_SHOULD_BE_EQUAL')); 
    	  }
      },
      
      //************** lock grids***************
      getLockedGrids : function(){
    	  var form = this.getStudentfeereqsearchform();
    	  var concessionType  = form.down("#concessionType").getValue();
    	  if(concessionType=='INSTALLMENT'){
             this.getStudentfeereqbillinstallmentgrid().getSelectionModel().setLocked(true);
    	  }
    	 },
      
      getLockedWaiverGrids : function(){
    	  var form = this.getStudentfeereqsearchform();
    	  var concessionType  = form.down("#concessionType").getValue();
    	  if(concessionType=='INSTALLMENT'){
    	     this.getStudentfeereqbillwaivergrid().getSelectionModel().setLocked(true);
    	  }
      },
      
      getSelectConcessionType : function(obj,record){
    	  
    	  var value = record[0].get("id");
    	  var structure = this.getFeerequeststructure();
    	  structure.down("#feereqbillwaivergrid").setVisible(false);
    	  structure.down("#feereqbillinstallmentgrid").setVisible(false);
    	 
    	  if(value=='INSTALLMENT'){
    		  structure.down("#feereqbillinstallmentgrid").setVisible(true);
    	  }else{
    		  structure.down("#feereqbillwaivergrid").setVisible(true);
    	  }
      },
      
      //******* get id value json **********
      getIdValueJson: function(id, value) {
  		if (id) return {
  			id: id,
  			value: value
  		};
      },
      
      getAutoLoadFieldsStudentPortal : function(){

    	  var form = this.getStudentfeereqsearchform();

    	  var chooseAgainstField = form.down("#chooseAgainst");
    	  var chooseAgainstStore = chooseAgainstField.getStore();

    	  var concessionTypeField =  form.down("#concessionType");
    	  var concessionTypeStore = concessionTypeField.getStore();

    	  chooseAgainstStore.load({
    		  callback: function(record, operation, success) {
    			  if (success) {
    				  chooseAgainstField.setValue('PENDING_BILLS');
    			  }
    		  }
    	  });

    	  concessionTypeStore.load({
    		  callback: function(record, operation, success) {
    			  if (success) {
    				  concessionTypeField.setValue('INSTALLMENT');
    			  }
    		  }
    	  });
      },
      
      getChooseAgainstAndConcessionTypeForStudentPortal : function(obj,record){

    	  var form = this.getStudentfeereqsearchform();
    	  var chooseAgainst =  form.down("#chooseAgainst").getValue();
    	  var concessionType = form.down("#concessionType").getValue();
    	  
    	  var futureGrid = this.getStudentfeereqbillinstallmentgrid();
    	  var pendingGrid = this.getStudentfeereqbillwaivergrid();

    	  //  var futureGridModel = futureGrid.selModel.getSelection()[0];
    	  // var pendingGridModel = pendingGrid.selModel.getSelection()[0];

    	  pendingGrid.setVisible(false);
    	  futureGrid.setVisible(false);

    	  if(chooseAgainst=='FUTURE_BILLING'){

    		  futureGrid.setVisible(true);
    		  futureGrid.getSelectionModel().setLocked(false);
    		  futureGrid.getSelectionModel().deselectAll();

    		  if(concessionType=='FEE_CONCESSION'){
    			  futureGrid.columns[6].show();
    			  futureGrid.columns[5].hide();
    			  futureGrid.columns[4].show();
    		  }else{
    			  futureGrid.columns[4].hide();
    			  futureGrid.columns[5].hide();
    			  futureGrid.columns[6].hide();
    		  }

    	  }else if(chooseAgainst=='PENDING_BILLS'){

    		  pendingGrid.setVisible(true);
    		  pendingGrid.getSelectionModel().setLocked(false);
    		  pendingGrid.getSelectionModel().deselectAll();

    		  if(concessionType=='FEE_CONCESSION'){
    			  pendingGrid.columns[6].hide();
    			  pendingGrid.columns[5].show();
    			  pendingGrid.columns[7].show();
    		  }else{
    			  pendingGrid.columns[7].hide();
    			  pendingGrid.columns[5].hide();
    			  pendingGrid.columns[6].hide();
    		  }
    	  }
      },
      
   // **********get records based on student Id,billedUserType &adjustmentType *****
      getSearchFeeReqForStudentPortal : function(){
    	  
    	  var structure = this.getStudentfeerequeststructure();

    	  var billInstallment = structure.down("#studentfeereqbillinstallmentgrid");
    	  var billWaiver = structure.down("#studentfeereqbillwaivergrid");
    	  
    	  var form = this.getStudentfeereqsearchform();
    	  var portalId = this.getCurrentLoggedPortalId();
    	  if(portalId==7){
    		  var portalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
    		  var user = portalInfo.student;
    	  }else
    	  {
    		  var user=this.getCurrentlyLoggedInUser();
    	  }
    	  var id = user.id;
    	  var billedUserType = 'STUDENT';
    	  if(!billWaiver.isHidden()){
    		  var adjustmentType = 'RECEIPT';
    		  var store = this.getStore('feeandpayment.feerequest.FeeConcessionDetails');
        	  store.getProxy().extraParams = {
        		  id:id,
        		  billedUserType: billedUserType,
        		  adjustmentType:adjustmentType
        	  };
        	  store.load();
        	  
    	  }else if(!billInstallment.isHidden()){
    		  var store1 = this.getStore('feeandpayment.feerequest.FeeReqBillInstallment');
        	  store1.getProxy().extraParams = {
        		  id:id,
        		  requestFor: billedUserType
        	  };
        	  store1.load();
    	  }
      },
      
    //***********get installment**************
      getInstallmentForStudentPortal : function(grid){
    	 
    	  var record = grid.selModel.getSelection();
    	  
    	  if(record.length>0){
    	  
    	  var formWin = this.getFeereqinstallmentwin();
	      if (!formWin) {
	            Ext.widget('feereqinstallmentwin');
	            formWin = this.getFeereqinstallmentwin();
	       }
	      formWin.down("#id").setValue(record.get("billFeePlanRuleStageId"));
	      formWin.down("#studentId").setValue(record.get("userCode"));
	      formWin.down("#studentName").setValue(record.get("userPrintName"));
	      formWin.down("#billNo").setValue(record.get("billNo"));
	      formWin.down("#feeHead").setValue(record.get("feeHeadName"));
	      formWin.down("#amount").setValue(record.get("totalAmount"));
	      
	      formWin.show();
    	  }else{
    		  showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_REQUEST_TITLE'), getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	  }
      },
      disableMoreActionPivileges: function(gridReference, permissionsMap) {
			var associatedAcadLocationIds = new Array();
			associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
			buttonsToolBar = gridReference.query('toolbar')[0];
			var btnRaiseRequest = gridReference.down('#btnRaiseRequest');
			btnRaiseRequest.setVisible(false);
			Ext.each(permissionList, function(privilege) {
				 if (privilege === 'RAISEREQUEST') {
					if(!isNullOrEmpty(btnRaiseRequest)){
						btnRaiseRequest.setVisible(true);
					}        		
				}
			});
		},
});
