/**
 *  @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.controller.feeandpayment.voucherMode.VoucherModeController',{
	extend: 'Academia.controller.base.BaseController',
	models : ['feeandpayment.voucherMode.VoucherModeInnerList','feeandpayment.reports.VoucherSummaryReportGridModel'],
	stores : ['feeandpayment.voucherMode.VoucherModeList','feeandpayment.accountingConfigurationMapping.IAUAcademyLocationWise',
	          'feeandpayment.voucherMode.VoucherType','feeandpayment.voucherMode.VoucherLinkType',
	          'feeandpayment.voucherMode.VoucherPaymentType','feeandpayment.voucherMode.VoucherPaymentNo',
	          'feeandpayment.voucherMode.VoucherID','feeandpayment.voucherMode.VoucherStatus',
	          'feeandpayment.voucherMode.VoucherFlag','feeandpayment.managebill.BillType',
	          'feeandpayment.voucherMode.VoucherReceiptType','feeandpayment.voucherMode.VoucherBillNo',
	          'feeandpayment.voucherMode.VoucherReceiptNo','feeandpayment.voucherMode.VoucherModeInnerList','feeandpayment.payment.VoucherMode',
	          'feeandpayment.payment.VoucherEntryType','feeandpayment.reports.VoucherSummaryReportGridStore',
	          'feeandpayment.reports.ControlAccountByName','user.UserAcademyLocationStore'],
	views : ['feeandpayment.voucherMode.VoucherModeStructure','feeandpayment.voucherMode.VoucherModeList',
	         'feeandpayment.voucherMode.VoucherModeFilters','feeandpayment.voucherMode.VoucherModeInnerList',
	         'feeandpayment.voucherMode.VoucherModeForm','feeandpayment.voucherMode.VoucherModePanel',
	         'feeandpayment.reports.VoucherSummaryReportStructure','feeandpayment.reports.VoucherSummaryReportFilter',
	         'feeandpayment.reports.VoucherSummaryReportGrid','feeandpayment.reports.VoucherSummaryReportTabStructure'
	         ],
	config:{
		MANAGE_VOUCHER_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_VOUCHER_PRIVILEGES'),
		VOUCHER_SUMMARY_REPORT_ASSOCIATION_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('VOUCHER_SUMMARY_REPORT_ASSOCIATION_PRIVILEGES')
	},         
	refs : [{
		ref:'contentPanel',
		selector:'contentpanel'
	},{
		ref:'voucherModeList',
		selector:'vouchermodelist'
	},{
		ref : 'voucherModeFilters',
		selector : 'vouchermodefilters'
	},{
		ref:'voucherModeForm',
		selector:'vouchermodeform'
	},{
		ref:'voucherModeInnerList',
		selector:'vouchermodeinnerlist'
	},{
		ref:'vouchersummaryreportfilter',
		selector:'vouchersummaryreportfilter'
	},{
		ref:'vouchersummaryreportgrid',
		selector:'vouchersummaryreportgrid'
	},{
		ref:'vouchersummaryreporttabstructure',
		selector:'vouchersummaryreporttabstructure'
	}],
     init : function() {
    	 this.control({
    		 'vouchermodelist':{
    			 render:function(grid){
    				 this.doAccessControlValidation(grid, this.getMANAGE_VOUCHER_PRIVILEGES());
    				 this.disableChangeStatusPivileges(grid,this.getMANAGE_VOUCHER_PRIVILEGES());
    			 },
				afterrender:function(grid){
					var me = this;
					setTimeout(function(){
						me.addDataGridConfigButton(grid, me.getMANAGE_VOUCHER_PRIVILEGES());
					},1500);
					
					/* for checking verification required - yes/no*/
					var verifyVoucherBtn = grid.down('#btnVerifyVoucher');
					 Ext.Ajax.request({
						 method: "GET",
						 type: 'rest',
						 url: SERVERURL.ORGINFOLOADREQUEST,
						 success: function(response, action) {
							 var data = JSON.parse(response.responseText);
							 if(data.isVoucherVerificationRequired){
								 verifyVoucherBtn.setVisible(true);
							 }else{
							 	verifyVoucherBtn.setVisible(false);
							 }
							 
						 }
					 });
					 
					},						
	         	selectionchange: function(column, selected,eOpts ){
		
                	this.disableVoucherGridExportButton(column,selected);                	
                }
    			 /*afterrender : function(grid){
       				 var structure = grid.up('vouchermodestructure');
       				 this.getGridHeaderFreeze(grid,structure);
        		 },*/
    		 },

			'vouchermodeinnerlist':{
    			 render:function(grid){
    				 this.doAccessControlValidation(grid, this.getMANAGE_VOUCHER_PRIVILEGES());
    			 	},
				 afterrender:function(grid){
					var me = this;
					setTimeout(function(){
					me.addDataGridConfigButton(grid, me.getMANAGE_VOUCHER_PRIVILEGES());
											},1500);
					}
    		 },

    		 'vouchermodepanel':{
    			 afterrender : function(structure){
       				 var grid = structure.down('vouchermodelist');
       				 this.getGridHeaderFreezeVoucherCls(grid,structure);
        		 },
    		 },
    		 'vouchermodefilters':{
    			 render : this.voucherModeFiltersRender
    		 },
    		 'vouchermodefilters button[itemId=searchBtn]':{
    			 click : this.getSearchVoucherList
     		 },
     		 'vouchermodefilters button[itemId=resetBtn]':{
     			 click : function(obj){
     				 var form = obj.up('form').getForm();
     				 form.getFields().each(function(field) {
     					 if(field.name != 'voucherLinkType') {
     						field.reset();
     					 }
     				 });
     		    	 var academyLocationId = this.getCurrentAcademyLocation();
     		    	 var brandCampusId = form.findField('multiBrandCampusName');
     		    	 var aLComboStore = brandCampusId.getStore();
     		    	 aLComboStore.load({
     		    		 callback: function(records, operation, success) {
     		    			 if (success) {
     		    				 for(var i in records){
     		    					 if(records[i].data.id == academyLocationId){
     		    						 brandCampusId.setValue(academyLocationId);
     		    					 }
     		    				 }
     		    			 }
     		    		 }
     		    	 });
     			 }
     		 },
    		 'vouchermodelist button[itemId=btnChangeStatus]':{
                 click : this.getVoucherModeStatus
     		 },
     		 'vouchermodelist button[itemId=btnView]':{
                click : this.getViewVoucherMode
    		 },
    		 'vouchermodefilters customcombobox[itemId=voucherLinkType]' :{
    			 select : this.getChangeFields
    		 },
    		 /*'vouchersummaryreporttabstructure':{
    			 afterrender : function(structure){
       				 var grid = structure.down('vouchersummaryreportgrid');
       				 this.getGridHeaderFreeze(grid,structure);
        		 }
    		 },*/
    		 'vouchersummaryreportfilter button[itemId=resetBtn]':{
    			 click : this.getResetVoucherSummaryReport
    		 },
    		 'vouchersummaryreportfilter button[itemId=searchBtn]':{
    			 click : this.getSearchVoucherSummaryReport
    		 },
    		 'vouchersummaryreportfilter customcombobox[itemId=voucherTransactionType]':{
    			 select : this.getChangeFieldsVoucherSummary
    		 },
    		 'vouchersummaryreportfilter customcombobox[itemId=organizationUnit]':{
    			 select : this.getOrganizationUnit
    		 },
    		 'vouchersummaryreportgrid':{
    			
    			 render:function(grid){
    				 
    				 this.doAccessControlValidation(grid, this.getVOUCHER_SUMMARY_REPORT_ASSOCIATION_PRIVILEGES());
    				 //this.disableChangeStatusPivileges(grid,this.getVOUCHER_SUMMARY_REPORT_ASSOCIATION_PRIVILEGES()
    			 },
                     afterrender:function(structure){
                        var me = this;
			            setTimeout(function(){
							me.addDataGridConfigButton(structure, me.getVOUCHER_SUMMARY_REPORT_ASSOCIATION_PRIVILEGES());
						},1500);
    			 } 
    		 },
 	        'vouchermodelist button#exportToXMLBtn': {
	        	click: function(button) {
	        		var grid = this.getVoucherModeList();
	        	  this.exportToXMLVouchers('xml',grid);
    			}
	        },
	        'vouchermodelist button[itemId=btnVerifyVoucher]':{
              //  click : this.getVoucherModeStatus
                click : this.verifyVouchers
    		 },
    	 });
     },
     /*
      * after filter render , it will call
      */
     voucherModeFiltersRender : function(obj){
    	 
    	 var academyLocationId = this.getCurrentAcademyLocation();
    	 var form = this.getVoucherModeFilters();
    	 var voucherLinkType = form.down("#voucherLinkType");
    	 var brandCampusId = form.down('#multiBrandCampusItemId');
    	 var voucherStatus = form.down('#voucherStatus');
    	 var aLComboStore = brandCampusId.getStore();
    	 var voucherStatusStore = voucherStatus.getStore();
    	 var store = voucherLinkType.getStore();
    	 store.load({
    		 callback: function(rec, operation, success) {
    			 if (success) {
    				 voucherLinkType.setValue(rec[1].get("id"));
    			 }
    		 }
    	 });
    	 
    	 aLComboStore.load({
    		 callback: function(records, operation, success) {
    			 if (success) {
    				 for(var i in records){
    					 if(records[i].data.id == academyLocationId){
    						 brandCampusId.setValue(academyLocationId);
    					 }
    				 }
    			 }
    		 }
    	 });
    	 
    	 voucherStatusStore.load({
    		 callback: function(records, operation, success) {
    			 if (success) {
    				 for(var i in records){
    					 if(records[i].data.id == "CREATED"){
    						 voucherStatus.setValue(records[i].data.id);
    					 }
    				 }
    			 }
    		 }
    	 });
    	 
     },
     /*
      * fields will show based on voucher link type
      */
     getChangeFields : function(obj,record){
    	 var form = obj.up('form');
    	 var voucherLinkType = record[0].get("id");

    	 var billType = form.down("#billType");
    	 var billNo = form.down("#billNo");
    	 var receiptType = form.down("#receiptType");
    	 var receiptNo = form.down("#receiptNo");
    	 var paymentType = form.down("#paymentType");
    	 var paymentNo = form.down("#paymentNo");

    	 billType.reset();
    	 billNo.reset();
    	 receiptType.reset();
    	 receiptNo.reset();
    	 paymentType.reset();
    	 paymentNo.reset();

    	 form.down("#paymentDetailId").setVisible(false);
    	 form.down("#receiptDetailId").setVisible(false);
    	 form.down("#billDetailId").setVisible(false);

    	 switch(voucherLinkType){
    	 case 'BILL' :{
    		 form.down("#billDetailId").setVisible(true);
    		 break;
    	 }
    	 case 'RECEIPT' :{
    		 form.down("#receiptDetailId").setVisible(true);
    		 break;
    	 }
    	 case 'PAYMENT':{
    		 form.down("#paymentDetailId").setVisible(true);
    		 break;
    	 }
    	 }
     },
     /**
      * Open control Account Win
      */
     openVoucherModeTab : function(){
    	 var contentpanel = this.getContentPanel();
    	 var structure = Ext.widget('vouchermodeform');
    	 var tabName = getFeeAndPaymentCommonTranslation('VOUCHER_MODE_DETAIL');
    	 var getcontroller=this.getController('menu.CoreERPNavigationController');
    	 var getTab=getcontroller.getTab(tabName);
    	 if(getTab!=null){
    		 contentpanel.remove(getTab, true);
    	 }
    	 openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_FIVE);
     },
     /**
      * Close Control Account Win
      */
     getSearchVoucherList : function(obj){
    	 	var $this = this;
	    	var form = obj.up('form');
	    	form.down('#searchBtn').setDisabled(true);
	    	var getForm = form.getForm();
	    	var getFormValues = getForm.getValues();
	    	
	    	var grid = this.getVoucherModeList();

			grid.config.searchFilterForm = form;

	    	var store = grid.getStore();
	    	grid.getSelectionModel().deselectAll();
	    	
	    	var academyLocationId = getFormValues.multiBrandCampusName;
	    	var alids=[];
      		var academyLocationIds=null;
      		if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
				for (var i in academyLocationId) {
					if (Ext.isObject(academyLocationId[0])) {
						alids.push(academyLocationId[i].get("id"));
					} else {
						alids.push(academyLocationId[i]);
					}
				}
				academyLocationIds = alids.join();
			}
			else if(!isNullOrEmpty(academyLocationId)){
				academyLocationIds = academyLocationId;
			}
	    	store.getProxy().extraParams = {
	    		academyLocationId: academyLocationIds,
	    		iauId: getFormValues.organizationUnit,
	    		voucherType : getFormValues.voucherType,
	    		voucherLinkType : getFormValues.voucherLinkType,
	    		billType : getFormValues.billType,
	    		receiptType : getFormValues.receiptType,
	    		paymentType : getFormValues.paymentType,
	    		voucherStatus : getFormValues.voucherStatus,
	    		voucherId:form.down("#voucherId").getRawValue(),
	    		fromDate : getFormValues.dateFrom,
	    		tillDate:getFormValues.dateTill,
	    		voucherFlag : getFormValues.voucherFlag,
	    		billNo:form.down("#billNo").getRawValue(),
	    		receiptNo:form.down("#receiptNo").getRawValue(),
	    		paymentNo:form.down("#paymentNo").getRawValue()
	    	},
	    	$this.resetPageSetting(store)
	    	store.load({
	    		 callback: function(rec, operation, success) {
	    			 form.down('#searchBtn').setDisabled(false);
	    		 }
	    	 });
     },
     
     
     
     /*
      * 
      * fee voucher summary report search filter
      * 
      * 
      * 
      * */
     
     getSearchVoucherSummaryReport : function(obj){
 	 	var $this = this;
	    	var form = obj.up('form');
	    	form.down('#searchBtn').setDisabled(true);
	    	var getForm = form.getForm();
	    	var getFormValues = getForm.getValues();
	    	
	    	var grid = this.getVouchersummaryreportgrid();
	    	grid.config.searchFilterForm = form;
	    	
	    	var store = grid.getStore();
	    	
	    	var fromDate = form.down("#fromdate").getValue();
    		var tillDate = form.down("#todate").getValue();
    		
    		if(fromDate != null){
    			fromDate= new Date(fromDate);
    			fromDate = Ext.Date.format(fromDate, 'Y-m-d');
             }
            
            if(tillDate != null){
            	tillDate= new Date(tillDate);
            	tillDate = Ext.Date.format(tillDate, 'Y-m-d');
             }
	    	
	    	store.getProxy().extraParams = {
	    		iauId: getFormValues.organizationUnit,
	    		voucherMode : getFormValues.voucherType,
	    		transactionType : getFormValues.voucherTransactionType,
	    		billType : getFormValues.billType,
	    		receiptType : getFormValues.receiptType,
	    		paymentType : getFormValues.paymentType,
	    		Entrytype : getFormValues.voucherStatus,
	    		voucherId:form.down("#voucherId").getRawValue(),
	    		controlAccountId:getFormValues.controlAccountId,
	    		fromDate : fromDate,
	    		tillDate: tillDate,
	    		voucherFlag : getFormValues.voucherFlag,
	    		billNo:form.down("#billNo").getRawValue(),
	    		receiptNo:form.down("#receiptNo").getRawValue(),
	    		paymentNo:form.down("#paymentNo").getRawValue()
	    	
	    	},
	    	$this.resetPageSetting(store)
	    	
	    	store.load({
				 callback: function(record, operation, success) {
					 form.down('#searchBtn').setDisabled(false);
					 if (record.length > 0) {
						 for(var i in record){
           				if (record[i].data.academyLocationBaseCurrency != null) {
           					this$.toggleGridSummaryRow(grid,false); 
           				}else{
           					this$.toggleGridSummaryRow(grid,true);
           				}
						 }
					 }else{
						$this.toggleGridSummaryRow(grid,false);
					 }
				 }
			});
	    	
  },
  
  	getResetVoucherSummaryReport:function(obj){

 	 var form = obj.up('form');
 	 
 	 form.getForm().reset(); 	 
 	 var billType = form.down("#billType");
 	 var billNo = form.down("#billNo");
 	 var receiptType = form.down("#receiptType");
 	 var receiptNo = form.down("#receiptNo");
 	 var paymentType = form.down("#paymentType");
 	 var paymentNo = form.down("#paymentNo");

 	 billType.reset();
 	 billNo.reset();
 	 receiptType.reset();
 	 receiptNo.reset();
 	 paymentType.reset();
 	 paymentNo.reset();

 	 form.down("#paymentDetailId").setVisible(false);
 	 form.down("#receiptDetailId").setVisible(false);
 	 form.down("#billDetailId").setVisible(false);
	 form.down("#searchBtn").setDisabled(true);
	 form.down("#todate").reset();
	 form.down("#fromdate").reset();
	 form.down("#todate").setMinValue(false);
	 form.down("#todate").setMaxValue(false);
	 form.down("#fromdate").setMinValue(false);
	 form.down("#fromdate").setMaxValue(false);
	 
  },
  
     /**
      * 
      */
     getViewVoucherMode : function(){
    	 var $this = this;
    	 var grid = this.getVoucherModeList();
    	 if (grid.getSelectionModel().getCount() > 0) {
    		 var record = grid.selModel.getSelection();
    		 if(record.length == 1){
    			 this.openVoucherModeTab();
    			 var form = this.getVoucherModeForm();
    			 var id = record[0].get("id");
    			 var editUrl = SERVERURL.VOUCHER_MODE_FORM_FINDBYID;
    			 Ext.Ajax.request({
    				 method: "GET",
    				 type: 'rest',
    				 url: editUrl,
    				 params: {
    					 id: id
    				 },
    				 success: function(f, action) {
    					 var data = Ext.JSON.decode(f.responseText);
    					 var personModel = new Academia.model.feeandpayment.voucherMode.VoucherModeInnerList(data);
    					 form.loadRecord(personModel);

    					 var innerGrid = $this.getVoucherModeInnerList();
    					 var store = innerGrid.getStore();
    					 store.getProxy().extraParams = {
    						 id: id
    					 };
    					 store.load();
    					 form.down("#billtotalAmount").setValue(currencyRenderer(personModel.get("totalAmount"),personModel.get("currencyId")));
    					 form.down("#totalAmount").setValue(currencyRenderer(personModel.get("totalAmount"),personModel.get("currencyId")));
    					 form.down("#voucherDate").setValue(dateRender(personModel.get("voucherDate")));
    					 form.down("#voucherStatus").setValue(getCommonTranslation(personModel.get("voucherStatus")));
    					 form.down("#postingDate").setValue(dateRender(personModel.get("postingDate")));
    					 form.down("#consolidationDate").setValue(dateRender(personModel.get("consolidationDate")));
    				 }
    			 });
    		 }else{
    			 showWarningMessage(getFeeAndPaymentCommonTranslation('VOUCHER_MODE'), getFeeAndPaymentCommonTranslation('PLEASE_SELECT_ONE_RECORD')); //Please select a record
    		 }
    	 }else{
    		 showWarningMessage(getFeeAndPaymentCommonTranslation('VOUCHER_MODE'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record 
    	 }
     },
     getVoucherModeStatus : function(){
    	 var grid = this.getVoucherModeList();
    	 var grdStore = grid.getStore();
    	 var records = grid.selModel.getSelection();
    	 if(records.length > 0){
    		 var myjson = [];
    		 var jsonData = {};
    		 for(var i in records){
    			 myjson.push(records[i].get("id")); 
    		 }
    		 jsonData =  myjson;
    		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		 Ext.Ajax.request({
    			 method: "POST",
    			 jsonData: jsonData,
    			 type: 'rest',
    			 url: SERVERURL.VOUCHER_STATUS_UPDATE,
    			 headers: {
    				 'Content-Type': 'application/json'
    			 },
    			 success : function(response, action) {
    				 Ext.getBody().unmask();
    				 grdStore.reload();
    				 grid.getSelectionModel().deselectAll();
    				 showSuccessMessage(getFeeAndPaymentCommonTranslation('VOUCHER_MODE'), getFeeAndPaymentCommonTranslation('VOUCHER_STATUS_UPDATED_SUCCESSFULLY'));
    			 }
    		 });
    	 }else{
    		 showWarningMessage(getFeeAndPaymentCommonTranslation('VOUCHER_MODE'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record 
    	 }
     },
   //disable Change Status button************************************************************8
     disableChangeStatusPivileges: function(gridReference,permissionsMap) {
     	
     	var associatedAcadLocationIds = new Array();
 		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
 		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
 		var buttonsToolBar = gridReference.query('toolbar')[0];
 	 	var exportToXMLBtn = gridReference.down('#exportToXMLBtn');
    	var btnChangeStatus = gridReference.down('#btnChangeStatus');
    	var btnVerifyVoucherBtn = gridReference.down('#btnVerifyVoucher');
    	exportToXMLBtn.setVisible(false);
    	btnChangeStatus.setVisible(false);
    	btnVerifyVoucherBtn.setVisible(false);
 		//var splitbuttons = buttonsToolBar.query('splitbutton')[0];
 		//splitbuttons.setVisible(false);
     	/*Ext.each(splitbuttons.menu.items.items, function(menuItems) {
 			menuItems.setVisible(false);
     	});*/
     	Ext.each(permissionList, function(privilege) {	
     		if (privilege === 'EXPORT_TO_XML') {
         		var button = buttonsToolBar.query('#exportToXMLBtn')[0];
         		if(!isNullOrEmpty(button)){
         			button.setVisible(true);
         		}        		
         	}
     		if (privilege === 'CHANGESTATUS') {
         		var button = buttonsToolBar.query('#btnChangeStatus')[0];
         		if(!isNullOrEmpty(button)){
         			button.setVisible(true);
         		}        		
         	}
     		if (privilege === 'VERIFY_VOUCHERS') {
         		var button = buttonsToolBar.query('#btnVerifyVoucher')[0];
         		if(!isNullOrEmpty(button)){
         			button.setVisible(true);
         		}        		
         	}
     	
     	});
     },
     
     getChangeFieldsVoucherSummary : function(obj,record){
    	 
    	 var form = obj.up('form');
    	 var voucherLinkType = record[0].get("id");

    	 var billType = form.down("#billType");
    	 var billNo = form.down("#billNo");
    	 var receiptType = form.down("#receiptType");
    	 var receiptNo = form.down("#receiptNo");
    	 var paymentType = form.down("#paymentType");
    	 var paymentNo = form.down("#paymentNo");

    	 billType.reset();
    	 billNo.reset();
    	 receiptType.reset();
    	 receiptNo.reset();
    	 paymentType.reset();
    	 paymentNo.reset();

    	 form.down("#paymentDetailId").setVisible(false);
    	 form.down("#receiptDetailId").setVisible(false);
    	 form.down("#billDetailId").setVisible(false);

    	 switch(voucherLinkType){
    	 case 'BILL' :{
    		 form.down("#billDetailId").setVisible(true);
    		 break;
    	 }
    	 case 'RECEIPT' :{
    		 form.down("#receiptDetailId").setVisible(true);
    		 break;
    	 }
    	 case 'PAYMENT':{
    		 form.down("#paymentDetailId").setVisible(true);
    		 break;
    	 }
    	 }
     },
     
     getOrganizationUnit:function(obj,record){
    	 var form = obj.up('form');
    	 form.down("#searchBtn").setDisabled(false);
     },
     exportToXMLVouchers: function(fileType,grid) {
    	 
     	var studentId=0;
     	var admissionId=0;
     	if (grid.getSelectionModel().getCount() > 0) {
     		setTimeout(function(){
     			
     			var msg = '<span style="font-weight: 600;font-size: 16px;letter-spacing: 0.5px;color: black;">'+ getFeeAndPaymentCommonTranslation('FP_MANAGE_VOUCHER')+'</span><br><span style="font-size: 12px;text-align: left;color: black;top: -3px;position: relative;">'+getFeeAndPaymentCommonTranslation('XML_FILE_DOWNLOADED_SUCCESS_MESSAGE')+'</span>';
				var box2 =Ext.Msg.show({
				//title: getCommonTranslation('TITLE_QUARTZ_DETAIL'),
				msg	: msg,
				buttons	: Ext.MessageBox.OK,
				icon: Ext.Msg.INFO,
				cls: 'successMessageBox commonMsgBoxCls newClsMessageSuccessBox',
				fn	: function(response){
					if(response=="ok"){
						grid.getStore().reload();
					}
				}
				});	
				box2.removeCls('newClsMessageConfirmBox');
				box2.dockedItems.items[1].layout.pack = "end";
				box2.doLayout();
				box2.dockedItems.items[1].items.items[0].setUI('CustomBtnSubmit');
			}, 1200);
     		var record = grid.getSelectionModel().getSelection();
     		var voucherIdtemp=[];
     		for(var i in record){
     			voucherIdtemp.push(record[i].get("id"));
     		}
     		grid.getStore().commitChanges();
     		grid.getSelectionModel().deselectAll();

     		voucherId=voucherIdtemp.join();

     		user=this.getCurrentlyLoggedInUser();
     		// code to identify jasper
     		//var code ="ID_CARD_BACK";
     		var reportParams =new Object();
     		reportParams.userId=user.code;
     		reportParams.ids=String(voucherId); // convert int into string
     		var form = this.getVoucherModeFilters();
     		var linkType = form.down('#voucherLinkType');
     		var reportTitle=linkType.getValue();
     		reportTitle = (reportTitle.charAt(0).toUpperCase() + reportTitle.slice(1).toLowerCase()).concat('s');
     		var exportUrl = SERVERURL.PATH_EXPORTTOXMLVOUCHER;
     		this.exportJRXMLReport("blank",reportParams,reportTitle,"xml",exportUrl);

     	}
     },
     disableVoucherGridExportButton:function(column,selected) {
     	var grid = this.getVoucherModeList();
     	var exportButtonItemId = grid.down('#exportToXMLBtn');
     	exportButtonItemId.setDisabled(true);
     	var counter = 0;
     	selected.forEach(function(obj){
     		var postedStatus=obj.getData().voucherStatus;
     		if(!isNullOrEmpty(postedStatus)){
     			if(postedStatus == 'CREATED'){
     				counter = counter+1;
     			}
     		}
     		if(counter>0){
     			exportButtonItemId.setDisabled(false);
     		}else{
     			exportButtonItemId.setDisabled(true);
     		}
     	});
     },
     verifyVouchers : function(){
    	 var grid = this.getVoucherModeList();
    	 var grdStore = grid.getStore();
    	 var records = grid.selModel.getSelection();
    	 if(records.length > 0){
    		 var myjson = [];
    		 var jsonData;
    		 for(var i in records){
    			 myjson.push(records[i].get("id")); 
    		 }
    		 jsonData =  myjson.join();
    		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		 Ext.Ajax.request({
    			 method: "GET",
    			 type: 'rest',
    			 url: SERVERURL.PATH_VERIFY_VOUCHER,
    			 headers: {
    				 'Content-Type': 'application/json'
    			 },
    			 params: {
    				 ids: jsonData
    			 },
    			 success : function(response, action) {
    				 Ext.getBody().unmask();
    				 grdStore.reload();
    				 grid.getSelectionModel().deselectAll();
    				 showSuccessMessage(getFeeAndPaymentCommonTranslation('VOUCHER_MODE'), getFeeAndPaymentCommonTranslation('Transaction Completed Successfully'));
    			 }
    		 });
    	 }else{
    		 showWarningMessage(getFeeAndPaymentCommonTranslation('VOUCHER_MODE'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record 
    	 }
     },
     
});
