/*
 *  @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.controller.hostel.reports.ManageAllocationReportController', {
	extend : 'Academia.controller.base.BaseController',
	
	models : [],
	
	stores : ['hostel.manageroomtype.RoomType','hostel.managehostel.hostel.RestrictionType','attendance.UserGroup',
	          'hostel.managehostel.hostel.HostelCodeName','user.UserAcademyLocationStore','hostel.managehostel.floor.RoomCodeName',
	          'hostel.managehostel.floor.FloorCodeName','hostel.managehostel.building.BuildingCodeName','hostel.managehostel.room.RoomDetailsStatus',
	          'hostel.roomallocation.UserSmartSearchByUserType','hostel.roomallocation.userwise.UserWiseList',
	          'criteriabuilder.userquicksearch.QuickSearchName','hostel.roomallocation.userwise.CancelAllotmentList',
	          'hostel.roomallocation.userwise.CancellationReasonCombo','hostel.roomallocation.userwise.BedNoCombo',
	          'hostel.roomallocation.userwise.CheckOutReasonCombo','hostel.roomallocation.userwise.OccupiedBedsGridS',
	          'hostel.manageallocation.manageallocationuserwise.ManageUserWiseList','hostel.managehostel.floor.ManageFloorCodeName',
	          'hostel.roomallocation.userwise.AvailableBedsGridS','hostel.managehostel.hostel.ManageHostelCodeName','hostel.managehostel.building.ManageBuildingCodeName',
	          'hostel.reports.ManageAllocationReportStore','hostel.managehostel.room.RoomStatus','hostel.roomallocation.UserSmartSearchForOccupant'
	          ,'enquiry.studentDetail.GenderStore', 'Academia.store.common.GenderTypeStore'],
	          
	views : ['hostel.reports.manageallocationreport.ManageAllocationReportStructure',
	         'hostel.reports.manageallocationreport.ManageAllocationSearchReport','hostel.roomallocation.userwise.OccupiedBedsGrid',
	         'hostel.reports.manageallocationreport.ManageAllocationGridReport','hostel.roomallocation.userwise.OccupiedBedDetailsWin',
	         'hostel.roomallocation.userwise.AvailableBedDetailsWin','hostel.roomallocation.userwise.AvailableBedDetailsGrid'
	         ],
	         
	         config: {
	        	 ROOM_OCCUPANCY_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ROOM_OCCUPANCY_REPORT_PRIVILEGES'),
	         },
	         
	         refs :[{
	        	 ref: 'manageallocationsearchreport',
	        	 selector: 'manageallocationsearchreport'
	         },{
	        	 ref: 'manageallocationgridreport',
	        	 selector: 'manageallocationgridreport'
	         },{
	        	 ref: 'occupiedbeddetailswin',
	        	 selector: 'occupiedbeddetailswin'
	         },{
	        	 ref: 'occupiedbedsgrid',
	        	 selector: 'occupiedbedsgrid'
	         },{
	        	 ref: 'availablebeddetailswin',
	        	 selector: 'availablebeddetailswin'
	         },{
	        	 ref: 'availableBeddetailswin',
	        	 selector: 'availablebeddetailswin form'
	         },{
	        	 ref: 'availablebeddetailsgrid',
	        	 selector: 'availablebeddetailsgrid'
	         }],

	init : function() {
		this.control({
	
			'manageallocationsearchreport combo[itemId=userType]':{
				select:function(combo,record){
					var userTypeId = record[0].get("id");
					var form = combo.up('form');
					var studentName = form.down('#studentName');
					studentName.setDisabled(false);
					var store = studentName.getStore();
					
					store.getProxy().extraParams = {
						userType: userTypeId
					};
					store.load();
					
					var genderId = form.down('#genderId');
					if (userTypeId == 3)  {
						genderId.setVisible(true);
					} else {
						genderId.setVisible(false);
					}
				}
			},
			'manageallocationsearchreport combo[itemId=academyLocation]':{
				render:function(combo){
					var store = combo.getStore();
					store.getProxy().extraParams = {
						id: this.getCurrentlyLoggedInUser().id
					};
					store.load({
						callback:function(records, operation, success){
							if (success) {
								if(records.length == 1){
									combo.setValue(records[0].get("id"));									
								}
							}
						}
					});

				},
				select:function(combo,record){
					var alId = record[0].get("id");
					var form = combo.up('form');
					var hostelCodeName = form.down('#hostelCodeName');
					hostelCodeName.clearValue();
					var store = hostelCodeName.getStore();
					store.getProxy().extraParams = {
						academyLocationId: alId
					};
					store.load();
				}
			},
			'manageallocationsearchreport button[itemId=searchButtonId]':{
				click:function(obj){
					this.loadUserOrRoomWiseRecord(obj);
				}
			},
			'manageallocationsearchreport button[itemId=resetButtonId]':{
				click:function(obj){
					this.resetUserWise(obj);
				}
			},
			'manageallocationgridreport':{
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					
					var manageuserwiselist = this.getManageallocationgridreport();
					var columnName=manageuserwiselist.columnManager.columns[cellIndex].dataIndex;
					
					if(columnName=='noOfBeds'){
						if (e.target.tagName == 'A') {
							var manageHostelController=  Academia.app.getController('Academia.controller.hostel.managehostel.ManageHostelController');
							manageHostelController.openListOfBedWin(grid, rowIndex, record);
						}
					}
					if(columnName=='noOfOccupiedBeds'){
						if (e.target.tagName == 'A') {
							this.showOccupiedBedsDetails(grid, rowIndex, record);
						}
					}
					if(columnName=='noOfAvailableBeds'){
						if (e.target.tagName == 'A') {
							this.showAvailableBedsDetails(grid, rowIndex, record);
						}
					}
				},
				render:function(grid){
					this.doAccessControlValidation(grid, this.getROOM_OCCUPANCY_REPORT_PRIVILEGES());
				}
			},
			'manageallocationsearchreport':{
				render:function(){
					var form = this.getManageallocationsearchreport();
					var buildingCodeName  = form.down('#buildingCodeName');
					var floorCodeNoField  = form.down('#floorCodeNo');
					var roomNoField  = form.down('#roomNo'),
			 		userTypeField  = form.down('#userType');

					var buildingCodeStore =  buildingCodeName.getStore();
					var floorCodeNo = floorCodeNoField.getStore();
					var roomNo = roomNoField.getStore(),
					userTypeFldStore = userTypeField.getStore();

					var values = form.getForm().getValues();

					buildingCodeStore.getProxy().extraParams = {
						hostelCode:values.hostelCodeName,
						status:values.status,
						resourceGroup:'Building'
					};
					buildingCodeStore.load();

					floorCodeNo.getProxy().extraParams = {
						buildingCode:values.floorCodeNo,
						status:values.status,
						resourceGroup:'Floor'
					};
					floorCodeNo.load();

					roomNo.getProxy().extraParams = {
						floorCode:values.roomNo,
						status:values.status,
						resourceGroup:'Room'
					};
					roomNo.load();
					
					userTypeFldStore.load({
						callback:function(records, operation, success){
							if(records.length > 0){
								var rec = userTypeFldStore.findRecord('userGroupName',getCommonTranslation('STUDENT'));
								if(rec){
									userTypeField.setValue(rec.data.id);	
									var studentName = form.down('#studentName');
									var store = studentName.getStore();
									store.getProxy().extraParams = {
										userType: rec.data.id
									};
									store.load();
								}
							}
						}
					});
				}
			},
			'manageallocationsearchreport customcombobox[itemId=hostelCodeName]':{
				select: function(obj,record){
					var form = obj.up('form');
					var hostelCode = record[0].get("id");
					var buildingCodeName  = form.down('#buildingCodeName');
					buildingCodeName.clearValue();
					var buildingCodeStore =  buildingCodeName.getStore();

					var values = form.getForm().getValues();
					
						buildingCodeStore.getProxy().extraParams = {
							hostelCode:hostelCode,
							status:values.status
						};
						buildingCodeStore.load();
				}
			},
			'manageallocationsearchreport customcombobox[itemId=buildingCodeName]':{
				select: function(obj,record){
					var form = obj.up('form');
					var buildingCode = record[0].get("id");
					var floorCodeName  = form.down('#floorCodeNo');
					floorCodeName.clearValue();
					var floorCodeStore =  floorCodeName.getStore();

					var values = form.getForm().getValues();
					
						floorCodeStore.getProxy().extraParams = {
							buildingCode:buildingCode,
							status:values.status,
							resourceGroup:'Floor'
						};
						floorCodeStore.load();
					}
			},
			'manageallocationsearchreport customcombobox[itemId=floorCodeNo]':{
				select: function(obj,record){
					var form = obj.up('form');
					var floorCode = record[0].get("id");
					var roomNoField  = form.down('#roomNo');
					roomNoField.clearValue();
					var roomStore =  roomNoField.getStore();

					var values = form.getForm().getValues();
					
//					if(values.hostelType == 'ROOM'){
						roomStore.getProxy().extraParams = {
							floorCode:floorCode,
							status:values.status,
							resourceGroup:'Room'
						};
						roomStore.load();
					}
//				}
			}
		});
	},
	onRenderStoreLoad:function(){
		var form = this.getManageallocationsearchreport();
		var hostelCodeName  = form.down('#hostelCodeName');
		var buildingCodeName  = form.down('#buildingCodeName');
		var floorCodeNoField  = form.down('#floorCodeNo');
		var roomNoField  = form.down('#roomNo'),
 		userTypeField  = form.down('#userType');

		var hostelCodeNameStore =  hostelCodeName.getStore();
		var buildingCodeStore =  buildingCodeName.getStore();
		var floorCodeNo = floorCodeNoField.getStore();
		var roomNo = roomNoField.getStore(),
		userTypeFldStore = userTypeField.getStore();

		var values = form.getForm().getValues();

		hostelCodeNameStore.getProxy().extraParams = {
			hostelCode:values.hostelCodeName,
			status:values.status,
			resourceGroup:'Hostel'
		};
		hostelCodeNameStore.load();
		
		buildingCodeStore.getProxy().extraParams = {
			hostelCode:values.hostelCodeName,
			status:values.status,
			resourceGroup:'Building'
		};
		buildingCodeStore.load();

		floorCodeNo.getProxy().extraParams = {
			buildingCode:values.floorCodeNo,
			status:values.status,
			resourceGroup:'Floor'
		};
		floorCodeNo.load();

		roomNo.getProxy().extraParams = {
			floorCode:values.roomNo,
			status:values.status,
			resourceGroup:'Room'
		};
		roomNo.load();
		
		userTypeFldStore.load({
			callback:function(records, operation, success){
				if(records.length > 0){
					var rec = userTypeFldStore.findRecord('userGroupName',getCommonTranslation('STUDENT'));
					if(rec){
						userTypeField.setValue(rec.data.id);	
						var studentName = form.down('#studentName');
						var store = studentName.getStore();
						store.getProxy().extraParams = {
							userType: rec.data.id
						};
						store.load();
					}
				}
			}
		});
	},
	resetUserWise:function(obj){
		var form = obj.up('form');
		form.getForm().reset();
		//form.down('#studentName').setDisabled(true);
		this.onRenderStoreLoad();
	},
	showOccupiedBedsDetails:function(grid, rowIndex, record){
		var $this = this;
		var formWindow = $this.getOccupiedbeddetailswin();
		if (!formWindow) {
			Ext.widget('occupiedbeddetailswin');
			formWindow = $this.getOccupiedbeddetailswin();
		}
		formWindow.show();

		var store = $this.getOccupiedbedsgrid().getStore();
		store.getProxy().extraParams = {
			hostelRoomId:record.data.hostelRoomId
		};
		store.load();

	},
	showAvailableBedsDetails:function(grid, rowIndex, record){
		var $this = this;
		var formWindow = $this.getAvailablebeddetailswin();
		if (!formWindow) {
			Ext.widget('availablebeddetailswin');
			formWindow = $this.getAvailablebeddetailswin();
		}
		formWindow.show();

		 var form = $this.getAvailableBeddetailswin().getForm();
	   	   
    	 if(!isNullOrEmpty(record.data.floorNo)){
    		 var floorNo =   record.data.floorNo;
    		 form.findField('floorNo').setValue(floorNo);
    	 }
    	 
    	 if(!isNullOrEmpty(record.data.roomType)){
    		 var roomType =   record.data.roomType;
    		 form.findField('roomType').setValue(roomType);
    	 }
    	 	
    	 
    	 if(!isNullOrEmpty(record.data.roomNo)){
    		 var roomNo =   record.data.roomNo;
    		 form.findField('roomNo').setValue(roomNo);
    	 }
    	 
    	 
   	  var store = $this.getAvailablebeddetailsgrid().getStore();
		store.getProxy().extraParams = {
			resourceId:record.data.resourceId
		};
		store.load();

	},
	loadUserOrRoomWiseRecord:function(obj){
		var $this = this;
		var searchForm = obj.up('form');
		var form = searchForm.getForm();
		var values = form.getValues();
		
			var grid = $this.getManageallocationgridreport();
			var store = grid.getStore();
			store.getProxy().extraParams = {

				roomTypeId:values.roomType,
				hostelResourceId:values.hostelCodeName,
				buildingResourceId:values.buildingCodeName,
				floorResourceId:values.floorCodeNo,
				roomResourceId:values.roomNo,
				status:values.status,
				userType:values.userType,
				userId:values.studentName,
				academyLocationId:values.academyLocation,
				allotmentStatus:values.allotmentStatus,
				gender: values.gender
			};
			$this.resetPageSetting(store);
			store.loadPage(1);
			/*store.load({
     		   callback: function(record, operation, success) {
     			   if (record.length > 0) {
     				   $this.toggleGridSummaryRow(grid,true);
     			   }else{
     				   $this.toggleGridSummaryRow(grid,false);
     			   }
     		   }
     	   });*/
	}
});
