/**
 * @author Pravin.Surve
 * This is used for to handle configuration of Adhoc messages Events.  
 * 
 */
Ext.define('Academia.controller.messaging.AdhocMessagingEventController', {
	
	extend: 'Academia.controller.base.BaseController',

    views: [
            'messaging.AdhocMessageSubTabPanel',
            'Academia.view.messaging.AdhocMessaheBasicSetUpForm',
            'messaging.AdhocReviewPanel',
            'messaging.AdhocAttachmentsPanel',
            'messaging.AdhocDistributionList',
            'messaging.AdhocMessageDistributionRule',
            'messaging.SystemEventConfigDistributionList',
            'messaging.SysEveConfigDistributionRulePanel',
            'messaging.systemEventMessagingRuleEditor.systemEventMessagingRuleEditor',
            'messaging.systemEventMessagingRuleEditor.SearchCriteriaGroupForMessaging',
            'messaging.systemEventMessagingRuleEditor.SearchCriteriaLineItemForMessaging',
            'messaging.systemEventMessagingRuleEditor.SearchConfigDataSourceForMessaging',
            'messaging.AdhocEventsSearchForm',
            'messaging.AdhocMessageEventsPanel',
            'messaging.AdhocRecepientWindow',
            'messaging.AdhocApproveRejectPanel',
            'messaging.AdhocAppRejCommentTabPanel',
            'messaging.AdhocApproveRejectFormPanel',
            'messaging.AdhocAppRejCommentHistory',
            'messaging.AdhocMessagingReportPanel',
            'messaging.AdhocMesagingReportFormWindow',
            'common.AcademyLocationProgramBatchSeatTypeForm',
            'messaging.report.AdhocMessageReportSearchForm',
            'messaging.report.AdhocEventReportPanel',
            'messaging.AdhocMessageEventsPanelView',
            'messaging.report.SendMessageReportStructure',
            'messaging.report.SendMessageList',
            'messaging.report.SendMessageAttachedDocumentWin',
            'messaging.CancelAdhocMessageReasonWin'
            ],
            
    model:['Academia.model.criteriabuilder.AdvancedSearchConfig'],
            
    stores: ['messaging.MessageTemplate','Academia.store.messaging.MessageCategoryStore','messaging.MessageSubCategoryStore','Academia.store.messaging.MessageSearchConfigs',
             'messaging.ApprovarComboStore','messaging.AdhocCommentHistoryStore','messaging.AdhocMessagingDocumentList','documentmanagement.DocumentCategorys','messaging.StudentsFilterByAcademyLocationIdStore',
             'messaging.AdhocMessagingReportGridStore','messaging.SendMessageReportList','messaging.SendMessageReportRecipientStore','messaging.SendMessageReportContactStore',
             'criteriabuilder.userquicksearch.QuickSearchPrintNameStore','messaging.SendMessageReportEventNameStore','messaging.SendMessageAttachedDocumentStore','messaging.SendMessageReportStatusStore',
             'user.UserAcademyLocationStore','feeandpayment.managebill.Student','common.IntakeYearStore','program.ProgramGroupStore','personinfo.common.personalinfo.AttendanceReportProgramGroupStore','program.programbatchdetail.BatchByProgramIdSSStore',
             'program.programbatchdetail.PeriodByBatchIdSSStore','program.programbatchdetail.SectionByPeriodIDSmartSearch','attendance.AttendanceProgramSectionStore','program.StudentsByAcademyLocationIdStore','messaging.MessageStatusStore'],

    refs: [           
	
	/* Adhoc list  reference */
	
    {
        ref: 'adhocEventsSearchForm',
        selector: 'adhoceventssearchform[itemId=adhocEventsSearchForm]'
    }, {
        ref: 'adhocEventSearchResultGrid',
        selector: 'searchresultgrid[itemId=adhocEventSearchResultGrid]'
    }, {
    	ref: 'adhocMessagingReportForm',
    	selector: 'adhocmesagingreportformwindow form[itemId=adhocMessagingReportform]'
    }, {
    	ref: 'adhocMessagingReportSearchForm',
    	selector: 'adhocmesagingreportformwindow form[itemId=adhocMessagingReportSearchform]'
    }, {
        ref: 'adhocMessageReportSearchResultGrid',
        selector: 'searchresultgrid[itemId=adhocMessageReportSearchResultGrid]'
    }, {
        ref: 'adhocMessageReportSearchForm',
        selector: 'adhocmessagereportsearchform[itemId=adhocMessageReportSearchForm]'
    },{
    	ref : 'sendMessageListGrid',
    	selector : 'sendmessagelist'
    },{
    	ref : 'sendMessageReportStructure',
    	selector : 'sendmessagereportstructure'
    },{
    	ref : 'sendmessageattacheddocumentwin',
    	selector : 'sendmessageattacheddocumentwin[itemId=masgeSendReportItemId]'
    },{
    	ref : 'canceladhocmessagereasonwin',
    	selector : 'canceladhocmessagereasonwin[itemId=cancelAdhocMessageReasonWinItemId]'
    }],
    config: {
    	ADHOC_MESSAGING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADHOC_MESSAGING_PRIVILEGES'),
    	ADHOC_MESSAGING_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADHOC_MESSAGING_REPORT_PRIVILEGES'),
    	PC_M12_R_MESSAGE_SENT_REPORT_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PC_M12_R_MESSAGE_SENT_REPORT_PRIVILEGES')
    },
    init: function(application) {
		this.isStaticDocOfMSR=false;
        this.control({
        	//**************************Export**************************************************************************  
			  'searchresultgrid[itemId=adhocEventSearchResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false);
		            }
		        },
		        'searchresultgrid[itemId=adhocEventSearchResultGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true);
		            }
		        },
		        'searchresultgrid[itemId=adhocEventSearchResultGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
		            }
		        },
		        'searchresultgrid[itemId=adhocEventSearchResultGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
		            }
		        },
		      //**************************Export**************************************************************************  
		        'searchresultgrid[itemId=adhocMessageReportSearchResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportAdhocEventList(SERVERURL.PDFEXPORT,'pdf',false);
		            }
		        },
		        'searchresultgrid[itemId=adhocMessageReportSearchResultGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		                this.exportAdhocEventList(SERVERURL.PDFEXPORT,'pdf',true);
		            }
		        },
		        'searchresultgrid[itemId=adhocMessageReportSearchResultGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportAdhocEventList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
		            }
		        },
		        'searchresultgrid[itemId=adhocMessageReportSearchResultGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		                this.exportAdhocEventList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
		            }
		        },
		      //**************************Export**************************************************************************  
        	/* Adhoc Form combo rendering and loading */
        	'adhoceventssearchform combo': {
                render: function(combo){
                	if(!isNullOrEmpty(combo.itemId) && combo.itemId!=="property"){
                		this.loadComboData(combo);
                	}                	                
                }
            },
            
            'adhoceventssearchform combo[itemId=messageCategory]': {
                select: function(combo,records){
                	var me=this;
                	var selectedCategoryId=combo.getValue();
                	if(!isNullOrEmpty(selectedCategoryId)){
                		var params=new Object();                	
                    	params.id=selectedCategoryId;
                    	me.loadDependentComboData(combo,records,params,'#messageSubCategory');
                	}  
                }
            },
            
            'adhocmessageeventspanel grid[itemId=adhocEventSearchResultGrid]': {
                render: function(grid){
                	this.gridRenderFunction(grid);
                	this.addCancelAdhocMessageButton(grid);
                	this.genericCBGridAccessControlValidation(grid, this.getADHOC_MESSAGING_PERMISSIONS());
                },
                selectionchange: function(column, selected,eOpts ){
            		var grid = column.view.up('grid');
            		var btn = grid.down('#btnCancelAdhocMsg');
            		var btnDelete = grid.down('#searchResultGridBtnDelete');
            		btn.setDisabled(false);
            		btnDelete.setDisabled(false);
            		if(selected.length == 0) {
            			btn.setDisabled(true);
            		} else {
            			for(var i=0; i<selected.length; i++) {
            				if(selected[i].data.MESSAGE_STATUS != "Ready") {
            					btn.setDisabled(true);
            					break;
                			}
            			}
            			for(var i=0; i<selected.length; i++) {
            				if(selected[i].data.MESSAGE_STATUS == "Initiated") {
            					btnDelete.setDisabled(true);
            					break;
                			}
            			}
            		}  
            		if(selected.length == 1) {                	
                    	var me=this;
                    	var adhocTab=me.getTabReferenceByTabTitle();
                    	if(adhocTab){
                    		var adhocGrid=adhocTab.down('grid');
                    		//console.log(adhocGrid);                	 
                        	if(adhocGrid){
                        		record = selected[0];
                        		var searchResultGridBtnEdit=adhocGrid.down("#searchResultGridBtnEdit");
                        		var searchResultGridBtnView=adhocGrid.down("#searchResultGridBtnView");
                        		
                        		if(!isEmpty(record)){
                            		var selectedTemplateAcadLocId=record.get('ACADEMY_LOCATION_ID');
                            		var selectedTemplateApprovarId=record.get('APPROVER_ID');
                            		var status=record.get('REVIEW_STATUS');
                            		var user=me.getCurrentlyLoggedInUser();
                            		var academyLocationId=me.getCurrentAcademyLocation();
                            		var user=me.getCurrentlyLoggedInUser();
                            		
                            				/* check statuses of templates */                    			
                                			if(status==CONSTANTS.MSG_TEMP_APPROVED){
                                				searchResultGridBtnEdit.setDisabled(false);
                                				searchResultGridBtnView.setDisabled(false);                
                                				record=me.getEnableDisableParams(record,false,false,false,false);                            				
                                			}else if(status==CONSTANTS.MSG_TEMP_REJECTED){                            				
                                				if(!isEmpty(user) && user.id==selectedTemplateApprovarId){                            					                                					
                                					searchResultGridBtnEdit.setDisabled(true);
                                    				searchResultGridBtnView.setDisabled(false);           
                                    				record=me.getEnableDisableParams(record,false,false,false,false);
                                				}else{
    	                        					if(!isNullOrEmpty(selectedTemplateAcadLocId) && academyLocationId==selectedTemplateAcadLocId){
    	                        						searchResultGridBtnEdit.setDisabled(false);
    	                                				searchResultGridBtnView.setDisabled(false);
    	                                				record=me.getEnableDisableParams(record,true,false,true,false);	                                				
    	                        					}else{
    	                        						searchResultGridBtnEdit.setDisabled(true);
    	                                				searchResultGridBtnView.setDisabled(false);
    	                                				record=me.getEnableDisableParams(record,false,false,false,false);
    	                        					}
                                				}    
                                			}else if(status==CONSTANTS.MSG_TEMP_DRAFT){ 
                                				if(!isNullOrEmpty(selectedTemplateAcadLocId) && academyLocationId==selectedTemplateAcadLocId){
                                					searchResultGridBtnEdit.setDisabled(false);
                                    				searchResultGridBtnView.setDisabled(false);
                                    				record=me.getEnableDisableParams(record,false,false,false,true);                                				
                                				}else{
                                					searchResultGridBtnEdit.setDisabled(true);
                                    				searchResultGridBtnView.setDisabled(false);
                                    				record=me.getEnableDisableParams(record,false,false,false,false);
                                				}                            				                            				
                                			}else if(status==CONSTANTS.MSG_TEMP_SENT_FOR_APPROVAL){
                                				if(!isEmpty(user) && user.id==selectedTemplateApprovarId){                            					                                					
                                    					searchResultGridBtnEdit.setDisabled(false);
                                        				searchResultGridBtnView.setDisabled(false);              
                                        				record=me.getEnableDisableParams(record,true,true,false,false);                                    				
                                				}else{
                                					if(!isNullOrEmpty(selectedTemplateAcadLocId) && academyLocationId==selectedTemplateAcadLocId){
                                						searchResultGridBtnEdit.setDisabled(false);
                                        				searchResultGridBtnView.setDisabled(false);                          
                                        				record=me.getEnableDisableParams(record,false,false,false,false);
                                					}else{
                                						searchResultGridBtnEdit.setDisabled(true);
                                        				searchResultGridBtnView.setDisabled(false);
                                        				record=me.getEnableDisableParams(record,false,false,false,false);
                                					}
                                				}                            				
                                			}else if(status==CONSTANTS.MSG_TEMP_RESUBMIT_FOR_APPROVAL){
                                				if(!isEmpty(user) && user.id==selectedTemplateApprovarId){                            					                                					
                                					searchResultGridBtnEdit.setDisabled(false);
                                    				searchResultGridBtnView.setDisabled(false);                                  
                                    				record=me.getEnableDisableParams(record,true,true,false,false); 
                                				}else{
    	                        					if(!isNullOrEmpty(selectedTemplateAcadLocId) && academyLocationId==selectedTemplateAcadLocId){
    	                        						searchResultGridBtnEdit.setDisabled(false);
    	                                				searchResultGridBtnView.setDisabled(false);
    	                                				record=me.getEnableDisableParams(record,true,false,true,false);	                                				
    	                        					}else{
    	                        						searchResultGridBtnEdit.setDisabled(true);
    	                                				searchResultGridBtnView.setDisabled(false);
    	                                				record=me.getEnableDisableParams(record,false,false,false,false);
    	                        					}
                                				}    
                                			}                            			                            		        		
                            		}
                        		
                        	}                    	                    	
                    	}                	
                    }
            		
                }
            },
            
            'adhoceventssearchform button[itemId=adhocEventFindButtonId]': {
            	click: this.loadAdhocGridAndSearchRequest,
            	render: this.loadAdhocGridAndSearchRequest
            },
            
            'adhoceventssearchform button[itemId=adhocEventClearSearch]':{
            	click: function(button) {
            		this.clearSearchForm(button)
            		var form =	this.getAdhocEventsSearchForm();
            		var fromDate =form.down('#msgFromDateId');
            		var toDate =form.down('#msgToDateId');
            		fromDate.setMaxValue(null);
            		toDate.setMinValue(null);
            	}
            },
            /* Adhoc Grid Button Events  */
            
            'adhocmessageeventspanel button[itemId=searchResultGridBtnAdd]': {
                click: function(button){                	
                	this.openNewAdhocTab(button);
                }
            },
            
            'adhocmessageeventspanel button[itemId=searchResultGridBtnEdit]': {
                click: function(button){
                	var me=this;
                	var grid =button.up('grid');
                	if(grid){                		
                		if (grid.getSelectionModel().getCount() > 0) {        	
                			me.openAdhocTemplateTab(button,grid,false);
                        } else {
                        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
                        }
                	}
                }
            },
            
            'adhocmessageeventspanel button[itemId=searchResultGridBtnView]': {
                click: function(button){
                	var me=this;
                	var grid =button.up('grid');
                	if(grid){                		
                		if (grid.getSelectionModel().getCount() > 0) {        	
                			me.openAdhocTemplateTab(button,grid,true);
                        } else {
                        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
                        }
                	}
                }
            },
            
            'adhocmessageeventspanel button[itemId=searchResultGridBtnDelete]': {
                click: function(button){
                	this.deleteAdhocMessageTemplate(button);
                }
            },
            
            'adhocmessageeventspanel button[itemId=btnCancelAdhocMsg]': {
            	click: function(button){
            		var formWindow = this.getCanceladhocmessagereasonwin();
            		  
        			if (!formWindow) {
        				formWindow = Ext.widget('canceladhocmessagereasonwin',{
        					itemId:'cancelAdhocMessageReasonWinItemId'
        				});
        			}
        			formWindow.show();
        		
            	}
            },
            
            'canceladhocmessagereasonwin button[itemId=btnSave]': {
                click: function(button){
                	this.cancelScheduleAdhocMessage(button);
                }
            },
            
            'canceladhocmessagereasonwin button[itemId=btnCancel]': {
                click: function(button){
                	button.up('window').close();
                }
            },
            
            'adhocmessahebasicsetupform combo[itemId=adhocMessageCategory]': {
                select: function(combo,records){
                	var me=this;
                	var selectedCategoryId=combo.getValue();
                	if(!isNullOrEmpty(selectedCategoryId)){
                		me.resetDependentFormFields(combo);
                		var params=new Object();                	
                    	params.id=selectedCategoryId;
                    	me.loadDependentComboData(combo,records,params,'#adhocMessageSubCategory');                    	
                	}                	                
                }
            },
            
            'adhocmessahebasicsetupform combo[itemId=adhocMessageSubCategory]': {
            	select : function(combo,records){
            		var me = this;
            		var subCategoryId = combo.getValue();
            		if(!isNullOrEmpty(subCategoryId)){
            			me.resetDependentFormFields(combo);
             			var msgCategoryIdParam=new Object();                	
             			msgCategoryIdParam.msgCatagoryId=subCategoryId;
             			msgCategoryIdParam.availableForAdhoc= true;
             			me.loadDependentComboData(combo,records,msgCategoryIdParam,'#selectTemplate');
             			me.addRecipientTypes(subCategoryId,combo,false);
             		}            		
            	}
            },
            
            'adhocmessahebasicsetupform checkbox[itemId=isAdhocCustomizeTemplate]': {
            	change:function(checkbox, newValue, oldValue, eOpts){                	
                	this.checkAdhocCustomizeTemplateType(checkbox,newValue,oldValue);
                }
            },
            
            'adhocmessahebasicsetupform checkbox[itemId=isAdhocApprovalRequired]': {
            	change:function(checkbox, newValue, oldValue, eOpts){                	
                	this.checkApproval(checkbox,newValue,oldValue);
                }
            },
            
            'adhocmessahebasicsetupform radiogroup#sendingPriority': {
        		change: function( radio, newValue, oldValue, eOpts) {
        			 this.loadScheduleField(radio, newValue, oldValue);
        		}
        	},
            
        	'adhocdistributionlist button[itemId=buildListButton]': {
                click:function(button){           
                	this.showBuildListWindow(button);                	                	
                } 
            },
            
            'systemeventmessagingruleeditor[itemId=adhocMessageDistributionListRuleEditor] button[itemId=SaveSearchButtonForMessaging]':{
            	click:function(button){
            		this.setSystemMessageRecipientObject(button.up('panel'),button.up('#adhocMessageDistributionList'),'distrListInstance');           		 
            	}           	    
            },
            
            'adhocmessahebasicsetupform button[itemId=adhocMsgSubmitBtn]': {
                click: function(button){                	
                	this.saveUpdateAdhocMessageTemplate(button);
                }
            },
            
            'adhocmessahebasicsetupform button[itemId=adhocMsgCancelBtn]': {
                click: function(button){                	
                	 button.up('form').getForm().getFields().each(function(field) {
                         field.reset();
                     });
                }
            },
            
            'adhocrecepientwindow button[itemId=adhocRecepientSaveBtn]': {
                click: function(button){                	
                	this.saveAdhocRecepientData(button);
                }
            },
            
            'adhocrecepientwindow button[itemId=adhocRecepientCancelBtn]': {
                click: function(button){                	
                	button.up('window').close();
                }
            },
            
            'searchresultgrid[itemId=adhocEventSearchResultGrid]':{      
            	render:function(grid){
            		this.gridRenderFunction(grid);
            	},
                afterrender:function(grid){
                	grid.down("#searchResultGridBtnView").hide(); 
 			   		grid.down("#searchResultGridBtnAdd").hide();
 			   		grid.down("#searchResultGridBtnEdit").hide();
 			   	//V2D-359081 			   		
 			   		var me = this;
 			   		var structure = grid.up('adhocmessageeventspanel');
 			   		me.getGridHeaderFreezeForQuartz(grid, structure, true);
                },
                /*select:function(rowModel, record, index, eOpts ){                	
                	var me=this;
                	var adhocTab=me.getTabReferenceByTabTitle();
                	if(adhocTab){
                		var adhocGrid=adhocTab.down('grid');
                		//console.log(adhocGrid);                	 
                    	if(adhocGrid){
                    		var searchResultGridBtnEdit=adhocGrid.down("#searchResultGridBtnEdit");
                    		var searchResultGridBtnView=adhocGrid.down("#searchResultGridBtnView");
                    		
                    		if(!isEmpty(record)){
                        		var selectedTemplateAcadLocId=record.get('ACADEMY_LOCATION_ID');
                        		var selectedTemplateApprovarId=record.get('APPROVER_ID');
                        		var status=record.get('REVIEW_STATUS');
                        		var user=me.getCurrentlyLoggedInUser();
                        		var academyLocationId=me.getCurrentAcademyLocation();
                        		var user=me.getCurrentlyLoggedInUser();
                        		
                        				 check statuses of templates                     			
                            			if(status==CONSTANTS.MSG_TEMP_APPROVED){
                            				searchResultGridBtnEdit.setDisabled(false);
                            				searchResultGridBtnView.setDisabled(false);                
                            				record=me.getEnableDisableParams(record,false,false,false,false);                            				
                            			}else if(status==CONSTANTS.MSG_TEMP_REJECTED){                            				
                            				if(!isEmpty(user) && user.id==selectedTemplateApprovarId){                            					                                					
                            					searchResultGridBtnEdit.setDisabled(true);
                                				searchResultGridBtnView.setDisabled(false);           
                                				record=me.getEnableDisableParams(record,false,false,false,false);
                            				}else{
	                        					if(!isNullOrEmpty(selectedTemplateAcadLocId) && academyLocationId==selectedTemplateAcadLocId){
	                        						searchResultGridBtnEdit.setDisabled(false);
	                                				searchResultGridBtnView.setDisabled(false);
	                                				record=me.getEnableDisableParams(record,true,false,true,false);	                                				
	                        					}else{
	                        						searchResultGridBtnEdit.setDisabled(true);
	                                				searchResultGridBtnView.setDisabled(false);
	                                				record=me.getEnableDisableParams(record,false,false,false,false);
	                        					}
                            				}    
                            			}else if(status==CONSTANTS.MSG_TEMP_DRAFT){ 
                            				if(!isNullOrEmpty(selectedTemplateAcadLocId) && academyLocationId==selectedTemplateAcadLocId){
                            					searchResultGridBtnEdit.setDisabled(false);
                                				searchResultGridBtnView.setDisabled(false);
                                				record=me.getEnableDisableParams(record,false,false,false,true);                                				
                            				}else{
                            					searchResultGridBtnEdit.setDisabled(true);
                                				searchResultGridBtnView.setDisabled(false);
                                				record=me.getEnableDisableParams(record,false,false,false,false);
                            				}                            				                            				
                            			}else if(status==CONSTANTS.MSG_TEMP_SENT_FOR_APPROVAL){
                            				if(!isEmpty(user) && user.id==selectedTemplateApprovarId){                            					                                					
                                					searchResultGridBtnEdit.setDisabled(false);
                                    				searchResultGridBtnView.setDisabled(false);              
                                    				record=me.getEnableDisableParams(record,true,true,false,false);                                    				
                            				}else{
                            					if(!isNullOrEmpty(selectedTemplateAcadLocId) && academyLocationId==selectedTemplateAcadLocId){
                            						searchResultGridBtnEdit.setDisabled(false);
                                    				searchResultGridBtnView.setDisabled(false);                          
                                    				record=me.getEnableDisableParams(record,false,false,false,false);
                            					}else{
                            						searchResultGridBtnEdit.setDisabled(true);
                                    				searchResultGridBtnView.setDisabled(false);
                                    				record=me.getEnableDisableParams(record,false,false,false,false);
                            					}
                            				}                            				
                            			}else if(status==CONSTANTS.MSG_TEMP_RESUBMIT_FOR_APPROVAL){
                            				if(!isEmpty(user) && user.id==selectedTemplateApprovarId){                            					                                					
                            					searchResultGridBtnEdit.setDisabled(false);
                                				searchResultGridBtnView.setDisabled(false);                                  
                                				record=me.getEnableDisableParams(record,true,true,false,false); 
                            				}else{
	                        					if(!isNullOrEmpty(selectedTemplateAcadLocId) && academyLocationId==selectedTemplateAcadLocId){
	                        						searchResultGridBtnEdit.setDisabled(false);
	                                				searchResultGridBtnView.setDisabled(false);
	                                				record=me.getEnableDisableParams(record,true,false,true,false);	                                				
	                        					}else{
	                        						searchResultGridBtnEdit.setDisabled(true);
	                                				searchResultGridBtnView.setDisabled(false);
	                                				record=me.getEnableDisableParams(record,false,false,false,false);
	                        					}
                            				}    
                            			}                            			                            		        		
                        		}
                    		
                    	}                    	                    	
                	}                	
                }*/
            },                                    
            
            'adhocapproverejectformpanel button[itemId=btnAdhocApproveReviewComment]': {
            	click: function(button, eOpts ){                	
            		this.approveRejectResubmitTemplate(button,getMessagingModuleTranslation('ADHOC_TEMP_APPROVED_MSG')); //Adhoc message template approved successfully.
                }
            },
            
            'adhocapproverejectformpanel button[itemId=btnAdhocRejectReviewComment]': {
            	click: function(button, eOpts ){                	
            		this.approveRejectResubmitTemplate(button,getMessagingModuleTranslation('ADHOC_TEMP_REJECTED_MSG')); //Adhoc message template rejected successfully.
                }
            },
            
            'adhocapproverejectformpanel button[itemId=btnAdhocReSubmitForApprovalComment]': {
            	click: function(btnReSubmitForApproval, eOpts ){
            		var me=this;
            		var adhocmessahebasicsetupform=btnReSubmitForApproval.up('adhocmessahebasicsetupform');
                	if(adhocmessahebasicsetupform){
                		var adhocMsgSubmitBtn=adhocmessahebasicsetupform.down("#adhocMsgSubmitBtn");
            		    if(adhocMsgSubmitBtn){
            		    	me.saveUpdateAdhocMessageTemplate(adhocMsgSubmitBtn,true,btnReSubmitForApproval);
            		    }
                	}
            		/*showConfirmMessage(getMessagingModuleTranslation('MSG_TEMP_RESUBMIT_FOR_APPROVAL'), getMessagingModuleTranslation('RESUBMIT_FOR_APPROVAL_MSG'), function(btn, text) {  //Have you checked the comments for rejection? Please click on Yes to proceed
                        if (btn == 'yes') {                        	
                        	var adhocmessahebasicsetupform=btnReSubmitForApproval.up('adhocmessahebasicsetupform');
                        	if(adhocmessahebasicsetupform){
                        		var adhocMsgSubmitBtn=adhocmessahebasicsetupform.down("#adhocMsgSubmitBtn");
                    		    if(adhocMsgSubmitBtn){
                    		    	me.saveUpdateAdhocMessageTemplate(adhocMsgSubmitBtn,true,btnReSubmitForApproval);
                    		    }
                        	}                        		                            	
                        }
                    });  */           		
                }
            },
            
            'adhocmessahebasicsetupform button[itemId=btnadhocSendForApproval]': {
            	click: function(button, eOpts ){                       		
            		this.sentTemplateForApproval(button,getMessagingModuleTranslation('ADHOC_TEMP_SENT_FOR_APPROVAL_MSG')); //Adhoc message template sent for approval successfully.
                }
            },
            
            'adhocmessagingreportpanel button[itemId=btnAddAdhocMessagingReport]': {
                click:function(button){
                	this.addMessagingReportDocument(button);                	                	
                } 
            },
            
            'adhocmessagingreportpanel button[itemId=btnDeleteAdhocMessagingReport]': {
                click:function(button){                	
                	this.deleteMessagingReportDocument(button);
                } 
            },
            
            'adhocmesagingreportformwindow button[itemId=adhocMessagingReportAttachBtn]': {
                click:function(button){
                	this.addSelectedAdhocMsgDocuments(button);
                } 
            },
            
            'adhocmesagingreportformwindow button[itemId=adhocMessagingReportCancelBtn]': {
                click:function(button){
                	button.up('window').close();
                } 
            },
            
            'adhocmesagingreportformwindow combo[itemId=acadamyLocationCourseId]': {
            	select: function(combo, records, eOpts) {
                	var academyLocationId = combo.getValue();
                	var courseCombo = this.getAdhocMessagingReportSearchForm().down('#courseId');
                	courseCombo.reset();
                	var store = courseCombo.getStore();
                	store.proxy.extraParams = {
                			academyLocationId: academyLocationId
                	};
                	store.load();
                }
            },           
            
            'adhocmesagingreportformwindow combo[itemId=adhoc_msg_doc_category]': {            	
            	select: function(combo, records, eOpts) {
            		var form = this.getAdhocMessagingReportSearchForm();
           			this.addContainerToForm(form, combo.getValue());
                }
            },
            
            'adhocmesagingreportformwindow button[itemId=searchButtonId]': {
            	click: function(combo, eOpts) {
            		this.loadAdhocMessagingReportselector();
            	}
            },
            
            'adhocmesagingreportformwindow button[itemId=resetBtnId]': {
            	click: function(combo, eOpts) {
            		var form = this.getAdhocMessagingReportSearchForm();                	                	
                	form.getForm().reset();                	
            	}
            },
            'adhoceventreportpanel searchresultgrid[itemId=adhocMessageReportSearchResultGrid]': {
                render: function(grid){
                	grid.addButtonToolbar();
               	    this.genericCBGridAccessControlValidation(grid, this.getADHOC_MESSAGING_REPORT_PERMISSIONS());
                	grid.down("#searchResultGridBtnView").setVisible(false); 
 			   		grid.down("#searchResultGridBtnAdd").setVisible(false);
 			   		grid.down("#searchResultGridBtnEdit").setVisible(false);
 			   		grid.down("#searchResultGridBtnDelete").setVisible(false);
                }
            },
            'adhocmessagereportsearchform[itemId=adhocMessageReportSearchForm] button[itemId=searchButtonId]': {
                click: function(){
                	this.loadAdhocMessageSearchReportGrid();
                }
            },
            'adhocmessagereportsearchform[itemId=adhocMessageReportSearchForm] button[itemId=resetButtonId]': {
                click: function(){
                	this.resetAdhocMessageSearchResultForm();
                }
            },
            'adhocmessagereportsearchform[itemId=adhocMessageReportSearchForm]': {
                render: function(){
                	var searchForm = this.getAdhocMessageReportSearchForm();
                	var messageSubCategory = searchForm.down('#messageSubCategory');
                	messageSubCategory.setDisabled(true);
                }
            },
            
            'sendmessagereportstructure': {
                afterrender: function(){                	
                	var form = this.getSendMessageReportStructure();  
            		var contactId=form.down("#contactId");
            		var mobileId=form.down("#mobileId");
            		var eventDateForm=form.down("#eventDateForm","d/m/Y");
            		var eventDateTill=form.down('#eventDateTill');
            		var messageId = form.down("#sendmessageId").getValue();
            		contactId.getStore().getProxy().setExtraParam('id', 1);
        			//contactId.getStore().load();
        			mobileId.getStore().getProxy().setExtraParam('id', 2);
        			//mobileId.getStore().load();
        			
                    var programNameCombo = form.down('#programId');
                    var programGroupId = form.down('#Program_Group');
                    var studentId = form.down('#studentId');
                    var studentIdStore = studentId.getStore();
    				var programNameStore = programNameCombo.getStore();
    				var academyLocationId = this.getCurrentAcademyLocation();
    				programNameStore.getProxy().extraParams = {
    					academyLocationIds: academyLocationId
    				};
    				programNameStore.load();
    				studentIdStore.getProxy().extraParams = {
    					academyLocationIds: academyLocationId
    				};
    				studentIdStore.load();
    				eventDateForm.setValue(new Date());
    				eventDateTill.setValue(new Date());	
    				
                }
            },
            
            'sendmessagereportstructure button[itemId=resetButtonId]': {
                click: function(){                	
                	var form = this.getSendMessageReportStructure();  
                	var grid =  this.getSendMessageListGrid();
            		var sendMessage = form.down("#sendmessageId").reset();
            		var recipient=form.down("#recipientName").reset();
            		var contactId=form.down("#contactId").reset();
            		var sentbyName=form.down("#sentby").reset();
            		var eventNameCode=form.down("#eventName").reset();
            		var eventDateForm=form.down("#eventDateForm");
            		var eventDateTill=form.down("#eventDateTill");
            		eventDateForm.reset();
            		eventDateTill.reset();
            		eventDateForm.setValue(new Date());
    				eventDateTill.setValue(new Date());	
            		//eventDateTill.setMinValue(null);
            		//eventDateForm.setMaxValue(null);
            		var academyLocationId = form.down("#academyLocationId");
            		academyLocationId.reset();
            		var studentId = form.down("#studentId");
            		studentId.reset();
            		var intakeYearPlcDriveId = form.down("#intakeYearPlcDriveId");
            		intakeYearPlcDriveId.reset();
            		var Program_Group = form.down("#Program_Group");
            		Program_Group.reset();
            		var programNameCombo = form.down("#programId");
            		programNameCombo.reset();
            		var batchId = form.down("#batchId");
            		batchId.reset();
            		batchId.setDisabled(true);
            		var periodId = form.down("#periodId");
            		periodId.reset();
            		periodId.setDisabled(true);
            		var sectionId = form.down("#sectionId");
            		sectionId.reset();
            		sectionId.setDisabled(true);
            		
            		var academyLocationId = form.down("#fieldsetId");
             		academyLocationId.setDisabled(false);
             		
             		var academyLocationId = this.getCurrentAcademyLocation();
             		var programNameStore = programNameCombo.getStore();
    				programNameStore.getProxy().extraParams = {
    					academyLocationIds: academyLocationId
    				};
    				programNameStore.load();
            		form.down("#statusComboMsgSendReport").reset();
            		grid.down("#exportMessageSentReportItemId").setDisabled(true);
            		grid.down("#btnUnblockEmails").setDisabled(true);
                }
            },            
            'sendmessagereportstructure radiogroup[itemId=sendmessageId]': {
            	change: function(obj,value){                	
                	var form = this.getSendMessageReportStructure();   
                	var grid =  this.getSendMessageListGrid();            	
                	var contactField=form.down("#contactId");
        			var mobileField=form.down("#mobileId");
        			var eventDateForm=form.down("#eventDateForm","d/m/Y");
            		var eventDateTill=form.down('#eventDateTill');
        			grid.down("#exportMessageSentReportItemId").setDisabled(true);
        			grid.down("#btnUnblockEmails").setDisabled(true);
        			eventDateForm.setValue(new Date());
    				eventDateTill.setValue(new Date());	
            		if(value.sendMessage===2){              			
                		var recipient=form.down("#recipientName").reset();
                		var contactId=form.down("#contactId").reset();
                		var sentbyName=form.down("#sentby").reset();
                		var eventNameCode=form.down("#eventName").reset();
                		//var eventDateForm=form.down("#eventDateForm").reset();
                		//var eventDateTill=form.down("#eventDateTill").reset();
                		var mobileNO=form.down("#mobileId").reset();
                		form.down("#academyLocationId").reset();
            			contactField.setVisible(false);
            			mobileField.setVisible(true);
            			var statusComboMsgSendReport=form.down("#statusComboMsgSendReport");
            			statusComboMsgSendReport.reset();
            			statusComboMsgSendReport.setVisible(false);
            			grid.down("#btnUnblockEmails").setDisabled(true);
            			grid.down("#btnUnblockEmails").setVisible(false);
        				
            		}else{
            			form.down("#academyLocationId").reset();
                		var recipient=form.down("#recipientName").reset();
                		var contactId=form.down("#contactId").reset();
                		var sentbyName=form.down("#sentby").reset();
                		var eventNameCode=form.down("#eventName").reset();
                		//var eventDateForm=form.down("#eventDateForm").reset();
                		//var eventDateTill=form.down("#eventDateTill").reset();
            			contactField.setVisible(true);
            			mobileField.setVisible(false);
            			var statusComboMsgSendReport=form.down("#statusComboMsgSendReport");
            			statusComboMsgSendReport.reset();
            			statusComboMsgSendReport.setVisible(true);
            			grid.down("#btnUnblockEmails").setVisible(true);
            		}                	
                }
            },
            'adhocmessagereportsearchform[itemId=adhocMessageReportSearchForm] combo[itemId=messageCategory]': {
                select: function(combo,records){
                	var searchForm = this.getAdhocMessageReportSearchForm();
                	var messageSubCategory = searchForm.down('#messageSubCategory');
                	messageSubCategory.setDisabled(false);
                	var selectedCategoryId=combo.getValue();
                	if(!isNullOrEmpty(selectedCategoryId)){
                		
                /*		var store = messageSubCategory.getStore();
                		store.load({
                			params:{
                				id: selectedCategoryId
                			}
                		});*/
                		var store = messageSubCategory.getStore();
                		store.getProxy().extraParams={
        					id:selectedCategoryId
        				};
                		store.load();
                	}  
                }
            },
            'sendmessagereportstructure button[itemId=searchButtonId]':{
            	click : function(obj){
            		var form = this.getSendMessageReportStructure();
            		var grid =  this.getSendMessageListGrid();
            		var sendMessage = form.down("#sendmessageId").getValue();
            		//console.log(sendMessage);
            		var recipient=form.down("#recipientName").getValue();
            		var contactId=null;
            		var sentbyName=form.down("#sentby").getValue();
            		var eventNameCode=form.down("#eventName").getValue();
            		var eventDateForm=form.down("#eventDateForm").getValue().toISOString().split('.')[0];
            		var eventDateTill=form.down("#eventDateTill").getValue().toISOString().split('.')[0];
            		var messageId=form.down("#sendmessageId").getValue();
            		
            		var academyLocationId=form.down("#academyLocationId").getValue();
            		var studentId=form.down("#studentId").getValue();
            		var intakeYearId=form.down("#intakeYearPlcDriveId").getValue();
            		var programGroupId=form.down("#Program_Group").getValue();
            		var programId=form.down("#programId").getValue();
            		var batchId=form.down("#batchId").getValue();
            		var periodId=form.down("#periodId").getValue();
            		var sectionId=form.down("#sectionId").getValue();
            		
        			if(eventDateForm.includes('T')){
            			eventDateForm = eventDateForm.replace('T', ' ');
            		}
        			
            		if(eventDateTill.includes('T')){
            			eventDateTill = eventDateTill.replace('T', ' ');
            		}
            		
            		var statusComboMsgSendReport = form.down('#statusComboMsgSendReport');
            		var statusVal = statusComboMsgSendReport.getValue();
            		
            		if(messageId.sendMessage==1){
            			contactId=form.down("#contactId").getValue();
            			if(!isNullOrEmpty(statusComboMsgSendReport) && statusComboMsgSendReport.valueModels.length>0){
            				statusVal = statusComboMsgSendReport.valueModels[0].get('key');
            			}
            		}else{
            			contactId=form.down("#mobileId").getValue();
            			statusVal = null;
            		}
            		//var formValues=form.getForm().getValues();            		
            		var store = grid.getStore();
            		var exportReport=grid.down("#exportMessageSentReportItemId");
            		store.getProxy().extraParams = {
            			deliveryModeId: sendMessage.sendMessage,
            			recipientName: recipient,
            			contact:contactId,
            			sentBy:sentbyName,
            			eventName:eventNameCode,
            			fromDate:eventDateForm,
            			toDate:eventDateTill,
            			status:statusVal,
            			academyLocationId:academyLocationId,
            			studentId:studentId,
            			intakeYearId:intakeYearId,
            			programGroupId:programGroupId,
            			programId:programId,
            			batchId:batchId,
            			periodId:periodId,
            			sectionId:sectionId
            			
            		}
            		store.removeAll();
            		this.resetGridSetting(grid);
            		this.resetPageSetting(store);
            		store.loadPage(1,{ callback: function(records, operation, success) {
		                    if(records.length>0){
		                       exportReport.setDisabled(false);
		                    }
	                 	 }
             		 });
            	}
            },
            'sendmessagelist':{
            	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
            		var messageTemplate = record.get('msgContent');
            		var $this =this;
            		if (e.target.tagName == 'A') {
            			var dataIndex = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
            			if(dataIndex == "attachedDocument"){
            				$this.openAttachedDocumentLink(record);
            			}
            			else{
            				$this.openSendMessageReportLink(record);	
            			}
            		}
            	},
            	render: function(grid){
    				var $this = this;
    				var itemIdPrivilegeNameArray = [{"#exportMessageSentReportItemId" : "EXPORT_REPORTS"},{"#btnUnblockEmails" : "UNBLOCK"}];
    				this.disableRadioGroupAndOtherPivileges(grid, this.getPC_M12_R_MESSAGE_SENT_REPORT_PERMISSIONS(),itemIdPrivilegeNameArray);
    				var exportReport=grid.down("#exportMessageSentReportItemId");
    				var btnUnblockEmails=grid.down("#btnUnblockEmails");
    				exportReport.setDisabled(true);
    				btnUnblockEmails.setDisabled(true);
    			},
    			selectionchange: function(column, selected) {
    				var grid = this.getSendMessageListGrid();
	        		var btnUnblockEmails = grid.down('#btnUnblockEmails');
	        		if(selected.length>0){
	        			for(var i in selected){
	        				if(selected[i].data.deliveryStatus=='Delivery'||selected[i].data.deliveryStatus=='DELIVERY'||selected[i].data.deliveryStatus==null){
	        					btnUnblockEmails.setDisabled(true);
	        					break;
	        				}else{
	        					btnUnblockEmails.setDisabled(false)
	        				}
	        			}
	        		}else{
	        			btnUnblockEmails.setDisabled(false)
	        		}
    			}
            },
            'sendmessagereportstructure datefield[itemId=eventDateForm]':{
            	select : function(field, value, eOpts){
            		this.checkSelectDate();

            	}
            },
            'sendmessagereportstructure datefield[itemId=eventDateTill]':{
            	select : function(field, value, eOpts){
            		this.checkSelectDate();

            	}
            },
            
            'sendmessagelist button[itemId=exportMessageSentReportItemId]':{
            	click: function(){
            		this.exportXlsMsgSentReport();
            		
            	}
            },
            'sendmessagereportstructure customcombobox[itemId=sentby]':{
               	blur : function(field, e, eOpts){
               	var fieldVal = field.getValue();
	            if(!isNullOrEmpty(fieldVal) && fieldVal.match(/(\%|\s\b)/g).length>0){
	                field.setValue("");
	               	field.setRawValue("");
	               	}
               	 }
              },
            'sendmessageattacheddocumentwin[itemId=masgeSendReportItemId] grid[itemId=sendMessageDocumentGridItemId]': {
            	cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var grid = $this.getSendmessageattacheddocumentwin().down('#sendMessageDocumentGridItemId');
                    var columnName = grid.columnManager.columns[cellIndex].dataIndex;
                    if (columnName == "name") {
                        if (e.target.tagName == 'A') {
                            var documentId = record.get("id");
                             var staticDocOfMSR  = record.get("staticDocOfMSR");
                            if (!isNullOrEmpty(documentId)) {
                            	var isWhetherSysMsgEvent = false;
                            	var gridMessageList = $this.getSendMessageListGrid();
                            	if(gridMessageList.getSelectionModel().getCount()>0){
                            		var recordList = gridMessageList.getSelectionModel().getSelection();
                            		var eventName = recordList[0].get('eventName');
                            		
                            		if(!isNullOrEmpty(eventName)){
                            			isWhetherSysMsgEvent = true;
                            		}
                            	}
                                $this.downloadAttachedDocumentFile(documentId,isWhetherSysMsgEvent,staticDocOfMSR);
                            }
                        }
                    }
                }
            },
            
            
            'sendmessagereportstructure customcombobox[itemId=recipientName]': {
    			select: function(combo,newValue, oldValue, eOpts){
    				var form = this.getSendMessageReportStructure();
    				var academyLocationId = form.down("#fieldsetId");
            		academyLocationId.setDisabled(true);
            		var grid =  this.getSendMessageListGrid();
            		var exportReport=grid.down("#exportMessageSentReportItemId");
		            exportReport.setDisabled(true);
    			}
    		},
    		
    		 'sendmessagereportstructure customcombobox[itemId=contactId]': {
     			select: function(combo,newValue, oldValue, eOpts){
     				var form = this.getSendMessageReportStructure();
     				var academyLocationId = form.down("#fieldsetId");
             		academyLocationId.setDisabled(true);
             		
            		var grid =  this.getSendMessageListGrid();
            		var exportReport=grid.down("#exportMessageSentReportItemId");
		            exportReport.setDisabled(true);
     			}
     		},
     		'sendmessagereportstructure customcombobox[itemId=mobileId]': {
     			select: function(combo,newValue, oldValue, eOpts){
     				var form = this.getSendMessageReportStructure();
     				var academyLocationId = form.down("#fieldsetId");
             		academyLocationId.setDisabled(true);
             		
            		var grid =  this.getSendMessageListGrid();
            		var exportReport=grid.down("#exportMessageSentReportItemId");
		            exportReport.setDisabled(true);
     			}
     		},
    		
    		'sendmessagereportstructure customcombobox[itemId=academyLocationId]': {
    			select: function(combo,newValue, oldValue, eOpts){
    				var academyLocationId = newValue[0].data.id;
    				var form = this.getSendMessageReportStructure();
    				
    				var programGroupNameCombo = form.down('#Program_Group');
    				var programGroupNameStore = programGroupNameCombo.getStore();
    				programGroupNameStore.getProxy().extraParams = {
    					academyLocationId: academyLocationId
    				};
    				programGroupNameStore.load();
    				
    				var studentId = form.down('#studentId');
    				var studentIdStore = studentId.getStore();
    			/*	studentIdStore.getProxy().extraParams = {
    					academyLocationIds: academyLocationId
    				};
    				studentIdStore.load();*/
    				
    				var programNameCombo = form.down('#programId');
                    var programNameStore = programNameCombo.getStore();
                    programNameStore.getProxy().extraParams = {
    					academyLocationIds: academyLocationId
    				};
    				programNameStore.load();
    				this.loadOtherCombo();
    				
            		var grid =  this.getSendMessageListGrid();
            		var exportReport=grid.down("#exportMessageSentReportItemId");
		            exportReport.setDisabled(true);
    				
    			}
    		},
    		
    		'sendmessagereportstructure customcombobox[itemId=Program_Group]': {
    			select: function(combo,newValue, oldValue, eOpts){
    				var programGroupId = newValue[0].data.id;
    				var form = this.getSendMessageReportStructure();
    				var programNameCombo = form.down('#programId');
    				
    				if(!isNullOrEmpty(form.down('#academyLocationId'))){
    					var academyLocationId = form.down('#academyLocationId').getValue();
    					if(isNullOrEmpty(academyLocationId)){
    					 academyLocationId = this.getCurrentAcademyLocation();
    					}
    				}
    				var programNameStore = programNameCombo.getStore();
    				programNameStore.getProxy().extraParams = {
    					academyLocationIds: academyLocationId,
    					programGroupId : programGroupId
    				};
    				programNameStore.load();
    				this.loadOtherCombo();
    				
            		var grid =  this.getSendMessageListGrid();
            		var exportReport=grid.down("#exportMessageSentReportItemId");
		            exportReport.setDisabled(true);
    			}
    		},
            'sendmessagereportstructure customcombobox[itemId=programId]': {
    			select: function(combo,newValue, oldValue, eOpts){
    				var programId = newValue[0].data.id;
    				var form = this.getSendMessageReportStructure();
    				var batchNameCombo = form.down('#batchId');
    				var periodNameCombo = form.down('#periodId');
    				var sectionNameCombo = form.down('#sectionId');
    				periodNameCombo.reset();
    				sectionNameCombo.reset();
    				batchNameCombo.setDisabled(false);
    				var batchNameStore = batchNameCombo.getStore();
    				batchNameStore.getProxy().extraParams = {
    					programId: programId
    				};
    				batchNameStore.load();
    				this.loadOtherCombo();
    				
            		var grid =  this.getSendMessageListGrid();
            		var exportReport=grid.down("#exportMessageSentReportItemId");
		            exportReport.setDisabled(true);
    			},
    		},
    		'sendmessagereportstructure customcombobox[itemId=batchId]': {
    			select: function(combo,newValue, oldValue, eOpts){
    				var batchId = newValue[0].data.id;
    				var form = this.getSendMessageReportStructure();
    				var periodNameCombo = form.down('#periodId');
    				var periodNameCombo = form.down('#periodId');
    				var sectionNameCombo = form.down('#sectionId');
    				periodNameCombo.reset();
    				sectionNameCombo.reset();
    				periodNameCombo.setDisabled(false);
    				var periodNameStore = periodNameCombo.getStore();
    				periodNameStore.getProxy().extraParams = {
    					id: batchId
    				};
    				periodNameStore.load();
    				this.loadOtherCombo();
    				
            		var grid =  this.getSendMessageListGrid();
            		var exportReport=grid.down("#exportMessageSentReportItemId");
		            exportReport.setDisabled(true);
    			}
    		},
    		'sendmessagereportstructure customcombobox[itemId=sectionId]': {
    			select: function(combo,newValue, oldValue, eOpts){
    				this.loadOtherCombo();
    				
            		var grid =  this.getSendMessageListGrid();
            		var exportReport=grid.down("#exportMessageSentReportItemId");
		            exportReport.setDisabled(true);
    			}
    		},
    		'sendmessagereportstructure customcombobox[itemId=periodId]': {
    			select: function(combo,newValue, oldValue, eOpts){
    				var periodId = newValue[0].data.id;
    				var form = this.getSendMessageReportStructure();
    				var sectionNameCombo = form.down('#sectionId');
    				var sectionNameStore = sectionNameCombo.getStore();
    				var sectionNameCombo = form.down('#sectionId');
    				sectionNameCombo.reset();
    				sectionNameCombo.setDisabled(false);
    				sectionNameStore.getProxy().extraParams = {
    					periodId: periodId
    				};
    				sectionNameStore.load();
    				this.loadOtherCombo();
    				
            		var grid =  this.getSendMessageListGrid();
            		var exportReport=grid.down("#exportMessageSentReportItemId");
		            exportReport.setDisabled(true);
    			}
    		},
    		'sendmessagereportstructure customcombobox[itemId=intakeYearPlcDriveId]':{
    			select: function(combo,newValue, oldValue, eOpts){
    				this.loadOtherCombo();
    				
            		var grid =  this.getSendMessageListGrid();
            		var exportReport=grid.down("#exportMessageSentReportItemId");
		            exportReport.setDisabled(true);
    			}
    		},
    		'sendmessagereportstructure customcombobox[itemId=statusComboMsgSendReport]':{
    			select: function(combo,newValue, oldValue, eOpts){
    				
            		var grid =  this.getSendMessageListGrid();
            		var exportReport=grid.down("#exportMessageSentReportItemId");
		            exportReport.setDisabled(true);
    			}
    		},
    		'sendmessagereportstructure customcombobox[itemId=eventName]':{
    			select: function(combo,newValue, oldValue, eOpts){
            		var grid =  this.getSendMessageListGrid();
            		var exportReport=grid.down("#exportMessageSentReportItemId");
		            exportReport.setDisabled(true);
    			}
    		},
    		'sendmessagereportstructure customcombobox[itemId=studentId]': {
    			select: function(combo,newValue, oldValue, eOpts){
    				var studentId = newValue[0].data.id;
    				var form = this.getSendMessageReportStructure();
    				
    	    	 /*   Ext.Ajax.request({
    	                method: "GET",
    	                type: 'rest',
    	                url: SERVERURL.PATH_FIND_PROGRAM_BATCH_SECTION_PERIOD_BY_STUDENT_ID,
    	                headers: {
    	                    'Content-Type': 'application/json'
    	                },
    	                params: {
    	                    studentId: studentId
    	                },
    	                success: function(response, action) {
    	                    var data = Ext.decode(response.responseText);
    	                    var programCombo = form.down('#programId');
    	                    var programComboStore = programCombo.getStore();
    	                    programComboStore.load({
    	                        callback: function(records, operation, success) {
    	                            if (!isNullOrEmpty(data[0].programId)) {
    		                            programCombo.setValue(data[0].programId);
    	                                var batchCombo = form.down('#batchId');
    	                                var batchComboStore = batchCombo.getStore();
    	                                batchComboStore.getProxy().extraParams = {
    	                                    programId: data[0].programId
    	                                };

    	                                batchComboStore.load({
    	                                    callback: function(records, operation, success) {
    	                                        if (!isNullOrEmpty(data[0].batchId)) {
    		                                        batchCombo.setValue(data[0].batchId);
    	                                            var periodCombo = form.down('#periodId');
    	                                            var periodComboStore = periodCombo.getStore();
    	                                            periodComboStore.getProxy().extraParams = {
    	                                                id: data[0].batchId
    	                                            };

    	                                            periodComboStore.load({
    	                                                callback: function(records, operation, success) {
    	                                                    if (!isNullOrEmpty(data[0].programPeriodId)) {
    		                                                    periodCombo.setValue(data[0].programPeriodId);
    	                                                        var sectionCombo = form.down('#sectionId');
    	                                                        var sectionComboStore = sectionCombo.getStore();
    	                                                        sectionComboStore.getProxy().extraParams = {
    	                                                            periodId: data[0].programPeriodId
    	                                                        };
    	                                                        sectionComboStore.load({
    	                                                            callback: function(records, operation, success) {
    	                                                            	if (!isNullOrEmpty(data[0].sectionId)) {
    		                                                                sectionCombo.setValue(data[0].sectionId);
    	                                                            	}else {
    	                                                            		sectionCombo.emptyText = [ '' ];
    	                                                            		sectionCombo.applyEmptyText();
    	                                                            		sectionCombo.reset();
    	                                                            	}
    	                                                            }
    	                                                        });
    	                                                    }
    	                                                }
    	                                            });
    	                                        }
    	                                    }
    	                                });
    	                            }
    	                        }
    	                    });
    	                }
    	            });*/
    				
    				
    				/*var form = this.getSendMessageReportStructure();
    				var sectionNameCombo = form.down('#sectionId');
    				var sectionNameStore = sectionNameCombo.getStore();
    				sectionNameStore.getProxy().extraParams = {
    					periodId: periodId
    				};
    				sectionNameStore.load();*/
    			}
    		},
    		'sendmessagelist button[itemId=btnUnblockEmails]': {
    			click: function(){                	
    				var grid =  this.getSendMessageListGrid();
    				var records = grid.getSelectionModel().getSelection();
    				var wsMessageReportModelList1 ={};
    				var wsMessageReportModel =[];
    				var json= new Object;
    				if(grid.getSelectionModel().getCount() > 0){
    					showConfirmMessage(getMessagingModuleTranslation('ALERT'), getMessagingModuleTranslation('UNBLOCK_CONFIRM_MESSAGE'), function(btn, text) {
    						if (btn == 'yes') {
    							for(var i in records){
    								json = {
    										"contact" : records[i].data.contact,
    										"deliveryStatus" : records[i].data.deliveryStatus,
    										"recipientFullName" : records[i].data.recipientFullName,
    										"sendersName" : records[i].data.sendersName,
    										"msgContent" : records[i].data.msgContent,
    										"eventName" : records[i].data.eventName,
    										"lastUpdate" : records[i].data.lastUpdate,
    										"sentBy" : records[i].data.sentBy,
    										"msgRcpntLogId" : records[i].data.msgRcpntLogId,
    										"attachedDocument" : records[i].data.attachedDocument,
    										"queueStatus" : records[i].data.queueStatus,
    										"snsQueueStaRtus" : records[i].data.snsQueueStatus,
    										"diagnosticCode" : records[i].data.diagnosticCode

    								};
    								wsMessageReportModel.push(json);
    							}
    							wsMessageReportModelList1=wsMessageReportModel;
    							var formData = Ext.encode(wsMessageReportModel);
    							Ext.Ajax.request({
    								type: 'rest',
    								url: SERVERURL.PATH_UPDATE_ALL_BLOCK_AND_BOUNCE_EMAILS,
    								jsonData: wsMessageReportModelList1,
    								method: 'POST',
    								headers : {
    									'Content-Type' : 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization
    								},
    								success: function(response, action) {
    									if(response.responseText!="Success"){
    										showWarningMessage(getCommonTranslation('ALERT'),response.responseText);
    									}
    									else
    									showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('SUCCESS'));  //Adhoc messaging document deleted successfully
    									grid.getStore().load();
    								}
    							});
    						}
    					});
    				}else{
    					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
    				}
    			}
    		},

        });
    },
    
    
    checkSelectDate:function(){
    	var form = this.getSendMessageReportStructure();
		var grid =  this.getSendMessageListGrid();
		var eventDateForm=form.down("#eventDateForm").getValue();
		var eventDateTill=form.down("#eventDateTill").getValue();
		var exportReport=grid.down("#exportMessageSentReportItemId");
		var btnUnblockEmails=grid.down("#btnUnblockEmails");
		var sendmessageId=form.down("#sendmessageId").getValue();
		var value =sendmessageId.sendMessage;
		if(!isNullOrEmpty(eventDateForm) && !isNullOrEmpty(eventDateTill)){
			exportReport.setDisabled(true);
			if(value==1){
				btnUnblockEmails.setDisabled(false);
				btnUnblockEmails.setVisible(true);
			}
		}
		else{
			exportReport.setDisabled(true);
			btnUnblockEmails.setDisabled(true);
			btnUnblockEmails.setVisible(false);
			if(value==1){
				btnUnblockEmails.setDisabled(true);
				btnUnblockEmails.setVisible(true);
			}
		}
    },
    exportXlsMsgSentReport : function() {
		var $this = this;
    	var form = $this.getSendMessageReportStructure();
		var values = form.getValues();
		var dt = new Date();
    	var dateString = Ext.Date.format(dt, 'YmdHis'); 
		var reportTitle = "Message Sent Report"+"_"+dateString;
		var code = 'MESSAGE_SENT_EXCEL_EXPORT_REPORT';
		var reportHeader = "Message Sent Report";
	
		
		
		var sendMessage = form.down("#sendmessageId").getValue();
		//console.log(sendMessage);
		var recipient=form.down("#recipientName").getValue();
		var contactId=null;
		var sentbyName=form.down("#sentby").getValue();
		var eventNameCode=form.down("#eventName").getValue();
		var eventDateForm=form.down("#eventDateForm").getValue();
		var eventDateTill=form.down("#eventDateTill").getValue();
		var messageId=form.down("#sendmessageId").getValue();
		var status=form.down("#statusComboMsgSendReport").getValue();
		if(messageId.sendMessage==1){
			contactId=form.down("#contactId").getValue();
		}else{
			contactId=form.down("#mobileId").getValue();
		}
		
		
		
	
		var reportParams = new Object();
		reportParams.fromDate = eventDateForm;
		reportParams.toDate = eventDateTill;
		reportParams.contact = contactId;
		reportParams.sentBy = sentbyName;
		reportParams.eventName=eventNameCode;
		reportParams.recipientName=recipient;
		reportParams.deliveryModeId=sendMessage.sendMessage;
		reportParams.headerName = reportHeader;
		reportParams.status = status;
		reportParams.academyLocationId = values.academyLocationId;
		reportParams.studentId = values.STUDENT_ID;
		reportParams.intakeYearId = values.intakeYearPlcDriveId;
		reportParams.programGroupId = values.programGroup;
		reportParams.programId = values.programId;
		reportParams.batchId = values.batchId;
		reportParams.periodId = values.periodId;
		reportParams.sectionId = values.sectionId;
		$this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.MSG_SENT_EXCEL_REPORT);
	},
    /**
     * Load Adhoc Message Search Report Grid
     */
    loadAdhocMessageSearchReportGrid: function(){
    	
        var searchForm = this.getAdhocMessageReportSearchForm();
        var jsonFormatFormData = this.createSearchResultReportJsonFormat(searchForm);
        var resultGrid = this.getAdhocMessageReportSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.MESSAGING_ADHOC_MSG_EVENT_REPORT_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        Ext.getBody().unmask();
    },
    /**
     * Create Search Result Report Json Format
     * @param searchForm form
     */
    createSearchResultReportJsonFormat: function(searchForm){
    	var this$=this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.MESSAGING_ADHOC_MSG_EVENT_REPORT_BASIC_CONFIGCODE;

        formValues = searchForm.getValues();        
        
        for (var key in formValues) {
            var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'START_DATE' && key !== 'END_DATE'&& key !== 'DELIVERY_MODE'){
                var keyValueJsonObject = this$.getJsonObject( key , value);
                this$.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
            }
        }
       
        var deliveryModes = formValues['DELIVERY_MODE'];
        if(deliveryModes != undefined){
        	var arr = [];
        	if(deliveryModes.length == undefined){
        		arr.push(deliveryModes);
        	}else{
        		for(var i=0;i<deliveryModes.length;i++) {
        			arr.push(deliveryModes[i]);
        		} 
        	}
        	var keyValueJsonObj = this$.getJsonObject('DELIVERY_MODE', arr.join());
        	this$.pushJsonObjectInArray(keyValueJsonObj,searchcriteria);

        }
        
        /*if(!isNullOrEmpty(formValues.START_DATE) && !isNullOrEmpty(formValues.END_DATE)){
        	var keyValueJsonObject = this$.getJsonObject( key, formValues.START_DATE, formValues.END_DATE);
            this$.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }*/
        if(!isNullOrEmpty(formValues.START_DATE)){
        	var keyValueJsonObject = this$.getJsonObject( "START_DATE", formValues.START_DATE);
        	this$.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }

        if(!isNullOrEmpty(formValues.END_DATE)){
        	var endDate =  Ext.Date.add (new Date(formValues.END_DATE),Ext.Date.DAY,1)
        	var keyValueJsonObject = this$.getJsonObject( "END_DATE",Ext.Date.format(endDate, CONSTANTS.SUBMIT_DATE_FORMAT));
        	this$.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }
        
        values.searchCriterias = searchcriteria;
        return values;
    },
    /**
     * Reset Adhoc Message Event Search Result Form
     */
    resetAdhocMessageSearchResultForm: function(){
    	var searchForm = this.getAdhocMessageReportSearchForm();
    	var grid =  this.getSendMessageListGrid();
    	searchForm.getForm().reset();
    	searchForm.down("#startDate").setMaxValue(null);
        searchForm.down("#startDate").setValue("");
        searchForm.down("#startDate").setMinValue(null);
        searchForm.down("#endDate").setMaxValue(null);
        searchForm.down("#endDate").setValue("");
        searchForm.down("#endDate").setMinValue(null);
    	var messageSubCategory = searchForm.down('#messageSubCategory');
    	messageSubCategory.getStore().removeAll();
    	messageSubCategory.setDisabled(true);
    },
    
    /**
     * addContainerToForm
     * 
     */
    
    addContainerToForm: function(form, value){
    	var container = this.addDocumentCategoryTemplate(value, false);
    	if(form.getComponent(1).getItemId() != 'documentTemplateButtonContainer'){
    		form.remove(1);
    	}
    	form.insert(1, container);
    },
    
    /**
     * addDocumentCategoryTemplate
     * 
     */
    addDocumentCategoryTemplate: function(value, isMappingSearchForm){
    	var container = {
   			 xtype: 'fieldcontainer',
   			 plugins: "formlabelrequired",
   			 //padding: (isMappingSearchForm)?10:0,
    	        layout: {
    	            type: 'hbox'
    	        },
    	        defaults: {
    	        	width: 226,
    	            labelAlign: 'top'
    	        },
    	        items:[]
    	};
    	switch(value) {
    	
    	case 'ACADEMY_LOCATION_LEVEL':
    		container.items = [{
                xtype: 'customcombobox',
                fieldLabel: getDocumentTranslation('ACADAMY_LOCATION'),
                allowBlank: false,
                editable: false,
                labelAlign: 'top',
                width: 226,
                name: 'academyLocationId',
                itemId: 'acadamyLocationId',
                valueField: 'id',
                displayField: 'value',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.organization.academylocations.AcademyLocationStore');
                        combo.bindStore(store);
                    }
                }
	        }];
    		break;
    	case 'COURSE_LEVEL':
    		container.items = [{
                xtype: 'customcombobox',
                fieldLabel: getDocumentTranslation('ACADAMY_LOCATION'),
                allowBlank: false,
                editable: false,
                labelAlign: 'top',
                width: 226,
                name: 'academyLocationId',
                itemId: 'acadamyLocationCourseId',
                valueField: 'id',
                displayField: 'value',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.organization.academylocations.AcademyLocationStore');
                        combo.bindStore(store);
                    }
                }
                
	        }, {
                xtype: 'customcombobox',
                fieldLabel: getDocumentTranslation('COURSE'),
                allowBlank: false,
                editable: false,
                labelAlign: 'top',
                width: 226,
                name: 'courseId',
                itemId: 'courseId',
                valueField: 'id',
                displayField: 'value',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.course.CourseComboStore');
                        combo.bindStore(store);
                    }
                }
	        }];
    		break;
    	case 'COMMUNITY_LEVEL':
    		container.items = [{
                xtype: 'customcombobox',
                fieldLabel: getDocumentTranslation('COMMUNITY'),
                allowBlank: false,
                editable: false,
                labelAlign: 'top',
                width: 226,
                name: 'communityId',
                itemId: 'communityId',
                valueField: 'id',
                displayField: 'value',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.othermasters.communitymaster.CommunityComboStore');
                        combo.bindStore(store);
                    }
                }
            }];
    		break;
    	case 'PROGRAM_BATCH_SEAT_TYPE_LEVEL':
    		container = {
    			xtype: 'academylocationprogrambatchseattypeform',
            	itemId: 'academyLocationProgramBatchSeatTypeForm',
            	margin: (isMappingSearchForm)?'-10px':0
    		};
    		break;
    	}
    	
    	return container;
    },
    
    /**
     * loadDocumentTemplateMappingGrid
     * 
     */
    loadAdhocMessagingReportselector: function(){
    	var this$ = this;
    	var ownerId = '';
    	var form = this$.getAdhocMessagingReportSearchForm();
    	var formvalues = form.getValues();
        var adhocMessagingReportSelector = this$.getAdhocMessagingReportForm().down("#adhocMessagingReportSelector");
    	var store = adhocMessagingReportSelector.getStore();
    	switch(formvalues.configLevel) {
	    	case 'ACADEMY_LOCATION_LEVEL':
	    		ownerId = formvalues.academyLocationId;
	    		break;
	    	case 'COURSE_LEVEL':
	    		ownerId = formvalues.courseId;
	    		break;
	    	case 'COMMUNITY_LEVEL':
	    		ownerId = formvalues.communityId;
	    		break;
	    	case 'PROGRAM_BATCH_SEAT_TYPE_LEVEL':
	    		var seatType = form.down('#seatTypeCombo');
	    		ownerId = seatType.progBatchSeatConfigId;
	    		break;
    	}
    	
    	adhocMessagingReportSelector.getStore().proxy.extraParams = {
    			ownerId: ownerId,
    			configLevel: formvalues.configLevel
    	};
    	if(adhocMessagingReportSelector.getStore().data.length>0){
    		adhocMessagingReportSelector.getStore().removeAll();
    		adhocMessagingReportSelector.reset();
    	}    	
    	adhocMessagingReportSelector.getStore().load();
    },
    
    /*
     * This function is used for to add selected AdHoc Messaging documents
     *    
     */    
    addSelectedAdhocMsgDocuments:function(button){
    	var AdhocMessagingTab=this.getTabReferenceByTabTitle();
    	var adhocMessagingReportform=button.up('form');
    	var adhocMessagingReportformWindow=button.up('window');
    	if(adhocMessagingReportform){
    		var adhocMessagingReportGrid=AdhocMessagingTab.down("#adhocMessagingReportGrid");
    		var adhocMessagingReportSelector=adhocMessagingReportform.down("#adhocMessagingReportSelector");
    		if(adhocMessagingReportSelector){
    			var selectedAdhocMessagingReportArray=adhocMessagingReportSelector.getValue();
				if(selectedAdhocMessagingReportArray.length>0){
					var successDocumentNames="",duplicateDocumentNames="",msg="";
					for(var selectedReportCount=0;selectedReportCount<selectedAdhocMessagingReportArray.length;selectedReportCount++){						
						var selectedReportRec=adhocMessagingReportSelector.getStore().findRecord('id',selectedAdhocMessagingReportArray[selectedReportCount]);
						if(selectedReportRec){
							var record = adhocMessagingReportGrid.getStore().findRecord('dydtOwnerCnfgId', selectedReportRec.get('id'));
                			if(isEmpty(record)){
                				var gridRecordObject=new Object();							
    							gridRecordObject.dydtOwnerCnfgId=selectedReportRec.get('id');
    							gridRecordObject.documentTypeName=selectedReportRec.get('documentTypeName');
    							gridRecordObject.templateName=selectedReportRec.get('templateName');							
    							adhocMessagingReportGrid.getStore().add(gridRecordObject);
    							successDocumentNames=selectedReportRec.get('templateName')+",";
                			}else{
                				duplicateDocumentNames=selectedReportRec.get('templateName')+",";
                			}							
						}						
					}
					if(successDocumentNames.length>0){
						successDocumentNames=successDocumentNames.substring(0, successDocumentNames.length-1);
						msg=successDocumentNames+getMessagingModuleTranslation('DOCUMENT_ADDED_MSG');  // document(s) added successfully 
					}
					if(duplicateDocumentNames.length>0){
						duplicateDocumentNames=duplicateDocumentNames.substring(0, duplicateDocumentNames.length-1);
						if(msg.length){
							msg=msg+",";
						}
						msg=msg+duplicateDocumentNames+getMessagingModuleTranslation('DUPLICATE_DOCUMENT_ENTRY_MSG'); // document(s) are already attached to adhoc message'
					}
					showSuccessMessage(getMessagingModuleTranslation('ADD_ADHOC_MESSAGING_DOCUMENT'),msg);
					adhocMessagingReportformWindow.close();
				}else{
					showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SELECT_AVAILABLE_ITEMS')); //Please select available items
				}
    		}
    	}
    },
    
    
    /*
     * This function is used for to delete selected AdHoc Messaging Report after clicking on delete button
     *    
     */
    deleteMessagingReportDocument: function(button) {
    	var adhocMessagingDocumentGrid=button.up('grid');         	
        if(adhocMessagingDocumentGrid && adhocMessagingDocumentGrid.getSelectionModel().getCount() > 0) {
        	showConfirmMessage(getMessagingModuleTranslation('DELETE_ADHOC_MESSAGING_DOCUMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                     var records = adhocMessagingDocumentGrid.getSelectionModel().getSelection();
                     for (var count = 0; count < records.length; count++) {
                    	 adhocMessagingDocumentGrid.getStore().remove(records[count]);
                     }
                     showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('DELETE_ADHOC_MESSAGING_DOCUMENT_MSG'));  //Adhoc messaging document deleted successfully
                }
            });
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },
    
    
    /**
     * This method is used for to show add window of adhoc message report
     * @param addButton  - add Button reference
     *          
     */
    addMessagingReportDocument:function(addButton){
    	var adhocMesagingReportFormWindow=this.showWindow('adhocmesagingreportformwindow');
    	if(adhocMesagingReportFormWindow){    		
    		var adhocMessagingReportSelector=adhocMesagingReportFormWindow.down("#adhocMessagingReportSelector");
    		if(adhocMessagingReportSelector){
    			if(adhocMessagingReportSelector.getStore().data.length>0){
    				adhocMessagingReportSelector.getStore().removeAll();
    				adhocMessagingReportSelector.reset();
    			}	
    		}
    	}    	
    },        
    
    
    /**
     * This method is used for to Accept/Reject/Resubmit adhoc message template
     * @param button  - button reference
     * @param successMsg - success message
     *          
     */
    approveRejectResubmitTemplate: function(button,successMsg) {
    	var me=this;
        var commentForm=button.up('form');
        if(commentForm){
        	var adhocmessahebasicsetupform=commentForm.up("adhocmessahebasicsetupform");
        	var adhocReviewCommentTxtArea=commentForm.down("#adhocReviewCommentTxtArea");
        	var messageStatus=button.status;
        	var lastUpdateDate=Ext.Date.format(new Date(),'d-m-Y');
        	var loggedInUser=me.getCurrentlyLoggedInUser();
        	
        	if(adhocReviewCommentTxtArea && !isNullOrEmpty(adhocReviewCommentTxtArea.getValue())){
        		if(adhocmessahebasicsetupform){
        			
        			var jsonObject=new Object();        			        		
        			jsonObject.msgEventConfigId=adhocmessahebasicsetupform.down("#adhocMessageID").getValue();
        			jsonObject.commentByUserName=loggedInUser.value;
        			jsonObject.commentByUserId=loggedInUser.id;
        			jsonObject.comment=adhocReviewCommentTxtArea.getValue();
        			jsonObject.messageStatus=messageStatus;
        			jsonObject.lastUpdate=lastUpdateDate;
        			
        			var jsonFormatFormData=Ext.encode(jsonObject);        			        				        				
        	        if (!isNullOrEmpty(jsonFormatFormData)) {
        	                Ext.Ajax.request({
        	                    type: 'rest',
        	                    url: SERVERURL.REVIEW_ADHOC_MESSAGE_TEMPLATE, //URL - : rest/adhocMsgEventConfigResource/reviewAdhocMessageConfig
        	                    jsonData: jsonFormatFormData,
        	                    method: 'POST',
        	                    success: function(response, form) {
        	                    	if (!isNullOrEmpty(response.responseText) && response.responseText=="true") {
        	                            showSuccessMessage(getCommonTranslation('SUCCESS'), successMsg);
        	                            adhocmessahebasicsetupform.close();
        	                            var SearchForm = me.getAdhocEventsSearchForm();
        	                            if(SearchForm){
        	                            	var reviewStatusCombo=SearchForm.down("#reviewStatusCombo");
        	                            	if(reviewStatusCombo){
        	                            		reviewStatusCombo.setValue("All");
        	                            	}
        	                            }
        	                            me.loadAdhocGridAndSearchRequest();
        	                        }        	                        
        	                    }
        	                });        	            
        			}
        		}
        	}else{
        		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('ENTER_COMMENTS')); //Please enter comment in comment box
        	}
        }
    },
    
    
    /**
     * This method is used for to sent adhoc message template to approval.
     * @param button  - button reference
     * @param successMsg - success message
     *          
     */
    sentTemplateForApproval: function(button,successMsg) {
    	var me=this;
        var adhocmessahebasicsetupform=button.up('form');
        if(adhocmessahebasicsetupform){
        	
        	var messageStatus=button.status;
        	//var lastUpdateDate=Ext.Date.format(new Date(),'d-m-Y');
        	var loggedInUser=me.getCurrentlyLoggedInUser();
        	        	
        	var approver=adhocmessahebasicsetupform.down("#adhocApprover");        	
        	if(approver && !isNullOrEmpty(approver.getValue())){
        		if(adhocmessahebasicsetupform){
        			
        			var jsonObject=new Object();        			        		
        			jsonObject.adhocMsgEventConfigId=adhocmessahebasicsetupform.down("#adhocMessageID").getValue();
        			jsonObject.authorName=loggedInUser.value;
        			jsonObject.authorId=loggedInUser.id;        			
        			jsonObject.messageStatus=messageStatus;
        			//jsonObject.lastUpdate=lastUpdateDate;
        			
        			var jsonFormatFormData=Ext.encode(jsonObject);        			        				        				
        	        if (!isNullOrEmpty(jsonFormatFormData)) {
        	                Ext.Ajax.request({
        	                    type: 'rest',        	                           	                    
        	                    url: SERVERURL.SEND_FOR_APPROVAL_ADHOC_MESSAGE_TEMPLATE, //rest/adhocMsgEventConfigResource/updateReviewStatus
        	                    jsonData: jsonFormatFormData,
        	                    method: 'POST',
        	                    success: function(response, form) {
        	                    	if (!isNullOrEmpty(response.responseText) && response.responseText=="true") {
        	                            showSuccessMessage(getCommonTranslation('SUCCESS'), successMsg);
        	                            adhocmessahebasicsetupform.close();        	   
        	                            var SearchForm = me.getAdhocEventsSearchForm();
        	                            if(SearchForm){
        	                            	var reviewStatusCombo=SearchForm.down("#reviewStatusCombo");
        	                            	if(reviewStatusCombo){
        	                            		reviewStatusCombo.setValue("All");
        	                            	}
        	                            }
                                		me.loadAdhocGridAndSearchRequest();
        	                        }        	                        
        	                    }
        	                });        	            
        			}
        		}
        	}else{
        		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('SELECT_APPROVAR_USER')); //Please select approvar user
        	}        	        	
        }
    },
    
    
    
    /**
     * This method is used to get enable disable parameters for buttons/panels 
     * 
     *     
     */
    getEnableDisableParams:function(record,isAllowToShowReviewCommentTab,isAllowToShowAppRejBtns,isAllowToShowResubmitBtn,isAllowToShowSendForApprovalBtn){
    	
    	if(!isEmpty(record)){
    		record.set('AllowToShowReviewCommentTab',isAllowToShowReviewCommentTab);
    		record.set('AllowToShowAppRejBtns',isAllowToShowAppRejBtns);
    		record.set('AllowToShowResubmitBtn',isAllowToShowResubmitBtn);
    		record.set('AllowToShowSendForApprovalBtn',isAllowToShowSendForApprovalBtn);
    	}    	
		
		return record;
    },
    
        
    /**
     * This method is used to open New Adhoc Event Tab 
     * @param button -  button reference after firing click event    
     */
    openNewAdhocTab:function(button){
    	var tab = this.openTab(getMessagingModuleTranslation('ADD_ADHOC_MESSAGE'), 'adhocmessahebasicsetupform',CONSTANTS.MENU_COLOR_TWELVE);
    	if(tab){
    		this.loadDistrubutionListData(tab);
    	}
    },
    
    /**
     * This method is used for to load combos 
     * @param combo - combo reference     
     */
    loadComboData:function(combo){
    	combo.getStore().load();
    },
    
    loadDistrubutionListData: function(adhocMessageMasterForm){
    	var me=this;
    	if(adhocMessageMasterForm){
    		var adhocDistributionListForm=adhocMessageMasterForm.down("#adhocDistributionListForm");
    		
    		var paramObject=new Object();    				
    		paramObject.msgCatagoryId=null;
    		
    		me.sendGetAjaxRequest(SERVERURL.FIND_ALL_ADOC_MESSAGEING_RECIPIENT_TYPES, 'GET', paramObject, function(option, success, response) {
        		if(success){	
        			var data = Ext.decode(response.responseText);
        			/*if(data.length==0){
        				adhocmessagesubtabpanel.setDisabled(true);
                	}else if(data.length>0){
        				adhocmessagesubtabpanel.setDisabled(false);
                	}*/
                    if(!isEmpty(data)){                            	
                    	
                    	/* First Remove All Components */
                    	Ext.each(adhocDistributionListForm.items.items, function(formCmp) {
                    		adhocDistributionListForm.remove(formCmp);
                    	});
                    	
                    	for(var dataCount=0;dataCount<data.length;dataCount++){
                    		var recipientTypeObject=data[dataCount];
                    		if(!isEmpty(recipientTypeObject)){
                    			
                    			var entityRecipientTypeForm=null;
                    			if(!isNullOrEmpty(recipientTypeObject.code)){
                    				
                    				entityRecipientTypeForm=adhocDistributionListForm.down("#"+recipientTypeObject.code+'recipientTypeForm');
                    				if(!entityRecipientTypeForm){
                    					systemEventConfigDistributionListEntity=me.addDistributionListQueryBuilderViewPanel(adhocDistributionListForm,recipientTypeObject);
                    					entityRecipientTypeForm=adhocDistributionListForm.down("#"+recipientTypeObject.code+'recipientTypeForm');
                    				}
                    				
                    				if(entityRecipientTypeForm){
                    					var templateCombo=entityRecipientTypeForm.down("#templateCombo");
                            			if(templateCombo && !isEmpty(recipientTypeObject.msgTemplateConfigs) && recipientTypeObject.msgTemplateConfigs.length>0){                        				
                            				templateCombo.getStore().loadData(recipientTypeObject.msgTemplateConfigs);
                            			}     
                    				}
                    				                            				                            				
                    			}
                    			
                    		}
                    	}
                    	
                    }
        		}    
    		});
    	}
		    				    				    			    			
},
    
    /**
     * This method is used to load template grid according to search criteria
     * @param model 
     * @param records
     * @return request according to search criteria
     */
    loadAdhocGridAndSearchRequest: function(model, records) {
        var SearchForm = this.getAdhocEventsSearchForm();
        var jsonFormatFormData = this.createJsonFormat(SearchForm, records);
        var adhocEventSearchResultGrid = this.getAdhocEventSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.MESSAGE_ADHOC_EVENT_LIST_VIEWCODE);
        adhocEventSearchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    },
    
    /**
     * This method is used to create JSON format of form values
     * @param SearchForm
     * @return formated JSON of form Values
     */
    createJsonFormat: function(SearchForm) {
    	var this$=this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();
        
        values.configCode = CONSTANTS.CB.MESSAGE_ADHOC_EVENT_LIST_BASIC_CONFIGCODE;
        formValues = SearchForm.getValues();
                
       
        for (var key in formValues) {
            var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All'){
            	if(key == 'TO_DATE') {
            		value = value +' '+'23:59:59'
            	}
                var keyValueJsonObject = this$.getJsonObject( key , value);
                this$.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
            }
        }

        values.searchCriterias = searchcriteria;
        return values;
    },
    
    /**
     * This method is used to crate JSON object
     * @param key 
     * @param value
     * @param additional value
     * @return JSON object
     */
    getJsonObject: function(key, value, additionalValue) {
        if (!isNullOrEmpty(value) && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (!isNullOrEmpty(value) && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    
    /**
     * This method is used to push JSON object into array & create Object array
     *@param JSON object
     *@param array
     *@return JSON object Array
     *
     */
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },

    /**
     * This method is used to clear fields on template search Form
     * @param button which is reference of button
     */
    clearSearchForm: function(button) {
        
        var form=button.up('form');        
        if(form){
        	var basicForm = form.getForm();
        	basicForm.getFields().each(function(field) {
                field.reset();
                if(field.getItemId()=='messageSubCategory'){
                	field.getStore().removeAll();
                }
            });
        
        }                    	
    },
    /**
     * This method is used for to load dependent combo 
     * @param combo - combo reference     
     * @param records - selected combo record
     * @param params - param object to send parameter
     * @param comboItemId -dependent combo Item Id 
     */
    loadDependentComboData:function(combo,records,params,comboItemId,selectedRecordId){
    	var form=combo.up('form');
    	var selectedId=combo.getValue();
    	if(form && !isNullOrEmpty(selectedId)){
    		var dependentCombo=form.down(comboItemId);
    		if(dependentCombo){    	    			
    			dependentCombo.reset();    			    			
    			dependentCombo.getStore().removeAll();
    			dependentCombo.getStore().load({
    					params:params,
    					callback: function(records, operation, success) {
    						if(records.length>0 && !isNullOrEmpty(selectedRecordId)){
    							var selectedRecord=dependentCombo.getStore().getById(selectedRecordId);
    							if(!isEmpty(selectedRecord)){
    								dependentCombo.setValue(selectedRecordId);
    							}else{
    								dependentCombo.setValue("");
    							}
    						} 
    		            }
    				});
    			}
    		}    	
    },
    
    /***
     * This is to disable select template combo on check
     * @param checkbox - checkbox reference     
     * @param newValue - checkbox's new value
     * @param oldValue - checkbox's old value 
     */
    checkAdhocCustomizeTemplateType : function(checkbox,newValue,oldValue){
    	var me=this;
    	var form=checkbox.up('form');  
    	if(form){
    		var selectTemplateCombo=form.down('#selectTemplate');
    		if(!isNullOrEmpty(checkbox.itemId) && checkbox.itemId==='isAdhocCustomizeTemplate' && newValue==true){  
    			selectTemplateCombo.setVisible(false);
    			selectTemplateCombo.setDisabled(true);
    			me.showHideRecepientTemplateCombo(checkbox,true);
        	}else if(!isNullOrEmpty(checkbox.itemId) && checkbox.itemId==='isAdhocCustomizeTemplate' && newValue==false){  
        		selectTemplateCombo.setVisible(true);
        		selectTemplateCombo.setDisabled(false);
        		me.showHideRecepientTemplateCombo(checkbox,false);
        	}
    	}
    	
    },
        
    
    /**
     * This method is to enable schedule field
     */
    loadScheduleField : function(radio,newValue, oldValue){
    	var adhocMessageForm = radio.up('form');
    	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
    	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
    	var radioValue = radio.getValue().sendingPriority;
    	
    	if(radioValue=='IMMEDIATE'){
    		scheduleDateField.setVisible(false);
    		scheduleDateField.setDisabled(true);
    		scheduleTimeField.setVisible(false);
    		scheduleTimeField.setDisabled(true);    		
    	}
    	else if(radioValue=='SCHEDULE'){
    		scheduleDateField.setVisible(true);
    		scheduleDateField.setDisabled(false);
    		scheduleTimeField.setVisible(true);
    		scheduleTimeField.setDisabled(false);
    	}
    },
    
    /**
     * This method is used to add tool-bar at search result grid
     */
    gridRenderFunction: function(grid) {
    	grid.addButtonToolbar();
        /*grid.addDocked({
            xtype: 'toolbar',
            itemId: 'functionButtonsToolbar',
            dock: 'top',
            items: [{
                xtype: 'button',
                itemId: 'searchResultGridBtnAdd',
                tooltip: getCommonTranslation('ADD'),
                glyph: ICONGLYPH.ADDGLYPH
            }, {
                xtype: 'button',
                itemId: 'searchResultGridBtnEdit',                
                tooltip: getCommonTranslation('EDIT'),
                glyph: ICONGLYPH.EDITGLYPH
            },{
                xtype: 'button',
                itemId: 'searchResultGridBtnView',
                tooltip: getCommonTranslation('VIEW'),
                iconCls: 'view-icon'	
            }, {
                xtype: 'button',
                itemId: 'searchResultGridBtnDelete',                
                cls: 'CustomToolbarBtnReject',
                tooltip: getCommonTranslation('DELETE'),
                glyph: ICONGLYPH.DELETEGLYPH
            }]
        });*/
    },
    
    /**
     * This method is used to open New Template Tab 
     * @param button -  button reference after firing click event    
     */
    openAdhocTemplateTab:function(button,grid,isViewMode){
    	var me=this;
    	var record = grid.getSelectionModel().getSelection()[0];
    	var tabTitle = (isViewMode)?getMessagingModuleTranslation('VIEW_ADHOC_MESSAGE'):getMessagingModuleTranslation('EDIT_ADHOC_MESSAGE');        
        var ID = record.get("ID");
        var messageStatus = record.get('MESSAGE_STATUS');
        var isAllowToShowReviewCommentTab=record.get('AllowToShowReviewCommentTab');
        var isAllowToShowAppRejBtns=record.get('AllowToShowAppRejBtns');
        var isAllowToShowResubmitBtn=record.get('AllowToShowResubmitBtn');
        var isAllowToShowSendForApprovalBtn=record.get('AllowToShowSendForApprovalBtn');        
        if(messageStatus != 'SENT'){
        	if (!isNullOrEmpty(tabTitle) && !isNullOrEmpty(ID)) {
            	var param=new Object();        	
            	param.id=ID;
            	me.sendGetAjaxRequest(SERVERURL.ADHOC_MESSAGE_TEMPLATE_FIND_BY_ID, 'GET', param, function(option, success, response) {  //URL-:rest/adhocMsgEventConfigResource/findById
            		if(success){	
            			var data = Ext.decode(response.responseText);
                        if(!isEmpty(data)){                    	
                        	var adhocTemplateTab=me.getTabReferenceByTabTitle(tabTitle);                    
                            if (adhocTemplateTab) {
                            	me.closeTab(adhocTemplateTab);
                            }                    	
                            adhocTemplateTab=me.openTab(tabTitle, 'adhocmessahebasicsetupform');
                        	if(adhocTemplateTab){            
                        		if(!isEmpty(data.wsMsgEventRecipientConfigs) && data.wsMsgEventRecipientConfigs.length>0){
    								data.wsMsgEventRecipientConfigs=Ext.encode(data.wsMsgEventRecipientConfigs);								
    							}
                        		if(!isEmpty(data.wsAdhocRecipients) && data.wsAdhocRecipients.length>0){
    								data.wsAdhocRecipients=Ext.encode(data.wsAdhocRecipients);								
    							}
                        		if(!isNullOrEmpty(data.id)){
    								data.adhocMessageID=data.id;
    								data.adhocMessageStatus=data.status;
    							}                    		
                        		if(!isNullOrEmpty(data.msgDueDate)){
                        			var dateString="",timeString="";	
                        			var date = Ext.Date.parse(data.msgDueDate,'Y-m-d h:i A');
                        			if(date instanceof Date){
                        				dateString = Ext.Date.format(date,'Y-m-d');
                        				timeString = Ext.Date.format(date,'g:i A');
                        			}
                        		    
                        			if(!isNullOrEmpty(dateString) && !isNullOrEmpty(timeString)){

                            			data.msgDueDate=dateString;
                            			data.msgDueDateTime=timeString;
                            			
                        				var scheduleField=adhocTemplateTab.down('#schedule');
                        				if(scheduleField && data.sendingPriority == 'SCHEDULE'){
                        					scheduleField.setValue(true);
                        				}
                        			} 
                        			if(!isNullOrEmpty(data.approverId)){
                        				var isAdhocApprovalRequired=adhocTemplateTab.down('#isAdhocApprovalRequired');
                        				isAdhocApprovalRequired.setValue(true);
                        				var adhocApprover=adhocTemplateTab.down('#adhocApprover');
                        				var adhocApproverStore = adhocApprover.getStore();
                        				adhocApproverStore.load();
                        			}
                        			if(!isNullOrEmpty(data.adhocRcpntMsgTemplateCnfgId) && isNullOrEmpty(data.msgTemplateConfigId)){
                        				var isAdhocCustomizeTemplate=adhocTemplateTab.down('#isAdhocCustomizeTemplate');
                        				isAdhocCustomizeTemplate.setValue(true);
                        			}                   			
                        		}
                        		adhocTemplateTab.getForm().setValues(data);    
                        		
                        		var adhocMessagingReportGrid=adhocTemplateTab.down("#adhocMessagingReportGrid");
                    			if(data.adhocMsgDynamicAttachments.length>0){
                    				for(var selectedReportCount=0;selectedReportCount<data.adhocMsgDynamicAttachments.length;selectedReportCount++){						
                    						var selectedReportRec=data.adhocMsgDynamicAttachments[selectedReportCount];
                    						if(selectedReportRec){
                    							var gridRecordObject=new Object();							                							
                    							gridRecordObject.id=selectedReportRec.id;
                    							gridRecordObject.dydtOwnerCnfgId=selectedReportRec.dydtOwnerCnfgId;
                    							gridRecordObject.documentTypeName=selectedReportRec.documentTypeName;
                    							gridRecordObject.templateName=selectedReportRec.templateName;							
                    							adhocMessagingReportGrid.getStore().add(gridRecordObject);
                    						}						
                    				}
                    			}
                        		
                        		if(!isNullOrEmpty(data.id)){
                        			var adhocCommentHistoryTemplateView=adhocTemplateTab.down('#adhocCommentHistoryTemplateView');
                        			if(adhocCommentHistoryTemplateView){
                        				adhocCommentHistoryTemplateView.getStore().load({
                                			params:{                            				
                                				adhocMsgEventConfigId:data.id
                                			}
                                		});
                        			}                    			
                        		}                    		
                        		
                        		if(!isNullOrEmpty(data.msgCategoryId)  && !isNullOrEmpty(data.msgSubCategoryId)){
                        			var msgCategoryCombo=adhocTemplateTab.down('#adhocMessageCategory');                    			
                        			if(msgCategoryCombo){
                        				msgCategoryCombo.getStore().load({
                        					callback: function(records, operation, success) {
                            					if(records.length>0){
                            						var selectedRecord=msgCategoryCombo.getStore().getById(data.msgCategoryId);                        						
                            						if(!isEmpty(selectedRecord)){
                            							msgCategoryCombo.setValue(data.msgCategoryId);                        						
                            							var params=new Object();                	
                                                    	params.id=data.msgCategoryId;
                                                    	me.loadDependentComboData(msgCategoryCombo,null,params,'#adhocMessageSubCategory',data.msgSubCategoryId);                                                	                                                	
                            						}
                            					}    						
                            		         }		
                        				});                    				
                        			}                    			
                        		}
                        		if(!isNullOrEmpty(data.msgSubCategoryId)){
                        			var messageSubCategoryCombo=adhocTemplateTab.down('#adhocMessageSubCategory');
                        			if(messageSubCategoryCombo){
                        				var params=new Object();                	
                                    	params.msgCatagoryId=data.msgSubCategoryId;
                                    	params.availableForAdhoc= true;
                                    	me.loadDependentComboData(messageSubCategoryCombo,null,params,'#selectTemplate',data.msgTemplateConfigId);
                                    	me.addRecipientTypes(data.msgSubCategoryId,messageSubCategoryCombo,true,data);
                        			}                                        			
                            	}               
                        		
                        		if(isViewMode){                    			
                        			me.SetMessagingTemplateInViewMode(adhocTemplateTab);
                        		}else{           
                        			/* Only for Edit Mode */
                        	        if(isAllowToShowReviewCommentTab){
                        	        	var adhocReviewCommentTab=adhocTemplateTab.down('#adhocReviewComment');
                        	        	if(adhocReviewCommentTab){
                        	        		adhocReviewCommentTab.setDisabled(false);
                        	        		
                        	        		var adhocapprejcommenttabpanel=adhocReviewCommentTab.up('adhocapprejcommenttabpanel');
                        	        		if(adhocapprejcommenttabpanel){
                        	        			adhocapprejcommenttabpanel.setActiveTab(adhocReviewCommentTab);
                        	        		}                    	        		
                        	        		
                        	        		var adhocMsgSubmitBtn=adhocTemplateTab.down('#adhocMsgSubmitBtn');
                            	        	var btnadhocSendForApproval=adhocTemplateTab.down('#btnadhocSendForApproval');
                        	        		
                            	        	var adhocReviewCommentTxtArea=adhocTemplateTab.down('#adhocReviewCommentTxtArea');
                        	        		adhocReviewCommentTxtArea.setVisible(true);                    	        		
                        	        		adhocReviewCommentTxtArea.setDisabled(false);
                        	        		
                        	        		adhocMsgSubmitBtn.setVisible(false);
                        	        		btnadhocSendForApproval.setVisible(false);
                        	        		
                            	        	if(isAllowToShowResubmitBtn){
                            	        		var btnAdhocReSubmitForApprovalComment=adhocTemplateTab.down('#btnAdhocReSubmitForApprovalComment');
                            	        		btnAdhocReSubmitForApprovalComment.setVisible(true);
                            	        		btnAdhocReSubmitForApprovalComment.setDisabled(false);
                            	        		                              	        		
                            	        	}else if(isAllowToShowAppRejBtns){
                            	        		me.SetMessagingTemplateInViewMode(adhocTemplateTab);
                            	        		adhocReviewCommentTxtArea.setReadOnly(false);
                            	        		var btnAdhocApproveReviewComment=adhocTemplateTab.down('#btnAdhocApproveReviewComment');
                            	        		var btnAdhocRejectReviewComment=adhocTemplateTab.down('#btnAdhocRejectReviewComment');
                            	        		
                            	        		btnAdhocApproveReviewComment.setVisible(true);
                            	        		btnAdhocApproveReviewComment.setDisabled(false);
                            	        		
                            	        		btnAdhocRejectReviewComment.setVisible(true);
                            	        		btnAdhocRejectReviewComment.setDisabled(false);
                            	        		
                            	        	}
                        	        	}                    	        	
                        	        }
                        	        if(isAllowToShowSendForApprovalBtn){
                        	        	var adhocMsgSubmitBtn=adhocTemplateTab.down('#adhocMsgSubmitBtn');
                        	        	var btnadhocSendForApproval=adhocTemplateTab.down('#btnadhocSendForApproval');
                        	        	if(btnadhocSendForApproval){
                        	        		btnadhocSendForApproval.setVisible(true);
                        	        		btnadhocSendForApproval.setDisabled(false);
                        	        		adhocMsgSubmitBtn.setDisabled(false);
                        	        	}
                        	        }
                        		}
                        	}                    	
                        }
            		}
            		
                });        	          
            }
        }else {
        	showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('MESSAGE_SENT_ALREADY')); //Message has been already sent,you cannot edit template
        }
            	                    	
    },
    
    SetMessagingTemplateInViewMode:function(adhocTemplateTab){    	       
    	adhocTemplateTab.down('#btnadhocSendForApproval').setVisible(false);
    	adhocTemplateTab.down('#adhocMsgSubmitBtn').setVisible(false);
    	adhocTemplateTab.getForm().getFields().each(function(field) {
			 if(!isNullOrEmpty(field.itemId) && field.itemId!=="ckEditor" && field.itemId!=="reportSelector" && field.itemId!=="messageScopeSelector"){
				 field.setReadOnly(true);
			 }                    			      
		 });
    },    
    
    /**
     * This method is used for to check approval assigned to adhoc message template  
     * @param checkbox - checkbox reference     
     * @param newValue - checkbox's new value
     * @param oldValue - checkbox's old value 
     */
    checkApproval:function(checkbox,newValue,oldValue){
    	var form=checkbox.up('form');    	    	
    	if(form){
    		var adhocApprover=form.down('#adhocApprover');    
    		var btnadhocSendForApproval=form.down('#btnadhocSendForApproval');
    		if(newValue==true){
    			adhocApprover.setDisabled(false);
    			adhocApprover.setVisible(true);
    			btnadhocSendForApproval.setVisible(true);
        	}else if(newValue==false){
        		adhocApprover.clearValue();
        		adhocApprover.setDisabled(true);
        		adhocApprover.setVisible(false);
        		btnadhocSendForApproval.setVisible(false);
        	}    		
    	}    	
    },
    
    
    /**
     * This method is used for to save/update adhoc recepient data  
     * @param button - save button reference   
     * 
     */
    saveAdhocRecepientData: function(button) {
    	var me=this;    	
    	var adhocRecepientform=button.up('form');
		var adhocRecepientWindow=button.up('window');
    	var masterForm=me.getTabReferenceByTabTitle();    	
		if(masterForm){
			var wsAdhocRecipients=masterForm.down("#wsAdhocRecipients");
			var adhocMessageID=masterForm.down("#adhocMessageID");
	    	if(adhocRecepientform){
	    		var adhocRecepientDataArray=new Array();
	    		var formValues=adhocRecepientform.getValues();
	    		if(formValues && !isNullOrEmpty(formValues.emailIds)){
	    			var adhocRecepientEmailData=new Object();
	    			adhocRecepientEmailData.id=(!isNullOrEmpty(formValues.emailDBId))?formValues.emailDBId:null;
	    			adhocRecepientEmailData.msgEventConfigId=(!isNullOrEmpty(adhocMessageID.getValue()))?adhocMessageID.getValue():null;
	    			adhocRecepientEmailData.contactType="EMAIL";
	    			adhocRecepientEmailData.contacts=formValues.emailIds;
	    			adhocRecepientDataArray.push(adhocRecepientEmailData);
	    		}    		
	    		if(formValues && !isNullOrEmpty(formValues.mobileNos)){
	    			var adhocRecepientMobileData=new Object();
	    			adhocRecepientMobileData.id=(!isNullOrEmpty(formValues.mobileDBId))?formValues.mobileDBId:null;
	    			adhocRecepientMobileData.msgEventConfigId=(!isNullOrEmpty(adhocMessageID.getValue()))?adhocMessageID.getValue():null;
	    			adhocRecepientMobileData.contactType="MOBILE_NO";
	    			adhocRecepientMobileData.contacts=formValues.mobileNos;
	    			adhocRecepientDataArray.push(adhocRecepientMobileData);
	    		}
	    		if(adhocRecepientDataArray.length>0){
	    			wsAdhocRecipients.setValue(Ext.encode(adhocRecepientDataArray));
	    			showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('DISTRIBUTION_LIST_RULE_CRITERIA_SAVED_MSG'));
	    			adhocRecepientWindow.close();
	    		}else{
	    			showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_ENTER_AT_LEAST_ONE_DETAILS'));
	    		}    			    		
			}
    	}    	
		
    },
    
    
    /**
     * This method is used for to save/update adhoc message template  
     * @param button - save button reference   
     * 
     */
    saveUpdateAdhocMessageTemplate: function(button,isResubmitForApprovalFlow,btnReSubmitForApproval) {
    	var me=this;
    	var adhocEventSearchResultGrid = me.getAdhocEventSearchResultGrid();
        var adhocMsgTemplateForm = button.up('form');                
        var submitUrl = '',methodName = '',isUpdate = false;
        if (adhocMsgTemplateForm) {                                               
    		
        	var returnVal=me.validateBasicAdhocMessageTemplateForm(adhocMsgTemplateForm);                			
			if(returnVal==0){
				return 0;	
			}
        	        	
            var isAdhocCustomizeTemplate=adhocMsgTemplateForm.down("#isAdhocCustomizeTemplate");     
            if(isAdhocCustomizeTemplate){
            	var returnVal=me.validateDistributionList(adhocMsgTemplateForm,isAdhocCustomizeTemplate.getValue());                			
    			if(returnVal==0){
    				return 0;	
    			}               
            }                                           

            var adhocMsgHiddenField = adhocMsgTemplateForm.down('#adhocMessageID');
            var adhocMsgStatusHiddenField= adhocMsgTemplateForm.down('#adhocMessageStatus');
            if (isNullOrEmpty(adhocMsgHiddenField.getSubmitValue())) {            	
                submitUrl = SERVERURL.ADOC_MESSAGEING_CREATE, //rest/adhocMsgEventConfigResource/create
                methodName = 'POST';
                isUpdate = false;
            } else {            	
                submitUrl = SERVERURL.ADOC_MESSAGEING_UPDATE, //rest/adhocMsgEventConfigResource/update
                methodName = 'PUT';
                isUpdate = true;
            }
            
            var jsonFormatFormData = me.createJsonFormatFormData(adhocMsgTemplateForm); 
            
            
            if (!isNullOrEmpty(submitUrl) && !isNullOrEmpty(methodName) && !isNullOrEmpty(jsonFormatFormData)) {
                Ext.Ajax.request({
                    type: 'rest',
                    url: submitUrl,
                    method: methodName,
                    jsonData: jsonFormatFormData,
                    success: function(response, action) {                        	                        	                                               	
                    	
                    	var isAdhocApprovalRequired=adhocMsgTemplateForm.down('#isAdhocApprovalRequired');
                    	var btnadhocSendForApproval=adhocMsgTemplateForm.down('#btnadhocSendForApproval');
                    	var adhocMsgSubmitBtn=adhocMsgTemplateForm.down('#adhocMsgSubmitBtn');
                    	
                    	if(isAdhocApprovalRequired.getValue() && !isUpdate){ //Create with approval
                    		btnadhocSendForApproval.setDisabled(false);
                    		adhocMsgSubmitBtn.setDisabled(true);
                    		var hiddenIDField=adhocMsgTemplateForm.down("#adhocMessageID");
                    		if(hiddenIDField && !isNullOrEmpty(response.responseText)){
                    			hiddenIDField.setValue(response.responseText);
                    		}
                    		me.giveSuccessMsg(isUpdate);
                    	}else if(!isNullOrEmpty(isResubmitForApprovalFlow) && isResubmitForApprovalFlow){
                    		var hiddenIDField=adhocMsgTemplateForm.down("#adhocMessageID");
                    		if(hiddenIDField && !isNullOrEmpty(response.responseText)){
                    			hiddenIDField.setValue(response.responseText);
                    		}
                    		me.approveRejectResubmitTemplate(btnReSubmitForApproval,getMessagingModuleTranslation('ADHOC_TEMP_RESUBMITTED_MSG')); //Adhoc message template resubmitted successfully.
                    	}else{
                    		adhocMsgTemplateForm.close();  
                    		me.giveSuccessMsg(isUpdate);
                    		var SearchForm = me.getAdhocEventsSearchForm();
                            if(SearchForm){
                            	var reviewStatusCombo=SearchForm.down("#reviewStatusCombo");
                            	if(reviewStatusCombo){
                            		reviewStatusCombo.setValue("All");
                            	}
                            }
                    		me.loadAdhocGridAndSearchRequest();
                    	}
                    }                    
                });
            }
        }
    },
    
    giveSuccessMsg:function(isUpdate){
    	if (isUpdate) {
            showSuccessMessage(getMessagingModuleTranslation('ADHOC_MESSAGE'), getMessagingModuleTranslation('UPDATE_ADHOC_MESSAGE_MSG')); //Adhoc message updated successfully												
        } else {
            showSuccessMessage(getMessagingModuleTranslation('ADHOC_MESSAGE'), getMessagingModuleTranslation('ADD_ADHOC_MESSAGE_MSG')); //Adhoc message added successfully												
        }
    },
    
    /**
     * This method is used for to create save/update adhoc message json format   
     * @param adhocMsgForm - adhoc message form reference
     * 
     */
    createJsonFormatFormData:function(adhocMsgForm){
    	var me=this;    	
    	var adhocMessageJsonData=new Object();
    	
    	var adhocMsgFormData = adhocMsgForm.getValues(); 
    	if(!isEmpty(adhocMsgFormData)){
    		
    		var commonMessageTemplateCombo=adhocMsgForm.down("#selectTemplate");    		
    		adhocMessageJsonData.id=(!isNullOrEmpty(adhocMsgFormData.adhocMessageID)) ? adhocMsgFormData.adhocMessageID : null;
    		adhocMessageJsonData.status=(!isNullOrEmpty(adhocMsgFormData.adhocMessageStatus)) ? adhocMsgFormData.adhocMessageStatus : null;
    		if(commonMessageTemplateCombo && !isNullOrEmpty(commonMessageTemplateCombo.getValue())){
    			adhocMessageJsonData.msgTemplateConfigId=commonMessageTemplateCombo.getValue();
    		}else{
    			adhocMessageJsonData.msgTemplateConfigId=null;
    		}    		
    		adhocMessageJsonData.sendingPriority=(!isNullOrEmpty(adhocMsgFormData.sendingPriority)) ? adhocMsgFormData.sendingPriority : null;
    		adhocMessageJsonData.msgCategoryId=(!isNullOrEmpty(adhocMsgFormData.msgCategoryId)) ? adhocMsgFormData.msgCategoryId : null;
    		adhocMessageJsonData.msgSubCategoryId=(!isNullOrEmpty(adhocMsgFormData.msgSubCategoryId)) ? adhocMsgFormData.msgSubCategoryId : null;
    		
    		if(adhocMsgFormData.sendingPriority==="SCHEDULE"){
    			if(!isNullOrEmpty(adhocMsgFormData.msgDueDate) && !isNullOrEmpty(adhocMsgFormData.msgDueDateTime)){
	    			var dateString="";
	    			dateString=adhocMsgFormData.msgDueDate+" "+adhocMsgFormData.msgDueDateTime;
	    			adhocMessageJsonData.msgDueDate=dateString;
	    		}else{
	    			adhocMessageJsonData.msgDueDate= null;
	    		}
    		}else if(adhocMsgFormData.sendingPriority==="IMMEDIATE"){
    			/*var now = new Date();
    			var dateString = Ext.Date.format(now,'Y-m-d h:i A');*/
    			adhocMessageJsonData.msgDueDate=null;
    		}else{
    			adhocMessageJsonData.msgDueDate= null;
    		}
	        		    		    		
    		adhocMessageJsonData.messageId=(!isNullOrEmpty(adhocMsgFormData.messageId)) ? adhocMsgFormData.messageId : null;
    		adhocMessageJsonData.displayCode=(!isNullOrEmpty(adhocMsgFormData.displayCode)) ? adhocMsgFormData.displayCode : null;
    		adhocMessageJsonData.wsMsgEventRecipientConfigs=(!isNullOrEmpty(adhocMsgFormData.wsMsgEventRecipientConfigs)) ? Ext.decode(adhocMsgFormData.wsMsgEventRecipientConfigs) : null;
    		adhocMessageJsonData.wsAdhocRecipients=(!isNullOrEmpty(adhocMsgFormData.wsAdhocRecipients)) ? Ext.decode(adhocMsgFormData.wsAdhocRecipients) : null;
        	
    		if(!isNullOrEmpty(adhocMsgFormData.approverId)){
    			adhocMessageJsonData.approverId=adhocMsgFormData.approverId.id;
    			adhocMessageJsonData.approvalRequired = true;
        	}else{
        		adhocMessageJsonData.approverId=null;
        		adhocMessageJsonData.approvalRequired = false;
        	}       	 
    		
    		var academyLocation=me.getCurrentAcademyLocation();
        	if(!isNullOrEmpty(academyLocation)){
        		adhocMessageJsonData.academyLocationId=academyLocation;
        	}
        	
        	var currentlyLoggedInUser=me.getCurrentlyLoggedInUser();
        	if(!isEmpty(currentlyLoggedInUser)){
        		adhocMessageJsonData.authorId=currentlyLoggedInUser.id;
        		adhocMessageJsonData.authorName=currentlyLoggedInUser.value;
        	}
        	
        	var isAdhocApprovalRequired=adhocMsgForm.down('#isAdhocApprovalRequired');
        	if(isAdhocApprovalRequired.getValue()){
        		adhocMessageJsonData.reviewStatusCode=CONSTANTS.MSG_TEMP_DRAFT;
        	}else{
        		adhocMessageJsonData.reviewStatusCode=CONSTANTS.MSG_TEMP_APPROVED;
        	}        	        	
        	
    		
    		var adhocMessagingReportGrid=adhocMsgForm.down("#adhocMessagingReportGrid");
    		if(adhocMessagingReportGrid && adhocMessagingReportGrid.getStore().data!=undefined && adhocMessagingReportGrid.getStore().data.length>0){
    			adhocMessageJsonData=me.addAdhocMessagingReports(adhocMessageJsonData,adhocMessagingReportGrid);
    		}
    	}
    	
    	return Ext.encode(adhocMessageJsonData);
    },
    
    addAdhocMessagingReports:function(adhocMessageJsonData,adhocMessagingReportGrid){
    	var adhocMsgDynamicAttachments=new Array();
    	for(var storeRecCount=0;storeRecCount<adhocMessagingReportGrid.getStore().data.items.length;storeRecCount++){
    		var storeRecord=adhocMessagingReportGrid.getStore().data.items[storeRecCount];
    		if(storeRecord){
    			var adhocMsgDynamicAttachmentObj=new Object();
    			adhocMsgDynamicAttachmentObj.id=(!isNullOrEmpty(storeRecord.get('id')))?storeRecord.get('id'):null;    			    			
    			adhocMsgDynamicAttachmentObj.documentTypeName=storeRecord.get('documentTypeName');    			
    			//adhocMsgDynamicAttachmentObj.dydtOwnerCnfgId=storeRecord.get('dydtOwnerCnfgId'); Template Name
    			adhocMsgDynamicAttachmentObj.dydtOwnerCnfgId=storeRecord.get('dydtOwnerCnfgId');    			
    			adhocMsgDynamicAttachments.push(adhocMsgDynamicAttachmentObj);
    		}
    	}
    	adhocMessageJsonData.adhocMsgDynamicAttachments=adhocMsgDynamicAttachments;
    	
    	return adhocMessageJsonData;
    },

    /**
     * This method is used for to validate Basic Adhoc Message Template Form  
     *     
     * @param adhocMsgTemplateForm - main panel form container reference        
     *                 
     */
    validateBasicAdhocMessageTemplateForm:function(adhocMsgTemplateForm){
    	    	    	    	
    	var returnVal=1;
    	var messageId=adhocMsgTemplateForm.down("#messageId");
    	var messageName=adhocMsgTemplateForm.down("#messageName");
    	var adhocMessageCategory=adhocMsgTemplateForm.down("#adhocMessageCategory");    	
    	var adhocMessageSubCategory=adhocMsgTemplateForm.down("#adhocMessageSubCategory");
    	var isAdhocCustomizeTemplate=adhocMsgTemplateForm.down("#isAdhocCustomizeTemplate");
    	var selectTemplateCombo=adhocMsgTemplateForm.down("#selectTemplate");
    	var sendingPriority=adhocMsgTemplateForm.down('#sendingPriority');
    	
    	if(
    	   (messageId && isNullOrEmpty(messageId.getValue().trim())) ||
    	   (messageName && isNullOrEmpty(messageName.getValue().trim())) ||
    	   (adhocMessageCategory && isNullOrEmpty(adhocMessageCategory.getValue())) ||
    	   (adhocMessageSubCategory && isNullOrEmpty(adhocMessageSubCategory.getValue()))
    	  ){    		
    		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_ENTER_BASIC_FORM_DETAILS')); //Please enter basic form details
    		adhocMsgTemplateForm.isValid();
    		returnVal=0;
	    	return returnVal;
    	}    	
    	
    	if(
    		(isAdhocCustomizeTemplate && isAdhocCustomizeTemplate.getValue()==false) &&
    		(selectTemplateCombo && isNullOrEmpty(selectTemplateCombo.getValue()))	
    	  ){
    		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SELECT_TEMPLATE_VALUE')); //Please select template value
    		selectTemplateCombo.isValid();
    		returnVal=0;
	    	return returnVal;    		
    	}
    	
    	if(sendingPriority && isEmpty(sendingPriority.getValue())){
    		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_ENTER_SENDING_PRIORITY_DETAILS')); //Please enter sending priority details
    		returnVal=0;
	    	return returnVal;
    	}else{
			var priorityObject=sendingPriority.getValue();
    		if(!isEmpty(priorityObject) && !isNullOrEmpty(priorityObject.sendingPriority) && (priorityObject.sendingPriority==="SCHEDULE")){
    			var scheduleDate=adhocMsgTemplateForm.down("#scheduleDate");
    	    	var scheduleTime=adhocMsgTemplateForm.down("#scheduleTime");
    	    	
    	    	if(
    	       	   (scheduleDate && isNullOrEmpty(scheduleDate.getValue())) ||
    	       	   (scheduleTime && isNullOrEmpty(scheduleTime.getValue()))
    	       	  ){    		
    	    	    showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_ENTER_SCHEDULE_DETAILS')); //Please enter schedule details
    	    	    returnVal=0;
    	    		return returnVal;
    	    	}
    		}    		
    	}
    	
    	var isAdhocApprovalRequired=adhocMsgTemplateForm.down("#isAdhocApprovalRequired");
        if(isAdhocApprovalRequired.getValue()){
        	var adhocApprover = adhocMsgTemplateForm.down("#adhocApprover").getValue();
        	if(!Ext.isNumber(adhocApprover) || isNullOrEmpty(adhocApprover)){	
        		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('SELECT_APPROVAR_USER'));
        		returnVal=0;
	    		return returnVal;
        	}
        }
    	
    	return returnVal;
    },

    /**
     * This method is used for to validate Adhoc distribution list
     *     
     * @param adhocMsgTemplateForm - main panel form container reference 
     * @param whetherCommonMsgTemplate -  this flag indicates whether Common Msg Template used or per recipient wise template used  
     *           
     */
    validateDistributionList:function(adhocMsgTemplateForm,whetherEachRecipientTypeTemplate){
    	    	    	    	
    	var returnVal=1;
    	var adhocMessagingDistributionListEntity=adhocMsgTemplateForm.down("#adhocDistributionListForm");
    	var wsMsgEventRecipientConfigField=adhocMsgTemplateForm.down('#wsMsgEventRecipientConfigs');
    	var wsAdhocRecipientsField=adhocMsgTemplateForm.down('#wsAdhocRecipients');
    	
    	if(adhocMessagingDistributionListEntity){   
    		if(isNullOrEmpty(wsAdhocRecipientsField.getValue()) && isNullOrEmpty(wsMsgEventRecipientConfigField.getValue())){
//				var fieldSetTitle = fieldSetObj.down('displayfield');
				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SET_DISTRIBUSTION_RULE_FOR_RECIPIENTS')); //Please set distribustion list for _____ Receipient 
		    	returnVal=0;
		    	return false;	    			
    		}
	    		/*Ext.each(adhocMessagingDistributionListEntity.items.items, function(form) {
	    			var formDataObject=form.getForm().getValues();
    	    		if(!isEmpty(formDataObject)){
    	    			var fieldSetObj=form.down('fieldset');
    	    			var recipientCode=formDataObject.recipientCode;
    	    					
    	    			if(!isNullOrEmpty(recipientCode) && recipientCode==="AdhocRecipients" && isNullOrEmpty(wsAdhocRecipientsField.getValue()) && isNullOrEmpty(wsMsgEventRecipientConfigField.getValue())){
    	    				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SET_EMAIL_MOBILE_NO_FOR_ADHOC_RECIPIENTS')); //Please set email Ids,mobile nos for Adhoc Recipients
    				    	returnVal=0;
    				    	return false;    	    				
    	    			}else if(isNullOrEmpty(wsAdhocRecipientsField.getValue()) && isNullOrEmpty(wsMsgEventRecipientConfigField.getValue())){
    	    				var fieldSetTitle = fieldSetObj.down('displayfield');
    	    				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SET_DISTRIBUSTION_LIST_FOR')+"'"+fieldSetTitle.fieldLabel+"'"); //Please set distribustion list for _____ Receipient 
    				    	returnVal=0;
    				    	return false;	    			
    		    		}		  
    	    		}
	    		});	*/    	
    	}	
	    return returnVal;    	    	
    },
    
    /**
     * This method is used for to delete  adhoc message template  
     * @param button - button reference   
     * 
     */
    deleteAdhocMessageTemplate: function(button) {
    	var grid =button.up('grid'),submitURL="";
    	if(grid){
    		var grdStore = grid.getStore();
    		if (grid.getSelectionModel().getCount() > 0) {        	
            	showConfirmMessage(getMessagingModuleTranslation('DELETE_ADHOC_MESSAGING_TEMPLATE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                    if (btn == 'yes') {
                    	 if (grid.getSelectionModel().getCount() > 0) {
                             var records = grid.getSelectionModel().getSelection();
                             var ids = [];
                             for (var count = 0; count < records.length; count++) {
                                 var id = "";     
                                 if (!isNullOrEmpty(records[count].get("ID"))) {
                                     id = records[count].get("ID");
                                     ids.push(id)
                                 }
                             }
                             if(isNullOrEmpty(submitURL)){
                            	 submitURL=SERVERURL.ADHOC_MESSAGE_TEMPLATE_DELETE_ALL;  //URL-rest/adhocMsgEventConfigResource/delete
                            	 submitURL=submitURL.concat("?ids="+ids.join());
                             }
                             Ext.Ajax.request({
                                 type: 'rest',                                     
                                 url: submitURL, 													 
                                 method: 'DELETE',
                                 success: function(form, action) {
                                     grdStore.reload();
                                     showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('DELETE_ADHOC_MESSAGING_TEMPLATE_MSG')); //Adhoc Message Template deleted successfully
                                 }
                             });
                         }
                    }
                });        	
            } else {
            	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
            }
    	}                        
    },
    
    cancelScheduleAdhocMessage: function(button) {
    	var win = button.up('window');
    	var cancelationReason = win.down('#cancelationReasonId').getValue();
    	var grid = this.getAdhocEventSearchResultGrid(),submitURL="";

        var records = grid.getSelectionModel().getSelection();
        var idAndReasonMap = new Ext.util.HashMap();
        var ids = [];
        for (var count = 0; count < records.length; count++) {
            var id = "";     
            if (!isNullOrEmpty(records[count].get("ID"))) {
                id = records[count].get("ID");
                ids.push(id)
            }
        }
        if(isNullOrEmpty(submitURL)){
       	 submitURL=SERVERURL.CANCEL_SCHEDULE_ADHOC_MESSAGE; 
        }
        idAndReasonMap.add("ID",ids.join());
        idAndReasonMap.add("CANCELLATIONREASON",cancelationReason);
        var idAndReasonMap = Ext.encode(idAndReasonMap.map);
        Ext.Ajax.request({
            type: 'rest',                                     
            url: submitURL, 													 
            method: 'POST',
            jsonData: idAndReasonMap,
            success: function(form, action) {
            	grid.getStore().reload();
                showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('CANCEL_SCHEDULE_ADHOC_MESSAGE_MSG'));
                win.close();
            }
        });
    
    },
    
    /**
     * This method is used for to show or hide each recepient template combo
     * @param combo - check box Reference     
     * @param whetherShow - whether show or hide template combo flag
     *  
     */
    showHideRecepientTemplateCombo:function(checkBox,whetherShow){    	
    	var me=this;
    	var adhocMessageMasterForm=checkBox.up('adhocmessahebasicsetupform');
    	if(adhocMessageMasterForm){
    		
    		var adhocmessagesubtabpanel=adhocMessageMasterForm.down("adhocmessagesubtabpanel");
    		var adhocDistributionListForm=adhocMessageMasterForm.down("#adhocDistributionListForm");
    		
    		if(adhocmessagesubtabpanel && adhocDistributionListForm){
    			
    			Ext.each(adhocDistributionListForm.items.items, function(form) {
    				if(form){
    					var recepientTemplateCombo=form.down("#templateCombo");
    					if(recepientTemplateCombo){
    						if(whetherShow){
    							recepientTemplateCombo.setVisible(true);
    						}else{
    							recepientTemplateCombo.setVisible(false);
    						}
    					}
    				}
    			});
    		}	
    	}    	
    },
    
    /**
     * This method is used for to reset dependent form fields 
     * @param combo - combo Reference     
     *  
     */
    resetDependentFormFields:function(combo){
    	
    	var adhocMessageMasterForm=combo.up('adhocmessahebasicsetupform');
    	if(adhocMessageMasterForm){
    		
    		var isAdhocCustomizeTemplate=adhocMessageMasterForm.down("#isAdhocCustomizeTemplate");    		
    		var adhocMessageSubCategory=adhocMessageMasterForm.down("#adhocMessageSubCategory");
    		var adhocDistributionListForm=adhocMessageMasterForm.down("#adhocDistributionListForm");
    		var adhocmessagesubtabpanel=adhocMessageMasterForm.down("adhocmessagesubtabpanel");
    		
    		if(adhocMessageSubCategory && combo.itemId==="adhocMessageCategory"){
    			adhocMessageSubCategory.reset();
    		}
    		
    		if(isAdhocCustomizeTemplate && isAdhocCustomizeTemplate.getValue()==true){
    			isAdhocCustomizeTemplate.setValue(false);
    		}    		
    		
    		if(adhocDistributionListForm && adhocmessagesubtabpanel){
    			/* First remove all dynamic form components */
            	Ext.each(adhocDistributionListForm.items.items, function(formCmp) {
            		adhocDistributionListForm.remove(formCmp);
            	});        	
//            	adhocmessagesubtabpanel.setDisabled(true);
    		}    		        	
    	}    		
    },
    
    /**
     * This method is used to add recipient types dynamically
     * @param selectedCategoryId - selected message category Id
     * @param combo - combo Reference     
     * @param isUpdate - update flag
     *  
     */
    addRecipientTypes:function(selectedCategoryId,combo,isUpdate,updateData){
    	var me=this;
    	var adhocMessageMasterForm=combo.up('adhocmessahebasicsetupform');
    	if(adhocMessageMasterForm){
    		var adhocDistributionListForm=adhocMessageMasterForm.down("#adhocDistributionListForm");
    		var isAdhocCustomizeTemplate=adhocMessageMasterForm.down("#isAdhocCustomizeTemplate");
    		var adhocmessagesubtabpanel=adhocMessageMasterForm.down("adhocmessagesubtabpanel");
    		
    		if(adhocDistributionListForm && !isNullOrEmpty(selectedCategoryId)){
    			
    				var paramObject=new Object();    				
    				paramObject.msgCatagoryId=selectedCategoryId;
    				
    				me.sendGetAjaxRequest(SERVERURL.FIND_ALL_ADOC_MESSAGEING_RECIPIENT_TYPES, 'GET', paramObject, function(option, success, response) {
                		if(success){	
                			var data = Ext.decode(response.responseText);
//                			if(data.length==0){
//                				adhocmessagesubtabpanel.setDisabled(true);
//                        	}else if(data.length>0){
//                				adhocmessagesubtabpanel.setDisabled(false);
//                        	}
                            if(!isEmpty(data)){                            	
                            	
                            	/* First Remove All Components */
                            	Ext.each(adhocDistributionListForm.items.items, function(formCmp) {
                            		adhocDistributionListForm.remove(formCmp);
                            	});
                            	
                            	for(var dataCount=0;dataCount<data.length;dataCount++){
                            		var recipientTypeObject=data[dataCount];
                            		if(!isEmpty(recipientTypeObject)){
                            			
                            			var entityRecipientTypeForm=null;
                            			if(!isNullOrEmpty(recipientTypeObject.code)){
                            				
                            				entityRecipientTypeForm=adhocDistributionListForm.down("#"+recipientTypeObject.code+'recipientTypeForm');
                            				if(!entityRecipientTypeForm){
                            					systemEventConfigDistributionListEntity=me.addDistributionListQueryBuilderViewPanel(adhocDistributionListForm,recipientTypeObject);
                            					entityRecipientTypeForm=adhocDistributionListForm.down("#"+recipientTypeObject.code+'recipientTypeForm');
                            				}
                            				
                            				if(entityRecipientTypeForm){
                            					var templateCombo=entityRecipientTypeForm.down("#templateCombo");
                                    			if(templateCombo && !isEmpty(recipientTypeObject.msgTemplateConfigs) && recipientTypeObject.msgTemplateConfigs.length>0){                        				
                                    				templateCombo.getStore().loadData(recipientTypeObject.msgTemplateConfigs);
                                    			}     
                                    			
                                    			
                                    			if(isUpdate){       
                                    				                                    				
                                    				var recipientTypeId=entityRecipientTypeForm.getValues()['recipientTypeId'];   	
                        	            			var masterFormValues=adhocMessageMasterForm.getForm().getValues();
                        	            			//var isImplicitFlow=systemeventconfigmasterform.down("#isImplicitFlow").getValue();
                        	            			
                        	            				if(!isEmpty(masterFormValues)){
                        	            					if(!isNullOrEmpty(masterFormValues.wsMsgEventRecipientConfigs)){
                        	                					var wsMsgEventRecipientConfigs=Ext.decode(masterFormValues.wsMsgEventRecipientConfigs);
                        	                					
                        	                					if(wsMsgEventRecipientConfigs.length>0){
                        	                						for(var count=0;count<wsMsgEventRecipientConfigs.length;count++){
                        	                							var recepientObj=wsMsgEventRecipientConfigs[count];
                        	                							if(!isEmpty(recepientObj)){
                        	                								if(recipientTypeId==recepientObj.msgRecipientTypeId){
                        	                									
                        	                									entityRecipientTypeForm.getForm().setValues(recepientObj);
                        	                									break;
                        	                    							}
                        	                							}    							
                        	                						}
                        	                					}
                        	                				}
                        	            				}
                                    			}                                    			
                            				}
                            				                            				                            				
                            			}
                            			
                            		}
                            	}
                            	
                            	if(data.length>0){
                            		if(isUpdate && !isEmpty(updateData) && !isNullOrEmpty(updateData.msgTemplateConfigId)){
                            			isAdhocCustomizeTemplate.setValue(false);
                            		}                            		
                            	}
                            }
                		}    
        		});    				    				    			    			
    		}
    	}
    },
    
      
    /**
     * This method is used to add recipient form dynamically
     * @param adhocDistributionListForm - recipient form panel container reference 
     * @param recipientTypeObject - form data object to set in recipient form
     *  
     */
    addDistributionListQueryBuilderViewPanel:function(adhocDistributionListForm,recipientTypeObject){
    	    	
    	if(adhocDistributionListForm && !isEmpty(recipientTypeObject)){
    		
    		adhocDistributionListForm.add({
    			xtype:'form',		        		
        		itemId: recipientTypeObject.code+'recipientTypeForm',
        		items:[{
    		        xtype: 'fieldset',    		        
    		        //title: recipientTypeObject.code,              		        
    		        //padding: '10 0 0 0',  
    		        height: '30px !important',
    		        style : {
    		        	marginTop : '-10px !important'
    		        },
    		        items: [{
		        			xtype:'hidden',
		        			name:'id',
		        			itemId:'id'
        				},{
    	        			xtype:'hidden',
    	        			name:'recipientCode',
    	        			itemId:'recipientCode',
    	        			value:recipientTypeObject.code
            			},{
    	        			xtype:'hidden',
    	        			name:'recipientTypeId',
    	        			itemId:'recipientTypeId',
    	        			value:recipientTypeObject.id
            			},{    	    
            				xtype:'hidden',
            				name:'msgRecipientTypeId',
            				itemId:'msgRecipientTypeId'	
            			},{
    	        			xtype:'hidden',
    	        			name:'distrListProviderId',
    	        			itemId:'distrListProviderId',
    	        			value:recipientTypeObject.distrListProviderId
    	        		},{
    		        		xtype:'hidden',
    		        		name:'distrRuleProviderId',
    		        		itemId:'distrRuleProviderId',
    		        		value:recipientTypeObject.distrRuleProviderId
    		        	},{
    		        		xtype:'hidden',
    		        		name:'distrListInstanceImplicitId',
    		        		itemId:'distrListInstanceImplicitId'
    		        	},{
    			        xtype: 'fieldcontainer', 
    			        layout: 'hbox',
    			        defaults: {
    			            //labelAlign: 'top',
    			            //width: 226
    			        },
    			        items: [{
    			        	xtype:'displayfield',
    			        	fieldLabel: getMessagingModuleTranslation(recipientTypeObject.code),
    			        	labelWidth: 110,
    			        	style : {
    			        		fontWeight: 'bold',
    			        		fontSize: '13px !important'
    			        	}
    			        },{
    			        	xtype:'textfield',
    			        	name:'buildListName',
    			        	width: 350,
    			        	itemId:'buildListName',
    			        	hidden:true,
    			        	fieldLabel: getMessagingModuleTranslation('BUILD_LIST_NAME'),
    			        	hidden:true,
    			            allowBlank: false
    			        },{
    			            xtype: 'customcombobox',
    			            //fieldLabel: getMessagingModuleTranslation('SELECT_TEMPLATE'),
    			            emptyText: getMessagingModuleTranslation('SELECT_TEMPLATE'),                
    			            editable: false,
    			            width: 226,
    			            name: 'msgTemplateConfigId',
    			            itemId: 'templateCombo',
    			            valueField: 'id',
    			            queryMode: 'local',
    			            displayField: 'code',
    			            hidden:true,    			            
    			            allowBlank: false,
    			            listeners: {
    			            	render: function(combo){
    			            		var store = Ext.create('Academia.store.messaging.MessageTemplate');
    			            		combo.bindStore(store);
    			            	}
    			            }
    			        },{
    			            xtype: 'button',
    			            text: ((!isNullOrEmpty(recipientTypeObject.code))?getMessagingModuleTranslation(recipientTypeObject.code):"")+"  "+getMessagingModuleTranslation('BUILD_LIST'),
    			            itemId: 'buildListButton',
    			            buttonAlign: 'right',  
    			            width: 226,
    			            ui: 'CustomBtnSubmit',
    			            /*style:{
    			            	marginTop:'28px'
    			            },*/
    			            scale: CONSTANTS.BUTTONSIZE
    			        }]
    			    }]
    	        }]
    		});
        	
    		adhocDistributionListForm.doLayout();
    	}
    	
    	return adhocDistributionListForm;    	    	    	
    },
    
    /**
     * This method is used to show Build List Dialog Box
     * @param button - Button Reference
     * 
     */
    showBuildListWindow: function(button){
    	var me=this;
    	var cachedRecipientDistrbutionListObject=null;
    	var cachedRecipientDistrbutionRuleObject=null;
    	
    	var masterForm=button.up('adhocmessahebasicsetupform');
    	if(masterForm){
    		     			
    		var recepientTypeform=button.up('form');
	    	if(recepientTypeform){
	    		
	    		var templateCombo=recepientTypeform.down("#templateCombo");
	    		var recipientCode=recepientTypeform.down("#recipientCode");
	    		
	    		var formDataObject=recepientTypeform.getValues();
	    		if(!isEmpty(formDataObject) && templateCombo && templateCombo.isVisible()){
	    			var fieldSetObj=recepientTypeform.down('fieldset');
	    			
	    			if(isNullOrEmpty(formDataObject.msgTemplateConfigId)){
	    				var fieldSetTitle = fieldSetObj.down('displayfield');
	    				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SELECT_TEMPLATE_FOR')+"'"+fieldSetTitle.fieldLabel+"'"); //Please select template for _____ Receipient     	    	    				
	    				return 0;
	    			}
	    		}	    	
	    		
	    		if(recipientCode && recipientCode.getValue()==="AdhocRecipients"){
	    			var adhocrecepientwindow=me.showWindow('adhocrecepientwindow');
	    			
	    			var adhocRecepientform=adhocrecepientwindow.down("#adhocRecepientform");
	    			if(adhocRecepientform){
	    				
	    				var emailDBId=adhocRecepientform.down("#emailDBId");
	    				var emailIds=adhocRecepientform.down("#emailIds");
	    				var mobileDBId=adhocRecepientform.down("#mobileDBId");
	    				var mobileNos=adhocRecepientform.down("#mobileNos");
	    				
	    				var wsAdhocRecipientsObjString=masterForm.down("#wsAdhocRecipients").getValue();	    			    			    		
	         			if(!isNullOrEmpty(wsAdhocRecipientsObjString)){
		    				  var wsAdhocRecipients= Ext.decode(wsAdhocRecipientsObjString);
		    			      if(!isEmpty(wsAdhocRecipients) && wsAdhocRecipients.length>0){	    			    	  
		    			    	  
	          						for(var count=0;count<wsAdhocRecipients.length;count++){
	          							var adhocRecepientDataObj=wsAdhocRecipients[count];
	          							if(!isEmpty(adhocRecepientDataObj)){
	          								if(adhocRecepientDataObj.contactType=="EMAIL"){
	          									emailDBId.setValue(adhocRecepientDataObj.id);
	          									emailIds.setValue(adhocRecepientDataObj.contacts);	          									
	              							}
	          								if(adhocRecepientDataObj.contactType=="MOBILE_NO"){
	          									mobileDBId.setValue(adhocRecepientDataObj.id);
	          									mobileNos.setValue(adhocRecepientDataObj.contacts);	          									
	              							}
	          							}    							
	          						}	          							    			    	  
		    			      }
		    			}
	    			}	    								    		    	
	    		}else{
	    			
	    			var adhocmessagedistributionrule=me.showWindow('adhocmessagedistributionrule');
		    	    if(adhocmessagedistributionrule){
		    	     				
		    	    	adhocmessagedistributionrule.setTitle(button.getText());
		    	     				
		    	     	var adhocMessageDistributionList=adhocmessagedistributionrule.down('#adhocMessageDistributionList');    	     	
		    	     			
		    	     	if(adhocMessageDistributionList){
		    	     		adhocMessageDistributionList.setVisible(true);    	     		    	     		    	     		
		        	    	if(recepientTypeform){
		        	    		
		        	    		var recipientTypeId=recepientTypeform.getValues()['recipientTypeId'];   	
		            			var masterFormValues=masterForm.getForm().getValues();
		            			
		            			if(!isEmpty(masterFormValues)){
		            					if(!isNullOrEmpty(masterFormValues.wsMsgEventRecipientConfigs)){
		                					var wsMsgEventRecipientConfigs=Ext.decode(masterFormValues.wsMsgEventRecipientConfigs);
		                					
		                					if(wsMsgEventRecipientConfigs.length>0){
		                						for(var count=0;count<wsMsgEventRecipientConfigs.length;count++){
		                							var recepientObj=wsMsgEventRecipientConfigs[count];
		                							if(!isEmpty(recepientObj)){
		                								if(recipientTypeId==recepientObj.msgRecipientTypeId){
		                									cachedRecipientDistrbutionListObject=recepientObj.distrListInstance;
		                									cachedRecipientDistrbutionRuleObject=recepientObj.distrRuleInstance;
		                									break;
		                    							}
		                							}    							
		                						}
		                					}
		                			}
		            			}        				    	    	
		        	    	}
		    	     		
		        	    	/* Add Distribution List dynamically */    	        	    	     	     		
		     	     		me.addSystemEventMessagingRuleEditorPanel(button,masterForm,adhocmessagedistributionrule,'#adhocMessageDistributionList','adhocMessageDistributionListRuleEditor','distrListProviderId',cachedRecipientDistrbutionListObject);    	     	     			     	     		
		    	     	}
		    	    }
	    		}	    		    	        	    
	    	}   
    	}     	
    },
   
    /**
     * This method is used to add System Event Messaging Rule Editor Panel dynamically
     * @param button - button Reference
     * @param adhocmessagedistributionrule - This is main form panel container reference  
     * @param systemEventConfigurationPanelId - This is a container panel id  
     * @param ruleEditorItemId - This is a item ID of System Event Messaging Rule Editor Panel
     * @param providerId - This is a provider Id name of form 
     * @param cachedRecipientObject - cached Recipient Object
     * 
     */
    addSystemEventMessagingRuleEditorPanel:function(button,systemeventconfigmasterform,adhocmessagedistributionrule,systemEventConfigurationPanelId,ruleEditorItemId,providerId,cachedRecipientObject){
    	var me=this;
    	var recepientTypeform=button.up('form');
    	
    	if(recepientTypeform){
    		var systemEventConfigurationPanel=adhocmessagedistributionrule.down(systemEventConfigurationPanelId);
    		if(systemEventConfigurationPanel){
    			    			
    				if(isEmpty(cachedRecipientObject)){
    					
    					var providerValue=recepientTypeform.getValues()[providerId];
    	    			if(!isNullOrEmpty(providerValue)){
    	    				var paramObject=new Object();
    	    				paramObject.id=providerValue;				
    	    				    				
    	    				me.sendGetAjaxRequest(SERVERURL.FIND_DEFAULT_CONFIG_BY_DATA_PROVIDER_ID, 'GET', paramObject, function(option, success, response) { //URL - :'rest/sysMsgEvtDefaultRecipientResource/findDefaultDataProviderConfigById'
    	                		if(success){	
    	                			var data = Ext.decode(response.responseText);
    	                            if(!isEmpty(data)){
    	                            	
    	                            	if(!isEmpty(data.cbSearchCriteria)){
    	                            		
    	                            		var qyeryBuilderView=systemEventConfigurationPanel.down("#"+ruleEditorItemId);
    	                            		if(!qyeryBuilderView){
    	                            			systemEventConfigurationPanel=me.addDistributionRuleQueryBuilderViewPanel(systemEventConfigurationPanel,ruleEditorItemId,data.configCode,data.viewCode);
    	                            			qyeryBuilderView=systemEventConfigurationPanel.down("#"+ruleEditorItemId);
    	                            		}
    	                            		
    	                            		systemEventConfigurationPanel.getForm().findField("msgRecipientTypeId").setValue(recepientTypeform.getValues()['recipientTypeId']);
    	                            		systemEventConfigurationPanel.getForm().findField("msgTemplateConfigId").setValue(recepientTypeform.getValues()['msgTemplateConfigId']);
        	                            	systemEventConfigurationPanel.getForm().findField("dataProviderId").setValue(providerValue);        	                            	
        	                            	systemEventConfigurationPanel.getForm().findField("searchConfigCode").setValue(data.configCode);
        	                            	systemEventConfigurationPanel.getForm().findField("searchResultViewCode").setValue(data.viewCode);
    	                                	                                	                            	        	                            	        	                            	
        	                            	me.setDefaultSearchCriteriaInCached(systemEventConfigurationPanel,data.cbSearchCriteria,qyeryBuilderView);
    	                            	}                       	
    	                            }
    	                		}    
    	        			});    				    				
    	    			}
    				}else{
    					
						if(!isEmpty(cachedRecipientObject.advancedSearchDTO)){
                    		
							var qyeryBuilderView=systemEventConfigurationPanel.down("#"+ruleEditorItemId);
                    		if(!qyeryBuilderView){
                    			systemEventConfigurationPanel=me.addDistributionRuleQueryBuilderViewPanel(systemEventConfigurationPanel,ruleEditorItemId,cachedRecipientObject.searchConfigCode,cachedRecipientObject.searchResultViewCode);
                    			qyeryBuilderView=systemEventConfigurationPanel.down("#"+ruleEditorItemId);
                    		}
                    		
                    		systemEventConfigurationPanel.getForm().findField("id").setValue(cachedRecipientObject.id);
                    		
                    		systemEventConfigurationPanel.getForm().findField("msgRecipientTypeId").setValue(recepientTypeform.getValues()['recipientTypeId']);
                    		systemEventConfigurationPanel.getForm().findField("msgTemplateConfigId").setValue(recepientTypeform.getValues()['msgTemplateConfigId']);
                        	systemEventConfigurationPanel.getForm().findField("dataProviderId").setValue(cachedRecipientObject.dataProviderId);
                        	systemEventConfigurationPanel.getForm().findField("savedRuleRefId").setValue(cachedRecipientObject.savedRuleRefId);                        	
                        	systemEventConfigurationPanel.getForm().findField("searchConfigCode").setValue(cachedRecipientObject.searchConfigCode);
                        	systemEventConfigurationPanel.getForm().findField("searchResultViewCode").setValue(cachedRecipientObject.searchResultViewCode);
                        	
                        	me.setDefaultSearchCriteriaInCached(systemEventConfigurationPanel,cachedRecipientObject.advancedSearchDTO.cbSearchCriteria,qyeryBuilderView);                        	
                    	}	
						
    				}

    			}
    			    			
    		}
    	
    },
    
    /**
     * This method is used to distribution rule/list advanced search panel
     * @param systemEventConfigurationPanel  - panel reference which contain advance search panel
     * @param ruleEditorItemId - rule Editor Item Id
     * @param configCode - config Code 
     * @param viewCode - view Code    
     * 
     */    
    addDistributionRuleQueryBuilderViewPanel:function(systemEventConfigurationPanel,ruleEditorItemId,configCode,viewCode){
    	
    	if(systemEventConfigurationPanel && !isNullOrEmpty(ruleEditorItemId) && !isNullOrEmpty(configCode) && !isNullOrEmpty(viewCode)){
    		
    		systemEventConfigurationPanel.add({
    			xtype: 'systemeventmessagingruleeditor',
        		itemId:ruleEditorItemId,		 
        		searchConfigCode :configCode,
        		searchResultViewCode:viewCode                            		
        	});
    		systemEventConfigurationPanel.doLayout();
    	}
    	
    	return systemEventConfigurationPanel;
    },
    
    /**
     * This method is used for to set default Search Criteria In Cache
     * @param systemeventconfigform - form container which contain advance search panel
     * @param cbSearchCriteria- advance search json data object  
     * @param qyeryBuilderView- advance searh panel 
     * 
     */    
    setDefaultSearchCriteriaInCached:function(systemeventconfigform,cbSearchCriteria,qyeryBuilderView){
    	
    	if(!isEmpty(cbSearchCriteria)){
    		
    		var whetherPassedDefaultSearchCriteriaToCMP=false;
    		var componentCopyOfCbSearchCriteria=cbSearchCriteria;	                                		
    		var defaultSearchCriteria=cbSearchCriteria;
    		
    		var defaultSearchCriterias=new Array();
    		var passedToCmpSearchCriterias=new Array();
    		
    			                                			
    			//if(!isEmpty(cbSearchCriteria.searchCriterias) && cbSearchCriteria.searchCriterias.length>0){
    				for(var searchCriteriaCount=0;searchCriteriaCount<cbSearchCriteria.searchCriterias.length;searchCriteriaCount++){
    					var searchCriteriaObject=cbSearchCriteria.searchCriterias[searchCriteriaCount];
    					if(!isEmpty(searchCriteriaObject)){	                                						
    						if(searchCriteriaObject.visibility==false && searchCriteriaObject.whetherEditable==false){
    							defaultSearchCriterias.push(searchCriteriaObject);	                                								                                						
    						}else if(searchCriteriaObject.visibility==true && searchCriteriaObject.whetherEditable==true){
    							passedToCmpSearchCriterias.push(searchCriteriaObject);	                                							
    							if(!whetherPassedDefaultSearchCriteriaToCMP){
    								whetherPassedDefaultSearchCriteriaToCMP=true;
    							}
    						}/*else{
    							defaultSearchCriterias.push(searchCriteriaObject);
    						}*/	                                						
    					}
    				}
    				
    				if(defaultSearchCriterias.length>0){
						if(!defaultSearchCriterias[0].searchCriterias){
							defaultSearchCriteria.searchCriterias=defaultSearchCriterias;    						 	
							if(defaultSearchCriteria.visibility==false && defaultSearchCriteria.whetherEditable==false){
    							systemeventconfigform.down("#defaultSearchCriterias").setValue(Ext.encode(defaultSearchCriteria));
    						}
						}else{
							if(defaultSearchCriterias[0].visibility==false && defaultSearchCriterias[0].whetherEditable==false){
    							systemeventconfigform.down("#defaultSearchCriterias").setValue(Ext.encode(defaultSearchCriterias[0]));
    						}
						}    					
    				}
    				
    				if(passedToCmpSearchCriterias.length>0){
    					componentCopyOfCbSearchCriteria.searchCriterias=passedToCmpSearchCriterias;	                                					
    				}
    				
    				var myMask = new Ext.LoadMask(qyeryBuilderView, {msg:"Please wait..."});
    				myMask.show();
    				
    				qyeryBuilderView.loadConfiguration(qyeryBuilderView,componentCopyOfCbSearchCriteria,whetherPassedDefaultSearchCriteriaToCMP,myMask);
    				
    				return passedToCmpSearchCriterias;
    					                                					                                								
    			//}
    		//}	                                		
    	}
    	
    },
    
    
    /**
     * This method is used for to set adhoc message event configuration Recipient object
     * @param Panel - Recipient Panel reference
     * @param form - Recipient Panel container form
     *           
     */
    setSystemMessageRecipientObject:function(Panel,form,instanceType){
    	var me=this;
    	var masterForm=me.getTabReferenceByTabTitle();    	
    		if(masterForm){
    			var wsMsgEventRecipientConfigs=new Array();
    			var selectedRecipientTypeId="";
    			var selectedRecipientTemplateId="";
    			var isExist=false;    			
    			var success = false;
    			var templateCombo=masterForm.down("#selectTemplate");
    			var isAdhocCustomizeTemplate=masterForm.down("#isAdhocCustomizeTemplate");
    				
    			if(form){
	    	    	var formDataObject=form.getValues();
	    	    	if(!isEmpty(formDataObject) && !isNullOrEmpty(formDataObject.msgRecipientTypeId)){
	    	    		selectedRecipientTypeId=formDataObject.msgRecipientTypeId;
	    	    		if(!isNullOrEmpty(formDataObject.msgTemplateConfigId)){	    	    			
	    	    			selectedRecipientTemplateId=formDataObject.msgTemplateConfigId;
	    	    		}
	    	    		if(isAdhocCustomizeTemplate && isAdhocCustomizeTemplate.getValue()==false){
	    	    			if(templateCombo && !isNullOrEmpty(templateCombo.getValue())){
		    	    			selectedRecipientTemplateId=templateCombo.getValue();
		    	    		}	    	    	
	    	    		}	    	    			
	    	    	}
	    	    }
    			
    			var wsMsgEventRecipientConfigsObjString=masterForm.down("#wsMsgEventRecipientConfigs").getValue();
				if(!isNullOrEmpty(wsMsgEventRecipientConfigsObjString)){
					
					wsMsgEventRecipientConfigs= Ext.decode(masterForm.down("#wsMsgEventRecipientConfigs").getValue());
	    	    	if(!isEmpty(wsMsgEventRecipientConfigs)){
	    	    			    		
	    	    		for(var count=0;count<wsMsgEventRecipientConfigs.length;count++){
	    	    			var wsMsgEventRecipientConfigObject=wsMsgEventRecipientConfigs[count];
	    	    			if(!isEmpty(wsMsgEventRecipientConfigObject)){
	    	    				var msgRecipientTypeId=wsMsgEventRecipientConfigObject.msgRecipientTypeId;
	    	    				if(msgRecipientTypeId==selectedRecipientTypeId){
	    	    					isExist=true;
	    	    					var advancedSearchDTOObj=Panel.getSearchCriteriaJsonObject();
	    	    		    		if(!isEmpty(advancedSearchDTOObj)){
	    	    		    			advancedSearchDTOObj=me.setDefaultSearchCriteriaInDistribution(advancedSearchDTOObj,form);
	    	    		    			if(!isEmpty(advancedSearchDTOObj.cbSearchCriteria.searchCriterias)){
	    	    		    				var instanceObject=me.createSystemMessageEventConfigInstanceObject(form,advancedSearchDTOObj);
		    	    		    			wsMsgEventRecipientConfigs[count][instanceType]=instanceObject;
		    	    		    			wsMsgEventRecipientConfigs[count]["msgTemplateConfigId"]=selectedRecipientTemplateId;
		    	    		    			masterForm.down("#wsMsgEventRecipientConfigs").setValue(Ext.encode(wsMsgEventRecipientConfigs));
		    	    		    			success = true;
		    	    		    			break;
	    	    		    			}else{
	    	    		    				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_ENTER_DISTRIBUTION_LIST_CRITERIA'));
	    	    		    				return;
	    	    		    			}
	    	    		    			
	    	    		    		}	
	    	    				}
	    	    			}
	    	    			    			
	    	    		} 
	    	    		
	    	    	}
				}
				
				if(!isExist){
	    			var recipientObject=new Object();
	    			var advancedSearchDTOObj=Panel.getSearchCriteriaJsonObject();
		    		if(!isEmpty(advancedSearchDTOObj)){		    			
		    			advancedSearchDTOObj=me.setDefaultSearchCriteriaInDistribution(advancedSearchDTOObj,form);
		    			if(!isEmpty(advancedSearchDTOObj.cbSearchCriteria.searchCriterias)){
		    				var instanceObject=me.createSystemMessageEventConfigInstanceObject(form,advancedSearchDTOObj);		    			
			    			recipientObject.msgRecipientTypeId=selectedRecipientTypeId;
			    			recipientObject.msgTemplateConfigId=selectedRecipientTemplateId;
			    			if(instanceType==='distrRuleInstance'){
			    				recipientObject.distrRuleInstance=instanceObject;
			    			}else if(instanceType==='distrListInstance'){
			    				recipientObject.distrListInstance=instanceObject;
			    			}
			    			wsMsgEventRecipientConfigs.push(recipientObject);
			    			masterForm.down("#wsMsgEventRecipientConfigs").setValue(Ext.encode(wsMsgEventRecipientConfigs));
			    			success=true;
		    			}else{
		    				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_ENTER_DISTRIBUTION_LIST_CRITERIA'));
		    			}
		    			
		    		}		    			
	    		}
				if(!isEmpty(wsMsgEventRecipientConfigs) && success==true){
					Panel.up('window').close();            		 
					showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('DISTRIBUTION_LIST_RULE_CRITERIA_SAVED_MSG')); //Distribution list criteria has saved successfully
	    		}else{
	    			showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_ENTER_DISTRIBUTION_LIST_CRITERIA'));
	    		}
    		}  
    },
    
    
    /**
     * This method is used for to set default search criteria object in distribution list
     * @param advancedSearchDTOObj - initiation Rule Panel reference
     * @param form - distribution list/rule container form
     *           
     */
    setDefaultSearchCriteriaInDistribution:function(advancedSearchDTOObj,form){
    	if(advancedSearchDTOObj){
    		if(!isEmpty(advancedSearchDTOObj.cbSearchCriteria)){
    			if(advancedSearchDTOObj.cbSearchCriteria.searchCriterias){
    				if(!isNullOrEmpty(form.down("#defaultSearchCriterias").getValue())){
    					var defaultSearchCriteria=Ext.decode(form.down("#defaultSearchCriterias").getValue());
    					if(!isEmpty(defaultSearchCriteria)){            							            							
    						advancedSearchDTOObj.cbSearchCriteria.searchCriterias.push(defaultSearchCriteria);            							
    					}
    				}            					
    			}
    		}
    	}    
    	return advancedSearchDTOObj;
    },
    
    /**
     * This method is used to create System Message Event Config Instance Object and keep inside form hidden value
     * @param form - Initiation rule container form OR distribution list/rule container form
     * @param advancedSearchDTOObj - advance search criteria builder json oject 
     * 
     */        
    createSystemMessageEventConfigInstanceObject:function(form,advancedSearchDTOObj){
    	
    	var instanceDataObject=new Object();    	
    	instanceDataObject.whetherUpdate=true; //Send this flag always true
    	
    	if(form){
    		var formDataObject=form.getValues();
    		if(!isEmpty(formDataObject)){
    			instanceDataObject.id=(!isNullOrEmpty(formDataObject.id))?formDataObject.id:null;
    			instanceDataObject.dataProviderId=(!isNullOrEmpty(formDataObject.dataProviderId))?formDataObject.dataProviderId:null;
    			instanceDataObject.savedRuleRefId=(!isNullOrEmpty(formDataObject.savedRuleRefId))?formDataObject.savedRuleRefId:null;
    			instanceDataObject.searchConfigCode=(!isNullOrEmpty(formDataObject.searchConfigCode))?formDataObject.searchConfigCode:"";
    			instanceDataObject.searchResultViewCode=(!isNullOrEmpty(formDataObject.searchResultViewCode))?formDataObject.searchResultViewCode:"";
    			instanceDataObject.advancedSearchDTO=(!isEmpty(advancedSearchDTOObj))?advancedSearchDTOObj:null;
    		}
    	}
    	
    	return instanceDataObject;
    	
    },
  //******************************Export ******************************************************
	    exportUserList : function(exportUrl,filetype,whetherAll) {
	        var quickSearchForm=this.getAdhocEventsSearchForm(); 
	        var searchResultGrid = this.getAdhocEventSearchResultGrid();
	        var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	        var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	        var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
	        var visibleColumns=this.getVisibleColumns(searchResultGrid);
	        var reportTitle=getCommonTranslation('ADHOC_MESSAGE_LIST');
	if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
	                      jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
	               }
	searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	
	},
	 exportAdhocEventList : function(exportUrl,filetype,whetherAll) {
	        var quickSearchForm=this.getAdhocMessageReportSearchForm(); 
	        var searchResultGrid = this.getAdhocMessageReportSearchResultGrid();
	        var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	        var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	        var jsonFormatFormData=this.createSearchResultReportJsonFormat(quickSearchForm);
	        var visibleColumns=this.getVisibleColumns(searchResultGrid);
	        var reportTitle=getCommonTranslation('ADHOC_MESSAGE_LIST');
	if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
	                      jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
	               }
	searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	
	},
	createSearchCriteriaString: function(searchForm) {
	    	var me=this;
	        var formValues = new Array();
	        formValues = searchForm.getValues();        
	        var searchCriteriaString="";
	        for (var key in formValues) {
	        	var value = formValues[key]; 
	        	var i=0;
	            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
	            	var keyValueJsonObject = me.getJsonObject( key , value);
	            	if(keyValueJsonObject.paramCode != "DELIVERY_MODE"){
	            	    searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
	            	}else{
						for(i in value){
							if(keyValueJsonObject.paramCode == "DELIVERY_MODE" && value[i] == 1){
								searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+getMessagingModuleTranslation('EMAIL') + " ,";
							}else if(keyValueJsonObject.paramCode == "DELIVERY_MODE" && value[i] == 2){
								searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+getMessagingModuleTranslation('SMS') + " ,";
							}else if(keyValueJsonObject.paramCode == "DELIVERY_MODE" && value[i] == 3){
								searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+getMessagingModuleTranslation('LETTER') + " ,";
							}else if(keyValueJsonObject.paramCode == "DELIVERY_MODE" && value[i] == 4){
								searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+getMessagingModuleTranslation('SYS_INTERNAL_MSG')+ " ,";
							}else if(keyValueJsonObject.paramCode == "DELIVERY_MODE" && value[i] == 5){
								searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+getMessagingModuleTranslation('WEB_LINK')+ " ,";
							}	            	    
						}
	            	}
	            }
	        }
	        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	        return searchCriteriaString;
	},
	openSendMessageReportLink: function(record){
		var id = record.get('msgRcpntLogId');
		if(!isNullOrEmpty(id)){
			Ext.Ajax.request({
				type: 'rest',
				url: SERVERURL.PATH_FIND_MSG_CONTENT_BY_MSG_RCPNTLOG_ID,													 
				method: 'GET',
				async: false,
				headers: {
					'Content-Type': 'application/json'
				},
				params: {
					id: id
				},
				success: function(response, form, action) {
					responseObject = eval("(" + response.responseText + ")"); //make object of response text
					var msgContent = responseObject.msgContent;

					var win = new Ext.Window({
						title: getMessagingModuleTranslation('MESSAGE_CONTENT'),
						frame: true,
						height : 405 ,
						minWidth:767, 
						width: 800, 
						autoScroll:true,
						modal:true,
						html: msgContent,
						cls: 'messageContentWinCls'
					});
					win.show();

				},
				failure: function(form, action) {
					//showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
				}
			});
		}
	},
	openAttachedDocumentLink: function(record){
		var $this = this;
		var id = record.get('msgRcpntLogId');
		if(!isNullOrEmpty(id)){
			var isWhetherSysMsgEvent = false;
			var eventName = record.get('eventName');
			if(!isNullOrEmpty(eventName)){
				isWhetherSysMsgEvent = true;
			}
			
			var gridMessageList = $this.getSendMessageListGrid();
            
        	if(gridMessageList.getSelectionModel().getCount() == 0) {
        		gridMessageList.getSelectionModel().select(record);
        	}

			var formWindow = $this.getSendmessageattacheddocumentwin();
			if (!formWindow) {
			//	Ext.widget('sendmessageattacheddocumentwin');
				formWindow = Ext.widget('sendmessageattacheddocumentwin',{
					  itemId:'masgeSendReportItemId'
				  });
				//formWindow = $this.getSendmessageattacheddocumentwin();
			}
			formWindow.show();
			var documentGrid = formWindow.down('#sendMessageDocumentGridItemId');
			documentGrid.getStore().getProxy().extraParams = {
				id: id,
				whetherSysMsgEvent:isWhetherSysMsgEvent
			};
			documentGrid.getStore().load();
		/*	documentGrid.getStore().load({
				callback: function(records, operation, success) {
					for(i in records){
						
					}
					$this.isStaticDocOfMSR = records[0].data.staticDocOfMSR;
				}
			}); */
            gridMessageList.getSelectionModel().select();
		}
	},
	downloadAttachedDocumentFile : function(documentId,isWhetherSysMsgEvent,staticDocOfMSR){
    	if(!isNullOrEmpty(documentId)){
    		var csvForm = Ext.create('Ext.form.Panel'); 
	    	csvForm.getForm().submit({
		    	target: '_blank',
		    	method:'GET',
		    	params :{
		    		access_token : Ext.Ajax.defaultHeaders.access_token,
		    		id: documentId,
					whetherSysMsgEvent:isWhetherSysMsgEvent,
					staticDocOfMSR:staticDocOfMSR
		    	},
		    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		    	url: SERVERURL.PATH_DOWNLOAD_MSG_DOCUMENTS,
		    	standardSubmit :true
	    	});
    	}
    },
    
    addCancelAdhocMessageButton:function(grid) {
    	var cancelMsgButton={
    			xtype: 'button',
    			itemId: 'btnCancelAdhocMsg',
    			disabled:true,
    			text:getCommonTranslation('CANCEL_ADHOC_MSG'),
    			tooltip: getCommonTranslation('CANCEL_ADHOC_MSG')
    		};
    	grid.down('#functionButtonsToolbar').insert(4,cancelMsgButton);
    },
    loadOtherCombo:function(){
    	var form = this.getSendMessageReportStructure();
		var programNameCombo = form.down('#programId').getValue();
		var academyLocationId = form.down('#academyLocationId').getValue();
		var stdNameCombo = form.down('#studentId');
		var batchNameCombo = form.down('#batchId').getValue();
		var periodNameCombo = form.down('#periodId').getValue();
		var sectionNameCombo = form.down('#sectionId').getValue();
		var programGroup = form.down('#Program_Group').getValue();
		var intakeYear = form.down('#intakeYearPlcDriveId').getValue();
		
		stdNameCombo.getStore().getProxy().extraParams = {
			academyLocationIds:academyLocationId,
			program:programNameCombo,
			section:sectionNameCombo,
			batch:batchNameCombo,
			period:periodNameCombo,
			intakeYear:intakeYear,
			programGroup:programGroup
		};
		stdNameCombo.getStore().load();
    }
});
