/**
 * 
 */
Ext.define('Academia.controller.organization.AcademyController', {
    extend: 'Academia.controller.base.BaseController',
    models: ['organization.AcademiesStructure'],
    stores: ['organization.AcademiesStructureStore', 
             'common.picklist.AcademyTypeStore', 'common.StatusComboStore'],
    views: ['organization.academies.AcademiesStructureGrid',
            'organization.academies.AcademiesFormWindow', 'common.CustomFieldForm'],
            
    alias: "widget.AcademiesController",
    refs: [{
        ref: 'academiesForm',
        selector: 'academiesFormWindow form'
    }, {
        ref: 'academiesFormWindow',
        selector: 'academiesFormWindow'
    }, {
        ref: 'academiesStructureGrid',
        selector: 'academiesStructureGrid'
    }],
    config: {
    	ORGANIZATION_STRUCTURE_ACADEMY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ORGANIZATION_STRUCTURE_ACADEMY_PRIVILEGES')
    },
    init: function(application) {
        this.control({
            'academiesStructureGrid button[itemId=btnAdd]': {
                click: function() {
                    this.showFormWindow();
                }
            },
            'academiesStructureGrid button[itemId=btnEdit]': {
                click: function() {
                    this.editFormWindow();
                }
            },
            'academiesStructureGrid button[itemId=btnView]': {
                click: function() {
                    this.viewFormWindow();
                }
            },
            'academiesStructureGrid button[itemId=btnDelete]': {
                click: function() {
                    this.deleteRecord();
                }
            },
            'academiesFormWindow form button[itemId=academyFormSubmitButtonId]': {
                click: this.saveUpdateUser
            },
            'academiesFormWindow form button[itemId=academyFormCancelButtonId]': {
                click: this.closeFormWindow
            },
            'academiesFormWindow datefield[itemId=startDate]': {

                select: function(startDate, value) {
                    var form = startDate.up('form');
                    var tillDate = form.down('#tillDate');
                    tillDate.reset();
                    if (startDate.getValue() < new Date()) {
                        tillDate.setMinValue(new Date());
                    } else {
                        tillDate.setMinValue(startDate.getValue());
                    }
                }

            },
            'academiesStructure': {
                activate: function() {
                    this.loadStoreManually();
                }
            },
            'academiesFormWindow':{
            	afterrender : function(obj) {
            		var $this = this;
            		var status = $this.getAcademiesFormWindow();
            		var statusVal = status.down('#status');
            		var comboStore = statusVal.getStore();
            		comboStore.load({
            			callback:function(record) {
            					statusVal.setRawValue(record[0].data.name);  
            			}
            		});
            	}
            },
            'academiesStructureGrid[itemId=academiesStructureGrid]': {
            	render: function(grid) {
                    //this.doAccessControlValidation(grid, this.getORGANIZATION_STRUCTURE_ACADEMY_PERMISSIONS());
                }
            }
        });
    },

    showFormWindow: function() {
        var formWindow = this.getAcademiesFormWindow();
        if (!formWindow) {
            Ext.widget('academiesFormWindow');
            formWindow = this.getAcademiesFormWindow();
        }
        formWindow.show();
    },
    closeFormWindow: function() {
        this.getAcademiesFormWindow().close();
    },
    viewFormWindow: function() {
        this.editFormWindow();
        var form = this.getAcademiesForm();
        if (form) {
            form.down('#academyFormSubmitButtonId').setVisible(false);
            form = form.getForm();
            toggleReadOnlyFormItems(form, true);
        }
    },

    editFormWindow: function() {

        var grid = this.getAcademiesStructureGrid();

        if (grid.getSelectionModel().getCount() > 0) {
            this.showFormWindow();
            var form = this.getAcademiesForm();
            var records = grid.getSelectionModel().getSelection();
            if (records != undefined && records != "" && records != null) {
                form.loadRecord(records[0]);
                form.down("#startDate").setValue(dateRender(records[0].data.startDate));
                form.down("#tillDate").setValue(dateRender(records[0].data.tillDate));
            }
        } else {
        	showWarningMessage(getCommonTranslation('ACADEMIESTABTEXT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    deleteRecord: function() {
        var grid = this.getAcademiesStructureGrid();

        if (grid.getSelectionModel().getCount() > 0) {
        	showConfirmMessage(getCommonTranslation('ACADEMIESTABTEXT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var record = grid.getSelectionModel().getSelection()[0];
                    var id = record.get("id");
                    Ext.Ajax.request({
                        method: "DELETE",
                        type: 'rest',
                        url: SERVERURL.ACADEMY_DELETE,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        params: {
                            id: id
                        },
                        success: function(form, action) {
                            grid.getStore().reload();
                            showSuccessMessage(getCommonTranslation('ACADEMIESTABTEXT'), getCommonTranslation('ACADEMY_DELETE_SUCCESS'));
                        }
                    });
                }
            });
        } else {
        	showWarningMessage(getCommonTranslation('ACADEMIESTABTEXT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    saveUpdateUser: function(model, records) {
        var form = this.getAcademiesForm().getForm();
        var values = form.getValues();
        var submitUrl;
        var successMessge;
        var this$ = this;
    	var organization= Academia.model.singleton.Organization;
    	values.organizationId=organization.id;
    	if(values.status=='Active'||values.status){
    		values.status=true;
    	}else{
    		values.status=false;
    	}
        if (form.findField('id').getSubmitValue() == null || form.findField('id').getSubmitValue() == "") {
            submitUrl = SERVERURL.ACADEMY_CREATE;
            successMessge = getCommonTranslation('ACADEMY_ADD_SUCCESS');
        } else {
            submitUrl = SERVERURL.ACADEMY_UPDATE;
            successMessge = getCommonTranslation('ACADEMY_UPDATE_SUCCESS');
        }
        var curDate = new Date();
        var tillDate = new Date(form.findField("tillDate").value);
        var validTillDate = true;
        
        if(values.tillDate !== '') {
        	if(curDate > tillDate) {
        		validTillDate = false;
        	}
        }
        if(validTillDate) {
        	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        	var formData = Ext.encode(values);

        	Ext.Ajax.request({
        		type: 'rest',
        		url: submitUrl,
        		jsonData: formData,
        		method: 'POST',
        		success: function(form, action) {
        			this$.getAcademiesStructureGrid().getStore().reload();
        			this$.closeFormWindow();
        			this$.getAcademiesStructureGrid().getSelectionModel().deselectAll(true);
        			showSuccessMessage(getCommonTranslation('ACADEMIESTABTEXT'), successMessge);
        		},
        		failure: function(form, action) {
        			this$.getAcademiesStructureGrid().getSelectionModel().deselectAll(true);
        		}
        	});
        	Ext.getBody().unmask();
        } else {
        	this$.closeFormWindow();
        	showWarningMessage(getCommonTranslation('ACADEMIESTABTEXT'), getCommonTranslation('ACADEMY_END_DATE_PASSED_INACTIVE_STATUS'));
        }
    },
    /*
     * @method
     * method to load the store manually after the rendering of the grid.
     */
    loadStoreManually: function() {
    	this.getAcademiesStructureGrid().getStore().sorters.clear();
    	this.getAcademiesStructureGrid().getStore().load();
    }

});
