/**
 * This controller is used for the student, faculty disciplinary functionality.
 * Add/Edit/delete/view
 * @author Sachin.Bangar
 */
Ext.define('Academia.controller.personinfo.common.PersonDisciplinaryController', {
	extend: 'Academia.controller.personinfo.common.PersonCommonController',


	stores: ['common.IncidentTypeStore', 'personinfo.common.disciplinaryactivity.ReportedByStore', 
		'personinfo.common.disciplinaryactivity.DisciplinaryActionStore', 'common.LiveSearchCombos',
		'personinfo.common.disciplinaryactivity.DisciplinaryActionSUStore',
		'personinfo.common.disciplinaryactivity.PositiveIncidentStore',  'personinfo.common.disciplinaryactivity.NegativeIncidentStore',
		'personinfo.common.disciplinaryactivity.ReportedUserSearchCombos','personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentStore',
		'personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentListStore','personinfo.common.disciplinaryactivity.PositiveIncidentDocumentStore',
		'personinfo.common.disciplinaryactivity.PositiveIncidentDocumentListStore', 'programCourseDashboard.Student',
		'personinfo.common.disciplinaryactivity.DisciplinaryTypeOfIncidentSearchCombo','common.CategoryOfIncidentStore',
		'common.IncidentRatingPositiveStore','common.IncidentRatingNegativeStore',
		'common.ProgramStoreAccessible','common.ProgramsByAcademyIdLocationId',
		'personinfo.common.disciplinaryactivity.DisciplinarySUTypeOfMisconductSearchCombo',
		'personinfo.common.disciplinaryactivity.DisciplinarySUAccessTemporaryRestriction',
		'personinfo.common.disciplinaryactivity.DisciplinarySUAppealOutcome',
		'personinfo.common.disciplinaryactivity.DisciplinaryCommitteeSU',
		'common.ProgramStore','coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
		'personinfo.common.disciplinaryactivity.DisciplinaryActionSanctionDetailSUGrid',
		'personinfo.common.disciplinaryactivity.DisciplinarySanctionTypeSUStore',
		'personinfo.common.disciplinaryactivity.DisciplinarySanctionDetailGridStore',
		'personinfo.common.disciplinaryactivity.SanctionCompletedStore',
		'personinfo.common.disciplinaryactivity.DisciplinaryActionSUDocumentListStore',
		'personinfo.common.disciplinaryactivity.DisciplinarySanctionDetailGridWindowStore','personinfo.common.disciplinaryactivity.SUDisciplinaryDeterminationComboStore',
		'common.PenaltyCSMStore','common.OutcomeCSMStore','common.CourseVarientOfEnrolledStudentStore','common.AssessmentEventNegativeStore'],

		views: ['personinfo.common.disciplinaryactivity.DisciplinaryActionGrid', 'personinfo.common.disciplinaryactivity.DisciplinaryActionForm', 
			'personinfo.common.disciplinaryactivity.PositiveIncidentGrid', 'personinfo.common.disciplinaryactivity.PositiveIncidentForm', 
			'personinfo.common.disciplinaryactivity.NegativeIncidentGrid', 'personinfo.common.disciplinaryactivity.NegativeIncidentForm',
			'common.NestedJsonCombo','personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentGrid',
			'personinfo.common.disciplinaryactivity.SanctionDetailsGrid',
			'personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentList','personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentListGrid',
			'personinfo.common.disciplinaryactivity.PositiveIncidentDocumentGrid','personinfo.common.disciplinaryactivity.PositiveIncidentDocumentListGrid',
			'personinfo.common.disciplinaryactivity.PositiveIncidentDocumentList','personinfo.common.disciplinaryactivity.DisciplinaryActionSUGrid',
			'personinfo.common.disciplinaryactivity.DisciplinaryActionFormSU',
			'personinfo.common.disciplinaryactivity.PersonWindowSu',
			'personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentSUList',
			'personinfo.common.disciplinaryactivity.DisciplinaryActionSuSanctionDetailWindow',
			'personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentListGridSU',
			'personinfo.common.disciplinaryactivity.SanctionDetailsGridOnWindow','personinfo.common.disciplinaryactivity.NegativeIncidentForm'],

			/**
			 *  Load store after grid renderer
			 *  @param gridItemId
			 *  @param url
			 */

			loadGridStore: function(gridItemId, url) {
				var this$ = this;
				var user=this.getCurrentlyLoggedInUser().code;
				var personProfile = this$.getContentPanelActiveTab();
				var personObj = this$.getPersonObj();
				var grid = personProfile.down(gridItemId);
				if (grid) {
					var personId = personObj["id"];
					var store = grid.getStore();
					store.getProxy().api.read = url;
					store.getProxy().extraParams = {
						personId: personId
					};
					grid.getStore().load({
						callback: function(rec, operation, success) {
							for(var j=0;j<rec.length;j++){
							
								for(var i=j;i<rec[j].data;i++)
									{
									   if(rec[j].data.disciplinaryActionDetails[i].code==user)
										   {
										    if(rec[j].data.disciplinaryActionDetails[i].wheatherChecked==false)
										    	{
										    	grid.getStore().remove(rec[j]);
										    	}
										   }
									}	
						   }
						}
					});
				}
			},
			getDownloadFile : function(documentId){
				if(!isNullOrEmpty(documentId)){
					var $this = this;
					$this.getDocumentController()
					.downloadDocumentFile(
							documentId);
				}
			},
			/**
			 * show person common window
			 * @param informationType
			 * @param formItemId
			 */

			showPersonCommonWindow : function(informationType, formItemId){
				var this$ = this;
				var title = null, xtypeForm = null;
				var formWindow;
				if(informationType == 'DISCIPLINARY_ACTION_SU'){
					formWindow = this$.getPersonWindowSu();
				}else{
					formWindow = this$.getPersonCommonWindow();
				}
				if(!formWindow){
					switch(informationType){

					case 'DISCIPLINARY_ACTION' : {//Disciplinary Action
						title = getPersonModuleTranslation('DISCIPLINARY_ACTION');
						xtypeForm = 'disciplinaryactionform';
						break;
					}
					case 'POSITIVE_INCIDENT' : {//Positive Incident
						title = getPersonModuleTranslation('POSITIVE_INCIDENT');
						xtypeForm = 'positiveincidentform';
						break;
					}
					case 'NEGATIVE_INCIDENTS' : {//Negative Incidents
						title = getPersonModuleTranslation('NEGATIVE_INCIDENTS');
						xtypeForm = 'negativeincidentform';
						break;
					}
					case 'DISCIPLINARY_ACTION_SU' : {//Negative Incidents
						title = getPersonModuleTranslation('SP_DISCIPLINARY_ACTIONS_SU');
						xtypeForm = 'disciplinaryactionformsu';
						break;
					}
					default :{
						break;
					}

					}
					if(informationType == 'DISCIPLINARY_ACTION_SU'){
						formWindow = Ext.widget('personwindowsu',{
							title: title,
							itemId : 'personwindowsu',
							items: [{
								xtype: xtypeForm,
								itemId: formItemId
							}]
						});
					}else{
						formWindow = Ext.widget('personcommonwindow',{
							title: title,
							itemId : 'personCommonWindow',
							items: [{
								xtype: xtypeForm,
								itemId: formItemId
							}]
						});
					}

					if(formItemId=="studentPositiveIncidentForm"){
						var panelItem = new Array();
						var form = this.getPositiveincidentform();
						var jobPostingContainer = form.down('#incidentDetailsContainer');
						var newcont=jobPostingContainer.items.items.length;
						var insertPosition=newcont+1;
						panelItem.push({

							xtype: 'fieldcontainer',
							cls:'positveIncidentCls',
							layout : {
								type : 'vbox'
							},
							defaults : {
								width : 'auto',
								labelAlign : 'top'
							},
							items : [{
								xtype: 'checkboxfield',
								width: 'auto',
								itemId:'teacherId',
								labelAlign: 'left',
								boxLabel: getCommonTranslation('INFORM_TEACHER'),
								name: 'isTeacher',
								inputValue : true,
								uncheckedValue: false
							},{
								xtype: 'checkboxfield',
								width: 'auto',
								itemId:'parentId',
								labelAlign: 'left',
								boxLabel: getCommonTranslation('INFORM_PARENT'),
								name: 'isParent',
								inputValue : true,
								uncheckedValue: false
							}]
						
						
						});
						jobPostingContainer.insert(insertPosition,panelItem);
						form.getForm().checkValidity();
						jobPostingContainer.doLayout();
					}
					
					var disciplinarydocumentStore=this.getStore('personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentStore');
					disciplinarydocumentStore.removeAll();
					var positivedocumentStore=this.getStore('personinfo.common.disciplinaryactivity.PositiveIncidentDocumentStore');
					positivedocumentStore.removeAll();
					var disciplinaryActionSu=this.getStore('personinfo.common.disciplinaryactivity.DisciplinarySanctionDetailGridStore');
					disciplinaryActionSu.removeAll();
				}

				formWindow.show();
			},
			/**
			 * view person common window
			 */
			viewPersonCommonWindow: function(form){

				if (form) {
					form.down('#submitButtonId').setVisible(false);
					if(!isNullOrEmpty(form.down('#uploadDisciplinaryItemId'))){
						form.down('#uploadDisciplinaryItemId').setVisible(false);
					} else if(!isNullOrEmpty(form.down('#uploadPositiveIncidentItemId'))){
						form.down('#uploadPositiveIncidentItemId').setVisible(false);
					} else if(!isNullOrEmpty(form.down('#uploadDisciplinarySUItemId'))){
						var sanctionGrid = this.getSanctiondetailsgrid();
						sanctionGrid.down('#btnAdd').setVisible(false);
						form.down('#uploadDisciplinarySUItemId').setVisible(false);
						
						sanctionGrid.on('beforeedit', function(editor, e) {
					        return false;
					        });
						
						sanctionGrid.columns.forEach(function(obj){
    	    				if(obj.dataIndex == 'addButton' || obj.dataIndex == 'deleteButton'){
    	    					obj.destroy();
    	    				}
    	    			});
					  sanctionGrid.reconfigure();
						
					}
					form = form.getForm();
					toggleReadOnlyFormItems(form, true);
				}
			},

			/**
			 * Close person common window
			 */
			closePersonCommonWindow: function() {
				var this$ = this;
				this$.getPersonCommonWindow().close();
			},
			closePersonWindowSU: function() {
				var this$ = this;
				this$.getPersonWindowSu().close();
			},

			/**
			 *  View disciplinary action form window
			 *  @param informationType
			 *  @param formItemId
			 *  @param gridItemId
			 */
			viewDisciplinaryActionFormWindow: function(informationType, formItemId, gridItemId) {
				var this$ = this;
				this$.editDisciplinaryActionFormWindow(informationType, formItemId, gridItemId);
				var form = this$.getPersonDisciplinaryActionForm();
				this$.viewPersonCommonWindow(form);
				form.isValid();
			},
			/**
			 *  View disciplinary action form SU window
			 *  @param informationType
			 *  @param formItemId
			 *  @param gridItemId
			 */
			viewDisciplinaryActionFormSUWindow: function(informationType, formItemId, gridItemId) {
				var this$ = this;
				this$.editDisciplinaryActionFormSUWindow(informationType, formItemId, gridItemId);
				var form = this$.getPersonDisciplinaryActionFormSU();
				this$.viewPersonCommonWindow(form);
			},
			/**
			 * Edit disciplinary action form window
			 *  @param informationType
			 *  @param formItemId
			 *  @param gridItemId
			 */
			editDisciplinaryActionFormWindow: function(informationType, formItemId, gridItemId) {

				var this$ = this;
				var personProfile = this$.getContentPanelActiveTab();
				var grid = personProfile.down(gridItemId);

				if (grid.getSelectionModel().getCount() > 0) {
					this.showPersonCommonWindow(informationType, formItemId);
					var form = this$.getPersonDisciplinaryActionForm();
					var records = grid.getSelectionModel().getSelection()[0];
					if (!isEmpty(records)) {
						if(!isNullOrEmpty(records.data.studentDateOfAction))
							records.data.dateOfAction = records.data.studentDateOfAction;
						if(!isNullOrEmpty(records.data.studentIncidentDate))
							records.data.incidentDate =records.data.studentIncidentDate;
					}

					var reportedByComboField = form.down('#reportedByField');

					if (!isNullOrEmpty(records.get("reportedByUser"))) {
						reportedByComboField.setValue('USER');
						/*var reportedByUserId = {
               		id: records.get('reportedByUserId')	
               };
               records.set('reportedByUserId', reportedByUserId);*/
						var reportedByUserId = form.down("#reportedByUserIdField");
						reportedByUserId.getStore().load({
							callback: function(rec, operation, success) {
								reportedByUserId.setValue(records.data.reportedByUser.id)
							}
						});
					} else {
						reportedByComboField.setValue('OTHER');
					}

					this$.showHideDisciplinaryReportedField(reportedByComboField);
					form.loadRecord(records);

					var incidentTypeId = form.down("#incidentType");
					incidentTypeId.getStore().load({
						callback: function(rec, operation, success) {
							incidentTypeId.setValue(records.data.incidentType.id)
						}
					});
					if(this.getCurrentLoggedPortalId() == 2){
						this$.viewPersonCommonWindow(form);
						form.down('#submitButtonId').setVisible(true);
						form.getForm().findField('remarks').setReadOnly(false);
					}
				} else {
					showWarningMessage(getPersonModuleTranslation('DISCIPLINARY_ACTION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			},
			/**
			 * Delete disciplinary action record
			 * @param gridItemId
			 * @param deleteUrl
			 */
			deleteDisciplinaryActionRecord: function(gridItemId, deleteUrl) {

				var this$ = this;
				var personProfile = this$.getContentPanelActiveTab();
				var personObj = this$.getPersonObj();
				//var person = new Object();
				var personId = personObj["id"];
				var grid = personProfile.down(gridItemId);
				var isFaculty=true;
				if(gridItemId=='#studentDisciplinaryActionGrid'){
					isFaculty=false;
				}
				if (grid.getSelectionModel().getCount() > 0) {
					showConfirmMessage(getPersonModuleTranslation('DISCIPLINARY_ACTION'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
						if (btn == 'yes') {
							if (grid.getSelectionModel().getCount() > 0) {
								var records = grid.getSelectionModel().getSelection();
								for (var count = 0; count < records.length; count++) {
									var id = "";
									if (!isNullOrEmpty(records[count].get("id"))) {
										id = records[count].get("id");
									}
									Ext.Ajax.request({
										type: 'rest',
										url: deleteUrl + id+"?id="+id+"&personId="+personId+"&isFaculty="+isFaculty,
										params:{
											personId:personId

										},
										method: 'DELETE',
										headers: {
											'Content-Type': 'application/json'
										},
										success: function(form, action) {
											grid.getStore().reload();
											showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('DISCIPLINARY_ACTION_DELETE_SUCCESS'));
										}
									});
								}
							}
						}
					});
				} else {
					showWarningMessage(getPersonModuleTranslation('DISCIPLINARY_ACTION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				}

			},
			/**
			 *  Save disciplinary action
			 *  @param gridItemId
			 *  @param saveUrl
			 *  @param updateUrl
			 */
			saveDisciplinaryAction: function(gridItemId, saveUrl, updateUrl) {

				var this$ = this;
				var isValid = true;
				var submitUrl, isUpdate = false;

				var personProfile = this$.getContentPanelActiveTab();
				var grid = personProfile.down(gridItemId);
				var form = this$.getPersonDisciplinaryActionForm();
				form.down('#submitButtonId').setDisabled(true);
				var reportedBy = form.down('#reportedByField').getValue();
				if(reportedBy == 'USER'){
					var reportedByUserId = form.down('#reportedByUserIdField').getValue();
					if(isNullOrEmpty(reportedByUserId) || !this$.isNumber(reportedByUserId)){
						showWarningMessage(getPersonModuleTranslation('POSITIVE_INCIDENT'), getPersonModuleTranslation('PLEASE_SELECT_USER_ID'));
						isValid = false;
					}
				}

				if(isValid){
					var id = form.down('#disciplinary_hidden_field');
					if (isNullOrEmpty(id.getSubmitValue())) {
						submitUrl = saveUrl,
						isUpdate = false;
					} else {
						submitUrl = updateUrl,
						isUpdate = true;
					}
					var jsonFormatFormData = this$.getJsonDisciplinaryData(form);
					this$.applyWindowMask(); 

					this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
						this$.hideWindowMask();
						if(success){
							this$.closePersonCommonWindow();
							grid.getStore().reload();
							grid.getSelectionModel().deselectAll();
							if (isUpdate) {
								showSuccessMessage(getPersonModuleTranslation('DISCIPLINARY_ACTION'), getPersonModuleTranslation('DISCIPLINARY_ACTION_UPDATE_SUCCESS'));
							} else {
								showSuccessMessage(getPersonModuleTranslation('DISCIPLINARY_ACTION'), getPersonModuleTranslation('DISCIPLINARY_ACTION_ADD_SUCCESS'));
							}
						}else{
							this$.hideWindowMask();
							this$.closePersonCommonWindow();
							grid.getStore().reload();
							form.down('#submitButtonId').setDisabled(false);
						}
					});
				}

			},

			saveDisciplinaryActionSU:function(gridItemId, saveUrl,updateUrl) {

				var this$ = this;
				var isValid = true;
				var submitUrl, isUpdate = false;

				var personProfile = this$.getContentPanelActiveTab();
				var grid = personProfile.down(gridItemId);
				var gridData = grid.getSelectionModel().getSelection()[0];
				var saveId;
				if(gridData!=null){
					saveId=gridData.data.id;
				}else{
					saveId=null;
				}
				var form = this$.getPersonDisciplinaryActionFormSU();
				var sanctionalGrid = form.down('#sanctiondetailsgrid');
				var sanctionalGridStore = sanctionalGrid.getStore();
				var isMandSancDetails = false;
				if(isValid){
					// var id = form.down('#disciplinary_Action_SU_hidden_field');
					if (isNullOrEmpty(saveId)) {
						submitUrl = saveUrl,
						isUpdate = false;
					} else {
						submitUrl = updateUrl,
						isUpdate = true;
					}
					var jsonFormatFormData;
					if(isUpdate){
						jsonFormatFormData = this$.getJsonDisciplinaryDataSUEdit(form,gridData);
					}else{
						jsonFormatFormData = this$.getJsonDisciplinaryDataSUSave(form);
					}
					this$.applyWindowMask(); 
					if(form.down('#isGuilty').getValue().isGuilty){
						if(sanctionalGridStore.data.length<1){
							isMandSancDetails=true;
						}else{
							sanctionalGridStore.each(function(rec) {
								if((Ext.decode(jsonFormatFormData).sanctionDetails.length<1)|| (isNullOrEmpty(rec.data.sanctionType) && (!isNullOrEmpty(rec.data.sanctionDate) ||  
										!isNullOrEmpty(rec.data.sanctionRecallDate) ||  !isNullOrEmpty(rec.data.sanctionComplete)
										|| !isNullOrEmpty(rec.data.appealOutcome) || !isNullOrEmpty(rec.data.sanctionHours)))){
									isMandSancDetails=true;
								}
							});
						}
						if(isMandSancDetails){
							this$.hideWindowMask();
							return showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SANCTION_DETAIL_ALERT_MESSAGE'));
						}
					}
					this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
						this$.hideWindowMask();
						if(success){
							this$.closePersonWindowSU();
							grid.getStore().reload();
							grid.getSelectionModel().deselectAll();
							if (isUpdate) {
								showSuccessMessage(getPersonModuleTranslation('DISCIPLINARY_ACTION'), getPersonModuleTranslation('DISCIPLINARY_ACTION_UPDATE_SUCCESS'));
							} else {
								showSuccessMessage(getPersonModuleTranslation('DISCIPLINARY_ACTION'), getPersonModuleTranslation('DISCIPLINARY_ACTION_ADD_SUCCESS'));
							}
						}else{
							this$.hideWindowMask();
							this$.closePersonWindowSU();
							grid.getStore().reload();
						}
					});
				}

			},

			/**
			 *  Get Disciplinary Action Json for form submission
			 */
			getJsonDisciplinaryData: function(form) {

				var this$ = this;
				var jsonFormFieldData = new Object();
				var personObj = this$.getPersonObj();
				var formData = form.getValues();
				var disciplinaryactivity = new Academia.model.personinfo.common.disciplinaryactivity.DisciplinaryActionModel();
				if (!isEmpty(formData)) {
					var person = new Object();
					person.id = personObj["id"];
					formData.person = person;

					// formData= this$.getIdValueJson[formData.incident];

					var incidentObj = new Object();
					incidentObj.id = formData.incidentType;
					formData.incidentType = incidentObj;

					var reportedByUserObj = new Object();
					reportedByUserObj.id = formData.reportedByUser;
					formData.reportedByUser = reportedByUserObj;

					if(formData.reportedBy == "USER" ){
						if(!isNullOrEmpty(formData.reportedByUser)){
							//formData.reportedByUserId = formData.reportedByUserId.id;
							//debugger;
							//formData.reportedByUser = {id:formData.reportedByUser.id};
						}else{
							delete formData.reportedByUser;
						}
					}else{
						delete formData.reportedByUser;
					}

					delete formData.reportedBy;

					var docStore = this$.getStore('personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentStore');
					var docArray = [];
					if (docStore.data.items != null
							&& docStore.data.items.length > 0) {
						Ext.each(docStore.data.items, function(val) {
							var newData = {
									"name" : val.data.documentName,
									"path" : val.data.path,
									"type" : val.data.type,
									"createdBy" : this$.getIdValueJson(
											val.data.createdBy.id,
											val.data.createdBy.value)
							};
							docArray.push(newData);
						});
					}
				}
				formData.documents = docArray;
				jsonFormFieldData = Ext.encode(formData);
				return jsonFormFieldData;
			},

			documentReportDocumentZip : function() {
				var $this = this;
				var form = $this.getDisciplinaryactiondocumentlist();
				var disciplinaryActionGrid=form.down('#disciplinaryactiondocumentlistgridItemId');
				if (disciplinaryActionGrid.getSelectionModel().getCount() > 0) {
					var records = disciplinaryActionGrid.getSelectionModel().getSelection();
					var dispatchZipName = "Disciplinary action  Documnet";
					var saveModel=[];  
					for(var i in records){
						if(!isNullOrEmpty(records[i].get('path'))) {
							saveModel.push(records[i].get('path'));
						}
						showConfirmMessage(getPersonModuleTranslation('DISCIPLINARY_ACTION_DOCUMENTS'),
								getPersonModuleTranslation('DISCIPLINARY_ACTION_DOCUMENTS_ALERT'),
								function(btn, text) {
							if (btn == 'yes') {
								var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
								$this.getController('Academia.controller.document.DocumentController')
								.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
							}
						});

					}
				}
				else {
					$this.hideWindowMask();
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			},

			deleteIncidentDocument:function(){
				var $this=this;
				var form = $this.getPositiveincidentdocumentlist();
				var positiveincidentgrid;
				positiveincidentgrid= $this.getPositiveincidentgrid();
				var positiveincident = this.getPositiveincidentdocumentlistgrid();
				var positiveincidentdocgrid=form.down('#positiveincidentdocumentlistgridItemId');
				if (positiveincidentdocgrid.getSelectionModel().getCount() > 0) {
					var records = positiveincidentdocgrid.getSelectionModel().getSelection();
					var ids=[];
					Ext.Array.each(records,function(value){
						ids.push(value.data.id);
					});
					showConfirmMessage(getPersonModuleTranslation('DISCIPLINARY_ACTIVITY'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
						if (btn == 'yes'){
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							Ext.Ajax.request({
								method: "DELETE",
								type: 'rest',
								url : SERVERURL.INCIDENT_ACTION_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
								headers: {
									'Content-Type': 'application/json'
								},
								success: function(form, action) {

									Ext.getBody().unmask();
									showSuccessMessage(getPersonModuleTranslation('POSITIVE_INCIDENT'),getPersonModuleTranslation('POSITIVE_INCIDENTS_DOCUMENT_SUCCESS_DELETE_MSG'));	 
									positiveincidentgrid.store.reload();
									positiveincidentdocgrid.store.reload();
									positiveincidentdocgrid.getSelectionModel().deselectAll(true);
								}
							});
						}

					});
				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
				}
			},

			deleteNegativeIncidentDocument:function(){
				var $this=this;
				var form = $this.getPositiveincidentdocumentlist();
				var negativeincidentgrid;
				negativeincidentgrid= $this.getNegativeincidentgrid();
				var positiveincident = this.getPositiveincidentdocumentlistgrid();
				var positiveincidentdocgrid=form.down('#positiveincidentdocumentlistgridItemId');
				if (positiveincidentdocgrid.getSelectionModel().getCount() > 0) {
					var records = positiveincidentdocgrid.getSelectionModel().getSelection();
					var ids=[];
					Ext.Array.each(records,function(value){
						ids.push(value.data.id);
					});
					showConfirmMessage(getPersonModuleTranslation('DISCIPLINARY_ACTIVITY'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
						if (btn == 'yes'){
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							Ext.Ajax.request({
								method: "DELETE",
								type: 'rest',
								url : SERVERURL.INCIDENT_ACTION_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
								headers: {
									'Content-Type': 'application/json'
								},
								success: function(form, action) {

									Ext.getBody().unmask();
									showSuccessMessage(getPersonModuleTranslation('NEGATIVE_INCIDENT'),getPersonModuleTranslation('NEGATIVE_INCIDENTS_DOCUMENT_SUCCESS_DELETE_MSG'));	 
									negativeincidentgrid.store.reload();
									positiveincidentdocgrid.store.reload();
									positiveincidentdocgrid.getSelectionModel().deselectAll(true);
								}
							});
						}

					});
				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
				}
			},

			deleteDisciplinaryDocument:function(){
				var $this=this;
				var form = $this.getDisciplinaryactiondocumentlist();
				var disciplinaryactiongrid= $this.getDisciplinaryactiongrid();
				var disciplinaryaction = this.getDisciplinaryactiondocumentlistgrid();
				var disciplinaryActionDocGrid=form.down('#disciplinaryactiondocumentlistgridItemId');
				if (disciplinaryActionDocGrid.getSelectionModel().getCount() > 0) {
					var records = disciplinaryActionDocGrid.getSelectionModel().getSelection();
					var ids=[];
					Ext.Array.each(records,function(value){
						ids.push(value.data.id);
					});
					showConfirmMessage(getPersonModuleTranslation('DISCIPLINARY_ACTIVITY'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
						if (btn == 'yes'){
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							Ext.Ajax.request({
								method: "DELETE",
								type: 'rest',
								url : SERVERURL.DISCIPLINARY_ACTION_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
								headers: {
									'Content-Type': 'application/json'
								},
								success: function(form, action) {

									Ext.getBody().unmask();
									showSuccessMessage(getPersonModuleTranslation('DISCIPLINARY_ACTIVITY'),getPersonModuleTranslation('DISCIPLINARY_DOCUMENT_SUCCESS_DELETE_MSG'));	 
									disciplinaryActionDocGrid.store.reload();
									disciplinaryactiongrid.store.reload();
									disciplinaryActionDocGrid.getSelectionModel().deselectAll(true);
								}
							});
						}
					});
				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
				}
			},

			incidentDocumentReportDocumentZip : function(incidentType) {
				var $this = this;
				var form = $this.getPositiveincidentdocumentlist();
				var incidentGrid=form.down('#positiveincidentdocumentlistgridItemId');
				var records = incidentGrid.getStore().data.items;
				var saveModel = [];
				var dispatchZipName = "Positive  Incident action  Documnet";
				if(incidentType == 'negative'){
					dispatchZipName = "Negative  Incident action  Documnet";
				}
				if (incidentGrid.getSelectionModel().getCount() > 0) {
					var records = incidentGrid.getSelectionModel().getSelection();
					for ( var i in records) {
						if (!isNullOrEmpty(records[i].get('path'))) {
							saveModel.push(records[i].get('path'));
						}
					}

					var confirmMsg = getPersonModuleTranslation('POSITIVE_INCIDENT_DOCUMENTS');
					if(incidentType == 'negative'){
						confirmMsg = getPersonModuleTranslation('NEGATIVE_INCIDENT_DOCUMENTS');
					}

					var msgAlert = getPersonModuleTranslation('POSITIVE_INCIDENT_DOCUMENTS_ALERT');
					if(incidentType == 'negative'){
						msgAlert = getPersonModuleTranslation('NEGATIVE_INCIDENT_DOCUMENTS_ALERT');
					}

					showConfirmMessage(confirmMsg,
							msgAlert,
							function(btn, text) {
						if (btn == 'yes') {
							var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
							$this.getController('Academia.controller.document.DocumentController')
							.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
						}
					});

				}
				else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
				}
			},

			showPositiveActionFormWindow: function() {
				var this$ = this;
				var formWindow = this$.getPositiveIncidentWindow();
				if (!formWindow) {
					Ext.widget('positiveincidentwindow');
					formWindow = this$.getPositiveIncidentWindow();
				}
				formWindow.show();
			},

			closePositiveActionFormWindow: function() {
				var this$ = this;
				this$.getPositiveIncidentWindow().close();
			},

			/**
			 *  View positive action form window
			 *  @param informationType
			 *  @param formItemId
			 *  @param gridItemId
			 */
			viewPositiveActionFormWindow: function(informationType, formItemId, gridItemId) {
				var this$ = this;
				this$.editPositiveActionFormWindow(informationType, formItemId, gridItemId);
				var form = this$.getPersonPositiveIncidentForm();
				this$.viewPersonCommonWindow(form);
				form.isValid();
			},
			/**
			 * Edit positive action form window
			 *  @param informationType
			 *  @param formItemId
			 *  @param gridItemId
			 */
			editPositiveActionFormWindow: function(informationType, formItemId, gridItemId) {

				var this$ = this;
				var personProfile = this$.getContentPanelActiveTab();
				var grid = personProfile.down(gridItemId);

				if (grid.getSelectionModel().getCount() > 0) {
					this.showPersonCommonWindow(informationType, formItemId);
					var form = this$.getPersonPositiveIncidentForm();
					var isParent=form.down('#parentId');
					var isTeacher=form.down('#teacherId');
					var records = grid.getSelectionModel().getSelection()[0];
					if(!isNullOrEmpty(isParent)){
						if(records.raw.isParent==true && formItemId=="studentPositiveIncidentForm"){
							isParent.setReadOnly(true);
						}else{
							isParent.setReadOnly(false);
							isParent.setValue(false);
						}
					}
					if(!isNullOrEmpty(isTeacher)){
						if(records.raw.isTeacher==true && formItemId=="studentPositiveIncidentForm"){
							isTeacher.setReadOnly(true);
						}else{
							isTeacher.setReadOnly(false);
							isTeacher.setValue(false);
						}
					}
					var reportedByComboField = form.down('#reportedByField');
					if (!isNullOrEmpty(records.get("reportedByUserId"))) {
						reportedByComboField.setValue('USER');
						/*var reportedByUserId = {
                		id: records.get('reportedByUserId')	
                };
                records.set('reportedByUserId', reportedByUserId);*/

						var reportedByUserId = form.down("#reportedByUserIdField");
						reportedByUserId.getStore().load({
							callback: function(rec, operation, success) {
								reportedByUserId.setValue(records.get('reportedByUserId'))
							}
						});
						if(records.raw.isParent!=null && formItemId=="studentPositiveIncidentForm"){
							form.down('#parentId').setValue(records.raw.isParent);
						}
						if(records.raw.isTeacher!=null && formItemId=="studentPositiveIncidentForm"){
							form.down('#teacherId').setValue(records.raw.isTeacher);
						}
					} else {
						reportedByComboField.setValue('OTHER');
					}

					/*if( !isNullOrEmpty(form.down("#reportedByUserIdField")) && form.down("#reportedByUserIdField") != undefined ){

            	if (!isNullOrEmpty(records.get("categoryOfIncident"))) {

                    var categoryOfIncidentCombo = form.down("#categoryOfIncidentCombo");
                    categoryOfIncidentCombo.getStore().load({
                 	   callback: function(rec, operation, success) {
                 		  categoryOfIncidentCombo.setValue(records.get('categoryOfIncident'))
                 	   }
                    });
                }
            }*/

					this$.showHidePositiveReportedField(reportedByComboField);
					if(!isNullOrEmpty(records.data.studentIncidentDate))
						records.data.incidentDate =records.data.studentIncidentDate;
					//form.getForm().setValues(records.data);
					form.down('#typeOfIncidentCombo').getStore().load();
					form.loadRecord(records);
					if(this.getCurrentLoggedPortalId() == 2){
						this$.viewPersonCommonWindow(form);
						form.down('#submitButtonId').setVisible(true);
						form.getForm().findField('remarks').setReadOnly(false);
						if(records.raw.isTeacher==false||records.raw.isTeacher==null)
						    form.down('#teacherId').setReadOnly(false);
						if(records.raw.isParent==false||records.raw.isParent==null)
						    form.down('#parentId').setReadOnly(false);
					}
				} else {
					showWarningMessage(getPersonModuleTranslation('POSITIVE_INCIDENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			},
			/**
			 * Delete positive action record
			 * @param gridItemId
			 * @param deleteUrl
			 */
			deletePositiveActionRecord: function(gridItemId, deleteUrl) {

				var this$ = this;
				var personProfile = this$.getContentPanelActiveTab();
				var grid = personProfile.down(gridItemId);

				if (grid.getSelectionModel().getCount() > 0) {
					showConfirmMessage(getPersonModuleTranslation('POSITIVE_INCIDENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
						if (btn == 'yes') {
							if (grid.getSelectionModel().getCount() > 0) {
								var records = grid.getSelectionModel().getSelection();
								for (var count = 0; count < records.length; count++) {
									var id = "";
									if (!isNullOrEmpty(records[count].get("id"))) {
										id = records[count].get("id");
									}
									Ext.Ajax.request({
										type: 'rest',
										url: deleteUrl + id,
										method: 'DELETE',
										headers: {
											'Content-Type': 'application/json'
										},
										success: function(form, action) {
											grid.getStore().reload();
											showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('POSITIVE_INCIDENT_DELETE_SUCCESS'));
										}
									});
								}
							}
						}
					});
				} else {
					showWarningMessage(getPersonModuleTranslation('POSITIVE_INCIDENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				}

			},
			/**
			 * Show hide positive reported field
			 * @param combo
			 */
			showHidePositiveReportedField: function(combo) {
				var this$ = this;
				var form = this$.getPersonPositiveIncidentForm();
				var reportedBy = combo.getValue();
				var reportedByUserIdField = form.down('#reportedByUserIdField');
				var reportedByUserName = form.down('#reportedByUserNameField');
				if (reportedBy === 'USER') {
					reportedByUserIdField.setDisabled(false);
					reportedByUserName.setReadOnly(true);
				} else {
					reportedByUserIdField.setDisabled(true);
					reportedByUserName.setReadOnly(false);
				}
				reportedByUserIdField.setValue('');
				reportedByUserName.setValue('');
			},
			showHideDisciplinaryReportedField: function(combo) {
				var this$ = this;
				var form = this$.getPersonDisciplinaryActionForm();
				var reportedBy = combo.getValue();
				var reportedByUserIdField = form.down('#reportedByUserIdField');
				var reportedByUserName = form.down('#reportedByUserNameField');
				if (reportedBy === 'USER') {
					reportedByUserIdField.setDisabled(false);
					reportedByUserName.setReadOnly(true);
				} else {
					reportedByUserIdField.setDisabled(true);
					reportedByUserName.setReadOnly(false);
				}
				reportedByUserIdField.setValue('');
				reportedByUserName.setValue('');
			},
			/**
			 * Validate positive reported id field
			 * @param reportedIdField
			 */
			validatePositiveReportedIdField: function(combo, records, eOpts) {
				var this$ = this;
				var form = this$.getPersonPositiveIncidentForm();
				if(!isEmpty(records[0].data)){
					var reportedName = records[0].data.value;
					form.down('#reportedByUserNameField').setValue(reportedName);
				}

			},

			/**
			 *  Save positive action
			 *  @param gridItemId
			 *  @param saveUrl
			 *  @param updateUrl
			 */
			savePositiveAction: function(gridItemId, saveUrl, updateUrl) {

				var this$ = this;
				var isValid = true;
				var submitUrl, isUpdate = false;

				var personProfile = this$.getContentPanelActiveTab();
				var grid = personProfile.down(gridItemId);
				var form = this$.getPersonPositiveIncidentForm();
				form.down('#submitButtonId').setDisabled(true);
				var reportedBy = form.down('#reportedByField').getValue();
				if(reportedBy == 'USER'){
					var reportedByUserId = form.down('#reportedByUserIdField').getValue();
					if(isNullOrEmpty(reportedByUserId) || !this$.isNumber(reportedByUserId)){
						showWarningMessage(getPersonModuleTranslation('POSITIVE_INCIDENT'), getPersonModuleTranslation('PLEASE_SELECT_USER_ID'));
						isValid = false;
					}
				}
				if(isValid){
					var id = form.down('#positive_hidden_field');
					if (isNullOrEmpty(id.getSubmitValue())) {
						submitUrl = saveUrl;// SERVERURL.INCIDENT_ACTION_ADD,
						isUpdate = false;
					} else {
						submitUrl = updateUrl;//SERVERURL.INCIDENT_ACTION_UPDATE,
						isUpdate = true;
					}
					var jsonFormatFormData = this$.getJsonIncidentData(form, undefined, CONSTANTS.INCIDENT_CF_POSITIVE_INCIDENT_DISPLAY_NAME);
					//jsonFormatFormData.incidentType = CONSTANTS.INCIDENT_CF_POSITIVE_INCIDENT_DISPLAY_NAME;
					this$.applyWindowMask(); 

					this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
						this$.hideWindowMask();
						if(success){
							this$.closePersonCommonWindow();
							grid.getStore().reload();
							grid.getSelectionModel().deselectAll();
							if (isUpdate) {
								showSuccessMessage(getPersonModuleTranslation('POSITIVE_INCIDENT'), getPersonModuleTranslation('POSITIVE_INCIDENT_UPDATE_SUCCESS'));
							} else {
								showSuccessMessage(getPersonModuleTranslation('POSITIVE_INCIDENT'), getPersonModuleTranslation('POSITIVE_INCIDENT_ADD_SUCCESS'));
							}
						}else{
							this$.hideWindowMask();
							this$.closePersonCommonWindow();
							grid.getStore().reload();
							form.down('#submitButtonId').setDisabled(false);
						}
					});
				}


			},
			/**
			 *  Get Incidents Json for form submission
			 *  @param form
			 *  @param personObj
			 */
			getJsonIncidentData: function(form, personObj, incidentType) {

				var this$ = this;
				var jsonFormFieldData = new Object();
				var formData = form.getValues();
				if (!isEmpty(formData)) {
					var personObj = this$.getPersonObj();
					var person = new Object();
					person.id = personObj["id"];
					formData.person = person;
					if(formData.reportedBy == "USER" ){
						if(!isEmpty(formData.reportedByUserId)){
							formData.reportedByUserId = formData.reportedByUserId.id;
						}
					}

					delete formData.reportedBy;
					var docStore = this$.getStore('personinfo.common.disciplinaryactivity.PositiveIncidentDocumentStore');
					var docArray = [];
					if (docStore.data.items != null
							&& docStore.data.items.length > 0) {
						Ext.each(docStore.data.items, function(val) {
							if(!val.data.isEdit){
								var newData = {
										"name" : val.data.documentName,
										"path" : val.data.path,
										"type" : val.data.type,
										"id" : val.data.id,
										"createdBy" : this$.getIdValueJson(
												val.data.createdBy.id,
												val.data.createdBy.value),
								};
							}else{
							var newData = {
									"name" : val.data.documentName,
									"path" : val.data.path,
									"type" : val.data.type,
									"id" : val.data.id,
									"createdBy" : this$.getIdValueJson(
											val.data.createdBy.id,
											val.data.createdBy.value),
									"isEdit" : val.data.isEdit		
							};
							}
							docArray.push(newData);
						});
					}
				}
				formData.documents = docArray;
				formData.incidentType = incidentType;
				jsonFormFieldData = Ext.encode(formData);
				return jsonFormFieldData;

			},

			/**
			 *  View negative action form window
			 *  @param informationType
			 *  @param formItemId
			 *  @param gridItemId
			 */
			viewNegativeActionFormWindow: function(informationType, formItemId, gridItemId) {
				var this$ = this;
				this$.editNegativeActionFormWindow(informationType, formItemId, gridItemId);
				var form = this$.getPersonNegativeIncidentForm();
				this$.viewPersonCommonWindow(form);
				form.isValid();
			},
			/**
			 * Edit negative action form window
			 *  @param informationType
			 *  @param formItemId
			 *  @param gridItemId
			 */
			editNegativeActionFormWindow: function(informationType, formItemId, gridItemId) {

				var this$ = this;
				var personProfile = this$.getContentPanelActiveTab();
				var grid = personProfile.down(gridItemId);

				if (grid.getSelectionModel().getCount() > 0) {
					this.showPersonCommonWindow(informationType, formItemId);
					var form = this$.getPersonNegativeIncidentForm();
					var isParent=form.down('#parentId');
					var isTeacher=form.down('#teacherId');
					var records = grid.getSelectionModel().getSelection()[0];
					if(records.raw.isParent==true && formItemId=="studentNegativeIncidentForm"){
						isParent.setReadOnly(true);
					}
					if(records.raw.isTeacher==true && formItemId=="studentNegativeIncidentForm"){
						isTeacher.setReadOnly(true);
					}
					var reportedByComboField = form.down('#reportedByField');
					if (!isNullOrEmpty(records.get("reportedByUserId"))) {
						reportedByComboField.setValue('USER');

						/*var reportedByUserId = {
                		id: records.get('reportedByUserId')	
                };
                records.set('reportedByUserId', reportedByUserId);*/

						var reportedByUserId = form.down("#reportedByUserIdField");
						reportedByUserId.getStore().load({
							callback: function(rec, operation, success) {
								reportedByUserId.setValue(records.get('reportedByUserId'))
							}
						});

					} else {
						reportedByComboField.setValue('OTHER');
					}
					 var courseVarientId = form.down("#courseVarientId");
					 courseVarientId.reset();
					 if (!isNullOrEmpty(records.data.courseVarient) && !isNullOrEmpty(records.data.courseVarient.id)) {
		            	 courseVarientId.getStore().load({
						   callback: function(recordss, operation, success) {
							   var isCourseVarientFound = false;
							   for(var i in recordss){
								   if( !isNullOrEmpty(records.data.courseVarient) ){
									   if(recordss[i].data.courseVariantId==records.data.courseVarient.id){
										   isCourseVarientFound = true;
										   courseVarientId.setValue(recordss[i].data.courseVariantId);
									   }
									   
								   }
							   }
							   
							   if(!isCourseVarientFound){
								   courseVarientId.reset();
							   }
						   }	   
					   });
		             }
					this$.showHideNegativeReportedField(reportedByComboField);
					if(!isNullOrEmpty(records.data.studentIncidentDate))
						records.data.incidentDate = records.data.studentIncidentDate;
					if(!isNullOrEmpty(records.data.studentDateOfAction))
						records.data.dateOfAction = records.data.studentDateOfAction;
					form.down('#typeOfIncidentCombo').getStore().load();
					form.loadRecord(records);
					form.down('#parentId').setValue(records.raw.isParent);
					form.down('#teacherId').setValue(records.raw.isTeacher);
					if(this.getCurrentLoggedPortalId() == 2){
						this$.viewPersonCommonWindow(form);
						form.down('#submitButtonId').setVisible(true);
						form.getForm().findField('remarks').setReadOnly(false);
						if(records.raw.isTeacher==false||records.raw.isTeacher==null)
						    form.down('#teacherId').setReadOnly(false);
						if(records.raw.isParent==false||records.raw.isParent==null)
						    form.down('#parentId').setReadOnly(false);
					}
				} else {
					showWarningMessage(getPersonModuleTranslation('NEGATIVE_INCIDENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			},
			/**
			 * show hide negative report field
			 * @param combo
			 */
			showHideNegativeReportedField: function(combo) {
				var this$ = this;
				var form = this$.getPersonNegativeIncidentForm();
				var reportedBy = combo.getValue();
				var reportedByUserIdField = form.down('#reportedByUserIdField');
				var reportedByUserName = form.down('#reportedByUserNameField');
				if (reportedBy === 'USER') {
					reportedByUserIdField.setDisabled(false);
					reportedByUserName.setReadOnly(true);
				} else {
					reportedByUserIdField.setDisabled(true);
					reportedByUserName.setReadOnly(false);
				}
				reportedByUserIdField.setValue('');
				reportedByUserName.setValue('');
			},
			/**
			 * show hide negative report field
			 * @param combo
			 */
			showHideDisciplinaryActionReportedField: function(combo) {
				var this$ = this;
				var form = this$.getPersonDisciplinaryActionForm();
				var reportedBy = combo.getValue();
				var reportedByUserIdField = form.down('#reportedByUserIdField');
				var reportedByUserName = form.down('#reportedByUserNameField');
				if (reportedBy === 'USER') {
					reportedByUserIdField.setDisabled(false);
					reportedByUserName.setReadOnly(true);
				} else {
					reportedByUserIdField.setDisabled(true);
					reportedByUserName.setReadOnly(false);
				}
				reportedByUserIdField.setValue('');
				reportedByUserName.setValue('');
			},
			/**
			 * validate reported user
			 * @param reportedIdField
			 */
			validateNegativeReportedIdField: function(combo, records, eOpts) {
				var this$ = this;
				var form = this$.getPersonNegativeIncidentForm();
				if(!isEmpty(records[0].data)){
					var reportedName = records[0].data.value;
					//var reportedName = records[0].data.firstName + " " + records[0].data.lastName;
					form.down('#reportedByUserNameField').setValue(reportedName);
				}},

				validateDisciplinaryReportedIdField: function(combo, records, eOpts) {
					var this$ = this;
					var form = this$.getPersonDisciplinaryActionForm();
					if(!isEmpty(records[0].data)){
						var reportedName = records[0].data.value;
						form.down('#reportedByUserNameField').setValue(reportedName);
					}



				},
				/**
				 * Delete negative action record
				 * @param gridItemId
				 * @param deleteUrl
				 */
				deleteNegativeActionRecord: function(gridItemId, deleteUrl) {

					var this$ = this;
					var personProfile = this$.getContentPanelActiveTab();
					var grid = personProfile.down(gridItemId);

					if (grid.getSelectionModel().getCount() > 0) {
						showConfirmMessage(getPersonModuleTranslation('NEGATIVE_INCIDENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
							if (btn == 'yes') {
								if (grid.getSelectionModel().getCount() > 0) {
									var records = grid.getSelectionModel().getSelection();
									for (var count = 0; count < records.length; count++) {
										var id = "";
										if (!isNullOrEmpty(records[count].get("id"))) {
											id = records[count].get("id");
										}
										Ext.Ajax.request({
											type: 'rest',
											url: deleteUrl + id,
											method: 'DELETE',
											headers: {
												'Content-Type': 'application/json'
											},
											success: function(form, action) {
												grid.getStore().reload();
												showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('NEGATIVE_INCIDENT_DELETE_SUCCESS'));
											}
										});
									}
								}
							}
						});
					} else {
						showWarningMessage(getPersonModuleTranslation('NEGATIVE_INCIDENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}

				},

				/**
				 *  Save negative action
				 *  @param gridItemId
				 *  @param saveUrl
				 *  @param updateUrl
				 */
				saveNegativeAction: function(gridItemId, saveUrl, updateUrl) {

					var this$ = this;
					var isValid = true;
					var submitUrl, isUpdate = false;

					var personProfile = this$.getContentPanelActiveTab();
					var grid = personProfile.down(gridItemId);
					var form = this$.getPersonNegativeIncidentForm();
					var reportedBy = form.down('#reportedByField').getValue();
					if(reportedBy == 'USER'){
						var reportedByUserId = form.down('#reportedByUserIdField').getValue();
						if(isNullOrEmpty(reportedByUserId) || !this$.isNumber(reportedByUserId)){
							showWarningMessage(getPersonModuleTranslation('NEGATIVE_INCIDENT'), getPersonModuleTranslation('PLEASE_SELECT_USER_ID'));
							isValid = false;
						}
					}
					if(isValid){
						var id = form.down('#negative_hidden_field');
						if (isNullOrEmpty(id.getSubmitValue())) {
							submitUrl = saveUrl;
							isUpdate = false;
						} else {
							submitUrl = updateUrl,
							isUpdate = true;
						}
						var jsonFormatFormData = this$.getJsonIncidentData(form, undefined, CONSTANTS.INCIDENT_CF_NEGATIVE_INCIDENT_DISPLAY_NAME);
						//jsonFormatFormData.incidentType = CONSTANTS.INCIDENT_CF_NEGATIVE_INCIDENT_DISPLAY_NAME;
						this$.applyWindowMask(); 

						this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
							this$.hideWindowMask();
							if(success){
								this$.closePersonCommonWindow();
								grid.getStore().reload();
								grid.getSelectionModel().deselectAll();
								if (isUpdate) {
									showSuccessMessage(getPersonModuleTranslation('NEGATIVE_INCIDENT'), getPersonModuleTranslation('NEGATIVE_INCIDENT_UPDATE_SUCCESS'));
								} else {
									showSuccessMessage(getPersonModuleTranslation('NEGATIVE_INCIDENT'), getPersonModuleTranslation('NEGATIVE_INCIDENT_ADD_SUCCESS'));
								}
							}else{
								this$.hideWindowMask();
								this$.closePersonCommonWindow();
								grid.getStore().reload();
							}
						});
					}


				},
				isNumber: function(obj) {
					return !isNaN( parseFloat( obj ) ) && isFinite( obj );
				},
				getIdValueJson: function(id, value) {
					if (id)
						return {
						id: id,
						value: value
					};
				},
				getJsonDisciplinaryDataSUSave: function(form) {

					var this$ = this;
					var jsonFormFieldData = new Object();
					var personObj = this$.getPersonObj();
					var formData = form.getValues();
					var disciplinaryactivity = new Academia.model.personinfo.common.disciplinaryactivity.DisciplinaryActionSUModel();
					if (!isEmpty(formData)) {
						var person = new Object();
						person.id = personObj["id"];
						formData.person = person;

						disciplinaryactivity.set("person", person);

						var misConductTypeObj = new Object();
						misConductTypeObj.id = formData.typeOfMisconduct;
						formData.typeOfMisconduct = misConductTypeObj;

						disciplinaryactivity.set("misconductType", misConductTypeObj.id);
						disciplinaryactivity.set("dateOfMisconduct", formData.dateOfMisconduct);
						disciplinaryactivity.set("tempSuspension", formData.temporarysSuspension);
						disciplinaryactivity.set("tempSuspensionDate", formData.temporarySuspensionDate);

						var disciplinaryCommitteeObj = new Object();
						disciplinaryCommitteeObj.id = formData.disciplinaryCommittee;
						formData.disciplinaryCommittee = disciplinaryCommitteeObj.id;

						disciplinaryactivity.set("disciplinaryCommittee", disciplinaryCommitteeObj.id);
						disciplinaryactivity.set("notifyStudent", formData.notifyStudent);

						var temporarySuspensionAccessRestrictionObj = new Object();

						temporarySuspensionAccessRestrictionObj.id = formData.temporarySuspensionAccessRestriction;
						formData.temporarySuspensionAccessRestriction = temporarySuspensionAccessRestrictionObj;



						disciplinaryactivity.set("tempAccessRestriction", temporarySuspensionAccessRestrictionObj.id);
						disciplinaryactivity.set("isTempSuspensionLapse", formData.temporarysSuspensionLapse);
						disciplinaryactivity.set("tempSuspensionLapseDate", formData.temporarySuspensionLapseDate);

						var appealOutcomeObj = new Object();

						appealOutcomeObj.id = formData.appealOutcome;
						formData.appealOutcome = appealOutcomeObj.id;

                        if(isArray(formData.appeal)) {
                        	disciplinaryactivity.set("whetherAppealed", formData.appeal[0]);
                        }
                        else {
                        	disciplinaryactivity.set("whetherAppealed", formData.appeal);
                        }

                        var disciplinaryDeterminationObj = new Object();

                        disciplinaryDeterminationObj.id = formData.disciplinaryDetermination;
						formData.disciplinaryDetermination = disciplinaryDeterminationObj;
						var disciplinaryDetailList = {
								"disciplinaryDetermination" : disciplinaryDeterminationObj.id,
								"determinationDate" : formData.disciplinaryDeterminationDate,
								"determinationHearingDate" : formData.disciplinaryCommitteeHearingDate,
								"whetherGuilty" : formData.isGuilty
						};
						disciplinaryactivity.set("disciplinaryCommitteeDetails", disciplinaryDetailList);
						var appealOutcomeDetailList = {
								"appealDate" : formData.appealDate,
								"appealOutcome" : appealOutcomeObj.id,
								"misConductDetails" : formData.misconductDetail,
								"remarks" : formData.notesRemarks
						};

						disciplinaryactivity.set("appealDetails", appealOutcomeDetailList);

						var SanctionStoreGrid = this$.getStore('personinfo.common.disciplinaryactivity.DisciplinarySanctionDetailGridStore');
						var sanctionDetailsList=[];
						if (SanctionStoreGrid.data.items != null
								&& SanctionStoreGrid.data.items.length > 0) {
							Ext.each(SanctionStoreGrid.data.items, function(val) {
								var whetherSanctionCompleted;
								if(val.data.whetherSanctionCompleted == 'Yes'){
									whetherSanctionCompleted = true;
								}
								else{
									whetherSanctionCompleted=false;
								}
								var sanctionData = {
										"sanctionType" : this$.getIdValueJson(val.data.sanctionType),
										"sanctionDate" : Ext.Date.format(new Date(val.data.sanctionDate),CONSTANTS.NEW_SUBMIT_DATE_FORMAT),
										"sanctionRecallDate": Ext.Date.format(new Date(val.data.sanctionRecallDate),CONSTANTS.NEW_SUBMIT_DATE_FORMAT),
										"sanctionHours" : val.data.sanctionHours,
										"whetherSanctionCompleted" : whetherSanctionCompleted,
										"appealOutcome" :this$.getIdValueJson(val.data.appealOutcome),
								};
								if(!isNullOrEmpty(val.data.sanctionType) ||  !isNullOrEmpty(val.data.sanctionDate) || !isNullOrEmpty(val.data.sanctionRecallDate) 
										|| !isNullOrEmpty(val.data.sanctionHours) || !isNullOrEmpty(val.data.appealOutcome)){
								  sanctionDetailsList.push(sanctionData);
								}
							});
						}

                       
						disciplinaryactivity.set("sanctionDetails", sanctionDetailsList);

						var docStore = this$.getStore('personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentStore');
						var docArray = [];
						if (docStore.data.items != null
								&& docStore.data.items.length > 0) {
							Ext.each(docStore.data.items, function(val) {
								var newData = {
										"name" : val.data.documentName,
										"path" : val.data.path,
										"type" : val.data.type,
										"createdBy" : this$.getIdValueJson(
												val.data.createdBy.id,
												val.data.createdBy.value)
								};
								docArray.push(newData);
							});
						}
					}
					//formData.documents = docArray;
					disciplinaryactivity.set("documents", docArray);
					delete disciplinaryactivity.data.disciplinaryActionDetails;
					jsonFormFieldData = Ext.encode(disciplinaryactivity.data);
					return jsonFormFieldData;
				},
				getJsonDisciplinaryDataSUEdit: function(form,record) {

					var this$ = this;
					var jsonFormFieldData = new Object();
					var personObj = this$.getPersonObj();
					var formData = form.getValues();
					var disciplinaryactivity = new Academia.model.personinfo.common.disciplinaryactivity.DisciplinaryActionSUModel();
					if (!isEmpty(formData)) {
						var person = new Object();
						person.id = personObj["id"];
						formData.person = person;
						disciplinaryactivity.set("id",record.data.id);
						disciplinaryactivity.set("person", person);

						var misConductTypeObj = new Object();
						misConductTypeObj.id = formData.typeOfMisconduct;
						formData.typeOfMisconduct = misConductTypeObj;

						var dateOfMisconduct = null;
						if(!isNullOrEmpty(formData.dateOfMisconduct)){
							dateOfMisconduct = formData.dateOfMisconduct;
						}

						var temporarySuspensionDate = null;
						if(!isNullOrEmpty(formData.temporarySuspensionDate)){
							temporarySuspensionDate = formData.temporarySuspensionDate;
						}
						disciplinaryactivity.set("notifyStudent", formData.notifyStudent);

						disciplinaryactivity.set("misconductType", misConductTypeObj.id);
						disciplinaryactivity.set("dateOfMisconduct", dateOfMisconduct);
						disciplinaryactivity.set("tempSuspension", formData.temporarysSuspension);
						disciplinaryactivity.set("tempSuspensionDate", temporarySuspensionDate);

						var disciplinaryCommitteeObj = new Object();
						disciplinaryCommitteeObj.id = formData.disciplinaryCommittee;
						formData.disciplinaryCommittee = disciplinaryCommitteeObj.id;

						disciplinaryactivity.set("disciplinaryCommittee", disciplinaryCommitteeObj.id);

						var temporarySuspensionAccessRestrictionObj = new Object();

						temporarySuspensionAccessRestrictionObj.id = formData.temporarySuspensionAccessRestriction;
						formData.temporarySuspensionAccessRestriction = temporarySuspensionAccessRestrictionObj;


						var temporarySuspensionLapseDate = null;
						if(!isNullOrEmpty(formData.temporarySuspensionLapseDate)){
							temporarySuspensionLapseDate = formData.temporarySuspensionLapseDate;
						}
						disciplinaryactivity.set("tempAccessRestriction", temporarySuspensionAccessRestrictionObj.id);
						disciplinaryactivity.set("isTempSuspensionLapse", formData.temporarysSuspensionLapse);
						disciplinaryactivity.set("tempSuspensionLapseDate", temporarySuspensionLapseDate);

						var appealOutcomeObj = new Object();

						appealOutcomeObj.id = formData.appealOutcome;
						formData.appealOutcome = appealOutcomeObj.id;
						
						if(isArray(formData.appeal)) {
						   disciplinaryactivity.set("whetherAppealed", formData.appeal[0]);
						} else {
							disciplinaryactivity.set("whetherAppealed", formData.appeal);
						}
						


						var disciplinaryDeterminationDate = null;
						if(!isNullOrEmpty(formData.disciplinaryDeterminationDate)){
							disciplinaryDeterminationDate = formData.disciplinaryDeterminationDate;
						}

						var disciplinaryCommitteeHearingDate = null;
						if(!isNullOrEmpty(formData.disciplinaryCommitteeHearingDate)){
							disciplinaryCommitteeHearingDate = formData.disciplinaryCommitteeHearingDate;
						}
						 var disciplinaryDeterminationObj = new Object();

	                        disciplinaryDeterminationObj.id = formData.disciplinaryDetermination;
							formData.disciplinaryDetermination = disciplinaryDeterminationObj;
						var disciplinaryDetailList = {

								//"id":record.data.disciplinaryCommitteeDetails.id,
								"disciplinaryDetermination" : disciplinaryDeterminationObj.id,
								"determinationDate" : disciplinaryDeterminationDate,
								"determinationHearingDate" : disciplinaryCommitteeHearingDate,
								"whetherGuilty" : formData.isGuilty
						};
						disciplinaryactivity.set("disciplinaryCommitteeDetails", disciplinaryDetailList);
						var appealDate = null;
						if(!isNullOrEmpty(formData.appealDate)){
							appealDate = formData.appealDate;
						}
						var appealOutcomeDetailList = {

								//"id":record.data.appealDetails.id,
								"appealDate" : formData.appealDate,
								"appealOutcome" : appealOutcomeObj.id,
								"misConductDetails" : formData.misconductDetail,
								"remarks" : formData.notesRemarks
						};

						disciplinaryactivity.set("appealDetails", appealOutcomeDetailList);

						var docStore = this$.getStore('personinfo.common.disciplinaryactivity.DisciplinarySanctionDetailGridStore');
						var sanctionDetailsList=[];
						if (docStore.data.items != null
								&& docStore.data.items.length > 0) {
							Ext.each(docStore.data.items, function(val) {
								var temp;
								if(val.data.whetherSanctionCompleted == 'Yes'){
									temp = true;
								}
								else{
									temp=false;
								}
								var sactionType;
								if(!isNullOrEmpty(val.data.sanctionType)){
									if(Ext.isObject(val.data.sanctionType)){
										sactionType = val.data.sanctionType.id;
									}else{
										sactionType = val.data.sanctionType;
									}
								}
								var appealOutcome;
								if(!isNullOrEmpty(val.data.appealOutcome)){
									if(Ext.isObject(val.data.appealOutcome)){
										appealOutcome = val.data.appealOutcome.id;
									}else{
										appealOutcome = val.data.appealOutcome;
									}
								}

								var sanctioncompletionDate;
								if(!isNullOrEmpty(val.data.sanctionDate)){
									sanctioncompletionDate = val.data.sanctionDate;
								}

								var sanctionRecallDate;
								if(!isNullOrEmpty(val.data.sanctionRecallDate)){
									sanctionRecallDate = val.data.sanctionRecallDate;
								}

								var sanctionHours;
								if(!isNullOrEmpty(val.data.sanctionHours)){
									sanctionHours = val.data.sanctionHours;
								}
								var sanctionData = {
										"id":val.data.id,
										"sanctionType" : this$.getIdValueJson(sactionType),
										"sanctionDate" : Ext.Date.format(new Date(sanctioncompletionDate),CONSTANTS.NEW_SUBMIT_DATE_FORMAT),
										"sanctionRecallDate": Ext.Date.format(new Date(sanctionRecallDate),CONSTANTS.NEW_SUBMIT_DATE_FORMAT),
										"sanctionHours" : sanctionHours,
										"whetherSanctionCompleted" : temp,
										"appealOutcome" :this$.getIdValueJson(appealOutcome),
								};
								
								if(!isNullOrEmpty(val.data.sanctionType) ||  !isNullOrEmpty(val.data.sanctionDate) || !isNullOrEmpty(val.data.sanctionRecallDate) 
										|| !isNullOrEmpty(val.data.sanctionHours) || !isNullOrEmpty(val.data.appealOutcome)){
									sanctionDetailsList.push(sanctionData);
								}
							});
						}


						disciplinaryactivity.set("sanctionDetails", sanctionDetailsList);

						var docStore = this$.getStore('personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentStore');
						var docArray = [];
						if (docStore.data.items != null
								&& docStore.data.items.length > 0) {
							Ext.each(docStore.data.items, function(val) {
								var newData = {
										"name" : val.data.documentName,
										"path" : val.data.path,
										"type" : val.data.type,
										"createdBy" : this$.getIdValueJson(
												val.data.createdBy.id,
												val.data.createdBy.value)
								};
								docArray.push(newData);
							});
						}
					}
					//formData.documents = docArray;
					disciplinaryactivity.set("documents", docArray);
					delete disciplinaryactivity.data.disciplinaryActionDetails;
					jsonFormFieldData = Ext.encode(disciplinaryactivity.data);
					return jsonFormFieldData;
				},
				editDisciplinaryActionFormSUWindow:function(informationType, formItemId, gridItemId){
					var this$ = this;
					var personProfile = this$.getContentPanelActiveTab();
					var grid = personProfile.down(gridItemId);

					if (grid.getSelectionModel().getCount() > 0) {
						this.showPersonCommonWindow(informationType, formItemId);
						var form = this$.getPersonDisciplinaryActionFormSU();
						var records = grid.getSelectionModel().getSelection()[0];
						var sanctionGrid = form.down('#sanctiondetailsgrid');
						sanctionGrid.getStore().removeAll();
						// var sanctionGridstore = sanctionGrid.getStore();
						setTimeout(function(){
							if(!isNullOrEmpty(records.data.id) &&  records.data.sanctionDetails.length>0){
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.PATH_FIND_SANCTION_DETAIL_SU,
									method: "GET",
									params:{
										id:records.data.id
									},
									success: function(frm, action) {
										Ext.getBody().unmask();
										//var data = frm.responseText;
										var data = Ext.JSON.decode(frm.responseText);
										sanctionGrid.getStore().loadData(data);
										sanctionGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ sanctionGrid.getStore().getCount());
									}
								});
								sanctionGrid.down('#btnAdd').hide();

							}else{
								sanctionGrid.down('#btnAdd').show();
							}
        				},300);
						
						var sanctionTypeCombo = sanctionGrid.columns[0].getEditor();
						sanctionTypeCombo.getStore().load();

						var appealOutcomeCombo = sanctionGrid.columns[4].getEditor();
						appealOutcomeCombo.getStore().load();


						var typeOfMisconduct = form.down('#typeOfMisconduct');
						typeOfMisconduct.setValue(records.data.misconductType);

						var dateOfMisconduct = form.down('#dateOfMisconduct');
						dateOfMisconduct.setValue(records.data.studentDateOfMisconduct);

						if(!isNullOrEmpty(records.data.tempSuspension)){
							var temporarysSuspension = form.down('#temporarysSuspension');
							temporarysSuspension.setValue({temporarysSuspension:records.data.tempSuspension});
						}

						if(!isNullOrEmpty(records.data.tempSuspensionDate)){
							var tempSuspensionDate = form.down('#temporarySuspensionDate');
							tempSuspensionDate.setValue(records.data.studentTempSuspensionDate);
						}

						if(!isNullOrEmpty(records.data.disciplinaryCommittee)){
							var disciplinaryCommittee = form.down('#disciplinaryCommittee');
							disciplinaryCommittee.setValue(records.data.disciplinaryCommittee);
						}

						if(!isNullOrEmpty(records.data.tempAccessRestriction)){
							var tempAccessRestriction = form.down('#temporarySuspensionAccessRestriction');
							tempAccessRestriction.setValue(records.data.tempAccessRestriction);
						}

						if(!isNullOrEmpty(records.data.isTempSuspensionLapse)){
							var temporarysSuspensionLapse = form.down('#temporarysSuspensionLapse');
							temporarysSuspensionLapse.setValue({temporarysSuspensionLapse:records.data.isTempSuspensionLapse});
						}

						if(!isNullOrEmpty(records.data.tempSuspensionLapseDate)){
							var tempSuspensionLapseDate = form.down('#temporarySuspensionLapseDate');
							tempSuspensionLapseDate.setValue(records.data.studentTempSuspensionLapseDate);
						}

						if(!isNullOrEmpty(records.data.disciplinaryCommitteeDetails.disciplinaryDetermination)){
							var disciplinaryDetermination = form.down('#disciplinaryDetermination');
							disciplinaryDetermination.getStore().load({
								callback: function(record, operation, success) {
									if (success) {
										try{
											disciplinaryDetermination.setValue(records.data.disciplinaryCommitteeDetails.disciplinaryDetermination.id);
										}
										catch(e){
											console.log('errorCatch2');
										}
									}
								}
							});
						}

						if(!isNullOrEmpty(records.data.disciplinaryCommitteeDetails)){
							var determinationDate = form.down('#disciplinaryDeterminationDate');
							determinationDate.setValue(records.data.disciplinaryCommitteeDetails.studentDeterminationDate);

							var determinationHearingDate = form.down('#disciplinaryCommitteeHearingDate');
							determinationHearingDate.setValue(records.data.disciplinaryCommitteeDetails.studentDeterminationHearingDate);

							var whetherGuilty = form.down('#isGuilty');
							whetherGuilty.setValue({isGuilty:records.data.disciplinaryCommitteeDetails.whetherGuilty});
						}

						if(!isNullOrEmpty(records.data.whetherAppealed)){
							var appeal = form.down('#appeal');
							appeal.setValue({appeal:records.data.whetherAppealed});
						}

						if(!isNullOrEmpty(records.data.appealDetails)){
							var appealDate = form.down('#appealDate');
							appealDate.setValue(records.data.appealDetails.studentAppealDate);

							var appealOutcome = form.down('#appealOutcome');
							appealOutcome.setValue(records.data.appealDetails.appealOutcome);

							var misconductDetail = form.down('#misconductDetail');
							misconductDetail.setValue(records.data.appealDetails.misConductDetails);

							var remarks = form.down('#notesRemarks');
							remarks.setValue(records.data.appealDetails.remarks);
						}
						var notifyStudentFiled = form.down('#notifyStudent');

						if (records.data.disciplinaryActionDetails) {
							records.data.disciplinaryActionDetails.forEach(function(obj) {
								if (obj.studentId == personProfile.userId) {
									notifyStudentFiled.setValue(obj.notifyStudent);
								}
							});
						}

					}else {
						showWarningMessage(getPersonModuleTranslation('DISCIPLINARY_ACTION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				},
				deleteDisciplinaryActionSURecord: function(gridItemId, deleteUrl) {

					var this$ = this;
					var personProfile = this$.getContentPanelActiveTab();
					var personObj = this$.getPersonObj();
					//var person = new Object();
					var personId = personObj["id"];
					var grid = personProfile.down(gridItemId);
					if (grid.getSelectionModel().getCount() > 0) {
						showConfirmMessage(getPersonModuleTranslation('DISCIPLINARY_ACTION'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
							if (btn == 'yes') {
								if (grid.getSelectionModel().getCount() > 0) {
									var records = grid.getSelectionModel().getSelection();
									for (var count = 0; count < records.length; count++) {
										var id = "";
										if (!isNullOrEmpty(records[count].get("id"))) {
											id = records[count].get("id");
										}
										Ext.Ajax.request({
											type: 'rest',
											url: deleteUrl +"?id="+id,
											method: 'GET',
											headers: {
												'Content-Type': 'application/json'
											},
											success: function(form, action) {
												grid.getStore().reload();
												showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('DISCIPLINARY_ACTION_DELETE_SUCCESS'));
											}
										});
									}
								}
							}
						});
					} else {
						showWarningMessage(getPersonModuleTranslation('DISCIPLINARY_ACTION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}

				},
				documentSUReportDocumentZip : function() {
					
					var $this = this;
					var form = $this.getDisciplinaryactiondocumentsulist();
					var disciplinaryActionGrid=form.down('#disciplinaryactiondocumentlistgridItemIdsu');
					if (disciplinaryActionGrid.getSelectionModel().getCount() > 0) {
						var records = disciplinaryActionGrid.getSelectionModel().getSelection();
						var dispatchZipName = "Disciplinary action SU Documnet";
						var saveModel=[];  
						for(var i in records){
							if(!isNullOrEmpty(records[i].get('path'))) {
								saveModel.push(records[i].get('path'));
							}
							showConfirmMessage(getPersonModuleTranslation('DISCIPLINARY_ACTION_SU_DOCUMENTS'),
									getPersonModuleTranslation('DISCIPLINARY_ACTION_SU_DOCUMENTS_ALERT'),
									function(btn, text) {
								if (btn == 'yes') {
									var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
									$this.getController('Academia.controller.document.DocumentController')
									.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
								}
							});

						}
					}
					else {
						$this.hideWindowMask();
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				},
				deleteDisciplinarySUDocument:function(){
					var $this=this;
					var form = $this.getDisciplinaryactiondocumentsulist();
					var disciplinaryactiongrid= $this.getDisciplinaryactionsugrid();
					var disciplinaryaction = this.getDisciplinaryactiondocumentlistgridsu();
					var disciplinaryActionDocGrid=form.down('#disciplinaryactiondocumentlistgridItemIdsu');
					if (disciplinaryActionDocGrid.getSelectionModel().getCount() > 0) {
						var records = disciplinaryActionDocGrid.getSelectionModel().getSelection();
						var ids=[];
						Ext.Array.each(records,function(value){
							ids.push(value.data.id);
						});
						showConfirmMessage(getPersonModuleTranslation('DISCIPLINARY_ACTIVITY'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
							if (btn == 'yes'){
								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								Ext.Ajax.request({
									method: "DELETE",
									type: 'rest',
									url : SERVERURL.DELETE_FILE_DOCUMENT_SU+'?fileDocumentIds='+ids.join(),
									headers: {
										'Content-Type': 'application/json'
									},
									success: function(form, action) {

										Ext.getBody().unmask();
										showSuccessMessage(getPersonModuleTranslation('DISCIPLINARY_ACTIVITY'),getPersonModuleTranslation('DISCIPLINARY_DOCUMENT_SUCCESS_DELETE_MSG'));	 
										disciplinaryActionDocGrid.store.reload();
										disciplinaryactiongrid.store.reload();
										disciplinaryActionDocGrid.getSelectionModel().deselectAll(true);
									}
								});
							}
						});
					} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
					}
				},
});