/**
 * This controller is used for the faculty feedback and survey Controller.
 * @author Sachin.Bangar
 */
Ext.define('Academia.controller.personinfo.faculty.FacultyFeedbackSurveyController', {
    extend: 'Academia.controller.personinfo.common.PersonFeedbackSurveyController',

    refs: [{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'personFeedbackGivenForm',
        selector: 'feedbackgivenform[itemId=facultyFeedbackGivenForm]'
    }, {
        ref: 'personFeedbackReceiveForm',
        selector: 'feedbackreceiveform[itemId=facultyFeedbackReceiveForm]'
    }, {
        ref: 'personSurveyQuickSearchPanel',
        selector: 'surveyquicksearchpanel[itemId=facultySurveyHistoryGrid] form[itemId=surveyHistoryForm]'
    }, {
        ref: 'searchResultGrid',
        selector: 'searchresultgrid[itemId=surveyHistoryGrid]'
    },{
    	ref: 'personActiveSurveyForm',
    	selector: 'activesurveyform[itemId=facultyActiveSurveyForm]'
    }],
    config: {
    	FACULTY_FEEDBACK_GIVEN_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_FEEDBACK_GIVEN_PRIVILEGES'),
    	FACULTY_FEEDBACK_RECEIVED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_FEEDBACK_RECEIVED_PRIVILEGES'),
    	FACULTY_ACTIVE_SURVEY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_ACTIVE_SURVEY_PRIVILEGES')
    },
    init: function(application) {
    	this.control({
    		/**
    		 * Feedback Given
    		 */
    		 'feedbackgivengrid[itemId=facultyFeedbackGivenGrid]': {
                 render: function(grid) {
                 	//this.loadGridStore('#facultyFeedbackGivenGrid', SERVERURL.EDUCATION_HISTORY_GRIDDATA);
                	 this.doAccessControlValidation(grid, this.getFACULTY_FEEDBACK_GIVEN_PERMISSIONS());
                 }
             },
             'feedbackgivengrid[itemId=facultyFeedbackGivenGrid] button[itemId=btnView]': {
             	click: function(){
             		this.viewFeedbackGiven('FEEDBACK_GIVEN', 'facultyFeedbackGivenForm', '#facultyFeedbackGivenGrid');
             	}
             },
             'personcommonwindow[itemId=personCommonWindow] feedbackgivenform[itemId=facultyFeedbackGivenForm] button[itemId=cancelButtonId]': {
                 click: this.closePersonCommonWindow
             },
             
             /**
     		 * Feedback Received
     		 */
             
             'feedbackreceivedgrid[itemId=facultyFeedbackReceivedGrid]': {
                 render: function(grid) {
                 	//this.loadGridStore('#facultyFeedbackReceivedGrid', SERVERURL.EDUCATION_HISTORY_GRIDDATA);
                	 this.doAccessControlValidation(grid, this.getFACULTY_FEEDBACK_RECEIVED_PERMISSIONS());
                 }
             },
             'feedbackreceivedgrid[itemId=facultyFeedbackReceivedGrid] button[itemId=btnView]': {
             	click: function(){
             		this.viewFeedbackReceived('FEEDBACK_RECEIVE', 'facultyFeedbackReceiveForm', '#facultyFeedbackReceivedGrid');
             	}
             },
             'personcommonwindow[itemId=personCommonWindow] feedbackreceiveform[itemId=facultyFeedbackReceiveForm] button[itemId=cancelButtonId]': {
                 click: this.closePersonCommonWindow
             },
             /**
      		 * Survey History
      		 */
             'surveyquicksearchpanel[itemId=facultySurveyHistoryGrid] form[itemId=surveyHistoryForm] button[itemId=surveyBasicSearchBtn]': {
                 click: function() {
                     this.loadGridAndSearchUsers(this.getPersonSurveyQuickSearchPanel());
                 }
             },
             /**
      		 * Active Survey
      		 */
              
              'activesurveygrid[itemId=facultyActiveSurveyGrid]': {
                  render: function(grid) {
                  	//this.loadGridStore('#facultyActiveSurveyGrid', SERVERURL.EDUCATION_HISTORY_GRIDDATA);
                	  this.doAccessControlValidation(grid, this.getFACULTY_ACTIVE_SURVEY_PERMISSIONS());
                  }
              },
              'activesurveygrid[itemId=facultyActiveSurveyGrid] button[itemId=btnView]': {
               	click: function(){
               		this.viewActiveSurvey('ACTIVE_SURVEY', 'facultyActiveSurveyForm', '#facultyActiveSurveyGrid');
               	}
               },
               'personcommonwindow[itemId=personCommonWindow] activesurveyform[itemId=facultyActiveSurveyForm] button[itemId=cancelButtonId]': {
                   click: this.closePersonCommonWindow
               }
    	});
    }
});