/**
 * @author Raghavendra.Soni   
 */
Ext.define('Academia.controller.personinfo.faculty.LearningTargetsController', {
	extend: 'Academia.controller.base.BaseController',
    models: [
    	'genericmodels.dropdowns.EnumCombo',
    	'common.IdValueCodeDataModel',
    	'common.IdValueDataModel',
    	'examinationcenters.remark.EvaluationLevelByEvalPlanModel'
    ],
    stores: [
    	'examCenter.AssignSequence.EvaluationType',
    	'program.ProgramCodeOrNameSmartSearch',
    	'examinationcenters.reports.ExaminationResultBatchStore',
    	'examinationcenters.evaluation.CoursesForFacultyStore',
        'scholarships.ScholarshipCoursesStore',
    	'attendance.VariantMappedToSpecialGrade',
    	'examinationcenters.evaluationgroup.detailsequencecovered.EvalPlanTemplateMarksentry',
    	'examinationcenters.remark.EvaluationPlanLevelByEvaluationPlanId',
    	'program.programDetails.programBatches.courseParameter.LearningTargetsGridStore',
    	'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'
    ],
    views: [
    	'personinfo.common.course.LearningTargetStructure',
    	'personinfo.common.course.LearningTargetsFilter',
    	'personinfo.common.course.LearningTargetsGrid',
    	'personinfo.common.course.LearningTargetsReviewForm',
        'learningtarget.LearningtargetstructureCore',
        'learningtarget.LearningTargetsCoreFilter',
        'learningtarget.LearningTargetsCoreGrid',
        'learningtarget.LearningTargetsReviewCoreForm'
          
    ],
    refs: [{
        ref: 'learningtargetstructure',
        selector: 'learningtargetstructure'  
    }, {
        ref: 'learningtargetsfilter',
        selector: 'learningtargetsfilter'
    }, {
        ref: 'learningtargetsgrid',
        selector: 'learningtargetsgrid' 
    },{
    	ref: 'learningtargetsreviewform',
    	selector: 'learningtargetsreviewform'
    },{
    	ref: 'learningtargetsCorefilter',
    	selector: 'learningtargetsCorefilter'
    },{
    	ref: 'learningtargetstructureCore',
    	selector: 'learningtargetstructureCore'
    },{
    	ref: 'learningtargetscoregrid',
    	selector: 'learningtargetscoregrid'
    },{
    	ref: 'learningtargetsreviewcoreform',
    	selector: 'learningtargetsreviewcoreform'
    }],
    config: {
    	//ORGANIZATION_STRUCTURE_ACADEMY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ORGANIZATION_STRUCTURE_ACADEMY_PRIVILEGES')
		LEARNING_TARGETS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LEARNING_TARGETS_PERMISSIONS')
    },
    init: function(application) {
        this.control({
            'learningtargetsfilter customcombobox[itemId=evaluationTypeItemId]': { 
                change: function(field) {
                	//Initializing all variables
                	var me = this,
                		filterForm = field.up('learningtargetsfilter'),
                		evaluationTypeField = filterForm.down('#evaluationTypeItemId'),
                		programField = filterForm.down('#programIdItemId'),
                		batchField = filterForm.down('#batchIdItemId'),
                		courseField = filterForm.down('#courseItemId'),
                		courseVarientField = filterForm.down('#courseVariantItemId'),
                		evalautionPlanField = filterForm.down('#evalautionPlanItemId'),
                		evalPlanLevelField = filterForm.down('#evalPlanLevelItemId'),
                		dependentFieldsExtraParams = {},
                		currentFieldValue = field.getValue(),
                		dependentFields = [programField, batchField, courseField, courseVarientField, evalautionPlanField, evalPlanLevelField];
                	
                	//Dependent field's (ProgramField) extraParams
                	if(!isNullOrEmpty(currentFieldValue)){
                		dependentFieldsExtraParams = {
                			qry: '',
                			academyLocationId:me.getCurrentAcademyLocation(),
                			facultyId: me.getCurrentlyLoggedInUser().id
                		};
                	}
                    
                	//Resetting dependent fields
                    me.clearDependentFields(dependentFields);
                    me.enableDisableDependentField(currentFieldValue, programField);
                    me.resetExtraParamsAndLoad(programField, dependentFieldsExtraParams, function(){
                    	
                    });
                }
            },
            'learningtargetsfilter customcombobox[itemId=programIdItemId]': {
                change: function(field) {
                	//Initializing all variables
                	var me = this,
                		filterForm = field.up('learningtargetsfilter'),
                		evaluationTypeField = filterForm.down('#evaluationTypeItemId'),
                		programField = filterForm.down('#programIdItemId'),
                		batchField = filterForm.down('#batchIdItemId'),
                		courseField = filterForm.down('#courseItemId'),
                		courseVarientField = filterForm.down('#courseVariantItemId'),
                		evalautionPlanField = filterForm.down('#evalautionPlanItemId'),
                		evalPlanLevelField = filterForm.down('#evalPlanLevelItemId'),
                		dependentFieldsExtraParams = {},
                		currentFieldValue = field.getValue(),
                		dependentFields = [batchField, courseField, courseVarientField, evalautionPlanField, evalPlanLevelField];
                	
                	//Dependent field's (BatchField) extraParams
                	if(!isNullOrEmpty(currentFieldValue)){
                		dependentFieldsExtraParams = {
                				id: currentFieldValue //programId
                		};
                	}
                    
                	//Resetting dependent fields
                    me.clearDependentFields(dependentFields);
                    me.enableDisableDependentField(currentFieldValue, batchField);
                    me.resetExtraParamsAndLoad(batchField, dependentFieldsExtraParams, function(){
                    	
                    });
                }
            },
            'learningtargetsfilter customcombobox[itemId=batchIdItemId]': {
                change: function(field) {
                	//Initializing all variables
                	var me = this,
                		filterForm = field.up('learningtargetsfilter'),
                		evaluationTypeField = filterForm.down('#evaluationTypeItemId'),
                		programField = filterForm.down('#programIdItemId'),
                		batchField = filterForm.down('#batchIdItemId'),
                		courseField = filterForm.down('#courseItemId'),
                		courseVarientField = filterForm.down('#courseVariantItemId'),
                		evalautionPlanField = filterForm.down('#evalautionPlanItemId'),
                		evalPlanLevelField = filterForm.down('#evalPlanLevelItemId'),
                		periodField = filterForm.down('#periodItemId');
                		dependentFieldsExtraParams = {},
                		currentFieldValue = field.getValue(),
                		dependentFields = [courseField, courseVarientField, evalautionPlanField, evalPlanLevelField, periodField],
                		batchFieldRecord;
                	
                	//Dependent field's (CourseField) extraParams
                	if(!isNullOrEmpty(currentFieldValue)){
                		var batchFieldRecord = me.getSelectedRecordFromCombo(batchField);
                		dependentFieldsExtraParams = {
                			facultyId: me.getCurrentlyLoggedInUser().id,
                			evaluationPlantype:evaluationTypeField.getValue(),
                			academyLocationId:me.getCurrentAcademyLocation(),
                			academicTermId:batchFieldRecord.raw.academicTermId,
                			batchId:currentFieldValue
                		};
                	}
    				
                	//Resetting dependent fields
                    me.clearDependentFields(dependentFields);
                    me.enableDisableDependentField(currentFieldValue, courseField);
                    periodField.getStore().getProxy().extraParams={
    					id:currentFieldValue
    				};
                    periodField.getStore().load({
						callback: function(records, operation, success) {
							if (success) {
								periodField.setValue(records[0].data.id);
							}	
						}	
					});
                    me.resetExtraParamsAndLoad(courseField, dependentFieldsExtraParams, function(){
                    	
                    });
				}
            },
            'learningtargetsfilter customcombobox[itemId=courseItemId]': {
                change: function(field) {
                	//Initializing all variables
                	var me = this,
                		filterForm = field.up('learningtargetsfilter'),
                		evaluationTypeField = filterForm.down('#evaluationTypeItemId'),
                		programField = filterForm.down('#programIdItemId'),
                		batchField = filterForm.down('#batchIdItemId'),
                		courseField = filterForm.down('#courseItemId'),
                		courseVarientField = filterForm.down('#courseVariantItemId'),
                		evalautionPlanField = filterForm.down('#evalautionPlanItemId'),
                		evalPlanLevelField = filterForm.down('#evalPlanLevelItemId'),
                		dependentFieldsExtraParams = {},
                		currentFieldValue = field.getValue(),
                		dependentFields = [courseVarientField, evalautionPlanField, evalPlanLevelField];
                	
                	//Dependent field's (CourseVarientField) extraParams
                	if(!isNullOrEmpty(currentFieldValue)){
                		dependentFieldsExtraParams = {
                			courseId: courseField.getValue(),
                			batchId:batchField.getValue()
                		};
                	}
                    
                	//Resetting dependent fields
                    me.clearDependentFields(dependentFields);
                    me.enableDisableDependentField(currentFieldValue, courseVarientField);
                    me.resetExtraParamsAndLoad(courseVarientField, dependentFieldsExtraParams, function(){
                    	
                    });
                }
            },
            'learningtargetsfilter customcombobox[itemId=courseVariantItemId]': {
                change: function(field) {
                	//Initializing all variables
                	var me = this,
                		filterForm = field.up('learningtargetsfilter'),
                		evaluationTypeField = filterForm.down('#evaluationTypeItemId'),
                		programField = filterForm.down('#programIdItemId'),
                		batchField = filterForm.down('#batchIdItemId'),
                		courseField = filterForm.down('#courseItemId'),
                		courseVarientField = filterForm.down('#courseVariantItemId'),
                		evalautionPlanField = filterForm.down('#evalautionPlanItemId'),
                		evalPlanLevelField = filterForm.down('#evalPlanLevelItemId'),
                		dependentFieldsExtraParams = {},
                		currentFieldValue = field.getValue(),
                		dependentFields = [evalautionPlanField, evalPlanLevelField];
                	
                	//Dependent field's (EvaluationPlanField) extraParams
                	if(!isNullOrEmpty(currentFieldValue)){
                		dependentFieldsExtraParams = {
                				courseVariantId: courseVarientField.getValue()
                		};
                	}
                    
                	//Resetting dependent fields
                    me.clearDependentFields(dependentFields);
                    me.enableDisableDependentField(currentFieldValue, evalautionPlanField);
                    me.resetExtraParamsAndLoad(evalautionPlanField, dependentFieldsExtraParams, function(){
                    	
                    });
                }
            },
            'learningtargetsfilter customcombobox[itemId=evalautionPlanItemId]': {
                change: function(field) {
                	//Initializing all variables
                	var me = this,
                		filterForm = field.up('learningtargetsfilter'),
                		evaluationTypeField = filterForm.down('#evaluationTypeItemId'),
                		programField = filterForm.down('#programIdItemId'),
                		batchField = filterForm.down('#batchIdItemId'),
                		courseField = filterForm.down('#courseItemId'),
                		courseVarientField = filterForm.down('#courseVariantItemId'),
                		evalautionPlanField = filterForm.down('#evalautionPlanItemId'),
                		evalPlanLevelField = filterForm.down('#evalPlanLevelItemId'),
                		dependentFieldsExtraParams = {},
                		currentFieldValue = field.getValue(),
                		dependentFields = [evalPlanLevelField];
                	
                	//Dependent field's (EvalPlanLevelField) extraParams
                	if(!isNullOrEmpty(currentFieldValue)){
                		dependentFieldsExtraParams = {
                				evaluationPlanId: currentFieldValue
                		};
                	}
                    
                	//Resetting dependent fields
                    me.clearDependentFields(dependentFields);
                    me.enableDisableDependentField(currentFieldValue, evalPlanLevelField);
                    me.resetExtraParamsAndLoad(evalPlanLevelField, dependentFieldsExtraParams, function(){
                    	
                    });
                }
            },
            'learningtargetsfilter button[itemId=learningTargetSearchButtonId]': {
            	click: function(btn){
            		var me = this;
            		var learningtargetsfilter = btn.up('learningtargetsfilter');
            		var learningtargetstructure = btn.up('learningtargetstructure');
            		var learningtargetsgrid = learningtargetstructure.down('learningtargetsgrid');
            		var learningtargetsreviewform = learningtargetstructure.down('learningtargetsreviewform');
            		var learningtargetsgridStore = learningtargetsgrid.getStore();
            		var learningtargetsfilterValues = learningtargetsfilter.getForm().getValues();
            		var evalPlanLevelRecord = me.getSelectedRecordFromCombo(learningtargetsfilter.down('#evalPlanLevelItemId'));
            		
            		learningtargetsgridStore.removeAll();
            		learningtargetsreviewform.getForm().reset();
            		
            		learningtargetsgridStore.getProxy().extraParams={
            			programId: learningtargetsfilterValues.program,
            			batchId: learningtargetsfilterValues.batchId,
            			courseId: learningtargetsfilterValues.courseId,
            			courseVariantId: learningtargetsfilterValues.courseVariant,
            			evaluationPlanId: learningtargetsfilterValues.evalautionPlan,
            			evaluationType: learningtargetsfilterValues.evaluationType,
            			evaluationTypeCode: evalPlanLevelRecord.get('code'),
            			levelId: evalPlanLevelRecord.get('levelId'),
            			levelName: learningtargetsfilterValues.evalPlanLevelId,
            			academyLocationId:me.getCurrentAcademyLocation()
            		};
            		learningtargetsgridStore.load({
            			scope:this,
            			callback: function (records, operation, success) {
            				if(success){
            					
            					if(records.length){
            						learningtargetsgrid.down('#btnExportToPDF').setDisabled(false);
            						learningtargetsgrid.down('#btnExportToExcel').setDisabled(false);
            					}
            					else{
            						learningtargetsgrid.down('#btnExportToPDF').setDisabled(true);
            						learningtargetsgrid.down('#btnExportToExcel').setDisabled(true);
            					}
            					var sm = learningtargetsgrid.getSelectionModel();
            					Ext.each(records, function(record) {
            						if(record.data.isSelected){
            							var row = record.index;
            							sm.select(row, true);
            						}
            					});
            					
            					var teacherComment = records[0].raw.facultyComment;
            					var reviewDate = records[0].raw.reviewDate;
            					var nextReviewDate = records[0].raw.nextReviewDate;

        						learningtargetsreviewform.down('#reviewDate').setMinValue(false);
        						learningtargetsreviewform.down('#nextReviewDate').setMinValue(false);
        						learningtargetsreviewform.down('#reviewDate').setMaxValue(false);
        						learningtargetsreviewform.down('#nextReviewDate').setMaxValue(false);
            					
            					if(!isNullOrEmpty(reviewDate)){
            						learningtargetsreviewform.down('#reviewDate').setValue(reviewDate);
            					}
            					else{
            						learningtargetsreviewform.down('#reviewDate').setValue(new Date());
            					}
            					
            					if(!isNullOrEmpty(nextReviewDate)){
            						learningtargetsreviewform.down('#nextReviewDate').setValue(nextReviewDate);
            					}
            					
            					if(!isNullOrEmpty(teacherComment)){
            						learningtargetsreviewform.down('#teacherComment').setValue(teacherComment);
            					}
            				}
            			}
            		});
            	}
            }, 
              'learningtargetstructureCore':{
				afterrender: function(field){
					var me=this;
					var associatedAcadLocationIds = new Array();
				associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,me.getLEARNING_TARGETS_PERMISSIONS());
            		var apporvetargetBtn=field.down('#learningTargetApproveButtonId');   
                    apporvetargetBtn.setVisible(false);
                         Ext.each(permissionList, function(privilege) {
					if (privilege === 'APPROVE_TARGETS') {
						if (!isNullOrEmpty(apporvetargetBtn)) {   
							apporvetargetBtn.setVisible(true);
							    
						}
					}
				});
            	}},  
            	'learningtargetstructureCore panel[itemId=learningTargetParent]':{
            		afterrender:function(cmp){
            		var grid = cmp.down('learningtargetscoregrid');
       				 this.getGridHeaderFreezeForLearningTarget(grid,cmp);
            		}
            	},
              'learningtargetsCorefilter customcombobox[itemId=evaluationTypeItemId]': {
                change: function(field) {
                	//Initializing all variables
                	var me = this,
                		filterForm = field.up('learningtargetsCorefilter'),
                		evaluationTypeField = filterForm.down('#evaluationTypeItemId'),
                        academicTermId=filterForm.down('#assessmentSchemeAcademicTermId')
                		programField = filterForm.down('#programIdItemId'),   
                		batchField = filterForm.down('#batchIdItemId'),
                		courseField = filterForm.down('#courseItemId'),
                		courseVarientField = filterForm.down('#courseVariantItemId'),
                		evalautionPlanField = filterForm.down('#evalautionPlanItemId'),
                		evalPlanLevelField = filterForm.down('#evalPlanLevelItemId'),  
                		dependentFieldsExtraParams = {},
                		currentFieldValue = field.getValue(),
                		dependentFields = [programField, batchField, courseField, courseVarientField, evalautionPlanField, evalPlanLevelField];
                	
                	//Dependent field's (ProgramField) extraParams
                	if(!isNullOrEmpty(currentFieldValue)){
                		dependentFieldsExtraParams = {
                			qry: '',
                			academyLocationId:me.getCurrentAcademyLocation() 
                			//facultyId: me.getCurrentlyLoggedInUser().id
                		};
                	}
                    
                	//Resetting dependent fields
                    me.clearDependentFields(dependentFields);
                    me.enableDisableDependentField(currentFieldValue, academicTermId);
                    me.resetExtraParamsAndLoad(programField, dependentFieldsExtraParams, function(){
                    	
                    });
                }
            }, 
                 'learningtargetsCorefilter customcombobox[itemId=assessmentSchemeAcademicTermId]': {
                change: function(field) {
                	//Initializing all variables
                	var me = this,
                		filterForm = field.up('learningtargetsCorefilter'),
                		evaluationTypeField = filterForm.down('#evaluationTypeItemId'),//assessmentSchemeAcademicTermId
                        academicTermId=filterForm.down('#assessmentSchemeAcademicTermId')
                		programField = filterForm.down('#programIdItemId'),
                		batchField = filterForm.down('#batchIdItemId'),
                		courseField = filterForm.down('#courseItemId'),
                		courseVarientField = filterForm.down('#courseVariantItemId'),
                		evalautionPlanField = filterForm.down('#evalautionPlanItemId'),
                		evalPlanLevelField = filterForm.down('#evalPlanLevelItemId'),
                		dependentFieldsExtraParams = {},
                		currentFieldValue = field.getValue(),
                		dependentFields = [programField, batchField, courseField, courseVarientField, evalautionPlanField, evalPlanLevelField];
                	
                	//Dependent field's (ProgramField) extraParams
                	if(!isNullOrEmpty(currentFieldValue)){
                		dependentFieldsExtraParams = {
                			qry: '',
                			academyLocationId:me.getCurrentAcademyLocation() 
                			//facultyId: me.getCurrentlyLoggedInUser().id
                		};
                	}
                    
                	//Resetting dependent fields
                    me.clearDependentFields(dependentFields);
                    me.enableDisableDependentField(currentFieldValue, programField);
                    me.resetExtraParamsAndLoad(programField, dependentFieldsExtraParams, function(){
                    	
                    });
                }
            },
               'learningtargetsCorefilter customcombobox[itemId=programIdItemId]': {
                change: function(field) {
                	//Initializing all variables
                	var me = this,
                		filterForm = field.up('learningtargetsCorefilter'),
                		evaluationTypeField = filterForm.down('#evaluationTypeItemId'),
                        academicTermId=filterForm.down('#assessmentSchemeAcademicTermId'),
                		programField = filterForm.down('#programIdItemId'),
                		batchField = filterForm.down('#batchIdItemId'),
                		courseField = filterForm.down('#courseItemId'),
                		courseVarientField = filterForm.down('#courseVariantItemId'),
                		evalautionPlanField = filterForm.down('#evalautionPlanItemId'),
                		evalPlanLevelField = filterForm.down('#evalPlanLevelItemId'),
                		dependentFieldsExtraParams = {},
                		currentFieldValue = field.getValue(),
                		dependentFields = [batchField, courseField, courseVarientField, evalautionPlanField, evalPlanLevelField];
                	
                	//Dependent field's (BatchField) extraParams
                	if(!isNullOrEmpty(currentFieldValue)){
                		dependentFieldsExtraParams = {
                				id: currentFieldValue //programId
                		};
                	}
                    
                	//Resetting dependent fields
                    me.clearDependentFields(dependentFields);
                    me.enableDisableDependentField(currentFieldValue, batchField);
                    me.resetExtraParamsAndLoad(batchField, dependentFieldsExtraParams, function(){
                    	
                    });
                }
            },
                'learningtargetsCorefilter customcombobox[itemId=batchIdItemId]': {
                change: function(field) {
                	//Initializing all variables
                	var me = this,
                		filterForm = field.up('learningtargetsCorefilter'),
                		evaluationTypeField = filterForm.down('#evaluationTypeItemId'),
                        academicTermId=filterForm.down('#assessmentSchemeAcademicTermId'),
                		programField = filterForm.down('#programIdItemId'),
                		batchField = filterForm.down('#batchIdItemId'),
                		courseField = filterForm.down('#courseItemId'),
                		courseVarientField = filterForm.down('#courseVariantItemId'),
                		evalautionPlanField = filterForm.down('#evalautionPlanItemId'),
                		evalPlanLevelField = filterForm.down('#evalPlanLevelItemId'),
                		periodField = filterForm.down('#periodItemId'),
                		dependentFieldsExtraParams = {},
                		currentFieldValue = field.getValue(),
                		dependentFields = [courseField, courseVarientField, evalautionPlanField, evalPlanLevelField, periodField],
                		batchFieldRecord;
                	
                	//Dependent field's (CourseField) extraParams
                	if(!isNullOrEmpty(currentFieldValue)){
                		var batchFieldRecord = me.getSelectedRecordFromCombo(batchField);
                		dependentFieldsExtraParams = {
                			//facultyId: me.getCurrentlyLoggedInUser().id,
                			evaluationPlantype:evaluationTypeField.getValue(),
                			academyLocationId:me.getCurrentAcademyLocation(),
                			academicTermId:batchFieldRecord.raw.academicTermId,
                			batchId:currentFieldValue
                		};
                	}
    				
                	//Resetting dependent fields
                    me.clearDependentFields(dependentFields);
                    me.enableDisableDependentField(currentFieldValue, courseField);
                    periodField.getStore().getProxy().extraParams={
    					id:currentFieldValue
    				};
                    periodField.getStore().load({
						callback: function(records, operation, success) {
							if (success) {
								periodField.setValue(records[0].data.id);
							}	
						}	
					});
                    me.resetExtraParamsAndLoad(courseField, dependentFieldsExtraParams, function(){
                    	
                    });
                    
                    
                }
            },
              'learningtargetsCorefilter customcombobox[itemId=courseItemId]': {     
                change: function(field) {
                	//Initializing all variables
                	var me = this,
                		filterForm = field.up('learningtargetsCorefilter'),
                		evaluationTypeField = filterForm.down('#evaluationTypeItemId'),
                        academicTermId=filterForm.down('#assessmentSchemeAcademicTermId'),
                		programField = filterForm.down('#programIdItemId'),
                		batchField = filterForm.down('#batchIdItemId'),
                		courseField = filterForm.down('#courseItemId'),
                		courseVarientField = filterForm.down('#courseVariantItemId'),
                		evalautionPlanField = filterForm.down('#evalautionPlanItemId'),
                		evalPlanLevelField = filterForm.down('#evalPlanLevelItemId'),
                		dependentFieldsExtraParams = {},
                		currentFieldValue = field.getValue(),
                		dependentFields = [courseVarientField, evalautionPlanField, evalPlanLevelField];
                	
                	//Dependent field's (CourseVarientField) extraParams
                	if(!isNullOrEmpty(currentFieldValue)){
                		dependentFieldsExtraParams = {
                			courseId: courseField.getValue(),
                            batchId:batchField.getValue()
                		};
                	}
                    
                	//Resetting dependent fields
                    me.clearDependentFields(dependentFields);
                    me.enableDisableDependentField(currentFieldValue, courseVarientField);
                    me.resetExtraParamsAndLoad(courseVarientField, dependentFieldsExtraParams, function(){
                    	
                    });
                }
            },
            
                //
               'learningtargetsCorefilter customcombobox[itemId=courseVariantItemId]': {
                change: function(field) {
                	//Initializing all variables
                	var me = this,
                		filterForm = field.up('learningtargetsCorefilter'),
                		evaluationTypeField = filterForm.down('#evaluationTypeItemId'),
                        academicTermId=filterForm.down('#assessmentSchemeAcademicTermId'),
                		programField = filterForm.down('#programIdItemId'),
                		batchField = filterForm.down('#batchIdItemId'),
                		courseField = filterForm.down('#courseItemId'),
                		courseVarientField = filterForm.down('#courseVariantItemId'),
                		evalautionPlanField = filterForm.down('#evalautionPlanItemId'),
                		evalPlanLevelField = filterForm.down('#evalPlanLevelItemId'),
                		dependentFieldsExtraParams = {},
                		currentFieldValue = field.getValue(),
                		dependentFields = [evalautionPlanField, evalPlanLevelField];
                	
                	//Dependent field's (EvaluationPlanField) extraParams
                	if(!isNullOrEmpty(currentFieldValue)){
                		dependentFieldsExtraParams = {
                				courseVariantId: courseVarientField.getValue()
                		};
                	}
                    
                	//Resetting dependent fields
                    me.clearDependentFields(dependentFields);
                    me.enableDisableDependentField(currentFieldValue, evalautionPlanField);
                    me.resetExtraParamsAndLoad(evalautionPlanField, dependentFieldsExtraParams, function(){
                    	
                    });
                }
            },
               
            'learningtargetsCorefilter customcombobox[itemId=evalautionPlanItemId]': {
                change: function(field) {
                	//Initializing all variables
                	var me = this,
                		filterForm = field.up('learningtargetsCorefilter'),
                		evaluationTypeField = filterForm.down('#evaluationTypeItemId'),
                        academicTermId=filterForm.down('#assessmentSchemeAcademicTermId'),
                		programField = filterForm.down('#programIdItemId'),
                		batchField = filterForm.down('#batchIdItemId'),
                		courseField = filterForm.down('#courseItemId'),
                		courseVarientField = filterForm.down('#courseVariantItemId'),
                		evalautionPlanField = filterForm.down('#evalautionPlanItemId'),
                		evalPlanLevelField = filterForm.down('#evalPlanLevelItemId'),
                		dependentFieldsExtraParams = {},
                		currentFieldValue = field.getValue(),
                		dependentFields = [evalPlanLevelField];
                	
                	//Dependent field's (EvalPlanLevelField) extraParams
                	if(!isNullOrEmpty(currentFieldValue)){
                		dependentFieldsExtraParams = {
                				evaluationPlanId: currentFieldValue
                		};
                	}
                    
                	//Resetting dependent fields
                    me.clearDependentFields(dependentFields);
                    me.enableDisableDependentField(currentFieldValue, evalPlanLevelField);
                    me.resetExtraParamsAndLoad(evalPlanLevelField, dependentFieldsExtraParams, function(){
                    	
                    });
                }
            },
             'learningtargetsCorefilter button[itemId=learningTargetSearchButtonId]': {
            	click: function(btn){
            		var me = this;learningtargetsCorefilter
            		var learningtargetsCorefilter = btn.up('learningtargetsCorefilter');
            		learningtargetsCorefilter.down('#learningTargetSearchButtonId').setDisabled(true);
            		var learningtargetCorestructure = btn.up('learningtargetstructureCore');
            		var learningtargetscoregrid = learningtargetCorestructure.down('learningtargetscoregrid');
            		var learningtargetsreviewcoreform = learningtargetCorestructure.down('learningtargetsreviewcoreform');
              		var learningtargetsgridStore = learningtargetscoregrid.getStore();
            		var learningtargetsfilterValues = learningtargetsCorefilter.getForm().getValues();
            		var evalPlanLevelRecord = me.getSelectedRecordFromCombo(learningtargetsCorefilter.down('#evalPlanLevelItemId'));
            		
            		learningtargetsgridStore.removeAll();
            		learningtargetsreviewcoreform.getForm().reset();
            		
            		learningtargetsgridStore.getProxy().extraParams={
            			programId: learningtargetsfilterValues.program,
            			batchId: learningtargetsfilterValues.batchId,
            			courseId: learningtargetsfilterValues.courseId,
            			courseVariantId: learningtargetsfilterValues.courseVariant,   
            			evaluationPlanId: learningtargetsfilterValues.evalautionPlan,
            			evaluationType: learningtargetsfilterValues.evaluationType,
            			evaluationTypeCode: evalPlanLevelRecord.get('code'),
            			levelId: evalPlanLevelRecord.get('levelId'),
            			levelName: learningtargetsfilterValues.evalPlanLevelId,
            			academyLocationId:me.getCurrentAcademyLocation()
            		};
            		learningtargetsgridStore.load({
            			scope:this,
            			callback: function (records, operation, success) {
                              if(success){
                            	  learningtargetsCorefilter.down('#learningTargetSearchButtonId').setDisabled(false);
            					if(records.length){
            						learningtargetscoregrid.down('#btnExportToPDF').setDisabled(false);
            						learningtargetscoregrid.down('#btnExportToExcel').setDisabled(false);
            					}
            					else{
            						learningtargetscoregrid.down('#btnExportToPDF').setDisabled(true);
            						learningtargetscoregrid.down('#btnExportToExcel').setDisabled(true);
            					}
                              }
            				if(success){
            					var sm = learningtargetscoregrid.getSelectionModel();
								var isApproverDisabled = true;

            					Ext.each(records, function(record) {
            						if(record.data.isSelected){
            							var row = record.index;
            							sm.select(row, true);
            						}
            					});

								var teacherComment = '';
								var principalComment= '';
								var reviewDate = '';
								var nextReviewDate = '';
								if(records.length){
									var teacherComment = records[0].raw.facultyComment;
            						var reviewDate = records[0].raw.reviewDate;
            						var nextReviewDate = records[0].raw.nextReviewDate;
									var principalComment = records[0].raw.principalComment;
								}            					
            					   

        						learningtargetsreviewcoreform.down('#reviewDate1').setMinValue(false);
        						learningtargetsreviewcoreform.down('#nextReviewDate1').setMinValue(false);
        						learningtargetsreviewcoreform.down('#reviewDate1').setMaxValue(false);
        						learningtargetsreviewcoreform.down('#nextReviewDate1').setMaxValue(false);
            					
            					if(!isNullOrEmpty(reviewDate)){
            						learningtargetsreviewcoreform.down('#reviewDate1').setValue(reviewDate);
            					}
            					else{
            						learningtargetsreviewcoreform.down('#reviewDate1').setValue(new Date());
            					}
            					
            					if(!isNullOrEmpty(nextReviewDate)){
            						learningtargetsreviewcoreform.down('#nextReviewDate1').setValue(nextReviewDate);
            					}
            					
            					if(!isNullOrEmpty(teacherComment)){
            						learningtargetsreviewcoreform.down('#teacherComment').setValue(teacherComment);
            					}

								if(!isNullOrEmpty(principalComment)){
            						learningtargetsreviewcoreform.down('#principalComment').setValue(principalComment);
            					}

								// btn.setDisabled(isApproverDisabled);
								var colOne = learningtargetscoregrid.columns[0];
								colOne.setWidth(colOne.getWidth() + 1);
								colOne.setWidth(colOne.getWidth() - 1);
            				}
            			}
            		});
            	}
            },
               
            'learningtargetsgrid':{
            	afterrender: function(grid){
            		grid.getStore().removeAll();
            	},
            	selectionchange:function(view,record){
            		this.validateReviewForm();
            	}
            },
            'learningtargetscoregrid':{      
            	afterrender: function(grid){
            		grid.getStore().removeAll();
            		grid.down('#btnExportToPDF').setDisabled(true);
            		grid.down('#btnExportToExcel').setDisabled(true);
            	},
            	selectionchange:function(view,record){    
            		this.validateReviewFormNew();
            	}
            },
            
            'learningtargetsreviewform datefield[itemId=reviewDate]':{
            	change: function(dt){
            		this.validateReviewForm();
            	}
            },
            'learningtargetsreviewform datefield[itemId=nextReviewDate]':{
            	change: function(dt){
            		this.validateReviewForm();
            	}
            },
            'learningtargetsreviewform textarea[itemId=teacherComment]':{
            	change: function(dt){
            		this.validateReviewForm();
            	}
            },
             'learningtargetsreviewcoreform datefield[itemId=reviewDate1]':{
            	change: function(dt){
            		this.validateReviewFormNew();
            	}
            },
            'learningtargetsreviewcoreform datefield[itemId=nextReviewDate1]':{
            	change: function(dt){
            		this.validateReviewFormNew();
            	}
            },
            'learningtargetsreviewcoreform textarea[itemId=teacherComment]':{
            	change: function(dt){
            		this.validateReviewFormNew();  
            	}
            },
			'learningtargetsreviewcoreform textarea[itemId=principalComment]':{
            	change: function(dt){
            		this.validateReviewFormNew();
            	}
            },
            
            'learningtargetsreviewform button[itemId=learningTargetSaveButtonId]':{
            	click: function(btn){
            		this.saveLearningTarget(btn);
            	}
            },   
               //Manas-luktuke
              'learningtargetsreviewcoreform button[itemId=learningTargetSaveButtonId]':{
            	click: function(btn){
					this.saveLearningTarget(btn);
            	}
            },
			'learningtargetsreviewcoreform button[itemId=learningTargetApproveButtonId]': {
				click: function (btn) {
				      var me = this;
				
				      var filterForm = this.getLearningtargetsCorefilter();
				      var learningTargetGrid = this.getLearningtargetscoregrid();
				      var reviewForm = this.getLearningtargetsreviewcoreform();
				
				      var reviewDate = reviewForm.down('#reviewDate1').getValue();
				      var nextReviewDate = reviewForm.down('#nextReviewDate1').getValue();
				      var apporvetargetBtn = reviewForm.down('#learningTargetApproveButtonId');
				      if (!isNullOrEmpty(nextReviewDate) && nextReviewDate <= reviewDate) {
				         showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('NEXT_REVIEW_DATE_ERROR'));
				         return false;
				      } else {
				         var evaluationTypeField = filterForm.down('#evaluationTypeItemId');
				         var programField = filterForm.down('#programIdItemId');
				         var batchField = filterForm.down('#batchIdItemId');
				         var courseField = filterForm.down('#courseItemId');
				         var courseVarientField = filterForm.down('#courseVariantItemId');
				         var evalautionPlanField = filterForm.down('#evalautionPlanItemId');
				         var evalPlanLevelField = filterForm.down('#evalPlanLevelItemId');
				         var periodField = filterForm.down('#periodItemId');
				         var principalComment = Ext.isDefined(reviewForm.down('#principalComment')) ? reviewForm.down('#principalComment').getValue() : "";
				         var teacherComment = reviewForm.down('#teacherComment').getValue();
				
				         var gridSelection = learningTargetGrid.getSelectionModel().getSelection();
				         var buttonDisabled = true;
				
				         if (gridSelection.length) {
				            var isAllRecordAlreadySaved = me.isGridRecordFilledCore(gridSelection);
				            if (isAllRecordAlreadySaved) {
				               Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				               var submitUrl = SERVERURL.PATH_APPROVE_LEARNING_TARGET_DETAIL;
				               var WSLearningTargetDetailModel = [];
				               Ext.each(gridSelection, function (currentRecord) {
				                  WSLearningTargetDetailModel.push({
				                     admissionId: currentRecord.raw.admissionId,
				                     finalResult: currentRecord.get('finalResult'),
				                     subjectTarget: currentRecord.get('subjectTarget'),
				                     id: currentRecord.get('learningTargetDetailsId')
				                  });
				               });
				               var evalPlanLevelRecord = me.getSelectedRecordFromCombo(filterForm.down('#evalPlanLevelItemId'));
				
				               var submitValue = {
				                  id: gridSelection[0].raw.learningTargetId,
				                  levelId: evalPlanLevelRecord.get('levelId'),
				                  periodId: periodField.getValue(),
				                  reviewDate: reviewDate,
				                  nextReviewDate: nextReviewDate,
				                  academicType: evaluationTypeField.getValue(),
				                  courseVariantId: courseVarientField.getValue(),
				                  evaluationPlanId: evalautionPlanField.getValue(),
				                  facultyComment: teacherComment,
				                  evaluationTypeCode: evalPlanLevelRecord.get('code'),
				                  wsLearningTargetDetailModelList: WSLearningTargetDetailModel,
				                  principalComment: principalComment
				               };
				               Ext.Ajax.request({
				                  type: 'rest',
				                  url: submitUrl,
				                  jsonData: Ext.encode(submitValue),
				                  method: 'POST',
				                  success: function (form, action) {
				                     Ext.getBody().unmask();
				                     showSuccessMessage(getCommonTranslation('LEARNING_TARGETS'),
				                        getCommonTranslation('RECORD_APPROVED_SUCCESSFULLY'));
				                     learningTargetGrid.getStore().removeAll();
				                     learningTargetGrid.getStore().load({
				                        scope: this,
				                        callback: function (records, operation, success) {
				                           if (success) {
				                              var sm = learningTargetGrid.getSelectionModel();
				                              Ext.each(records, function (record) {
				                                 if (record.data.isSelected) {
				                                    var row = record.index;
				                                    sm.select(row, true);
				                                 }
				                              });
				
				                              var teacherComment = records[0].raw.facultyComment;
				                              var reviewDate = records[0].raw.reviewDate;
				                              var nextReviewDate = records[0].raw.nextReviewDate;
				
				                              reviewForm.down('#reviewDate1').setMinValue(false);
				                              reviewForm.down('#nextReviewDate1').setMinValue(false);
				                              reviewForm.down('#reviewDate1').setMaxValue(false);
				                              reviewForm.down('#nextReviewDate1').setMaxValue(false);
				
				                              if (!isNullOrEmpty(reviewDate)) {
				                                 reviewForm.down('#reviewDate1').setValue(reviewDate);
				                              } else {
				                                 reviewForm.down('#reviewDate1').setValue(new Date());
				                              }
				
				                              if (!isNullOrEmpty(nextReviewDate)) {
				                                 reviewForm.down('#nextReviewDate1').setValue(nextReviewDate);
				                              }
				
				                              if (!isNullOrEmpty(teacherComment)) {
				                                 reviewForm.down('#teacherComment').setValue(teacherComment);
				                              }
				                              if (!isNullOrEmpty(principalComment)) {
				                                 reviewForm.down('#principalComment').setValue(principalComment);
				                              }
				                           }
				                        }
				                     });
				                  }
				               });
				            }
							else {
								//msg "pls save all record before approving";
								showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SAVE_ALL_RECORD_BEFORE_APPROOVE')); 
							}
				         }
				      }
				   }
},

            'learningtargetsgrid numberfield':{
            	change: function(){
            		this.validateReviewForm();
            	},
            	focus: function(){
            		this.validateReviewForm();
            	},
            	blur: function(){
            		this.validateReviewForm();
            	}
            },

             'learningtargetscoregrid numberfield':{ 
            	change: function(){
            		this.validateReviewFormNew();
            	},
            	focus: function(){
            		this.validateReviewFormNew();
            	},
            	blur: function(){
            		this.validateReviewFormNew();
            	}
            }
        });
    },

    clearDependentFields: function(dependentFields) {  
        var me = this;
        Ext.each(dependentFields, function(currentField){
        	if(currentField.reset){
            	currentField.reset();
        	}
        	
        	if(currentField.clearValue){
            	currentField.clearValue();
        	}
        	
        	currentField.setDisabled(true);
        });
    },
    
    enableDisableDependentField: function(currentFieldValue, dependentField) {
    	var me = this;
    	
    	if(isNullOrEmpty(currentFieldValue)){
    		dependentField.setDisabled(true);
    	}
    	else{
    		dependentField.setDisabled(false);
    	}
    },
    
    resetExtraParamsAndLoad: function(dependentField, newExtraParams, callbackFunction) {
    	var me = this;
    	var dependentFieldStore = dependentField.getStore();
    	
    	dependentFieldStore.getProxy().extraParams=newExtraParams;
    	if(!dependentField.isDisabled()){
        	dependentFieldStore.load({
        		callback: callbackFunction
        	});
    	}
    },
    
    getSelectedRecordFromCombo: function(field){
    	if(!isNullOrEmpty(field.getValue())){
        	return field.findRecord(field.valueField,field.getValue());
    	}
    	else{
    		return {
    			raw: {},
    			data: {}
    		};
    	}
    },
    
    validateReviewForm: function(form){
    	var me = this;
    	var filterForm = this.getLearningtargetsfilter();
    	var learningTargetGrid = this.getLearningtargetsgrid();
    	var reviewForm = this.getLearningtargetsreviewform();
    	
    	var learningTargetSaveButton = reviewForm.down('#learningTargetSaveButtonId');
    	var gridSelection = learningTargetGrid.getSelectionModel().getSelection();
    	
    	var buttonDisabled = true;
    	
    	if(gridSelection.length){
    		var isAllRecordFilled = me.isGridRecordFilled(gridSelection);
    		if(isAllRecordFilled){
    			if(filterForm.isValid()){
        			if(reviewForm.isValid()){
        				buttonDisabled = false;
            		}
            		else{
            			buttonDisabled = true;
            			reviewForm.getForm().clearInvalid();
            		}
        		}
        		else{
        			buttonDisabled = true;
        			filterForm.getForm().clearInvalid();
        		}
    		}
    		else{
    			buttonDisabled = true;
    		}
    	}
    	else{ 
    		buttonDisabled = true;
    	}
    	
    	learningTargetSaveButton.setDisabled(buttonDisabled);
      
    },

       validateReviewFormNew: function(form){
    	var me = this;
    	var filterForm = this.getLearningtargetsCorefilter();
    	var learningTargetGrid = this.getLearningtargetscoregrid();
    	var reviewForm = this.getLearningtargetsreviewcoreform();
		    	

    	var learningTargetSaveButton = reviewForm.down('#learningTargetSaveButtonId');
		var apporvetargetBtn=reviewForm.down('#learningTargetApproveButtonId');
    	

    	var gridSelection = learningTargetGrid.getSelectionModel().getSelection();
    	
    	var buttonDisabled = true;
    	
    	if(gridSelection.length){
    		var isAllRecordFilled = me.isGridRecordFilled(gridSelection);
    		if(isAllRecordFilled){
    			if(filterForm.isValid()){
        			if(reviewForm.isValid()){
        				buttonDisabled = false;
            		}
            		else{
            			buttonDisabled = true;
            			reviewForm.getForm().clearInvalid();
            		}
        		}
        		else{
        			buttonDisabled = true;
        			filterForm.getForm().clearInvalid();
        		}
    		}
    		else{
    			buttonDisabled = true;
    		}
    	}
    	else{
    		buttonDisabled = true; 
    	}
    	
    	learningTargetSaveButton.setDisabled(buttonDisabled);
		apporvetargetBtn.setDisabled(buttonDisabled); 
    },
    
    isGridRecordFilled: function(selectedRecord){
    	var allFilled = true;
    	Ext.each(selectedRecord, function(currentRecord){
    		if(isNullOrEmpty(currentRecord.data.finalResult) || isNullOrEmpty(currentRecord.data.subjectTarget)){
    			allFilled = false;
    		}
    	});
    	return allFilled;
    },
       
	isGridRecordFilledCore: function(selectedRecord){
    	var allFilled = true;
    	Ext.each(selectedRecord, function(currentRecord){
    		if(isNullOrEmpty(currentRecord.data.learningTargetDetailsId)){
    			allFilled = false;
    		}
    	});
    	return allFilled;
    },

	saveLearningTarget: function(btn){
		var me = this;
		
		if(btn.up('learningtargetstructure')){
	    	var filterForm = this.getLearningtargetsfilter();
	    	var learningTargetGrid = this.getLearningtargetsgrid();
	    	var reviewForm = this.getLearningtargetsreviewform();
	    	
	    	var reviewDate = reviewForm.down('#reviewDate').getValue();
	    	var nextReviewDate = reviewForm.down('#nextReviewDate').getValue();
		}
		else{
	    	var filterForm = this.getLearningtargetsCorefilter();
	    	var learningTargetGrid = this.getLearningtargetscoregrid();
	    	var reviewForm = this.getLearningtargetsreviewcoreform(); 
	    	
	    	var reviewDate = reviewForm.down('#reviewDate1').getValue();
	    	var nextReviewDate = reviewForm.down('#nextReviewDate1').getValue();
		}
    		
    	if(!isNullOrEmpty(nextReviewDate) && nextReviewDate <= reviewDate){
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NEXT_REVIEW_DATE_ERROR')); 
    		   return false;
    	}
    	else{
    		var evaluationTypeField = filterForm.down('#evaluationTypeItemId');
    		var programField = filterForm.down('#programIdItemId');
    		var batchField = filterForm.down('#batchIdItemId');
    		var courseField = filterForm.down('#courseItemId');
    		var courseVarientField = filterForm.down('#courseVariantItemId');
    		var evalautionPlanField = filterForm.down('#evalautionPlanItemId');
    		var evalPlanLevelField = filterForm.down('#evalPlanLevelItemId');
    		var periodField = filterForm.down('#periodItemId');
			var principalComment = (Ext.isDefined(reviewForm.down('#principalComment')) && !isNullOrEmpty(reviewForm.down('#principalComment'))) ? reviewForm.down('#principalComment').getValue() : "";
        	var teacherComment = reviewForm.down('#teacherComment').getValue();
        	
    		var gridSelection = learningTargetGrid.getSelectionModel().getSelection();
    		
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			var	submitUrl=SERVERURL.PATH_SAVE_LEARNING_TARGETS_GRID_DATA;
			
			var WSLearningTargetDetailModel = [];
			Ext.each(gridSelection, function(currentRecord){
				WSLearningTargetDetailModel.push({
					admissionId:currentRecord.raw.admissionId,
					finalResult:currentRecord.get('finalResult'),
					subjectTarget:currentRecord.get('subjectTarget'),
					id: currentRecord.get('learningTargetDetailsId')
				});
			});
			
			var evalPlanLevelRecord = me.getSelectedRecordFromCombo(filterForm.down('#evalPlanLevelItemId'));
			    					
			var submitValue = {
					id: gridSelection[0].raw.learningTargetId,
					levelId: evalPlanLevelRecord.get('levelId'),
					periodId: periodField.getValue(),
					reviewDate: reviewDate,
					nextReviewDate: nextReviewDate,
					academicType: evaluationTypeField.getValue(),
					courseVariantId: courseVarientField.getValue(),
					evaluationPlanId: evalautionPlanField.getValue(),
					facultyComment: teacherComment,
					evaluationTypeCode: evalPlanLevelRecord.get('code'),
					wsLearningTargetDetailModelList: WSLearningTargetDetailModel,
					principalComment: principalComment
			};
			
  			Ext.Ajax.request({
				type : 'rest',
				url : submitUrl,
				jsonData : Ext.encode(submitValue),
				method : 'POST',
				success : function(form, action) {
					 Ext.getBody().unmask();
					showSuccessMessage(getCommonTranslation('LEARNING_TARGETS'),
							getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
					learningTargetGrid.getStore().removeAll();
					learningTargetGrid.getStore().load({
            			scope:this,
            			callback: function (records, operation, success) {
            				if(success){
            					var sm = learningTargetGrid.getSelectionModel();
            					Ext.each(records, function(record) {
            						if(record.data.isSelected){
            							var row = record.index;
            							sm.select(row, true);
            						}
            					});
            					
            					var teacherComment = records[0].raw.facultyComment;
            					var reviewDate = records[0].raw.reviewDate;
            					var nextReviewDate = records[0].raw.nextReviewDate;

            					reviewForm.down('#reviewDate').setMinValue(false);
            					reviewForm.down('#nextReviewDate').setMinValue(false);
            					reviewForm.down('#reviewDate').setMaxValue(false);
            					reviewForm.down('#nextReviewDate').setMaxValue(false);
            					
            					if(!isNullOrEmpty(reviewDate)){
            						reviewForm.down('#reviewDate').setValue(reviewDate);
            					}
            					else{
            						reviewForm.down('#reviewDate').setValue(new Date());
            					}
            					
            					if(!isNullOrEmpty(nextReviewDate)){
            						reviewForm.down('#nextReviewDate').setValue(nextReviewDate);
            					}
            					
            					if(!isNullOrEmpty(teacherComment)){
            						reviewForm.down('#teacherComment').setValue(teacherComment);
            					}
            				}
            			}
            		});
				}
  			});
    	}
	}
});
