/**
 *@author Vishal Joshi 
 *@author Amit.Gupta
 * 
 */
Ext.define('Academia.controller.placement.placementtype.PlacementTypeController', {
	extend: 'Academia.controller.base.BaseController',
	models : ['placement.placementtype.PlacementTypeModel'],
	stores : ['placement.placementtype.PlacementTypeGridStore','placement.PlacementTypeStore','examinationcenters.evaluation.evaluationPlanHeirarchy.GradeAndMarkData'],
	views : ['placement.placementtype.PlacementTypeStructure','placement.placementtype.PlacementTypeFilter',
	         'placement.placementtype.PlacementTypeGrid','placement.placementtype.PlacementTypeWin','placement.placementtype.PlacementTypeTabStructure'],
	         config: {
  	        	PLACEMENT_TYPE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PLACEMENT_TYPE_PRIVILEGES'),
  	        },	         
	         refs : [
	                 {
	                	 ref : 'placementtypestructure',
	                	 selector : 'placementtypestructure'
	                 },{
	                	 ref : 'placementtypefilter',
	                	 selector : 'placementtypefilter'
	                 },{
	                	 ref: 'placementtypegrid',
	                	 selector: 'placementtypegrid'
	                 },{
	                	 ref: 'contentPanel',
	                	 selector: 'contentPanel'
	                 },{
	                	 ref: 'placementTypeWin',
	                	 selector: 'placementtypewin'
	                 }],
	                 init : function() {
	                	 this.control({
	                		 'placementtypefilter button[itemId=searchBtn]': {
	                			 click: this.loadPlacementTypeGrid
	                		 },
	                		 'placementtypefilter button[itemId=resetBtn]': {
	                			 click: this.resetPlacementTypeFilter
	                		 },
	                		 'placementtypegrid': {
	                			 render: function(grid) {
	                				 this.doAccessControlValidation(grid, this.getPLACEMENT_TYPE_PERMISSIONS());
	                			 }
	                		 },
	                		 'placementtypegrid button[itemId=btnAdd]': {
	                			 click:this.showPlacementTypeWindow
	                		 },
	                		 'placementtypegrid button[itemId=btnEdit]': {
	                			 click : this.editPlacementTypeForm
	                		 },
	               		  'placementtypegrid button[itemId=btnView]': {
	            			  click: function() {
	            				  
	            				  this.viewPlacementWindow(grid);
	            			  }
	               		  	},
	                		 'placementtypewin button[itemId=SubmitBtn]':{
	                			 click:this.saveAddPlacementTypeWin
	                		 },
	                		 'placementtypewin button[itemId=CancelBtn]':{
	                			 click:this.closePlacementTypeWin
	                		 },
	                		 'placementtypegrid button[itemId=btnDelete]':{
	                			 click: this.deletePlacementTypeRecord
	                		 },
	                		 'placementtypewin radiogroup[itemId=whetherGradedItemId]':{
	                        	 change:function(value,newValue,oldValue){
	                         		// var droolAgendaField = Ext.ComponentQuery.query('combo#droolsItemId')[0];
	                         		 var form = this.getPlacementTypeWin();
	                         		 var gradeOrMarkField=form.down('#gradeOrMark');
	                         		var considerforRankingField=form.down('#considerforRanking');
	                         		var showinMarksheetField=form.down('#showinMarksheet');
	                         		
	                         		
	                         		 if(newValue.whetherGraded==true){
	                         			gradeOrMarkField.setDisabled(false);
	                         			considerforRankingField.setDisabled(false);
	                         			showinMarksheetField.setDisabled(false);
	                         		 }else{
	                         			 gradeOrMarkField.reset();
	                         			considerforRankingField.reset();
	                         			showinMarksheetField.reset();
	                         			gradeOrMarkField.setDisabled(true);
	                         			considerforRankingField.setDisabled(true);
	                         			showinMarksheetField.setDisabled(true);
	                         		 }
	                         	 }
	                          },

	                	 });
	                 },

	                 loadPlacementTypeGrid:function(){
	                	 var $this=this;
	                	 var grid = $this.getPlacementtypegrid();
	                	 var form = $this.getPlacementtypefilter().getForm();
	                	 var formValues = form.getValues();
	                	 grid.getStore().getProxy().extraParams = {
	                		 placementTypeId:formValues.placementtype
	               	     };
	                	 grid.getStore().load();
	                	 /*pdf & excel report header filter*/
	                 	 grid.config.searchFilterForm = $this.getPlacementtypefilter();
	                 },
	                 viewPlacementWindow: function(grid) {
	                	 this.editPlacementTypeForm(grid, true);
	                	 var win = this.getPlacementTypeWin();
	                	 var form = win.down('form').getForm();
	                	 this.toggleReadOnlyFormItems(form,true);
	                	 win.down('#SubmitBtn').setVisible(false);
	                 },	        
	                 showPlacementTypeWindow:function(){
	                	 var formWindow = this.getPlacementTypeWin();
	                	 if (!formWindow) {
	                		 Ext.widget('placementtypewin');
	                		 formWindow = this.getPlacementTypeWin();
	                	 }
	                	 formWindow.show();
	                 },
	                 closePlacementTypeWin : function(){
	                	 this.getPlacementTypeWin().close();
	                 },

	                 saveAddPlacementTypeWin : function(){
	                	 var $this = this;
	                	 var placementtypewin = $this.getPlacementTypeWin();
	                	 var grid = $this.getPlacementtypegrid();
	                	 var form = placementtypewin.down('form').getForm();
	                	 var value = form.getValues();
	                	 var placementtypemodel = new Academia.model.placement.placementtype.PlacementTypeModel();

	                	 placementtypemodel.set("placementType",value.placementType);
	                	 placementtypemodel.set("whetherCompletion",value.whetherCompletion);
	                	 placementtypemodel.set("placementTerm",value.placementTerm);
	                	 placementtypemodel.set("whetherGraded",value.whetherGraded);
	                	 placementtypemodel.set("gradeOrMark",value.gradeOrMark);
	                	 placementtypemodel.set("whetherConsiderForRanking",value.whetherConsiderForRanking);
	                	 placementtypemodel.set("whetherShowInMarksheet",value.whetherShowInMarksheet);
	                	 placementtypemodel.set("whetherMandatory",value.whetherMandatory);


	                	 var submitUrl;
	                	 var message;
	                	 if (form.findField('id').getSubmitValue() == null
	                			 || form.findField('id').getSubmitValue() == "") {
	                		 submitUrl = SERVERURL.PLACEMENT_TYPE_CREATE;
	                		 message = getPlacementTranslation('PLACEMENT_TYPE_CREATED_SUCCESSFULLY');
	                	 } else {
	                		 placementtypemodel.set("id",value.id);
	                		 submitUrl = SERVERURL.PLACEMENT_TYPE_UPDATE;
	                		 message = getPlacementTranslation('PLACEMENT_TYPE_UPDATED_SUCCESSFULLY');
	                	 }

	                	 var submitData = Ext.encode(placementtypemodel.data);
	                	 $this.applyWindowMask(); 
	                	 Ext.Ajax.request({
	                		 type : 'rest',
	                		 url : submitUrl,
	                		 jsonData : submitData,
	                		 method : 'POST',
	                		 success : function(response, action) {
	                			 $this.hideWindowMask();
	                			 grid.getSelectionModel().deselectAll();
	                			 grid.getStore().reload(); 
	                			 $this.closePlacementTypeWin();
	                			 showSuccessMessage(getPlacementTranslation('PLACEMENT_TYPE'), message);
	                		 }
	                	 });
	                 },

	                 //************* edit Placement details records********************
	                 editPlacementTypeForm:function(){
	                	 var $this = this;
	                	 var grid = $this.getPlacementtypegrid();

	                	 if (grid.getSelectionModel().getCount() > 0) {
	                		 this.showPlacementTypeWindow();
	                		 var form = $this.getPlacementTypeWin().down('form');
	                		 var record = grid.getSelectionModel().getSelection()[0];
	                		 var id = record.get("id");
	                		 var editUrl = SERVERURL.PLACEMENT_TYPE_FINDBYID;
	                		 Ext.Ajax.request({
	                			 method: "GET",
	                			 type: 'rest',
	                			 url: editUrl,
	                			 params: {
	                				 id: id
	                			 },
	                			 success: function(f, action) {
	                				 var data = Ext.JSON.decode(f.responseText);
	                				 var dataModel = new Academia.model.placement.placementtype.PlacementTypeModel(data);
	                				 console.log(dataModel);
	                				 form.loadRecord(dataModel);
	                				 form.down('#gradeOrMark').getStore().load({
	                					 callback:function(record){
	                						 for(var i in record){
	                							 if(record[i].data.id==dataModel.data.gradeOrMark){
	                								 form.down('#gradeOrMark').setValue(record[i].data.id);
	                							 }
	                						 }
	                					 }
	                				 });
	                				 var whetherGraded = form.down('#whetherGradedItemId');
	                				 var whetherGraded = form.down('#whetherGraded');
	                				 var considerforRanking = form.down('#considerforRanking');
	                				 var ShowInMarksheet = form.down('#showinMarksheet');

	                				 if(dataModel.get('whetherGraded')){
	                					 whetherGraded.items.items[0].setValue(true);
	                					 whetherGraded.items.items[1].setValue(false);
	                				 }else{
	                					 whetherGraded.items.items[1].setValue(true);
	                					 whetherGraded.items.items[0].setValue(false);
	                				 }

	                				 if(dataModel.get('whetherConsiderForRanking')){
	                					 considerforRanking.items.items[0].setValue(true);
	                					 considerforRanking.items.items[1].setValue(false);
	                				 }else{
	                					 considerforRanking.items.items[0].setValue(false);
	                					 considerforRanking.items.items[1].setValue(true);
	                					 considerforRanking.items.items[0].setValue(false);
	                				 }
	                				 if(dataModel.get('whetherGraded')){
	                					 whetherGraded.items.items[0].setValue(true);
	                					 whetherGraded.items.items[1].setValue(false);
	                				 }else{
	                					 whetherGraded.items.items[0].setValue(false);
	                					 whetherGraded.items.items[1].setValue(true);
	                				 }

	                				 if(dataModel.get('whetherShowInMarksheet')){
	                					 ShowInMarksheet.items.items[0].setValue(true);
	                					 ShowInMarksheet.items.items[1].setValue(false);
	                				 }else{
	                					 ShowInMarksheet.items.items[0].setValue(false);
	                					 ShowInMarksheet.items.items[1].setValue(true);
	                				 }

//	                				 holidayCheckId.items.items[0].setValue(true);
//	                				 holidayCheckId.items.items[1].setValue(false);

	                			 }
	                		 });
	                	 }else{
	                		 showWarningMessage(getPlacementTranslation('PLACEMENT_TYPE'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	                	 }
	                 },
	                 resetPlacementTypeFilter:function(){
	                	 var $this=this;
	                	 var filter = $this.getPlacementtypefilter().getForm();
	                	 filter.reset();
	                 },

	                 deletePlacementTypeRecord:function(){
	                	 var $this=this;
	                	 var grid = $this.getPlacementtypegrid();
	                	 if (grid.getSelectionModel().getCount() > 0) {
	                		 showConfirmMessage(getCommonTranslation('PLACEMENT_TYPE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	                			 if (btn == 'yes') {
	                				 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                				 var records = grid.getSelectionModel().getSelection();
	                				 var id = records[0].get("id");
	                				 Ext.Ajax.request({
	                					 method : "DELETE",
	                					 type : 'rest',
	                					 url : SERVERURL.PLACEMENT_TYPE_DELETE+'?id='+ id,
	                					 headers : {
	                						 'Content-Type' : 'application/json'
	                					 },
	                					 success : function(form,action) {
	                						 Ext.getBody().unmask();
	                						 grid.getStore().reload();
	                						 showSuccessMessage(getCommonTranslation('PLACEMENT_TYPE'),getCommonTranslation('PATH_PLACEMENT_TYPE_SUCCESS_MSG'));
	                					 }

	                				 });
	                			 }
	                		 });
	                	 }else {
	                		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                	 }
	                 }
});
