/**
 * @author Rajkumar.Patidar
 */
Ext.define('Academia.controller.portal.ParentPortalController', {
	extend: 'Academia.controller.base.BaseController',
	views: ['studentPortal.PersonInfoStudentPortal','login.ChangeStudentWindow'],
	refs: [{
		ref: 'contentPanel',
		selector: 'contentpanel'
	},{
		ref: 'personInfoStudentPortal',
		selector: 'personinfostudentportal'
	},{
		ref: 'changeStudentWindow',
		selector: 'changestudentwindow'
	}, {
		ref: 'stcpncstudentregistration',
		selector: 'stcpncstudentregistration'
	}],
	config: {
	   	 PARENT_PORTAL_COURSE_REGISTRATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_COURSE_REGISTRATION_PRIVILEGES'),
    },
	init: function(application) {
		this.control({
			'personinfostudentportal, stcpncstudentregistration': {
				afterrender: this.getPersonInfoStudentPortalRender 
			},
			'changestudentwindow button#cancelBtn':{
				click: function(button){
					var changestudentwindow=button.up('changestudentwindow');
					if(Ext.isDefined(changestudentwindow))
					changestudentwindow.close();
				}
			},
		'changestudentwindow':{
			render:function(changestudentwindow){
				   this.addStudentImagesField(changestudentwindow);
				   this.getStudentDetailByParent();
		        }
	        },
	        'stcpncstudentregistration tabpanel[itemId=stcPncStudentRegistration]':{
	           	 afterrender: function(tabpanel){
	           		 var me = this;
	           		 var permissionsMap = me.getPARENT_PORTAL_COURSE_REGISTRATION_PERMISSIONS()
	           		 var associatedAcadLocationIds = new Array();
	               	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	               	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	       
	               	if (permissionList.includes('PAYMENT_DETAILS')) {
	               		tabpanel.add({
	            			xtype: 'studentpaymentdetialsregistrationstructure',
	            			itemId :'studentpaymentdetialsregistrationstructureItemId',
	            			title: getCommonTranslation('PNC_PAYMENT_DETAILS'),
	            			disabled:true
	            		});
	               	 }
	           	 }
	          }
		});
	},
	/**
	 * @author Rajkumar.patidar
	 */
	getPersonInfoStudentPortalRender : function(tb){
		if(!tb.items.length || tb.xtype === "stcpncstudentregistration"){
		var $this=this;
		var programBatchSeatTypeConfigId=0;
		//var userInfo = Academia.model.authentication.UserInfoModel;
		
		var portalInfo = Academia.model.authentication.PortalInfoModel;
		var student = portalInfo.get('student');
		var personId = student.person.id;
		var userId = student.id
		
		$this.applyConfigToPersonTab(tb);
		if(tb.contentXtype=='feeplangrid'){
			 programBatchSeatTypeConfigId  = $this.getProgramBatchSeatTypeConfig();
		}
		try{
			var personInfo = contentPanel.getPersonInfo();
			}
			catch(ee){
			var contentPanel = $this.getContentPanel();
			var personInfo = contentPanel.getPersonInfo();
			}
		tb.setPersonInfo(personInfo);
		tb.setUserId(userId);
		tb.setPersonId(personId);
		tb.setAdmissionId(null);
		tb.setProgramBatchSeatTypeConfigId(programBatchSeatTypeConfigId);
		tb.insert(0,{
			xtype: tb.contentXtype,
			itemId: tb.contentXtypeItemId,
			personType:'STUDENT'
		});
		var that = this;
		setTimeout(function(){
			var contentPanel = that.getContentPanel(); //get hold of the content panel where we are adding all the tabs
			contentPanel.items.findBy(function(tab) {
				if(tab!=undefined){
					if(tab.title == 'Portal'){
						contentPanel.remove(tab,true);
					}
				}
			});
		}, 20);

		tb.items.items[0].setTitle(false);
		tb.items.items[0].closable=false;
		
		if(tb.items.items[0].viewType=='gridview'){
			tb.items.items[0].setTitle(tb.title);
		}
		}
	},
	getloggedInStudentDetails : function(){
		var this$ = this;
//		var userInfo = Academia.model.authentication.UserInfoModel;
		
		var portalInfo = Academia.model.authentication.PortalInfoModel;
		var student = portalInfo.get('student');
		var personId = student.person.id;
		var userId = student.id
		localStorage.setItem('studentNameWithParentName',student.printName);
		var studentProfile = this$.getContentPanel();
		Ext.apply(studentProfile, {
			personInfo: null,
			setPersonInfo: function(personInfo) {
				studentProfile.personInfo = personInfo;
			},
			getPersonInfo: function() {
				return studentProfile.personInfo;
			}
		});
		//var userId = userInfo.get("userId");
		if (!isNullOrEmpty(userId)) {
			Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			var studentProfileUrl = SERVERURL.STUDENT_PERSONAL_INFORMATION_BY_ID + userId;
			Ext.Ajax.request({
				type: 'rest',
				url: studentProfileUrl,
				method: 'GET',
				success: function(res, action) {
					Ext.getBody().unmask();
					var data = Ext.decode(res.responseText);
					if(!isEmpty(data)){
						studentProfile.setPersonInfo(data.person);
					}
				},
				failure: function(res, action) {
					Ext.getBody().unmask();
				}
			});
		}
	},
	getProgramBatchSeatTypeConfig : function(){
		var portalInfo = Academia.model.authentication.PortalInfoModel;
        var admissionDetails = portalInfo.get('admissionDetails')[0];
        var batchId = admissionDetails.batch.id;
		Ext.Ajax.request({
			type: 'rest',
			async: false,
			url: SERVERURL.FIND_PROGRAMBATCHSEATCONFIG_BY_BATCH_ID+'?batchId='+batchId,
			method: 'GET',
			success: function(res, action) {
				var jsonData = Ext.decode(res.responseText);
				var myArray=[];
				for(var i in jsonData){
					myArray.push(jsonData[i].id);
				}
				programBatchSeatTypeConfigId = myArray.join();
			}
		});
		return programBatchSeatTypeConfigId;
	},
	getLoadStudentDetail : function(){
		$this = this;
		var userInfo = Academia.model.authentication.UserInfoModel;
		var userIdLocalStorage = localStorage.getItem('userId');
		
		var personIdLocalStorage = localStorage.getItem('personId');
		if(!isNullOrEmpty(personIdLocalStorage)){
			userInfo.set('personId',personIdLocalStorage);
		}
		
		if(!isNullOrEmpty(userIdLocalStorage))
		{
			userInfo.set("userId",userIdLocalStorage);
		}	
		var userId = userInfo.get("userId");
		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
		Ext.Ajax.request({
			type: 'rest',
			url:SERVERURL.FIND_PARENT_PERSON_ID+'?userId='+userId,
			method: 'GET',
			async: false,
			success: function(res, action) {
				var personId = Ext.decode(res.responseText);

				Ext.Ajax.request({
					type: 'rest',
					url:SERVERURL.FIND_ASSOCIATED_STUDENTS+'?personId='+personId,
					method: 'GET',
					async: false,
					success: function(res, action) {
						var responseData = Ext.decode(res.responseText);
						var studentDetail = responseData[0];
						var getStudentFirstSiblingPersonId = localStorage.getItem('studentFirstSiblingPersonId');
						if(isNullOrEmpty(getStudentFirstSiblingPersonId)){
							localStorage.setItem('studentFirstSiblingPersonId',studentDetail.person.id);
						}
						
						var loggedInParentPersonId = localStorage.getItem('loggedInParentPersonId');
						if(isNullOrEmpty(loggedInParentPersonId)){
							localStorage.setItem('loggedInParentPersonId',personId);
						}
						
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.BATCH_ID_BY_STUDENT_ID+'?studentId='+studentDetail.id,
							method: 'GET',
							async: false,
							success: function(res, action) {
								var data = Ext.decode(res.responseText);
								var portalInfo = Academia.model.authentication.PortalInfoModel;
								portalInfo.set('admissionDetails',data[0].admissionDetails);
								portalInfo.set('student',data[0].student);
								portalInfo.set('userAacademyLocations',data[0].userAacademyLocations);
								portalInfo.set('programBatchDetails',data[0].programBatchDetails);
								portalInfo.set('pastProgramBatchDetails',data[0].pastProgramBatchDetails);
								try{
									if(portalId==7){
										if(!isNullOrEmpty(userInfo.data.userId)){
											localStorage.setItem('parentUserId',userInfo.data.userId);	
										}
										userInfo.set('personId',data[0].student.person.id);
										userInfo.set("userId",data[0].student.id);// it's necessary for parent portal
									}
								}
								catch(e){

								} 
								if($this.getChangeStudentWindow()!=undefined){
									showSuccessMessage(getCommonTranslation('CHANGE_STUDENT'), getCommonTranslation('STUDENT_CHANGE_SUCCESS_MESSAGE'));
									 $this.getChangeStudentWindow().close();
								}
							}
						});
					}
				});
			}
		});
	},
	applyConfigToPersonTab : function(newTab){

		Ext.apply(newTab,{
			personId: null,
			userId: null,
			admissionId: null,
			personInfo: {},
			setPersonId: function(personId) {
				newTab.personId = personId;
			},
			getPersonId: function() {
				return newTab.personId;
			},
			setUserId: function(userId) {
				newTab.userId = userId;
			},
			getUserId: function() {
				return newTab.userId;
			},
			setPersonInfo: function(personInfo) {
				newTab.personInfo = personInfo;
			},
			getPersonInfo: function() {
				return newTab.personInfo;
			},
			setAdmissionId: function(admissionId) {
				newTab.admissionId = admissionId;
			},
			getAdmissionId: function() {
				return newTab.admissionId;
			},
			setProgramBatchSeatTypeConfigId: function(programBatchSeatTypeConfigId) {
				newTab.programBatchSeatTypeConfigId = programBatchSeatTypeConfigId;
			},
			getProgramBatchSeatTypeConfigId: function() {
				return newTab.programBatchSeatTypeConfigId;
			}
		});
	},
	addStudentImagesField:function(obj) {
 	   var $this = this;
	   var panelItem = new Array();
	   var fieldContainer=obj.up('fieldcontainer');
	   var newcont=obj.items.items.length;
	   var insertPosition=newcont+1;
	   panelItem.push({
	    	xtype: 'form',
	    	itemId: 'changeStudentForm',
	    	standardSubmit: false,
	    	plugins: "formlabelrequired",
    		autoScroll:true,
	    	defaults: {
	    		labelAlign: 'top'
	    	},
	    	items: [{
	    		xtype : 'fieldset',
	    		itemId:'selectPortalForm',
	    		style: {
	    				background:'#ffffff', 
	    				border:'1px solid #D1D1D1', 
	    				display: 'table',
	    				top : '0px'
	    		},
	    		width: 'auto',
	    		height: 'auto',
	    		defaults:{
	    			labelAlign: 'top'
	    		},
	    		standardSubmit: false,
	    		items : [ {
	    			xtype: 'fieldcontainer',
	    			itemId:'innerImageItem',
	    			layout: 'hbox',
	    			defaults: {
	    				width: 112,
	    				height:140,
	    				labelAlign: 'top',
	    				margin:'5px',
	    				cls:'innerParentImageBox'
	    			}
	    		},{
    				xtype: 'button',
    				itemId: 'cancelBtn',
    				text: getCommonTranslation('CANCEL'),
    				ui: 'CustomBtnCancel',
    				style:{width:'100% !important'},
    				scale: 'medium'	

    			}]
	    	}]
	    });
	   obj.insert(insertPosition,panelItem);
	   obj.doLayout();
   },
   getStudentDetailByParent : function(){
	   $this= this;
		var userInfo = Academia.model.authentication.UserInfoModel;
		var userId = userInfo.get("userId");
		
		var personIdLocalStorage = localStorage.getItem('personId');
			if(!isNullOrEmpty(personIdLocalStorage))
			{
				userInfo.set("personId",personIdLocalStorage);
			}
		var getStudentFirstSiblingPersonId = localStorage.getItem('studentFirstSiblingPersonId');
		var personId = userInfo.get("personId");
		
		var loggedInParentPersonId = localStorage.getItem('loggedInParentPersonId');
		
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_FIND_ASSOCITED_SIBLING_DETAILS,
			params:{
				parentPersonId: loggedInParentPersonId,
				parentUserId: userId,
				studentPersonId :getStudentFirstSiblingPersonId
			 },
			method: 'GET',
			async: false,
			success: function(res, action) {
				var data = Ext.decode(res.responseText);
				var changeStudentWindow = $this.getChangeStudentWindow();
				var innerImageItem = changeStudentWindow.down('#innerImageItem');
				var panelItem = new Array();
				var newcont=innerImageItem.items.items.length;
				var insertPosition=newcont+1;
				var parentStudentIdLocalStorage = localStorage.getItem('parentStudentId');
				var isCurrentLoggedInSibling = false;
				var isCurrentLoggedDefaultInSibling = false;
				var authController = this$.getController('Academia.controller.authentication.AuthenticationController');
				for(var i = 0; i<data.length;i++) {
					isCurrentLoggedInSibling = false;
					if(!isNullOrEmpty(parentStudentIdLocalStorage)){
						if(data[i].studentId == parentStudentIdLocalStorage){
							isCurrentLoggedInSibling = true;
						}
					}else{
						if(data[i].studentId == userId){
							isCurrentLoggedInSibling = true;
						}

					}

					if(data[i].photoUrl == null){
						var newImage = {
								xtype: 'panel',
								layout: 'vbox',
								cls:'studentChangeImageBoxBorder',
								items : [{
									xtype: 'image',
									src: 'resources/images/profile_student.png',
									width: 100,
									height: 100,
									title:data[i].studentCodeAndPrintName,
									cls:'x-form-trigger',
									userId: data[i].parentUserId,
									personId: data[i].parentPersonId,
									studentId: data[i].studentId,
									academyLocationId: data[i].academyLocationIds,
									listeners: { 
										el: {
											click: function(obj) {
												if (typeof obj.lastExecutionTime === 'undefined') {
													obj.lastExecutionTime = 0;
										        }
										        var currentTime = new Date().getTime();
										        // Prevent function execution if called within the last 5+ seconds
										        if (currentTime - obj.lastExecutionTime < 5000) {
										            return false;
										        }
										        // Update last execution time
										        obj.lastExecutionTime = currentTime;
										           
												var userId = Ext.getCmp(this.id).userId;
												var personId = Ext.getCmp(this.id).personId;
												var studentId = Ext.getCmp(this.id).studentId;
												var academyLocationId = Ext.getCmp(this.id).academyLocationId;
												localStorage.setItem('userId',userId);
												localStorage.setItem('personId',personId);
												localStorage.setItem('parentStudentId',studentId);
												localStorage.setItem('studentAL',academyLocationId);
												localStorage.setItem('IsChangeStudent',true);
												authController.directLoginWithoutReload();
												$this.getLoadStudentDetail();
											} 
										} 
									}
								},{
									xtype: 'label',
									html: data[i].studentCodeAndPrintName,
									cls: 'changeStudentLabelNameCLS',
									listeners: { 
									afterrender:function(value,rec){
										if(!isNullOrEmpty(value.el.dom.innerHTML)){
											value.el.dom.setAttribute('data-qtip',value.el.dom.innerHTML);
											value.el.dom.style.textAlign = 'left';
											value.el.dom.style.overflow = 'hidden'; 
											value.el.dom.style.display = '-webkit-box';
											value.el.dom.style.webkitBoxOrient='vertical';
											value.el.dom.style.webkitLineClamp='2';
										}
										return value.el.dom.innerHTML;
								    }
									}
								}]
						};
					}else{
						if(data[i].isExternalPhotoUrl == true){
							var photoURL = data[i].photoUrl
						}else{
							var photoURL = 'resources/images/uploads'+data[i].photoUrl
						}
						var newImage = {
								xtype: 'panel',
								layout: 'vbox',
								cls:'studentChangeImageBoxBorder',
								items : [{
									xtype: 'image',
									src: photoURL,
									width: 100,
									height: 100,
									cls:'x-form-trigger',
									title:data[i].studentCodeAndPrintName,
									userId: data[i].parentUserId,
									personId: data[i].parentPersonId,
									studentId: data[i].studentId,
									academyLocationId: data[i].academyLocationIds,
									listeners: { 
										el: {
											click: function(obj) {
												if (typeof obj.lastExecutionTime === 'undefined') {
													obj.lastExecutionTime = 0;
										        }
										        var currentTime = new Date().getTime();
										        // Prevent function execution if called within the last 5+ seconds
										        if (currentTime - obj.lastExecutionTime < 5000) {
										            return false;
										        }
										        // Update last execution time
										        obj.lastExecutionTime = currentTime;
												
												var userId = Ext.getCmp(this.id).userId;
												var personId = Ext.getCmp(this.id).personId;
												var studentId = Ext.getCmp(this.id).studentId;
												var academyLocationId = Ext.getCmp(this.id).academyLocationId;
												localStorage.setItem('userId',userId);
												localStorage.setItem('personId',personId);
												localStorage.setItem('parentStudentId',studentId);
												localStorage.setItem('studentAL',academyLocationId);
												localStorage.setItem('IsChangeStudent',true);
												authController.directLoginWithoutReload();
												$this.getLoadStudentDetail();
											} 
										} 
									}
								},{
									xtype: 'label',
									html: data[i].studentCodeAndPrintName,
									cls: 'changeStudentLabelNameCLS',
									listeners: { 
										afterrender:function(value,rec){
											if(!isNullOrEmpty(value.el.dom.innerHTML)){
												value.el.dom.setAttribute('data-qtip',value.el.dom.innerHTML);
												value.el.dom.style.textAlign = 'left';
												value.el.dom.style.overflow = 'hidden'; 
												value.el.dom.style.display = '-webkit-box';
												value.el.dom.style.webkitBoxOrient='vertical';
												value.el.dom.style.webkitLineClamp='2';
											}
											return value.el.dom.innerHTML;
									    }
										}
								}]
						};
					}

					if(isCurrentLoggedInSibling){
						newImage.cls = 'x-form-trigger loggedinchangestudent innerParentImageBox';
					}

					innerImageItem.add(newImage);
				}
				/*if(data.length>3){
					innerImageItem.addCls('scrollParentImageBox');
				}*/
				innerImageItem.insert(insertPosition,panelItem);
				innerImageItem.doLayout();
			}
	   });
   },
	setStudentDetailByParent : function(studentId){
		$this= this;
		var userInfo = Academia.model.authentication.UserInfoModel;
		var userId = userInfo.get("userId");
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.BATCH_ID_BY_STUDENT_ID+'?studentId='+studentId,
			method: 'GET',
			async: false,
			success: function(res, action) {
				var data = Ext.decode(res.responseText);
				var portalInfo = Academia.model.authentication.PortalInfoModel;
				portalInfo.set('admissionDetails',data[0].admissionDetails);
				portalInfo.set('student',data[0].student);
				portalInfo.set('userAacademyLocations',data[0].userAacademyLocations);
				portalInfo.set('programBatchDetails',data[0].programBatchDetails);
				showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('STUDENT_CHANGE_SUCCESS_MESSAGE'));
                 
                 /*me.loadPortal(me);
                 me.initializeAcademyLocationAndOrganization();*/
                 //window.location.reload();
                 $this.getChangeStudentWindow().close();
			}
		});
	}
});
