Ext.define('Academia.controller.program.CourseFeeDefinitionCentersController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['program.programDetails.programBatches.courseFeeDefinition.CourseFeeDefinitionCenterStoreGrid',
		'feeandpayment.coursefeedefinition.CourseFeeSubHeadStore',
		'feeandpayment.coursefeedefinition.FeeHeadConfigurationGridStore','feeandpayment.coursefeedefinition.FeeHeadConfigurationSubHeadStore',
		'feeandpayment.coursefeedefinition.FeeHeadConfigurationCostCenterStore','feeandpayment.coursefeedefinition.FeeHeadConfigurationRefundableRuleStore',
		'feeandpayment.coursefeedefinition.FeeHeadConfigurationRuleStore','feeandpayment.coursefeedefinition.FeeHeadConfigurationDiscountRuleStore',
		'program.programDetails.programBatches.courseFeeDefinition.CFDSeatTypeMappingStore','program.programDetails.programBatches.courseFeeDefinition.MappedSeatTypeAndFeePlanGridStore'],
		models: [],
		views: [
			'program.programDetails.programBatchDetails.courseFeeDefinition.CourseFeeDefinitionCenterStructure',
			'program.programDetails.programBatchDetails.courseFeeDefinition.CourseFeeDefinitionCentersGrid',
			'program.programDetails.programBatchDetails.courseFeeDefinition.ViewCourseFeeDefinitionGrid',
			'program.programDetails.programBatchDetails.courseFeeDefinition.ViewCourseFeeDefinitionWindow',
			'program.programDetails.programBatchDetails.courseFeeDefinition.ViewCourseFeeDefinitionFilter',
			'program.programDetails.programBatchDetails.courseFeeDefinition.ManagePeriodFeeDefinitionStructure',
			'program.programDetails.programBatchDetails.courseFeeDefinition.ManageFeeHeadConfigurationFilter',
			'program.programDetails.programBatchDetails.courseFeeDefinition.ManageFeeHeadConfigurationGrid',
			'program.programDetails.programBatchDetails.courseFeeDefinition.CFDSeatTypeMappingWin',
			'program.programDetails.programBatchDetails.courseFeeDefinition.MappedSeatTypeAndFeePlanWin'
			],
			config:{
				COURSEFEEDEFINITIONCENTER_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSEFEEDEFINITIONCENTER_PRIVILEGES')
			},   	

			refs: [ {
				ref: 'contentPanel',
				selector: 'contentPanel'
			},{
				ref: 'coursefeedefinitioncenterstructure',
				selector: 'coursefeedefinitioncenterstructure'
			},{
				ref: 'coursefeedefinitioncentersgrid',
				selector: 'coursefeedefinitioncentersgrid'
			},{
				ref: 'contentPanel',
				selector: 'contentPanel'
			},{
				ref: 'programbatchdetailstabstructure',
				selector: 'programbatchdetailstabstructure'
			},{
				ref:'viewcoursefeedefinitiongrid',
				selector:'viewcoursefeedefinitiongrid'
			},{
				ref:'viewcoursefeedefinitionwindow',
				selector:'viewcoursefeedefinitionwindow'
			},{
				ref:'viewcoursefeedefinitionfilter',
				selector:'viewcoursefeedefinitionfilter'
			},{
				ref:'manageperiodfeedefinitionstructure',
				selector:'manageperiodfeedefinitionstructure'
			},{
				ref:'managefeeheadconfigurationfilter',
				selector:'managefeeheadconfigurationfilter'
			},{
				ref:'managefeeheadconfigurationgrid',
				selector:'managefeeheadconfigurationgrid'
			},{
				ref:'cfdseattypemappingwin',
				selector:'cfdseattypemappingwin'
			},{
				ref:'mappedseattypeandfeeplanwin',
				selector:'mappedseattypeandfeeplanwin'
			}
			],

			init: function(application) {
				this.control({
					'coursefeedefinitioncentersgrid':{
						afterrender:function(grid){
							var me = this;
							var permissionsMap = me.getCOURSEFEEDEFINITIONCENTER_PERMISSIONS();
							var associatedAcadLocationIds = new Array();
							associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
							var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
							//var buttonAdd = grid.down('#btnAdd'),
							btnEdit = grid.down('#btnEdit'),
							btnEnable = grid.down('#btnEnable'), 
							btnSave = grid.down('#saveBtn'),
							btnReset = grid.down('#resetGridBtn');
							seatTypeMapping = grid.down('#seatTypeMappingBtn');
							//buttonAdd.setVisible(false);
							btnEdit.setVisible(false);
							btnEnable.setVisible(false);
							seatTypeMapping.setVisible(false);

							Ext.each(permissionList, function(privilege) {
								/*if (privilege === 'CREATE') {
									if(!isNullOrEmpty(buttonAdd)){
										buttonAdd.setVisible(true);	
									}
								}
								*/
								if (privilege === 'UPDATE') {
									if(!isNullOrEmpty(btnEdit)){
										btnEdit.setVisible(true);	
									}
								} 
								if (privilege === 'ENABLE') {
									if(!isNullOrEmpty(btnEnable)){
										btnEnable.setVisible(true);	
									}
								} 
								if (privilege === 'SEAT_TYPE_MAPPING') {
									if(!isNullOrEmpty(seatTypeMapping)){
										seatTypeMapping.setVisible(true);	
									}
								} 
							});
							
							grid.getStore().on('load',function(){
								btnSave.setDisabled(true);
								btnReset.setDisabled(true);
							});
							
							grid.getStore().load();
						},
						cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){

							var columnName = View.getGridColumns()[ColIdx].dataIndex;
							if(columnName == "courseFeeDefinationName"){
								if(e.target.tagName=='A'){
									try{
										setTimeout(function(){
											View.up('grid').editingPlugin.cancelEdit();
										},100);
									}
									catch(e){}
									this.getFeeCourseSubHeadGridWindow(View,record);
								}
							}else if(columnName == "seatTypeFeePlan"){
								if(e.target.tagName=='A'){
									var mappedseattypeandfeeplanwin = this.getMappedseattypeandfeeplanwin();
									if (!mappedseattypeandfeeplanwin) {
										Ext.widget('mappedseattypeandfeeplanwin');
										mappedseattypeandfeeplanwin = this.getMappedseattypeandfeeplanwin();
									}
									mappedseattypeandfeeplanwin.show();
								}
							}
						},
						selectionchange: function(gridView, selected, eOpts){
							var me = this,
							grid = gridView.view.up('grid'),
							btnEdit = grid.down('#btnEdit'),
							btnEnable = grid.down('#btnEnable'),
							seatTypeMappingBtn = grid.down('#seatTypeMappingBtn'),
							btnSave = grid.down('#saveBtn'),
							btnReset = grid.down('#resetGridBtn'),
							enableText = getMessagingModuleTranslation('ENABLE'),
							isEnable=false, 
							isDisable=false,
							whetherEnable, 
							courseFeeDefinationId;

							if(selected.length > 0){
								Ext.each(selected, function(currentSelected){
									whetherEnable = currentSelected.get('whetherEnable');
									if(whetherEnable){
										isEnable = true;
									}
									else{
										isDisable = true;
									}
									
									courseFeeDefinationId = currentSelected.get('courseFeeDefinationId');
									if(whetherEnable===true && !isNullOrEmpty(courseFeeDefinationId)){
										enableText = getMessagingModuleTranslation('DISABLE');
									}
									if(currentSelected.data.courseFeeDefinationId === null && currentSelected.data.programBatchPeriodCourseFeeId === null  ){
										btnEdit.disable();
									}
									else{
										btnEdit.enable();
									}
									if(currentSelected.data.feePlanId && currentSelected.data.courseFeeDefinationType=="CREDIT_BASED"){
										seatTypeMappingBtn.enable();
									}
									else{
										seatTypeMappingBtn.disable();
									}
									btnSave.setDisabled(false);
									btnReset.setDisabled(false);
									btnEnable.setText(enableText);
									btnEnable.setTooltip(enableText);
								});
								if(isEnable && isDisable){
									btnEnable.setDisabled(true);
								}
								else{
									btnEnable.setDisabled(false);
								}
								if(selected.length>1){
									btnEdit.setDisabled(true);
									seatTypeMappingBtn.setDisabled(true);
									
								}
							}else{
								seatTypeMappingBtn.setDisabled(true);
							}
						}
					},
					'coursefeedefinitioncentersgrid button[itemId=seatTypeMappingBtn]':{
						click: function(button) {
							var $this=this,feePlanId,courseId,courseFeeDefinitionId,
							grid = $this.getCoursefeedefinitioncentersgrid(),
							selectedRecord = grid.getSelectionModel().getSelection()[0],
							batchStructure = $this.getProgrambatchdetailstabstructure(),
							batchCombo  = batchStructure.down('#batchId'),
							store = Ext.getStore('program.programDetails.programBatches.courseFeeDefinition.CFDSeatTypeMappingStore');
							if(selectedRecord && selectedRecord.data){
								feePlanId = selectedRecord.data.feePlanId;
								courseId = selectedRecord.data.courseId;
								courseFeeDefinitionId = selectedRecord.data.courseFeeDefinationId;
							}else{
								return showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
							store.getProxy().extraParams = {
								feePlanId: feePlanId,
								batchId:batchCombo.getValue(),
								courseId :courseId,
								courseFeeDefinitionId :courseFeeDefinitionId
							};
							store.load({
								callback: function(records, op, success) {
									if (records && records.length > 0) {
										var cfdseattypemappingwin = $this.getCfdseattypemappingwin();
										if (!cfdseattypemappingwin) {
											Ext.widget('cfdseattypemappingwin');
											cfdseattypemappingwin = $this.getCfdseattypemappingwin();
										}
										cfdseattypemappingwin.show();
									}else {
										showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ALL_SEAT_TYPES_ARE_MAPPED'));
									}
								}
							});
						}
					},
					'cfdseattypemappingwin multiselectcombofield[itemId=seatTypeId]':{
						afterrender:function(combo){
							var $this=this,
							cfdseattypemappingwin = this.getCfdseattypemappingwin(),
							grid = $this.getCoursefeedefinitioncentersgrid(),
							batchStructure = $this.getProgrambatchdetailstabstructure(),
							batchCombo  = batchStructure.down('#batchId'),
							seatTypeStore = combo.getStore();
							seatTypeStore.on('beforeload',function() {
								var selectedRecord = grid.getSelectionModel().getSelection()[0];
								if(selectedRecord && selectedRecord.data){
									seatTypeStore.getProxy().extraParams = {
										feePlanId: selectedRecord.data.feePlanId,
										batchId:batchCombo.getValue(),
										courseId:selectedRecord.data.courseId,
										courseFeeDefinitionId :selectedRecord.data.courseFeeDefinationId
									};
								}
							}, this);
						}
					},
					'cfdseattypemappingwin button[itemId=CancelBtn]':{
						click:function(){
							var cfdseattypemappingwin = this.getCfdseattypemappingwin();
							cfdseattypemappingwin.close();
						}
					},
					'cfdseattypemappingwin button[itemId=SubmitBtn]':{
						click:function(){
							this.saveSeatTypeMapping();
						}
					},
					'mappedseattypeandfeeplanwin grid[itemId=seatTypeAndFeePlanGridId]':{
						afterrender:function(grid){
							var courseFeeDefinationId,courseId,courseFeeType,feePlanId,store = grid.getStore(),
							grid = this.getCoursefeedefinitioncentersgrid(),
							selectedRecord = grid.getSelectionModel().getSelection()[0];
							if(selectedRecord && selectedRecord.data){
								feePlanId=selectedRecord.data.feePlanId;
								courseId=selectedRecord.data.courseId;
								courseFeeType=selectedRecord.data.courseFeeDefinationType;
								courseFeeDefinationId=selectedRecord.data.courseFeeDefinationId;
							}
							store.getProxy().extraParams = {
								feePlanId: feePlanId,
								courseFeeType:courseFeeType,
								courseId:courseId,
								courseFeeDefinationId:courseFeeDefinationId
							};
							store.load();
						}
					},
					/*'coursefeedefinitioncentersgrid button[itemId=btnAdd]':{
						click: function(button) {
							var me = this,
							grid = button.up('grid'),
							selectedRecord = grid.getSelectionModel().getSelection();

							if(selectedRecord.length==1){
								var win = new Ext.Window({
									title: getCommonTranslation('COURSE_FEE_DETAILS'),
									frame: true,
									height : 180,
									width:350,
									autoScroll:true,
									modal:true,
									layout: {
										type: 'vbox'
									},
									items:[{
										xtype : 'fieldcontainer',
										width : '100%',
										layout : {
											type : 'hbox'
										},
										defaults : {
											width : 226,
											labelAlign : 'top'
										},
										items:[{
											xtype: 'customcombobox',
											store :Ext.create('Ext.data.Store',{
												fields:['id','value'],
												autoLoad: false,
												proxy : {
													type: 'rest',
													api : {
														read : SERVERURL.PATH_FIND_ALL_COURSE_FEE_DEFINATION_BY_COURSEID 
													},
													reader: {
														type: 'json',
													} 
												},
												listeners: {
													beforeload: function(store, operation,eOpts) {
														store.proxy.extraParams = {
																courseId: selectedRecord[0].get('courseId')
														}; 
													}
												}
											}),
											fieldLabel: getCommonTranslation('COURSE_FEE_DEFINITION')+ ' <font color=red>*</font>',
											valueField: 'id',
											displayField: 'value',
											queryParam:'query',
											minChars:3,
											typeAhead:false,
											triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
											enableKeyEvents  : 'true',
											hideTrigger:false,
											forceSelection:true,
											emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
											listConfig: {
												listeners: {
													beforeshow: function(picker) {
														picker.minWidth = picker.up('combobox').getSize().width;
													}
												},
												loadingText: getCommonTranslation('SEARCHING'),
												emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
												getInnerTpl: function() {
													return '<div class="search-item">' +
													'{value}' +
													'</div>';
												}
											},
											listeners:{
												change: function(combo){
													if(isNullOrEmpty(combo.getValue())){
														combo.up('window').down('#btnSaveForm').setDisabled(true);
													}else{
														combo.up('window').down('#btnSaveForm').setDisabled(false);
													}
												}
											}
										}]
									}, {
										xtype: 'fieldcontainer',
										width: '100%',
										items: [{
											xtype: 'button',
											itemId: 'btnSaveForm',
											text: getCommonTranslation('SAVE'),
											ui: 'CustomBtnSubmit',
											scale: CONSTANTS.BUTTONSIZE,
											disabled: true,
											handler: function(button){
												var grid = me.getCoursefeedefinitioncentersgrid(),
												selectedRecord = grid.getSelectionModel().getSelection(),
												combo = button.up('window').down('customcombobox'),
												comboVal = combo.getValue(),
												win = button.up('window'),
												jsonData;

												if(selectedRecord.length==1 && !isNullOrEmpty(comboVal)){
													jsonData = {
															"id":selectedRecord[0].get('id'),
															"programCourse":{
																"id":selectedRecord[0].get('programCourseId')
															},
															"period":{
																"id":selectedRecord[0].get('periodId')
															},
															"courseFeeDefination":{
																"id":comboVal
															},
															"programBatchPeriodCourseFee": null,
															"whetherEnable":true
													};

													if(selectedRecord[0].data.courseFeeDefinationId == comboVal){
														if(!isNullOrEmpty(selectedRecord[0].data.programBatchPeriodCourseFeeId)){
															jsonData.programBatchPeriodCourseFee = {
																	"id":selectedRecord[0].get('programBatchPeriodCourseFee')
															};
														}
														jsonData.whetherEnable=selectedRecord[0].get('whetherEnable');
													}
													Ext.Ajax.request({
														type : 'rest',
														url : SERVERURL.PATH_ADD_COURSE_FEE_DEFINATION_IN_PROGRAM_COURSE_PERIOD,
														jsonData : jsonData,
														method : 'POST',
														success : function(form, action) {
															Ext.getBody().unmask();
															showSuccessMessage(getCommonTranslation('COURSE_FEE_DEFINITION'),getCommonTranslation('SUCCESS'));
															grid.store.loadPage(1);
															grid.getSelectionModel().deselectAll();
															grid.down('#btnEdit').setDisabled(true);
															win.close();
														}
													});
												}
											}
										}, {
											xtype: 'button',
											text: getCommonTranslation('RESET'),
											ui: 'CustomBtnCancel',
											scale: CONSTANTS.BUTTONSIZE,
											listeners:{
												click: function(btn){
													btn.up('window').down('customcombobox').reset();
												}
											}
										}]
									}],
									listeners:{
										afterrender: function(win){
											win.down('customcombobox').store.load({
												callback: function(records, operation, success) {
													win.down('customcombobox').setValue(selectedRecord[0].get('courseFeeDefinationId'));
												}
											});
										}
									}
								});
								win.show();
							} else {
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
						}
					},*/
					'coursefeedefinitioncentersgrid button[itemId=btnEnable]':{
						click: function(button) {
							var me = this,
							grid = button.up('grid'),
							selectedRecord = grid.getSelectionModel().getSelection(),
							jsonData=[],
							isAllFeeMapped = true;

							if(selectedRecord.length){
								Ext.each(selectedRecord, function(currentRecord){
									if(isNullOrEmpty(currentRecord.get('courseFeeDefinationId'))){
										isAllFeeMapped = false;
									} else {
										var dataVal = {
											"id":currentRecord.get('id'),
											"programCourse":{
												"id":currentRecord.get('programCourseId')
											},
											"period":{
												"id":currentRecord.get('periodId')
											},
											"courseFeeDefination":{
												"id":currentRecord.get('courseFeeDefinationId')
											},
											"programBatchPeriodCourseFee": null,
											"whetherEnable":!currentRecord.get('whetherEnable'),
											"billingDate":currentRecord.get('billingDate'),
										};
										if(!isNullOrEmpty(currentRecord.get('programBatchPeriodCourseFee'))){
											dataVal.programBatchPeriodCourseFee = {
												"id":currentRecord.get('programBatchPeriodCourseFee')
											};
										}
										jsonData.push(dataVal);
									}
								});
								if(!isAllFeeMapped){
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_COURSE_FEE_DEFINITION_MAPPED'));
								}
								else if(jsonData.length){
									Ext.Ajax.request({
										type : 'rest',
										url : SERVERURL.PATH_ADD_COURSE_FEE_DEFINATION_IN_PROGRAM_COURSE_PERIOD,
										jsonData : jsonData,
										method : 'POST',
										success : function(form, action) {
											Ext.getBody().unmask();
											showSuccessMessage(getCommonTranslation('COURSE_FEE_DEFINITION'),getCommonTranslation('SUCCESS'));
											grid.store.loadPage(1);
											grid.getSelectionModel().deselectAll();
											grid.down('#btnEdit').setDisabled(true);
										}
									});
								}
							} else {
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
						}
					},
					'coursefeedefinitioncentersgrid button[itemId=btnEdit]':{
						click: function() {
							this.openManagePeriodCourseFeeDefinitionTab();
						}
					},
					'coursefeedefinitioncentersgrid button[itemId=saveBtn]':{
						click: function(btn) {
							// save button code here
							var me = this;
							var grid = me.getCoursefeedefinitioncentersgrid(),
							selectedRecord = grid.getSelectionModel().getSelection(),
							//comboVal = selectedRecord[0].get('newCourseFeeDefinitionId'),
							jsonData = [];

							if(selectedRecord.length){
								Ext.each(selectedRecord, function(currentRecord){
									comboVal =currentRecord.data.newCourseFeeDefinitionId;
									if(!isNullOrEmpty(comboVal)){
										var dataVal = {
												"id":currentRecord.get('id'),
												"programCourse":{
													"id":currentRecord.get('programCourseId')
												},
												"period":{
													"id":currentRecord.get('periodId')
												},
												"courseFeeDefination":{
													"id":comboVal
												},
												"programBatchPeriodCourseFee": null,
												"whetherEnable":true,
												"billingDate": currentRecord.get('billingDate')
										};
									}
									else{
										var dataVal = {
												"id":currentRecord.get('id'),
												"programCourse":{
													"id":currentRecord.get('programCourseId')
												},
												"period":{
													"id":currentRecord.get('periodId')
												},
												"courseFeeDefination":{
													"id":currentRecord.get('oldCourseFeeDefinitionId')
												},
												"programBatchPeriodCourseFee": null,
												"whetherEnable":true,
												"billingDate": currentRecord.get('billingDate')
										};
									}
									

									if(currentRecord.data.oldCourseFeeDefinitionId == comboVal){
										if(!isNullOrEmpty(currentRecord.data.programBatchPeriodCourseFeeId)){
											dataVal.programBatchPeriodCourseFee = {
													"id":currentRecord.get('programBatchPeriodCourseFee')
											};
										}
										dataVal.whetherEnable=currentRecord.get('whetherEnable');
									}
									

									jsonData.push(dataVal);
								});
								

								Ext.Ajax.request({
									type : 'rest',
									url : SERVERURL.PATH_ADD_COURSE_FEE_DEFINATION_IN_PROGRAM_COURSE_PERIOD,
									jsonData : jsonData,
									method : 'POST',
									success : function(form, action) {
										Ext.getBody().unmask();
										showSuccessMessage(getCommonTranslation('COURSE_FEE_DEFINITION'),getCommonTranslation('SUCCESS'));
										grid.store.loadPage(1);
										grid.getSelectionModel().deselectAll();
										grid.down('#btnEdit').setDisabled(true);
									}
								});
							}
						}
					},
					'coursefeedefinitioncentersgrid button[itemId=resetGridBtn]':{
						click: function() {
							// reset button code here
							var me = this;
							var grid = me.getCoursefeedefinitioncentersgrid(),
							selectedRecord = grid.getSelectionModel().getSelection(),
							oldVal = selectedRecord[0].get('oldCourseFeeDefinitionId')
							newVal = selectedRecord[0].get('newCourseFeeDefinitionId');
							
							if(selectedRecord[0].dirty){
								grid.store.loadPage(1);
								grid.getSelectionModel().deselectAll();
								grid.down('#btnEdit').setDisabled(true);
							}
						}
					},
					'managefeeheadconfigurationgrid': {
						cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts){
							var columnName = grid.getGridColumns()[cellIndex].dataIndex;
							if (e.target.tagName == 'DIV' &&  columnName == "addButton" ) {

								serialNo = grid.getStore().getCount();
								this.onFeeHeadGridAddClick(serialNo+1,grid);
							}
							else if (e.target.tagName == 'DIV' && columnName == "deleteButton") {
								grid.getStore().removeAt(rowIndex);
								var storeCount = grid.getStore().getCount();
								if(storeCount == 0){
									this.getManagefeeheadconfigurationgrid().down('#btnAdd').setVisible(true);
									this.getManagefeeheadconfigurationgrid().down('#submitBtn').setVisible(false);
									this.getManagefeeheadconfigurationgrid().down('#resetBtn').setVisible(false);
								}
							}	
						},
						afterrender: function(grid){
							var grid1 = this.getManagefeeheadconfigurationgrid();
							var courseDefintionGrid = this.getCoursefeedefinitioncentersgrid();
							if(courseDefintionGrid.getSelectionModel().getCount()>0) { 
								var record = courseDefintionGrid.getSelectionModel().getSelection()[0];
								var id;
								if(!isNullOrEmpty(record.data.programBatchPeriodCourseFeeId)){
									var editUrl = SERVERURL.FIND_BY_ID_PROGRAM_BATCH_PERIOD_COURSE_FEE;
									id = record.get("programBatchPeriodCourseFeeId");

								}
								else if(!isNullOrEmpty(record.data.courseFeeDefinationId) && isNullOrEmpty(record.data.programBatchPeriodCourseFeeId)){
									var editUrl = SERVERURL.PATH_FIND_BY_ID_COURSE_FEE_DEFINITION;
									id  =record.get("courseFeeDefinationId");
								}	
								Ext.Ajax.request({
									method: "GET",
									type: 'rest',
									url: editUrl,
									params: {
										id: id
									},
									success: function(f, action) {
										var data = Ext.JSON.decode(f.responseText);

										if(data.courseFeeSubHeads.length>0){
											grid1.getStore().removeAll();
											var ObjModel = [];
											var serialNo = 0;
											for(i=0;i< data.courseFeeSubHeads.length; i++){
												serialNo = serialNo+1;
												var subHeadData = data.courseFeeSubHeads[i];
												var feeHeadConfGridModel = new Academia.model.feeandpayment.coursefeedefinition.FeeHeadConfigurationGridModel();
												feeHeadConfGridModel.set("serialNo", serialNo);
												feeHeadConfGridModel.set("feeHead", subHeadData.feeHead.id);
												feeHeadConfGridModel.set("amountOrWeightage", subHeadData.amountOrWeightage);
												//feeHeadConfGridModel.set("costCentre", subHeadData.costCentre.id);
												if(subHeadData.costCentre!=null)
						    						   feeHeadConfGridModel.set("costCentre", subHeadData.costCentre.id);
						    					else
						    						   feeHeadConfGridModel.set("costCentre",'');
												if(subHeadData.isRefundable!=null)
						    						   feeHeadConfGridModel.set("isRefundable", subHeadData.isRefundable);
						    					 else
						    						   feeHeadConfGridModel.set("isRefundable","");
						       						
						    					  if(subHeadData.rule!=null)
						    						   feeHeadConfGridModel.set("rule", subHeadData.rule.id);
						    					   else
						    					       feeHeadConfGridModel.set("rule","");
						    					  if(subHeadData.discountRule!=null)
						    						  feeHeadConfGridModel.set("discountRule", subHeadData.discountRule.id);
						    						  else
						    							  feeHeadConfGridModel.set("discountRule","");
											//	feeHeadConfGridModel.set("isRefundable", subHeadData.isRefundable);
											//	feeHeadConfGridModel.set("rule", subHeadData.rule.id);
												feeHeadConfGridModel.set("id", subHeadData.id);
												feeHeadConfGridModel.set("isAddDeleteRow", true);
												ObjModel.push(feeHeadConfGridModel);
											}
											grid1.getStore().loadRawData(ObjModel, true);
											grid1.down('#submitBtn').setVisible(true);
											grid1.down('#resetBtn').setVisible(true);
											grid1.down('#btnAdd').setVisible(false);

										}
										/*else{
											grid.down('#submitBtn').setVisible(false);
											grid.down('#resetBtn').setVisible(false);
											grid.down('#btnAdd').setVisible(true);
										}*/
									}
								});
							}

						}

					},
					'programbatchdetailstabstructure combo[itemId=batchId]':{
						select: function(c,r) {
							var batchId = "";
							if(Ext.isObject(r) || Ext.isArray(r)){
								batchId=r[0].data.id;
							}else{
								batchId=r;
							}
							var $this=this;
							var store = $this.getStore('program.programDetails.programBatches.courseFeeDefinition.CourseFeeDefinitionCenterStoreGrid');
							if(batchId!=null){
								store.getProxy().extraParams = {
									batchId: batchId,
									isFeeApplicable:true
								};
								store.load();
							}	
						}
					},
					'programassignexamcentersgrid button[itemId=btnEdit]':{
						click: function() {
							//this.openManagePeriodCourseFeeDefinitionTab();
						}
					},
					'programassignexamcentersgrid button[itemId=btnDelete]':{
						click: function() {
							//this.deleteAssignExamCentersData();
						}
					},
					'viewcoursefeedefinitiongrid': {
						afterrender:function(viewDefinitionGrid){
							var courseDefintionGrid = this.getCoursefeedefinitioncentersgrid();
							if(courseDefintionGrid.getSelectionModel().getCount()>0) {
								var record = courseDefintionGrid.getSelectionModel().getSelection()[0];
								var record1 =  courseDefintionGrid.getStore().findRecord('periodId',record.data.periodId)
								if(!isNullOrEmpty(record.data.programBatchPeriodCourseFeeId)){
								//	var id = record.get("programBatchPeriodCourseFeeId");
									viewDefinitionGrid.getStore().getProxy().extraParams = {
										courseFeeId:record.data.programBatchPeriodCourseFeeId,
										isPeriodCourseFee:true
									}
									var store = viewDefinitionGrid.getStore();
								this.resetPageSetting(store);
								viewDefinitionGrid.getStore().load();
								viewDefinitionGrid.getSelectionModel().deselectAll();
								
								}
								else if(!isNullOrEmpty(record.data.courseFeeDefinationId) && isNullOrEmpty(record.data.programBatchPeriodCourseFeeId)){
									viewDefinitionGrid.getStore().getProxy().extraParams = {
										courseFeeId:record.data.courseFeeDefinationId,
										isCourseFeeDefination:true										
									}
									var store = viewDefinitionGrid.getStore();
								this.resetPageSetting(store);
								viewDefinitionGrid.getStore().load();
								viewDefinitionGrid.getSelectionModel().deselectAll();
								
								}
								
								
							}
						}
					},
					'viewcoursefeedefinitionfilter': {
						afterrender: function(){
							var filter = this.getViewcoursefeedefinitionfilter();
							var filterForm = 	filter.getForm();
							var feeDefinitionName =filterForm.findField('feeDefinitionName');
							var feeType = filterForm.findField('feeType');
							var feeHead = filterForm.findField('feeHead');
							var courseDefintionGrid = this.getCoursefeedefinitioncentersgrid();
							var record = courseDefintionGrid.getSelectionModel().getSelection()[0];
							if(!isNullOrEmpty(record.data.programBatchPeriodCourseFeeId)){
								var editUrl = SERVERURL.FIND_BY_ID_PROGRAM_BATCH_PERIOD_COURSE_FEE;
								var id = record.get("programBatchPeriodCourseFeeId");

							}
							if(!isNullOrEmpty(record.data.courseFeeDefinationId) && isNullOrEmpty(record.data.programBatchPeriodCourseFeeId)){
								var editUrl = SERVERURL.PATH_FIND_BY_ID_COURSE_FEE_DEFINITION;
								var id  =record.get("courseFeeDefinationId");
							}	
							Ext.Ajax.request({
								method: "GET",
								type: 'rest',
								url: editUrl,
								params: {
									id: id
								},
								success: function(response, action) {
									var data = Ext.JSON.decode(response.responseText);
									feeDefinitionName.setValue(data.courseDefinationName);
									feeHead.setValue(data.parentFeeHead.value);
									if(data.courseFeeType=='FIXED' || data.courseFeeType=='FIXED_AMOUNT'){
										feeType.setValue('Fixed');
									}
									else if(data.courseFeeType=='CREDIT_BASED'){
										feeType.setValue('Credit Based');


									}
								}
							});
						}
					}, 
					'managefeeheadconfigurationgrid button#btnAdd': {
						click: function(){
							var grid = this.getManagefeeheadconfigurationgrid();
							this.onFeeHeadGridAddClick(1, grid);
							grid.down('#submitBtn').setVisible(true);
							grid.down('#resetBtn').setVisible(true);

						}
					},
					'managefeeheadconfigurationgrid button#submitBtn': {
						click: function(){
							this.saveFeeHeadConfigurationDetail();
						}
					},
					'managefeeheadconfigurationgrid button#resetBtn': {
						click: function(){
							var grid = this.getManagefeeheadconfigurationgrid();
							var record = grid.getSelectionModel().getSelection();
							if(record.length == 1){
								record[0].set("serialNo", record[0].data.serialNo);
								record[0].set("feeHead", '');
								record[0].set("amountOrWeightage", '');
								record[0].set("costCentre", '');
								record[0].set("isRefundable", '');
								record[0].set("rule", '');
								record[0].set("isAddDeleteRow", true);
								record[0].set("discountRule", '');
							}
							else{
								showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_HEAD_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
							}
						}
					},
				});
			},
			getFeeCourseSubHeadGridWindow: function(grid,record,repetitionGrid){
				var $this=this;
				var formWindow = this.getViewcoursefeedefinitionwindow();
				if (!formWindow) {
					formWindow = Ext.widget('viewcoursefeedefinitionwindow');

				}
				formWindow.show();
			},
			openManagePeriodCourseFeeDefinitionTab: function(){
				var me = this;
				var courseDefintionGrid = this.getCoursefeedefinitioncentersgrid();
				var record = courseDefintionGrid.getSelectionModel().getSelection()[0];
				var id;
				var contentpanel = me.getContentPanel();
				var courseFeeDefinitionStructure = Ext.widget('manageperiodfeedefinitionstructure');
				var tabName = getCommonTranslation('MANAGE_PERIOD_COURSE_FEE_DEFINITION');

				/**
				 * This is to remove tab from content panel and open same tab again 
				 */
				var getcontroller=me.getController('menu.CoreERPNavigationController');
				var getTab=getcontroller.getInnerTab(contentpanel,tabName);

				if(getTab){
					contentpanel.remove(getTab, true);
				}
				openTab(contentpanel, tabName, courseFeeDefinitionStructure,CONSTANTS.MENU_COLOR_FIVE);


				var filter = this.getManagefeeheadconfigurationfilter();
				var manageFeeHeadConfigurationGrid = this.getManagefeeheadconfigurationgrid();
				var filterForm =filter.getForm();
				if(!isNullOrEmpty(record.data.programBatchPeriodCourseFeeId)){
					var editUrl = SERVERURL.FIND_BY_ID_PROGRAM_BATCH_PERIOD_COURSE_FEE;
					id = record.get("programBatchPeriodCourseFeeId");

				}
				if(!isNullOrEmpty(record.data.courseFeeDefinationId) && isNullOrEmpty(record.data.programBatchPeriodCourseFeeId)){
					var editUrl = SERVERURL.PATH_FIND_BY_ID_COURSE_FEE_DEFINITION;
					id  =record.get("courseFeeDefinationId");
				}
				filterForm.findField('programBatchPeriodCourseFeeIdName').setValue(record.data.programBatchPeriodCourseFeeId);
				filterForm.findField('programCoursePeriodId').setValue(record.data.id);

				filterForm.findField('courseFeeDefinationId').setValue(record.data.courseFeeDefinationId);
				Ext.Ajax.request({
					method: "GET",
					type: 'rest',
					url: editUrl,
					params: {
						id: id
					},
					success: function(f, action) {
						var data = Ext.JSON.decode(f.responseText);

						filter.down("#feeDefinitionId").setValue(id);
						var feeDefinitionName = filterForm.findField('feeheadDefinationName');
						var feeHeadType = filterForm.findField('feeheadType');
						var feeHead = filterForm.findField('feeHead');
						var parentFeeHeadId =filterForm.findField('parentFeeHeadId');
						var isActiveField =filterForm.findField('isActive');

						feeDefinitionName.setValue(data.courseDefinationName);
						if(data.courseFeeType == "CREDIT_BASED"){
							feeHeadType.setValue('Credit Based'); 
						}
						else{
							feeHeadType.setValue('Fixed');
						}
						feeHead.setValue(data.parentFeeHead.value);
						parentFeeHeadId.setValue(data.parentFeeHead.id);
						isActiveField.setValue(data.isActive);

					}
				});

			},
			onFeeHeadGridAddClick: function(serialNo,grid){
				var $this = this;
				var ObjModel = [];
				var feeHeadConfGridModel = new Academia.model.feeandpayment.coursefeedefinition.FeeHeadConfigurationGridModel();
				feeHeadConfGridModel.set("serialNo", serialNo);
				feeHeadConfGridModel.set("feeHead", '');
				feeHeadConfGridModel.set("amountOrWeightage", '');
				feeHeadConfGridModel.set("costCentre", '');
				feeHeadConfGridModel.set("isRefundable", '');
				feeHeadConfGridModel.set("rule", '');
				feeHeadConfGridModel.set("isAddDeleteRow", true);
				ObjModel.push(feeHeadConfGridModel);
				grid.getStore().loadRawData(ObjModel, true);
				if(serialNo == 1){
					grid.down('#btnAdd').hide();
					grid.down('#submitBtn').setVisible(true);
					grid.down('#resetBtn').setVisible(true);
				}

			},
			saveSeatTypeMapping:function(){
				var $this=this,seatTypeArr=[],seatTypeStr,courseId,feePlanId,academyLocationId,submitUrl,programCourseId,periodId,
				url=SERVERURL.PATH_UNMAPPED_PROGRAM_BATCH_SEAT_TYPE_SAVE,
				grid = $this.getCoursefeedefinitioncentersgrid(),
				seatTypeButton = grid.down('#seatTypeMappingBtn'),
				selectedRecord = grid.getSelectionModel().getSelection()[0],
				cfdseattypemappingwin = this.getCfdseattypemappingwin();
				seatTypeValue = cfdseattypemappingwin.down('#seatTypeId').getValue();
				if(seatTypeValue !=undefined && seatTypeValue.length > 0) {
					for(var i in seatTypeValue) {
						if(Ext.isObject(seatTypeValue[0])) {
							seatTypeArr.push(seatTypeValue[i].get("pbstId"));
						} else {
							seatTypeArr.push(seatTypeValue[i]);
						}
					}
					seatTypeStr= seatTypeArr.join();
				} else {
					seatTypeStr = null;
				}	
				
				if(selectedRecord && selectedRecord.data){
					courseId=selectedRecord.data.courseId;
					feePlanId=selectedRecord.data.feePlanId;
					academyLocationId=selectedRecord.data.academyLocationId;
					programCourseId=selectedRecord.data.programCourseId;
					periodId=selectedRecord.data.periodId;
				}
				submitUrl = url+'?pbstIds=' + seatTypeStr+ '&courseId=' + courseId+ '&feePlanId=' + feePlanId+ '&academyLocationId=' + academyLocationId+ '&programCourseId=' + programCourseId+ '&periodId=' + periodId;
				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				Ext.Ajax.request({
					type : 'rest',
					url : submitUrl,
					method : 'POST',
					success : function(form, action) {
						var resp =  form.responseText;
						Ext.getBody().unmask();
						cfdseattypemappingwin.close();
						grid.getSelectionModel().deselectAll();
						seatTypeButton.setDisabled(true);
						if(resp=="CREDIT_FEE_MAPPING_NOT_DEFINED"){
							showWarningMessage(getCommonTranslation('ALERT'),'Credit fee mapping is currently not defined and needs to be configured');
						}else{
							grid.getStore().load();
							showSuccessMessage(getCommonTranslation('SUCCESS'),getProgramandcourseTranslation('SEAT_TYPE_MAPPED_SUCCESSFULLY'));
						}
					},
					failure:function(){
						Ext.getBody().unmask();
					}
				});
				
			},
			saveFeeHeadConfigurationDetail: function(){
				var structure =this.getManageperiodfeedefinitionstructure();
				var courseFeeGrid = this.getCoursefeedefinitioncentersgrid();

				var feeHeadFilter = this.getManagefeeheadconfigurationfilter();
				var subHeadGrid = this.getManagefeeheadconfigurationgrid();
				var feeHeadFilterValue = feeHeadFilter.getForm();
				var feeHeadFilterValues = feeHeadFilter.getForm().getValues();
				var jsonObj ={};
				var subHeadArray = [];
				var flag= true;
				var submitUrl = null;
				var storeItems = subHeadGrid.getStore().data.items;
				var isCreate = false;
				if(!isNullOrEmpty(feeHeadFilterValues.programCoursePeriodId)){
					isCreate = true;
				}
				if(storeItems.length > 0){
					storeItems.forEach(function(obj){
						var obj1 = new Object(); 

						obj1.serialNo=obj.data.serialNo;	 

						if(!isNullOrEmpty(obj.data.feeHead)){
							obj1.feeHead= {
									id:obj.data.feeHead
							}


						}else{
							flag =false;
						}
						if(!isNullOrEmpty(obj.data.amountOrWeightage)){
							obj1.amountOrWeightage= obj.data.amountOrWeightage

						}else{
							flag =false;
						}
						if(!isNullOrEmpty(obj.data.costCentre)){
							obj1. costCentre= {
									id: obj.data.costCentre

							}
						}
						if(!isNullOrEmpty(obj.data.discountRule)){
							obj1. discountRule= {
									id: obj.data.discountRule

							}
						}
						 if(obj.data.isRefundable==true&&!isNullOrEmpty(obj.data.rule))
	        	            {
	        	            	 obj1.rule= {
	               		          id: obj.data.rule

	        		                      }
	        		    obj1.isRefundable= obj.data.isRefundable;
	        	            }
	            		  else if(obj.data.isRefundable==false)
	        	            {
	        	            	 obj1.isRefundable= obj.data.isRefundable;
	        	            	 
	           	            }
	        	            else
	        	            {
	        	            	 obj1.isRefundable= obj.data.isRefundable;
	        	            	flag=false;
	        	            } 
						if(!isNullOrEmpty(feeHeadFilterValues.programBatchPeriodCourseFeeIdName)){
							if(!isNullOrEmpty(obj.data.id)){
								obj1.id = obj.data.id;
								
							}
						}
						
						else{
							obj1.id = null;
						}
						
						subHeadArray.push(obj1);
					});
					if(feeHeadFilter.getForm().isValid()){
						var feeTypeValue;
						var isActiveValue;
						if(feeHeadFilterValues.feeheadType == "Credit Based"){
							feeTypeValue = "CREDIT_BASED"
						}else{
							feeTypeValue = "FIXED"
						}
						if(feeHeadFilterValues.isActive == "true" ||feeHeadFilterValues.isActive == true ){
							isActiveValue = true;
						}
						else{
							isActiveValue = false; 
						}

					

					}
					else{
						flag = false;
					}
					if(flag){
						if(!isNullOrEmpty(feeHeadFilterValues.programBatchPeriodCourseFeeId)){
							submitUrl = SERVERURL.PROGRAM_BATCH_PERIOD_COURSE_FEE_UPDATE;
							jsonObj = {
									id:parseInt(feeHeadFilterValues.programCoursePeriodId),
									parentFeeHead: {
										id: parseInt(feeHeadFilterValues.parentFeeHeadId),
									},
									courseFeeType: feeTypeValue,
									courseDefinationName:feeHeadFilterValues.feeheadDefinationName,
									isActive:isActiveValue,
									courseFeeSubHeads:subHeadArray
							}
						}
						if(!isNullOrEmpty(feeHeadFilterValues.courseFeeDefinationId) && isNullOrEmpty(feeHeadFilterValues.programBatchPeriodCourseFeeId)){
							submitUrl = SERVERURL.PROGRAM_BATCH_PERIOD_COURSE_FEE_CREATE;		 				
							jsonObj = {
									programCoursePeriodId: parseInt(feeHeadFilterValues.programCoursePeriodId),
									parentFeeHead: {
										id: parseInt(feeHeadFilterValues.parentFeeHeadId),
									},
									courseFeeType: feeTypeValue,
									courseDefinationName:feeHeadFilterValues.feeheadDefinationName,
									isActive:isActiveValue,
									courseFeeSubHeads:subHeadArray
							}
						}

						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						Ext.encode(jsonObj);
						Ext.Ajax.request({
							type : 'rest',
							url : submitUrl,
							jsonData : jsonObj,
							method : 'POST',
							success : function(form, action) {
								Ext.getBody().unmask();
								showSuccessMessage(getCommonTranslation('FEE_HEAD_DETAILS'),getCommonTranslation('SUCCESS'));
								structure.up().close();
								courseFeeGrid.getStore().load();
								courseFeeGrid.getSelectionModel().deselectAll();
							},
							failure:function(form,action){

							}
						});
					}
					else{
						showWarningMessage(getCommonTranslation('ALERT'),getServiceRequestTranslation('FILL_MANDATORY_FIELDS'));
					}

				}
			},
});