Ext.define('Academia.controller.program.ProgramCoursesController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['program.programDetails.programBatches.programCourse.ProgramCourseStoreGrid','program.programDetails.programBatches.programCourse.ProgramCourseCodeStore',
             'coursetransaction.studymaterialdistribution.CoursesAllSmartSearch','program.programDetails.programBatches.programCourse.CourePeriodMapStore',
             'program.programDetails.programBatches.relatedCourses.ProgramRelatedCourses', 'course.coursegroup.CourseGroupByCourseIdStore'],
    models: ['program.programDetails.programBatches.programCourse.ProgramCourseModelGrid','common.IdValueCodeDataModel',
    		'program.programDetails.programBatches.programCourse.PeriodParameteModel'],
    views: ['baselayout.contentarea.ContentPanel',
            'program.programDetails.programBatchDetails.courses.ProgramCoursesForm',
            'program.programDetails.programBatchDetails.courses.ProgramCoursesGrid',
            'program.programDetails.programBatchDetails.courses.ProgramCoursesStructure',
            'program.programDetails.programBatchDetails.courses.CoursesPeriodMappingForm',
            'program.programDetails.programBatchDetails.courses.CourseMappedPeriodList',
            'program.programDetails.programBatchDetails.courses.CourseMappedPeriodListGrid',
            'program.programDetails.programBatchDetails.courses.CoursePeriodMappingGrid',
            'program.programDetails.programBatchDetails.courses.CoursePeriodMappingTabStructure',
            'program.programDetails.programBatchDetails.ProgramBatchDetailsInnerTabPanelStructure',
            'program.programDetails.programBatchDetails.courses.NoOfCourseGroups',
            'program.programDetails.programBatchDetails.courses.NoOfAssociatedCourseGroup'
        	],
   config:{
	   		/*
	   		 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
       		   	 */
       	   	/**
       	        * @cfg {Array} PROGRAMCOURSE_PERMISSIONS array (required)
       	        * The array of permissions to use for Access control wise enabling and disabling buttons.
       	        * @accessor
       	        */
	   PROGRAMCOURSE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROGRAMCOURSE_PRIVILEGES'), 
	   PROGRAM_BATCH_COURSE_GROUP_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROGRAM_BATCH_COURSE_GROUP_PRIVILEGES')
   } , 
   refs: [{
	   ref: 'programcoursesgrid',
	   selector: 'programcoursesgrid'
   },{
	   ref: 'programcoursesformwindow',
	   selector: 'programcoursesformwindow'
   },{
	   ref: 'contentPanel',
	   selector: 'contentPanel'
   },{
	   ref: 'programbatchdetailstabstructure',
	   selector: 'programbatchdetailstabstructure'
   },{
	   ref : 'batchdetailstabstructure',
	   selector : 'batchdetailstabstructure'
   },{
	   ref : 'coursesperiodmappingform',
	   selector : 'coursesperiodmappingform'
   },{
	   ref : 'coursemappedperiodlist',
	   selector : 'coursemappedperiodlist'
   },{
	   ref : 'courseperiodmappingtabstructure',
	   selector : 'courseperiodmappingtabstructure'
   },{
	   ref : 'courseperiodmappinggrid',
	   selector : 'courseperiodmappinggrid'
   }, {
 	  ref : 'programbatchdetailsinnertabpanelstructure',
	  selector : 'programbatchdetailsinnertabpanelstructure'
  }, {
 	  ref : 'noofcoursegroups',
	  selector : 'noofcoursegroups'
  }, {
 	  ref : 'noofassociatedcoursegroup',
	  selector : 'noofassociatedcoursegroup'
  }],

	
    init: function(application) {
        this.control({
        	'programcoursesgrid':{
        		render:function(grid){
        			this.doAccessControlValidation(grid, this.getPROGRAMCOURSE_PERMISSIONS());
        			this.addDataGridConfigButton(grid,this.getPROGRAMCOURSE_PERMISSIONS());
        			var associatedAcadLocationIds = new Array();
			    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			    	
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getPROGRAMCOURSE_PERMISSIONS());
        			var gridEditBtn= buttonsToolBar.query('#btnEdit')[0];
    				var mapPeriodBtn= buttonsToolBar.query('#mapPeriod')[0];
        			Ext.each(permissionList, function(privilege) {
			    		if (privilege === 'MAP_PERIOD') {
			        		if(!isNullOrEmpty(mapPeriodBtn)){
			        			mapPeriodBtn.setVisible(true);
			        		}        		
			        	}
			    	});
        			gridEditBtn.setDisabled(true);
    				mapPeriodBtn.setDisabled(true);
        			
        		},cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
        			var $this=this;
        			var columnName=grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
        			if(columnName=='periodObj' && record.data.periodDisplayObj!=null && record.data.periodDisplayObj.length > 1){
        				this.showMappedPeriodWithCourse(grid, RowIdx, record);
        			}
        			if(columnName=='courseGroupCount' &&  record.data.courseGroupCount > 0){ // checked
						//var store=$this.getStore('course.coursegroup.AssignCoursesStructureStore');


						var formWindow = $this.getNoofcoursegroups();
						if (!formWindow) {
							Ext.widget('noofcoursegroups');
							formWindow = $this.getNoofcoursegroups();
							var store= $this.getNoofassociatedcoursegroup().getStore();
							store.getProxy().extraParams = {
								batchId : record.data.batchId,
								courseId: record.data.courseId
							};
							$this.resetPageSetting(store);
							store.load();
							$this.getNoofassociatedcoursegroup().getView().refresh();
						}
						formWindow.down('#courseName').setValue(record.data.courseName);
						formWindow.show();

					}
        		},
        		afterrender:function(grid){
        			grid.getStore().load();
        		}
        	},'noofassociatedcoursegroup':{
        		afterrender:function(grid){
					this.disableExportPdfExcelButtonByPivileges(grid,this.getPROGRAM_BATCH_COURSE_GROUP_PERMISSIONS());
				}
            },'noofassociatedcoursegroup button[itemId=btnSaveItemId]':{
            	click: function() {
                	this.updateNoOfAssociateCourseGropusRecord();
                }
            },'programcoursesgrid button[itemId=btnAdd]':{
            	click: function() {
                	this.showProgramCoursesFormWindow();
                }
            },'programcoursesformwindow button[itemId=programCoursesFormCancel]':{
            	click: function() {
                	this.closeProgramCoursesFormCancel();
                }
            },'programcoursesformwindow button[itemId=programCoursesFormSubmit]':{
            	click: function() {
                	this.saveDataProgramCourseForm();
                }
            },'programcoursesstructure [itemId=ProgramCoursesGridId]':{
            	selectionchange: function(column, selected,eOpts ){
            		var grid=column.view.up('grid');
            		var buttonsToolBar = grid.query('toolbar')[0];
            		var gridEditBtn= buttonsToolBar.query('#btnEdit')[0];
            		var gridDeleteBtn= buttonsToolBar.query('#btnDelete')[0];
            		var mapPeriodBtn= grid.down('#mapPeriod');
            		var selectedModelperiod = [];
            		if(selected.length== 1){
        				gridEditBtn.setDisabled(false);
        				gridDeleteBtn.setDisabled(false);
            		}else{
        				gridEditBtn.setDisabled(true);
        				gridDeleteBtn.setDisabled(true);
            		}
            		if(selected.length > 0){
            			mapPeriodBtn.setDisabled(false);
            		}else{
            			mapPeriodBtn.setDisabled(true);
            		}
                }
            },
            
            'programcoursesformwindow':{
            	show: function() {
            		var $this=this;
            		var formWindow = this.getProgramcoursesformwindow();
            		var batchTabStructureForm=$this.getProgrambatchdetailstabstructure().getForm();
            		var batchId=batchTabStructureForm.findField('batch').getValue();
            		var courseCombo=formWindow.down('#courseItemId');
            		var store=courseCombo.getStore();
            		if(batchId!=null){
	            		store.getProxy().extraParams = {
	    					id: batchId
	    				};
	    				//store.load();
	    			 }	
            		var alinfomodel = Academia.model.authentication.ALInfoModel;
               	 	var wheatherSchool = alinfomodel.get('wheatherSchool');
               	 	var isOfferedYearly = formWindow.down('#isOfferedYearly');
               	 	if(wheatherSchool){
               	 		isOfferedYearly.setVisible(false);
               	 	}/*else{
               	 		//isOfferedYearly.setVisible(true);
               	 	}*/
                }
            },
            'programbatchdetailstabstructure combo[itemId=batchId]':{
            	select: function(c,r) {
            		var batchId = "";
            		if(Ext.isObject(r) || Ext.isArray(r)){
            			batchId=r[0].data.id;
					  }else{
						  batchId=r;
					  }
            		var $this=this;
            		var store = $this.getStore('program.programDetails.programBatches.programCourse.ProgramCourseStoreGrid');
    				if(batchId!=null){
	            		store.getProxy().extraParams = {
	    					batchId: batchId
	    				};
	    				store.load();
	    			 }	
                }
            },
            'programcoursesgrid button[itemId=btnEdit]':{
            	click:function(){
            		this.editCourseFormWindow();
            	}
            },
            'programcoursesgrid button[itemId=btnDelete]':{
            	click:function(){
            		this.deleteProgramCourseData();
            	}
            },
            'programcoursesgrid button[itemId=btnView]':{
            	click:function(){
            		var value=true;
            		this.editCourseFormWindow(value);
            	}
            },
            'programcoursesgrid button[itemId=mapPeriod]':{
            	click:function(){
            		this.showCoursePeriodMappingWindow();
            		this.loadCoursePeriodMappingGrid();
            	}
            },
            'coursesperiodmappingform':{
            	render : function(){
            		var batchTabStructureForm=this.getProgrambatchdetailstabstructure().getForm();
            		var batchId=batchTabStructureForm.findField('batch').getValue();
            		var formWindow = this.getCoursesperiodmappingform();
            		var periodComboStore = formWindow.down('#prgCrsPeriodId').getStore();
            		periodComboStore.getProxy().extraParams = {
						   id: batchId
					   };
            		periodComboStore.load();
            	}
            },
            'coursesperiodmappingform button[itemId=coursesperiodmappingformSubmit]':{
            	click: function(obj,record) {
            	    var form = this.getCoursesperiodmappingform();
                	this.saveCourseDefaultPeriod(obj,form.down('#prgCrsPeriodId').getValue());
                }
            },
            'coursesperiodmappingform button[itemId=coursesperiodmappingformCancel]':{
            	click: function() {
                	this.closeCourseDefaultPeriodMappingWindow();
                }
            },
            'courseperiodmappinggrid':{
            	render:function(){
            		var grid=this.getCourseperiodmappinggrid();
            		var buttonsToolBar = grid.query('toolbar')[0];
            		var defaultPeriodBtn= buttonsToolBar.query('#defaultPeriod')[0];
            		defaultPeriodBtn.setDisabled(true);
            	}
            },
            'courseperiodmappinggrid button[itemId=defaultPeriod]':{
            	click:function(){
            		this.showCourseDefaultPeriodMappingWindow();
            	}
            },
            'courseperiodmappingtabstructure':{
            	afterrender:function(){
            		var structure = this.getCourseperiodmappingtabstructure();
            		var saveBtn = structure.down('#coursesperiodmappingformSubmit');
            		setTimeout(function(){
            			saveBtn.setDisabled(true);
            			structure.up('batchdetailstabstructure').up().body.setScrollTop(0);
            		},100);
            		
            	}
            },
            'courseperiodmappingtabstructure [itemId=courseperiodmappinggrid]':{
            	selectionchange: function(column, selected,eOpts ){
            		var grid=this.getCourseperiodmappinggrid();
            		var buttonsToolBar = grid.query('toolbar')[0];
            		var defaultPeriodBtn= buttonsToolBar.query('#defaultPeriod')[0];
            		var structure = this.getCourseperiodmappingtabstructure();
            		var saveBtn = structure.down('#coursesperiodmappingformSubmit');
            		if(selected.length > 0){
            			defaultPeriodBtn.setDisabled(false);
            			saveBtn.setDisabled(false);
            		}else{
            			defaultPeriodBtn.setDisabled(true);
            			saveBtn.setDisabled(true);
            		}
                }
            },
            'courseperiodmappingtabstructure button[itemId=coursesperiodmappingformSubmit]':{
            	click: function(btn) {
                	this.saveCoursePeriodMapping(btn);
                }
            },
            'courseperiodmappingtabstructure button[itemId=coursesperiodmappingformCancel]':{
            	click: function() {
                	this.closeCoursePeriodMappingWindow();
                }
            },
            'courseperiodmappinggrid checkcolumn':{
            	checkchange:function(obj, rowIndex, checked, eOpts ){
            		var this$ = this;
            		var grid = this$.getCourseperiodmappinggrid();
            		var store = grid.getStore();
            		var models = grid.getStore().getRange();
            		
            		var isOfferedYearly = models[rowIndex].data.periodObj[0].isOfferedYearly;
					var objDataIndex = obj.dataIndex;
					var courseRepeatable = models[rowIndex].data.periodObj[0].courseRepeatable;
					
					var result = models[rowIndex].data.periodObj.filter(function (obj) {
						  return "checkbox"+obj.periodId === objDataIndex;
						})[0];
					
					var periodYearId = result.periodYearId;
    				
    				if(isOfferedYearly == true && !isNullOrEmpty(periodYearId) && courseRepeatable == false){
    					var flag = false;
    					for(var i =0; i<models[rowIndex].data.periodObj.length;i++){
    						var objPeriodYearId = models[rowIndex].data.periodObj[i].periodYearId;
    						if(periodYearId==objPeriodYearId){
    							if(checked){
    								models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true);	
    							}
    							else{
    								if(!isNullOrEmpty(models[rowIndex].data.periodObj[i].parameterizationId)){
    									models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true); 
    								}
    								else{
    									var result1 = models[rowIndex].data.periodObj.filter(function (obj) {
    										  return obj.periodYearId === periodYearId;
    									});
    									if(result1.length>0){
    										result1.forEach(function(objRes){
    											if(!isNullOrEmpty(objRes.parameterizationId)){
    												flag = true;
    											}
    										});
    										if(flag){
    											models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true);  
    										}
    										else{
    											models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, false);
    										}
    									}
    									else{
    										models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, false);	
    									}
    								}
    							}
            				}else{
            					models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, false);
            				}
    					}
    				}
    				else if(isOfferedYearly == false && courseRepeatable == false){
    					var flag = false;
            			var count=0;
            			for(var i =0; i<models[rowIndex].data.periodObj.length;i++){
            				if(models[rowIndex].get('checkbox'+models[rowIndex].data.periodObj[i].periodId) == true){
            					count = count+1;
            				}
            				if(!isNullOrEmpty(models[rowIndex].data.periodObj[i].parameterizationId)){
            					models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true); 
            					flag = true;
            				}else{
            					models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, false);
            					if(count>1){
            						showWarningMessage(getCommonTranslation('MAP_PERIOD'),getCommonTranslation('NOT_REPEATABLE_COURSE_PERIOD_MESSAGE'));
            					}
            				}
            				if(!flag){
            					if(obj.dataIndex=='checkbox'+models[rowIndex].data.periodObj[i].periodId){
                					models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true);  
                				}else{
                					models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, false);
                				}
            				}
            			}
    				}
    				else if(isOfferedYearly == false && courseRepeatable == true){
    					for(var i =0; i<models[rowIndex].data.periodObj.length;i++){
            				if(!isNullOrEmpty(models[rowIndex].data.periodObj[i].parameterizationId)){
            					models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true); 
            				}
            			}  
    				}
    				else if(isOfferedYearly == true && !isNullOrEmpty(periodYearId) && courseRepeatable == true){
    					var flag = false;
    					for(var i =0; i<models[rowIndex].data.periodObj.length;i++){
    						var objPeriodYearId = models[rowIndex].data.periodObj[i].periodYearId;
    						if(periodYearId==objPeriodYearId){
    							if(checked){
    								models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true);	
    							}
    							else{
    								if(!isNullOrEmpty(models[rowIndex].data.periodObj[i].parameterizationId)){
    									models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true); 
    								}
    								else{
    									var result1 = models[rowIndex].data.periodObj.filter(function (obj) {
    										  return obj.periodYearId === periodYearId;
    									});
    									if(result1.length>0){
    										result1.forEach(function(objRes){
    											if(!isNullOrEmpty(objRes.parameterizationId)){
    												flag = true;
    											}
    										});
    										if(flag){
    											models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true);  
    										}
    										else{
    											models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, false);
    										}
    									}
    									else{
    										models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, false);	
    									}
    								}
    							}
            				}else{
            					//models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, false);
            				}
    					}
    				}
            		
            		/*if(models[rowIndex].data.courseRepeatable!=true){
            			var flag = false;
            			var count=0;
            			for(var i =0; i<models[rowIndex].data.periodObj.length;i++){
            				if(models[rowIndex].get('checkbox'+models[rowIndex].data.periodObj[i].periodId) == true){
            					count = count+1;
            				}
            				if(!isNullOrEmpty(models[rowIndex].data.periodObj[i].parameterizationId)){
            					models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true); 
            					flag = true;
            				}else{
            					models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, false);
            					if(count>1){
            						showWarningMessage(getCommonTranslation('MAP_PERIOD'),getCommonTranslation('NOT_REPEATABLE_COURSE_PERIOD_MESSAGE'));
            					}
            				}
            				if(!flag){
            					if(obj.dataIndex=='checkbox'+models[rowIndex].data.periodObj[i].periodId){
                					models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true);  
                				}else{
                					models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, false);
                				}
            				}
            			
            			}  
            		}else{
            			for(var i =0; i<models[rowIndex].data.periodObj.length;i++){
            				if(!isNullOrEmpty(models[rowIndex].data.periodObj[i].parameterizationId)){
            					models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true); 
            				}
            			}   
            		}*/
            		/*setTimeout(function(){
            			grid.getSelectionModel().selectAll();
            		},100);*/
            		
            	}
            }
        });
    },
      showProgramCoursesFormWindow: function() {
    	  	var grid = this.getProgramcoursesgrid();
    	  	if(grid.getSelectionModel().getSelection().length > 0){
    	  		grid.getSelectionModel().deselectAll();
    	  	}
	        var formWindow = this.getProgramcoursesformwindow();
	        
	        if (!formWindow){
	            Ext.widget('programcoursesformwindow');
	            formWindow = this.getProgramcoursesformwindow();
	        }
	        formWindow.show();
	    },
	    
	    updateNoOfAssociateCourseGropusRecord: function() {
    	  	var grid = this.getNoofassociatedcoursegroup();
    	  	var programCourseGrid = this.getProgramcoursesgrid();
			var formWindow = this.getNoofcoursegroups();
    	  	if(grid.getSelectionModel().getSelection().length > 0){
    	  		var record=grid.getSelectionModel().getSelection()[0];
        	  	var batchId=record.raw.batchId;
        	  	var courseId=record.raw.courseId;
        	  	var whetherMajor=record.data.whetherMajor;
        	  	if(whetherMajor=='Yes' || whetherMajor=='YES'){
        	  		whetherMajor=true;
        	  	}else{
        	  		whetherMajor=false;
        	  	}
        	  	
        	  	Ext.Ajax.request({
   				 type: 'rest',
   				 async: false,
   				 url: SERVERURL.PATH_UPDATE_NO_OF_ASSOCIATE_COURSE_GROUPS,
   				 method: 'GET',
   				 params:{
   					batchId:batchId,
   					courseId:courseId,
   					whetherMajor:whetherMajor
   				 },
   				 success: function(f, action) {
   				 if(f.responseText=='true'){
   					showSuccessMessage(getCommonTranslation('COURSE_GROUP'), getCommonTranslation('SUCCESS'));
   					programCourseGrid.getStore().removeAll();
   					programCourseGrid.getStore().load();
   					formWindow.close();
      				//grid.down('#btnSaveItemId').setDisabled(true);
   				 }else{
   					showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('exception_while_updating_entity'));
   				 }
   				 }
   			 });
        	  	
    	  	}else{
        	  	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	  	}
	    },
	    
	    closeProgramCoursesFormCancel: function() {
	        this.getProgramcoursesformwindow().close();
	    },
	    showCourseDefaultPeriodMappingWindow: function() {
	        var formWindow = this.getCoursesperiodmappingform();
	        if (!formWindow){
	            Ext.widget('coursesperiodmappingform');
	            formWindow = this.getCoursesperiodmappingform();
	        }
	        formWindow.show();
	    },
	    closeCourseDefaultPeriodMappingWindow: function() {
	        this.getCoursesperiodmappingform().close();
	    },
	    editCourseFormWindow:function(value){
	    	var $this = this;
	    	var prgmCourse= Ext.widget('programcoursesformwindow');
	    	var prgrmCourseForm=prgmCourse.items.items[0];
	    	var button= Ext.ComponentQuery.query('button#programCoursesFormSubmit')[0];
	    	button.setText('Save');
	    	var courseIdField=prgrmCourseForm.getForm().findField('courseId');
	    	var prgmCourseForm=prgmCourse.items.items[0];
	    	var grid = $this.getProgramcoursesgrid();
	    	var records = grid.getSelectionModel().getSelection()[0];
	    	var prmCourseIds = [];
	    	if(!isNullOrEmpty(records.data.periodObj)){
				var periodObjs=records.data.periodObj;
				for(var j in periodObjs){
					if(Ext.isObject(periodObjs[j])){
						if(!isNullOrEmpty(periodObjs[j].parameterizationId)){
							prmCourseIds.push(periodObjs[j].parameterizationId);
						}

					}
				}
			}
	    	if(!isNullOrEmpty(records.data.periodDisplayObj) && records.data.periodDisplayObj.length > 0){
	    		prgmCourseForm.getForm().findField('isOfferedYearly').setReadOnly(true);
	    	} else{
	    		prgmCourseForm.getForm().findField('isOfferedYearly').setReadOnly(false);
	    	}
	    	if(!isNullOrEmpty(prmCourseIds) && prmCourseIds.length > 0){
	    		prgmCourseForm.getForm().findField('whetherOptionalItem').setReadOnly(true);
	    	}else{
	    		prgmCourseForm.getForm().findField('whetherOptionalItem').setReadOnly(false);
	    	}
	    	
	    	var courseIds = [];
	    	if (grid.getSelectionModel().getCount() > 0) {
	    		$this.showProgramCoursesFormWindow();
	    		if(value){
	    			toggleReadOnlyFormItems(prgmCourseForm.getForm(),true);
	    			button.hide();
	    		}
	    		prgmCourseForm.loadRecord(records);
	    		courseIdField.store.load({
	    			params:{
	    				id: records.data.batchId,
	    				editPrgCourse:'true'
	    			},
	    			callback: function(rec, operation, success) {
	    				if (success) {
	    					courseIds.push(records.data.courseId);
	    					courseIdField.setValue(courseIds);
	    					courseIdField.setValue(courseIds);
	    					courseIdField.setReadOnly(true);
	    				}
	    			}
	    		});

	    		if(!records.data.whetherOptional){
	    			Ext.ComponentQuery.query('radiogroup#whetherOptionalItemId')[0].items.items[0].setValue(true);
	    			Ext.ComponentQuery.query('radiogroup#whetherOptionalItemId')[0].items.items[1].setValue(false);
	    		}else if(records.data.whetherOptional){
	    			Ext.ComponentQuery.query('radiogroup#whetherOptionalItemId')[0].items.items[0].setValue(false);
	    			Ext.ComponentQuery.query('radiogroup#whetherOptionalItemId')[0].items.items[1].setValue(true);
	    		}
	    		prgmCourseForm.down('#whetherMajor').setValue(records.data.whetherMajor);
	    		
	    	}else{
	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
	    	}
	    },
	    saveDataProgramCourseForm:function(){
	    	var $this=this;
	    	var grid=$this.getProgramcoursesgrid();
	    	var batchTabStructureForm=$this.getProgrambatchdetailstabstructure().getForm();
	    	var batchId=batchTabStructureForm.findField('batch').getValue();
	    	var prgmCourse=Ext.ComponentQuery.query('form#programCoursesFormItemId')[0];
	    	var form=prgmCourse.getForm();
//	    	var assignSectionType = form.findField('assignSectionType').getValue();
	    	var values=form.getFieldValues();
	    	var courseIds = [];
	    	if(values.courseId !=undefined && values.courseId.length > 0){
	    		for(var i in values.courseId){
	    			if(Ext.isObject(values.courseId[i])){
	    				courseIds.push(values.courseId[i].get("id"));
	    			}else{
	    				courseIds.push(values.courseId[i]);
	    			}
	    		}
	    	}
	    	var submitModel=new Academia.model.program.programDetails.programBatches.programCourse.ProgramCourseModelGrid();
	    	submitModel.set('id',values.id);
	    	submitModel.set('courseIds',courseIds.join());
	    	submitModel.set('batchId',batchId);
	    	submitModel.set('whetherOptional',values.whetherOptional);
	    	submitModel.set('periodObj',null);
	    	submitModel.set('periodDisplayObj',null);
	    	submitModel.set('isOfferedYearly',values.isOfferedYearly);
	    	submitModel.set('whetherMajor',values.whetherMajor)  ///
	    	if(values.whetherOptional){
	    		submitModel.set('enrollmentCriteria', values.enrollmentCriteria);
	    	}
	    	var fData = Ext.encode(submitModel.data);
	    	if(values.id!=null&&values.id>0){
	    		submitUrl = SERVERURL.PROGRAM_BATCH_COURSE_UPDATE_URL;
	    		submitModel.set('version',values.version);
	    	}else{
	    		submitUrl = SERVERURL.PROGRAM_BATCH_COURSE_CREATE_URL;
	    	}
	    	$this.applyWindowMask();
	    	Ext.Ajax.request({
	    		type: 'rest',
	    		url: submitUrl,
	    		jsonData: fData,
	    		method: 'POST',
	    		success: function(response, action) {
	    			if(response.responseText == 'Only 1 course can be added in this program batch'){
	    				$this.hideWindowMask();
	    				showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ONE_COURSE_CAN_ADD')); 
	    			}else if(response.responseText == 'NO_MORE_MANDATORY_COURSES_CAN_BE_MAPPED_TO_BATCH'){
	    				$this.hideWindowMask();
	    				showWarningMessage(getCommonTranslation('ALERT'), 
	    						getProgramandcourseTranslation('NO_MORE_MANDATORY_COURSES_CAN_BE_MAPPED_TO_BATCH')); 
	    			}else if(response.responseText == 'COURSE_WITH_M_CANT_BE_ADDED'){
	    				$this.hideWindowMask();
	    				showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('COURSE_WITH_M_CANT_BE_ADDED_COURSE'));
	    			}else if(response.responseText == 'COURSE_WITH_G_CANT_BE_ADDED'){
	    				$this.hideWindowMask();
	    				showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('COURSE_WITH_G_CANT_BE_ADDED_COURSE'));
	    			}else{
	    				$this.hideWindowMask();
	    				showSuccessMessage(getCommonTranslation('COURSE_INFO_TITLE'), getCommonTranslation('SUCCESS'));
	    				form.reset();
	    				grid.getStore().reload();
	    				var store = $this.getProgramProgramDetailsProgramBatchesRelatedCoursesProgramRelatedCoursesStore();
	            		store.removeAll();
	            		if(batchId!=null){
		            		store.getProxy().extraParams = {
		            			batchId: batchId
		    				};
		    				store.load();
		    			 }
	    				$this.closeProgramCoursesFormCancel();
	    			}
	    			$this.hideWindowMask();
	    		}
	    	});
	    	grid.getSelectionModel().deselectAll();
	    },
	    deleteProgramCourseData:function(){ 
	    	var $this=this;
	    	var grid = $this.getProgramcoursesgrid();
	    	var batchTabStructureForm=$this.getProgrambatchdetailstabstructure().getForm();
	    	var batchId=batchTabStructureForm.findField('batch').getValue();
	    	if (grid.getSelectionModel().getCount() > 0) {
	    		var records = grid.getSelectionModel().getSelection();
	    		var submitModel=[];
	    		var ids = [];
	    		var progCrsPeriodIds = [];
	    		var courseGroupIds = [];
	    		var prmCourseIds = [];
	    		if(records !=undefined && records.length > 0){
	    			for(var i in records){
	    				var courseGroupId = "";
	    				if(Ext.isObject(records[i])){
	    					submitModel.push(records[i].data);
	    					courseGroupId = records[i].data.courseGroupId;
	    					if(!isNullOrEmpty(courseGroupId)){
	    						courseGroupIds.push(courseGroupId);
	    					}
	    					if(!isNullOrEmpty(records[i].data.periodObj)){
	    						var periodObjs=records[i].data.periodObj;
	    						for(var j in periodObjs){
	    							if(Ext.isObject(periodObjs[j])){
	    								if(!isNullOrEmpty(periodObjs[j].parameterizationId)){
	    									prmCourseIds.push(periodObjs[j].parameterizationId);
	    								}

	    							}
	    						}
	    					}
	    				}
	    			}
	    		}
	    		var formData = Ext.encode(submitModel);
	    		/**
	    		 * Can not delete which are added in course specialization
	    		 */
	    		if(!isNullOrEmpty(courseGroupIds) && courseGroupIds.length > 0){
	    			showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('COURSE_GROUP_COURSES'));
	    			return;
	    		}
	    		if(!isNullOrEmpty(prmCourseIds) && prmCourseIds.length > 0){
	    			showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('COURSE_PARAM_DEPENDENY'));
	    			return;
	    		}
	    		showConfirmMessage(getCommonTranslation('COURSE_INFO_TITLE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	    		function(btn, text) {
	    			if (btn == 'yes'){
	    				Ext.Ajax.request({
	    					type: 'rest',
	    					url: SERVERURL.DELETE_PROGRAM_BATCH_COURSE,
	    					method: 'POST',
	    					jsonData: formData,
	    					success: function(f, action) {
	    						if(f.responseText == "SUCCESS"){
	    							showSuccessMessage(getCommonTranslation('COURSE_INFO_TITLE'), getCommonTranslation('SUCCESS'));
	    							grid.getStore().loadPage(1);
	    							var store = $this.getProgramProgramDetailsProgramBatchesRelatedCoursesProgramRelatedCoursesStore();
	    		            		store.removeAll();
	    		            		if(batchId!=null){
	    			            		store.getProxy().extraParams = {
	    			            			batchId: batchId
	    			    				};
	    			    				store.load();
	    			    			 }
	    						}
	    						else if(f.responseText == "COURSE_PARAMETER_SETTINGS_DONE"){
	    							showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('COURSE_PARAM_DEPENDENY'));
	    						}
	    					}
	    				});
	    			}
	    		});
	    	}else{
	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
	    	}
	    },
	    viewProgramCourseData:function(){
	    	var $this=this; 
	       	var grid = $this.getProgramcoursesgrid();
	              Ext.widget('programcoursesformwindow');
	         var formWindow= Ext.ComponentQuery.query('form#programCoursesFormItemId')[0];
	       	 var form=formWindow.getForm();
	       	 if (grid.getSelectionModel().getCount() > 0) {
	       		$this.editCourseFormWindow();
	       		toggleReadOnlyFormItems(form,true);
	       	 var button= Ext.ComponentQuery.query('button#programCoursesFormSubmit')[0];
	       		button.hide();
	       	 } else {
	       		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
	       	 }
	    	
	    },
saveCoursePeriodMapping:function(btn){
            var $this=this;
            btn.setDisabled(true);
            var grid=this.getCourseperiodmappinggrid();
            var store = grid.getStore();
            var flag = true;
            var selectModel = [];
            selectModel = grid.getSelectionModel().getSelection();
            var finalModel=[];
            var batchId = selectModel[0].data.batchId;
			Ext.Array.each(selectModel, function(record) {
			    var periodObject = [];
			    var periodObj = record.get('periodObj') || [];

			    Ext.Array.each(periodObj, function(period) {
			        if (record.get('checkbox' + period.periodId)) {
			            periodObject.push({
			                periodId: period.periodId,
			                checkbox: record.get('checkbox' + period.periodId)
			            });
			        }
			    });
			    
			    if(periodObject.length<1){
					flag =false;
				}
			    
			    var courseMapPeriodModel = {
			        batchId: batchId,
			        periodObj: periodObject,
			        courseId: record.get('courseId'),
			        id: record.get('id'),
			        programId: record.raw.programId
			    };

			    finalModel.push(courseMapPeriodModel);
			});
			
			if(!flag){
				 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
			}
			else{
				Ext.Ajax.request({
	                type: 'rest',
	                timeout: 500000,
	                url: SERVERURL.PATH_CREATE_UPDATE_PROGRAM_COURSE_PERIOD,
	                method: 'POST',
	                jsonData: finalModel,
	                success: function(f, action) {
	                    if(f.responseText == "SUCCESS"){
	                        showSuccessMessage(getCommonTranslation('COURSE_INFO_TITLE'), getCommonTranslation('SUCCESS'));
	                        //grid.getStore().reload();
	                       var store = $this.getStore('program.programDetails.programBatches.programCourse.ProgramCourseStoreGrid');
	                        if(batchId!=null){
	                        	store.getProxy().extraParams = {
	                                batchId: batchId
	                            };
	                            store.load(function(){
	                                btn.setDisabled(false);
	                                $this.closeCoursePeriodMappingWindow();
	                            });
	                         }
	                    }
	                }
	            });
	            
			}
            
            
        },
	    showMappedPeriodWithCourse:function(grid, RowIdx, record){
	    	var docWindow = this.getCoursemappedperiodlist();
	    	if (!docWindow) {
	    		Ext.widget('coursemappedperiodlist');
	    		docWindow = this.getCoursemappedperiodlist();
	    	}
	    	docWindow.show();
	    	var grid = docWindow.down('#coursemappedperiodlistgridItemId');
	    	var store = grid.getStore();
	    	store.loadData(record.data.periodDisplayObj);
	    },
	    showCoursePeriodMappingWindow: function() {       
	    	var $this =this;
	    	var containpanel = $this.getProgrambatchdetailsinnertabpanelstructure();
	    	var tabName = getCommonTranslation('MAP_PERIOD');
	    	var tabDetail = containpanel.items.items;
	    	for(var i in tabDetail){
	    		if(tabDetail[i].title==tabName){
	    			tabDetail[i].close();
	    		}
	    	}
	    	var configfeestructure = Ext.widget('courseperiodmappingtabstructure');
	    	openTab(containpanel, tabName, configfeestructure);
	    },
	    closeCoursePeriodMappingWindow: function() {       
	    	var $this =this;
	    	var containpanel = $this.getProgrambatchdetailsinnertabpanelstructure();
	    	var tabName = getCommonTranslation('MAP_PERIOD');
	    	var tabDetail = containpanel.items.items;
	    	for(var i in tabDetail){
	    		if(tabDetail[i].title==tabName){
	    			tabDetail[i].close();
	    		}
	    	}
	    	var mainGrid = this.getProgramcoursesgrid();
			mainGrid.getSelectionModel().deselectAll();
	    },
	    loadCoursePeriodMappingGrid:function(){
	    	var $this = this;
	    	var grid = contentPanel.getActiveTab().down('programcoursesgrid');
	    	if (grid.getSelectionModel().getCount() > 0) {
	    		var records = grid.getSelectionModel().getSelection();
	    		var courseModel = [];
	    		var periodIds = [];
	    		/*var batchId;
	    		for(var i in records){
	    			batchId = records[i].data.batchId;
	    		}*/

				var mappingGrid = $this.getCourseperiodmappinggrid();
	    		var store = mappingGrid.getStore();
	    		store.loadData(records);
	    		periodIds.push({
					   header: getCommonTranslation('COURSE_CODE_NAME'),
					   dataIndex: 'courseCode',
					   flex:.1,
					   sortable: false,
					   renderer:function(value,record, rec){
						   if(value){
							   return getExaminationTranslation(rec.data.courseCode +"/"+ rec.data.courseName);
						   }else {
							   return rec.data.courseCode +"/"+ rec.data.courseName;
						   }
					   }
				   });
			
				var periodRecords = records[0].data.periodObj;
				var sequencePeriodRecords = [];
				var sortedPeriodRecords = periodRecords.sort(this.dynamicSort("programPeriodSeq"));
				//var sequence = 1;
				var sequence = sortedPeriodRecords[0].programPeriodSeq;
				var programPeriodMaxSequence = sortedPeriodRecords[sortedPeriodRecords.length-1].programPeriodSeq;
				var count=0;
				//while(sequence<=periodRecords.length){
				while(sequence<=programPeriodMaxSequence){
					for(var j in periodRecords){
						if(periodRecords[j].programPeriodSeq == sequence){
							sequencePeriodRecords.push(periodRecords[j]);
							sequence++;
							break;
						}
					}
					count++;
                    if((sortedPeriodRecords.length-1)>=count){
                       sequence=sortedPeriodRecords[count].programPeriodSeq
                    }
                    
				}
				for(var j in sequencePeriodRecords){
					var column = Ext.create('Ext.grid.column.CheckColumn', {
						header:  sequencePeriodRecords[j].periodName,
						dataIndex: 'checkbox'+sequencePeriodRecords[j].periodId,
						sortable: false,
						stopSelection: false, 
						readOnly:true,
						style:{'text-align':'center'},
						flex:.1,
						renderer: function(value, metadata,record) {
							/*if (metadata.recordIndex != 0) {
							metadata.style+= ' opacity:0.3';
							value=false;
							}*/
							/*value=false;
							if(record.data.courseRepeatable!=true){
								if(record.data.courseRepeatable){
									record.set(this.dataIndex, true);
							}else{
									record.set(this.dataIndex, false);
								} 
							}*/
							var cssPrefix = Ext.baseCSSPrefix,
							cls = cssPrefix + 'grid-checkcolumn';
							if (value) {
								cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
							}
							return '<img class="' + cls + '" src="' + Ext.BLANK_IMAGE_URL + '"/>';
						}
					});
					periodIds.push(column) ;
				}
				for (i=0;i<records.length;i++){
					var sequencePeriodRecords = records[i].data.periodObj;
					for(var j in sequencePeriodRecords){
						if(sequencePeriodRecords[j].checkbox){
							records[i].set('checkbox'+sequencePeriodRecords[j].periodId, true);
						}else{
							records[i].set('checkbox'+sequencePeriodRecords[j].periodId, false);
						}
					}
				}
	    		mappingGrid.reconfigure(null,periodIds);
	    		mappingGrid.getView().refresh();
	    	}
	    },
	    dynamicSort: function(property) {
	    var sortOrder = 1;
	    	if (property[0] === "-") {
	    		sortOrder = -1;
	    		property = property.substr(1);
	    	}
	    	return function(a, b) {
	    		/* next line works with strings and numbers,
	    		* and you may want to customize it to your needs
	    		*/
	    		var result = (a[property] < b[property]) ? -1 : (a[property] > b[property]) ? 1 : 0;
	    		return result * sortOrder;
	    			}
	    		},
	    disableExportPdfExcelButtonByPivileges :function(gridReference, permissionsMap){
			var associatedAcadLocationIds = new Array();
			associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
			var exportPdfBtn = gridReference.down('#btnExportToPDF');
			var exportExcelbtn = gridReference.down('#btnExportToExcel');
			var saveButton = gridReference.down('#btnSaveItemId');
			
			 exportPdfBtn.setVisible(false);
			 exportExcelbtn.setVisible(false);
			 saveButton.setVisible(false);

			 Ext.each(permissionList, function(privilege) {
				if (privilege === 'EXPORT') {
					var buttonsArray = new Array();
	        		buttonsArray.push( gridReference.down('#btnExportToPDF'));        		
	        		buttonsArray.push(gridReference.down('#btnExportToExcel'));
	        	    Ext.each(buttonsArray, function(button) {
	        			if(!isNullOrEmpty(button)){
	            			button.setVisible(true);
	            		}  
	        		});
				}else if (privilege === 'SAVE') {
            		if(!isNullOrEmpty(saveButton)){
            			saveButton.setVisible(true);
            		}        		
        		} 
			});
		},
	    saveCourseDefaultPeriod:function(obj,record){
	    	var periodValue = record;
	    	var grid = this.getCourseperiodmappinggrid();
	    	var store = grid.getStore();
	    	var models = [];
	    	models = grid.getSelectionModel().getSelection();
	    	var finalModel=[];
	    	
	    	/*code added for check offered yearly on set default button click*/
	    	for(var rowIndex in models){
	    		var periodObj = models[rowIndex].data.periodObj;
	    		var flag = false;

	    		var isOfferedYearly = models[rowIndex].data.periodObj[0].isOfferedYearly;
	    		var courseRepeatable = models[rowIndex].data.periodObj[0].courseRepeatable;

	    		var periodRes = models[rowIndex].data.periodObj.filter(function (obj) {
	    			  return obj.periodId === periodValue;
	    		});

	    		var periodYearId = periodRes[0].periodYearId;

	    		if(isOfferedYearly == true && !isNullOrEmpty(periodYearId) && courseRepeatable == false){
	    			var flag = false;
	    			for(var i =0; i<models[rowIndex].data.periodObj.length;i++){
	    				var objPeriodYearId = models[rowIndex].data.periodObj[i].periodYearId;
	    				var checked = models[rowIndex].data.periodObj[i].checkbox;
	    				if(periodYearId==objPeriodYearId){
	    					if(checked){
	    						models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true);	
	    					}
	    					else{
	    						if(!isNullOrEmpty(models[rowIndex].data.periodObj[i].parameterizationId)){
	    							models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true); 
	    						}
	    						else{
	    							var result1 = models[rowIndex].data.periodObj.filter(function (obj) {
	    								  return obj.periodYearId === periodYearId;
	    							});
	    							if(result1.length>0){
	    								result1.forEach(function(objRes){
	    									if(!isNullOrEmpty(objRes.parameterizationId)){
	    										flag = true;
	    									}
	    								});
	    								if(flag){
	    									models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true);  
	    								}
	    								else{
	    									if(periodValue == models[rowIndex].data.periodObj[i].periodId){
	    										models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true);  
	    									}else{
	    										models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true);
	    									}
	    								}
	    							}
	    							else{
	    								models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, false);	
	    							}
	    						}
	    					}
	    				}else{
	    					models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, false);
	    				}
	    			}
	    		}
	    		else if(isOfferedYearly == false && courseRepeatable == false){
	    			var flag = false;
	    			var count=0;
	    			for(var i =0; i<models[rowIndex].data.periodObj.length;i++){

	    				var flag = false;
	    				if(models[rowIndex].get('checkbox'+models[rowIndex].data.periodObj[i].periodId) == true){
	    					count = count+1;
	    				}
	    				if(!isNullOrEmpty(models[rowIndex].data.periodObj[i].parameterizationId)){
	    					models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true); 
	    					flag = true;
	    				}else{
	    					models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, false);
	    					if(count>1){
	    						//showWarningMessage(getCommonTranslation('MAP_PERIOD'),getCommonTranslation('NOT_REPEATABLE_COURSE_PERIOD_MESSAGE'));
	    					}
	    				}
	    				if(!flag){
	    					if(periodValue == models[rowIndex].data.periodObj[i].periodId){
	    						models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true);  
	    					}else{
	    						models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, false);
	    					}
	    				}
	    			}
	    		}
	    		else if(isOfferedYearly == false && courseRepeatable == true){
	    			for(var i =0; i<models[rowIndex].data.periodObj.length;i++){
	    				if(!isNullOrEmpty(models[rowIndex].data.periodObj[i].parameterizationId)){
	    					models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true); 
	    				}
	    				else{
	    					var checked = models[rowIndex].data.periodObj[i].checkbox;
	    					if(!checked){
	    						if(periodValue == models[rowIndex].data.periodObj[i].periodId){
	    							models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true);  
	    						}
	    					}
	    				}
	    			}  
	    		}
	    		else if(isOfferedYearly == true && !isNullOrEmpty(periodYearId) && courseRepeatable == true){
	    			var flag = false;
	    			for(var i =0; i<models[rowIndex].data.periodObj.length;i++){

	    				var objPeriodYearId = models[rowIndex].data.periodObj[i].periodYearId;
	    				var checked = models[rowIndex].data.periodObj[i].checkbox;
	    				if(periodYearId==objPeriodYearId){
	    					if(checked){
	    						models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true);	
	    					}
	    					else{
	    						if(!isNullOrEmpty(models[rowIndex].data.periodObj[i].parameterizationId)){
	    							models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true); 
	    						}
	    						else{
	    							var result1 = models[rowIndex].data.periodObj.filter(function (obj) {
	    								  return obj.periodYearId === periodYearId;
	    							});
	    							if(result1.length>0){
	    								result1.forEach(function(objRes){
	    									if(!isNullOrEmpty(objRes.parameterizationId)){
	    										flag = true;
	    									}
	    								});
	    								if(flag){
	    									models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true);  
	    								}
	    								else{
	    									if(periodValue == models[rowIndex].data.periodObj[i].periodId){
	    										models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true);  
	    									}else{
	    										models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, true);
	    									}
	    								}
	    							}
	    							else{
	    								models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, false);	
	    							}
	    						}
	    					}
	    				}else{
	    					//models[rowIndex].set('checkbox'+models[rowIndex].data.periodObj[i].periodId, false);
	    				}

	    			}
	    		}
	    	}

	    	/*for(var i in selectModel){
	    		var periodObj = selectModel[i].data.periodObj;
	    		var flag = false;
	    		for(var j in periodObj){
	    			if(selectModel[i].data.courseRepeatable!=true){
	    				if(!isNullOrEmpty(selectModel[i].data.periodObj[j].parameterizationId)){
	    					selectModel[i].set('checkbox'+periodObj[j].periodId, true); 
	    					flag = true;
	    				}else{
	    					selectModel[i].set('checkbox'+periodObj[j].periodId, false);
	    				}
	    				if(!flag){

	    					if(periodObj[j].periodId == periodValue){
	    						selectModel[i].set('checkbox'+periodObj[j].periodId, true);
	    					}else{
	    						selectModel[i].set('checkbox'+periodObj[j].periodId, false);
	    					}
	    				}
	    			}else{

	    				if(!flag){
	    					if(periodObj[j].periodId == periodValue){
	    						selectModel[i].set('checkbox'+periodObj[j].periodId, true);
	    					}else if(!isNullOrEmpty(selectModel[i].data.periodObj[j].parameterizationId)){
		    					selectModel[i].set('checkbox'+periodObj[j].periodId, true); 
		    				}else{
	    						selectModel[i].set('checkbox'+periodObj[j].periodId, false);
	    					}
	    				}
	    			}	
	    		}
   		}*/
	    	grid.getView().refresh();
	    	this.closeCourseDefaultPeriodMappingWindow();	
	    }
});