/**
 * @author Seshagiri.k
 */
Ext.define('Academia.controller.program.customReports.CustomReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['program.customReports.CustomReportTabStore'],
	views: ['program.customReports.CustomReportStructure',
		'program.customReports.CustomReportTreePanelAndGrid',
		'program.customReports.FacultyReportListStructure',
		'program.customReports.SectionReportListStructure',
		'program.customReports.CourseReportListStructure',
		'program.customReports.DepartmentReportListStructure',
		'program.customReports.ProgramReportListStructure'],
		config: {
			FACULTY_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_DETAIL_PRIVILIGES'),
			COURSE_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_DETAIL_PRIVILIGES'),
			DEPARTMENT_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DEPARTMENT_DETAIL_PRIVILIGES'),
			SECTION_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SECTION_DETAIL_PRIVILIGES'),
			PROGRAM_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROGRAM_DETAIL_PRIVILIGES')
		},
		refs: [{
			ref: 'customreportstructure',
			selector: 'customreportstructure'
		},{
			ref: 'customreporttreepanelandgrid',
			selector: 'customreporttreepanelandgrid'
		},{
			ref: 'searchresultgrid',
			selector: 'facultyreportliststructure searchresultgrid[itemId=facultyreportgrid]'
		},{
			ref: 'searchresultgrid',
			selector: 'departmentreportliststructure searchresultgrid[itemId=departmentreportgrid]'
		},{
			ref: 'searchresultgrid',
			selector: 'coursereportliststructure searchresultgrid[itemId=coursereportgrid]'
		},{
			ref: 'searchresultgrid',
			selector: 'sectionreportliststructure searchresultgrid[itemId=sectionreportgrid]'
		},{
			ref: 'searchresultgrid',
			selector: 'programreportliststructure searchresultgrid[itemId=programreportgrid]'
		}],

		init: function() {
			this.control({
				'customreportstructure':{
					afterrender : function(structure){
						var $this = this;
						var customreporttreepanelandgrid = structure.down('#customreporttreepanelandgridId');
						structure.body.on('scroll', function(e, target) {
							var activeTab = structure.down('#tabpanelIds').getActiveTab();
							if(!isNullOrEmpty(activeTab)){
								var baseStructure = activeTab;
								var grid = activeTab.down('searchresultgrid');
								if(grid != undefined){
									$this.getMultipleCBGridHeaderFreezeForPaginationFix(grid,structure,true);
								}else{
									grid = activeTab.down('grid');
									$this.getMultipleGridHeaderFreeze(grid,structure,true); 
								}
							}
						});
					} 
				},
				'customreporttreepanelandgrid panel[itemId=customReportLinkItemId] treepanel[itemId=customReportTreePanelItemId]' : {
					render:function(obj){
						var $this = this;
						var reportParantNode = $this.getCustomreporttreepanelandgrid().down('treepanel').getStore().tree.root;
						$this.applyPermissionOnNodes(reportParantNode);
					},
					itemclick : this.getOpenProgramReportStructure
				},
				'facultyreportliststructure searchresultgrid[itemId=facultyreportgrid]': {
					afterrender: function(grid) {
						this.gridRenderFunction(grid);
						this.genericCBGridAccessControlValidation(grid, this.getFACULTY_DETAIL_PERMISSIONS());
						this.getDynamicProgramReportGrid(grid,CONSTANTS.CB.PR_FACULTY_DETAIL_REPORT_VIEWCODE,
								CONSTANTS.CB.PR_FACULTY_DETAIL_REPORT_CONFIGCODE, getCommonTranslation('FACULTY_LIST'));
					}
				},
				'departmentreportliststructure searchresultgrid[itemId=departmentreportgrid]': {
					afterrender: function(grid) {
						this.gridRenderFunction(grid);
						this.genericCBGridAccessControlValidation(grid, this.getDEPARTMENT_DETAIL_PERMISSIONS());
						this.getDynamicProgramReportGrid(grid,CONSTANTS.CB.PR_DEPARTMENT_DETAIL_REPORT_VIEWCODE,
								CONSTANTS.CB.PR_DEPARTMENT_DETAIL_REPORT_CONFIGCODE, getCommonTranslation('DEPARTMENT_LIST'));
					}
				},
				'coursereportliststructure searchresultgrid[itemId=coursereportgrid]': {
					afterrender: function(grid) {
						this.gridRenderFunction(grid);
						this.genericCBGridAccessControlValidation(grid, this.getCOURSE_DETAIL_PERMISSIONS());
						this.getDynamicProgramReportGrid(grid,CONSTANTS.CB.PR_COURSE_DETAIL_REPORT_VIEWCODE,
								CONSTANTS.CB.PR_COURSE_DETAIL_REPORT_CONFIGCODE, getCommonTranslation('COURSE_LIST'));
					}
				},
				'sectionreportliststructure searchresultgrid[itemId=sectionreportgrid]': {
					afterrender: function(grid) {
						this.gridRenderFunction(grid);
						this.genericCBGridAccessControlValidation(grid, this.getSECTION_DETAIL_PERMISSIONS());
						this.getDynamicProgramReportGrid(grid,CONSTANTS.CB.PR_SECTION_DETAIL_REPORT_VIEWCODE,
								CONSTANTS.CB.PR_SECTION_DETAIL_REPORT_CONFIGCODE, getCommonTranslation('SECTION_LIST'));
					}
				},
				'programreportliststructure searchresultgrid[itemId=programreportgrid]': {
					afterrender: function(grid) {
						this.gridRenderFunction(grid);
						this.genericCBGridAccessControlValidation(grid, this.getSECTION_DETAIL_PERMISSIONS());
						this.getDynamicProgramReportGrid(grid,CONSTANTS.CB.PR_PROGRAM_DETAIL_REPORT_VIEWCODE,
								CONSTANTS.CB.PR_PROGRAM_DETAIL_REPORT_CONFIGCODE, getCommonTranslation('PROGRAM_LIST'));
					}
				},
				//***1**************Export For Report**********************************************************************
				'programreportliststructure [itemId=programreportgrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,'programreportgrid',CONSTANTS.CB.PR_PROGRAM_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('PROGRAM_LIST'));
					}
				},
				'programreportliststructure [itemId=programreportgrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,'programreportgrid',CONSTANTS.CB.PR_PROGRAM_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('PROGRAM_LIST'));
					}
				},
				'programreportliststructure [itemId=programreportgrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,'programreportgrid',CONSTANTS.CB.PR_PROGRAM_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('PROGRAM_LIST'));
					}
				},
				'programreportliststructure [itemId=programreportgrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,'programreportgrid',CONSTANTS.CB.PR_PROGRAM_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('PROGRAM_LIST'));
					}
				},
				//***2*************************************************************************************************** 
				'sectionreportliststructure [itemId=sectionreportgrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,'sectionreportgrid',CONSTANTS.CB.PR_SECTION_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('SECTION_LIST'));
					}
				},
				'sectionreportliststructure [itemId=sectionreportgrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,'sectionreportgrid',CONSTANTS.CB.PR_SECTION_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('SECTION_LIST'));
					}
				},
				'sectionreportliststructure [itemId=sectionreportgrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,'sectionreportgrid',CONSTANTS.CB.PR_SECTION_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('SECTION_LIST'));
					}
				},
				'sectionreportliststructure [itemId=sectionreportgrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,'sectionreportgrid',CONSTANTS.CB.PR_SECTION_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('SECTION_LIST'));
					}
				},
				//****3**********************************************************************************************************
				'coursereportliststructure [itemId=coursereportgrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,'coursereportgrid',CONSTANTS.CB.PR_COURSE_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('COURSE_LIST'));
					}
				},
				'coursereportliststructure [itemId=coursereportgrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,'coursereportgrid',CONSTANTS.CB.PR_COURSE_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('COURSE_LIST'));
					}
				},
				'coursereportliststructure [itemId=coursereportgrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,'coursereportgrid',CONSTANTS.CB.PR_COURSE_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('COURSE_LIST'));
					}
				},
				'coursereportliststructure [itemId=coursereportgrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,'coursereportgrid',CONSTANTS.CB.PR_COURSE_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('COURSE_LIST'));
					}
				},
				//***4**********************************************************************************************************  
				'departmentreportliststructure [itemId=departmentreportgrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,'departmentreportgrid',CONSTANTS.CB.PR_DEPARTMENT_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('DEPARTMENT_LIST'));
					}
				},
				'departmentreportliststructure [itemId=departmentreportgrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,'departmentreportgrid',CONSTANTS.CB.PR_DEPARTMENT_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('DEPARTMENT_LIST'));
					}
				},
				'departmentreportliststructure [itemId=departmentreportgrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,'departmentreportgrid',CONSTANTS.CB.PR_DEPARTMENT_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('DEPARTMENT_LIST'));
					}
				},
				'departmentreportliststructure [itemId=departmentreportgrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,'departmentreportgrid',CONSTANTS.CB.PR_DEPARTMENT_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('DEPARTMENT_LIST'));
					}
				},
				//**5***********************************************************************************************************  
				'facultyreportliststructure [itemId=facultyreportgrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,'facultyreportgrid',CONSTANTS.CB.PR_FACULTY_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('FACULTY_REPORT'));
					}
				},
				'facultyreportliststructure [itemId=facultyreportgrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,'facultyreportgrid',CONSTANTS.CB.PR_FACULTY_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('FACULTY_REPORT'));
					}
				},
				'facultyreportliststructure [itemId=facultyreportgrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,'facultyreportgrid',CONSTANTS.CB.PR_FACULTY_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('FACULTY_REPORT'));
					}
				},
				'facultyreportliststructure [itemId=facultyreportgrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
					click: function(obj) {
						var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
						this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,'facultyreportgrid',CONSTANTS.CB.PR_FACULTY_DETAIL_REPORT_CONFIGCODE,getCommonTranslation('FACULTY_REPORT'));
					}
				},
			});
		},

		/************************ START: Common functions for dynamic grid links  ****************************************/
		getDynamicProgramReportGrid : function(grid,respectiveLinkViewCode, respectiveLinkConfigCode, tabName,model, records) {
			grid.setTitle(tabName);
			var jsonFormatFormData = this.createJsonFormat(respectiveLinkConfigCode);

			var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;

			resultViewUrl = resultViewUrl.concat(respectiveLinkViewCode);
			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

			grid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
			Ext.getBody().unmask();
		},
		createJsonFormat: function(respectiveLinkConfigCode) {
			var values = new Object();
			var searchcriteria = new Array();
			values.configCode = respectiveLinkConfigCode;
			values.searchCriterias = searchcriteria;
			return values;
		},
		gridRenderFunction:function(grid){
			grid.addButtonToolbar();
		},
		/************************ END: Common functions for dynamic grid links  ****************************************/
		//**********************************Export Functionality********************************************************
		exportUserList : function(exportUrl,filetype,whetherAll,maingrid,grid,configcode,title) {
			var quickSearchForm = null;
			var searchResultGrid = null;
			var pagingtoolbaroptions = null; 
			var searchCriteriaString = null;
			var jsonFormatFormData = null;

			searchResultGrid = maingrid;
			pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
			jsonFormatFormData=this.createJsonFormat(configcode);


			var visibleColumns=this.getVisibleColumns(searchResultGrid);
			var reportTitle=getCommonTranslation(title);
			if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
				jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
			}
			searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,null,visibleColumns,reportTitle);
		}, 
		//**************************************End*********************************************************************  
		createSearchCriteriaString: function(searchForm) {
//			var me=this;
			var formValues = new Array();
			formValues = searchForm.getValues();        
			var searchCriteriaString="";
			for (var key in formValues) {
				var value = formValues[key];            
				if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
					//  var keyValueJsonObject = me.getJsonObject( key , value);
					//searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
				}
			}
			searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
			return searchCriteriaString;
		},
		getOpenProgramReportStructure : function(treePanel, record, item,index, e, eOpts){
			var $this = this;
			var containpanel = $this.getCustomreporttreepanelandgrid();
			var treePanel = containpanel.down('#customReportTreePanelItemId');
			var tabDetail = record.data;
			var structure = Ext.widget(tabDetail.reportXtype);
			var tabstructure = containpanel.down('#tabpanelIds');

			if (!isNullOrEmpty(tabDetail.text)
					&& !isNullOrEmpty(tabDetail.reportXtype)
					&& !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
				treePanel.toggleCollapse();
				openTab(tabstructure, tabDetail.text,structure);
				treePanel.getSelectionModel().deselectAll();
			}
		},
		applyPermissionOnNodes:function(reportParantNode){
			if(reportParantNode.hasChildNodes()) {
				reportParantNode.removeAll();
			}
			var $this = this;
			var associatedAcadLocationIds = new Array();
			associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
					associatedAcadLocationIds, $this.getSECTION_DETAIL_PERMISSIONS());
			Ext.each(permissionList, function(privilege) {
				if (privilege === 'LINK') {
					reportParantNode.appendChild({
						text: getCommonTranslation('SECTION_LIST'),
						reportXtype: 'sectionreportliststructure',
						reportXtypeItemId: 'sectionreportliststructure',
						leaf: true
					});
				}
			});
			permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
					associatedAcadLocationIds, $this.getCOURSE_DETAIL_PERMISSIONS());
			Ext.each(permissionList, function(privilege) {
				if (privilege === 'LINK') {
					reportParantNode.appendChild({
						text: getCommonTranslation('COURSE_LIST'),
						reportXtype: 'coursereportliststructure',
						reportXtypeItemId: 'coursereportliststructure',
						leaf: true
					});
				}
			});
			permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
					associatedAcadLocationIds, $this.getDEPARTMENT_DETAIL_PERMISSIONS());
			Ext.each(permissionList, function(privilege) {
				if (privilege === 'LINK') {
					reportParantNode.appendChild({
						text: getCommonTranslation('DEPARTMENT_LIST'),
						reportXtype: 'departmentreportliststructure',
						reportXtypeItemId: 'departmentreportliststructure',
						leaf: true
					});
				}
			});
			permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
					associatedAcadLocationIds, $this.getFACULTY_DETAIL_PERMISSIONS());
			Ext.each(permissionList, function(privilege) {
				if (privilege === 'LINK') {
					reportParantNode.appendChild({
						text: getCommonTranslation('FACULTY_LIST'),
						reportXtype: 'facultyreportliststructure',
						reportXtypeItemId: 'facultyreportliststructure',
						leaf: true
					});
				}
			});
			permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
					associatedAcadLocationIds, $this.getPROGRAM_DETAIL_PERMISSIONS());
			Ext.each(permissionList, function(privilege) {
				if (privilege === 'LINK') {
					reportParantNode.appendChild({
						text: getCommonTranslation('PROGRAM_LIST'),
						reportXtype: 'programreportliststructure',
						reportXtypeItemId: 'programreportliststructure',
						leaf: true
					});
				}
			});
		}
});